<?php

/**
 * Relación entre el almacén y la forma de pago.
 */
class AsignacionAlmacenPago {
    public $forma_pago, $id_group, $id_warehouse;
    
    /**
     * 
     * @param string $forma_pago
     * @param int $id_group
     * @param int $id_warehouse
     */
    public function __construct($forma_pago, $id_group, $id_warehouse) {
        $this->forma_pago = $forma_pago;
        $this->id_group = $id_group;
        $this->id_warehouse = $id_warehouse;
    }
    
    /**
     * Devuelve la asignacion correspondiente o null.
     * @param string $forma_pago
     * @param int[] $grupos
     * @return AsignacionAlmacenPago
     */
    public static function cargar($forma_pago, $grupos) {
        $instancia = null;
        
        $forma_pago = pSQL($forma_pago);
        $idsGrupo = implode(',', array_map('intval', $grupos));
        if($idsGrupo) {
            $datos = Db::getInstance()->getRow('SELECT * FROM `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."asignacionAlmacenPago` 
                WHERE forma_pago = '$forma_pago' AND (id_group IN ($idsGrupo) OR id_group = 0) ORDER BY id_group DESC");
            if($datos) {
                $instancia = new AsignacionAlmacenPago($datos['forma_pago'], $datos['id_group'], $datos['id_warehouse']);
            }
        }
        
        return $instancia;
    }
    
    /**
     * Devuelve los datos de todas las asignaciones.
     * @return array
     */
    public static function cargarTodas() {
        return Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."asignacionAlmacenPago`");
    }
    
    /**
     * Elimina todas las asignaciones actuales.
     * @return boolean
     */
    public static function eliminarTodas() {
        return Db::getInstance()->execute('TRUNCATE `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo.'asignacionAlmacenPago`');
    }
    
    /**
     * Graba la relación.
     * @return boolean
     */
    public function grabar() {
        $forma_pago = pSQL($this->forma_pago);
        $id_group = (int)$this->id_group;
        $id_warehouse = (int)$this->id_warehouse;
        return Db::getInstance()->execute('REPLACE INTO `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."asignacionAlmacenPago` 
            (forma_pago, id_group, id_warehouse) VALUES ('$forma_pago', '$id_group', '$id_warehouse')");
    }
    
    /**
     * Elimina la relación.
     * @return boolean
     */
    public function eliminar() {
        $forma_pago = pSQL($this->forma_pago);
        $id_group = (int)$this->id_group;
        return Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."asignacionAlmacenPago` 
            WHERE forma_pago = '$forma_pago' AND id_group = $id_group");
    }
    
    /**
     * Obtiene las asignaciones de un cliente
     * 
     * @param Customer $customer
     * @return array
     */
    public static function cargarPorCliente($customer){
        if(Validate::isLoadedObject($customer)) {
            $grupos = $customer->getGroups();
        }
        else {
            $grupos = [Configuration::getGlobalValue('PS_GUEST_GROUP')];
        }
        $asignaciones = self::cargarTodas();
        $asignacionesCliente = [];
        foreach ($asignaciones as $asignacion) {
            if((in_array($asignacion['id_group'], $grupos) || !$asignacion['id_group'])){
                $asignacionesCliente[] = $asignacion;
            }
        }
        
        return $asignacionesCliente;
    }
}
