<?php

class AlmacenesVirtuales
{
    /**
     * Devuelve los almacenes de stock virtual en los que está (o debería estar) el producto.
     * @param int $id_product
     * @param int $id_product_attribute
     * @return \AlmacenStockVirtual[]
     */
    public function cargarPorProducto($id_product, $id_product_attribute = 0) {
        $almacenes = [];
        
        $id_product = (int)$id_product;
        $id_product_attribute = (int)$id_product_attribute;
        //Producto en almacenes virtuales
        $ids_warehouse = array_column(Db::getInstance()->executeS('
            SELECT distinct asv.id_warehouse FROM `'._DB_PREFIX_.'stock` s
                INNER JOIN `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."almacenStockVirtual` asv 
                    ON s.id_warehouse = asv.id_warehouse
            WHERE id_product = $id_product AND id_product_attribute = $id_product_attribute"), 'id_warehouse');
        //Producto en almacenes relacionados con virtuales
        $ids_warehouse = array_merge($ids_warehouse, array_column(Db::getInstance()->executeS('
            SELECT distinct asv.id_warehouse FROM `'._DB_PREFIX_.'stock` s
                INNER JOIN `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."almacenStockVirtual` asv 
                    ON s.id_warehouse = asv.id_warehouse_origen
            WHERE id_product = $id_product AND id_product_attribute = $id_product_attribute"), 'id_warehouse'));
        foreach(array_unique($ids_warehouse) as $id_warehouse) {
            $almacenes[] = new AlmacenStockVirtual($id_warehouse);
        }
        
        return $almacenes;
    }
    
    /**
     * Almacena todas las relaciones de los almacenes desde cero.
     * @param array $relaciones id_warehouse => [ids_warehouse]
     */
    public function grabarRelaciones($relaciones) {
        Db::getInstance()->execute('TRUNCATE TABLE `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo.'almacenStockVirtual`');
        foreach($relaciones as $id_warehouse => $almacenesOrigen) {
            $id_warehouse = (int)$id_warehouse;
            foreach($almacenesOrigen as $almacenOrigen) {
                $id_warehouse_origen = (int)$almacenOrigen;
                Db::getInstance()->execute('INSERT IGNORE INTO `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."almacenStockVirtual` 
                    (id_warehouse, id_warehouse_origen) VALUES ('$id_warehouse', '$id_warehouse_origen')");
            }
        }
    }
    
    /**
     * Devuelve las relaciones de los almacenes.
     * @return array id_warehouse => [ids_warehouse]
     */
    public function cargarRelaciones() {
        $relacionesAgrupadas = [];
        $relaciones = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo.'almacenStockVirtual`');
        foreach($relaciones as $relacion) {
            if(empty($relacionesAgrupadas[$relacion['id_warehouse']])) {
                $relacionesAgrupadas[$relacion['id_warehouse']] = [];
            }
            $relacionesAgrupadas[$relacion['id_warehouse']][] = $relacion['id_warehouse_origen'];
        }
        
        return $relacionesAgrupadas;
    }
}
