<?php

/**
 * Clase para actualizar 
 */
class AlmacenStockVirtual {//TODO: La parte sin el módulo de gestavdstock no está completa.
    private $id_warehouse, $gestavdstock, $almacenesVirtuales;
    
    /**
     * 
     * @param int $id_warehouse
     */
    public function __construct($id_warehouse) {
        $this->id_warehouse = (int)$id_warehouse;
        $this->gestavdstock = new GestAvdStockClass();
        $this->almacenesVirtuales = new AlmacenesVirtuales();
    }
    
    /**
     * Anota movimientos y modifica el stock de los almacenes virtuales relacionados.
     * @param int $mvt_physical Debe ser siempre positivo.
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $id_warehouse_origen
     * @param int $id_warehouse_destino
     */
    public static function movimientoStockVirtual($mvt_physical, $id_product, $id_product_attribute = 0, 
            $id_warehouse_origen = null, $id_warehouse_destino = null) {
        if($id_warehouse_origen || $id_warehouse_destino) {
            //Obtenemos los almacenes virtuales afectados según el tipo de afectación
            $virtualesMovimiento = [];
            $virtualesDestino = [];
            $virtualesOrigen = [];
            $relaciones = (new AlmacenesVirtuales())->cargarRelaciones();
            foreach($relaciones as $id_warehouse_virtual => $relacion) {
                $esOrigen = $id_warehouse_origen && in_array($id_warehouse_origen, $relacion);
                $esDestino = $id_warehouse_destino && in_array($id_warehouse_destino, $relacion);
                if($esOrigen && $esDestino) {
                    //Si contiene ambos es un movimiento
                    $virtualesMovimiento[] = $id_warehouse_virtual;
                }
                elseif($esOrigen) {
                    $virtualesOrigen[] = $id_warehouse_virtual;
                }
                elseif($esDestino) {
                    $virtualesDestino[] = $id_warehouse_virtual;
                }
            }
            
            //Realizamos los cambios
            foreach($virtualesMovimiento as $virtualMovimiento) {
                $almacenVirtual = new AlmacenStockVirtual($virtualMovimiento);
                $almacenVirtual->ajustarStockAlmacen($id_product, $id_product_attribute, 0, 0, 'Reubicación');
            }
            foreach($virtualesDestino as $virtualDestino) {
                $almacenVirtual = new AlmacenStockVirtual($virtualDestino);
                $almacenVirtual->ajustarStockAlmacen($id_product, $id_product_attribute, $mvt_physical, 0, 'Entrada');
            }
            foreach($virtualesOrigen as $virtualOrigen) {
                $almacenVirtual = new AlmacenStockVirtual($virtualOrigen);
                $almacenVirtual->ajustarStockAlmacen($id_product, $id_product_attribute, -$mvt_physical, 0, 'Salida');
            }
        }
    }
    
    /**
     * Actualiza el stock del producto indicado.
     * @param int $id_product
     * @param int $id_product_attribute
     * @return boolean
     */
    public function actualizarStock($id_product, $id_product_attribute = 0) {
        $id_product = (int)$id_product;
        $id_product_attribute = (int)$id_product_attribute;
        $id_warehouse = (int)$this->id_warehouse;
        
        //Compatibilidad con el módulo gestavdstock
        if(Module::isEnabled('gestavdstock')) {
            $stockFisico = 0;
            $stockReservado = 0;
            
            $almacenesRelacionados = $this->almacenesVirtuales->cargarRelaciones();
            if($almacenesRelacionados[$id_warehouse]) {
                foreach($almacenesRelacionados[$id_warehouse] as $id_warehouse_origen) {
                    //Cargamos el último movimiento de cada almacén relacionado
                    $ultimoMovimiento = $this->gestavdstock->obtenerUltimoMovimiento($id_product, $id_product_attribute, $id_warehouse_origen);
                    if($ultimoMovimiento) {
                        $stockFisico += $ultimoMovimiento['stock_quantity'];
                    }
                }
                //Obtenemos el último movimiento del almacén virtual
                $ultimoMovimiento = $this->gestavdstock->obtenerUltimoMovimiento($id_product, $id_product_attribute, $id_warehouse);
                if($ultimoMovimiento) {
                    $mvt_physical = $stockFisico - $ultimoMovimiento['physical_quantity'];
                    $stockReservado = $ultimoMovimiento['reserved_quantity'];
                }
                else {
                    $mvt_physical = $stockFisico;
                    $stockReservado = 0;
                }
                //Agregamos un movimiento
                if($mvt_physical) {
                    //El stock físico del almacén virtual es la suma de los stocks disponibles de sus componentes y el stock disponible 
                    //del virtual es la diferencia del físico del virtual y su reservado.
                    $this->gestavdstock->insertarMovimiento($id_product, $id_product_attribute, $id_warehouse, $stockReservado, 
                            $stockFisico, 0, $mvt_physical);
                }
            }
        }
        else {
            $stockFisico = (int)Db::getInstance()->getValue('
                SELECT SUM(usable_quantity) quantity FROM `'._DB_PREFIX_.'stock` s
                    INNER JOIN `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."almacenStockVirtual` asv 
                        ON s.id_warehouse = asv.id_warehouse_origen AND asv.id_warehouse = $id_warehouse
                WHERE id_product = $id_product AND id_product_attribute = $id_product_attribute 
                GROUP BY id_product, id_product_attribute");

            $estadoError = (int)Configuration::getGlobalValue('PS_OS_ERROR');
            $estadoCancelado = (int)Configuration::getGlobalValue('PS_OS_CANCELED');
            $stockReservado = (int)Db::getInstance()->getValue('
                SELECT SUM(od.product_quantity - od.product_quantity_refunded) FROM `'._DB_PREFIX_.'orders` o
                    INNER JOIN `'._DB_PREFIX_.'order_detail` od ON od.id_order = o.id_order
                    INNER JOIN `'._DB_PREFIX_."order_state` os ON os.id_order_state = o.current_state
                WHERE os.shipped != 1 AND (o.valid = 1 OR (os.id_order_state != $estadoError AND os.id_order_state != $estadoCancelado)) 
                    AND od.product_id = $id_product AND od.product_attribute_id = $id_product_attribute
                GROUP BY od.product_id, od.product_attribute_id");
        }

        return self::ajustarStock($id_product, $id_product_attribute, $id_warehouse, $stockFisico, $stockFisico - $stockReservado);
    }
    
    /**
     * Cambia el stock.
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $id_warehouse
     * @param int $stockFisico
     * @param int $usable_quantity
     * @return bool
     */
    private static function ajustarStock($id_product, $id_product_attribute, $id_warehouse, $stockFisico, $usable_quantity) {
        $stockObj = new Stock(StockAvailable::getWarehouseStockAvailableIdByProductId($id_product, $id_product_attribute, $id_warehouse));
        if(!Validate::isLoadedObject($stockObj)) {
            $stockObj->id_product = $id_product;
            $stockObj->id_product_attribute = $id_product_attribute;
            $stockObj->id_warehouse = $id_warehouse;
            $stockObj->price_te = 0;
        }
        $stockObj->physical_quantity = ($stockFisico > 0 ? $stockFisico : 0);
        $stockObj->usable_quantity = ($usable_quantity > 0 ? $usable_quantity : 0);
        return $stockObj->save();
    }

    /**
     * Revierte los movimientos de un pedido y producto.
     * @param int $id_order
     * @param int $id_product
     * @param int $id_product_attribute
     */
    public function deshacerUltimoMovimientoPedido($id_order, $id_product, $id_product_attribute = 0) {
        $almacenesRelacionados = $this->almacenesVirtuales->cargarRelaciones();
        if($almacenesRelacionados[$this->id_warehouse]) {
            $mvt_physical_virtual = 0;
            $mvt_reserved_virtual = 0;
            foreach($almacenesRelacionados[$this->id_warehouse] as $id_warehouse_origen) {
                //Cargamos el último movimiento de cada almacén relacionado para el pedido
                $ultimoMovimientoPedido = $this->gestavdstock->obtenerUltimoMovimiento($id_product, $id_product_attribute, $id_warehouse_origen, 
                        $id_order);
                if($ultimoMovimientoPedido) {
                    //Obtenemos el último movimiento del almacén relacionado
                    $ultimoMovimiento = $this->gestavdstock->obtenerUltimoMovimiento($id_product, $id_product_attribute, $id_warehouse_origen);
                    $mvt_physical = -$ultimoMovimientoPedido['mvt_physical'];
                    $mvt_reserved = -$ultimoMovimientoPedido['mvt_reserved'];
                    $stockReservado = $ultimoMovimiento['reserved_quantity'] + $mvt_reserved;
                    $stockFisico = $ultimoMovimiento['physical_quantity'] + $mvt_physical;
                    //Deshacemos el cambio
                    $this->gestavdstock->insertarMovimiento($id_product, $id_product_attribute, $id_warehouse_origen, $stockReservado, 
                        $stockFisico, $mvt_reserved, $mvt_physical, 'Pedido cancelado', $id_order);
                    self::ajustarStock($id_product, $id_product_attribute, $id_warehouse_origen, $stockFisico, $stockFisico - $stockReservado);
                    
                    $mvt_physical_virtual += $mvt_physical;
                    $mvt_reserved_virtual += $mvt_reserved;
                }
            }
            
            //Actualizamos el virtual
            $this->ajustarStockAlmacen($id_product, $id_product_attribute, $mvt_physical_virtual, $mvt_reserved_virtual, 'Pedido cancelado', 
                    $id_order);
        }
    }
    
    /**
     * Anota un movimiento en el almacén virtual y cambia su stock.
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $mvt_physical
     * @param int $mvt_reserved
     * @param string $reason_presta
     * @param int $id_order
     */
    private function ajustarStockAlmacen($id_product, $id_product_attribute, $mvt_physical, $mvt_reserved, $reason_presta, $id_order = 0) {
        $ultimoMovimiento = $this->gestavdstock->obtenerUltimoMovimiento($id_product, $id_product_attribute, $this->id_warehouse);
        if($ultimoMovimiento) {
            $stockReservado = $ultimoMovimiento['reserved_quantity'] + $mvt_reserved;
            $stockFisico = $ultimoMovimiento['physical_quantity'] + $mvt_physical;
        }
        else {
            $stockReservado = ($mvt_reserved > 0 ? $mvt_reserved : 0);
            $stockFisico = ($mvt_physical > 0 ? $mvt_physical : 0);
        }

        $this->gestavdstock->insertarMovimiento($id_product, $id_product_attribute, $this->id_warehouse, $stockReservado, 
                $stockFisico, $mvt_reserved, $mvt_physical, $reason_presta, $id_order);
        self::ajustarStock($id_product, $id_product_attribute, $this->id_warehouse, $stockFisico, $stockFisico - $stockReservado);
    }
    
    /**
     * Crea un movimiento para el pedido en su almacén virtual.
     * @param int $mvt_physical Debe ser siempre positivo.
     * @param int $id_order
     * @param int $id_product
     * @param int $id_product_attribute
     */
    public static function ajustarStockPedido($mvt_physical, $id_order, $id_product, $id_product_attribute = 0) {
        $id_warehouse = false;
        //Buscamos el almacén de la línea de pedido
        $pedido = new Order($id_order);
        foreach($pedido->getProducts() as $producto) {
            if($producto['product_id'] == $id_product && $producto['product_attribute_id'] == $id_product_attribute) {
                $id_warehouse = $producto['id_warehouse'];
                break;
            }
        }
        if($id_warehouse) {
            //Comprobamos que sea virtual
            $almacenesVirtuales = array_keys((new AlmacenesVirtuales())->cargarRelaciones());
            if(in_array($id_warehouse, $almacenesVirtuales)) {
                //Ajustamos el stock físico y el reservado
                $almacenStockVirtual = new AlmacenStockVirtual($id_warehouse);
                $almacenStockVirtual->ajustarStockAlmacen($id_product, $id_product_attribute, -$mvt_physical, -$mvt_physical, 
                        'Pedido Enviado', $id_order);
            }
        }
    }
}
