<?php
/**
 * Realiza el cambio del stock físico.
 * NOTA: Para que funcione con el modo "basado en el orden de almacen" sería necesario que cree un movimiento por cada almacén
 * del que saque stock, ahora mismo está computando todo el movimiento al primer almacén.
 */
class ActualizarStockFisico {
    private $pedido, $estadoAnterior, $nuevoEstado;
    
    /**
     * 
     * @param int $id_order
     */
    public function __construct($id_order = 0) {
        if($id_order) {
            $this->pedido = new Order($id_order);
            //Nos inventamos un filtro para evitar la caché
            $estados = $this->pedido->getHistory(Context::getContext()->language->id, false, false, -mt_rand());
            if(count($estados) >= 1) {
                $this->nuevoEstado = new OrderState($estados[0]['id_order_state']);
            }
            if(count($estados) >= 2) {
                $this->estadoAnterior = new OrderState($estados[1]['id_order_state']);
            }
        }
    }
    
    /**
     * Actualiza el stock físico para el último cambio de estado.
     * NOTA: Solo debe llamarse una vez o falseará el stock físico.
     */
    public function actualizar() {
        if($this->nuevoEstado) {
            foreach ($this->pedido->getProductsDetail() as $lineaPedido) {
                if ($this->nuevoEstado->shipped && (!Validate::isLoadedObject($this->estadoAnterior) || !$this->estadoAnterior->shipped)) {
                    //Se han enviado productos, reducimos la cantidad física
                    $mvts = StockMvt::getNegativeStockMvts($this->pedido->id, $lineaPedido['product_id'], $lineaPedido['product_attribute_id'],
                                ($lineaPedido['product_quantity'] - $lineaPedido['product_quantity_refunded'] - $lineaPedido['product_quantity_return'])); 
                    foreach ($mvts as $mvt) {
                        $this->modificarStockFisico($lineaPedido['product_id'], $lineaPedido['product_attribute_id'], $mvt['id_warehouse'], 
                                -$mvt['physical_quantity']);
                    }
                } 
                elseif (!$this->nuevoEstado->shipped && Validate::isLoadedObject($this->estadoAnterior) && $this->estadoAnterior->shipped) {
                    //Se anula el transporte, recuperamos el stock
                    if (Pack::isPack($lineaPedido['product_id'])) {
                        $productos = Pack::getItems($lineaPedido['product_id'], Context::getContext()->language->id);
                        foreach ($productos as $producto) {
                            $mvts = StockMvt::getNegativeStockMvts($this->pedido->id, $producto->id, 0, 
                                    $producto->pack_quantity * $lineaPedido['product_quantity']);
                            foreach ($mvts as $mvt) {
                                $this->modificarStockFisico($producto->id, 0, $mvt['id_warehouse'], $mvt['physical_quantity']); 
                            }
                        }
                    } 
                    else {
                        $mvts = StockMvt::getNegativeStockMvts($this->pedido->id, $lineaPedido['product_id'], $lineaPedido['product_attribute_id'],
                                ($lineaPedido['product_quantity'] - $lineaPedido['product_quantity_refunded'] - $lineaPedido['product_quantity_return']));
                        foreach ($mvts as $mvt) {
                            $this->modificarStockFisico($lineaPedido['product_id'], $lineaPedido['product_attribute_id'], $mvt['id_warehouse'], 
                                    $mvt['physical_quantity']); 
                        }
                    }
                }
            }
        }
    }
    
    /**
     * Cambia el stock físico en la cantidad indicada.
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $id_warehouse
     * @param int $quantity
     * @return boolean
     */
    public function modificarStockFisico($id_product, $id_product_attribute, $id_warehouse, $quantity) {
        $id_stock = (int) StockAvailable::getWarehouseStockAvailableIdByProductId($id_product, $id_product_attribute, $id_warehouse);
        if ($id_stock) {
            $stockObj = new Stock($id_stock);
            $stockObj->physical_quantity += $quantity;
        } 
        else {
            $stockObj = new Stock($id_stock);
            $stockObj->id_product = (int) $id_product;
            $stockObj->id_product_attribute = (int) $id_product_attribute;
            $stockObj->id_warehouse = (int)$id_warehouse;
            $stockObj->usable_quantity += $quantity;
            $stockObj->physical_quantity += $quantity;
            $stockObj->price_te = 0;
        }
        
        //Las cantidades no pueden bajar de cero
        if($stockObj->physical_quantity < 0) {
            $stockObj->physical_quantity = 0;
        }
        if($stockObj->usable_quantity < 0) {
            $stockObj->usable_quantity = 0;
        }
        
        return $stockObj->save();
    }
}
