<?php
define('_PS_ADMIN_DIR_', '');
include_once(dirname(__FILE__) . '../../../../config/config.inc.php');
include_once(dirname(__FILE__) . '/../imaxmovimientospda.php');

$context = Context::getContext();
$modulo = new imaxmovimientospda();
$multiAlmacen = Module::getInstanceByName('imaxmultialmacen');

//Comprobamos logueo
if(empty($context->employee->id) || !$context->employee->isLoggedBack()) {
    Tools::redirectAdmin($context->shop->getBaseURL().'modules/imaxmovimientospda/pda/index.php');
}


$urlImaximprimepedidosservidor = $context->link->getBaseLink().'modules/imaximprimepedidosservidor/menu';
$options = '';

$almacenes = $multiAlmacen->getFunciones()->getWarehouses(true, null, false);
$almacenes = array_values($modulo->quitarAlmacenStockVirtual($almacenes));
$almacenes = array_map(function($almacen) {
    return [
        'id' => $almacen['id_warehouse'],
        'idBusquedas' => $almacen['reference'],
        'nombre' => $almacen['name'],
    ];
}, $almacenes);

$cuerpo = 'principal.php';
$js[] = 'principal.js';
$js[] = 'AsignacionIndividual.js';
$css[] = 'principal.css';
$css[] = 'asignacionIndividual.css';
$traducciones = array('mensaje_errorProducto' => $modulo->l('Error al obtener el producto.', 'imaxmovimientospda'), 
    'mensaje_errorRegistrarMovimiento' => $modulo->l('Error al registrar movimiento de stock del producto.', 'imaxmovimientospda'), 
    'mensaje_registrarMovimiento' => $modulo->l('Movimiento de stock del producto registrado correctamente.', 'imaxmovimientospda'),
    'mensaje_errorAlmacenesIguales' => $modulo->l('El almacén origen y el almacén destino tienen que ser distintos.', 'imaxmovimientospda'),
    'mensaje_errorCantidadNegativa' => $modulo->l('La cantidad introducida debe ser mayor a cero.', 'imaxmovimientospda'),
    'mensaje_errorMovimientosValidos' => $modulo->l('No hay movimientos válidos para registrar.', 'imaxmovimientospda'),
    'mensaje_errorRegistrarMovimientos' => $modulo->l('Error al registrar los movimientos.', 'imaxmovimientospda'), 
    'mensaje_registrarMovimientos' => $modulo->l('Movimientos registrados correctamente.', 'imaxmovimientospda'),
    'mensaje_errorServidor' => $modulo->l('Error al registrar los movimientos.', 'imaxmovimientospda'));
$nombreUsuario = $context->employee->firstname;
$nombrePagina = $modulo->l('Producto', 'ImaxImprimePedidosServidor');
$srcLogo = $context->link->getBaseLink().'img/'.Configuration::get('PS_LOGO');
require_once 'vistas/base.php';