$(function () {
    var id_product = 0, id_product_attribute = 0, stockActual = 0;

    var popUp = new AsignacionIndividual(almacenes, function(elemento) {
        // Usa la referencia al input activo para asignar los valores
        $(inputActivo).data('idwarehouse', elemento.id);
        $(inputActivo).val(elemento.nombre);
        if($(inputActivo).attr('name') == 'searchWarehouse' && elemento.id){
            obtenerListaProductos(elemento.id);
        }
    });

    /**
     * Obtiene un producto por ean y coloca el foco donde corresponda.
     * @param int ean 
     */
    function obtenerProducto(ean) {
        $.getJSON('ajax.php?callback=?', {
            accion: 'obtenerProducto',
            ean: ean
        }, function (respuesta) {
            if (respuesta.ok) {
                limpiarControles();
                $('#infoProducto').html('<strong>' + respuesta.datos.nombre + '</strong>' + '<img src="' + respuesta.datos.imagen + '" alt=""/> ');
                $('#infoProducto').after(respuesta.datos.tablaStocks);
                $('#referencia').html(respuesta.datos.referencia); 
                if(respuesta.datos.almacenSalidaPorDefecto){
                    $('#inputAlmacenDestino').val(respuesta.datos.almacenSalidaPorDefecto.name);
                    $('#inputAlmacenDestino').attr('data-idwarehouse', respuesta.datos.almacenSalidaPorDefecto.id_warehouse);
                }
                $('#contenedorProducto').show();
                $('#contenedorGuardar').show();
                id_product = respuesta.datos.id_product;
                id_product_attribute = respuesta.datos.id_product_attribute;
                almacenesOrigen = respuesta.datos.almacenesOrigen;
                popUpOrigen = new AsignacionIndividual(almacenesOrigen, function(elemento) {
                    // Usa la referencia al input activo para asignar los valores
                    $(inputActivo).attr('data-idwarehouse', elemento.id);
                    $(inputActivo).val(elemento.nombre);
                });
                focoEnInput('inputAlmacenOrigen');
            }
            else {
                limpiarControles();
                
                mensaje(mensaje_errorProducto, 'error');
            }
        });
    }
    
    /**
     * Registrar el movimiento de stock de un producto
     */
    function registrarMovimiento() {
        var cantidad = parseFloat($('#cantidad').val());
        var almacenOrigen = $('#inputAlmacenOrigen').data('idwarehouse');
        var almacenDestino  = $('#inputAlmacenDestino').data('idwarehouse');
        if(isNaN(cantidad) || cantidad <= 0){
            mensaje(mensaje_errorCantidadNegativa, 'error');
        }else if(almacenOrigen == almacenDestino){
            mensaje(mensaje_errorAlmacenesIguales, 'error');

        }else{
            $.getJSON('ajax.php?callback=?', {
                accion: 'registrarMovimiento',
                id_product: id_product,
                id_product_attribute: id_product_attribute,
                almacenOrigen : almacenOrigen,
                almacenDestino : almacenDestino,
                cantidad : cantidad
            }, function (respuesta) {
                limpiarControles();
                if (respuesta.ok) {
                    mensaje(mensaje_registrarMovimiento, 'correcto');
                }
                else {
                    mensaje(mensaje_errorRegistrarMovimiento, 'error');
                }
            });
        }
    }


    /**
     * Registrar el movimiento de stock de productos seleccionados.
     */
    function registrarMovimientos() {
        let movimientos = [];
        let enviarAUnaUbicacion = $('#allDest').is(':checked');
        let almacenDestinoUnico = $('#inputAllDest').data('idwarehouse');

        // Recorrer los productos marcados y recopilar la información
        $('#listaProductos tbody tr').each(function () {
            let checkbox = $(this).find('input[type="checkbox"]');
            if (checkbox.is(':checked')) {
                let cantidad = parseFloat($(this).find('.inputCant').val());
                let almacenDestino = enviarAUnaUbicacion ? almacenDestinoUnico : $(this).find('.inputDest').data('idwarehouse');

                // Validar datos antes de agregar a la lista de movimientos
                if (!isNaN(cantidad) && cantidad > 0 && almacenDestino) {
                    let id_product = checkbox.val().split('-')[0];
                    let id_product_attribute = checkbox.val().split('-')[1];

                    movimientos.push({
                        id_product: id_product,
                        id_product_attribute: id_product_attribute,
                        cantidad: cantidad,
                        almacenDestino: almacenDestino
                    });
                }
            }
        });

        // Si no hay movimientos a registrar, mostrar un mensaje
        if (movimientos.length === 0) {
            mensaje(mensaje_errorMovimientosValidos, 'error');
            return;
        }

        // Realizar la petición AJAX con todos los movimientos
        $.ajax({
            url: 'ajax.php?callback=?',
            method: 'POST',
            dataType: 'json',
            data: {
                accion: 'registrarMovimientos',
                movimientos: movimientos
            },
            success: function (respuesta) {
                limpiarControles();
                if (respuesta.ok) {
                    mensaje(mensaje_registrarMovimientos, 'correcto');
                } else {
                    mensaje(mensaje_errorRegistrarMovimientos, 'error');
                }
            },
            error: function () {
                mensaje(mensaje_errorServidor, 'error');
            }
        });
    }

    /**
     * Modifica los controles para solicitar otro ean.
     */
    function limpiarControles() {
        $('#tablaStocks').remove();
        $('input[name="ean"]').val('');
        $('#almacenOrigen').val('').empty();
        $('#almacenDestino').val('').empty();
        $('#cantidad').val('');
        $('#infoProducto').html('');
        $('#inputAlmacenOrigen').val('').attr('data-idwarehouse', '');
        $('#inputAlmacenDestino').val('').attr('data-idwarehouse', '');
        $('#contenedorProducto').hide();
        $('#contenedorLista').hide();
        $('#contenedorGuardar').hide();
        $('#listaProductos tbody').empty();
        $('#allDest').prop('checked', false);
        $('#inputAllDest').val('');
        
        id_product = 0;
        id_product_attribute = 0;
        stockActual = 0;
    
        focoEnInput('ean');
    }
    
    /**
     * Hace foco en sobre el elemento que le pasamos
     * @param {string} inputName 
     */
    function focoEnInput(inputName) {
        var input = $('input[name="' + inputName + '"]');
        if(!input.is(':focus')) {
            input.attr('readonly', 'readonly');
            input.focus();
            input.get(0).selectionStart = input.get(0).selectionEnd = input.val().length;
            setTimeout(function() {
                input.removeAttr('readonly');
            }, 50);
        }
    }
    
    /**
     * Obteniene la lista de productos de un almacén y coloca el foco donde corresponda.
     * @param int ean 
     */
    function obtenerListaProductos(idWarehouse) {
        $.getJSON('ajax.php?callback=?', {
            accion: 'obtenerListaProductos',
            idWarehouse: idWarehouse
        }, function (respuesta) {
            if (respuesta.ok) {
                limpiarControles();
                $('#infoAlmacen').html('<strong>' + respuesta.datos.almacen.name + '</strong>');
                let tablaListaProductos = '';
                            
                // Iterar sobre cada producto y construir el HTML de la tabla
                Object.values(respuesta.datos.productos).forEach(producto => {
                    tablaListaProductos += `
                        <tr>
                            <td>
                                <input type="checkbox" value="${producto.id_product}-${producto.id_product_attribute}">
                            </td>
                            <td>${producto.referencia}</td>
                            <td>${producto.nombre}</td>
                            <td>${producto.physical_quantity}</td>
                            <td>
                                <input class="inputCant" type="number" min="0" value="${producto.physical_quantity}" />
                            </td>
                            <td>
                                <input class="inputDest" type="text" value="${producto.almacenSalidaPorDefecto?.name || ''}" data-idwarehouse="${producto.almacenSalidaPorDefecto?.id_warehouse || ''}" />
                            </td>
                        </tr>
                    `;
                });

                // Añadir el HTML generado al tbody de la tabla
                $('#listaProductos tbody').html(tablaListaProductos);

                $('#contenedorLista').show();
                $('#contenedorGuardar').show();
            }
            else {
                limpiarControles();
                
                mensaje(mensaje_errorProducto, 'error');
            }
        });
    }

    //Iniciamos
    $('input[name="ean"]').val('');
    $('input[name="ean"]').keyup(function(e) {
        if(e.keyCode == 13) {
            let numero = $('input[name="ean"]').val();
            obtenerProducto(numero);
        }
    });

    $('input[name="searchWarehouse"]').val('');
    
    // Evento para marcar o desmarcar todos los checkboxes
    $(document).on('click', '#allCheck, #allDest', function(e) {
        const isChecked = $(this).is(':checked');
        // Marcar o desmarcar todos los checkboxes en la tabla
        $('#listaProductos tbody input[type="checkbox"]').prop('checked', isChecked);
    });


    $('input[name="cantidad"]').keyup(function(e) {
        if(e.keyCode == 13) {
            registrarMovimiento();
        }
    });

    $('#registrarMovimiento').click(function() {
        if ($('#listaProductos tbody tr').length > 0) {
            registrarMovimientos();
        } else {
            registrarMovimiento();
        }
    });
    
    focoEnInput('ean');

    // Variable para almacenar el input activo
    let inputActivo;

    // Evento de selección para inputs de almacén
    $('#inputAlmacenOrigen, #inputAlmacenDestino').on('click', function(e) {
        $(this).select();
    });

    // Evento de keyup para ambos inputs
    $(document).on('keyup', '#inputAlmacenOrigen, #inputAlmacenDestino, input[name="searchWarehouse"], .inputDest, #inputAllDest', function(e) {
        if (e.keyCode == 13) {
            inputActivo = this; // Asigna el input que activó el evento
            let tipoAlmacen = $(this).attr('id') === 'inputAlmacenOrigen' ? 'Almacenes Origen' : 'Almacenes Destino';

            // Muestra el pop-up correspondiente
            let almacenDestinoVal = $('#inputAlmacenDestino').val();
            (tipoAlmacen === 'Almacenes Origen') ? popUpOrigen.mostrar(tipoAlmacen) : popUp.mostrar(tipoAlmacen);

            $('input[name="textoBusquedaIndividual"]').val($(this).val());
            $('input[name="textoBusquedaIndividual"]').trigger($.Event('keyup', { keyCode: 13 }));

            // Define el próximo foco según el input activo
            let siguienteInput = (tipoAlmacen === 'Almacenes Origen' && !almacenDestinoVal) ? 'inputAlmacenDestino' : 'cantidad';

            // Evento para la selección de la lista
            $('.listadoIndividual li span').click(function(e) {
                focoEnInput(siguienteInput);
            });

            // Evento de keyup para textoBusquedaIndividual
            $('input[name="textoBusquedaIndividual"]').keyup(function(e) {
                if (e.keyCode == 13) {
                    focoEnInput();
                }
            });

            focoEnInput(siguienteInput);
        }
    });
});