<?php
use PrestaShop\PrestaShop\Adapter\SymfonyContainer;

define('_PS_ADMIN_DIR_', '');
include_once(dirname(__FILE__).'../../../../config/config.inc.php');
include_once(dirname(__FILE__).'/../imaxmovimientospda.php');
$context = Context::getContext();
$context->shop->setUrl();
//Inicializamos el kernel
if(version_compare(_PS_VERSION_, '1.7.0.0 ', '>=')) {
    if(!class_exists('AppKernel')) {
        require_once __DIR__.'/../../../app/AppKernel.php';
    }

    global $kernel;
    $kernel = new AppKernel(_PS_MODE_DEV_ ? 'dev' : 'prod', _PS_MODE_DEV_ ? true : false);
    $kernel->boot();
    Context::getContext()->container = SymfonyContainer::getInstance();
}

$resultado['ok'] = false;
$resultado['datos'] = array();
//Comprobamos logueo
if (!empty($context->employee->id) && $context->employee->isLoggedBack()) {
    switch (Tools::getValue('accion')) {
        case 'obtenerProducto':
            $ean = trim(Tools::getValue('ean'));
            $imax = new imaxmovimientospda();
            $resultado['datos'] = $imax->obtenerProductoPDA($ean);
            $resultado['ok'] = (boolean)$resultado['datos'];
            break;
        case 'obtenerListaProductos':
            $idWarehouse =  (int)Tools::getValue('idWarehouse');
            $imax = new imaxmovimientospda();
            $imaxMultialmacen = Module::getInstanceByName('imaxmultialmacen');
            $resultado['datos']['almacen'] = $imaxMultialmacen->getFunciones()->getWarehouseById($idWarehouse);
            $resultado['datos']['productos'] = $imax->obtenerListaProductosPDA($idWarehouse);
            $resultado['ok'] = (boolean)$resultado['datos'];
            break;
        case 'registrarMovimiento':
            $id_product = (int)trim(Tools::getValue('id_product'));
            $id_product_attribute = (int)trim(Tools::getValue('id_product_attribute'));
            $almacenOrigen = (int) Tools::getValue('almacenOrigen');
            $almacenDestino = (int) Tools::getValue('almacenDestino');
            $cantidad = (int)trim(Tools::getValue('cantidad'));
            $imax = new imaxmovimientospda();
            $razonMvtSalida = Configuration::getGlobalValue($imax->sufijo .'RAZON_MVT_SALIDA');
            $razonMvtEntrada = Configuration::getGlobalValue($imax->sufijo.'RAZON_MVT_ENTRADA');
            // Verificar stock en el almacén de origen
            if($almacenOrigen){
                $stockOrigen = StockAvailable::getQuantityAvailableByProduct($id_product, $id_product_attribute, null, $almacenOrigen); 
                if ($stockOrigen >= $cantidad) {
                    try {
                        // Reducir stock en el almacén de origen
                        StockAvailable::updateQuantity($id_product, $id_product_attribute, -$cantidad, null, false, array(), $almacenOrigen);
                        $imax->generarMovimiento($id_product,$id_product_attribute, -$cantidad, $razonMvtSalida, $almacenOrigen);
                        // Aumentar stock en el almacén de destino
                        StockAvailable::updateQuantity($id_product, $id_product_attribute, $cantidad, null, false, array(), $almacenDestino);
                        $imax->generarMovimiento($id_product,$id_product_attribute, $cantidad, $razonMvtEntrada, $almacenDestino);
                        if(Module::isEnabled('imaxmultialmacen')){
                            include_once(dirname(__FILE__).'/../../imaxmultialmacen/classes/ActualizarStockFisico.php');
                            $actualizarStockFisico = new ActualizarStockFisico();
                            $actualizarStockFisico->modificarStockFisico($id_product, $id_product_attribute, $almacenOrigen, -$cantidad);
                            $actualizarStockFisico->modificarStockFisico($id_product, $id_product_attribute, $almacenDestino, $cantidad);
                            $multiAlmacen = Module::getInstanceByName('imaxmultialmacen');
                            $multiAlmacen->movimientoStockVirtual($cantidad, $id_product, $id_product_attribute, $almacenOrigen, $almacenDestino);
                        }
                        $resultado['ok'] = true;
                    } catch (Exception $e) {
                        $resultado['ok'] = false;
                    }      
                } else {
                    $resultado['ok'] = false;
                }
            } else{
                try {
                    // Aumentar stock en el almacén de destino
                    StockAvailable::updateQuantity($id_product, $id_product_attribute, $cantidad, null, false, array(), $almacenDestino);
                    $imax->generarMovimiento($id_product,$id_product_attribute, $cantidad, $razonMvtEntrada, $almacenDestino);
                    if(Module::isEnabled('imaxmultialmacen')){
                        include_once(dirname(__FILE__).'/../../imaxmultialmacen/classes/ActualizarStockFisico.php');
                        $actualizarStockFisico = new ActualizarStockFisico();
                        $actualizarStockFisico->modificarStockFisico($id_product, $id_product_attribute, $almacenDestino, $cantidad);
                        $multiAlmacen = Module::getInstanceByName('imaxmultialmacen');
                        $multiAlmacen->movimientoStockVirtual($cantidad, $id_product, $id_product_attribute, null, $almacenDestino);
                    }
                    $resultado['ok'] = true;
                } catch (Exception $e) {
                    $resultado['ok'] = false;
                }      
            }
            break;
            case 'registrarMovimientos':
                $movimientos = Tools::getValue('movimientos');
                $imax = new imaxmovimientospda();
                $resultado = ['ok' => true];
                $razonMvtEntrada = Configuration::getGlobalValue($imax->sufijo.'RAZON_MVT_ENTRADA');
                try {
                    foreach ($movimientos as $movimiento) {
                        $id_product = (int)$movimiento['id_product'];
                        $id_product_attribute = (int)$movimiento['id_product_attribute'];
                        $almacenDestino = (int)$movimiento['almacenDestino'];
                        $cantidad = (int)$movimiento['cantidad'];
                        // Aumentar stock en el almacén de destino
                        StockAvailable::updateQuantity($id_product, $id_product_attribute, $cantidad, null, false, array(), $almacenDestino);
                        $imax->generarMovimiento($id_product,$id_product_attribute, $cantidad, $razonMvtEntrada, $almacenDestino);
                        if(Module::isEnabled('imaxmultialmacen')){
                            include_once(dirname(__FILE__).'/../../imaxmultialmacen/classes/ActualizarStockFisico.php');
                            $actualizarStockFisico = new ActualizarStockFisico();
                            $actualizarStockFisico->modificarStockFisico($id_product, $id_product_attribute, $almacenDestino, $cantidad);
                            $multiAlmacen = Module::getInstanceByName('imaxmultialmacen');
                            $multiAlmacen->movimientoStockVirtual($cantidad, $id_product, $id_product_attribute, null, $almacenDestino);
                        }
                    }
                    $resultado['ok'] = true;
                } catch (Exception $e) {
                    dump($e);
                    die();
                    $resultado['ok'] = false;
                }

            break;
            
    }
}

echo Tools::getValue('callback').'('.json_encode($resultado).')';
