/* global mensaje_comentarios, mensaje_errorComentarios, mensaje_guardar, mensaje_errorGuardar */

$(function () {
    var multiplicador = new Multiplicador(simboloMultiplicador);
    var lector = new LectorCodigosInput(13, function (codigoEscaneado) {
        $('.linea').each(function () {
            var opcionSeleccionada = $('input[name="opcionEscaneo"]:checked').val(); // Obtiene la opción seleccionada
            var cantidad = multiplicador.getMultiplicador(codigoEscaneado);
            var codigo = multiplicador.getCodigo(codigoEscaneado);
        
            if (opcionSeleccionada === 'producto') {
                // Escanear producto
                if ($(this).data('referencia') == codigo && $(this).data('refalmacen') == codigoAlmacenGlobal) {
                    procesarLectura($(this), cantidad);
                    return false; // Salir del bucle
                } else if (typeof refEan[codigo] !== 'undefined' && $(this).data('referencia') == refEan[codigo] && $(this).data('refalmacen')  == codigoAlmacenGlobal) {
                    procesarLectura($(this), cantidad);
                    return false; // Salir del bucle
                }
            } else if (opcionSeleccionada === 'almacen') {
                // Escanear almacén
                codigoAlmacenGlobal = codigoEscaneado;
                let almacenEncontrado = almacenes.find(function(almacen) {
                    return almacen.idBusquedas === codigoAlmacenGlobal;
                });
                if(almacenEncontrado){
                    $('#infoAlmacen').html(`<strong>Almacén: </strong> ${almacenEncontrado.idBusquedas}-${almacenEncontrado.nombre}`);
                }else{
                    $('#infoAlmacen').html('');
                    mensaje(mensaje_errorAlmacen, 'error'); 
                }
                return false;
            }
        });
    });
    lector.iniciarCaptacion();
    focoEnInput(lector.inputName);
    $('body').click(function () {
        focoEnInput(lector.inputName);
    });

    var comentarios = [];
    
    cargarComentarios();
    if (estado) {
        $('.linea').each(function () {
            if(unidadesComparar == 1){
                var unidades = $(this).find('td:nth-child(4)').html();
            }else{
                var unidades = $(this).find('td:nth-child(5)').html();
            }      
            var unidadesCont = $(this).find('td:nth-child(6)').html();
            if (unidadesCont !== '') {
                if (unidades == unidadesCont) {
                    $(this).addClass('igual');
                } else {
                    $(this).addClass('desigual');
                }
            }
        });
    }
    desactivarFilas();
    if (estado == 'Finalizado') {
        $('#guardar').addClass('desactivado').removeClass('boton');
        $('#generar').addClass('desactivado').removeClass('boton');
        $('#intro').addClass('desactivado').removeClass('boton');
        $('#finalizar').addClass('desactivado').removeClass('boton');
    } else if (id) {
        $('#generar').addClass('desactivado').removeClass('boton');
        $('#guardar').addClass('boton').removeClass('desactivado');
        $('#finalizar').addClass('boton').removeClass('desactivado');
        $('#intro').addClass('boton').removeClass('desactivado');
    } else {
        $('#guardar').addClass('desactivado').removeClass('boton');
        $('#finalizar').addClass('desactivado').removeClass('boton');
        $('#intro').addClass('desactivado').removeClass('boton');
        $('#comentarios').addClass('desactivado').removeClass('boton');
    }

    $('#idInventario').html(id);

    $('#generar').click(function () {
        $.getJSON('ajax.php?callback=?', {
            accion: 'generar',
            nombreArchivo: nombreArchivo,
        }, function (respuesta) {
            if (respuesta.ok) {
                mensaje(mensaje_generar, 'correcto');
                id = respuesta.id;
                location.assign('inventario.php?archivo=' + nombreArchivo + '&id=' + id);
            }
            else {
                mensaje(mensaje_errorGenerar, 'error');
            }
        });
    });

    $('#menos').click(function (e) {
        e.stopPropagation();
        var cantidad = parseInt($('input[name="cantidad"]').val());
        if (isNaN(cantidad)) {
            cantidad = 0;
        }
        cantidad--;
        $('input[name="cantidad"]').val(cantidad);
        cantidadActual = 0;
        if(!isNaN(parseInt($('.seleccionada td:last-child').html()))){
            cantidadActual = parseInt($('.seleccionada td:last-child').html());
        }
        cantidadActual--;
        $('.seleccionada td:last-child').html(cantidadActual);
        guardar();
        focoEnInput(lector.inputName);
    });
    

    $('#mas').click(function (e) {
        e.stopPropagation();
        var cantidad = parseInt($('input[name="cantidad"]').val());
        if (isNaN(cantidad)) {
            cantidad = 0;
        }
        cantidad++;
        $('input[name="cantidad"]').val(cantidad);
        cantidadActual = 0;
        if(!isNaN(parseInt($('.seleccionada td:last-child').html()))){
            cantidadActual = parseInt($('.seleccionada td:last-child').html());
        }
        cantidadActual++;
        $('.seleccionada td:last-child').html(cantidadActual);
        guardar();
        focoEnInput(lector.inputName);
    });

    $('.linea').click(function () {
        $('input[name="cantidad"]').val('');
        $('#comentarios').removeClass('desactivado').addClass('boton');
        referencia = $(this).data('referencia');
        $('.linea').removeClass('seleccionada');
        $(this).removeClass('igual');
        $(this).removeClass('desigual');
        $(this).addClass('seleccionada');
        scroll();
        getEan(referencia);
        if(unidadesComparar == 1){
            var totales = $(this).find('td:nth-child(4)').html();
        }else{
            var totales = $(this).find('td:nth-child(5)').html();
        }
        var escaneadas = $(this).find('td:nth-child(6)').html();
        cargarUnidadesContador(escaneadas, totales);
        marcarFilas();
    });

    function getEan(referencia) {
        $.getJSON('ajax.php?callback=?', {
            accion: 'getEan',
            referencia: referencia
        }, function (respuesta) {
            if (respuesta.ok) {
                $('#ean').val(respuesta.datos);
            } else {
                $('#ean').val('Producto sin EAN');
            }
        });
    }

    function cargarUnidadesContador(escaneadas, totales = ''){
        if (totales != '') {
            $('#unidadesTotales').val(totales);
        }
        if (escaneadas == '') {
            escaneadas = 0;
        }
        $('#unidadesEscaneadas').val(escaneadas);
    }

    $('#cantidad').click(function (e) {
        e.stopPropagation();
    });

    $('#cantidad').keyup(function (e) {
        if (e.keyCode == 13) {
            $('#intro').click();
        }
    });
    $('#intro').click(function () {
        cantidadAlmacen = parseInt($('input[name="cantidad"]').val());
        cantidad = 0;
        if(!isNaN(parseInt($('.seleccionada td:last-child').html()))){
            cantidad = parseInt($('.seleccionada td:last-child').html());
        }
        cantidadAlmacen += cantidad
        $('.seleccionada td:last-child').html(cantidadAlmacen);
        cargarUnidadesContador(cantidadAlmacen);
        $('#cantidad').val('');
        guardar();
        marcarFilas(true);
    });


    $('#finalizar').click(function () {
        var contenido = '<p>¿ESTÁ SEGURO DE FINALIZAR INVENTARIO?</p><button id="aceptar" class="boton">ACEPTAR</button>';
        abrirDialogo(contenido, function () {
            $('#aceptar').click(function () {
                $('#aceptar').removeClass('boton').addClass('desactivado');
                guardar(function () {
                    $.getJSON('ajax.php?callback=?', {
                        accion: 'finalizar',
                        id: id,
                        nombreArchivo: nombreArchivo,
                    }, function (respuesta) {
                        if (respuesta.ok) {
                            mensaje(mensaje_finalizar, 'correcto');
                            location.assign('principal.php');
                        } else {
                            mensaje(mensaje_errorFinalizar, 'error');
                        }
                    });
                });
            });
        });
    });

    $('#comentarios').click(function () {
        var contenido = '<p>COMENTARIOS</p><textarea id="textoComentarios"></textarea><button id="aceptar" class="boton">ACEPTAR</button>';
        $('.linea').each(function () {
            var referencia = $(this).data('referencia');
        });
        abrirDialogo(contenido, function () {
            $('#textoComentarios').click(function (e) {
                e.stopPropagation();
            });
            $('#textoComentarios').val(comentarios[referencia]);
            $('#aceptar').click(function () {
                var comentario = $('#textoComentarios').val();
                $.getJSON('ajax.php?callback=?', {
                    accion: 'comentariosLinea',
                    id: id,
                    referencia: referencia,
                    comentario: comentario
                }, function (respuesta) {
                    if (respuesta.ok) {
                        mensaje(mensaje_comentarios, 'correcto');
                        comentarios[referencia] = comentario;
                    } else {
                        mensaje(mensaje_errorComentarios, 'error');
                    }
                    cerrarDialogo();
                });
                marcarFilas(true);
            });
        });
    });

    function cargarComentarios() {
        $.getJSON('ajax.php?callback=?', {
            accion: 'cargarComentariosLineas',
            id: id
        }, function (respuesta) {
            if (respuesta.ok) {
                comentarios = respuesta.datos;
            }
        });
    }

    function guardar(callback) {
        var datos = [];
        $('.linea').each(function () {
            let referencia = $(this).data('referencia');
            let cantidad = parseInt($(this).find('td:last-child').html());
            let ubicacion = $(this).data('ubicacion');
            let refAlmacen = $(this).data('refalmacen');
            datos.push({ id, referencia, cantidad, ubicacion, refAlmacen});
        });
        $.ajax({
            type: "POST",
            url: 'ajax.php?callback=?',
            async: true,
            dataType: "jsonp",
            data: {
                datos : datos,
                accion: 'guardar',

            },
            success: function (respuesta) {
                if (respuesta.ok) {
                    if (typeof (callback) === 'function') {
                        callback();
                    }// else {
                    //     location.assign('principal.php');
                    // }
                }
            }
        });
    }

    $('#cancelar').click(function () {
        location.assign('principal.php');
    });


    /**
     * Funcion que hace scroll hasta el elemento seleccionado
     */

    function scroll() {
        var posicion = $('.seleccionada').offset().top - 90;
        $('html, body').animate({ scrollTop: posicion }, 500);
    }

    /**
     * Funcion que desactiva las filas con una referencia no valida
    */
   function desactivarFilas() {
        $('.linea').each(function () {
            var descripcion = $(this).find('td:nth-child(3)').html();
            if (descripcion == 'Referencia errónea' || descripcion == 'No existe la referencia en Prestashop') {
                $(this).addClass('desactivada');
            }
        });
    }
    
    /**
     * Realiza los procesos necesarios tras leer correctamente una referencia.
     * @param {jQuery} linea
     * @param {int} cantidad
     */
    function procesarLectura(linea, cantidad) {
        $('.linea').removeClass('seleccionada');
        linea.addClass('seleccionada');
        scroll();
        referencia = linea.data('referencia');
        getEan(referencia);
        if(cantidad) {
            //La cantidad venía en el código, lo automatizamos
            $('#cantidad').val(cantidad);
            $('#intro').click();
        }
    }

});
