/**
 * Muestra un mensaje en pantalla.
 * @param {string} texto
 * @param {string} clase
 */
function mensaje(texto, clase) {
    var mensaje = $('<div class="alert ' + clase + '">' + texto + '</div>');
    $('body').append(mensaje);
    mensaje.css('left', $(window).width() / 2 - mensaje.outerWidth() / 2);

    mensaje.click(function () {
        mensaje.fadeOut(1000, function () {
            mensaje.remove();
        });
    });

    setTimeout(function () {
        mensaje.fadeOut(1000, function () {
            mensaje.remove();
        });
    }, 5000);
}

/**
 * Abre un cuadro de dialogo.
 * @param {String} contenido
 * @param {function} onReady
 */
function abrirDialogo(contenido, onReady) {
    var html =
        '<div class="ventana">' +
        contenido +
        '<span class="botonCerrarDialogo">X</span></div>';
    $('body').append(html);

    //Centrar
    $('.ventana').css('left', parseFloat($('body').width()) / 2 - parseFloat($('.ventana').outerWidth()) / 2);

    if (typeof onReady === 'function') {
        onReady();
    }
    $('.botonCerrarDialogo').click(function () {
        cerrarDialogo();
    });
}

/**
 * Cierra el cuadro de dialogo.
 */
function cerrarDialogo() {
    $('.ventana').remove();
    marcarFilas(true);
}

/**
* Pone el cursor en el input de captación.
* @param {string} inputName
* @param {boolean} forzar
*/
function focoEnInput(inputName, forzar) {
    if (!$('input[name="' + inputName + '"]').is(':focus') || forzar) {
        if (!mostrarTeclado) {
            $('input[name="' + inputName + '"]').attr('readonly', 'readonly');
        }
        $('input[name="' + inputName + '"]').focus();
        if (!mostrarTeclado) {
            setTimeout(function () {
                $('input[name="' + inputName + '"]').removeAttr('readonly');
            }, 50);
        }
    }
}

function marcarFilas(intro = false) {
    $('.linea').each(function() {
        cantidadAlmacen = parseInt($(this).find('td:last-child').html());
        if (isNaN(cantidadAlmacen) || (!intro && $(this).hasClass('seleccionada'))) {
            return;
        }    
        var cantidadPrestashop;
        
        if (unidadesComparar == 1) {
            cantidadPrestashop = parseInt($(this).find('td:nth-child(4)').html());
        } else {
            cantidadPrestashop = parseInt($(this).find('td:nth-child(5)').html());
        }
        
        if (cantidadAlmacen == cantidadPrestashop) {
            $(this).removeClass('desigual').addClass('igual').removeClass('seleccionada');
        } else {
            $(this).removeClass('igual').addClass('desigual').removeClass('seleccionada');
        }
    });
}