/**
 * Permite leer distintos tipos de códigos complejos introducidos por teclado.
 * @param {int} codigoFinalizacion El código char de la tecla que finaliza la introducción. 
 * Si no se indica, se finaliza al alcanzar la longitud.
 * @param {function} callback Se llama con el código captado.
 * @returns {LectorCodigosInput}
 */
function LectorCodigosInput(codigoFinalizacion, callback) {
    var esto = this;
    
    this.codigoFinalizacion = codigoFinalizacion;
    this.captando = false;
    this.inputName = 'lector_' + Math.floor(Math.random() * 100000);
    
    var input = $('<input type="text" name="' + this.inputName + '" value=""/>');
    input.css({
        'position': 'absolute',
        'top': '0px',
        'left': '-1000px',
        'width': '100px'
    });
    $('body').append(input);
    
    input.keyup(function(e) {
        if(esto.captando) {
            if(e.keyCode == esto.codigoFinalizacion) {
                var numero = $.trim(input.val());
                input.val('');

                callback(numero);
            }
        }
    });
}

/**
 * Inicia la captación de códigos.
 */
LectorCodigosInput.prototype.iniciarCaptacion = function() {
    this.captando = true;
    $('input[name="' + this.inputName + '"]').val('');
    
};

/**
 * Detiene la captación de códigos.
 * @param {boolean} vaciarBuffer
 */
LectorCodigosInput.prototype.detenerCaptacion = function() {
    this.captando = false;
};