<?php
define('_PS_ADMIN_DIR_', '');
include_once(dirname(__FILE__) . '../../../../config/config.inc.php');
include_once(dirname(__FILE__) . '/../imaxinventariodiferido.php');

$context = Context::getContext();
$modulo = new imaxinventariodiferido();
$multiAlmacen = Module::getInstanceByName('imaxmultialmacen');

//Comprobamos logueo
if (empty($context->employee->id) || !$context->employee->isLoggedBack()) {
    Tools::redirectAdmin($context->shop->getBaseURL() . 'modules/imaxinventariodiferido/pda/index.php');
}

$archivo = basename(Tools::getValue('archivo'));
$id = basename(Tools::getValue('id'));
$refEan = [];
if ($id) {
    $inventario = $modulo->getReferencias($id);
    if(Module::isEnabled('imaxmultialmacen')){
        $inventario = array_values(array_unique($inventario));
    }
    foreach ($inventario as $referencia) {
        $eans = $modulo->getEan($referencia);
        if (!empty($eans)) {
            foreach($eans as $ean){
                $refEan[$ean] = $referencia;
            }
        }
    }
} else {
    $inventario = $modulo->getInventario($archivo);
}
$inventarioTemp = array();
foreach ($inventario as $referencia) {
    if(Module::isEnabled('imaxmultialmacen')){
        $datosMultialmacen = $modulo->getDatosInventarioMultialmacen($id, $referencia);
        foreach($datosMultialmacen as  $datoMultialmacen){
            $inventarioTemp[] = $datoMultialmacen;
        }
    }else{
        $inventarioTemp[] = $modulo->getDatosInventario($id, $referencia);
    }
}

$almacenes = $multiAlmacen->getFunciones()->getWarehouses(true, null, false);
$almacenes = array_values($modulo->quitarAlmacenStockVirtual($almacenes));
$almacenes = array_map(function($almacen) {
    return [
        'id' => $almacen['id_warehouse'],
        'idBusquedas' => $almacen['reference'],
        'nombre' => $almacen['name'],
    ];
}, $almacenes);

$inventario = $inventarioTemp;
$urlImaximprimepedidosservidor = $context->link->getBaseLink() . 'modules/imaximprimepedidosservidor/menu';
$urlPrincipal = $context->link->getBaseLink() . 'modules/imaxinventariodiferido/pda/principal.php';
$cuerpo = 'inventario.php';
$js[] = 'inventario.js';
$js[] = 'LectorCodigos.js';
$js[] = 'Multiplicador.js';
$css[] = 'inventario.css';
$traducciones = array(
    'mensaje_errorGenerar' => $modulo->l('Error al generar el fichero.', 'imaxinventariodiferido'),
    'mensaje_generar' => $modulo->l('Fichero generado correctamente.', 'imaxinventariodiferido'),
    'mensaje_guardar' => $modulo->l('Inventario guardado correctamente.', 'imaxinventariodiferido'),
    'mensaje_errorGuardar' => $modulo->l('Error al guardar el inventario.', 'imaxinventariodiferido'),
    'mensaje_finalizar' => $modulo->l('Inventario finalizado correctamente.', 'imaxinventariodiferido'),
    'mensaje_errorFinalizar' => $modulo->l('Error al finalizar el inventario.', 'imaxinventariodiferido'),
    'mensaje_comentarios' => $modulo->l('Comentarios guardados correctamente.', 'imaxinventariodiferido'),
    'mensaje_errorComentarios' => $modulo->l('Error al guardar los comentarios.', 'imaxinventariodiferido'),
    'mensaje_errorAlmacen' => $modulo->l('El almacén no ha sido encontrado.', 'imaxinventariodiferido'),
);
$nombreUsuario = $context->employee->firstname;
$nombrePagina = $modulo->l('Inventario', 'ImaxImprimePedidosServidor');
$srcLogo = $context->link->getBaseLink() . 'img/' . Configuration::get('PS_LOGO');
$mostrarTeclado = Configuration::getGlobalValue($modulo->sufijo.'MOSTRAR_TECLADO');
$simboloMultiplicador = Configuration::getGlobalValue($modulo->sufijo . 'SIMBOLO_MULTIPLICADOR');
$unidadesComparar = Configuration::getGlobalValue($modulo->sufijo . 'UNIDADES_COMPARAR');
$fechaArchivo = date('d/m/Y');
require_once 'vistas/base.php';
