<?php

define('_PS_ADMIN_DIR_', '');
include_once(dirname(__FILE__) . '../../../../config/config.inc.php');
include_once(dirname(__FILE__) . '/../imaxinventariodiferido.php');

$context = Context::getContext();
$context->shop->setUrl();

$resultado['ok'] = false;
$resultado['datos'] = array();
//Comprobamos logueo
if (!empty($context->employee->id) && $context->employee->isLoggedBack()) {
    switch (Tools::getValue('accion')) {
        case 'generar':
            $nombreArchivo = trim(Tools::getValue('nombreArchivo'));
            $nombreUsuario = $context->employee->firstname . ' ' . $context->employee->lastname;
            $imax = new imaxinventariodiferido();
            $resultado['datos'] = $imax->guardarArchivo($nombreUsuario, $nombreArchivo);
            if ($resultado['datos']) {
                $id = $imax->getIdArchivo($nombreArchivo);
                if(Module::isEnabled('imaxmultialmacen')){
                    $resultado['datos'] = $imax->guardarLineaArchivoMultialmacen($id, $nombreArchivo);
                }else{
                    $resultado['datos'] = $imax->guardarLineaArchivo($id, $nombreArchivo);
                }
            }
            $imax->eliminarArchivo($nombreArchivo);
            $resultado['ok'] = (bool)$resultado['datos'];
            $resultado['id'] = $id;
            break;

        case 'getEan':
            $referencia = trim(Tools::getValue('referencia'));
            $imax = new imaxinventariodiferido();
            $resultado['datos'] = $imax->getEan($referencia);
            if (!empty($resultado['datos'])) {
                $resultado['ok'] = true;
            }
            break;
        case 'guardar':
            $datos = Tools::getValue('datos');
            $imax = new imaxinventariodiferido();
            foreach ($datos as $dato) {
                if ($dato['cantidad'] == 'NaN') {
                    $dato['cantidad'] = -1;
                }
                $resultado['datos'] = $imax->actualizarLineaArchivo($dato['id'], $dato['referencia'], $dato['cantidad'], $dato['ubicacion'], $dato['refAlmacen']);
            }
            $resultado['ok'] = (bool)$resultado['datos'];
            break;
        case 'finalizar':
            $id = trim(Tools::getValue('id'));
            $nombreArchivo = trim(Tools::getValue('nombreArchivo'));
            $imax = new imaxinventariodiferido();
            if(Module::isEnabled('imaxmultialmacen')){
                $imax->enviarEmailsMultialmacen($id, $nombreArchivo);
                $imax->generarCsvMultialmacen($id, $nombreArchivo);
            }else{
                $imax->enviarEmails($id, $nombreArchivo);
                $imax->generarCsv($id, $nombreArchivo);
            }
            $resultado['datos'] = $imax->finalizarArchivo($id);
            $resultado['ok'] = (bool)$resultado['datos'];
            break;
        case 'cargarComentariosLineas':
            $id = trim(Tools::getValue('id'));
            $imax = new imaxinventariodiferido();
            $resultado['datos'] = $imax->cargarComentariosLineas($id);
            $resultado['ok'] = (bool)$resultado['datos'];
            break;
        case 'comentariosLinea':
            $id = trim(Tools::getValue('id'));
            $referencia = trim(Tools::getValue('referencia'));
            $comentario = trim(Tools::getValue('comentario'));
            $imax = new imaxinventariodiferido();
            $resultado['datos'] = $imax->guardarComentarioLinea($id, $referencia, $comentario);
            $resultado['ok'] = (bool)$resultado['datos'];
            break;
        case 'cargarComentariosArchivos':
            $imax = new imaxinventariodiferido();
            $resultado['datos'] = $imax->cargarComentariosArchivos();
            $resultado['ok'] = (bool)$resultado['datos'];
            break;
        case 'comentariosArchivo':
            $id = trim(Tools::getValue('id'));
            $comentario = trim(Tools::getValue('comentarios'));
            $imax = new imaxinventariodiferido();
            $resultado['datos'] = $imax->guardarComentarioArchivo($id, $comentario);
            $resultado['ok'] = (bool)$resultado['datos'];
            break;
        case 'eliminar':
            $id = trim(Tools::getValue('id'));
            $imax = new imaxinventariodiferido();
            $resultado['datos'] = $imax->eliminarInventario($id);
            $resultado['ok'] = (bool)$resultado['datos'];
            break;
    }
}

echo Tools::getValue('callback') . '(' . json_encode($resultado) . ')';
