<?php

class imaxinventariodiferido extends Module
{

    var $versionPS;
    var $idShop;
    var $idLang;
    var $idTab;
    var $ean;
    var $stock;
    private $_html = '';

    const prefijo = 'imaxinventariodiferido_';
    public $idManual, $forceCheck, $sufijo;

    public function __construct()
    {
        $this->name = 'imaxinventariodiferido';
        $this->tab = 'administration';
        $this->version = '1.30';
        $this->author = 'Informax';
        $this->need_instance = 0;
        $this->idManual = '';
        $this->forceCheck = 0;
        $this->sufijo = self::prefijo;
        parent::__construct();
        $this->displayName = $this->l('Control del inventario diferido');
        $this->description = $this->l('Permite contabilizar el inventario diferido de los productos cargados desde un archivo .csv');

        if (version_compare(_PS_VERSION_, '1.5.0.0 ', '>=')) {
            $this->versionPS = 15;
            $this->idLang = Configuration::getGlobalValue('PS_LANG_DEFAULT');
            $this->idShop = Configuration::getGlobalValue('PS_SHOP_DEFAULT');
        }       
    }

    public function install()
    {
        $directorioAdmin = getcwd();
        if (!@copy(dirname(__FILE__) . '/imaxinventariodiferido_ajax.php', $directorioAdmin . '/imaxinventariodiferido_ajax.php')) {
            $this->_errors[] = $this->l('Ha fallado al copiar el fichero de JS');
            return false;
        }


        include(dirname(__FILE__) . '/configuration.php');
        foreach ($configuracion as $indice => $valor) {
            if (!Configuration::updateGlobalValue($indice, $valor)) {
                return false;
            }
        }

        if (!parent::install())
            return false;

        foreach ($hooks as $hook) {
            if (!$this->registerHook($hook)) {
                $this->_errors[] = $this->l('Ha fallado la instalacion del hook:') . ' ' . $hook;
                return false;
            }
        }

        include(dirname(__FILE__) . '/sql-install.php');
        foreach ($sql as $s) {
            if (!Db::getInstance()->execute($s)) {
                $this->_errors[] = $this->l("Error al ejecutar") . $s;
                return false;
            }
        }

        if (!$this->installTab()) {
            $this->_errors[] = $this->l('Error al instalar el tab');
            return false;
        }

        //Crear redireccion hacia pda
        Db::getInstance()->execute('INSERT IGNORE INTO `' . _DB_PREFIX_ . 'meta` (page, configurable) VALUES ("module-imaxinventariodiferido-pda", 1)');
        $idMeta = Db::getInstance()->Insert_ID();
        $tiendas = Shop::getShops();
        $idiomas = Language::getLanguages();
        foreach ($tiendas as $tienda) {
            foreach ($idiomas as $idioma) {
                Db::getInstance()->execute('
                    INSERT IGNORE INTO `' . _DB_PREFIX_ . "meta_lang` (id_meta, id_shop, id_lang, title, description, keywords, url_rewrite) 
                        VALUES ('$idMeta', '{$tienda['id_shop']}', '{$idioma['id_lang']}', 'INVENTARIO DIFERIDO', 'Ayuda a modificar el stock de los productos.', 'inventarioDiferido', 'inventarioDiferido')");
            }
        }

        if (class_exists('Theme')) {
            $plantillas = Theme::getThemes();
            foreach ($plantillas as $plantilla) {
                Db::getInstance()->execute('
                INSERT IGNORE INTO `' . _DB_PREFIX_ . "theme_meta` (id_theme, id_meta, left_column, right_column) 
                    VALUES ('$plantilla->id', '$idMeta', '$plantilla->default_left_column', '$plantilla->default_right_column')");
            }
        }
        return true;
    }

    public function uninstall()
    {
        if (!parent::uninstall()) {
            return false;
        }

        include(dirname(__FILE__) . '/sql-unninstall.php');
        foreach ($sql as $s) {
            if (!Db::getInstance()->execute($s)) {
                $this->_errors[] = $this->l("Error al ejecutar") . $s;
                return false;
            }
        }
        $directorioAdmin = getcwd();


        if (!$this->uninstallTab()) {
            $this->_errors[] = $this->l('Error al eliminar el tab');
            return false;
        }

        include(dirname(__FILE__) . '/configuration.php');
        foreach ($configuracion as $indice => $valor) {
            if (Configuration::getGlobalValue($indice) !== FALSE) {
                if (!Configuration::deleteByName($indice)) {
                    return false;
                }
            }
        }

        return true;
    }

    public function getContent()
    {
        $this->getTxtFiles();
        
        $this->addCSS('css.css');
        $this->addJS('functions.js');
        $this->addCSS('publi.css');
        $this->_html .= $this->createHelpHeader();
        if (!empty($_POST)){
            if (isset($_SESSION['message'])) {
                $this->_html .= $_SESSION['message'];
                unset($_SESSION['message']);
            }else{
                $this->_html .= $this->_postProcess();
            }
        }

        $this->_displayForm();
        $this->_html .= $this->getModuleFooter();
        return $this->_html;
    }

    private function _postProcess()
    {
        $accion = Tools::getValue("action");
        $this->idTab = Tools::getValue("idTab");
        $html = "";
        switch ($accion) {
            case 'gestionLicencia':
                $this->forceCheck = 1;
                if (Configuration::updateGlobalValue(self::prefijo . 'LICENCIA', trim(Tools::getValue('licencia'))))
                    $html .= $this->displayConfirmation($this->l('Licencia guardada correctamente.'));
                else
                    $html .= $this->displayError($this->l('Ha ocurrido un error al guardar la licencia'));
                break;
            case 'configuracion':
                if (Configuration::updateGlobalValue(self::prefijo . 'MOSTRAR_TECLADO', trim(Tools::getValue('mostrar_teclado'))) &&
                    Configuration::updateGlobalValue(self::prefijo . 'SIMBOLO_MULTIPLICADOR', trim(Tools::getValue('simboloMultiplicador'))) &&
                    Configuration::updateGlobalValue(self::prefijo . 'UNIDADES_COMPARAR', trim(Tools::getValue('unidadesComparar'))) &&
                    Configuration::updateGlobalValue(self::prefijo . 'ORIGEN_UBI_PDA', trim(Tools::getValue('origenUbicacionPDA')))
                    ) {
                    $html .= $this->displayConfirmation($this->l('Configuración guardada correctamente.'));
                } else
                    $html .= $this->displayError($this->l('Ha ocurrido un error al guardar la configuracion'));
                break;
            case 'emails':
                if (
                    Configuration::updateGlobalValue(self::prefijo . 'EMAILS', trim(Tools::getValue('emails')))
                ) {
                    $html .= $this->displayConfirmation($this->l('Configuración guardada correctamente.'));
                } else
                    $html .= $this->displayError($this->l('Ha ocurrido un error al guardar la configuracion'));
                break;
            case 'ficheros':
                $uploads_dir = __DIR__ . '/import';
                if ($_FILES["fichero"]["error"] == UPLOAD_ERR_OK) {
                    $tmp_name = $_FILES["fichero"]["tmp_name"];
                    $name = basename($_FILES["fichero"]["name"]);
                    move_uploaded_file($tmp_name, "$uploads_dir/$name");
                    $html .= $this->displayConfirmation($this->l('Fichero subido correctamente.'));
                } else {
                    $html .= $this->displayError($this->l('Ha ocurrido un error al subir el fichero'));
                }
                $_SESSION['message'] = $html;
                header('Location: ' . $_SERVER['REQUEST_URI']);
                exit();
                break;
            default:
                break;
        }

        return $html;
    }

    private function _displayForm()
    {

        if (Configuration::getGlobalValue(self::prefijo . 'LICENCIA') == '') {
            $this->_html .= '<div class="bootstrap" style="width:100%">';
            $this->_html .= '<div class="alert alert-warning">';
            $this->_html .= '<p>' . $this->l('ATENCION: SU LICENCIA ESTA VACIA') . '</p>';
            $this->_html .= '<p>' . $this->l('Debe introducir un numero de licencia valido para continuar') . '</p>';
            $this->_html .= '</div>';
            $this->_html .= '</div>';
            $this->_html .= $this->_mostrarLicencia();
            $this->forceCheck = 0;
        } elseif (!$this->checkLicencia($this->forceCheck)) {
            $this->_html .= '<div class="bootstrap" style="width:100%">';
            $this->_html .= '<div class="alert alert-warning">';
            $this->_html .= '<p>' . $this->l('ATENCION: SU LICENCIA NO ES VALIDA') . '</p>';
            $this->_html .= '<p>' . $this->l('Si ejecuta el modulo sin licencia los resultados no seran validos') . '</p>';
            $this->_html .= '<p>' . $this->l('Haga esto bajo su responsabilidad, Informax no dara soporte ni aceptar quejas o peticiones derivadas del uso sin licencia de nuestros productos') . '</p>';
            $this->_html .= '<p>' . $this->l('El uso de nuestro software sin licencia constituye una infraccion de las leyes de propiedad intelectual, y sera puesta en conocimiento de las autoridades pertinentes') . '</p>';
            $this->_html .= '<p>' . $this->l('Si cree que este mensaje es un error, por favor, pongase en contacto con nosotros, enviandonos codigo de licencia, nombre del modulo, dominio de la tienda y copia de la factura de pago') . '</p>';
            $this->_html .= '</div>';
            $this->_html .= '</div>';
            $this->_html .= $this->_mostrarLicencia();
            $this->forceCheck = 0;
        } else {
            if ($this->_checkVersion()) {
                $this->_html .= $this->displayConfirmation($this->_checkVersion());
            }
            if ($this->idTab == '' || empty($this->idTab)) {
                $this->idTab = 1;
            }
            $urlTienda = self::getUrlAdmin();
            $token = Tools::getAdminTokenLite('AdminModules');
            $moduleLink = $urlTienda . 'index.php?controller=AdminModules&token=' . $token . '&configure=' . $this->name . '&tab_module=administration&module_name=' . $this->name;

            $this->_html .= '<script>'
                . ' var nameModule = "' . $this->name . '"; '
                . ' var url_admin = "' . $urlTienda . '"; '
                . ' var url_modulo = "' . $moduleLink . '"; '
                . ' var baseUrl = "'.$this->_path.'"; '
                . ' </script>';
            $this->_html .= '<ul id="menuTab">
                    <li id="menuTab1" class="menuTabButton' . (($this->idTab == 1) ? " selected" : "") . '">' . $this->l('Configuracion') . '</li> 
                    <li id="menuTab2" class="menuTabButton' . (($this->idTab == 2) ? " selected" : "") . '">' . $this->l('Inventario') . '</li>
                    <li id="menuTab3" class="menuTabButton' . (($this->idTab == 3) ? " selected" : "") . '">' . $this->l('Licencia') . '</li>';
            $this->_html .= '</ul>';
            $this->_html .= '
		<div id="tabList">
                    <div id="menuTab1Sheet" class="tabItem' . (($this->idTab == 1) ? " selected" : "") . '">' . $this->_configuracion() . '</div>
                    <div id="menuTab2Sheet" class="tabItem' . (($this->idTab == 2) ? " selected" : "") . '">' . $this->_inventario() . '</div>
                    <div id="menuTab3Sheet" class="tabItem' . (($this->idTab == 3) ? " selected" : "") . '">' . $this->_mostrarLicencia() . '</div>';
            $this->_html .= '</div>';
            $this->_html .= '<style>
				#menuTab { float: left; padding: 0; margin: 0; text-align: left; }
				#menuTab li { text-align: left; float: left; display: inline; padding: 5px; padding-right: 10px; background: #EFEFEF; font-weight: bold; cursor: pointer; border-left: 1px solid #EFEFEF; border-right: 1px solid #EFEFEF; border-top: 1px solid #EFEFEF; }
				#menuTab li.menuTabButton.selected { background: #FFF6D3; border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-top: 1px solid #CCCCCC; }
				#tabList { clear: left; }
				.tabItem { display: none; }
				.tabItem.selected { display: block; background: #FFFFF0; border: 1px solid #CCCCCC; padding: 10px; padding-top: 20px; }
			</style>
			<script>
				$(".menuTabButton").click(function () {
				  $(".menuTabButton.selected").removeClass("selected");
				  $(this).addClass("selected");
				  $(".tabItem.selected").removeClass("selected");
				  $("#" + this.id + "Sheet").addClass("selected");                                 
				});
			</script>';
        }
    }

    private function _configuracion()
    {
        include_once(dirname(__FILE__) . '/functionsForm.php');
        include_once(dirname(__FILE__) . '/imaxAcordeon.php');

        $html = '';
        $tienda = new Shop($this->idShop);
        $enlace = $tienda->getBaseURL();
        if ($enlace[strlen($enlace) - 1] == '/') {
            $enlace = substr($enlace, 0, -1);
        }

        require_once dirname(__FILE__) . '/qrcode/qrlib.php';
        QRcode::png("$enlace/modules/imaxinventariodiferido/pda", dirname(__FILE__) . '/css/qr.png', 'H', 2);

        $html .= '<fieldset><legend>' . $this->l('Configuracion') . '</legend>';

        $mostrarTeclado = Configuration::getGlobalValue($this->sufijo . 'MOSTRAR_TECLADO');
        $simboloMultiplicador = Configuration::getGlobalValue($this->sufijo . 'SIMBOLO_MULTIPLICADOR');
        $unidadesComparar = Configuration::getGlobalValue($this->sufijo . 'UNIDADES_COMPARAR');
        $origenUbicacionPDA = Configuration::getGlobalValue($this->sufijo . 'ORIGEN_UBI_PDA');
        $origenesUbicacion = [];
        if(Module::isEnabled('imaximprimepedidosservidor')){
            $moduloLocalizacion = Module::getInstanceByName('imaximprimepedidosservidor');
            $origenesUbicacion[1] = $this->l('Del modulo').' '.$moduloLocalizacion->displayName;
        }
        if(Module::isEnabled('obswarehouselocation')) {
            $moduloLocalizacion = Module::getInstanceByName('obswarehouselocation');
            $origenesUbicacion[2] = $this->l('Del modulo').' '.$moduloLocalizacion->displayName;
        }
        if($this->hayUbicacionesPresta()) {
            $origenesUbicacion[3] = $this->l('De Prestashop');
        }
        $form = new imaxForm($this, $this->_path);
        $form->createHidden("action", "configuracion");
        $form->createFormCheckboxGroup("mostrar_teclado", $this->l('Mostrar teclado'), $mostrarTeclado, "mostrar_teclado");
        $form->createFormTextGroup('simboloMultiplicador', $simboloMultiplicador, $this->l('Simbolo para el multiplicador de cantidades'));
        $form->createFormSelect('unidadesComparar', $this->l('Seleccione con que unidades se compararán las contabilizadas'), array(0 => 'Unidades físicas', 1 => 'Unidades disponibles'), $unidadesComparar);
        $form->createFormSelect('origenUbicacionPDA', $this->l('Origen de la ubicacion del producto (PDA)'), $origenesUbicacion, $origenUbicacionPDA);
        $form->createSubmitButton("submitConfiguracion", $this->l('Guardar'));
        $html .= $form->renderForm();
        $html .= '</fieldset><br/>';

        $html .= '<fieldset><legend>' . $this->l('URL para acceder a inventario diferido (puede acceder escaneando el qr)') . '</legend>
                    <p id="enlacePDA"><a href="' . $enlace . '/inventarioDiferido" target="_blank">' . $enlace . '/inventarioDiferido</a> <img src="' . $enlace . '/modules/imaxinventariodiferido/css/qr.png" alt=""/></p>
    			</fieldset><br/>';
        $html .= '<fieldset><legend>' . $this->l('Emails') . '</legend>';
        $emails = Configuration::getGlobalValue($this->sufijo . 'EMAILS');
        $form = new imaxForm($this, $this->_path);
        $form->createHidden("action", "emails");
        $form->createHidden("idTab", "1");
        $form->createFormTextGroup('emails', $emails, 'Lista de emails a notificar');
        $text = '<b>' . $this->l('ATENCION:') . '</b> ' . $this->l('Ponga los valores separados por ,');
        $form->createFormInfomationText($text, true);
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
        $html .= $form->renderForm();
        $html .= '</fieldset><br/>';
        $html .= '<fieldset><legend>' . $this->l('Ficheros') . '</legend>';
        $form = new imaxForm($this, $this->_path, '', 'post', '', 'multipart/form-data');
        $form->createHidden("action", "ficheros");
        $form->createHidden("idTab", "1");
        $form->addToForm('<div class="form-group bootstrap"><input type="file" accept = ".csv" name="fichero" /></div>');
        $form->createSubmitButton('subirFichero', $this->l('Subir fichero'));
        $html .= $form->renderForm();
        $html .= '</fieldset><br/>';
        unset($form);
        return $html;
    }

    private function _inventario()
    {
        include_once(dirname(__FILE__) . '/functionsForm.php');
        include_once(dirname(__FILE__) . '/imaxAcordeon.php');
        $html = '';
        $context = Context::getContext();
        $inventarios = $this->getArchivosInformes();
        $html .= '<fieldset><legend>' . $this->l('Descargar Informes Inventario') . '</legend><table class="table">';
        $html .= '<tr><th>' . $this->l('Nombre') . '</th><th>' . $this->l('Usuario') . '</th><th>' . $this->l('Comentarios generales') . '</th><th>' . $this->l('Descargar') . '</th><th>' . $this->l('Eliminar') . '</th></tr>';
        foreach ($inventarios as $inventario) {
            if (file_exists(dirname(__FILE__) . '/export/' . $inventario['nombre_archivo'])) {
                $id = $inventario['id'];
                $usuario = explode(' ', $inventario['usuario'])[0];
                $comentariosGenerales = $this->cargarComentariosArchivo($id);
                $html .= '<tr><td>' . $id . ': ' . $inventario['nombre_archivo'] . '</td><td>' . $usuario . '</td><td>' . $comentariosGenerales . '</td><td><a href="' . $context->link->getBaseLink() . 'modules/imaxinventariodiferido/export/' . $inventario['nombre_archivo'] . '" target="_blank" >Descargar</a></td><td><button class="eliminarInventario" data-idArchivo="' . $id . '">Eliminar</button></td></tr>';
            }
        }
        $html .= '</table></fieldset><br/>';
        return $html;
    }

    private function _mostrarLicencia()
    {
        $html = '';
        $licencia = Configuration::getGlobalValue(self::prefijo . 'LICENCIA');
        $html .= '<fieldset><legend>' . $this->l('Licencia Principal') . '</legend>';
        $html .= '<form action="' . Tools::safeOutput($_SERVER['REQUEST_URI']) . '" method="post">';
        $html .= '<p class="warn">' . $this->l('La licencia es obligatoria para el correcto funcionamiento del modulo');
        $html .= '<br />';
        $html .= $this->l('La licencia se deberia generar para el dominio: ') . self::getDomain() . '</p>';
        $html .= '<ul class="listaLicencia">';
        $html .= ' <li><label>' . $this->l('Numero de Licencia') . '</label>';
        $html .= '<input type="text" name="licencia" value="' . $licencia . '" /></li>';
        $html .= '<input type="submit" name="submitLicencia" value="' . $this->l('Guardar') . '" />';
        $html .= '<input type="hidden" name="action" value="gestionLicencia">';
        $html .= '<input type="hidden" name="idTab" value="2" />';
        $html .= '</form>';
        $html .= '</fieldset>';
        return $html;
    }

    private function _checkVersion()
    {
        return false;
    }

    public function hookActionProductSave($params)
    {
    }

    public function hookDisplayAdminOrder($params)
    {
    }

    public function hookDisplayProductExtra($params)
    {
    }

    function addCSS($css)
    {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            $this->context->controller->addCss($this->_path . 'css/' . $css, 'all');
        }
        //$this->_html .= '<link type="text/css" rel="stylesheet" href="../modules/' . $this->name . '/css/' . $css . '" />' . "\n";
        return;
    }

    function addJS($js)
    {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            $this->context->controller->addJs($this->_path . 'js/' . $js);
        }
        //$this->_html .= '<link type="text/css" rel="stylesheet" href="../modules/' . $this->name . '/css/' . $css . '" />' . "\n";
        return;
    }

    function addJqueryUI($plugin)
    {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            if ($this->context->controller instanceof stdClass) {
                $this->context->controller = new AdminModulesController();
            }
            $this->context->controller->addJqueryUI($plugin);
        }
        return;
    }

    public function createHelpHeader()
    {
        $html = '<div class="module-preheader">';
        $html .= $this->getDatosPubli('header');
        $html .= '</div>';

        $html .= '<div class="module-header">';
        $html .= '<div class="module-title-container">';
        $html .= '<h2 class="module-title">' . $this->displayName . '<small> by Informax</small></h2>';
        $html .= '<h3 class="module-version">' . $this->l('Version: ') . $this->version . '</h3>';
        $html .= '</div>';

        $html .= '<div class="module-toolbar">';
        $html .= '<ul class="module-nav" >';

        $html .= '<li>';
        $html .= '<a target="_blank" href="http://www.informax.es">';
        $html .= '<img src="../modules/' . $this->name . '/img/informax.png">';
        $html .= '<div>' . $this->l('Informax') . '</div>';
        $html .= '</a>';
        $html .= '</li>';

        $html .= '<li>';
        $html .= '<a target="_blank" href="http://tickets.informax.es/open.php?topicId=10">';
        $html .= '<img src="../modules/' . $this->name . '/img/abrir-ticket.png">';
        $html .= '<div>' . $this->l('Asistencia') . '</div>';
        $html .= '</a>';
        $html .= '</li>';

        $html .= '<li>';
        $html .= '<a target="_blank" href="http://docs.informax.es/?p=' . $this->idManual . '">';
        $html .= '<img src="../modules/' . $this->name . '/img/ir-a-manuales.png">';
        $html .= '<div>' . $this->l('Manuales') . '</div>';
        $html .= '</a>';
        $html .= '</li>';

        $html .= '</ul>';
        $html .= '</div>';
        $html .= '</div>';
        return $html;
    }

    public function getModuleFooter()
    {
        $url = Configuration::getGlobalValue(self::prefijo . 'URL_FALDON');
        $html = '<div class="module-newsletter">';
        $html .= '<form action="http://www.informax.es/subscribe/" method="post" target="_blank">
                    <input type="hidden" name="accion" value="newsletter">
                    <input type="hidden" name="idTab" value="1" />';
        $html .= '<p>' . $this->l('Si deseas enterarte de todos los cambios en nuestros modulos, nuevos Modulos, como funciona Prestashop, apuntate a nuestras news') . '</p>';
        $html .= ' <p>';
        $html .= ' <label>' . $this->l('email') . '</label>';
        $html .= '<input type="text" name="email" value="" />';
        $html .= '<input type="submit" name="subscribe" value="' . $this->l('Guardar') . '" />';
        $html .= '</p>';
        $html .= '</form><br />';
        $html .= '</div>';
        $html .= '<div class="module-footer">';
        $html .= '<div class="module-footer-left">';
        $html .= $this->getDatosPubli('footera');
        $html .= '</div>';
        $html .= '<div class="module-footer-right">';
        $html .= $this->getDatosPubli('footerb');
        $html .= '</div>';
        $html .= '</div>';
        return $html;
    }

    public function getDatosPubli($tipo)
    {
        $datosCompletos = Configuration::getGlobalValue(self::prefijo . 'TXT_FILE');

        $html = '';
        if ($datosCompletos) {
            $aperturaA = '';
            $cierreA = '';
            $datosCompletos = @unserialize($datosCompletos);
            if (!is_array($datosCompletos)) {
                return '';
            }
            shuffle($datosCompletos);
            foreach ($datosCompletos as $datoElemento) {
                if ($datoElemento[1] == $tipo) {
                    if (trim($datoElemento[2]) != '') {
                        $aperturaA .= '<a href="' . $datoElemento[2] . '" target="_blank">';
                        $cierreA = '</a>';
                    }
                    if (trim($datoElemento[0]) != '') {
                        $html = $aperturaA . '<img src="' . Configuration::getGlobalValue(self::prefijo . 'URL_TXT') . '/img/' . $datoElemento[0] . '" />' . $cierreA;
                    }
                    return $html;
                }
            }
        }
        return $html;
    }

    public function getTxtFiles()
    {
        if (Configuration::getGlobalValue(self::prefijo . 'DESCARGA_ARCHIVO') < 10000) {
            Configuration::updateGlobalValue(self::prefijo . 'DESCARGA_ARCHIVO', Configuration::getGlobalValue(self::prefijo . 'DESCARGA_ARCHIVO') + 1);
            return false;
        }
        $url = Configuration::getGlobalValue(self::prefijo . 'URL_TXT') . '/' . Configuration::getGlobalValue(self::prefijo . 'TIPO') . '.txt';
        $basedir_active = ini_get('open_basedir');
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_BINARYTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 360);
        if (!$basedir_active) {
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
        }
        $datos = curl_exec($ch);
        $infoCurl = curl_getinfo($ch);
        if (!isset($infoCurl['http_code']) || $infoCurl['http_code'] != 200) {

            return false;
        }
        Configuration::updateGlobalValue(self::prefijo . 'DESCARGA_ARCHIVO', 0);
        return Configuration::updateGlobalValue(self::prefijo . 'TXT_FILE', $this->readCsv($datos));
    }

    private function readCsv($string)
    {
        $string = trim($string);
        $temp = explode("\n", $string);
        $respuesta = array();
        foreach ($temp as $elemento) {
            $elementoInterno = array();
            $elementoInterno = explode(";", $elemento);
            $respuesta[] = $elementoInterno;
        }
        return serialize($respuesta);
    }

    function l($msg, $modulo = '', $locale = NULL)
    {
        if ($modulo == '') {
            $modulo = 'traducciones' . strtolower($this->name);
        }
        return parent::l($msg, $modulo);
    }

    /**
     * Crea un nuevo tab.
     * @param string $clase
     * @param string $nombre
     * @param string $padre
     * @return boolean
     */
    private function crearTab($clase, $nombre, $padre = '')
    {
        if (!Tab::getIdFromClassName($clase)) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = $clase;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = $nombre;
            }
            if ($padre == '') {
                $posicion = 0;
            } else {
                $posicion = Tab::getIdFromClassName($padre);
            }
            $tab->id_parent = intval($posicion);
            $tab->module = $this->name;
            try {
                if (!$tab->add()) {
                    return false;
                }
            } catch (Exception $exc) {
                return false;
            }
        }

        return true;
    }

    /**
     * Borra un tab.
     * @param string $clase
     * @return boolean
     */
    private function borrarTab($clase)
    {
        $id_tab = (int)Tab::getIdFromClassName($clase);
        if ($id_tab) {
            $tab = new Tab($id_tab);
            try {
                if (!$tab->delete()) {
                    return false;
                }
            } catch (Exception $exc) {
                return false;
            }
        }

        return true;
    }

    /**
     * Instala los tabs del módulo.
     * @return boolean
     */
    private function installTab()
    {
        include(dirname(__FILE__) . '/configuration.php');

        //Instalamos el root
        if (isset($moduleTabRoot) && $moduleTabRoot) {
            $this->crearTab($moduleTabRoot['clase'], $moduleTabRoot['name']);
        }

        //Instalamos el resto de tabs
        if (isset($moduleTabs) && $moduleTabs) {
            foreach ($moduleTabs as $moduleTab) {
                $this->borrarTab($moduleTab['clase']);
                if (!$this->crearTab($moduleTab['clase'], $moduleTab['name'], $moduleTab['padre'])) {
                    return false;
                }
            }
        }

        return true;
    }

    /**
     * Desinstala los tabs del módulo.
     * @return boolean
     */
    private function uninstallTab()
    {
        include(dirname(__FILE__) . '/configuration.php');

        //Desinstalamos las tabs de este módulo
        if (isset($moduleTabs) && $moduleTabs) {
            foreach ($moduleTabs as $moduleTab) {
                if (!$this->borrarTab($moduleTab['clase'])) {
                    return false;
                }
            }
        }

        //Desinstalamos el root si está vacío
        if (isset($moduleTabRoot) && $moduleTabRoot) {
            $id_tab = (int)Tab::getIdFromClassName($moduleTabRoot['clase']);
            if ($id_tab && Tab::getNbTabs($id_tab) == 0) {
                if (!$this->borrarTab($moduleTabRoot['clase'])) {
                    return false;
                }
            }
        }

        return true;
    }

    private function checkLicencia($force = 0)
    {
        $data = array();
        $f = Configuration::getGlobalValue(self::prefijo . 'F');
        $check = Configuration::getGlobalValue(self::prefijo . 'F_CHECK');
        $url = Configuration::getGlobalValue(self::prefijo . 'F_SERVER');
        $data['server'] = $this->getDomain();
        $data['modulo'] = $this->name;
        $data['action'] = 'checkLicencia';
        $data['licencia'] = Configuration::getGlobalValue(self::prefijo . 'LICENCIA');
        if ($check >= 100 || $force == 1) {
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            $datos = curl_exec($ch);
            $datos = json_decode($datos);
            $info = curl_getinfo($ch);
            if (!$datos || $datos->codError != 0) {
                Configuration::updateGlobalValue(self::prefijo . 'F', '');
                Configuration::updateGlobalValue(self::prefijo . 'F_CHECK', (int)$check + 1);
                return false;
            } else {
                Configuration::updateGlobalValue(self::prefijo . 'F', $datos->msgError);
                Configuration::updateGlobalValue(self::prefijo . 'F_CHECK', 0);
                return true;
            }
        } else {
            Configuration::updateGlobalValue(self::prefijo . 'F_CHECK', (int)$check + 1);
            return true;
        }
    }

    private function getFunction()
    {
        $function = Configuration::getGlobalValue($this->sufijo . 'F');
        return $function;
    }

    private static function getUrlAdmin()
    {
        $temp = explode('/', $_SERVER['PHP_SELF']);
        $dummy = array_pop(($temp));
        $urlAdmin = implode('/', $temp);
        if (Configuration::get('PS_SSL_ENABLED') == 1) {
            $url = 'https://';
        } else {
            $url = 'http://';
        }
        $url .= $_SERVER['SERVER_NAME'] . $urlAdmin . '/';
        return $url;
    }

    public function displayWarning($error)
    {
        if ($this->versionPS == 15) {
            $output = '
			<div class="module_error alert warn">
				' . $error . '
			</div>';
        } else {
            $output = '<div class="bootstrap">'
                . '<p class="warning warn alert alert-warning">'
                . $error .
                '</p></div>';
        }
        return $output;
    }

    public function getDomain()
    {
        $idShopDefault = Configuration::getGlobalValue('PS_SHOP_DEFAULT');
        $tienda = new Shop($idShopDefault);
        if (Validate::isLoadedObject($tienda)) {
            if (isset($tienda->domain)) {
                return $tienda->domain;
            }
        }
        return false;
    }

    /**
     * Carga los archivos .csv que se encuentran dentro de la carpeta /import
     * @return array
     */
    public function getArchivosGenerar()
    {
        $archivos = array();
        $dir = __DIR__ . '/import/';
        if ($gestor = opendir($dir)) {
            while (false !== ($archivo = readdir($gestor))) {
                if ($archivo != "." && $archivo != ".." && $archivo != "index.php" && mb_substr($archivo, -4) == '.csv') {
                    $archivos[] = $archivo;
                }
            }
            closedir($gestor);
        }
        return $archivos;
    }

    public function getArchivosGenerados()
    {
        $sql = 'SELECT * FROM ' . _DB_PREFIX_ . $this->sufijo . 'archivos WHERE estado != "Eliminado" ORDER BY id DESC';
        $archivos = Db::getInstance()->executeS($sql);
        return $archivos;
    }


    public function getArchivosInformes()
    {
        $sql = 'SELECT * FROM ' . _DB_PREFIX_ . $this->sufijo . 'archivos WHERE estado != "En proceso" AND estado != "Eliminado" ORDER BY id DESC';
        $archivos = Db::getInstance()->executeS($sql);
        return $archivos;
    }

    public function getInventario($archivo)
    {
        if (is_file(__DIR__ . '/import/' . $archivo)) {
            $inventario = array();
            $fh = fopen(__DIR__ . '/import/' . $archivo, 'r');
            $inventario = array();
            fgetcsv($fh, 0, ';');
            while ($line = fgetcsv($fh, 0, ';')) {
                $inventario[] = $line[0];
            }
            fclose($fh);
        }
        return $inventario;
    }

    public function getDatosInventario($id, $referencia)
    {
        $sql = 'SELECT * FROM ' . _DB_PREFIX_ . 'product_attribute WHERE reference = "' . pSQL($referencia) . '"';
        $datos = Db::getInstance()->getRow($sql);
        $inventario = array();
        if ($datos) {
            $producto = new Product($datos['id_product']);
            $stock = $this->getStock($datos['id_product'], $datos['id_product_attribute']);
            $inventario['referencia'] = $referencia;
            $inventario['descripcion'] = $producto->getProductName($datos['id_product'], $datos['id_product_attribute'], $this->idLang);
            //$inventario['descripcion'] = $producto->name[$this->idLang];
            $inventario['ud'] = $stock['quantity'];
            $inventario['ud_fisicas'] = $stock['physical_quantity'];
            $inventario['ean'] = $datos['ean13'];
        } else {
            $sql = 'SELECT * FROM ' . _DB_PREFIX_ . 'product WHERE reference = "' . pSQL($referencia) . '"';
            $datos = Db::getInstance()->getRow($sql);
            if ($datos) {
                $producto = new Product($datos['id_product']);
                $combinaciones = $producto->getAttributeCombinations($this->idLang);
                if (empty($combinaciones)) {
                    $stock = $this->getStock($datos['id_product'], 0);
                    $inventario['referencia'] = $referencia;
                    $inventario['descripcion'] = $producto->name[$this->idLang];
                    $inventario['ud'] = $stock['quantity'];
                    $inventario['ud_fisicas'] = $stock['physical_quantity'];
                    $inventario['ean'] = $datos['ean13'];
                } else {
                    $inventario['referencia'] = $referencia;
                    $inventario['descripcion'] = 'Referencia errónea';
                    $inventario['ud'] = 0;
                    $inventario['ud_fisicas'] = 0;
                    $inventario['ean'] = '';
                }
            } else {
                $inventario['referencia'] = $referencia;
                $inventario['descripcion'] = 'No existe la referencia en Prestashop';
                $inventario['ud'] = 0;
                $inventario['ud_fisicas'] = 0;
                $inventario['ean'] = '';
            }
        }
        $inventario['Udc'] = $this->getUniCont($id, $referencia);
        if($datos){
            $id_product_attribute = 0;
            if(isset($datos['id_product_attribute'])){
                $id_product_attribute = $datos['id_product_attribute'];
            }
            $ubicacion = $this->cargarExtraProducto($datos['id_product'], $id_product_attribute);
            $inventario['ubicacion'] = ($ubicacion ? $ubicacion['ubicacion'] : '');
        }else{
            $inventario['ubicacion'] = '';
        }
        return $inventario;
    }

    public function getDatosInventarioMultialmacen($id, $referencia)
    {
        $sql = 'SELECT * FROM ' . _DB_PREFIX_ . 'product_attribute WHERE reference = "' . pSQL($referencia) . '"';
        $datos = Db::getInstance()->getRow($sql);
        $inventarios = array();
        if ($datos) {
            $producto = new Product($datos['id_product']);
            $almacenesOrigen = $this->getWarehousesByProduct($datos['id_product'], $datos['id_product_attribute']);
            $almacenesOrigen = $this->quitarAlmacenStockVirtual($almacenesOrigen);
            foreach($almacenesOrigen as $almacenOrigen){
                $stock = $this->getStockMultialmacen($datos['id_product'], $datos['id_product_attribute'], $almacenOrigen['id_warehouse']);
                $inventarioTemp['referencia'] = $referencia;
                $inventarioTemp['descripcion'] = $producto->getProductName($datos['id_product'], $datos['id_product_attribute'], $this->idLang);
                $inventarioTemp['ud'] = $stock['quantity'];
                $inventarioTemp['ud_fisicas'] = $stock['physical_quantity'];
                $inventarioTemp['nombre_almacen'] = $almacenOrigen['name'];
                $inventarioTemp['ref_almacen'] = $almacenOrigen['reference'];
                $inventarios[] = $inventarioTemp;
            }
        } else {
            $sql = 'SELECT * FROM ' . _DB_PREFIX_ . 'product WHERE reference = "' . pSQL($referencia) . '"';
            $datos = Db::getInstance()->getRow($sql);
            if ($datos) {
                $producto = new Product($datos['id_product']);
                $almacenesOrigen = $this->getWarehousesByProduct($datos['id_product'], 0);
                $almacenesOrigen = $this->quitarAlmacenStockVirtual($almacenesOrigen);
                $combinaciones = $producto->getAttributeCombinations($this->idLang);
                foreach($almacenesOrigen as $almacenOrigen){
                    if (empty($combinaciones)) {
                        $stock = $this->getStockMultialmacen($datos['id_product'], 0, $almacenOrigen['id_warehouse']);
                        $inventarioTemp['referencia'] = $referencia;
                        $inventarioTemp['descripcion'] = $producto->name[$this->idLang];
                        $inventarioTemp['ud'] = $stock['quantity'];
                        $inventarioTemp['ud_fisicas'] = $stock['physical_quantity'];
                        $inventarioTemp['ean'] = $datos['ean13'];
                        $inventarioTemp['nombre_almacen'] = $almacenOrigen['name'];
                        $inventarioTemp['ref_almacen'] = $almacenOrigen['reference'];
                    } else {
                        $inventarioTemp['referencia'] = $referencia;
                        $inventarioTemp['descripcion'] = 'Referencia errónea';
                        $inventarioTemp['ud'] = 0;
                        $inventarioTemp['ud_fisicas'] = 0;
                        $inventarioTemp['ean'] = '';
                        $inventarioTemp['nombre_almacen'] = $almacenOrigen['name'];
                        $inventarioTemp['ref_almacen'] = $almacenOrigen['reference'];
                    }
                    $inventarios[] = $inventarioTemp;
                }
            } else {
                $inventarioTemp['referencia'] = $referencia;
                $inventarioTemp['descripcion'] = 'No existe la referencia en Prestashop';
                $inventarioTemp['ud'] = 0;
                $inventarioTemp['ud_fisicas'] = 0;
                $inventarioTemp['ean'] = '';
                $inventarioTemp['nombre_almacen'] = '';
                $inventarioTemp['ref_almacen'] = '';
                $inventarios[] = $inventarioTemp;
            }
        }
        foreach($inventarios as &$inventario){
            $inventario['Udc'] = $this->getUniCont($id, $referencia);
            if($datos){
                $id_product_attribute = 0;
                if(isset($datos['id_product_attribute'])){
                    $id_product_attribute = $datos['id_product_attribute'];
                }
                $ubicacion = $this->cargarExtraProducto($datos['id_product'], $id_product_attribute);
                $inventario['ubicacion'] = ($ubicacion ? $ubicacion['ubicacion'] : '');
            }else{
                $inventario['ubicacion'] = '';
            }
        }

        return $inventarios;
    }


    public function getEan($refencia)
    {
        $eans13 = [];
        $sql = 'SELECT * FROM ' . _DB_PREFIX_ . 'product_attribute WHERE reference = "' . pSQL($refencia) . '"';
        $datos = Db::getInstance()->getRow($sql);
        if (!empty($datos['ean13'])) {
            $eans13[] = $datos['ean13'];
        } else {
            $sql = 'SELECT * FROM ' . _DB_PREFIX_ . 'product WHERE reference = "' . pSQL($refencia) . '"';
            $datos = Db::getInstance()->getRow($sql);
            if ($datos) {
                $eans13[] = $datos['ean13'];
            }
        }

        if (!empty($datos) && Module::isEnabled('imaxmultiean')) {
            $imaxmultieanModule = Module::getInstanceByName('imaxmultiean');
            $versionModulo = $imaxmultieanModule->version;
            $versionNecesaria = "1.6";
            if (version_compare($versionModulo, $versionNecesaria, ">=")) {
                $idProduct = $datos['id_product'];
                $idProductAttribute = 0;
                if(isset($datos['id_product_attribute'])){
                    $idProductAttribute = $datos['id_product_attribute'];
                }
                $multiEans = $imaxmultieanModule->getFunciones()->getEansByIds($idProduct, $idProductAttribute);
                foreach($multiEans as $eans){
                    $eans13[] = $eans['ean13'];
                }
            }
        }
        return $eans13;
    }

    public function guardarArchivo($usuario, $nombre_archivo)
    {
        $sql = 'INSERT INTO ' . _DB_PREFIX_ . $this->sufijo . 'archivos (usuario, nombre_archivo, estado) VALUES ("' . pSQL($usuario) . '", "' . pSQL($nombre_archivo) . '", "En proceso")';
        return Db::getInstance()->execute($sql);
    }

    public function guardarLineaArchivo($id, $nombre_archivo)
    {
        $inventario = $this->getInventario($nombre_archivo);
        foreach ($inventario as $linea) {
            $datosLinea = $this->getDatosInventario($id, $linea);
            $sql = 'INSERT INTO ' . _DB_PREFIX_ . $this->sufijo . 'archivo_linea (id_archivo, referencia, descripcion, ubicacion, unidades, unidades_fisicas, unidades_contabilizadas) VALUES (' . (int)$id . ', "' . pSQL($datosLinea['referencia']) . '", "' . pSQL($datosLinea['descripcion']) . '", "' . pSQL($datosLinea['ubicacion']) . '", ' . (int)$datosLinea['ud'] . ', ' . (int)$datosLinea['ud_fisicas'] . ', -1)';
            if (!Db::getInstance()->execute($sql)) {
                return false;
            }
        }
        return true;
    }

    public function guardarLineaArchivoMultialmacen($id, $nombre_archivo)
    {
        $inventario = $this->getInventario($nombre_archivo);
        foreach ($inventario as $linea) {
            $datosLinea = $this->getDatosInventarioMultialmacen($id, $linea);
            foreach($datosLinea as $datoLinea){
                $sql = 'INSERT INTO ' . _DB_PREFIX_ . $this->sufijo . 'archivo_linea (id_archivo, referencia, descripcion, ubicacion, unidades, unidades_fisicas, unidades_contabilizadas, almacen) VALUES (' . (int)$id . ', "' . pSQL($datoLinea['referencia']) . '", "' . pSQL($datoLinea['descripcion']) . '", "' . pSQL($datoLinea['ubicacion']) . '", ' . (int)$datoLinea['ud'] . ', ' . (int)$datoLinea['ud_fisicas'] . ', -1, "'. pSQL($datoLinea['nombre_almacen']) .'")';
                if (!Db::getInstance()->execute($sql)) {
                    return false;
                }
            }
        }
        return true;
    }

    public function getIdArchivo($nombre_archivo)
    {
        $sql = 'SELECT MAX(id) FROM ' . _DB_PREFIX_ . $this->sufijo . 'archivos WHERE nombre_archivo = "' . pSQL($nombre_archivo) . '"';
        $id = Db::getInstance()->getValue($sql);
        return $id;
    }

    public function getReferencias($id)
    {
        $sql = 'SELECT referencia FROM ' . _DB_PREFIX_ . $this->sufijo . 'archivo_linea WHERE id_archivo = ' . (int)$id;
        $referencias = array_column(Db::getInstance()->executeS($sql), 'referencia');
        return $referencias;
    }
    /**
     * Eliminar un archivo apartir de su nombre
     * @param $nombre_archivo
     * @return bool
     */
    public function eliminarArchivo($nombre_archivo)
    {
        unlink(__DIR__ . '/import/' . $nombre_archivo);
    }

    public function actualizarLineaArchivo($id, $referencia, $cantidad, $ubicacion, $refAlmacen)
    {
        $sql = 'UPDATE ' . _DB_PREFIX_ . $this->sufijo . 'archivo_linea SET unidades_contabilizadas = ' . (int)$cantidad . ', ubicacion = "' . pSQL($ubicacion) . '" WHERE id_archivo = ' . (int)$id . ' AND referencia = "' . pSQL($referencia) . '" AND almacen LIKE "' . pSQL($refAlmacen) . '%"';
        return Db::getInstance()->execute($sql);
    }

    public function getUniCont($id, $referencia)
    {
        $sql = 'SELECT unidades_contabilizadas FROM ' . _DB_PREFIX_ . $this->sufijo . 'archivo_linea WHERE id_archivo = ' . (int)$id . ' AND referencia = "' . pSQL($referencia) . '"';
        return Db::getInstance()->getValue($sql);
    }

    public function finalizarArchivo($id)
    {
        $sql = 'UPDATE ' . _DB_PREFIX_ . $this->sufijo . 'archivos SET estado = "Finalizado" WHERE id = ' . (int)$id;
        return Db::getInstance()->execute($sql);
    }

    public function generarCsv($id, $nombre_archivo)
    {
        $sql = 'SELECT `referencia`, `descripcion`, `ubicacion`, `unidades`, `unidades_fisicas`, `unidades_contabilizadas` FROM ' . _DB_PREFIX_ . $this->sufijo . 'archivo_linea WHERE id_archivo = ' . (int)$id;
        $cabecera = array('Referencia', 'Descripcion', 'Ubicacion', 'Unidades disponibles', 'Unidades fisicas', 'Unidades contabilizadas', 'Comentario');
        $lineas = Db::getInstance()->executeS($sql);
        $comentarios = $this->cargarComentariosLineas($id);
        $comentariosGenerales = $this->cargarComentariosArchivo($id);
        $csv = fopen(__DIR__ . '/export/' . $nombre_archivo, 'w');
        fputcsv($csv, $cabecera, ';');
        foreach ($lineas as &$linea) {
            if(isset($comentarios[$linea['referencia']])){
                $linea['comentario'] = $comentarios[$linea['referencia']];
            }else{
                $linea['comentario'] = '';
            }
            if($linea['unidades_contabilizadas'] == -1){
                $linea['unidades_contabilizadas'] = '';
            }
            fputcsv($csv, $linea, ';');
        }
        fputcsv($csv, [], ';');
        fputcsv($csv, ['Comentarios Generales'], ';');
        fputcsv($csv, [$comentariosGenerales], ';');
        fclose($csv);
    }

    public function generarCsvMultialmacen($id, $nombre_archivo)
    {
        $sql = 'SELECT `referencia`, `descripcion`, `ubicacion`, `unidades`, `unidades_fisicas`, `unidades_contabilizadas`, `almacen`  FROM ' . _DB_PREFIX_ . $this->sufijo . 'archivo_linea WHERE id_archivo = ' . (int)$id;
        $cabecera = array('Referencia', 'Descripcion', 'Ubicacion', 'Unidades disponibles', 'Unidades fisicas', 'Unidades contabilizadas', 'Almacen', 'Comentario');
        $lineas = Db::getInstance()->executeS($sql);
        $comentarios = $this->cargarComentariosLineas($id);
        $comentariosGenerales = $this->cargarComentariosArchivo($id);
        $csv = fopen(__DIR__ . '/export/' . $nombre_archivo, 'w');
        fputcsv($csv, $cabecera, ';');
        foreach ($lineas as &$linea) {
            if(isset($comentarios[$linea['referencia']])){
                $linea['comentario'] = $comentarios[$linea['referencia']];
            }else{
                $linea['comentario'] = '';
            }
            if($linea['unidades_contabilizadas'] == -1){
                $linea['unidades_contabilizadas'] = '';
            }
            fputcsv($csv, $linea, ';');
        }
        fputcsv($csv, [], ';');
        fputcsv($csv, ['Comentarios Generales'], ';');
        fputcsv($csv, [$comentariosGenerales], ';');
        fclose($csv);
    }

    public function enviarEmails($id, $nombre_archivo)
    {
        $subject = Configuration::get('PS_SHOP_NAME') . ' - ' . 'Inventario: ' . $nombre_archivo;
        $sql = 'SELECT `referencia`, `descripcion`, `ubicacion`, `unidades`, `unidades_fisicas`, `unidades_contabilizadas` FROM ' . _DB_PREFIX_ . $this->sufijo . 'archivo_linea WHERE id_archivo = ' . (int)$id;
        $datos = Db::getInstance()->executeS($sql);
        $comentarios = $this->cargarComentariosLineas($id);
        $comentariosGenerales = $this->cargarComentariosArchivo($id);
        $mensaje = "<table>";
        $mensaje .= "<tr><th>Referencia</th><th>Descripcion</th><th>Ubicacion</th><th>Unidades disponibles</th><th>Unidades fisicas</th><th>Unidades contabilizadas</th><th>Comentario</th></tr>";
        foreach ($datos as $dato) {
            if(isset($comentarios[$dato['referencia']])){
                $comentario = $comentarios[$dato['referencia']];
            }else{
                $comentario = '';
            }
            $mensaje .= "<tr><td>" . $dato['referencia'] . "</td><td>" . $dato['descripcion'] . "</td><td>" . $dato['ubicacion'] . "</td><td>" . $dato['unidades'] . "</td><td>" . $dato['unidades_contabilizadas'] . "</td><td>" . $dato['unidades_contabilizadas'] . "</td><td>" . $comentario . "</td></tr>";
        }
        $mensaje .= "</table></br>";
        $mensaje .= "<div><strong>Comentarios generales</strong><p>$comentariosGenerales</p></div>";
        $emails = trim(Configuration::getGlobalValue($this->sufijo . 'EMAILS'));
        if($emails){
            $emails = explode(',', $emails);
            foreach ($emails as $email) {
                Mail::Send(Context::getContext()->language->id, 'informe', $subject, ['{tabla}' => $mensaje, '{nombre_archivo}' => $nombre_archivo], trim($email), NULL, trim($email), NULL, NULL, NULL, dirname(__FILE__) . '/mails/');
            }
        }
    }

    public function enviarEmailsMultialmacen($id, $nombre_archivo)
    {
        $subject = Configuration::get('PS_SHOP_NAME') . ' - ' . 'Inventario: ' . $nombre_archivo;
        $sql = 'SELECT `referencia`, `descripcion`, `ubicacion`, `unidades`, `unidades_fisicas`, `unidades_contabilizadas`, `almacen` FROM ' . _DB_PREFIX_ . $this->sufijo . 'archivo_linea WHERE id_archivo = ' . (int)$id;
        $datos = Db::getInstance()->executeS($sql);
        $comentarios = $this->cargarComentariosLineas($id);
        $comentariosGenerales = $this->cargarComentariosArchivo($id);
        $mensaje = "<table>";
        $mensaje .= "<tr><th>Referencia</th><th>Descripcion</th><th>Ubicacion</th><th>Unidades disponibles</th><th>Unidades fisicas</th><th>Unidades contabilizadas</th><th>Almacen</th><th>Comentario</th></tr>";
        foreach ($datos as $dato) {
            if(isset($comentarios[$dato['referencia']])){
                $comentario = $comentarios[$dato['referencia']];
            }else{
                $comentario = '';
            }
            $mensaje .= "<tr><td>" . $dato['referencia'] . "</td><td>" . $dato['descripcion'] . "</td><td>" . $dato['ubicacion'] . "</td><td>" . $dato['unidades'] . "</td><td>" . $dato['unidades_contabilizadas'] . "</td><td>" . $dato['unidades_contabilizadas'] . "</td><td>" . $dato['almacen'] . "</td><td>" . $comentario . "</td></tr>";
        }
        $mensaje .= "</table></br>";
        $mensaje .= "<div><strong>Comentarios generales</strong><p>$comentariosGenerales</p></div>";
        $emails = trim(Configuration::getGlobalValue($this->sufijo . 'EMAILS'));
        if($emails){
            $emails = explode(',', $emails);
            foreach ($emails as $email) {
                Mail::Send(Context::getContext()->language->id, 'informe', $subject, ['{tabla}' => $mensaje, '{nombre_archivo}' => $nombre_archivo], trim($email), NULL, trim($email), NULL, NULL, NULL, dirname(__FILE__) . '/mails/');
            }
        }
    }

    public function guardarComentarioLinea($id, $referencia, $comentario)
    {
        $sql = 'REPLACE INTO ' . _DB_PREFIX_ . $this->sufijo . 'comentarios_linea (id_archivo, referencia, comentario) VALUES (' . (int)$id . ', "' . pSQL($referencia) . '", "' . pSQL($comentario) . '")';
        return Db::getInstance()->execute($sql);
    }

    public function cargarComentariosLineas($id)
    {
        $sql = 'SELECT * FROM ' . _DB_PREFIX_ . $this->sufijo . 'comentarios_linea WHERE id_archivo = ' . (int)$id;
        $comentarios = Db::getInstance()->executeS($sql);
        $comentariosOrdenados = array();
        foreach ($comentarios as $comentario) {
            $comentariosOrdenados[$comentario['referencia']] = $comentario['comentario'];
        }
        return $comentariosOrdenados;
    }

    public function cargarComentariosArchivo($id)
    {
        $id = (int) $id;
        $sql = 'SELECT comentario FROM ' . _DB_PREFIX_ . $this->sufijo . 'comentarios_archivo WHERE id_archivo=' . $id;
        $comentarios = Db::getInstance()->getValue($sql);
        return $comentarios;
    }

    public function cargarComentariosArchivos()
    {
        $sql = 'SELECT * FROM ' . _DB_PREFIX_ . $this->sufijo . 'comentarios_archivo';
        $comentarios = Db::getInstance()->executeS($sql);
        $comentariosOrdenados = array();
        foreach ($comentarios as $comentario) {
            $comentariosOrdenados[$comentario['id_archivo']] = $comentario['comentario'];
        }
        return $comentariosOrdenados;
    }

    public function eliminarInventario($id)
    {
        $sql = 'UPDATE ' . _DB_PREFIX_ . $this->sufijo . 'archivos SET estado = "Eliminado" WHERE id = ' . (int)$id;
        return Db::getInstance()->execute($sql);
    }

    public function guardarComentarioArchivo($id, $comentario)
    {
        $sql = 'REPLACE INTO ' . _DB_PREFIX_ . $this->sufijo . 'comentarios_archivo (id_archivo, comentario) VALUES (' . (int)$id . ', "' . pSQL($comentario) . '")';
        return Db::getInstance()->execute($sql);
    }

    /**
     * Devuelve la cantidad física de un producto
     * @param mixed $id_product
     * @param mixed $id_product_attribute
     * @return string|false
     */
    public function getStock($id_product, $id_product_attribute = null) {
        $db = Db::getInstance();
        $id_product_attribute_condition = $id_product_attribute ? ' AND id_product_attribute = ' . (int)$id_product_attribute : ' AND id_product_attribute = 0';
    
        $sql = 'SELECT quantity, physical_quantity FROM ' . _DB_PREFIX_ . 'stock_available WHERE id_product = ' . (int)$id_product . $id_product_attribute_condition;
        return $db->getRow($sql);
    }
    
     /**
     * Devuelve datos extra del producto.
     * @param int $id_product
     * @param int $id_product_attribute Si es false se ignora.
     * @return array
     */
    public function cargarExtraProducto($id_product, $id_product_attribute = false) {
        return ($id_product_attribute !== false ? $this->cargarExtraUnaCombinacion($id_product, (int) $id_product_attribute) : 
            $this->cargarExtraTodasCombinaciones($id_product));
    }
    /**
     * Devuelve los datos extra para una combinacion.
     * @param int $id_product
     * @param int $id_product_attribute
     * @return array
     */
    private function cargarExtraUnaCombinacion($id_product, $id_product_attribute) {
        //Datos extra
        $id_product = (int) $id_product;
        $id_product_attribute = (int) $id_product_attribute;
        $resultado = array();
        $origenUbicacion = Configuration::getGlobalValue(self::prefijo . 'ORIGEN_UBI_PDA');
        if($origenUbicacion == 1){
            $modulo = Module::getInstanceByName('imaximprimepedidosservidor');
            $resultado = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . $modulo->sufijo . "extraProducto` WHERE id_product = '$id_product' AND id_product_attribute = '$id_product_attribute'");
        }elseif($origenUbicacion == 2) {
            //obswarehouselocation
            $modulo = Module::getInstanceByName('obswarehouselocation');
            if($modulo) {
                $localizacion = $modulo->getWarehouseLocation($id_product);
                $resultado['id_product'] = $id_product;
                $resultado['id_product_attribute'] = $id_product_attribute;
                $resultado['ubicacion'] = $localizacion;
            }
        }
        elseif($origenUbicacion == 3) {
            //Prestashop
            if($this->hayUbicacionesPresta()) {
                $resultado['id_product'] = $id_product;
                $resultado['id_product_attribute'] = $id_product_attribute;
                $resultado['ubicacion'] = Db::getInstance()->getValue('SELECT location FROM `'._DB_PREFIX_."stock_available` WHERE id_product = '$id_product' AND id_product_attribute = '$id_product_attribute'");
            }
        }
        
        return $resultado;
    }
    
    /**
     * Devuelve los datos extra de un producto.
     * @param int $id_product
     * @return array
     */
    private function cargarExtraTodasCombinaciones($id_product) {
        $resultado = array();
        
        //Datos extra
        $id_product = (int) $id_product;
        
        $origenUbicacion = Configuration::getGlobalValue(self::prefijo . 'ORIGEN_UBI_PDA');
        if($origenUbicacion == 1){
            $modulo = Module::getInstanceByName('imaximprimepedidosservidor');
            $temp = Db::getInstance()->executeS('SELECT * FROM `' . _DB_PREFIX_ . $modulo->sufijo . "extraProducto` WHERE id_product = '$id_product'");
            foreach($temp as $t) {
                $resultado[$t['id_product_attribute']] = $t;
            }
        }elseif($origenUbicacion == 2) {
            //obswarehouselocation
            $modulo = Module::getInstanceByName('obswarehouselocation');
            if($modulo) {
                $localizacion = $modulo->getWarehouseLocation($id_product);
                $resultado[0]['id_product'] = $id_product;
                $resultado[0]['id_product_attribute'] = 0;
                $resultado[0]['ubicacion'] = $localizacion;
            }
        }
        elseif($origenUbicacion == 3) {
            //Prestashop
            if($this->hayUbicacionesPresta()) {
                $localizaciones = Db::getInstance()->executeS('SELECT id_product_attribute, location FROM `'._DB_PREFIX_."stock_available` WHERE id_product = '$id_product'");
                foreach($localizaciones as $localizacion) {
                    $resultado[$localizacion['id_product_attribute']]['id_product'] = $id_product;
                    $resultado[$localizacion['id_product_attribute']]['id_product_attribute'] = $localizacion['id_product_attribute'];
                    $resultado[$localizacion['id_product_attribute']]['ubicacion'] = $localizacion['location'];
                }
            }
        }

        return $resultado;
    }

    /**
     * Indica si están disponibles las ubicaciones de Prestashop.
     * @return boolean
     */
    private function hayUbicacionesPresta() {
        $ubicaciones = false;
        
        $columnas = Db::getInstance()->executeS('DESCRIBE '._DB_PREFIX_.'stock_available');
        foreach($columnas as $columna) {
            if($columna['Field'] == 'location') {
                $ubicaciones = true;
                break;
            }
        }
        
        return $ubicaciones;
    }

    /**
     * Devuelvo los almacenes en los que se encuentra un producto
     * @param mixed $id_product
     * @param mixed $id_product_attribute
     * @return array
     */
    public function getWarehousesByProduct($id_product, $id_product_attribute){
        $id_product = (int) $id_product;
        $id_product_attribute = (int) $id_product_attribute;
        $sql = 'SELECT w.id_warehouse, CONCAT(w.reference, " - " ,w.name) as name , w.reference FROM `'._DB_PREFIX_.'stock` s 
                INNER JOIN `'._DB_PREFIX_."warehouse` w ON s.id_warehouse = w.id_warehouse
                WHERE s.id_product = $id_product AND s.id_product_attribute = $id_product_attribute GROUP BY s.id_warehouse";
        return Db::getInstance()->executeS($sql);
    }

    /**
     * Devuelve la cantidad física de un producto
     * @param mixed $id_product
     * @param mixed $id_product_attribute
     * @return array
     */
    public function getStockMultialmacen($id_product, $id_product_attribute = null, $id_warehouse = null) {
        if($id_warehouse){
            $idStock = StockAvailable::getWarehouseStockAvailableIdByProductId($id_product, $id_product_attribute, $id_warehouse);
            $stock = new Stock($idStock);
            $resultado = ['quantity' => $stock->usable_quantity, 'physical_quantity' => $stock->physical_quantity];
        }else{
            $db = Db::getInstance();
            $id_product_attribute_condition = $id_product_attribute ? ' AND id_product_attribute = ' . (int)$id_product_attribute : ' AND id_product_attribute = 0';
            $sql = 'SELECT quantity, physical_quantity FROM ' . _DB_PREFIX_ . 'stock_available WHERE id_product = ' . (int)$id_product . $id_product_attribute_condition;
            $resultado = $db->getRow($sql);
        }
        return $resultado;
    }

    /**
     * Elimina del array de almacenes los almacenes virtuales
     * @param array $almacenes
     * @return array
     */
    public function quitarAlmacenStockVirtual($almacenes) {
        Module::getInstanceByName('imaxmultialmacen');
        $almacenesStockVirtualActuales = (new AlmacenesVirtuales())->cargarRelaciones();
        
        // Obtener todos los id_warehouse de almacenesStockVirtualActuales en una lista
        $almacenesStockVirtualIds = array_keys($almacenesStockVirtualActuales);
        // Filtrar los almacenes para quitar los que están en almacenesStockVirtualIds
        $almacenesFiltrados = array_filter($almacenes, function($almacen) use ($almacenesStockVirtualIds) {
            return !in_array($almacen['id_warehouse'], $almacenesStockVirtualIds);
        });
        return $almacenesFiltrados;
    }

    /**
    * Reordena los almacenes para que el primer almacén virtual aparezca primero
    * y elimina los demás almacenes virtuales.
    * @param array $almacenes
    * @return array
    */
    public function reordenarAlmacenStockVirtual($almacenes) {
        Module::getInstanceByName('imaxmultialmacen');
        $almacenesStockVirtualActuales = (new AlmacenesVirtuales())->cargarRelaciones();

        // Obtener todos los id_warehouse de almacenesStockVirtualActuales en una lista
        $almacenesStockVirtualIds = array_keys($almacenesStockVirtualActuales);

        $primerAlmacenVirtualId = $almacenesStockVirtualIds[0];

        // Filtrar los almacenes para eliminar los almacenes virtuales excepto el primero
        $almacenesFiltrados = array_filter($almacenes, function($almacen) use ($almacenesStockVirtualIds, $primerAlmacenVirtualId) {
            return !in_array($almacen['id_warehouse'], $almacenesStockVirtualIds) || $almacen['id_warehouse'] === $primerAlmacenVirtualId;
        });

        // Reordenar el array colocando el primer almacén virtual al inicio
        usort($almacenesFiltrados, function($a, $b) use ($primerAlmacenVirtualId) {
            return ($a['id_warehouse'] === $primerAlmacenVirtualId) ? -1 : 1;
        });

        return array_values($almacenesFiltrados);
    }


}
