<?php

/**
 * @version 1.45
 */
class imaxForm {

    private $sinFormulario, $formulario = '', $modulo;

    function __construct($modulo, $modulePath = '', $action = '', $method = 'post', $name = '', $enctype = '', $extras = false, $sinFormulario = false, $pathToModule = '', $ajax = false) {
        if ($action == '') {
            $action = Tools::safeOutput($_SERVER['REQUEST_URI']);
        }
        if ($enctype != '') {
            $enctype = 'enctype="' . $enctype . '"';
        }
        if (!$sinFormulario) {
            $this->formulario = '<form name="' . $name . '" action="' . $action . '" method="' . $method . '" ' . $enctype;
            if ($extras) {
                if (!is_array($extras)) {
                    $extras = array($extras);
                }
                foreach ($extras AS $indice => $extra) {
                    $this->formulario .= $indice . '="' . $extra . '"';
                }
            }
            $this->formulario .= ' >';
        }
        $this->sinFormulario = $sinFormulario;

        $this->context = Context::getContext();
        $this->_path = $modulePath;
        $this->_modulePath = $pathToModule;
        $this->ajax = $ajax;
        if (!$this->ajax) {
            if (version_compare(_PS_VERSION_, '1.6.0.0 ', '>=')) {
                $this->addCSS('forms.css');
            } else {
                $this->addCSS('forms.15.css');
            }
            $this->addJS('forms.js');
        }
        $this->idLang = Configuration::getGlobalValue('PS_LANG_DEFAULT');
        $this->idShop = Configuration::getGlobalValue('PS_SHOP_DEFAULT');
        $this->modulo = $modulo;
    }

    /**
     * Agrega html al formulario.
     * @param string $html
     * @return $this
     */
    public function addToForm($html) {
        $this->formulario .= $html;

        return $this;
    }

    /**
     * Devuelve el html del formulario.
     * @param boolean $vaciarFormulario Si es true se vacia el form despues de devolver el html.
     * @return string
     */
    public function renderForm($vaciarFormulario = false) {
        if (!$this->sinFormulario) {
            $this->formulario .= '</form>';
        }

        $formulario = $this->formulario;

        if ($vaciarFormulario) {
            $this->formulario = '';
        }

        return $formulario;
    }

    /**
     * Crea un elemento informativo
     * @param string $text Texto a mostrar
     * @param string $class Clase del elemento (warning (defecto), confirm)
     * @return $this
     */
    function createFormInfomationText($text, $class = 'warning') {
        switch ($class) {
            case 'warning':
                $class = ' warning warn alert  alert-warning ';
                break;
            case 'confirm':
                $class = ' module_confirmation conf confirm alert alert-success ';
                break;
            default:
                break;
        }
        $html = '';
        $html .= '<div class="form-group">';
        $html .= '<div class="bootstrap imaxBootstrap">';
        $html .= '<p class="' . $class . '">';
        $html .= $text;
        $html .= '</p>';
        $html .= '</div>';
        $html .= '</div>';
        $this->formulario .= $html;

        return $this;
    }

    /**
     * 
     * @param string $name
     * @param string $text
     * @param string $title
     * @param array $checks
     * @param array $selectedValue
     * @return $this
     */
    public function createFormCheckboxGroupList($name, $text, $title, $checks, $selectedValue = array(), $extras = array()) {
        $html = '';
        $html .= '<div class="form-group"';
        $html .= $this->addExtras($extras);
        $html .= '>';
        $html .= '<label class="control-label">';
        $html .= '<span title="' . $title . '">';
        $html .= $text;
        $html .= '</span>';
        $html .= '</label>';
        $html .= '<div class="control-label">';
        foreach ($checks as $check) {
            $marcado = ($selectedValue !== false && in_array($check['value'], $selectedValue) ? 'checked="checked"' : '');

            $html .= '<div class="form-group">';
            $html .= '<label><input type="checkbox" ' . $marcado . ' value="' . $check['value'] . '" name="' . $name . '[]" id="' . $name . '"> ' . $check['text'].'</label>';
            $html .= '</div>';
        }
        $html .= '</div>';
        $html .= '</div>';
        
        $this->formulario .= $html;

        return $this;
    }
    /**
     * Crea un checkbox.
     * @param string $name Nombre del checkbox
     * @param string $text Texto informativo
     * @param boolean $checked Marcado(true) o no(false), por defecto false
     * @param string $title Titulo 
     * @param string $value El valor del checkbox.
     * @return $this
     */
    function createFormCheckboxGroup($name, $text, $checked = false, $title = '', $value = 1) {
        $marcado = '';
        if ($checked == true) {
            $marcado = ' checked="checked"';
        }
        $html = '';
        $html .= '<div class="form-group">';
        $html .= '<div>';
        $html .= '<input type="checkbox" ' . $marcado . ' value="' . $value . '" name="' . $name . '" id="' . $name . '">';
        $html .= '</div>';
        $html .= '<label for="' . $name . '" class="control-label">';
        $html .= '<span title="' . $title . '">';
        $html .= $text;
        $html .= '</span>';
        $html .= '</label>';
        $html .= '</div>';
        $this->formulario .= $html;

        return $this;
    }

    /**
     * 
     * @param array $datos
     * @param string $text 
     * @param array $extras
     * @return $this
     */
    function createFormRadioButtonGroup($datos, $text, $extras = false) {
        $html = '';
        $html .= '<div class="form-group">';
        $html .= '<label class="control-label">' . $text . '</label>';
        $html .= '<div class="control-label">';
        foreach ($datos AS $indice => $dato) {
            $checked = '';
            if (isset($dato['checked']) && $dato['checked'] == 1) {
                $checked = ' checked="checked"';
            }
            $html .= '<div class="radio">';
            $html .= '<label>';
            $html .= '<input ' . $checked . ' type="radio" value="' . $dato['value'] . '" name="' . $dato['name'] . '"';

            if ($extras && $extras[$indice]) {
                foreach ($extras[$indice] AS $indiceExtras => $extra) {
                    $html .= $indiceExtras . '="' . $extra . '"';
                }
            }
            $html .= ' />';

            $html .= $dato['text'];
            $html .= '</label>';
            $html .= '</div>';
        }
        $html .= '</div>';
        $html .= '</div>';
        $this->formulario .= $html;

        return $this;
    }

    /**
     * 
     * @param string $name
     * @param string $contenido
     * @param string $text 
     * @param string $title 
     * @param boolean $multiLang
     * @param boolean $wysiwyg
     * @return $this
     */
    public function generarTextArea($name, $contenido, $text, $title = '', $multiLang = 0, $wysiwyg = 1, $array=false) {
        $html = '';
        $html .= '<div class="form-group bootstrap">';
        $html .= '<label class="control-label">';
        $html .= '<span data-toggle="tooltip" title="" data-original-title="' . $title . '">';
        $html .= $text;
        $html .= '</span>';
        $html .= '</label>';
        if ($multiLang) {
            $idiomas = $this->getLanguages();
            $idiomasSelect = $idiomas;
            foreach ($idiomas AS $language) {
                $html .= '<div class="translatable-field row lang-' . $language['id_lang'] . ' control-label">';
                $html .= '<div class="col-lg-10">';
                $html .= '<textarea ';
                $html .= ' id="' . $name . '_' . $language['id_lang'] . '"';
                if(!$array) {
                    $html .= ' name="' . $name . '_' . $language['id_lang'] . '"';
                }else {
                    $html .= " name='{$name}[{$language['id_lang']}]'";
                }
                if ($wysiwyg) {
                    $html .= ' class="autoload_rte">';
                } else {
                    $html .= '>';
                }

                if (isset($contenido[$language['id_lang']])) {
                    $html .= $contenido[$language['id_lang']];
                }

                $html .= ' </textarea>';
                $html .= ' </div>';
                $html .= ' <div class="col-lg-2">';
                $html .= ' <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">';
                $html .= $language['iso_code'];
                $html .= ' <span class="caret"></span>';
                $html .= ' </button> ';
                $html .= ' <ul class="dropdown-menu"> ';
                foreach ($idiomasSelect AS $idiomaSelect) {
                    $html .= ' <li><a href="javascript:hideOtherLanguage(' . $idiomaSelect['id_lang'] . ');">' . $idiomaSelect['name'] . '</a></li>';
                }
                $html .= ' </ul> ';
                $html .= ' </div> ';
                $html .= ' </div> ';
            }
        } else {
            $html .= '<div class="col-lg-9">';
            $html .= '<textarea ';
            $html .= ' id="' . $name . '"';
            $html .= ' name="' . $name . '"';
            if ($wysiwyg) {
                $html .= ' class="autoload_rte">';
            } else {
                $html .= '>';
            }

            $html .= $contenido;
            $html .= ' </textarea>';
            $html .= ' </div>';
        }
        $html .= '</div>';
        if ($wysiwyg) {
            $html .= '<script>';
            $html .= 'if(typeof tinySetup === "function") {';
            $html .= 'tinySetup({ ';
            $html .= 'editor_selector: "autoload_rte"';
            $html .= '}); ';
            $html .= '}';
            $html .= '</script>';
        }
        if($multiLang) {
            $html .= '<script>hideOtherLanguage(' . Configuration::getGlobalValue('PS_LANG_DEFAULT') . ');</script>';
        }
        $this->formulario .= $html;

        return $this;
    }

    /**
     * 
     * @param string $name
     * @param string $value
     * @param string $text 
     * @param string $title 
     * @param boolean $multiLang
     * @param boolean $password
     * @param array $extras
     * @param boolean $autofocus
     * @return $this
     */
    function createFormTextGroup($name, $value, $text, $title = '', $multiLang = 0, $password = 0, $extras = false, $autofocus = false) {
        $tipo = 'text';
        if ($password == 1) {
            $tipo = 'password';
        }

        $html = '<div class="form-group bootstrap">';
        $html .= '<label for="' . $name . '" class="control-label">';
        $html .= '<span title="' . $title . '">';
        $html .= $text;
        $html .= '</span>';
        $html .= '</label>';
        if ($multiLang) {
            $idiomas = $this->getLanguages();
            $idiomasSelect = $idiomas;
            foreach ($idiomas AS $language) {
                
                if(isset($value[$language['id_lang']])){
                    $valueString=$value[$language['id_lang']];
                }else{
                    $valueString='';
                }
                
                $html .= '<div class="control-label translatable-field row lang-' . $language['id_lang'] . '">';
                $html .= '<div class="col-lg-9">';
                $html .= "<input type='text' id='{$name}_{$language['id_lang']}' name='{$name}[{$language['id_lang']}]' value='$valueString'/>";
                $html .= '</div>';
                $html .= '<div class="col-lg-2">';
                $html .= '<button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">';
                $html .= $language['iso_code'];
                $html .= '<span class="caret"></span>';
                $html .= '</button> ';
                $html .= '<ul class="dropdown-menu"> ';
                foreach ($idiomasSelect AS $idiomaSelect) {
                    $html .= ' <li><a href="javascript:hideOtherLanguage(' . $idiomaSelect['id_lang'] . ');">' . $idiomaSelect['name'] . '</a></li>';
                }
                $html .= ' </ul> ';
                $html .= ' </div> ';
                $html .= ' </div> ';
            }
        } else {
            $html .= '<div class="control-label col-lg-6">';
            $html .= '<input type="' . $tipo . '" value="' . $value . '" name="' . $name . '" id="' . $name . '"';
            if ($extras && is_array($extras)) {
                foreach ($extras AS $indice => $extra) {
                    $html.= ' ' . $indice . '="' . $extra . '"';
                }
            }
            if ($autofocus) {
                $html .= ' autofocus ';
            }
            $html .= '>';
            $html .= '</div>';
        }
        $html .= '</div>';

        $html .= '<script>hideOtherLanguage(' . Configuration::getGlobalValue('PS_LANG_DEFAULT') . ');</script>';

        $this->formulario .= $html;

        return $this;
    }

    /**
     * 
     * @param string $name
     * @param string $text 
     * @param string $title 
     * @param array $extras
     * @return $this
     */
    function createFormDate($name, $text, $title = '', $extras = false) {
        $tipo = 'text';


        $html = '<div class="form-group bootstrap">';
        $html .= '<label for="' . $name . '" class="control-label col-lg-3">';
        $html .= '<span title="' . $title . '">';
        $html .= $text;
        $html .= '</span>';
        $html .= '</label>';

        $html .= '<div class="col-lg-3">';
        $html .= '<input type="' . $tipo . '" data-hex="true" value="" name="' . $name . '" id="' . $name . '"';
        if ($extras && is_array($extras)) {
            foreach ($extras AS $indice => $extra) {
                $html.= ' ' . $indice . '="' . $extra . '"';
            }
        }
        $html .= '>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '<script type="text/javascript">';
        $html .= '$(function(){ ';
        $html .= '  $("#' . $name . '").datepicker(); ';
        $html .= '});';
        $html .= '</script>';


        $this->formulario .= $html;

        return $this;
    }

    /**
     * Permite crear un elemento de tipo color picker
     * @param string $name
     * @param string $value
     * @param string $text
     * @param string $title
     * @param array $extras
     * @param boolean $autofocus
     */
    function createFormColorPicker($name, $value, $text, $title = '', $extras = false, $autofocus = false) {
        $html = '<div class="form-group ';
        if ($this->modulo->versionPS < 17) {
            $html .= 'bootstrap';
        }
        $html .= '">';
        $html .= '<label for="' . $name . '" class="control-label col-lg-3">';
        $html .= '<span title="' . $title . '">';
        $html .= $text;
        $html .= '</span>';
        $html .= '</label>';
        $html .= '<div class="col-lg-2">';
        $html .= '<div class="row">';
        $html .= '<div class="input-group">';
        $html .= '<input type="text" value="' . $value . '" name="' . $name . '" id="' . $name . '" data-hex="true"';
        $class = '';
        if ($extras && is_array($extras)) {
            foreach ($extras AS $indice => $extra) {
                if ($indice == 'class') {
                    $class .= ' ' . $extra;
                } else {
                    $html.= ' ' . $indice . '="' . $extra . '"';
                }
            }
        }
        $html .= ' class="color mColorPickerInput';
        if ($class) {
            $html .= ' ' . $class . '"';
        } else {
            $html .= '"';
        }
        if ($autofocus) {
            $html .= ' autofocus ';
        }
        $html .= '>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '</div>';
        $this->formulario .= $html;
    }

    /**
     * 
     * @param string $name
     * @param string $value
     * @param string $text 
     * @param string $title 
     * @param string $outputDelimiter
     * @param string $paceholder 
     * @param array $options
     * @return $this
     */
    function createFormTagTextGroup($name, $value, $text, $title = '', $outputDelimiter = ',', $paceholder = 'Añadir etiqueta', $options = array()) {
        $html = '';
        $this->addJS('jquery.tagify.js');
        $html .= '<div class="form-group bootstrap">';
        $html .= '<label for="' . $name . '" class="control-label col-lg-3">';
        $html .= '<span title="' . $title . '">';
        $html .= $text;
        $html .= '</span>';
        $html .= '</label>';
        $html .= '<div class="col-lg-9">';
        $html .= '<input type="text" value="' . $value . '" name="' . $name . '" id="' . $name . '"';
        if ($options) {
            foreach ($options AS $indice => $valor) {
                if ($indice == 'class') {
                    $valor .= ' tagify';
                }
                $html .= $indice . '="' . $valor . '"';
            }
        }
        $html .= '>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '<script>';
        $html .= '$().ready(function () { ';
        $html .= '  $("#' . $name . '").tagify({'
                . 'delimiters: [13,44], '
                . 'addTagPrompt: "' . $paceholder . '",'
                . 'outputDelimiter: "' . $outputDelimiter . '"'
                . '});';

        $html .= '  $("#' . $name . '").closest("form").submit( function() {';
        $html .= '  $(this).find("#' . $name . '").val($("#' . $name . '").tagify("serialize"));';
        $html .= '  });';
        $html .= '});';
        $html .= '</script>';
        $this->formulario .= $html;

        return $this;
    }

    /**
     * 
     * @param string $name
     * @param string $text 
     * @param int $defaultValue
     * @param int $min
     * @param int $max
     * @param int $step
     * @param string $title 
     * @return $this
     */
    function createFormSelectNumerico($name, $text, $defaultValue, $min, $max, $step = 1, $title = '') {
        $html = '';
        $html .= '<div class="form-group">';
        $html .= '<label for="' . $name . '" class="control-label">';
        $html .= '<span title="' . $title . '">';
        $html .= $text;
        $html .= '</span>';
        $html .= '</label>';
        $html .= '<div class="control-label">';
        $html .= '<select name="' . $name . '" id="' . $name . '">';
        for ($i = $min; $i < $max; $i = $i + $step) {
            $selected = '';
            if ($i == $defaultValue) {
                $selected = ' selected="selected" ';
            }
            $html .= '<option value="' . $i . '" ' . $selected . '>' . $i . '</option>';
        }
        $html .= '</select>';
        $html .= '</div>';
        $html .= '</div>';
        $this->formulario .= $html;

        return $this;
    }

    function createHidden($name, $value) {
        $html = '<input type="hidden" name="' . $name . '" value="' . $value . '" id="' . $name . '" />';
        $this->formulario .= $html;

        return $this;
    }

    /**
     * 
     * @param string $name
     * @param string $text 
     * @param array $extras
     * @return $this
     */
    function createSubmitButton($name, $text, $extras = false) {
        $html = '<button class="btn btn-default pull-right" name="' . $name . '" type="submit"';
        $html .= $this->addExtras($extras);
        $html .= '>';
        $html .= '<i class="process-icon-save"></i>' . $text . '</button>';
        $this->formulario .= $html;

        return $this;
    }

    /**
     * 
     * @param string $name
     * @param string $text 
     * @param array $extras
     * @param string $type
     * @param string $icon
     * @return $this
     */
    public function createButton($name, $text, $extras = false, $type = 'button', $icon = 'plus') {
        $html = '<button class="btn btn-default pull-right" name="' . $name . '" type="' . $type . '"';
        if ($extras && is_array($extras)) {
            foreach ($extras AS $indice => $extra) {
                $html.= ' ' . $indice . '="' . $extra . '"';
            }
        }

        $html .= '>';
        $html .= '<i class="process-icon-' . $icon . '"></i>' . $text . '</button>';
        $this->formulario .= $html;

        return $this;
    }

    /**
     * Crea un select.
     * @param string $name
     * @param array $text 
     * @param string $datos valor => visible
     * @param string $defaultValue
     * @param string $title 
     * @param array $extras
     * @return $this
     */
    function createFormSelect($name, $text, $datos, $defaultValue, $title = '', $extras = null) {
        $html = '';
        $html .= '<div class="form-group">';
        $html .= '<label for="' . $name . '" class="control-label">';
        $html .= '<span title="' . $title . '">';
        $html .= $text;
        $html .= '</span>';
        $html .= '</label>';
        $html .= '<div class="control-label">';
        $html .= '<select name="' . $name . '" id="' . $name . '" ';
        if ($extras) {
            foreach ($extras AS $indice => $extra) {
                $html .= $indice . '="' . $extra . '"';
            }
        }
        $html .= '>';
        foreach ($datos AS $valor => $texto) {
            $selected = '';
            if ($valor == $defaultValue) {
                $selected = ' selected="selected" ';
            }
            $html .= '<option value="' . $valor . '" ' . $selected . '>' . $texto . '</option>';
        }
        $html .= '</select>';
        $html .= '</div>';
        $html .= '</div>';
        $this->formulario .= $html;

        return $this;
    }

    /**
     * 
     * @param string $name
     * @param string $label 
     * @param string $title 
     * @param string $url
     * @return $this
     */
    public function createFormFileButton($name, $label, $title, $url) {
        $this->addJS('spin.js');
        $this->addJS('ladda.js');

        $this->addJS('jquery.iframe-transport.js');
        $this->addJS('jquery.fileupload.js');
        $this->addJS('jquery.fileupload-process.js');
        $this->addJS('jquery.fileupload-validate.js');
        //$this->addJS('jquery.fileupload-image.js');

        $html = '';
        $html .= '<div class="form-group">';
        $html .= '<label for="' . $name . '" class="control-label col-lg-3">';
        $html .= '<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="' . $title . '">' . $label . '</span>';
        $html .= '</label>';
        $html .= '<div class="col-lg-8 bootstrap">';
        $html .= '<input type="file" class="hide" data-url="' . $url . '" name="' . $name . '" id="' . $name . '">';
        $html .= '<button id="' . $name . '-add-button" type="button" data-size="s" data-style="expand-right" class="btn btn-default"><span class="ladda-label">';
        $html .= '<i class="icon-plus-sign"></i> ' . $label . '';
        $html .= '</span><span class="ladda-spinner"></span></button>';
        $html .= '<!--';
        $html .= '<div class="alert alert-success" id="' . $name . '-success" style="display:none">' . $this->modulo->l('Carga exitosa') . '</div>';
        $html .= '<div class="alert alert-danger" id="' . $name . '-errors" style="display:none"></div>';
        $html .= '-->';
        $html .= '</div>';

        $html .= "<script type='text/javascript'>
			function humanizeSize(bytes) {
				if (typeof bytes !== 'number') {
					return '';
				}
				if (bytes <= 1000000000) {
					return (bytes / 1000000000).toFixed(2) + ' GB';
				}
				if (bytes <= 1000000) {
					return (bytes / 1000000).toFixed(2) + ' MB';
				}
				return (bytes / 1000).toFixed(2) + ' KB';
				}
			$(document ).ready(function() {				
				var " . $name . "_add_button = Ladda.create(document.querySelector('#" . $name . "-add-button'));
				var " . $name . "total_files=0;
				var success_message = '" . $this->modulo->l("Carga exitosa") . "'
				$('#" . $name . "-add-button').removeAttr('disabled');
				$('#" . $name . "').fileupload({
					dataType: 'jsonp',
					autoUpload: true,
					singleFileUploads: true,
					maxFileSize: 838860800,
					success: function (e) {
						//showSuccessMessage(success_message);
					},
					start: function (e) {
						" . $name . "_add_button.start();
					},
					fail: function (e, data) {
						showErrorMessage(data.errorThrown.message);
					},
					done: function (e, data) {
						if (data.result) {							
							if (data.result.codError != 0) {
								showErrorMessage(data.result.msgError);
							}else { 
								showSuccessMessage(data.result.msgError);
							}
						}
						$('#" . $name . "-add-button').removeProp('disabled');
					}
				}).on('fileuploadalways', function (e, data) {				
					$('#" . $name . "-add-button').removeProp('disabled');
				}).on('fileuploadprocessalways', function (e, data) {
					var index = data.index,	file = data.files[index];
				}).on('fileuploadsubmit', function (e, data) {
					var params = new Object();
					$('input[id^=\"" . $name . "_name_\"]').each(function() {
						id = $(this).prop('id').replace('" . $name . "_name_', '" . $name . "_name[') + ']';
						params[id] = $(this).val();
				});
				$('textarea[id^=\"" . $name . "_description_\"]').each(function() {
					id = $(this).prop('id').replace('" . $name . "_description_', '" . $name . "_description[') + ']';
					params[id] = $(this).val();
				});
				data.formData = params;
				});
			$('#" . $name . "-add-button').on('click', function() {
				//$('#attachment_file-success').hide();
				//$('#attachment_file-errors').html('').hide();
				" . $name . "_file_total_files = 0;
				$('#" . $name . "').trigger('click');
			});
		});";
        $html .= '</script>';
        $html .= '</div>';
        $this->formulario .= $html;

        return $this;
    }

    /**
     * 
     * @param string $name
     * @param string $text 
     * @param mixed $defaultValue
     * @param string $title 
     * @return $this
     */
    public function generarSelectIdioma($name, $text, $defaultValue, $title) {
        $html = '';
        $html .= '<div class="form-group">';
        $html .= '<label for="' . $name . '" class="control-label">';
        $html .= '<span title="' . $title . '">';
        $html .= $text;
        $html .= '</span>';
        $html .= '</label>';
        $html .= '<div class="control-label">';
        $html .= '<select name="' . $name . '" id="' . $name . '" class="selectIdioma">';
        $idiomas = Language::getLanguages();
        foreach ($idiomas AS $idioma) {
            $selected = '';
            if ($defaultValue == $idioma['id_lang']) {
                $selected = ' selected="selected" ';
            }
            $html .= '<option value="' . $idioma['id_lang'] . '" ' . $selected . '>' . $idioma['name'] . '</option>';
        }
        $html .= '</select>';
        $html .= '</div>';
        $html .= '</div>';
        reset($idiomas);
        $html .= '<style>';
        foreach ($idiomas AS $idioma) {
            $html .= " .selectIdioma option[value='{$idioma['id_lang']}'] { background-image: url('.." . _THEME_LANG_DIR_ . "{$idioma['id_lang']}.jpg'); }";
        }
        $html .= '</style>';
        $html .= '<script>';
        $html .= ' var rutaImagenes="..' . _THEME_LANG_DIR_ . '"';
        $html .= '</script>';
        $this->formulario .= $html;

        return $this;
    }

    private function addCSS($css) {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            if ($this->context->controller instanceof stdClass) {
                $this->context->controller = new AdminModulesController();
            }
            if ($this->_modulePath) {
                $this->context->controller->addCss($this->_modulePath . '/forms/' . $css, 'all');
            } else {
                $this->context->controller->addCss($this->_path . '/forms/' . $css, 'all');
            }
        }
        return;
    }

    private function addJS($js) {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {

            if ($this->context->controller instanceof stdClass) {
                $this->context->controller = new AdminModulesController();
            }
            if ($this->_modulePath) {
                $this->context->controller->addJs($this->_modulePath . '/forms/' . $js);
            } else {
                $this->context->controller->addJs($this->_path . '/forms/' . $js);
            }
        }
        return;
    }

    public function getLanguages() {
        $languages = Language::getLanguages();
        return $languages;
    }

    /**
     * 
     * @param string $name
     * @param string $text 
     * @param int $defaultValue
     * @param string $title 
     * @return $this
     */
    public function createSelectSupplier($name, $text, $defaultValue, $title = '') {
        $suppliers = Supplier::getSuppliers();
        return $this->createFormSelectFromArray($name, $text, array_merge([$this->modulo->l(' - Seleccione un proveedor - ')], $suppliers), 
                'id_supplier', 'name', $defaultValue, $title);
    }

    /**
     * 
     * @param string $name
     * @param string $text 
     * @param int $defaultValue
     * @param string $title 
     * @return $this
     */
    public function createSelectManufacturer($name, $text, $defaultValue, $title = '') {
        $manufacturers = Manufacturer::getManufacturers();
        return $this->createFormSelectFromArray($name, $text, array_merge([$this->modulo->l(' - Seleccione un fabricante - ')], $manufacturers), 
                'id_manufacturer', 'name', $defaultValue, $title);
    }

    /**
     * 
     * @param int $id_lang
     * @param string $name
     * @param string $text 
     * @param array $value
     * @param string $title 
     * @return $this
     */
    public function createSelectGroups($id_lang, $name, $text, $value, $title = '') {
        $groups = Group::getGroups($id_lang);
        return $this->createFormSelectFromArray($name, $text, array_merge([$this->modulo->l(' - Seleccione un grupo - ')], $groups), 
                'id_group', 'name', $value, $title);
    }

    /**
     * 
     * @param int $id_lang
     * @param string $name
     * @param string $text 
     * @param array $value
     * @param string $title 
     * @param boolean $referencia
     * @return $this
     */
    public function createCheckBoxCarriers($id_lang, $name, $text, $value, $title = '', $referencia = false) {
        $carriers = Carrier::getCarriers($id_lang);
        return $this->createCheckboxesFromArray($name, $text, $title, $carriers, ($referencia ? 'id_reference' : 'id_carrier'), 'name', $value, 
                1);
    }

    /**
     * 
     * @param int $id_lang
     * @param string $name
     * @param string $text 
     * @param array $idDefault
     * @param string $title 
     * @param boolean $referencia
     * @return $this
     */
    public function createSelectCarriers($id_lang, $name, $text, $idDefault, $title = '', $referencia = false) {
        $carriers = Carrier::getCarriers($id_lang);
        return $this->createFormSelectFromArray($name, $text, array_merge([$this->modulo->l(' - Seleccione un transportista - ')], $carriers), 
                ($referencia ? 'id_reference' : 'id_carrier'), 'name', $idDefault, $title);
    }

    /**
     * 
     * @param string $name
     * @param string $text 
     * @param mixed $defaultValue
     * @param string $title 
     * @return $this
     */
    function createSelectNameImages($name, $text, $defaultValue, $title = '') {
        $images = ImageType::getImagesTypes();
        return $this->createFormSelectFromArray($name, $text, array_merge([$this->modulo->l(' - Seleccione un tipo de Imagen - ')], $images), 
                'id_image_type', 'name', $defaultValue, $title);
    }

    public function mostrarCategorias($name, $prefijo, $idParentCategoria = 2) {
        $sql = '    SELECT '
                . '     c.id_category, c.id_parent, cl.name, s.id_category  AS checked, s.margen '
                . ' FROM '
                . '     ' . _DB_PREFIX_ . 'category AS c '
                . '     INNER JOIN ' . _DB_PREFIX_ . 'category_lang AS cl '
                . '         ON '
                . '             cl.id_category = c.id_category '
                . '             AND cl.id_lang = ' . $this->idLang . ''
                . '             AND c.id_shop_default = cl.id_shop '
                . '             AND c.id_shop_default = ' . $this->idShop . ''
                . '     LEFT JOIN ' . _DB_PREFIX_ . $prefijo . 'categorias AS s '
                . '         ON s.id_category = c.id_category '
                . ' WHERE '
                . '     c.id_parent  = ' . $idParentCategoria . ' '
                . ' ORDER BY '
                . '     c.id_parent, c.id_category ';
        $categorias = Db::getInstance()->executeS($sql);
        $html = '<table id="' . $name . '">';
        $html .= '<thead>';
        $html .= '<tr>';
        $html .= '<td>&nbsp;</td>';
        $html .= '<td><input type="button" onclick="checkImaxAll(this.form, \'catCheckbox\')" name="checkme" value="' . $this->modulo->l('Invertir Seleccion') . '"></td>';
        $html .= '<td>' . $this->modulo->l('Margen general') . '&nbsp;<input type="textbox" onChange="llenarMargen(this.form)" id="llenarMargenText" value=""/></td>';
        $html .= '</tr>';
        $html .= '<tr>';
        $html .= '<th>' . $this->modulo->l('Categoria') . '</th>';
        $html .= '<th>' . $this->modulo->l('Marcar para Exportar') . '</th>';
        $html .= '<th>' . $this->modulo->l('Margen') . '</th>';
        $html .= '</tr>';
        $html .= '</thead>';
        foreach ($categorias AS $categoria) {
            $num = 0;
            $html .= '<tr>';
            $html .= '<td><b>' . $categoria['name'] . '</b></td>';
            $checked = "";
            $porcentaje = "";
            if (!empty($categoria['checked'])) {
                $checked = ' checked="checked"';
                $porcentaje = $categoria['margen'];
            }
            $html .= '<td><input type="checkbox" class="catCheckbox" ' . $checked . ' value="' . $categoria['id_category'] . '" name="categoria[' . $categoria['id_category'] . '][check]" /></td>';
            $html .= '<td><input class="catInput" type="text" name="categoria[' . $categoria['id_category'] . '][margen]" value="' . $porcentaje . '"/></td>';
            $html .= '</tr>';
            $this->getHijosTable($categoria, $html, $num, $prefijo);
        }

        $html .= '</table>';

        $html .= '<input type="hidden" name="accion" value="addPorcentajesCategorias">';

        $html .= '</fieldset>';
        $this->formulario .= $html;
        return $this;
    }

    private function getHijosTable($categoria, &$html, &$num, $prefijo) {
        $numInterno = $num;
        $sqlHijos = '     SELECT '
                . '  c.id_category, c.id_parent, cl.name, s.id_category  AS checked, s.margen '
                . ' FROM '
                . ' ' . _DB_PREFIX_ . 'category AS c '
                . '     INNER JOIN ' . _DB_PREFIX_ . 'category_lang AS cl '
                . '         ON  '
                . '             cl.id_category = c.id_category '
                . '             AND cl.id_lang = ' . $this->idLang . ' '
                . '             AND c.id_shop_default = cl.id_shop '
                . '             AND c.id_shop_default = ' . $this->idShop . ' '
                . '     LEFT JOIN ' . _DB_PREFIX_ . $prefijo . 'categorias AS s '
                . '         ON s.id_category = c.id_category '
                . ' WHERE '
                . '     c.id_parent=' . $categoria['id_category'];

        $categoriasHijos = Db::getInstance()->executeS($sqlHijos);
        $num++;
        foreach ($categoriasHijos AS $categoriaHijo) {
            $checked = "";
            $porcentaje = "";
            if (!empty($categoriaHijo['checked']) && $categoriaHijo['checked'] != null) {
                $checked = ' checked="checked"';
                $porcentaje = $categoriaHijo['margen'];
            }
            $numClase = $num;
            $html .= '<tr class="tr_' . $numClase . '">';
            $html .= '<td>' . str_repeat("&nbsp;", $num * 2) . $categoriaHijo['name'] . '</td>';
            $html .= '<td><input type="checkbox" class="catCheckbox" ' . $checked . ' value="' . $categoriaHijo['id_category'] . '" name="categoria[' . $categoriaHijo['id_category'] . '][check]" /></td>';
            $html .= '<td><input class="catInput" type="text" name="categoria[' . $categoriaHijo['id_category'] . '][margen]" value="' . $porcentaje . '"/></td>';
            $html .= '</tr>';
            $this->getHijos($categoriaHijo, $html, $num);
        }
        $num = $numInterno;
    }

    /**
     * 
     * @param string $name
     * @param string $text 
     * @param int $defaultValue
     * @param string $title 
     * @param boolean $active
     * @param boolean $chosen
     * @return $this
     */
    public function createSelectCategory($name, $text, $defaultValue, $title = '', $active = true, $chosen = false) {
        $html = '';
        $html .= '<div class="form-group">';
        $html .= '<label for="' . $name . '" class="control-label">';
        $html .= '<span title="' . $title . '">';
        $html .= $text;
        $html .= '</span>';
        $html .= '</label>';
        $html .= '<div class="control-label">';
        $html .= '<select name="' . $name . '" id="' . $name . '">';
        $html .= '<option value="0">' . $this->modulo->l(' - Seleccione una categoria - ') . '</option>';
        $categoriaHome = new Category(Configuration::get('PS_HOME_CATEGORY'), $this->idLang);
        $temp = array();
        $temp['id_category'] = $categoriaHome->id;
        $temp['name'] = $categoriaHome->name;
        array_unshift($categories, $temp);
        //$categories[] = $temp;
        foreach ($categories AS $category) {
            $num = 1;
            $selected = '';
            if ($category['id_category'] == $defaultValue) {
                $selected = ' selected="selected"';
            }
            $html .= '<option class="level_1" ' . $selected . ' value="' . $category['id_category'] . '">' . htmlspecialchars(trim($category['name'])) . '</option>';
            if ($category['id_category'] == $categoriaHome->id) {
                continue;
            }
            $this->getHijos($category['id_category'], $defaultValue, $html, $num, $active);
        }
        $html .= '</select>';
        $html .= '</div>';
        $html .= '</div>';
        if ($chosen) {
            $html .= '<script language="javascript">           
                 $(function(){$("#' . $name . '").chosen();});
                </script>';
        }
        $this->formulario .= $html;

        return $this;
    }

    private function getHijos($id_parent, $defaultValue, &$html, &$num, $active) {
        $numInterno = $num;
        $categories = Category::getChildren($id_parent, $this->idLang, $active);
        if (!$categories) {
            return;
        }
        $num++;
        foreach ($categories AS $category) {
            $selected = '';
            if ($category['id_category'] == $defaultValue) {
                $selected = ' selected="selected"';
            }
            $html .= '<option class="level_' . $num . '" ' . $selected . ' value="' . $category['id_category'] . '">' . htmlspecialchars(trim($category['name'])) . '</option>';
            $this->getHijos($category['id_category'], $defaultValue, $html, $num, $active);
        }
        $num = $numInterno;
        return true;
    }

    /**
     * Crea un upload File.
     * @param string $name Nombre del boton
     * @param string $text Texto informativo 
     * @param string $title Titulo 
     * @return $this
     */
    public function createFormUploadFile($name, $text, $title = '') {
        $html = '';
        $html .= '<div class="form-group">';
        $html .= '<label for="' . $name . '" class="control-label">';
        $html .= '<span title="' . $title . '">';
        $html .= $text;
        $html .= '</span>';
        $html .= '</label>';
        $html .= '<div class="control-label">';
        $html .= '<input type="file"  name="' . $name . '" id="' . $name . '">';
        $html .= '</div>';
        $html .= '</div>';
        $this->formulario .= $html;

        return $this;
    }

    /**
     * Crea una tabla dinamica.
     * @param string $name Identificador de la tabla.
     * @param string $table Nombre de la tabla en la base de datos.
     * @param string[] $campos Nombres de los campos en base de datos.
     * @param string[] $camposBusqueda Nombres de los campos en base de datos para las busquedas.
     * @param string $url Ruta base.
     * @param string $serverfile Archivo de destino en el servidor.
     * @param string $contenidoCabecera Los "tr" para la cabecera.
     * @param string[] $codigoFormateadores [id del formateador => Contenido de la funcion formateadora, recibe los parametros column y row].
     * @param string $codigoEventoLoad Contenido de la funcion del evento load. La tabla viene en la variable grid. Tambien se dispone de e.
     * @return $this
     */
    function createTableAjax($name, $table, $campos, $camposBusqueda, $url, $serverfile, $contenidoCabecera, $codigoFormateadores = array(), $codigoEventoLoad = '') {
        $html = '<div class="form-group" style="float:none">';
        $html .= '<style>
                    #' . $name . '-footer { float: none !important; }
                  </style>'
                . '<link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">'
                . '<link href="' . $url . 'bootgrid/css/jquery.bootgrid.css" rel="stylesheet">
            <table id="' . $name . '" class="table table-condensed table-hover table-striped">
                <thead>
                        ' . $contenidoCabecera . '
                </thead>
            </table>';

        $campos = urlencode(serialize($campos));
        $camposBusqueda = urlencode(serialize($camposBusqueda));
        $table = urlencode(trim($table));
        $codigoFormateadoresString = '';
        foreach ($codigoFormateadores as $idFormateador => $codigoFormateador) {
            $codigoFormateadoresString .= <<<EOT
                $idFormateador: function(column, row){
                    $codigoFormateador
                },
EOT;
        }
        $html .= '<script src="' . $url . 'bootgrid/js/jquery.bootgrid.min.js"></script>';
        $html .= <<<EOT
                <script language="javascript">
                    $(function() {
                       var grid = $("#$name").bootgrid(
                        {
                            ajax:true, 
                            post: function()  {
                                return {
                                    id: "b0df282a-0d67-40e5-8558-c9e93b7befed"
                                };
                            },
                            url: "{$url}bootgrid/php/$serverfile?tabla=$table&campos=$campos&camposBusqueda=$camposBusqueda",
                            formatters: {
                                $codigoFormateadoresString
                            }    
                        }).on("loaded.rs.jquery.bootgrid", function(e)
                            {
                                $codigoEventoLoad
                            });
                  });
                </script>
EOT;
        $html .= '</div>';
        $this->formulario .= $html;

        return $this;
    }

    private function addExtras($extras) {
        $html = '';
        if ($extras && is_array($extras)) {
            foreach ($extras AS $indice => $valor) {
                $html .= $indice . '="' . $valor . '"';
            }
        }
        return $html;
    }

    public function __toString() {
        return $this->renderForm(true);
    }

    public function createCheckBoxManufacturer($name, $defaultValue, $text = '') {
        $manufacturers = Manufacturer::getManufacturers();
        return $this->createCheckboxesFromArray($name, $text, '', $manufacturers, 'id_manufacturer', 'name', $defaultValue, 3);
    }

    /**
     * 
     * @param int $id_lang
     * @param string $name
     * @param string $text 
     * @param array $values
     * @param string $title 
     * @return $this
     */
    public function createOptionStatuses($id_lang, $name, $text, $values, $title = '') {
        $status = OrderState::getOrderStates($id_lang);
        $html .= '<div class="form-group">';
        $html .= '<label for="' . $name . '" class="control-label col-lg-3">';
        $html .= '<span title="' . $title . '">';
        $html .= $text;
        $html .= '</span>';
        $html .= '</label>';
        $html .= '<div class="col-lg-3">';
        $html .= '<select name="' . $name . '" id="' . $name . '">';
        $html .= '<option value="0">' . $this->modulo->l(' - Seleccione el estado - ') . '</option>';
        foreach ($status AS $statuses) {
            $idStatus = $statuses['id_order_state'];
            $marcado = '';
            foreach ($values as $v) {
                if ($idStatus == $v) {
                    $marcado = ' checked ';
                    break;
                }
            }
            $html .= '<option " ' . $marcado . ' value="' . $statuses['id_order_state'] . '">' . htmlspecialchars(trim($statuses['name'])) . '</option>';
        }
        $html .= '</select>';
        $html .= '</div>';
        $html .= '</div>';

        $this->formulario .= $html;
        return $this;
    }

    /**
     * 
     * @param string $name
     * @param string $text 
     * @param int $defaultValue
     * @param string $title 
     * @return $this
     */
    public function createSelectStatuses($idLang, $name, $text, $defaultValue, $title = '') {
        $status = OrderState::getOrderStates($idLang);
        return $this->createFormSelectFromArray($name, $text, array_merge([$this->modulo->l(' - Seleccione el estado - ')], $status), 
                'id_order_state', 'name', $defaultValue, $title);
    }

    /**
     * 
     * @param string $name
     * @param string $text 
     * @param int $defaultValue
     * @param string $title 
     * @return $this
     */
    public function createSelectFeatures($idLang, $name, $text, $defaultValue, $title = '') {
        $features = Feature::getFeatures($idLang);
        return $this->createFormSelectFromArray($name, $text, array_merge([$this->modulo->l(' - Seleccione una característica - ')], $features), 
                'id_feature', 'name', $defaultValue, $title);
    }

    /**
     * 
     * @param string $name
     * @param string $text 
     * @param int $defaultValue
     * @param string $title 
     * @return $this
     */
    public function createSelectFeaturesValues($idLang, $name, $text, $defaultValue, $value, $title = '') {
        $features = FeatureValue::getFeatureValuesWithLang($idLang, $value);
        return $this->createFormSelectFromArray($name, $text, array_merge([$this->modulo->l(' - Seleccione un valor de característica - ')], 
                $features), 'id_feature_value', 'value', $defaultValue, $title);
    }

    /**
     * Genera un select a partir de un array asociativo.
     * @param string $name
     * @param string $text
     * @param array $datos
     * @param string $claveId
     * @param string $claveValores
     * @param mixed $selectedValue
     * @param string $title
     * @param array $extras
     * @return $this
     */
    public function createFormSelectFromArray($name, $text, $datos, $claveId, $claveValores, $selectedValue, $title = '', $extras = null) {
        $datosFormateados = array();
        foreach ($datos as $dato) {
            $datosFormateados[$dato[$claveId]] = $dato[$claveValores];
        }

        return $this->createFormSelect($name, $text, $datosFormateados, $selectedValue, $title, $extras);
    }
    
    /**
     * Crea un select.
     * @param string $name
     * @param array $text 
     * @param string $datos valor => visible
     * @param string $defaultValues
     * @param string $title 
     * @param array $extras
     * @return $this
     */
    function createFormSelectMultiple($name, $text, $datos, $defaultValues, $title = '', $extras = null) {
        $this->addJS('jquery.chosen.js');
        $this->addCSS('jquery.chosen.css');
        $html = '';
        $html .= '<div class="form-group selectMultiple">';
        $html .= '<label for="' . $name . '" class="control-label">';
        $html .= '<span title="' . $title . '">';
        $html .= $text;
        $html .= '</span>';
        $html .= '</label>';
        $html .= '<div class="control-label">';
        $html .= '<select name="' . $name . '[]" id="' . $name . '" multiple ';
        if ($extras) {
            foreach ($extras AS $indice => $extra) {
                $html .= $indice . '="' . $extra . '"';
            }
        }
        $html .= '>';
        foreach ($datos AS $valor => $texto) {
            $selected = '';           
            if (is_array($defaultValues) && in_array($valor, $defaultValues)) {
                $selected = ' selected="selected" ';
            }
            $html .= '<option value="' . $valor . '" ' . $selected . '>' . $texto . '</option>';
        }
        $html .= '</select>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '<script>';
        $html .= '$("#'.$name.'").chosen({})';
        $html .= '</script>';
        $this->formulario .= $html;

        return $this;
    }
    
     /**
     * Genera un select a partir de un array asociativo.
     * @param string $name
     * @param string $text
     * @param array $datos
     * @param string $claveId
     * @param string $claveValores
     * @param mixed $selectedValues
     * @param string $title
     * @param array $extras
     * @return $this
     */
    public function createFormSelectMultipleFromArray($name, $text, $datos, $claveId, $claveValores, $selectedValues, $title = '', $extras = null) {
        $datosFormateados = array();
        foreach ($datos as $dato) {
            $datosFormateados[$dato[$claveId]] = $dato[$claveValores];
        }

        return $this->createFormSelectMultiple($name, $text, $datosFormateados, $selectedValues, $title, $extras);
    }

    /**
     * Crea una tabla para trabajar con un ObjectModel.
     * Se puede usar un campo "overrideType" en las columnas del ObjectModel para usar tipos personalizados, ej: select (Este tipo hace 
     * necesaria una función estática "getSelectValues" que devuelva los valores del select).
     * @param string $objectModelName
     * @param string[] $columnNames Las traducciones para los nombres de las columnas.
     * @param string[] $columnOrder El orden de las columnas.
     * @param string[] $hideColumns Columnas que no se desean en la tabla.
     * @param string $aggregationColumn Nombre de la columna por la que se agrupa.
     * @param string $aggregationColumnValue Valor de la columna anterior para agrupar.
     * @return $this
     */
    public function createFormObjectModelTable($objectModelName, $columnNames = array(), $columnOrder = array(), $hideColumns = array(), 
            $aggregationColumn = '', $aggregationColumnValue = '') {
        $campos = $objectModelName::$definition['fields'];
        //Ordenamos
        uksort($campos, function($a, $b) use ($columnOrder) {
            $posA = array_search($a, $columnOrder);
            if($posA === false) {
                $posA = PHP_INT_MAX;
            }
            $posB = array_search($b, $columnOrder);
            if($posB === false) {
                $posB = PHP_INT_MAX;
            }
            return $posA - $posB;
        });
        $idPrimario = $objectModelName::$definition['primary'];
        $sql = "SELECT $idPrimario FROM `"._DB_PREFIX_.$objectModelName::$definition['table'].'`';
        if($aggregationColumn) {
            $aggregationColumnValue = pSQL($aggregationColumnValue);
            $sql .= " WHERE `$aggregationColumn` = '$aggregationColumnValue'";
        }
        $ids = Db::getInstance()->executeS($sql);
        
        //Creamos la tabla
        if(!$aggregationColumnValue) {
            $aggregationColumnValue = uniqid();
        }
        $filaVacia = json_encode($this->generateImaxTableRow($objectModelName, 'newRow', $campos, null, $hideColumns, $aggregationColumn, 
                $aggregationColumnValue));
        $this->formulario .= "<script>if(typeof emptyRow_$objectModelName === 'undefined') { var emptyRow_$objectModelName = { }; }</script>";
        $this->formulario .= "<script>emptyRow_{$objectModelName}['$aggregationColumnValue'] = $filaVacia;</script>";
        $this->formulario .= '<input type="hidden" name="imaxTableModels[]" value="'.$objectModelName.'"/>';
        $this->formulario .= '<table class="table imaxTable">';
        $this->formulario .= '<thead>';
        $this->formulario .= '<tr>';
        foreach($campos as $nombreCampo => $infoCampo) {
            if(in_array($nombreCampo, $hideColumns)) {
                $hidden = 'imax_hide';
            }
            else {
                $hidden = '';
            }
            $nombreVisible = (isset($columnNames[$nombreCampo]) ? $columnNames[$nombreCampo] : $nombreCampo);
            $this->formulario .= "<th class='$hidden'>$nombreVisible</th>";
        }
        $this->formulario .= '<td><input type="button" name="imaxTableNewRow" value="+" data-object_model="'.$objectModelName.'" data-aggregation_column_value="'.$aggregationColumnValue.'"/></td>';
        $this->formulario .= '</tr>';
        $this->formulario .= '</thead>';
        $this->formulario .= '<tbody>';
        foreach($ids as $id) {
            $id = $id[$idPrimario];
            $objeto = new $objectModelName($id);
            
            $this->formulario .= $this->generateImaxTableRow($objectModelName, $id, $campos, $objeto, $hideColumns);
        }
        $this->formulario .= '</tbody>';
        $this->formulario .= '</table>';
        
        return $this;
    }
    
    /**
     * Genera una fila de datos para la tabla de ObjectModel.
     * Se puede usar un campo "overrideType" en las columnas del ObjectModel para usar tipos personalizados, ej: select (Este tipo hace 
     * necesaria una función estática "getSelectValues" que devuelva los valores del select).
     * @param string $objectModelName
     * @param mixed $id
     * @param array $fields
     * @param ObjectModel $object
     * @param string[] $hideColumns
     * @param string $aggregationColumn Nombre de la columna por la que se agrupa.
     * @param string $aggregationColumnValue Valor de la columna anterior para agrupar.
     * @return string
     */
    private function generateImaxTableRow($objectModelName, $id, $fields, $object = null, $hideColumns = array(), 
            $aggregationColumn = '', $aggregationColumnValue = '') {
        $auxForm = new imaxForm($this->modulo, $this->_path, '', '', '', '', array(), true);
        
        $html = '<tr class="imaxTableRow">';
        foreach($fields as $nombreCampo => $infoCampo) {
            if($aggregationColumn == $nombreCampo) {
                $valor = $aggregationColumnValue;
            }
            else {
                $valor = ($object ? $object->$nombreCampo : '');
            }
            
            if(in_array($nombreCampo, $hideColumns)) {
                $html .= '<td class="imax_hide">';
                $auxForm->createHidden("imaxTableRow[$objectModelName][$id][$nombreCampo]", $valor);
            }
            else {
                $html .= '<td>';
                $overrideType = (!empty($infoCampo['overrideType']) ? $infoCampo['overrideType'] : '');
                if($overrideType) {
                    switch($overrideType) {
                        case 'select':
                            $auxForm->createFormSelect("imaxTableRow[$objectModelName][$id][$nombreCampo]", '', 
                                    $objectModelName::getSelectValues($nombreCampo), ($object ? $object->$nombreCampo : ''));
                            break;
                    }
                }
                else {
                    $tipo = (!empty($infoCampo['type']) ? $infoCampo['type'] : '');
                    switch($tipo) {
                        case ObjectModel::TYPE_BOOL:
                            $auxForm->createFormCheckboxGroup("imaxTableRow[$objectModelName][$id][$nombreCampo]", '', $valor);
                            break;

                        default:
                            $auxForm->createFormTextGroup("imaxTableRow[$objectModelName][$id][$nombreCampo]", $valor, '', '', !empty($infoCampo['lang']));
                            break;
                    }
                }
            }
            $html .= $auxForm->renderForm(true);
            $html .= '</td>';
        }
        $html .= '<td><input type="button" name="imaxTableDeleteRow" value="X"/></td>';
        $html .= '</tr>';
        
        return $html;
    }
    
    /**
     * Graba automaticamente las tablas de ObjectModel.
     * @param array $post Debe contener imaxTableModels -> los ObjectModels cargados y imaxTableRow -> los datos correspondientes.
     * @return boolean 
     */
    public static function saveFormObjectModelTables($post) {
        //Primero eliminamos los modelos que no vienen
        if(!empty($post['imaxTableModels'])) {
            foreach($post['imaxTableModels'] as $objectModelName) {
                if(empty($post['imaxTableRow'][$objectModelName])) {
                    $idPrimario = $objectModelName::$definition['primary'];
                    $ids = Db::getInstance()->executeS("SELECT $idPrimario FROM `"._DB_PREFIX_.$objectModelName::$definition['table'].'`');
                    foreach($ids as $id) {
                        $obj = new $objectModelName($id[$idPrimario]);
                        $obj->delete();
                    }
                }
            }
        }
        
        //Resto de operaciones
        if(!empty($post['imaxTableRow'])) {
            foreach($post['imaxTableRow'] as $objectModelName => $objectModelsData) {
                $campos = $objectModelName::$definition['fields'];
                $idsExistentes = array();
                //Nuevos y existentes
                foreach($objectModelsData as $id => $objectModelData) {
                    $obj = new $objectModelName((int)$id);
                    foreach($objectModelData as $field => $value) {
                         $obj->$field = $value;
                    }
                    //Checks que no vienen
                    foreach($campos as $field => $infoCampo) {
                        if(!isset($objectModelData[$field]) && !empty($infoCampo['type']) && $infoCampo['type'] == ObjectModel::TYPE_BOOL) {
                            $obj->$field = false;
                        }
                    }
                    $obj->save();
                    
                    $idsExistentes[] = (int)$obj->id;
                }

                //Eliminaciones
                $idPrimario = $objectModelName::$definition['primary'];
                $idsExistentesString = implode(',', array_filter($idsExistentes));
                $where = ($idsExistentesString ? "WHERE $idPrimario NOT IN ($idsExistentesString)" : '');
                $ids = Db::getInstance()->executeS("SELECT $idPrimario FROM `"._DB_PREFIX_.$objectModelName::$definition['table']."` $where");
                foreach($ids as $id) {
                    $obj = new $objectModelName($id[$idPrimario]);
                    $obj->delete();
                }
            }
        }
        
        return true;
    }
    
    public function createCheckBoxFeatures($idLang, $name, $defaultValue, $text = '') {
        $features = Feature::getFeatures($idLang);
        return $this->createCheckboxesFromArray($name, $text, '', $features, 'id_feature', 'name', $defaultValue, 3);
    }
    
    public function createCheckBoxFeaturesValue($idLang, $name, $valueCarac, $nameFeature, $defaultValue) {
        $features = FeatureValue::getFeatureValuesWithLang($idLang, $valueCarac);  		
        return $this->createCheckboxesFromArray($name, $nameFeature, '', $features, 'id_feature_value', 'value', $defaultValue, 3);
    }
    
    /**
     * Crea una lista de checkbox a partir de un array.
     * @param string $name
     * @param string $text
     * @param string $title
     * @param array $datos
     * @param string $claveId
     * @param string $claveValores
     * @param array $selectedValues
     * @param int $columnas La cantidad de columnas en la que se dividira la lista.
     * @param array $extras
     * @return $this
     */
    public function createCheckboxesFromArray($name, $text, $title, $datos, $claveId, $claveValores, $selectedValues = array(), $columnas = 3, $extras = array()) {		
        $html = '';
        $numElementos = count($datos);
        $elementos = ceil($numElementos / $columnas);
        $i = 0;
        $html .= '<div class="bootstrap checkboxList">';
        $html .= '<div class="form-group nopoint"';
        $html .= $this->addExtras($extras);
        $html .= '>';
        $html .= '<label class="control-label">';
        $html .= '<span title="' . $title . '">';
        $html .= $text;
        $html .= '</span>';
        $html .= '</label>';
        foreach ($datos as $dato) {			
            $checked = '';
            if (in_array($dato[$claveId], $selectedValues)) {
                $checked = "checked='checked'";
            }
            if ($i == 0) {
                $html .= '<ul>';
            }
            
            $html .= '<li class="clearfix">';
            $html .= '<label>';
            $html .= '<input type="checkbox" ' . $checked . ' value="' . $dato[$claveId] . '" name="' . $name . '[]" id="' . $name . '">';
            $html .= $dato[$claveValores];
            $html .= '<div class="control-label">';
            $html .= '</label>';
            $html .= '</li>';
            $i++;
            if ($i >= $elementos) {
                $html .= '</ul>';
                $i = 0;
            }
        }
        $html .= '</ul>';
        $html .= '</div>';
        $html .= '</div>';
		
        $this->formulario .= $html;

        return $this;
    }
}
