<?php

function upgrade_module_3_65($module) {
    $transportistas = ['CORREOS' => 'correos', 'CORREOSEXPRESS' => 'correos_express', 'GLS' => 'gls', 'FEDEX' => 'fedex', 
        'DB_SCHENKER' => 'dbschenker', 'MONDIALRELAY' => 'modial_relay', 'ASENDIA' => 'asendia', 'ASM' => 'asm', 'UPS' => 'ups', 
        'CTT' => 'ctt', 'MRW' => 'mrw', 'ENVIALIA' => 'envialia', 'COLISSIMO' => 'colissimo', 'TIPSA' => 'tipsa', 'DHL' => 'dhl', 
        'CERTIFICADO' => 'certificado', 'ORDINARIO' => 'ordinario', 'SEUR' => 'seur', 'GDS' => 'gds', 'PAQ_LIGERO' => 'correos_paq_ligero',
        'GENERICO' => 'generica', 'ZELERIS' => 'zeleris'];
    foreach($transportistas as $original => $nuevo) {
        $datos = [
            'idsReference' => unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.$original)),
            'nuevoEstado' => Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'ESTADO_'.$original),
            'bultosManuales' => Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'BULTOS_MANUALES_'.$original)
        ];

        switch($original) {
            case 'CORREOSEXPRESS':
                $datos['nuevoEstado'] = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'ESTADO_CX');
                $datos['incluirRefs'] = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'INCLUIR_REFS');
                $datos['refOrId'] = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'REF_OR_ID');
                $datos['referenciaAmazon'] = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'REFERENCIA_AMAZON');
                $datos['separadorAmazon'] = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'SEPARADOR_AMAZON');
                $datos['inversaCex'] = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'INVERSA_CEX');
                break;
            
            case 'GLS':
                $datos['incluirRefsGls'] = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'INCLUIR_REFS_GLS');
                $datos['etiqXprodGls'] = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'ETIQ_X_PROD_GLS');
                $datos['usarProductPackageGls'] = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'USAR_PRODUCT_PACKAGE_GLS');
                break;
            
            case 'CERTIFICADO':
                $datos['inventarSeguimientoCertificado'] = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'INVENTAR_SEGUIMIENTO_CERTIFICADO');
                break;
            
            case 'ORDINARIO':
                $datos['inventarSeguimientoOrdinario'] = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'INVENTAR_SEGUIMIENTO_ORDINARIO');
                break;
            
            case 'ZELERIS':
                $datos['agenciaZeleris'] = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'AGENCIA_ZELERIS_SELECTED');
                break;
        }
        Configuration::updateGlobalValue(ImaxImprimePedidosServidor::prefijo.'datosTransportista_'.$nuevo, serialize($datos));
    }
    
    Configuration::updateGlobalValue(ImaxImprimePedidosServidor::prefijo . 'AGENCIAS_ZELERIS', json_encode([
        12 => 'Zeleris Día Siguiente'
    ]));
    
    return true;
}
