<?php

function upgrade_module_1_24($module) {
    $sql[] = 'ALTER TABLE `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo.'bloqueoPedido`
        ADD COLUMN `idTipoPedido` TINYINT(1) NOT NULL DEFAULT "0" AFTER `idPedido`';
    $sql[] = 'ALTER TABLE `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo.'bloqueoPedido`
        DROP PRIMARY KEY, ADD PRIMARY KEY (`idPedido`, `idTipoPedido`)';
    $sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."altaCompras` (
        `id` int(10) NOT NULL AUTO_INCREMENT,      
        `referencia` VARCHAR(255) NULL,
        `fechaEntrada` TIMESTAMP NULL,
        `finalizado` TINYINT(1) NOT NULL DEFAULT '0',
        `empleadoFinaliza` INT(11) NULL DEFAULT NULL,
        `fechaFinaliza` TIMESTAMP NULL DEFAULT NULL,
        `stockAgregado` TINYINT(1) NOT NULL DEFAULT '0',
	PRIMARY KEY (`id`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";
    $sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."altaComprasDetalle` (
        `id` int(10) NOT NULL AUTO_INCREMENT, 
        `idAlta` int(10) NOT NULL,
        `id_product` int(10) NOT NULL,        
        `id_product_attribute` int(10) NOT NULL,        
        `stock` int(10) NOT NULL,
        `stockRecibido` int(10) NOT NULL,
        PRIMARY KEY (`id`),
        KEY (`idAlta`),
        KEY (`id_product`, `id_product_attribute`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

    $sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."imagenPendiente` (
            `id` INT(11) NOT NULL AUTO_INCREMENT, 
            `id_imagen` INT(11) NOT NULL, 
            `id_product` INT(11) NOT NULL, 
            `urlImagen` VARCHAR(1000) NULL, 
            `hash` VARCHAR(250) NULL, 
            `esPrincipal` INT(1) DEFAULT 0, 
            `procesado` INT(1) DEFAULT 0, 
            `numIntentos` TINYINT(1) NOT NULL DEFAULT 0,
	  PRIMARY KEY (`id`), 
	  UNIQUE KEY (`hash`)
          )
	  COLLATE='utf8_general_ci' ENGINE=MyIsam;";

    $sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."processed` (
	`sku` VARCHAR(255) NOT NULL,
        `id_product` INT(11) NOT NULL,    
        `precio` VARCHAR(255) NULL,   
        `precioOferta` VARCHAR(255) NULL,   
        `url` VARCHAR(1000) NULL,           
        `urlAllReviews` VARCHAR(1000) NULL,   
        `urlOffers` VARCHAR(1000) NULL,   
	PRIMARY KEY (`sku`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

    $sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."w_pro` (
	`sku` VARCHAR(255) NOT NULL,
        PRIMARY KEY (`sku`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

    $sql[] = "CREATE TABLE `"._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."mensajeAltaCompra` (
            `idMensaje` INT NOT NULL AUTO_INCREMENT,
            `idAltaCompra` INT NOT NULL,
            `mensaje` VARCHAR(255) NOT NULL,
            PRIMARY KEY (`idMensaje`),
            INDEX (`idAltaCompra`)
        )
        COLLATE='utf8_spanish2_ci'
        ENGINE=MyIsam;";

    foreach ($sql as $s) {
        if (!Db::getInstance()->execute($s)) {
            return false;
        }
    }

    return true;
}
