<?php

$sql = array();

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."descarga` (
        `idPedido` int(10) NOT NULL,
        `pedidoDescargado` tinyint(1) NOT NULL DEFAULT 0,
        `facturaDescargado` tinyint(1) NOT NULL DEFAULT 0,
        `etiquetaDescargado` tinyint(1) NOT NULL DEFAULT 0,
	PRIMARY KEY (`idPedido`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=InnoDB;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."estadoMontable` (
        `idEstadoPedido` int(10) NOT NULL,
        `id_employee` int(10) NOT NULL,
	PRIMARY KEY (`idEstadoPedido`, `id_employee`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."bloqueoPedido` (
        `idPedido` int(10) NOT NULL,
        `idTipoPedido` tinyint(1) NOT NULL DEFAULT 0,
        `idEmpleado` int(10) NOT NULL,
        `uniq` CHAR(23) NOT NULL DEFAULT '',
        `acceso` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`idPedido`, `idTipoPedido`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."procesadoPedido` (
        `idPedido` int(10) NOT NULL,
        `idEmpleado` int(10) NOT NULL,
        `fechaInicio` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
        `fechaFin` TIMESTAMP NULL,
        `bultos` int(10) NOT NULL DEFAULT 1,
	PRIMARY KEY (`idPedido`, `idEmpleado`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."imprimirEtiqueta` (
        `idPedido` int(10) NOT NULL,
        `etiqueta` tinyint(1) NOT NULL DEFAULT 1,
        `pedido` tinyint(1) NOT NULL DEFAULT 0,
        `factura` tinyint(1) NOT NULL DEFAULT 0,
	PRIMARY KEY (`idPedido`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."licencias` (
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`nombre` VARCHAR(50) NOT NULL,
	`licencia` VARCHAR(50) NOT NULL,
    `numCheck` INT(11) NOT NULL DEFAULT '1001',
	`validate` TINYINT(2) NOT NULL DEFAULT '0',
	PRIMARY KEY (`id`)
        )
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."extraProducto` (
        `id_product` int(10) NOT NULL,
        `id_product_attribute` int(10) NOT NULL DEFAULT 0,
        `ubicacion` VARCHAR(255) NULL,
	PRIMARY KEY (`id_product`, `id_product_attribute`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."altaCompras` (
        `id` int(10) NOT NULL AUTO_INCREMENT,      
        `referencia` VARCHAR(255) NULL,
        `fechaEntrada` TIMESTAMP NULL,
        `finalizado` TINYINT(1) NOT NULL DEFAULT '0',
        `empleadoFinaliza` INT(11) NULL DEFAULT NULL,
        `fechaFinaliza` TIMESTAMP NULL DEFAULT NULL,
        `stockAgregado` TINYINT(1) NOT NULL DEFAULT '0',
	PRIMARY KEY (`id`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";
$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."altaComprasDetalle` (
        `id` int(10) NOT NULL AUTO_INCREMENT, 
        `idAlta` int(10) NOT NULL,
        `id_product` int(10) NOT NULL,        
        `id_product_attribute` int(10) NOT NULL,        
        `stock` int(10) NOT NULL,
        `stockRecibido` int(10) NOT NULL,
        `ref_fabrica` VARCHAR(255) NOT NULL,
        `ean` VARCHAR(255) NOT NULL,
        `referencia` VARCHAR(255) NOT NULL,
        PRIMARY KEY (`id`),
        KEY (`idAlta`),
        KEY (`id_product`, `id_product_attribute`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."imagenPendiente` (
            `id` INT(11) NOT NULL AUTO_INCREMENT, 
            `id_imagen` INT(11) NOT NULL, 
            `id_product` INT(11) NOT NULL, 
            `urlImagen` VARCHAR(1000) NULL, 
            `hash` VARCHAR(250) NULL, 
            `esPrincipal` INT(1) DEFAULT 0, 
            `procesado` INT(1) DEFAULT 0, 
            `numIntentos` TINYINT(1) NOT NULL DEFAULT 0,
	  PRIMARY KEY (`id`), 
	  UNIQUE KEY (`hash`)
          )
	  COLLATE='utf8_general_ci' ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."processed` (
	`sku` VARCHAR(255) NOT NULL,
        `id_product` INT(11) NOT NULL,    
        `precio` VARCHAR(255) NULL,   
        `precioOferta` VARCHAR(255) NULL,   
        `url` VARCHAR(1000) NULL,           
        `urlAllReviews` VARCHAR(1000) NULL,   
        `urlOffers` VARCHAR(1000) NULL,   
	PRIMARY KEY (`sku`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."w_pro` (
	`sku` VARCHAR(255) NOT NULL,
        PRIMARY KEY (`sku`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE `"._DB_PREFIX_.self::prefijo."mensajeAltaCompra` (
            `idMensaje` INT NOT NULL AUTO_INCREMENT,
            `idAltaCompra` INT NOT NULL,
            `mensaje` VARCHAR(255) NOT NULL,
            `id_employee` INT,
            PRIMARY KEY (`idMensaje`),
            INDEX (`idAltaCompra`)
        )
        COLLATE='utf8_spanish2_ci'
        ENGINE=MyIsam;";
$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."numSerie` (
	`id_order` INT(11) NOT NULL,
	`id_order_detail` INT(11) NOT NULL,
	`id_product` INT(11) NOT NULL,
	`id_product_attribute` INT(11) NOT NULL,
	`num` INT(11) NOT NULL,
	`numSerie` VARCHAR(255) NOT NULL,
	PRIMARY KEY (`id_order`, `id_order_detail`, `id_product`, `id_product_attribute`, `num`),
    INDEX (`numSerie`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";
$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."numSerieActivo` (		
        `id_product` int(10) NOT NULL,		
        `activo` int(10) NOT NULL,
	PRIMARY KEY (`id_product`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."numSerieActivoCat` (		
        `id_category` int(10) NOT NULL,
        PRIMARY KEY (`id_category`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."servido` (		
        `idPedido` int(10) NOT NULL,
        `idProducto` int(10) NOT NULL,
        `idCombinacion` int(10) NOT NULL,
        `cantidadNecesaria` int(10) NOT NULL,
        `cantidadServida` int(10) NOT NULL,
	PRIMARY KEY (`idPedido`, `idProducto`, `idCombinacion`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."catExtra` (		
        `id_category` int(10) NOT NULL,
        `dhlAirContenido` VARCHAR(255) NULL,
	PRIMARY KEY (`id_category`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."employeeExtra` (		
        `id_employee` int(10) NOT NULL,
        `proveedores` BLOB NULL,
        `formasPago` BLOB NULL,
	PRIMARY KEY (`id_employee`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."orderExtra` (		
        `id_order` int(10) NOT NULL,
        `id_store` int(10) NULL,
	PRIMARY KEY (`id_order`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."orderDetailExtra` (		
        `id_order` int(10) NOT NULL,
        `id_order_detail` int(10) NOT NULL,
        `id_product` INT(11) NOT NULL,
        `id_product_attribute` INT(11) NOT NULL,
        `id_product_reemplazo` int(10) NULL,
        `id_product_attribute_reemplazo` int(10) NULL,
	PRIMARY KEY (`id_order`, `id_order_detail`, `id_product`, `id_product_attribute`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."filaPedidoEliminada` (		
        `id_order` int(10) NOT NULL,
        `id_order_detail` int(10) NOT NULL,
        `id_employee` int(10) NOT NULL,
        `fila` BLOB NOT NULL,
        `fecha` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id_order`, `id_order_detail`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."numBultos` (		
        `id_order` int(10) NOT NULL,
        `bultos` int(10) NOT NULL,
        `descargado` TINYINT(1) NOT NULL DEFAULT '0',
	PRIMARY KEY (`id_order`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."pedidoPendiente` (		
        `id_order` int(10) NOT NULL,
        `id_employee` int(10) NOT NULL,
	PRIMARY KEY (`id_order`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."imprimirEtiquetaProducto` (		
        `id_order` int(10) NOT NULL,
        `id_product` int(10) NOT NULL,
        `id_product_attribute` int(10) NOT NULL,
        `id_employee` int(10) NOT NULL,
        PRIMARY KEY (`id_order`, `id_product`, `id_product_attribute`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."opcionImprimirEtiquetaProducto` (
        `id_product` int(10) NOT NULL,
        `id_product_attribute` int(10) NOT NULL,
        `imprimirEtiqueta` TINYINT(1) NOT NULL DEFAULT '0',
        `imprimirUnaEtiqueta` TINYINT(1) NOT NULL DEFAULT '0',
        PRIMARY KEY (`id_product`, `id_product_attribute`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."etiquetaProductoImpresa` (		
        `id_order` int(10) NOT NULL,
        `id_product` int(10) NOT NULL,
        `id_product_attribute` int(10) NOT NULL,
        `id_employee` int(10) NOT NULL,
        PRIMARY KEY (`id_order`, `id_product`, `id_product_attribute`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."opcionAlmacenProducto` (
        `id_product` int(10) NOT NULL,
        `id_product_attribute` int(10) NOT NULL,
        `almacenesMostrar` BLOB NULL,
        `almacenEntradaPorDefecto` int(10) NOT NULL DEFAULT '0',
        `almacenSalidaPorDefecto` int(10) NOT NULL DEFAULT '0',
        PRIMARY KEY (`id_product`, `id_product_attribute`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";