<?php

class ImaxLog {

	private static $instance;
	private $msg;
	private $object;
	private $errorLevel;
	private $errorCode;
	private $destinos;
	private $context;
	private $activo = TRUE;
	
	const VERSION = '1.2';
	
	private function __construct() { }

	/**
	 *  Clase singleton, si existe una instancia de la clase la devuelve,
	 * si no existe, la crea y la devuelve
	 * @return ImaxLog Object
	 */
	static function getLog() {
		if (empty(self::$instance))
			self::$instance = new ImaxLog();
		return self::$instance;
	}

	/**
	 * Clona el objeto de tipo ImaxLog y lo devuelve
	 * @return ImaxLog Object
	 */
	public function cloneImaxLog() {
		return clone($this);
	}
	
	/**
	 * Sirve para activar y desctivar los logs.
	 * @param boolean $estado
	 */
	public function modificarEstado($estado) {
		$this->activo = (boolean)$estado;
	}

	/**
	 *  Añade el log, envia los correos y/o saca por pantalla dependiendo de la configuracion
	 * @param string $msg Mensaje de Error a enviar
	 * @param int $errorLevel Nivel del error (1-5)
	 * @param string $errorCode Codigo del error
	 * @param array $destinos Array asociativo con los campos email, log y screen, y los valores 0/1 si se desea activar o no
	 * @param exception $exception Excepcion generada
	 * @param ObjectModel $object Objeto que ha provocado el error
	 * @return boolean
	 */
	public function addLog($msg, $errorLevel, $errorCode, $destinos, $exception = null, $object = null, $subject = 'Informacion') {
		if (!is_array($destinos) || !$this->activo) {
			return false;
		} 
          /*
          if(is_array($msg)) {
               $temp = '';
               $sw = 0;
               foreach($msg AS $indice => $valor) {
                    if($sw == 0) {
                         $temp .= $indice.'=>'.$valor;
                         $sw = 1;
                    }else {
                         $temp .= "<br />".$indice.'=>'.$valor;
                    }
               }
               $msg = $temp;
          }
          */
		$this->msg = $msg;
		$this->object = $object;
		$this->exception = $exception;
		$this->errorLevel = $errorLevel;
		$this->errorCode = $errorCode;
		$this->destinos = $destinos;
		$this->subject = $subject;
		$this->context = Context::getContext();

		foreach ($destinos AS $destino) {
			if ($destino == 'email') {
				$this->sendEmail();
			}
			if ($destino == 'log') {
				$this->addToPrestashopLog();
			}
			if ($destino == 'drive') {
				$this->addToDrive();
			}
			if ($destino == 'screen') {
				return $this->showLog();
			}
			return true;
		}
	}

	/**
	 * Envia el correo
	 * @return boolean
	 */
	private function sendEmail() {
		$mail = new Mail();
		$configuration = Configuration::getMultiple(array(
					'PS_SHOP_EMAIL',
					'PS_MAIL_METHOD',
					'PS_MAIL_SERVER',
					'PS_MAIL_USER',
					'PS_MAIL_PASSWD',
					'PS_SHOP_NAME',
					'PS_MAIL_SMTP_ENCRYPTION',
					'PS_MAIL_SMTP_PORT',
					'PS_MAIL_METHOD',
					'PS_MAIL_TYPE'
		));
		$smtpChecked = true;
		$smtpServer = $configuration['PS_MAIL_SERVER'];
		$type = "text/plain";
		$to = $configuration['PS_SHOP_EMAIL'];
		$from = $configuration['PS_SHOP_EMAIL'];
		$smtpLogin = $configuration['PS_MAIL_USER'];
		$smtpPassword = $configuration['PS_MAIL_PASSWD'];
		$smtpPort = $configuration['PS_MAIL_SMTP_PORT'];
		$smtpEncryption = $configuration['PS_MAIL_SMTP_ENCRYPTION'];
		return $mail->sendMailTest($smtpChecked, $smtpServer, $this->msg, $this->subject, $type, $to, $from, $smtpLogin, $smtpPassword, $smtpPort, $smtpEncryption);
	}

	/**
	 * Añade el mensaje al log de prestashop
	 * @return boolean
	 */
	private function addToPrestashopLog() {
		$log = new Logger();
		$log->severity = intval($this->errorLevel);
		$log->error_code = intval($this->errorCode);
		$log->message = pSQL(htmlentities($this->msg), FALSE);
		$log->date_add = date('Y-m-d H:i:s');
		$log->date_upd = date('Y-m-d H:i:s');

		if (isset($this->context->employee) && Validate::isLoadedObject($this->context->employee)) {
			$log->id_employee = $this->context->employee->id;
		} else {
			$log->id_employee = 0;
		}
		if ($this->object instanceof ObjectModel) {
			if ((get_class($this->object)) && !empty($this->object->id)) {
				$log->object_type = pSQL(get_class($this->object));
				$log->object_id = intval($this->object->id);
			}
		} else {
			$log->object_type = ' - ';
			$log->object_id = 0;
		}
		try {
			$res = $log->add();
			return $res;
		} catch (Exception $e) {
			return false;
		}
	}

	/**
	 * Guarda a disco el log
	 */
	private function addToDrive() {
		$path = _PS_ROOT_DIR_ . '/log/';
		$file = date('Y-m-d-h-i-s') . '.log';
		$msg = $this->msg . PHP_EOL;
		if ($this->exception != NULL) {
			$msg .= $this->exception->getMessage() . PHP_EOL;
			foreach ($this->exception->getTrace() AS $id => $trace) {

				$current_line = (isset($trace['line'])) ? $trace['line'] : '';
				$relative_file = (isset($trace['file'])) ? $trace['file'] : '';
				$msg .= ((isset($trace['class'])) ? $trace['class'] : '') . ((isset($trace['type'])) ? $trace['type'] : '') . $trace['function'] . PHP_EOL;
				$msg .= '[line ' . $current_line . ' - ' . $relative_file . ']' . PHP_EOL;
				if (isset($trace['args']) && count($trace['args']))
					$msg .= ' - [' . count($trace['args']) . ' Arguments]' . PHP_EOL;
				if ($relative_file)
					$msg .= $this->displayFileDebug($trace['file'], $trace['line'], $id, true);
				if (isset($trace['args']) && count($trace['args']))
					$msg .= $this->displayArgsDebug($trace['args'], $id, true);
			}
			$msg .= PHP_EOL;
		}
		if ($this->object != NULL) {
			$msg .= 'Tipo de Objeto: ' . get_class($this->object) . PHP_EOL;
			$msg .= 'Contenido: '.PHP_EOL;
			if (gettype($this->object) == 'object') {
				$msg .= print_r(get_object_vars($this->object), true);
				$msg .= PHP_EOL;
			} else {
				$msg .= print_r($this->object, true);
				$msg .= PHP_EOL;
			}			
		}
		file_put_contents($path.$file , $msg);
	}

	/**
	 * Imprime el mensaje de error formateado para sacarlo por pantalla, el objeto que provoco el error, y la excepcion que se genero
	 */
	private function showLog($detener = false) {
		//d(get_object_vars($this));
		echo '<style>
				#imaxException{font-family: Verdana; font-size: 14px}
				#imaxException h2{color: #F20000}
				#imaxException p{padding-left: 20px}
				#imaxException ul li{margin-bottom: 10px;list-style:none}
				#imaxException a{font-size: 12px; color: #000000}
				#imaxException .psTrace, #psException .psArgs{display: none}
				#imaxException pre{border: 1px solid #236B04; background-color: #EAFEE1; padding: 5px; font-family: Courier; width: 99%; overflow-x: auto; margin-bottom: 30px;}
				#imaxException .psArgs pre{background-color: #F1FDFE;}
				#imaxException pre .selected{color: #F20000; font-weight: bold;}
			</style>';
		echo '<div id="imaxException">';
		echo '<h2>[' . get_class($this) . ']</h2>';
		//echo '<div><p>'.$this->msg.'</p></div>';
          echo '<pre><div><p>'.print_r($this->msg, true).'</p></div></pre>';
		if ($this->exception != NULL) {
			echo '<p>' . $this->exception->getMessage() . '</p>';
			echo '<ul>';
			foreach ($this->exception->getTrace() AS $id => $trace) {
				echo '<li>';
				$current_line = (isset($trace['line'])) ? $trace['line'] : '';
				$relative_file = (isset($trace['file'])) ? $trace['file'] : '';
				echo '<b>' . ((isset($trace['class'])) ? $trace['class'] : '') . ((isset($trace['type'])) ? $trace['type'] : '') . $trace['function'] . '</b>';
				echo ' - <a style="font-size: 12px; color: #000000; cursor:pointer; color: blue;" onclick="document.getElementById(\'psTrace_' . $id . '\').style.display = (document.getElementById(\'psTrace_' . $id . '\').style.display != \'block\') ? \'block\' : \'none\'; return false">[line ' . $current_line . ' - ' . $relative_file . ']</a>';
				if (isset($trace['args']) && count($trace['args']))
					echo ' - <a style="font-size: 12px; color: #000000; cursor:pointer; color: blue;" onclick="document.getElementById(\'psArgs_' . $id . '\').style.display = (document.getElementById(\'psArgs_' . $id . '\').style.display != \'block\') ? \'block\' : \'none\'; return false">[' . count($trace['args']) . ' Arguments]</a>';
				if ($relative_file)
					$this->displayFileDebug($trace['file'], $trace['line'], $id, true);
				if (isset($trace['args']) && count($trace['args']))
					$this->displayArgsDebug($trace['args'], $id);
				echo '</li>';
			}
			echo '</ul>';
		}
		if ($this->object != NULL) {
			echo '<h2>Tipo de Objeto: <span>' . get_class($this->object) . '</span></h2>';
			echo '<h2>Contenido: </h2>';
			echo '<pre>';
			if (gettype($this->object) == 'object') {
				var_dump(get_object_vars($this->object));
			} else {
				var_dump($this->object);
			}
			echo '</pre>';
		}
		echo '</div>';
                
                if($detener)
                    die();
	}

	protected function displayFileDebug($file, $line, $id = null, $hd = false) {
		$lines = file($file);
		$offset = $line - 6;
		$total = 11;
		if ($offset < 0) {
			$total += $offset;
			$offset = 0;
		}
		$lines = array_slice($lines, $offset, $total);
		++$offset;
		if ($hd == false) {
			echo '<div class="psTrace" id="psTrace_' . $id . '" ' . ((is_null($id) ? 'style="display: block"' : '')) . '><pre>';
			foreach ($lines as $k => $l) {
				$string = ($offset + $k) . '. ' . htmlspecialchars($l);
				if ($offset + $k == $line)
					echo '<span class="selected">' . $string . '</span>';
				else
					echo $string;
			}
			echo '</pre></div>';
		}else {
			$msg = '';
			foreach ($lines as $k => $l) {
				$string = ($offset + $k) . '. ' . $l;
				$msg .= $string . PHP_EOL;
			}
			return $msg;
		}
	}

	protected function displayArgsDebug($args, $id, $hd = false) {
		if (!$hd) {
			echo '<div class="psArgs" id="psArgs_' . $id . '"><pre>';
			foreach ($args as $arg => $value) {
				echo '<b>Argument [' . Tools::safeOutput($arg) . "]</b><br />";
				echo Tools::safeOutput(var_dump($value));
				echo "<br />";
			}
			echo '</pre>';
		} else {
			$msg = '';
			foreach ($args as $arg => $value) {
				$msg .= 'Argument [' . Tools::safeOutput($arg) . "]".PHP_EOL;
				$msg .= Tools::safeOutput(print_r($value, TRUE)).PHP_EOL;			
			}
			return $msg;
		}
	}

}
