/* global mensaje_escaneado, mensaje_errorCodigo, mensaje_listo, mensaje_selecciona, mensaje_fecha, mensaje_errorCargaPedido, mensaje_errorAgregarMensaje, mensaje_imprimirCorrecto */

var productos = [];

$(function () {
    $.datepicker.regional['es'] = {
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
        dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mié', 'Juv', 'Vie', 'Sáb'],
        dayNamesMin: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'],
        weekHeader: 'Sm',
        dateFormat: 'dd/mm/yy',
        firstDay: 1,
        isRTL: false,
        showMonthAfterYear: false,
        yearSuffix: ''
    };
    
    $('input[name="fechaInicio"],input[name="fechaFin"]').val("");
    $('input[name="fechaInicio"],input[name="fechaFin"]').datepicker(
        $.extend(
            {}, 
            $.datepicker.regional[ "es" ], 
            { 
                onSelect: function(dateText, inst) {
                    actualizarPedidos();
                }
            }
        )
    );

    //Coger códigos
    var multiplicador = new Multiplicador(simboloMultiplicador);
    var lector = new LectorCodigosInput(13, function (codigoEscaneado) {
        var cantidad = multiplicador.getMultiplicador(codigoEscaneado);
        var codigo = multiplicador.getCodigo(codigoEscaneado);
        var producto = obtenerProducto(codigo);
        if (producto) {
            producto.cantidadActual = parseInt(producto.cantidadActual) + parseInt(cantidad);
            actualizarCantidadTabla(producto.identificador);
            actualizarCantidadProducto(codigo, producto);
            scroll(producto.identificador);
            $('#mensajeUltimo').html(mensaje_escaneado + ': ' + codigo).css('color', 'green');
        } else {
            $('#mensajeUltimo').html(mensaje_errorCodigo + ': ' + codigo).css('color', 'brown');

            mensaje(mensaje_errorCodigo + ': ' + codigo, 'error');
        }
    });

    $('#contenedorPedidos').click(function (ev) {
        ev.stopImmediatePropagation();
    });
    $('#contenedorPedidos').change(function (ev) {
        focoEnInput(lector.inputName, ev);
    });
    $('.pagina').eq(0).click(function (ev) {
        focoEnInput(lector.inputName, ev);
    });
    $('.pagina').eq(1).click(function (ev) {
        focoEnInput(lector.inputName, ev);
    });
    focoEnInput(lector.inputName);
    lector.iniciarCaptacion();

    //Menú y desplazamiento de página
    var desplaza = new DesplazarPaginasConMenu('#paginas', '.pagina', '#menu', function (pagina) {
        if (pagina == 0 || pagina == 1) {
            focoEnInput(lector.inputName);
            lector.iniciarCaptacion();
        }
    });

    $('#botonMenu').click(function () {
        desplaza.intercambiarMenu();
    });


    $(window).on("orientationchange", function (event) {
        setTimeout(function () {
            $('.pagina').width($('html').width());
            $('#paginas').width($('.pagina').length * $('.pagina').width());
            desplaza.actualizarPosicion();
        }, 500);
    });

    //Lista de pedidos
    actualizarPedidos();
    setInterval(actualizarPedidos, 30000);

    //Cambio de pedido
    $('select[name="pedidos"]').change(function () {
        bloquear();

        //Reiniciamos la pantalla
        $(this).removeClass('conMensaje');
        $(this).addClass($('select[name="pedidos"] option[value="' + $(this).val() + '"]').attr('class'));
        $('#mensajeEstado').html(($(this).val() != 0 ? mensaje_listo : mensaje_selecciona));
        $('#mensajeProceso').html('').css('color', '');
        $('#mensajeUltimo').html('');
        $('#finalizar').removeClass('disabled');

        if (parseInt($(this).val())) {
            //Cargamos los productos
            $.getJSON('ajax.php?callback=?', {
                accion: 'cargarPedido',
                idPedido: $(this).val()
            }, function (respuesta) {
                if (respuesta.ok) {
                    $('#listaMensajes').empty();
                    for (var i = 0, len = respuesta.datos.mensajes.length; i < len; i++) {
                        $('#listaMensajes').append('<p>' + respuesta.datos.mensajes[i] + '</p>');
                    }

                    $('#contenedorInfo #fechaPedido').html(mensaje_fecha + " <strong>" + respuesta.datos.fechaCreacion + "</strong>.");

                    $('#contenedorListado table tbody').empty();
                    productos = [];
                    for (var x in respuesta.datos.productos) {
                        var iter = respuesta.datos.productos[x];

                        introducirLineaProducto(iter, '');
                    }

                    actualizarCantidadesGrupos();

                    $('#contenedorListado table .restar').click(function () {
                        var codigo = obtenerCodigo(desconvertirId($(this).parent().parent().attr('id')));
                        var producto = obtenerProducto(codigo);
                        
                        if (producto && producto.cantidadActual > 0) {
                            var codigoEscaneado = parseInt(lector.obtenerCodigoActual(true));
                            var cantidad = 1;
                            if(codigoEscaneado){
                                cantidad = codigoEscaneado;
                                if(cantidad > producto.cantidadActual){
                                    cantidad = producto.cantidadActual;
                                }
                            }
                            producto.cantidadActual = parseInt(producto.cantidadActual) - cantidad;
                            actualizarCantidadTabla(codigo);
                            actualizarCantidadProducto(codigo, producto);
                        }
                    });

                    $('#contenedorListado table .sumar').click(function () {
                        var codigo = obtenerCodigo(desconvertirId($(this).parent().parent().attr('id')));
                        var producto = obtenerProducto(codigo);

                        if (producto) {
                            var codigoEscaneado = parseInt(lector.obtenerCodigoActual(true));
                            var cantidad = 1;
                            if(codigoEscaneado){
                                cantidad = codigoEscaneado;
                            }
                            producto.cantidadActual = parseInt(producto.cantidadActual) + cantidad;
                            actualizarCantidadTabla(codigo);
                            actualizarCantidadProducto(codigo, producto);
                        }
                    });
                } else {
                    mensaje(mensaje_errorCargaPedido, 'error');
                }
            });
        } else {
            $('#contenedorInfo #fechaPedido').html("");
            $('#contenedorListado table tbody').empty();
            productos = [];
        }
    });
    $('select[name="pedidos"]').change();
    setInterval(bloquear, 60000);

    //Abrir y cerrar fieldsets en listado
    $('#contenedorListado fieldset').children('div').click(function (ev) {
        ev.stopPropagation();
        focoEnInput(lector.inputName, ev);
    });

    //Agregar mensaje
    $('input[name="enviarMensaje"]').click(function () {
        var mensaje = $('textarea[name="mensaje"]').val(), idPedido = $('select[name="pedidos"]').val();

        $.getJSON('ajax.php?callback=?', {
            accion: 'agregarMensaje',
            idPedido: idPedido,
            mensaje: mensaje
        }, function (respuesta) {
            if (respuesta.ok) {
                $('#listaMensajes').prepend('<p>' + mensaje + '</p>');
                $('select[name="pedidos"]').addClass('conMensaje');
                $('select[name="pedidos"] option[value="' + idPedido + '"]').addClass('conMensaje');
            } else {
                mensaje(mensaje_errorAgregarMensaje, 'error');
            }
        });
    });

    //Finalizar
    $('#finalizar').click(function () {
        if ($('select[name="pedidos"]').val() != '0') {
            var finalizado = true, i = 0;
            $('#contenedorListado table tbody').each(function () {
                var cantidad = $(this).children('tr').length / 2;
                
                if (i < 2 && cantidad > 0) {
                    finalizado = false;
                }

                i++;
            });

            if (finalizado || confirm(mensaje_noCompleto)) {
                finalizar();
            }
        }
    });
    
    //Imprimir
$('#imprimir').click(function(){
    var idPedido = $('select[name="pedidos"]').val();
    var checkedProducts = [];

    $('input[name="impEtiqueta"]:checked').each(function(){
        var $tr = $(this).closest('tr');
        var product = {
            productId: $tr.data('producto-id'),
            combinationId: $tr.data('combination-id')
        };
        checkedProducts.push(product);
    });
    
    $.getJSON('ajax.php?callback=?', {
        accion: 'imprimir',
        idPedido: idPedido,
        checkedProducts: checkedProducts 
    }, function (respuesta) {
        if (respuesta.ok) {
            mensaje(mensaje_imprimirCorrecto, 'correcto');
        }
    });
});

    

    //Enlace
    $('#pickingSalida').click(function () {
        window.location = '../pda';
    });
    
    $(document).keyup(function (ev) {
        var paginaActual = $('#menu li').index($('#menu li.paginaActual'));
        if (ev.keyCode == 37) {
            if (paginaActual > 0) {
                var anterior = $('#menu li.paginaActual').prev();
                if (anterior.length) {
                    desplaza.cambiarPagina(paginaActual - 1);
                    $('#menu li').removeClass('paginaActual');
                    anterior.addClass('paginaActual');
                }
            }
        } else if (ev.keyCode == 39) {
            if (paginaActual < $('#menu li').length - 1) {
                var siguiente = $('#menu li.paginaActual').next();
                if (siguiente.length) {
                    desplaza.cambiarPagina(paginaActual + 1);
                    $('#menu li').removeClass('paginaActual');
                    siguiente.addClass('paginaActual');
                }
            }
        } else if (ev.keyCode == 36) {
            desplaza.cambiarPagina(0);
            $('#menu li').removeClass('paginaActual');
            $('#menu li').eq(0).addClass('paginaActual');
        } else if (!ev.ctrlKey && ev.keyCode == 38) {
            if (!$('select[name="pedidos"]').is(":focus")) {
                var anterior = $('select[name="pedidos"] option:selected').prev();
                if (anterior.length) {
                    $('select[name="pedidos"]').val(anterior.val());
                    $('select[name="pedidos"]').change();
                }
            }
        } else if (!ev.ctrlKey && ev.keyCode == 40) {
            if (!$('select[name="pedidos"]').is(":focus")) {
                var siguiente = $('select[name="pedidos"] option:selected').next();
                if (siguiente.length) {
                    $('select[name="pedidos"]').val(siguiente.val());
                    $('select[name="pedidos"]').change();
                }
            }
        } else if (ev.ctrlKey && ev.keyCode == 38) {
            $('#finalizar').click();
        }
    });


    /**
     * Funcion que hace scroll hasta el elemento seleccionado
     * @param {string} identificador 
     */
    function scroll(identificador) {
        var posicion = $( '#' + identificador + '_identificador').position().top - 90;
        $('html, body').animate({ scrollTop: posicion }, 500);
    }

    /**
     * 
     * @param {jquery} elemento 
     */
    function corregirScroll(elemento){
        var posicion = elemento.position;
        window.scrollTo(0, posicion.top);
    }
});