/* global productos, mensaje_errorBloqueo, mensaje_errorListado, mensaje_finalizadas, mensaje_excedidas, mensaje_incompletas, botonSumarPDA, botonRestarPDA, mensaje_finalizado, mensaje_error_finalizado */

/**
 * Indica si un pedido está bloqueado.
 * @param {Array} bloqueos
 * @param {int} idPedido
 * @returns {Boolean}
 */
function bloqueado(bloqueos, idPedido) {
    var encontrado = false;

    for (var i = 0, len = bloqueos.length; i < len; i++) {
        if (bloqueos[i].idPedido == idPedido) {
            encontrado = true;
            break;
        }
    }

    return encontrado;
}

/**
 * Actualiza la lista de pedidos.
 */
function actualizarPedidos() {
    $.getJSON('ajax.php?callback=?', {
        accion: 'obtenerListaPedidos',
        fechaDesde: $.trim($('input[name="fechaInicio"]').val()),
        fechaHasta: $.trim($('input[name="fechaFin"]').val())
    }, function (respuesta) {
        if (respuesta.ok) {
            var seleccionado = $('select[name="pedidos"]').val(), existe = false;
            $('select[name="pedidos"] option').slice(1).remove();
            for (var x in respuesta.datos.pedidos) {
                var clase = '', simbolo = '';

                if (respuesta.datos.pedidos[x].mensajes > 0) {
                    clase = 'conMensaje';
                    simbolo = '*';
                }

                $('select[name="pedidos"]').append('<option ' + (bloqueado(respuesta.datos.bloqueos, respuesta.datos.pedidos[x].id) ? 'disabled="disabled"' : '') +
                        ' value="' + respuesta.datos.pedidos[x].id + '" class="' + clase + '">' + simbolo + respuesta.datos.pedidos[x].id + ' - ' + respuesta.datos.pedidos[x].referencia + '</option>');

                if (respuesta.datos.pedidos[x].id == seleccionado) {
                    existe = true;
                }
            }

            if (existe) {
                $('select[name="pedidos"]').val(seleccionado);
            } else {
                $('select[name="pedidos"]').val('0');
            }
        } else {
            mensaje(mensaje_errorListado, 'error');
        }
    });
}

/**
 * Bloquea un pedido.
 */
function bloquear() {
    $.getJSON('ajax.php?callback=?', {
        accion: 'bloquear',
        idPedido: $('select[name="pedidos"]').val()
    }, function (respuesta) {
        if (!respuesta.ok) {
            mensaje(mensaje_errorBloqueo, 'error');
        }
    });
}

/**
 * Actualiza la cantidad de producto en la tabla.
 * @param {string} codigo
 */
function actualizarCantidadTabla(codigo) {
    var producto = obtenerProducto(codigo);
    setSeleccionada($('#' + convertirId(codigo) + '_identificador'));
    $('#' + convertirId(codigo) + '_identificador .cantidadActual').html(producto.cantidadActual);
    if (producto.cantidadActual == producto.cantidadNecesaria) {
        if($('#' + convertirId(codigo) + '_identificador').closest('div').attr('id') != 'contenedorLineasCompletas') {
            $('#contenedorLineasCompletas table tbody').prepend($('#' + convertirId(codigo) + '_identificador').next().next());
            $('#contenedorLineasCompletas table tbody').prepend($('#' + convertirId(codigo) + '_identificador').next());
            $('#contenedorLineasCompletas table tbody').prepend($('#' + convertirId(codigo) + '_identificador'));
        }
    }
    else if(producto.cantidadActual > producto.cantidadNecesaria) {
        if($('#' + convertirId(codigo) + '_identificador').closest('div').attr('id') != 'contenedorLineasExcedidas') {
            $('#contenedorLineasExcedidas table tbody').prepend($('#' + convertirId(codigo) + '_identificador').next().next());
            $('#contenedorLineasExcedidas table tbody').prepend($('#' + convertirId(codigo) + '_identificador').next());
            $('#contenedorLineasExcedidas table tbody').prepend($('#' + convertirId(codigo) + '_identificador'));
        }
    }
    else if($('#' + convertirId(codigo) + '_identificador').closest('div').attr('id') != 'contenedorLineasIncompletas') {
        $('#contenedorLineasIncompletas table tbody').prepend($('#' + convertirId(codigo) + '_identificador').next().next());
        $('#contenedorLineasIncompletas table tbody').prepend($('#' + convertirId(codigo) + '_identificador').next());
        $('#contenedorLineasIncompletas table tbody').prepend($('#' + convertirId(codigo) + '_identificador'));
    }
    
    actualizarCantidadesGrupos();
}

/**
 * Cambia los números de los grupos de líneas.
 */
function actualizarCantidadesGrupos() {
    //Actualizamos la cantidad de líneas en los fieldset
    var mensaje = '', textos = [mensaje_incompletas, mensaje_excedidas, mensaje_finalizadas], i = 0, finalizado = true;
    $('#contenedorListado table tbody').each(function() {
        var cantidad = $(this).children('tr').length/2;
        $(this).closest('fieldset').children('legend').children('span').html(cantidad);
        
        if(i < 2 && cantidad > 0) {
            finalizado = false;
        }
        
        mensaje += cantidad + ' ' + textos[i] + '. ';
        i++;
    });
    
    if(finalizado) {
        $('#mensajeProceso').css('color', 'green');
    }
    else {
        $('#mensajeProceso').css('color', '');
    }
    
    $('#mensajeProceso').html(mensaje);
}

/**
 * Crea una nueva línea en la tabla de productos.
 * @param {object} datosProducto
 * @param {string} claseCSS
 */
function introducirLineaProducto(datosProducto, claseCSS) {
    productos.push({identificador: datosProducto.identificador, referencia: datosProducto.reference, ean13: datosProducto.ean13, eans13: datosProducto.eans13, cantidadNecesaria: datosProducto.stock, cantidadActual: datosProducto.stockRecibido});
    var suma = '';
    if (botonSumarPDA == "1") {
        suma = '<td><span class="sumar boton">+</span></td>';
    }
    
    var resta = '';
    if(botonRestarPDA) {
        resta = '<td><span class="restar boton">-</span></td>';
    }
    
    // Contenedor según cantidad
    var contenedor;
    if (datosProducto.stockRecibido == datosProducto.stock) {
        contenedor = 'contenedorLineasCompletas';
    }
    else if(datosProducto.stockRecibido > datosProducto.stock) {
        contenedor = 'contenedorLineasExcedidas';
    }
    else {
        contenedor = 'contenedorLineasIncompletas';
    }
    
    $('#' + contenedor + ' table tbody').append(function() {
        var idProducto = datosProducto.id_product;
        var idProductoAttribute = datosProducto.id_product_attribute;
        var imprimirEtiqueta = etiquetasImprimir.find(function(producto) {
            return producto.id_product == idProducto && producto.id_product_attribute == idProductoAttribute && producto.imprimirEtiqueta == 1;
        }) ? 'checked' : '';
    var etiquetaImpresa = '';
    if(datosProducto.etiquetaImpresa){
        etiquetaImpresa = ' etiquetaImpresa';
    }
        return '<tr id="' + convertirId(datosProducto.identificador) + '_identificador" class="' + claseCSS + etiquetaImpresa + '" data-producto-id="' + datosProducto.id_product + '" data-combination-id="' + datosProducto.id_product_attribute + '"><td><input type="checkbox" id="impEtiqueta" name="impEtiqueta" ' + imprimirEtiqueta + ' /></td><td><img src="' + datosProducto.imagen + '" alt/></td><td>' + datosProducto.nombre + '</td>' + datosProducto.ref_fabrica + '<td>' + datosProducto.stock + '</td><td class="cantidadActual">' + datosProducto.stockRecibido + '</td>' + suma + resta + '</tr>';
    });
    
    $('#' + contenedor + ' table tbody').append('<tr class="ubicacion ' + claseCSS + '" ><td colspan="2">Ub: ' + (datosProducto.ubicacion ? datosProducto.ubicacion : '-') + '</td><td>Restante: ' + datosProducto.stockReal + '</td><td colspan="4">Fab: '+datosProducto.ref_fabrica+'</td></tr>');
    if(mostrarRefProduct == 1){
        $('#' + contenedor + ' table tbody').append('<tr class="refProduct"><td colspan="7" >Referencia: '+ (datosProducto.referencia ? datosProducto.referencia : '-') +'</td></tr>');
        $('#' + contenedor + ' .ubicacion').removeClass('ubicacion');
    } 
}

/**
 * Pone el cursor en el input de captación.
 * @param {string} inputName
 * @param {event} ev
 */
function focoEnInput(inputName, ev) {
    var input = $('input[name="' + inputName + '"]'); 
    if (!input.is(':focus')) {
        if(ev){
            input.css({
                'top': ev.pageY + 'px'
            });
        }
        input.attr('readonly', 'readonly');
        input.focus();
        setTimeout(function () {
            input.removeAttr('readonly');
        }, 50);
    }
}

/**
 * Termina el pedido.
 */
function finalizar() {
    $('#finalizar').addClass('disabled');

    var idPedido = $('select[name="pedidos"]').val();

    $.ajax({
        url: 'ajax.php',
        type: 'POST',
        dataType: 'jsonp',
        data: {
            accion: 'finalizar',
            idPedido: idPedido,
            stocks: productos
        },
        success: function(respuesta) {
            if (respuesta.ok) {
                $('select[name="pedidos"]').val(0);
                $('select[name="pedidos"] option[value="' + idPedido + '"]').remove();
                $('select[name="pedidos"]').change();

                mensaje(mensaje_finalizado, 'correcto');
            } else {
                $('#finalizar').removeClass('disabled');

                mensaje(mensaje_error_finalizado, 'error');
            }
        }
    });
}

function actualizarCantidadProducto(id, stock){
    var idPedido = $('select[name="pedidos"]').val();
    $.getJSON('ajax.php?callback=?', {
        accion: 'actualizarCantidadProducto',
        idPedido: idPedido,
        id: id,
        stock: stock
    }, function (respuesta) {
        if (respuesta.ok) {
        } else {
        }
    });    
}

/**
 * Obtiene el identificador de un producto a partir de su id de html.
 * @param {String} id
 * @returns {String}
 */
function obtenerCodigo(id) {
    var partes = id.split('_');
    partes.pop();
    
    return partes.join('_');
}

/**
 * Modifica el codigo para que se pueda utilizar como id.
 * @param {String} codigo
 * @returns {String}
 */
function convertirId(codigo) {
    return codigo.replace(' ', '¬');
}

/**
 * Modifica el codigo para devolverlo a la normalidad.
 * @param {String} codigo
 * @returns {String}
 */
function desconvertirId(codigo) {
    return codigo.replace('¬', ' ');
}

/**
 * Devuelve el producto buscado
 * @param {string} codigo 
 * @returns {object}
 */
function obtenerProducto(codigo){
    var producto;
    for (var i in productos) {
        if(productos[i].referencia == codigo || productos[i].ean13 == codigo || productos[i].identificador == codigo){
            producto = productos[i];
            break;
        }
        else {
            for (var j in productos[i].eans13) {
                if (productos[i].eans13[j] == codigo) {
                    producto = productos[i];
                    break;
                }
            }
        }
    }
    return producto;
}

/**
 * Imprime un determinado código html a partir de su id 
 */
function printSpecificArea() {
    $('#paginaListado').printElement({printMode:'popup'});
}

/**
    * Asigna a una fila la clase seleccionada
    * @param {jQuery} fila
    */
function setSeleccionada(fila) {
    $('.seleccionada').removeClass('seleccionada');
    fila.addClass('seleccionada');
}