/**
 * Sirve para obtener el multiplicador o el codigo.
 * @param {String} simbolo
 * @returns {Multiplicador}
 */
function Multiplicador(simbolo) {
    if(!simbolo) {
        simbolo = '*';
    }
    this.simbolo = simbolo;
}

/**
 * Devuelve el multiplicador contenido en este numero.
 * @param {String} numero
 * @returns {int}
 */
Multiplicador.prototype.getMultiplicador = function(numero) {
    var multiplicador = 1;
    
    var posSimbolo = numero.indexOf(this.simbolo);
    if(posSimbolo !== -1) {
        var partes = numero.split(this.simbolo);
        multiplicador = parseInt(partes[0]);
    }
    
    return multiplicador;
};

/**
 * Devuelve el codigo pasado sin el multiplicador.
 * @param {String} numero
 * @returns {String}
 */
Multiplicador.prototype.getCodigo = function(numero) {
    var codigo = numero;
    
    var partes = numero.split(this.simbolo);
    if(partes.length > 1) {
        codigo = partes.slice(1).join(this.simbolo);
    }
    
    return codigo;
};