/**
 * Permite desplazar la pantalla horizontalmente como si fuesen múltiples páginas, usando un menú.
 * @param {string} selectorContenedorPaginas
 * @param {string} selectorPaginas
 * @param {string} selectorMenu
 * @param {function} callback Se llama al finalizar un desplazamiento, recibe el número de página abierta.
 */
function DesplazarPaginasConMenu(selectorContenedorPaginas, selectorPaginas, selectorMenu, callback) {
    var contenedor = $(selectorContenedorPaginas), paginas = $(selectorPaginas), menu = $(selectorMenu), esto = this;
    
    //Configuracion inicial
    paginas.css('float', 'left').width($('body').width());
    contenedor.css('position', 'relative').width(paginas.length * paginas.width());
    menu.css('position', 'fixed').css('top', '0').css('left', -menu.outerWidth() + 'px');
    
    /**
     * Abre el menu.
     */
    this.abrirMenu = function() {
        if(!$('#overlay').length) {
            var over = $('<div id="overlay"></div>').css('width', '100%').css('height', '100%').css('z-index', '888').css('opacity', '0.6').css('background-color', 'black').
                    css('position', 'absolute').css('top', '0').css('left', '0').click(function() {
                        esto.cerrarMenu();
            });
            $('body').append(over);
        }
        
        menu.animate({
            left: 0
        }, 600);
    };
    
    /**
     * Cierra el menu.
     */
    this.cerrarMenu = function() {
        menu.animate({
            left: -menu.outerWidth() + 'px'
        }, 600, function() {
            $('#overlay').remove();
        });
    };
    
    this.intercambiarMenu = function() {
        if(parseInt(menu.css('left')) == 0) {
            esto.cerrarMenu();
        }
        else {
            esto.abrirMenu();
        }
    };
    
    /**
     * Muestra la pagina indicada.
     * @param {int} pagina La posicion de la pagina.
     */
    this.cambiarPagina = function(pagina) {
        contenedor.animate({
            left: -(paginas.outerWidth() * pagina) + 'px'
        }, 600, function() { if(typeof callback === 'function') { callback(pagina); } });
        
        $('body').scrollTop(0)
    };
    
    /**
     * Reposiciona la pagina actual para que cuadre en la ventana.
     */
    this.actualizarPosicion = function() {
        contenedor.css('left', -(paginas.outerWidth() * menu.children().index($('.paginaActual'))) + 'px');
    };
             
    //Cambiamos de pagina
    menu.children().click(function() {
        var pos = menu.children().index(this);
        esto.cambiarPagina(pos);
        
        menu.children().removeClass('paginaActual');
        $(this).addClass('paginaActual');
        
        esto.cerrarMenu();
    });
    
}