<?php

define('_PS_ADMIN_DIR_', '');
include_once(dirname(__FILE__).'../../../../config/config.inc.php');
include_once(dirname(__FILE__).'/../imaximprimepedidosservidor.php');

$context = Context::getContext();
$context->shop->setUrl();

$resultado['ok'] = false;
$resultado['datos'] = array();
//Comprobamos logueo
if (!empty($context->employee->id) && $context->employee->isLoggedBack()) {
    switch (Tools::getValue('accion')) {
        case 'obtenerListaPedidos':
            $fechaInicioString = '';
            $fechaInicio = Tools::getValue('fechaDesde', '');
            $fechaFinString = '';
            $fechaFin = Tools::getValue('fechaHasta', '');

            //Cargamos los pedidos montables
            if ($fechaInicio) {
                $trozosInicio = explode('/', $fechaInicio);
                $fechaInicioString = "AND date(fechaEntrada) >= '$trozosInicio[2]-$trozosInicio[1]-$trozosInicio[0]'";
            }
            if ($fechaFin) {
                $trozosFin = explode('/', $fechaFin);
                $fechaFinString = "AND date(fechaEntrada) <= '$trozosFin[2]-$trozosFin[1]-$trozosFin[0]'";
            }

            $pedidos = Db::getInstance()->executeS('
                SELECT ac.*, COUNT(mac.idMensaje) as mensajes FROM `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo.'altaCompras` ac
                    LEFT JOIN `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."mensajeAltaCompra` mac ON ac.id = mac.idAltaCompra 
                WHERE finalizado = 0 $fechaInicioString $fechaFinString
                GROUP BY ac.id
                ORDER BY ac.id DESC
                LIMIT 100");

            //Cargamos los bloqueos
            $bloqueos = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."bloqueoPedido` WHERE idEmpleado != {$context->employee->id} AND NOW() - acceso < 60 AND idTipoPedido = ".ImaxImprimePedidosServidor::TIPO_PEDIDO_ENTRADA);

            $resultado['ok'] = true;
            $resultado['datos']['pedidos'] = $pedidos;
            $resultado['datos']['bloqueos'] = $bloqueos;
            break;

        case 'bloquear':
            $idPedido = (int)Tools::getValue('idPedido');

            $resultado['ok'] = Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."bloqueoPedido` WHERE idEmpleado = {$context->employee->id} AND idTipoPedido = ".ImaxImprimePedidosServidor::TIPO_PEDIDO_ENTRADA);
            if ($idPedido) {
                $resultado['ok'] = Db::getInstance()->execute('REPLACE INTO `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."bloqueoPedido` (idPedido, idTipoPedido, idEmpleado) VALUES ($idPedido, ".ImaxImprimePedidosServidor::TIPO_PEDIDO_ENTRADA.", {$context->employee->id})");
            }
            break;
            
        case 'cargarPedido':
            $idPedido = (int)Tools::getValue('idPedido');
            if ($idPedido) {
                $imax = new ImaxImprimePedidosServidor();
                
                $image_sizes = ImageType::getImagesTypes();
                $width = 1000;
                $image_type_name = '';
                foreach ($image_sizes AS $image_size) {
                    if ($image_size['width'] < $width) {
                        $width = $image_size['width'];
                        $image_type_name = $image_size['name'];
                    }
                }

                $datosPedido = Db::getInstance()->getRow('SELECT * FROM `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."altaCompras` WHERE id = $idPedido");
                $productosPedido = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."altaComprasDetalle` WHERE idAlta = $idPedido ORDER BY id ASC");
                foreach ($productosPedido as &$productoPedido) {
                    $producto = new Product($productoPedido['id_product']);
                    $productoPedido['stock'] = (int) $productoPedido['stock'];
                    $productoPedido['stockRecibido'] = (int) $productoPedido['stockRecibido'];
                    if($productoPedido['id_product_attribute']) {
                        $combinacion = new Combination($productoPedido['id_product_attribute']);
                        $productoPedido['ean13'] = $combinacion->ean13;
                        $productoPedido['reference'] = $combinacion->reference;
                        $productoPedido['nombre'] = Product::getProductName($productoPedido['id_product'], $productoPedido['id_product_attribute']);
                        $productoPedido['etiquetaImpresa'] = $imax->getEtiquetaProductoImpresa($idPedido, $productoPedido['id_product'], $productoPedido['id_product_attribute']);
                    }
                    else {
                        $productoPedido['ean13'] = $producto->ean13;
                        $productoPedido['reference'] = $producto->reference;
                        $productoPedido['nombre'] = $producto->name[Context::getContext()->language->id];
                        $productoPedido['etiquetaImpresa'] = $imax->getEtiquetaProductoImpresa($idPedido, $productoPedido['id_product'], 0);
                    }
                    $productoPedido['eans13'] = array();
                    if (Module::isEnabled('imaxmultiean')) {
                        $module = Module::getInstanceByName('imaxmultiean');
                        $productoPedido['eans13'] = array_column($module->getFunciones()->getEANs($productoPedido['id_product'], $productoPedido['id_product_attribute']), 'ean13');
                    }
                    //Agregamos el identificador
                    
                    $productoPedido['identificador'] = $producto->id.'-'.(int)$productoPedido['id_product_attribute'].'-ids';
                    
                    if(Module::isEnabled('imaxmultialmacen')){
                        $opcionAlmacen = $imax->cargarOpcionAlmacen($producto->id, (int)$productoPedido['id_product_attribute']);
                        if($opcionAlmacen && $opcionAlmacen['almacenEntradaPorDefecto'] != 0){
                            $idAlmacen = $opcionAlmacen['almacenEntradaPorDefecto'];
                        }else{
                            $idAlmacen = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'ALMACEN_ENTRADA_GENERAL');
                        }
                        $productoPedido['ubicacion'] = Warehouse::getWarehouseNameById($idAlmacen);
                        $cantidad = $imax->getStock($producto->id, (int)$productoPedido['id_product_attribute'], $idAlmacen);
                        $productoPedido['stockReal'] = $cantidad['physical_quantity'] ? $cantidad['physical_quantity'] : 0;
                    }else{
                        $ubicacion = $imax->cargarExtraProducto($producto->id, (int)$productoPedido['id_product_attribute']);
                        $productoPedido['ubicacion'] = ($ubicacion ? $ubicacion['ubicacion'] : '');
                        $cantidad = $imax->getStock($producto->id, (int)$productoPedido['id_product_attribute']);
                        $productoPedido['stockReal'] = $cantidad['physical_quantity'] ? $cantidad['physical_quantity'] : 0;
                    }
                    

                    //Imagen
                    $id_image_temp = Product::getCover($productoPedido['id_product']);
                    $productoPedido['descripcion'] = isset($producto->description_short[Context::getContext()->language->id]) ? strip_tags($producto->description_short[Context::getContext()->language->id]) : '';
                    $name = $producto->link_rewrite[Configuration::getGlobalValue('PS_LANG_DEFAULT')];
                    if($id_image_temp){
                        $ids = $producto->id.'-'.$id_image_temp['id_image'];
                        $type = $image_type_name;

                        $not_default = false;
                        // legacy mode or default image
                        $theme = ((Shop::isFeatureActive() && file_exists(_PS_PROD_IMG_DIR_.$ids.($type ? '-'.$type : '').'-'.(int)Context::getContext()->shop->theme_name.'.jpg')) ? '-'.Context::getContext()->shop->theme_name : '');
                        if ((Configuration::get('PS_LEGACY_IMAGES') && (file_exists(_PS_PROD_IMG_DIR_.$ids.($type ? '-'.$type : '').$theme.'.jpg'))) || ($not_default = strpos($ids, 'default') !== false)) {
                            if ((int)Configuration::get('PS_REWRITING_SETTINGS') == 1 && !$not_default) {
                                $uri_path = $context->shop->getBaseUri().$ids.($type ? '-'.$type : '').$theme.'/'.$name.'.jpg';
                            }
                            else {
                                $uri_path = _THEME_PROD_DIR_.$ids.($type ? '-'.$type : '').$theme.'.jpg';
                            }
                        }
                        else {
                            // if ids if of the form id_product-id_image, we want to extract the id_image part
                            $split_ids = explode('-', $ids);
                            $id_image = (isset($split_ids[1]) ? $split_ids[1] : $split_ids[0]);
                            $theme = ((Shop::isFeatureActive() && file_exists(_PS_PROD_IMG_DIR_.Image::getImgFolderStatic($id_image).$id_image.($type ? '-'.$type : '').'-'.(int)Context::getContext()->shop->theme_name.'.jpg')) ? '-'.Context::getContext()->shop->theme_name : '');
                            if ((int)Configuration::get('PS_REWRITING_SETTINGS') == 1) {
                                $uri_path = $context->shop->getBaseUri().$id_image.($type ? '-'.$type : '').$theme.'/'.$name.'.jpg';
                            }
                            else {
                                $uri_path = _THEME_PROD_DIR_.Image::getImgFolderStatic($id_image).$id_image.($type ? '-'.$type : '').$theme.'.jpg';
                            }
                        }

                        $productoPedido['imagen'] = 'http://'.Tools::getMediaServer($uri_path).$uri_path;
                    }else{
                        $productoPedido['imagen'] = '';
                    }
                }
                $mensajesPedido = Db::getInstance()->executeS('SELECT mensaje FROM `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."mensajeAltaCompra` WHERE idAltaCompra = $idPedido");
                foreach ($mensajesPedido as &$mensajePedido) {
                    $mensajePedido = $mensajePedido['mensaje'];
                }

                $resultado['ok'] = true;
                $resultado['datos']['productos'] = $productosPedido;
                $resultado['datos']['fechaCreacion'] = date('d/m/Y', strtotime($datosPedido['fechaEntrada']));
                $resultado['datos']['mensajes'] = $mensajesPedido;
            }
            break;
            
        case 'agregarMensaje':
            $idPedido = (int)Tools::getValue('idPedido');
            $mensaje = trim(Tools::getValue('mensaje'));
            if ($idPedido && $mensaje) {
                try {
                    $resultado['ok'] = Db::getInstance()->execute('INSERT INTO `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."mensajeAltaCompra` (idAltaCompra, mensaje, id_employee) VALUES ('$idPedido', '$mensaje', '{$context->employee->id}')");
                }
                catch (Exception $ex) {
                    
                }
            }
            break;
            
        case 'finalizar':
            $idPedido = (int)Tools::getValue('idPedido');
            $stocks = Tools::getValue('stocks');
            if ($idPedido && $stocks) {
                try {
                    Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."bloqueoPedido` WHERE idPedido = $idPedido AND idTipoPedido = ".ImaxImprimePedidosServidor::TIPO_PEDIDO_ENTRADA);
                }
                catch (Exception $ex) { }
                try {
                    foreach($stocks as $id => $stock) {
                        if(stripos($stock['identificador'], '-') !== false) {
                            $partes = explode('-', $stock['identificador']);
                            $ids['id_product'] = $partes[0];
                            $ids['id_product_attribute'] = $partes[1];
                        }
                        else {
                            $ids = ImaxImprimePedidosServidor::buscarEan($stock['ean13']);
                            if(empty($ids)){
                                $ids = ImaxImprimePedidosServidor::buscarReferencia($stock['referencia']);
                            }
                        }
                        $stock = (int)$stock['cantidadActual'];
                        
                        Db::getInstance()->execute('UPDATE `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."altaComprasDetalle` SET stockRecibido = '$stock' WHERE id_product = '{$ids['id_product']}' AND id_product_attribute = '{$ids['id_product_attribute']}' AND idAlta = '$idPedido'");
                    }
                    
                    $resultado['ok'] = Db::getInstance()->execute('UPDATE `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."altaCompras` SET finalizado = 1, empleadoFinaliza = '{$context->employee->id}', fechaFinaliza = NOW() WHERE id = '$idPedido'");
                }
                catch (Exception $ex) { 
                    echo $ex;
                }
            }
            break;
        case 'actualizarCantidadProducto':
            $idPedido = (int)Tools::getValue('idPedido');
            $id = Tools::getValue('id');
            $stock = Tools::getValue('stock');
            try {
                if(stripos($id, '-') !== false) {
                   $partes = explode('-', $id);
                   $ids['id_product'] = $partes[0];
                   $ids['id_product_attribute'] = $partes[1];
                }
                else {
                    $ids = ImaxImprimePedidosServidor::buscarEan($id);
                    if(empty($ids)){
                        $ids = ImaxImprimePedidosServidor::buscarReferencia($id);
                    }
                }
                $stock = (int)$stock['cantidadActual'];
                
                $resultado['ok'] = Db::getInstance()->execute('UPDATE `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."altaComprasDetalle` SET stockRecibido = '$stock' WHERE id_product = '{$ids['id_product']}' AND id_product_attribute = '{$ids['id_product_attribute']}' AND idAlta = '$idPedido'");
            }
            catch (Exception $ex) { 
                echo $ex;
            }
            break;
        case 'sumarStock':
            require_once(dirname(__FILE__).'/../controllers/admin/AdminImaxImprimePedidosOrderController.php');
            $controller = new AdminImaxImprimePedidosOrderController();
            $resultado['ok'] = $controller->agregarStock(Tools::getValue('idPedido'));
            break;
        
        case 'eliminarPedido':
            require_once(dirname(__FILE__).'/../controllers/admin/AdminImaxImprimePedidosOrderController.php');
            $controller = new AdminImaxImprimePedidosOrderController();
            $resultado['ok'] = $controller->eliminarPedidoEan(Tools::getValue('idPedido'));
            break;
        case 'imprimir':
            $idPedido = (int)Tools::getValue('idPedido');
            $checkedProducts = Tools::getValue('checkedProducts');
            $idEmpleado = Context::getContext()->employee->id;
            foreach($checkedProducts as $producto){
                $idProducto = (int)$producto["productId"];
                $idCombinacion = (int)$producto["combinationId"];
                Db::getInstance()->execute('INSERT IGNORE `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."imprimirEtiquetaProducto` (id_order, id_product, id_product_attribute, id_employee)  VALUES('{$idPedido}', '{$idProducto}', '{$idCombinacion}', '{$idEmpleado}')");
            }
            $resultado['ok'] = true;
            break;
    }
}

echo Tools::getValue('callback').'('.json_encode($resultado).')';
