<?php
include(__DIR__.'/funciones/back.php');
define('_PS_ADMIN_DIR_', getAdminDir());
include_once(dirname(__FILE__) . '../../../../config/config.inc.php');
include_once(dirname(__FILE__) . '/../imaximprimepedidosservidor.php');
include_once(dirname(__FILE__) . '/funciones/funciones.php');
$context = Context::getContext();
$modulo = new ImaxImprimePedidosServidor();
$solicitarLectura = (boolean)Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'SOLICITAR_LECTURA');

//Comprobamos licencia
if(!$modulo->checkLicenciaAdicional('imaximprimepedidosservidorpda', $modulo->getLicenciaAdicional('imaximprimepedidosservidorpda', FALSE), 0)) {
    exit($modulo->l('Es necesaria una licencia para usar este plugin.'));
}

//Comprobamos logueo
if(empty($context->employee->id) || !$context->employee->isLoggedBack()) {
    Tools::redirectAdmin($context->shop->getBaseURL(true).'modules/imaximprimepedidosservidor/pda/index.php');
}

$licenciaPDAEntrada = $modulo->checkLicenciaAdicional('imaximprimepedidosservidorpdaentrada', $modulo->getLicenciaAdicional('imaximprimepedidosservidorpdaentrada', FALSE), 0);

//Formas de pago del empleado
$formasPagoEmpleado = array();
$formasPago = PaymentModule::getInstalledPaymentModules();
$datosEmpleado = $modulo->obtenerDatosExtraEmpleado($context->employee->id);
$todosEmpleados = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'TODOS_EMPLEADOS_PDA');
foreach($formasPago as $formaPago) {
    if($todosEmpleados || ($datosEmpleado && $datosEmpleado['formasPago'] && in_array($formaPago['name'], $datosEmpleado['formasPago']))) {
        $moduloTemp = Module::getInstanceByName($formaPago['name']);
        if(Validate::isLoadedObject($moduloTemp)) {
            $nombrePago = $moduloTemp->displayName;
        }
        else {
            $nombrePago = $formaPago['name'];
        }
        
        $formasPagoEmpleado[$formaPago['name']] = $nombrePago;
    }
}

//Transportistas, cambiamos el contexto para tener todos los transportistas
$contextType = Shop::getContext();
if($contextType == Shop::CONTEXT_GROUP) {
    $idContext = Shop::getContextShopGroupID();
}
else {
    $idContext = Shop::getContextShopID();
}
Shop::setContext(Shop::CONTEXT_ALL);
$transportistas = array();
$transportistasTemp = Carrier::getCarriers($modulo->idLang, true, false, false, null, Carrier::ALL_CARRIERS);
foreach($transportistasTemp as $transportistaTemp) {
    $transportistas[$transportistaTemp['id_reference']] = $transportistaTemp['name'];
}
Shop::setContext($contextType, $idContext);

if(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'VISOR_REDUCIDO') == 1) {
    $visorMuyReducido = 'visorReducido';
}
elseif(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'VISOR_REDUCIDO') == 2) {
    $visorMuyReducido = 'visorMuyReducido';
}
else {
    $visorMuyReducido = '';
}

//Estados de pedido
$estadosPedido = $modulo->cargarEstadosPedido($context->employee->id);

//Boton eliminar fila pedido
$eliminadores = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'EMPLEADOS_PUEDEN_ELIMINAR'));
$botonEliminarFilaPedido = ($eliminadores && in_array($context->employee->id, $eliminadores));

$estadoSinTerminar = (int)Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'ESTADO_SIN_TERMINAR_PDA');
$colorZonaPDA = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'COLOR_ZONA_PDA'));
    
$idBody = 'pda';
$nombreUsuario = $context->employee->firstname.' '.$context->employee->lastname;
$urlImaximprimepedidosservidor = $context->link->getBaseLink() . 'modules/imaximprimepedidosservidor/menu';
$srcLogo = $context->link->getBaseLink() . 'img/' . Configuration::get('PS_LOGO');

$aspectoAlternativo = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'ASPECTO_ALTERNATIVO_PDA');
$mostrarBotonImprimir = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'MOSTRAR_BOTON_IMPRIMIR');

$js[] = '../../comun/js/jquery-ui.min.js';
$js[] = 'Products.js';
$js[] = 'Multiplicador.js';
$js[] = 'procesadores/ProcesaCodigoAlternativamente.js';
$js[] = 'procesadores/ProcesaCodigoConPlantilla.js';
$js[] = 'procesadores/ProcesaCodigoModoNumerosSerie.js';
$js[] = 'vista/Elemento.js';
$js[] = 'vista/Fila.js';
$js[] = 'vista/VisorNormal.js';
$js[] = 'vista/VisorMuyReducido.js';
$js[] = 'LectorCodigos.js';
$js[] = 'DesplazarPaginasConMenu.js';
$js[] = 'funcionesPrincipal.js';
$js[] = 'principal.js';
$css[] = '../../comun/css/jquery-ui.structure.min.css';
$css[] = '../../comun/css/jquery-ui.theme.min.css';
$css[] = 'principal.css';

$cuerpo = 'principal.php';

if(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'UNA_SOLA_PAGINA_PDA')) {
    $css[] = 'principalUna.css';
}
else {
    $css[] = 'principalMulti.css';
}

$nomenStockFisico = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'NOMEN_STOCK_WEB');
$mensaje_restante = 'Restante';
if($nomenStockFisico){
    $mensaje_restante = 'Stock web';
}

$traducciones = array('mensaje_errorListado' => $modulo->l('Error al obtener el listado de pedidos.', 'ImaxImprimePedidosServidor'), 
    'mensaje_errorBloqueo' => $modulo->l('Error al bloquear el pedido.', 'ImaxImprimePedidosServidor'), 
    'mensaje_sinPedidos' => $modulo->l('No existen pedidos para el estado seleccionado.', 'ImaxImprimePedidosServidor'), 
    'mensaje_errorPedidoBloqueado' => $modulo->l('El pedido esta bloqueado.', 'ImaxImprimePedidosServidor'), 
    'mensaje_privado' => $modulo->l('(Privado)', 'ImaxImprimePedidosServidor'), 
    'mensaje_errorCargaPedido' => $modulo->l('Error al cargar el pedido.', 'ImaxImprimePedidosServidor'), 
    'mensaje_errorAgregarMensaje' => $modulo->l('Error al agregar el mensaje.', 'ImaxImprimePedidosServidor'), 
    'mensaje_finalizado' => $modulo->l('Pedido finalizado con exito.', 'ImaxImprimePedidosServidor'),
    'mensaje_impresion' => $modulo->l('Imprimir', 'ImaxImprimePedidosServidor'), 
    'mensaje_sinTerminar' => $modulo->l('El pedido queda pendiente.', 'ImaxImprimePedidosServidor'), 
    'mensaje_formaPago' => $modulo->l('La forma de pago es', 'ImaxImprimePedidosServidor'), 
    'mensaje_transportista' => $modulo->l('El transportista es', 'ImaxImprimePedidosServidor'), 
    'mensaje_identificadorPedido' => $modulo->l('El identificador del pedido es', 'ImaxImprimePedidosServidor'), 
    'mensaje_fecha' => $modulo->l('Creado el', 'ImaxImprimePedidosServidor'), 
    'mensaje_lee' => $modulo->l('Primero lee los mensajes.', 'ImaxImprimePedidosServidor'), 
    'mensaje_noCompleto' => $modulo->l('El pedido no esta completo. ¿Desea finalizarlo igualmente?', 'ImaxImprimePedidosServidor'),
    'mensaje_error_finalizado' => $modulo->l('Error al finalizar', 'ImaxImprimePedidosServidor'),
    'mensaje_error_impresion' => $modulo->l('Error al imprimir', 'ImaxImprimePedidosServidor'), 
    'mensaje_errorCodigo' => $modulo->l('Codigo erroneo.', 'ImaxImprimePedidosServidor'),
    'mensaje_telefono' => $modulo->l('Su telefono es', 'ImaxImprimePedidosServidor'),
    'mensaje_empaquetado' => $modulo->l('Desea empaquetado de regalo.', 'ImaxImprimePedidosServidor'),
    'mensaje_esPack' => $modulo->l('(Pack)', 'ImaxImprimePedidosServidor'),
    'mensaje_introduceSerie' => $modulo->l('Introduce el numero de serie', 'ImaxImprimePedidosServidor'),
    'mensaje_introducidoSerie' => $modulo->l('Numero de serie anotado', 'ImaxImprimePedidosServidor'),
    'mensaje_introduzcaNumerosSerie' => $modulo->l('Puede escanear los numeros de serie que desee.', 'ImaxImprimePedidosServidor'),
    'mensaje_cerrar' => $modulo->l('Cerrar', 'ImaxImprimePedidosServidor'),
    'mensaje_eliminar' => $modulo->l('Eliminar', 'ImaxImprimePedidosServidor'),
    'mensaje_selecciona' => $modulo->l('Selecciona un pedido para ver esta informacion', 'ImaxImprimePedidosServidor'),
    'mensaje_cambiar' => $modulo->l('Cambiar', 'ImaxImprimePedidosServidor'),
    'mensaje_seleccionar' => $modulo->l('Seleccionar', 'ImaxImprimePedidosServidor'),
    'mensaje_ninguno' => $modulo->l('Ninguno', 'ImaxImprimePedidosServidor'),
    'mensaje_ninguno_encontrado' => $modulo->l('Ninguno encontrado.', 'ImaxImprimePedidosServidor'),
    'mensaje_por' => $modulo->l('Por', 'ImaxImprimePedidosServidor'),
    'mensaje_bultos' => $modulo->l('Cantidad de bultos (no todos los transportistas lo usan)', 'ImaxImprimePedidosServidor'),
    'mensaje_referencia' => $modulo->l('Referencia', 'ImaxImprimePedidosServidor'),
    'mensaje_ubicacion' => $modulo->l('Ubicacion', 'ImaxImprimePedidosServidor'),
    'mensaje_fabricante' => $modulo->l('Marca', 'ImaxImprimePedidosServidor'),
    'mensaje_observaciones' => $modulo->l('Observaciones', 'ImaxImprimePedidosServidor'),
    'mensaje_restante' => $modulo->l($mensaje_restante, 'ImaxImprimePedidosServidor'),
    'mensaje_eliminar' => $modulo->l('Eliminar', 'ImaxImprimePedidosServidor'),
    'mensaje_noLote' => $modulo->l('(no existe siguiente lote)', 'ImaxImprimePedidosServidor'),
    'mensaje_errorEliminarFila' => $modulo->l('Error al tratar de eliminar la fila de pedido', 'ImaxImprimePedidosServidor'),
    'mensaje_seguroEliminarFila' => $modulo->l('Se eliminara la fila de pedido, continuar?', 'ImaxImprimePedidosServidor'),
    'visorReducido' => (int)Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'VISOR_REDUCIDO'),
    'packsIndivisibles' => Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'PACKS_INDIVISIBLES'),
    'solicitarLectura' => (boolean)Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'SOLICITAR_LECTURA'),
    'finalizarIncompletos' => Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'FINALIZAR_INCOMPLETOS'),
    'plantilla' => Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'PLANTILLA'),
    'modoPlantilla' => Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'MODO_PLANTILLA'),
    'separadorPlantilla' => Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'SEPARADOR_PLANTILLA'),
    'separadorPlantillaAlternativamente' => Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'SEPARADOR_PLANTILLA_ALTERNATIVAMENTE'),
    'conservarSeparador' => Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'CONSERVAR_SEPARADOR'),
    'conservarSeparadorAlternativamente' => Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'CONSERVAR_SEPARADOR_ALTERNATIVAMENTE'),
    'partesPlantilla' => Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'PARTES_PLANTILLA'),
    'partesPlantillaLote' => Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'PARTES_PLANTILLA_LOTE'),
    'partesPlantillaLoteAlternativamente' => Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'PARTES_PLANTILLA_LOTE_ALTERNATIVAMENTE'),
    'selectorGrupos' => Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'SELECTOR_GRUPOS'),
    'deluxeTracking' => (boolean)Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'DELUXE_TRACKING'),
    'mostrarUbicacion' => (boolean)Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'MOSTRAR_UBI_PDA'),
    'mostrarFabricante' => (boolean)Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'MOSTRAR_FABRICANTE_PDA'),
    'indicarSinStock' => (boolean)Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'INDICAR_SIN_STOCK_PDA'),
    'permitirReemplazar' => (boolean)Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'PERMITIR_REEMPLAZAR_PDA'),
    'simboloMultiplicador' => Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'SIMBOLO_MULTIPLICADOR_PDA'),
    'botonEliminarFilaPedido' => $botonEliminarFilaPedido,
    'eanExtendido' => (Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'EAN_EXTENDIDO_PDA') && 
            Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'IDENTIFICADOR_SALIDA') == 0),
    'multiplicadorSerieProductos' => (boolean)Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'MULTIPLICADOR_SERIE_PRODUCTOS'),
    'mostrarReferencia' => (boolean)Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'MOSTRAR_REF_PDA'),
    'verificarStock' => Module::isEnabled('imaxmultialmacen')
);

$datosExtra = [
    'ventana_sinLotes' => json_encode([cargarVista('ventanaSinLotes.php', $modulo)]),
    'ventana_sobraProducto' => json_encode(cargarVista('ventanaSobraProducto.php', $modulo)),
    'ventana_faltaProducto' => json_encode(cargarVista('ventanaFaltaProducto.php', $modulo)),
    'ventana_inexistente' => json_encode(cargarVista('ventanaInexistente.php', $modulo)),
    'ventana_error' => json_encode(cargarVista('ventanaError.php', $modulo)),
    'ventana_sinStock' => json_encode(cargarVista('ventanaSinStock.php', $modulo))
];

$formasFinalizarPedido = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'FORMAS_FINALIZAR_PEDIDO'));
$opcionesImprimir = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'OPCIONES_IMPRIMIR'));
require_once '../comun/vistas/base.php';