/* global mensaje_referencia, mensaje_restante, mensaje_cambiar, mensaje_ubicacion, mensaje_fabricante, mensaje_eliminar, mensaje_seguroEliminarFila, mensaje_observaciones */

/**
 * Crea filas para la tabla de productos.
 * @type VisorNormal
 */
class VisorNormal {

    /**
     * 
     * @param {boolean} indicarSinStock
     * @param {boolean} botonSumarPDA
     * @param {boolean} mostrarReferencia
     * @param {boolean} mostrarRestante
     * @param {boolean} permitirReemplazar
     * @param {boolean} mostrarUbicacion
     * @param {boolean} mostrarFabricante
     * @param {int} visorReducido
     * @param {boolean} botonEliminar
     * @param {boolean} mostrarObservaciones
     * @returns {VisorNormal}
     */
    constructor(indicarSinStock, botonSumarPDA, mostrarReferencia, mostrarRestante, permitirReemplazar, mostrarUbicacion, mostrarFabricante, 
            visorReducido, botonEliminar, mostrarObservaciones) {
        this.indicarSinStock = indicarSinStock;
        this.botonSumarPDA = (botonSumarPDA === '1');
        this.mostrarReferencia = mostrarReferencia;
        this.mostrarRestante = (mostrarRestante === '1');
        this.permitirReemplazar = permitirReemplazar;
        this.mostrarUbicacion = mostrarUbicacion;
        this.mostrarFabricante = mostrarFabricante;
        this.visorReducido = visorReducido;
        this.botonEliminar = botonEliminar;
        this.mostrarObservaciones = mostrarObservaciones;
    }

    /**
     * Devuelve el html de la fila.
     * @param {Object} datosProducto
     * @param {Object} producto
     * @param {String} claseCSS
     * @returns {jQuery}
     */
    html(datosProducto, producto, claseCSS) {
        var conStock = '';
        if(this.indicarSinStock) {
            if(datosProducto.conStock) {
                conStock = 'conStock';
            }
            else {
                conStock = 'sinStock';
            }
        }

        //Fila 1
        var fila1 = new Fila({ id: obtenerIdCompuesto(producto) + '_identificador', 
            class: 'filaProducto ' + claseCSS + ' filaIncompleta' });
        fila1.agregarElemento(new Elemento('<img src="' + datosProducto.imagen + '" alt/>', false, {}, true));
        fila1.agregarElemento(new Elemento(datosProducto.product_name, false, { class: 'nombreProducto', colspan: 2 }, true));
        fila1.agregarElemento(new Elemento(datosProducto.product_quantity, false, {}, true));
        fila1.agregarElemento(new Elemento('0', false, { class: 'cantidadActual ' + conStock }, true));
        fila1.agregarElemento(new Elemento('<span class="sumar boton">+</span>', false, {}, this.botonSumarPDA));
        fila1.agregarElemento(new Elemento('<span class="restar boton">-</span>', false, {}, true));
        fila1.agregarElemento(new Elemento('<img src="img/error.png" alt=""/>', false, { class: 'productoCompletado' }, this.visorReducido == 0));
        
        //Fila 2
        var fila2 = new Fila({ class: (this.mostrarReferencia ? 'referencia ' : '') + claseCSS + ' filaIncompleta fila2' });
        fila2.agregarElemento(new Elemento('<strong>' + mensaje_referencia + ':</strong>', false, {}, this.mostrarReferencia));
        fila2.agregarElemento(new Elemento(datosProducto.product_reference ? datosProducto.product_reference : '-', false, {}, this.mostrarReferencia));
        fila2.agregarElemento(new Elemento('<span class="eliminar boton">' + mensaje_eliminar + '</span>', false, { rowspan: 3 }, this.botonEliminar));
        fila2.agregarElemento(new Elemento('<span class="reemplazar boton">' + mensaje_cambiar + '</span>', false, { colspan: 2, rowspan: 3}, 
            this.permitirReemplazar));
        fila2.agregarElemento(new Elemento('', false, {}));

        //Fila 3
        var fila3 = new Fila({ class: (this.mostrarUbicacion ? 'ubicacion ' : '') + claseCSS + ' filaIncompleta fila3' });   
        // Verificar si los campos son arrays
        var ubicaciones = Array.isArray(datosProducto.ubicacion) ? datosProducto.ubicacion : [datosProducto.ubicacion];
        var stocksReales = Array.isArray(datosProducto.stockReal) ? datosProducto.stockReal : [datosProducto.stockReal];

        // Determinar el número máximo de elementos para iterar
        var maxLength = Math.max(ubicaciones.length, stocksReales.length);

        // Iterar y agregar elementos a la fila
        var htmlMsjUbi = '', htmlUbi = '', htmlMsjRest = '', htmlStockReal = '';
        for (var i = 0; i < maxLength; i++) {
            if (this.mostrarUbicacion) {
                htmlMsjUbi += '<strong>' + mensaje_ubicacion + ':</strong></br>'
                var ubicacion = ubicaciones[i] !== undefined ? ubicaciones[i] : '-';
                htmlUbi += ubicacion + '</br>';
            }
            if (this.mostrarRestante) {
                htmlMsjRest += '<strong>' + mensaje_restante + ':</strong></br>';
                var stockReal = stocksReales[i] !== undefined ? stocksReales[i] : '-';
                htmlStockReal += stockReal + '</br>';
            }
        }
        
        if (this.mostrarUbicacion) {
            fila3.agregarElemento(new Elemento(htmlMsjUbi, false, {}, true));
            fila3.agregarElemento(new Elemento(htmlUbi, false, { colspan: '2' }, true));
        }
        if (this.mostrarRestante) {
            fila3.agregarElemento(new Elemento(htmlMsjRest, false, {}, true));
            fila3.agregarElemento(new Elemento(htmlStockReal, false, { class: 'cantidadRestante' }, true));
        }

        //Fila 4
        var fila4 = new Fila({ class: (this.mostrarFabricante ? 'fabricante ' : '') + claseCSS + ' filaIncompleta fila4' });
        fila4.agregarElemento(new Elemento('<strong>' + mensaje_fabricante + ':</strong>', false, {}, this.mostrarFabricante));
        fila4.agregarElemento(new Elemento(datosProducto.fabricante ? datosProducto.fabricante : '-', false, {}, this.mostrarFabricante));
        //Fila 5
        var fila5 = new Fila({ class: (this.mostrarObservaciones ? 'observaciones ' : '') + claseCSS + ' filaIncompleta fila5' });
        fila5.agregarElemento(new Elemento('<strong>' + mensaje_observaciones + ':</strong>', false, {}, this.mostrarObservaciones));
        fila5.agregarElemento(new Elemento(datosProducto.observaciones ? datosProducto.observaciones : '-', false, {colspan: '4'}, this.mostrarObservaciones));

        var html = '';
        var filas = [fila1, fila2, fila3, fila4, fila5];
        for(var i=0,len=filas.length;i < len;i++) {
            html += filas[i].html();
        }
        var htmlObj = $(html);
        
        //Eventos
        var excluido = ':nth-child(5), :nth-child(6)';
        htmlObj.eq(0).children('td').not(excluido).click(function() {
            abrirDialogoNumerosSerie(producto);
        });
        if(this.permitirReemplazar) {
           htmlObj.eq(1).find('.boton.reemplazar').click(function() {
                abrirDialogoReemplazo($(this).parent().parent(), producto);
           });
        }
        if(this.botonEliminar) {
            htmlObj.eq(1).find('.boton.eliminar').click(function() {
                if(confirm(mensaje_seguroEliminarFila)) {
                    eliminarFilaPedido(producto);
                }
            });
        }
        
        return htmlObj;
    }
}