/**
 * Fila de una tabla.
 * @type Fila
 */
class Fila {
    /**
     * 
     * @param {Object} atributos
     * @returns {Fila}
     */
    constructor(atributos) {
        this.elementos = [];
        this.atributos = atributos;
    }
    
    /**
     * Agrega un nuevo elemento a la fila.
     * @param {Elemento} elemento
     */
    agregarElemento(elemento) {
        this.elementos.push(elemento);
    }
    
    /**
     * Devuelve el html de la fila.
     * @returns {String}
     */
    html() {
        var html = '<tr';
        for(var nombre in this.atributos) {
            html += ' ' + nombre + '="' + this.atributos[nombre] + '"';
        }
        html += '>';
        for(var i=0,len=this.elementos.length;i<len;i++) {
            html += this.elementos[i].html();
        }
        html += '</tr>';
        
        return html;
    }
}