/**
 * Elemento que se introduce en una fila.
 * @type Elemento
 */
class Elemento {
    /**
     * 
     * @param {String} contenido
     * @param {boolean} titulo
     * @param {Object} atributos
     * @param {boolean} visible
     * @returns {Elemento}
     */
    constructor(contenido, titulo, atributos, visible) {
        this.contenido = (visible ? contenido : '');
        this.atributos = atributos;
        this.titulo = titulo;
    }
    
    /**
     * Devuelve el html del elemento.
     * @returns {String}
     */
    html() {
        var elemento = (this.titulo ? 'th' : 'td');
        var html = '<' + elemento;
        for(var nombre in this.atributos) {
            html += ' ' + nombre + '="' + this.atributos[nombre] + '"';
        }
        html += '>' + this.contenido + '</' + elemento + '>';
        
        return html;
    }
}