/**
 * Procesa numeros de serie consecutivos para el mismo producto. Normalmente desde la ventana de coger numeros de serie abierta.
 * @param {Object} producto 
 * @param {boolean} deluxeTracking
 * @param {String} separadorPlantilla
 * @param {boolean} conservarSeparador
 * @param {String} partesPlantillaLote
 * @param {int} selectorGrupos
 * @returns {ProcesaCodigoModoNumerosSerie}
 */
function ProcesaCodigoModoNumerosSerie(producto, deluxeTracking, separadorPlantilla, conservarSeparador, partesPlantillaLote, selectorGrupos) {
    this.producto = producto;
    this.deluxeTracking = deluxeTracking;
    this.separadorPlantilla = separadorPlantilla;
    this.conservarSeparador = conservarSeparador;
    this.partesPlantillaLote = partesPlantillaLote;
    this.selectorGrupos = selectorGrupos;
}

/**
 * Procesa el codigo escaneado.
 * @param {String} codigoEscaneado
 */
ProcesaCodigoModoNumerosSerie.prototype.procesar = function(codigoEscaneado) {
    if(typeof this.producto.numerosSerie === 'undefined') {
        this.producto.numerosSerie = [];
    }
    if(codigoEscaneado) {
        //Usamos el formato para el numero de serie si lo hay
        if(this.separadorPlantilla) {
            var procesadorTemp = new ProcesaCodigoConPlantilla();
            codigoEscaneado = procesadorTemp.extraerPartes(codigoEscaneado, this.separadorPlantilla, this.partesPlantillaLote, 
                    this.conservarSeparador, this.selectorGrupos);
        }
        
        this.producto.numerosSerie.push(codigoEscaneado);
        if(this.deluxeTracking) {
            reservarNumerosSerie(this.producto, 1, codigoEscaneado);
        }
        agregarFilaNumeroSerie($('#ventanaNumerosSerie table'), this.producto, codigoEscaneado);
    }
    actualizarCantidadTabla(this.producto);
};

/**
 * Elimina la cantidad indicada de ultimos lotes.
 * @param {int} cantidad
 * @return {boolean} 
 */
ProcesaCodigoModoNumerosSerie.prototype.eliminarUltimosCodigos = function(cantidad) {
    if(cantidad <= this.producto.numerosSerie.length) {
        this.producto.numerosSerie.length -= cantidad;
    }
    else {
        this.producto.numerosSerie.length = 0;
    }
    
    for(var i=0;i<cantidad;i++) {
        eliminarFilaNumeroSerie($('#ventanaNumerosSerie table'));
    }
    
    return true;
};