/* global mensaje_introduceSerie, mensaje_errorCodigo, mensaje_introducidoSerie */

/**
 * Procesa primero un codigo de producto y despues un numero de serie, y repite la operacion.
 * @param {Products} productos
 * @param {Multiplicador} multiplicador
 * @param {boolean} deluxeTracking
 * @param {boolean} multiplicadorSerieProductos Usar el mismo multiplicador para los numeros de serie que para los productos.
 * @param {String} separadorPlantilla
 * @param {boolean} conservarSeparador
 * @param {String} partesPlantillaLote
 * @param {int} selectorGrupos
 * @returns {ProcesaCodigoAlternativamente}
 */
function ProcesaCodigoAlternativamente(productos, multiplicador, deluxeTracking, multiplicadorSerieProductos, separadorPlantilla, 
        conservarSeparador, partesPlantillaLote, selectorGrupos) {
    this.productos = productos;
    this.producto = null;
    this.multiplicadorAnterior = null;
    this.multiplicador = multiplicador;
    this.ultimoProducto = null;
    this.deluxeTracking = deluxeTracking;
    this.multiplicadorSerieProductos = multiplicadorSerieProductos;
    this.separadorPlantilla = separadorPlantilla;
    this.conservarSeparador = conservarSeparador;
    this.partesPlantillaLote = partesPlantillaLote;
    this.selectorGrupos = selectorGrupos;
}

/**
 * Procesa el codigo escaneado.
 * @param {String} codigoEscaneado
 */
ProcesaCodigoAlternativamente.prototype.procesar = function(codigoEscaneado) {
    var multiplicador = this.multiplicador.getMultiplicador(codigoEscaneado);
    codigoEscaneado = this.multiplicador.getCodigo(codigoEscaneado);
    
    if(this.producto) {
        //Estamos esperando el numero de serie del producto anterior
        if(typeof this.producto.numerosSerie === 'undefined') {
            this.producto.numerosSerie = [ ];
        }
        if(codigoEscaneado) {
            if(this.multiplicadorSerieProductos && this.multiplicadorAnterior) {
                //Usamos el multiplicador de los productos
                multiplicador = this.multiplicadorAnterior;
            }
            
            //Usamos el formato para el numero de serie si lo hay
            if(this.separadorPlantilla) {
                var procesadorTemp = new ProcesaCodigoConPlantilla();
                codigoEscaneado = procesadorTemp.extraerPartes(codigoEscaneado, this.separadorPlantilla, this.partesPlantillaLote, 
                        this.conservarSeparador, this.selectorGrupos);
            }

            for (var i = 0; i < multiplicador; i++) {
                this.producto.numerosSerie.push(codigoEscaneado);
            }
            
            if(this.deluxeTracking) {
                reservarNumerosSerie(this.producto, multiplicador, codigoEscaneado);
            }
        }
        actualizarCantidadTabla(this.producto);
        mensaje(mensaje_introducidoSerie + ': ' + codigoEscaneado, 'correcto');

        this.producto = null;
        this.multiplicadorAnterior = null;
    }
    else {
        //No hay plantilla, tiene que ser un identificador de producto
        var producto = this.productos.getByIdentifier(codigoEscaneado);
        if (producto) {
            producto.cantidadActual += multiplicador;
            actualizarCantidadTabla(producto);

            //Pedimos el numero de serie si es necesario
            if(producto.usaNumeroSerie) {
                this.producto = producto;
                this.multiplicadorAnterior = multiplicador;
                mensaje(mensaje_introduceSerie, 'aviso');
            }
        } 
        else {
            mensaje(mensaje_errorCodigo + ': ' + codigoEscaneado, 'error');
        }
        
        this.ultimoProducto = producto;
    }
};

/**
 * Elimina la cantidad indicada de ultimos lotes y de producto.
 * @param {int} cantidad
 * @return {boolean}  
 */
ProcesaCodigoAlternativamente.prototype.eliminarUltimosCodigos = function(cantidad) {
    var resultado = false;
    
    if(this.ultimoProducto !== null && this.ultimoProducto.cantidadActual !== null) {
        //Numeros de serie
        if(cantidad <= this.ultimoProducto.numerosSerie.length) {
            this.ultimoProducto.numerosSerie.length -= cantidad;
        }
        else {
            this.ultimoProducto.numerosSerie.length = 0;
        }

        //Cantidad de producto
        this.ultimoProducto.cantidadActual -= cantidad;
        if(this.ultimoProducto.cantidadActual < 0) {
            this.ultimoProducto.cantidadActual = 0;
        }
        
        resultado = true;
    }
    
    return resultado;
};