/* global plantilla, partesPlantilla, modoPlantilla, separadorPlantilla, conservarSeparador, mensaje_privado, mensaje_fecha, mensaje_formaPago, mensaje_transportista, mensaje_telefono, mensaje_empaquetado, packsIndivisibles, mensaje_errorCargaPedido, mensaje_errorAgregarMensaje, finalizarIncompletos, mensaje_noCompleto, solicitarLectura, mensaje_lee, unaSolaPaginaPDA, mensaje_selecciona, mensaje_bultos, visorReducido, simboloMultiplicador, mensaje_errorPedidoBloqueado, partesPlantillaLote, mostrarUbicacion, permitirReemplazar, botonSumarPDA, mostrarFabricante, mostrarRestante, mostrarReferencia, indicarSinStock, botonEliminarFilaPedido, deluxeTracking, multiplicadorSerieProductos, selectorGrupos, conservarSeparadorAlternativamente, partesPlantillaLoteAlternativamente, separadorPlantillaAlternativamente, eanExtendido, aspectoAlternativo, mostrarCP */

var productos = new Products(eanExtendido), procesador, lector, ocultarTeclado = true, visorProductos;

$(function () {
    $.datepicker.regional['es'] = {
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
        dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mié', 'Juv', 'Vie', 'Sáb'],
        dayNamesMin: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'],
        weekHeader: 'Sm',
        dateFormat: 'dd/mm/yy',
        firstDay: 1,
        isRTL: false,
        showMonthAfterYear: false,
        yearSuffix: ''
    };
    
    $('select[name="pedidosMontables"]').chosen();
    $('select[name="transportistaVisible"]').chosen();
    $('select[name="formaPagoVisible"]').chosen();
    $('select[name="filtroEstado"]').chosen();

    actualizarPedidos();
    setInterval(actualizarPedidos, 30000);

    actualizarResultadoPedido();

    $('input[name="fechaInicio"],input[name="fechaFin"]').val("");
    $('input[name="fechaInicio"],input[name="fechaFin"]').datepicker(
            $.extend(
                    {},
                    $.datepicker.regional[ "es" ],
                    {
                        onSelect: function (dateText, inst) {
                            actualizarPedidos();
                        }
                    }
            )
            );

    $('input[name="mensajesLeidos"]').attr('checked', false);
    
    //Agregar mensaje
    $('input[name="enviarMensaje"]').click(function () {
        var mensaje = $('textarea[name="mensaje"]').val(), idPedido = $('select[name="pedidosMontables"]').val(), privado = ($('#privado').is(':checked') ? 1 : 0);

        $.getJSON('ajax.php?callback=?', {
            accion: 'agregarMensaje',
            idPedido: idPedido,
            mensaje: mensaje,
            privado: privado
        }, function (respuesta) {
            if (respuesta.ok) {
                $('#listaMensajes').prepend('<p>' + (privado ? mensaje_privado + ' ' : '') + mensaje + '</p>');
                $('select[name="pedidosMontables"]').addClass('conMensaje');
                $('select[name="pedidosMontables"] option[value="' + idPedido + '"]').addClass('conMensaje');
            } else {
                mensaje(mensaje_errorAgregarMensaje, 'error');
            }
        });
    });

    //Imprimir etiqueta
    $('#finalizar, #finalizarImprimir, #finalizarImprimirBultos').click(function () {
        if (!$(this).hasClass('disabled') || ($('select[name="pedidosMontables"]').val() != '0' && parseInt(finalizarIncompletos) && confirm(mensaje_noCompleto))) {
            if (!solicitarLectura || $('input[name="mensajesLeidos"]').is(':checked')) {
                var bultos = 1;
                if($(this).attr('id') == 'finalizarImprimirBultos' || (pedirBultosFinalizar == 1 && aspectoAlternativo == 1)) {
                    bultos = prompt(mensaje_bultos);
                }
                if(bultos !== null) {
                    finalizar(($(this).attr('id') == 'finalizarImprimir' || $(this).attr('id') == 'finalizarImprimirBultos' ? 1 : 0), bultos);
                }
            } else {
                mensaje(mensaje_lee, 'error');
            }
            $('#contenedorFiltros').show();
            $('#contenedorPedidosMontables').show();
        }
    });
 
    $('#imprimir').click(function() {
        if(!$(this).hasClass('disabled')) {
            imprimir();
        }
    });
    //Dejar pendiente el pedido
    $('#sinTerminar').click(function() {
        if($('select[name="pedidosMontables"]').val() > 0) {
            pedidoSinTerminar();
        }
    });

    var multiplicador = new Multiplicador(simboloMultiplicador);
    //Coger codigos
    if((modoPlantilla == 1 && plantilla) || (modoPlantilla == 2 && separadorPlantilla)) {
        procesador = new ProcesaCodigoConPlantilla(productos, modoPlantilla, plantilla, separadorPlantilla, conservarSeparador, partesPlantilla, 
            partesPlantillaLote, multiplicador, deluxeTracking);
    }
    else {
        procesador = new ProcesaCodigoAlternativamente(productos, multiplicador, deluxeTracking, multiplicadorSerieProductos, 
        separadorPlantillaAlternativamente, conservarSeparadorAlternativamente, partesPlantillaLoteAlternativamente, selectorGrupos);
    }
    lector = new LectorCodigosInput(13, function (codigo) {
        procesador.procesar(codigo);
    });
    //Impedir que le quite el foco a los controles
    $('.hasDatepicker').click(function (ev) {
        ev.stopImmediatePropagation();
    });
    $('.chosen-container').click(function (ev) {
        ev.stopImmediatePropagation();
    });
    $('select[name="formaPagoVisible"]').click(function (ev) {
        ev.stopImmediatePropagation();
    });
    $('select[name="transportistaVisible"]').click(function (ev) {
        ev.stopImmediatePropagation();
    });
    $('select[name="filtroEstado"]').click(function (ev) {
        ev.stopImmediatePropagation();
    });
    $('select[name="sinTerminar"]').click(function (ev) {
        ev.stopImmediatePropagation();
    });
    $('select[name="pedidosMontables"]').click(function (ev) {
        ev.stopImmediatePropagation();
    });
    //Devolvemos el foco al input invisible
    $('.chosen-results').click(function (ev) {
        focoEnInput(lector.inputName, false, ev);
    });
    $('select[name="formaPagoVisible"]').change(function (ev) {
        focoEnInput(lector.inputName, false, ev);
    });
    $('select[name="transportistaVisible"]').change(function (ev) {
        focoEnInput(lector.inputName, false, ev);
    });
    $('select[name="pedidosMontables"]').change(function (ev) {
        focoEnInput(lector.inputName, false, ev);
    });
    $('select[name="filtroEstado"]').change(function (ev) {
        focoEnInput(lector.inputName, false, ev);
    });
    $('#contenedorPedidosMontables').click(function (ev) {
        focoEnInput(lector.inputName, false, ev);
    });
    $('#contenedorFiltros').click(function (ev) {
        focoEnInput(lector.inputName, false, ev);
    });
    $('.pagina').eq(0).click(function (ev) {
        focoEnInput(lector.inputName, false, ev);
    });
    
    //Filtro de forma de pago
    $('select[name="formaPagoVisible"]').change(function () {
        actualizarPedidos();
    });
    
    //Filtro de transportista
    $('select[name="transportistaVisible"]').change(function () {
        actualizarPedidos();
    });
    
    //Filtro de estado
    $('select[name="filtroEstado"]').change(function () {
        actualizarPedidos();
    });
    
    //Objeto para la creacion de la tabla de productos
    if(visorReducido == 2) {
        visorProductos = new VisorMuyReducido(indicarSinStock, botonSumarPDA, mostrarReferencia, mostrarRestante, permitirReemplazar, 
            mostrarUbicacion, mostrarFabricante, botonEliminarFilaPedido, aspectoAlternativo == 1);
    }
    else {
        visorProductos = new VisorNormal(indicarSinStock, botonSumarPDA, mostrarReferencia, mostrarRestante, permitirReemplazar, 
            mostrarUbicacion, mostrarFabricante, visorReducido, botonEliminarFilaPedido, aspectoAlternativo == 1);
    }
    
    //Cambio de modo
    $('select[name="sinTerminar"]').change(function () {
        //Refrescamos la lista de pedidos y cerramos el pedido actual
        actualizarPedidos();
        $('select[name="pedidosMontables"]').val(0);
        $('select[name="pedidosMontables"]').change();
        $('select[name="pedidosMontables"]').trigger('chosen:updated');
    });

    //Cambio de pedido
    $('select[name="pedidosMontables"]').change(function () {
        $('input[name="mensajesLeidos"]').attr('checked', false);

        $(this).removeClass('conStock').removeClass('sinStock').removeClass('conMensajePublico').removeClass('conMensajePrivado').removeClass('conMensajeAmbos');
        $('#contenedorPedidosMontables a.chosen-single').removeClass('conStock').removeClass('sinStock').removeClass('conMensajePublico').removeClass('conMensajePrivado').removeClass('conMensajeAmbos');

        $(this).addClass($('select[name="pedidosMontables"] option[value="' + $(this).val() + '"]').attr('class'));
        $('#contenedorPedidosMontables a.chosen-single').addClass($('select[name="pedidosMontables"] option[value="' + $(this).val() + '"]').attr('class'));

        if (parseInt($(this).val())) {
            //Cargamos los productos
            $.getJSON('ajax.php?callback=?', {
                accion: 'cargarPedido',
                idPedido: $(this).val(),
                uniq: sessionStorage.imax_uniq
            }, function (respuesta) {
                if (respuesta.ok) {
                    sessionStorage.imax_uniq = respuesta.datos.uniq;
                    $('#imprimir').removeClass('disabled');
                    $('#listaMensajes').empty();
                    for (var i = 0, len = respuesta.datos.mensajes.length; i < len; i++) {
                        var iter = respuesta.datos.mensajes[i];
                        $('#listaMensajes').append('<p>' + (iter.private == 1 ? mensaje_privado + ' ' : '') + iter.message + '</p>');
                    }

                    if(visorReducido == 2) {
                        //Visor muy reducido
                        $('#contenedorInfo #fechaPedido').html(respuesta.datos.fechaCreacion + ". " + respuesta.datos.formaPago + ". " + respuesta.datos.transportista + ".");
                    }
                    else if(aspectoAlternativo == 1){
                        $('#contenedorInfo #fechaPedido').html(mensaje_fecha + " <strong>" + respuesta.datos.fechaCreacion + "</strong>.").hide();
                        $('#contenedorInfo #formaPago').html(mensaje_formaPago + " <strong>" + respuesta.datos.formaPago + "</strong>.").hide();
                        if(mostrarCP == 1){
                            $('#contenedorInfo #transportista').html(mensaje_transportista + " <strong>" + respuesta.datos.transportista + " (" + respuesta.datos.codPostal + ")</strong>.");
                        }else{
                            $('#contenedorInfo #transportista').html(mensaje_transportista + " <strong>" + respuesta.datos.transportista + "</strong>.");
                        }
                        $('#contenedorInfo #telefono').html(mensaje_telefono + " <strong>" + respuesta.datos.telefono + "</strong>.").hide();
                        $('#contenedorInfo #empaquetado').html((respuesta.datos.empaquetado === '1' ? mensaje_empaquetado + ' ' + respuesta.datos.empaquetadoMensaje : '')).hide();
                        if(identificadorPedido == 0){
                            $('#contenedorInfo #identificadorPedido').html(mensaje_identificadorPedido + " <strong>" + respuesta.datos.referencia + "</strong>.");
                        }else{
                            $('#contenedorInfo #identificadorPedido').html(mensaje_identificadorPedido + " <strong>" + respuesta.datos.idPrestashop + "</strong>.");
                        }
                    }else{
                        $('#contenedorInfo #fechaPedido').html(mensaje_fecha + " <strong>" + respuesta.datos.fechaCreacion + "</strong>.");
                        $('#contenedorInfo #formaPago').html(mensaje_formaPago + " <strong>" + respuesta.datos.formaPago + "</strong>.");
                        if(mostrarCP == 1){
                            $('#contenedorInfo #transportista').html(mensaje_transportista + " <strong>" + respuesta.datos.transportista + " (" + respuesta.datos.codPostal + ")</strong>.");
                        }else{
                            $('#contenedorInfo #transportista').html(mensaje_transportista + " <strong>" + respuesta.datos.transportista + "</strong>.");
                        }
                        $('#contenedorInfo #telefono').html(mensaje_telefono + " <strong>" + respuesta.datos.telefono + "</strong>.");
                        $('#contenedorInfo #empaquetado').html((respuesta.datos.empaquetado === '1' ? mensaje_empaquetado + ' ' + respuesta.datos.empaquetadoMensaje : ''));
                    }
                    $('#contenedorInfoClientes #email').html("Email: <strong>" + respuesta.datos.email + "</strong>.");
                    $('#contenedorInfoClientes #customer').html("Nombre: <strong>" + respuesta.datos.customer + "</strong>.");
                    $('#contenedorInfoClientes #telefonoCliente').html("<p>Telefono: <strong>" + respuesta.datos.telefono + "</strong>.</p>");
                    $('#contenedorInfoClientes #direccionEntrega').html(" Direccion: <strong>" + respuesta.datos.direccionEntrega + "</strong>.");
                    $('#contenedorInfoClientes #transportista').html("Forma de Envio: <strong>" + respuesta.datos.transportista + "</strong>.");
                    $('#contenedorInfoClientes #codPostal').html("Codigo Postal: <strong>" + respuesta.datos.codPostal + "</strong>.");
                    $('#contenedorInfoClientes #ciudad').html("Ciudad:  <strong>" + respuesta.datos.ciudad + "</strong>.");
                    $('#contenedorInfoClientes #pais').html("Pais: <strong>" + respuesta.datos.pais + "</strong>.");
                    $('#contenedorInfoClientes #idPrestashop').html("ID Pedido: <strong>" + respuesta.datos.idPrestashop + "</strong>.");
                    $('#contenedorInfoClientes #referencia').html("Referencia: <strong>" + respuesta.datos.referencia + "</strong>.");
                    if(respuesta.datos.referenciaAmazon){
                        $('#contenedorInfoClientes #referenciaAmazon').html("Referencia Amazon: <strong>" + respuesta.datos.referenciaAmazon + "</strong>.");
                    }
                    $('#contenedorInfoClientes #sexo').html("Genero: <strong>" + respuesta.datos.sexo + "</strong>.");
                    $('#contenedorInfoClientes #nota').html("Nota Cliente: <strong>" + respuesta.datos.nota + "</strong>.");

                    $('#contenedorProductos table tbody').empty();
                    productos.clear();
                    for (var x in respuesta.datos.productos) {
                        var iter = respuesta.datos.productos[x];

                        if (packsIndivisibles == "1") {
                            //Los packs son indivisibles, ignoramos sus componentes
                            introducirLineaProducto(iter, '');
                        } else {
                            //Los packs se montan producto a producto
                            if (iter.componentes.length > 0) {
                                introducirCabeceraPack(iter);
                                for (var x in iter.componentes) {
                                    iter.componentes[x].idPack = iter.id_product;
                                    introducirLineaProducto(iter.componentes[x], 'identar');
                                }
                            } else {
                                introducirLineaProducto(iter, '');
                            }
                        }
                    }
                    
                    actualizarResultadoPedido();

                    $('#contenedorProductos table .restar').click(function () {
                        var producto = obtenerProductoPorFila($(this).parent().parent());
                        if (producto && producto.cantidadActual > 0) {
                            var multi = multiplicador.getMultiplicador($('input[name="' + lector.inputName + '"]').val());
                            $('input[name="' + lector.inputName + '"]').val('');
                            
                            if(producto.usaNumeroSerie) {
                                procesador.ultimoProducto = producto;
                                if(procesador instanceof ProcesaCodigoAlternativamente) {
                                    procesador.producto = null;
                                }
                                
                                if(producto.cantidadActual > producto.numerosSerie.length) {
                                    producto.cantidadActual -= multi;
                                }
                                else {
                                    if(deluxeTracking) {
                                        bloquearPantalla();

                                        var multiTemp = multi;
                                        var codigosEliminables = { };
                                        for(var i=producto.numerosSerie.length-1;i >= 0;i--) {
                                            if(typeof codigosEliminables[producto.numerosSerie[i]] === 'undefined') {
                                                codigosEliminables[producto.numerosSerie[i]] = 0;
                                            }
                                            codigosEliminables[producto.numerosSerie[i]]++;
                                        }
                                        if(Object.keys(codigosEliminables).length > 0) {
                                            for(var codigo in codigosEliminables) {
                                                if(multiTemp >= codigosEliminables[codigo]) {
                                                    marcarDisponible(producto, codigo, codigosEliminables[codigo], function() {
                                                        desbloquearPantalla();
                                                    });
                                                    multiTemp -= codigosEliminables[codigo];
                                                }
                                                else {
                                                    marcarDisponible(producto, codigo, multiTemp, function() {
                                                        desbloquearPantalla();
                                                    });
                                                    multiTemp = 0;
                                                }

                                                if(multiTemp <= 0) {
                                                    break;
                                                }
                                            }
                                        }
                                        else {
                                            desbloquearPantalla();
                                        }
                                    }

                                    if(!procesador.eliminarUltimosCodigos(multi)) {
                                        producto.cantidadActual -= multi;
                                    }
                                }
                            }
                            else {
                                producto.cantidadActual -= multi;
                            }
                            actualizarCantidadTabla(producto);
                        }
                    });

                    $('#contenedorProductos table .sumar').click(function () {
                        var producto = obtenerProductoPorFila($(this).parent().parent());
                        if (producto) {
                            var multi = multiplicador.getMultiplicador($('input[name="' + lector.inputName + '"]').val());
                            $('input[name="' + lector.inputName + '"]').val('');
                            
                            producto.cantidadActual += multi;
                            actualizarCantidadTabla(producto);
                        }
                    });
                    
                    $('#contenedorProductos table .eliminar').click(function() {
                        
                    });
                } 
                else if(respuesta.msg === 1) {
                    limpiarPedido();
                    mensaje(mensaje_errorPedidoBloqueado, 'error');
                }
                else {
                    limpiarPedido();
                    mensaje(mensaje_errorCargaPedido, 'error');
                }
            });
        } else {
            bloquear();
            limpiarPedido();
        }
    });
    $('select[name="pedidosMontables"]').change();
    setInterval(bloquear, 60000);
    
    $('#botonTeclado').click(function (ev) {
        ocultarTeclado = !ocultarTeclado;
        focoEnInput(lector.inputName, true, ev);
    });

    if(unaSolaPaginaPDA != "1") {
        var desplaza = new DesplazarPaginasConMenu('#paginas', '.pagina', '#menu', function (pagina) {
            if (pagina == 0) {
                focoEnInput(lector.inputName);
                lector.iniciarCaptacion();
            }
        });

        $('#botonMenu').click(function () {
            desplaza.intercambiarMenu();
        });

        $(window).on("orientationchange", function (event) {
            setTimeout(function () {
                $('.pagina').width($('html').width());
                $('#paginas').width($('.pagina').length * $('.pagina').width());
                desplaza.actualizarPosicion();
            }, 500);
        });
    }

    //Enlace
    $('#pickingEntrada').click(function () {
        window.location = '../pdaEntrada';
    });

    $(document).keyup(function (ev) {
        var paginaActual = $('#menu li').index($('#menu li.paginaActual'));
        if (ev.keyCode == 37) {
            //izquierda
            if (paginaActual > 0 && unaSolaPaginaPDA != "1") {
                var anterior = $('#menu li.paginaActual').prev();
                if (anterior.length) {
                    desplaza.cambiarPagina(paginaActual - 1);
                    $('#menu li').removeClass('paginaActual');
                    anterior.addClass('paginaActual');
                }
            }
        } else if (ev.keyCode == 39) {
            //derecha
            if (paginaActual < $('#menu li').length - 1 && unaSolaPaginaPDA != "1") {
                var siguiente = $('#menu li.paginaActual').next();
                if (siguiente.length) {
                    desplaza.cambiarPagina(paginaActual + 1);
                    $('#menu li').removeClass('paginaActual');
                    siguiente.addClass('paginaActual');
                }
            }
        } else if (ev.keyCode == 36) {
            //inicio
            if(unaSolaPaginaPDA != "1") {
                desplaza.cambiarPagina(0);
                $('#menu li').removeClass('paginaActual');
                $('#menu li').eq(0).addClass('paginaActual');
            }
        } else if (!ev.ctrlKey && ev.keyCode == 38) {
            //arriba
            if (!$('select[name="pedidosMontables"]').is(":focus")) {
                var anterior = $('select[name="pedidosMontables"] option:selected').prev();
                if (anterior.length) {
                    $('select[name="pedidosMontables"]').val(anterior.val());
                    $('select[name="pedidosMontables"]').change();
                    $('select[name="pedidosMontables"]').trigger('chosen:updated');
                }
            }
        } else if (!ev.ctrlKey && ev.keyCode == 40) {
            //abajo
            if (!$('select[name="pedidosMontables"]').is(":focus")) {
                var siguiente = $('select[name="pedidosMontables"] option:selected').next();
                if (siguiente.length) {
                    $('select[name="pedidosMontables"]').val(siguiente.val());
                    $('select[name="pedidosMontables"]').change();
                    $('select[name="pedidosMontables"]').trigger('chosen:updated');
                }
            }
        } else if (ev.ctrlKey && ev.keyCode == 38) {
            //control + arriba
            $('#finalizar').click();
        } else if (ev.ctrlKey && ev.keyCode == 40) {
            //control + abajo
            $('#finalizarImprimir').click();
        }
    });

    focoEnInput(lector.inputName);
    lector.iniciarCaptacion();
});
