/* global productos, procesador, lector, mostrarReferencia, mostrarUbicacion, mensaje_esPack, botonSumarPDA, mensaje_eliminar, mensaje_errorListado, mensaje_errorBloqueo, mensaje_finalizado, mensaje_error_finalizado, mensaje_introduzcaNumerosSerie, mensaje_cerrar, indicarSinStock, permitirReemplazar, mensaje_cambiar, mensaje_seleccionar, mensaje_ninguno, mensaje_ninguno_encontrado, mensaje_por, mensaje_referencia, mensaje_ubicacion, visorReducido, visorMuyReducido, ocultarTeclado, mensaje_selecciona, mostrarFabricante, mensaje_fabricante, deluxeTracking, ventana_sinLotes, ventana_sobraProducto, ventana_faltaProducto, ventana_error, visorProductos, mensaje_errorEliminarFila, mensaje_noLote, ventana_inexistente, partesPlantillaLote, conservarSeparador, separadorPlantilla, selectorGrupos, mensaje_sinTerminar, aspectoAlternativo, verificarStock, ventana_sinStock */

var procesadorAnterior = null;

/**
 * Indica si un pedido está bloqueado.
 * @param {array} bloqueos
 * @param {int} idPedido
 * @returns {Boolean}
 */
function bloqueado(bloqueos, idPedido) { 
    var encontrado = false;

    for (var i = 0, len = bloqueos.length; i < len; i++) {
        if (bloqueos[i].idPedido == idPedido) {
            encontrado = true;
            break;
        }
    }

    return encontrado;
}

/**
 * Actualiza la lista de pedidos.
 */
function actualizarPedidos() {
    $.getJSON('ajax.php?callback=?', {
        accion: 'obtenerListaPedidos',
        fechaDesde: $.trim($('input[name="fechaInicio"]').val()),
        fechaHasta: $.trim($('input[name="fechaFin"]').val()),
        formaPagoVisible: $('select[name="formaPagoVisible"]').val(),
        transportistaVisible: $('select[name="transportistaVisible"]').val(),
        modoSinTerminar: $('select[name="sinTerminar"]').val(),
        estadoVisible: $('select[name="filtroEstado"]').val(),
        uniq: sessionStorage.imax_uniq
    }, function (respuesta) {
        if (respuesta.ok) {
            var seleccionado = $('select[name="pedidosMontables"]').val(), existe = false;
            $('select[name="pedidosMontables"] option').slice(1).remove();
            for (var x in respuesta.datos.pedidos) {
                var clase = 'zona' + respuesta.datos.pedidos[x].id_zone, simbolo = '';
                if (respuesta.datos.pedidos[x].publicos > 0 && respuesta.datos.pedidos[x].privados > 0) {
                    clase = ' conMensajeAmbos';
                    simbolo = '*_';
                } else {
                    if (respuesta.datos.pedidos[x].publicos > 0) {
                        clase = ' conMensajePublico';
                        simbolo = '_';
                    } else if (respuesta.datos.pedidos[x].privados > 0) {
                        clase = ' conMensajePrivado';
                        simbolo = '*';
                    }
                }
                
                if(respuesta.datos.pedidos[x].conStock == 0 && indicarSinStock == 1) {
                    clase += ' sinStock';
                    simbolo += '/';
                }

                var textoTienda = (respuesta.datos.pedidos[x].textoTienda ? '(' + respuesta.datos.pedidos[x].textoTienda + ') ' : '');
                $('select[name="pedidosMontables"]').append('<option ' + (bloqueado(respuesta.datos.bloqueos, respuesta.datos.pedidos[x].id_order) ? 'disabled="disabled"' : '') +
                        ' value="' + respuesta.datos.pedidos[x].id_order + '" class="' + clase + '">' + simbolo + textoTienda + respuesta.datos.pedidos[x].id_order + (aspectoAlternativo == 1 ? '' : ' - ' + respuesta.datos.pedidos[x].reference) + '</option>');

                if (respuesta.datos.pedidos[x].id_order == seleccionado) {
                    existe = true;
                }
            }

            if (existe) {
                $('select[name="pedidosMontables"]').val(seleccionado);
            } else {
                $('select[name="pedidosMontables"]').val('0');
                $('select[name="pedidosMontables"]').change();
            }
            $('select[name="pedidosMontables"]').trigger('chosen:updated');
        } else {
            mensaje(mensaje_errorListado, 'error');
        }
    });
}

/**
 * Bloquea un pedido.
 */
function bloquear() {
    $.getJSON('ajax.php?callback=?', {
        accion: 'bloquear',
        idPedido: $('select[name="pedidosMontables"]').val(),
        uniq: sessionStorage.imax_uniq
    }, function (respuesta) {
        if (respuesta.ok) {
            sessionStorage.imax_uniq = respuesta.datos.uniq;
        }
        else {
            mensaje(mensaje_errorBloqueo, 'error');
        }
    });
}

/**
 * Actualiza la cantidad de producto en la tabla.
 * @param {Object} producto
 */
function actualizarCantidadTabla(producto) {
    $('#' + obtenerIdCompuesto(producto) + '_identificador .cantidadActual').html(producto.cantidadActual);
    setSeleccionada($('#' + obtenerIdCompuesto(producto) + '_identificador'));
    $('#' + obtenerIdCompuesto(producto) + '_identificador').next().find('.cantidadRestante').html(producto.stockReal - producto.cantidadActual);
    if (producto.cantidadActual == producto.cantidadNecesaria) {
        if(comprobarNumerosSerie(producto)) {
            $('#' + obtenerIdCompuesto(producto) + '_identificador .productoCompletado img').attr('src', 'img/ok.png');
            cambiarClaseReducida($('#' + obtenerIdCompuesto(producto) + '_identificador'), 'filaCompleta');
        }
        else {
            $('#' + obtenerIdCompuesto(producto) + '_identificador .productoCompletado img').attr('src', 'img/ok_medio.png');
            cambiarClaseReducida($('#' + obtenerIdCompuesto(producto) + '_identificador'), 'filaMedioCompleta');
        }
    }
    else {
        $('#' + obtenerIdCompuesto(producto) + '_identificador .productoCompletado img').attr('src', 'img/error.png');
        cambiarClaseReducida($('#' + obtenerIdCompuesto(producto) + '_identificador'), 'filaIncompleta');
    }
    cargarUnidadesContador();
    actualizarResultadoPedido();
}

function cargarUnidadesContador(){
    var totales = 0;
    var escaneadas = 0;
    
    $('.cantidadActual').prev('td').each(function () {
        if(!isNaN($(this).html())){
            totales = parseInt(totales) + parseInt($(this).html());
        }
    });

    $('.cantidadActual').each(function () {
        if(!isNaN($(this).html())){
            escaneadas = parseInt(escaneadas) + parseInt($(this).html());
        }
    });
    if (totales == '') {
        totales = 0;
    }
    if (escaneadas == '') {
        escaneadas = 0;
    }
    if(totales == escaneadas){
        $('#unidadesTotales').css('color','green');
        $('#unidadesEscaneadas').css('color','green');
    }else{
        $('#unidadesTotales').css('color','red');
        $('#unidadesEscaneadas').css('color','red');
    }
    $('#unidadesTotales').val(totales);
    $('#unidadesEscaneadas').val(escaneadas);
}

/**
 * Cambia la clase de la fila para el modo de visualizacion reducido.
 * @param {JQuery} fila
 * @param {String} clase
 */
function cambiarClaseReducida(fila, clase) {
    fila.removeClass('filaIncompleta').removeClass('filaCompleta').removeClass('filaMedioCompleta').addClass(clase);
    fila.next('.fila2').removeClass('filaIncompleta').removeClass('filaCompleta').removeClass('filaMedioCompleta').addClass(clase);
    fila.next('.fila2').next('.fila3').removeClass('filaIncompleta').removeClass('filaCompleta').removeClass('filaMedioCompleta').addClass(clase);
    fila.next('.fila3').removeClass('filaIncompleta').removeClass('filaCompleta').removeClass('filaMedioCompleta').addClass(clase);
}

/**
 * Comprueba si disponemos de la cantidad correcta de numeros de serie.
 * @param {Object} producto
 * @returns {boolean}
 */
function comprobarNumerosSerie(producto) {
    var completados = true;
    if(producto.usaNumeroSerie) {
        if(typeof producto.numerosSerie !== 'undefined') {
            completados = (producto.numerosSerie.length == producto.cantidadNecesaria);
        }
        else {
            completados = false;
        }
    }
    
    return completados;
}

/**
 * Actualiza la visualización cuando el pedido está completo.
 */
function actualizarResultadoPedido() {
    var completado = true;
    if (productos.isEmpty()) {
        completado = false;
        $('#sinTerminar').addClass('disabled');
    } else {
        $('#sinTerminar').removeClass('disabled');
        for (var x in productos.products) {
            if (productos.products[x].cantidadActual != productos.products[x].cantidadNecesaria || !comprobarNumerosSerie(productos.products[x])) {
                completado = false;
                break;
            }
        }
    }

    if (completado) {
        $('#contenedorFinalizado img').attr('src', 'img/ok.png');
        $('#finalizar').removeClass('disabled');
        $('#finalizarImprimir').removeClass('disabled');
        $('#finalizarImprimirBultos').removeClass('disabled');
    } else {
        $('#contenedorFinalizado img').attr('src', 'img/error.png');
        $('#finalizar').addClass('disabled');
        $('#finalizarImprimir').addClass('disabled');
        $('#finalizarImprimirBultos').addClass('disabled');
    }

    if(verificarStock) {
        var productosSinStock = [];
        //Comprobamos que exista stock suficiente
        for (var x in productos.products) {
            if (productos.products[x].stockReal < productos.products[x].cantidadNecesaria) {
                productosSinStock.push(productos.products[x]);
            }
        }
        
        if(productosSinStock.length > 0) {
            //Modificamos los controles
            $('#sinTerminar').addClass('disabled').css('pointer-events', 'none');
            $('#finalizar').addClass('disabled').css('pointer-events', 'none');
            $('#finalizarImprimir').addClass('disabled').css('pointer-events', 'none');
            $('#finalizarImprimirBultos').addClass('disabled').css('pointer-events', 'none');
            //Mostramos un mensaje
            var listadoProductosSinStock = '';
            productosSinStock.forEach(function(productoSinStock) {
                listadoProductosSinStock += '<li>' + productoSinStock.nombre + '</li>';
            });
            var ventana = ventana_sinStock.replace('{productosSinStock}', listadoProductosSinStock);
            abrirDialogo(ventana, function() {
                $('.cerrarVentana').click(function() {
                    cerrarDialogo();
                });
            });
        }
    }
}

/**
 * Termina el pedido.
 * @param {int} imprimir
 * @param {int} bultos
 */
function finalizar(imprimir, bultos) {
    $('#sinTerminar').addClass('disabled');
    $('#finalizar').addClass('disabled');
    $('#finalizarImprimir').addClass('disabled');
    $('#finalizarImprimirBultos').addClass('disabled');

    bultos = parseInt($.trim(bultos));
    var idPedido = $('select[name="pedidosMontables"]').val();
    $.ajax('ajax.php?callback=?', {
        cache: false,
        data: {
            accion: 'finalizar',
            idPedido: idPedido,
            imprimir: imprimir,
            bultos: (isNaN(bultos) ? 1 : bultos),
            productos: productos.products
        },
        dataType: "jsonp",
        method: "POST"
    }).done(function (respuesta) {
        if (respuesta.ok) { 
            $('#imprimir').addClass('disabled');           
            $('select[name="pedidosMontables"]').val(0);
            $('select[name="pedidosMontables"] option[value="' + idPedido + '"]').remove();
            $('select[name="pedidosMontables"]').change();
            $('select[name="pedidosMontables"]').trigger('chosen:updated');

            mensaje(mensaje_finalizado, 'correcto');
        } else {
            $('#sinTerminar').removeClass('disabled');
            $('#finalizar').removeClass('disabled');
            $('#finalizarImprimir').removeClass('disabled');
            $('#finalizarImprimirBultos').removeClass('disabled');

            mensaje(mensaje_error_finalizado, 'error');
        }
    });
}

/**
 * Marca el pedido para su impresión
 */

function imprimir(){
    var idPedido = $('select[name="pedidosMontables"]').val();
    $.ajax('ajax.php?callback=?', {
        cache: false,
        data: {
            accion: 'imprimir',
            idPedido: idPedido
        },
        dataType: "jsonp",
        method: "POST"
    }).done(function (respuesta) {
        if (respuesta.ok) {            
            mensaje(mensaje_impresion, 'correcto');
        } else {
            mensaje(mensaje_error_impresion, 'error');
        }
    });
}
/**
 * Deja un pedido pendiente.
 */
function pedidoSinTerminar() {
    $('#sinTerminar').addClass('disabled');
    $('#finalizar').addClass('disabled');
    $('#finalizarImprimir').addClass('disabled');
    $('#finalizarImprimirBultos').addClass('disabled');
    
    var idPedido = $('select[name="pedidosMontables"]').val();
    $.ajax('ajax.php?callback=?', {
        cache: false,
        data: {
            accion: 'sinTerminar',
            idPedido: idPedido
        },
        dataType: "jsonp",
        method: "POST"
    }).done(function (respuesta) {
        $('#sinTerminar').removeClass('disabled');
        if (respuesta.ok) {            
            $('select[name="pedidosMontables"]').val(0);
            $('select[name="pedidosMontables"]').change();
            $('select[name="pedidosMontables"]').trigger('chosen:updated');

            mensaje(mensaje_sinTerminar, 'correcto');
        } else {
            $('#sinTerminar').removeClass('disabled');
            $('#finalizar').removeClass('disabled');
            $('#finalizarImprimir').removeClass('disabled');
            $('#finalizarImprimirBultos').removeClass('disabled');

            mensaje(mensaje_error_finalizado, 'error');
        }
    });
}

/**
 * Pone el cursor en el input de captación.
 * @param {string} inputName
 * @param {boolean} forzar
 * @param {event} ev
 */
function focoEnInput(inputName, forzar, ev) {
    var input = $('input[name="' + inputName + '"]'); 
    if (!input.is(':focus') || forzar) {
        if(ev){
            input.css({
                'top': ev.pageY + 'px'
            });
        }
        if(ocultarTeclado) {
            input.attr('readonly', 'readonly');
        }
        input.focus();
        if(ocultarTeclado) {
            setTimeout(function () {
                input.removeAttr('readonly');
            }, 50);
        }
    }
}

/**
 * Crea una nueva línea en la tabla de productos.
 * @param {object} datosProducto
 * @param {string} claseCSS
 */
function introducirLineaProducto(datosProducto, claseCSS) {
    var producto = {cantidadNecesaria: datosProducto.product_quantity, cantidadActual: datosProducto.cantidadActual, usaNumeroSerie: datosProducto.usaNumeroSerie,
            stockReal: datosProducto.stockReal, identificador: datosProducto.identificador, id_order_detail: datosProducto.id_order_detail,
            id_product: datosProducto.product_id, id_product_attribute: datosProducto.product_attribute_id, 
            idPack: (typeof datosProducto.idPack !== 'undefined' ? datosProducto.idPack : 0), numerosSerie: datosProducto.numerosSerie,
            eans13: datosProducto.eans13, nombre: datosProducto.product_name };
    productos.products.push(producto);

    $('#contenedorProductos table tbody').append(visorProductos.html(datosProducto, producto, claseCSS));
    actualizarCantidadTabla(producto);
}

/**
 * Crea la línea de cabecera para un pack en la tabla de productos.
 * @param {object} datosProducto
 */
function introducirCabeceraPack(datosProducto) {
    $('#contenedorProductos table tbody').append('<tr><td><img src="' + datosProducto.imagen + '" alt/></td><td>' + mensaje_esPack + ' ' + datosProducto.product_name + '</td><td>-</td><td class="cantidadActual">-</td>' +
            (botonSumarPDA == "1" ? '<td></td>' : '') + '<td></td></td></tr>');
}

/**
 * Obtiene el identificador de un producto a partir de su id de html.
 * @param {String} id
 * @returns {String}
 */
function obtenerCodigo(id) {
    var partes = id.split('_');
    partes.pop();
    
    return partes.join('_');
}

/**
 * Abre la ventana de manejo de los numeros de serie.
 * @param {Object} producto
 */
function abrirDialogoNumerosSerie(producto) {
    var html = 
            '<div id="ventanaNumerosSerie" class="ventanaNumerosSerie">' + 
                '<p>' + mensaje_introduzcaNumerosSerie + '</p>' +
                '<table>' +
                '</table>' +
                '<p><span id="cerrar" class="boton">' + mensaje_cerrar + '</span></p>' +
            '</div>';
    
    $('body').append('<div id="fondoOscuroNumerosSerie"></div>');
    $('body').append(html);
    
    if(typeof producto.numerosSerie !== 'undefined') {
        var tabla = $('#ventanaNumerosSerie table');
        for(var i=0,len=producto.numerosSerie.length;i<len;i++) {
            agregarFilaNumeroSerie(tabla, producto, producto.numerosSerie[i]);
        }
    }
    
    //Centrar
    $('#ventanaNumerosSerie').css('left', parseFloat($('body').width())/2 - parseFloat($('#ventanaNumerosSerie').outerWidth())/2);
    //Modificamos modo escaneo 
    procesadorAnterior = procesador;
    procesador = new ProcesaCodigoModoNumerosSerie(producto, deluxeTracking, separadorPlantilla, conservarSeparador, partesPlantillaLote, 
        selectorGrupos);
    //Controles
    $('#ventanaNumerosSerie').click(function(ev) {
        focoEnInput(lector.inputName, false, ev);
    });
    $('#fondoOscuroNumerosSerie, #cerrar').click(function() {
        //Cerrar
        cerrarDialogoNumeroSerie();
    });
}

/**
 * Agrega una fila a la tabla de numeros de serie.
 * @param {jquery} tabla
 * @param {Object} producto
 * @param {String} numeroSerie
 */
function agregarFilaNumeroSerie(tabla, producto, numeroSerie) {
    if(!deluxeTracking) {
        var fila = $('<tr><td>' + numeroSerie + '</td><td><span class="boton eliminar">' + mensaje_eliminar + '</span></td></tr>');
        fila.find('.eliminar').click(function() {
            //Eliminar
            var codigoBorrar = $(this).parent().parent().children('td:first-child').html();
            for(var i=0,len=producto.numerosSerie.length;i<len;i++) {
                if(producto.numerosSerie[i] == codigoBorrar) {
                    producto.numerosSerie.splice(i, 1);
                    $(this).parent().parent().remove();
                    actualizarCantidadTabla(producto);
                    break;
                }
            }
            focoEnInput(lector.inputName);
        });
    }
    else {
        var fila = $('<tr><td>' + numeroSerie + '</td><td></td></tr>');
    }
    tabla.append(fila);
}

/**
 * Elimina el ultimo numero de serie de la tabla.
 * @param {jQuery} tabla
 */
function eliminarFilaNumeroSerie(tabla) {
    tabla.find('tr:last-child').remove();
}

/**
 * Cierra la ventana de manejo de los numeros de serie.
 */
function cerrarDialogoNumeroSerie() {
    procesador = procesadorAnterior;
    focoEnInput(lector.inputName);
    $('#ventanaNumerosSerie').remove();
    $('#fondoOscuroNumerosSerie').remove();
}

/**
 * Abre la ventana de reemplazo de producto.
 * @param {jQuery} fila
 * @param {Object} producto
 */
function abrirDialogoReemplazo(fila, producto) {
    var html = 
            '<div id="ventanaReemplazar" class="ventana">' + 
                '<h3>' + mensaje_cambiar + '</h3>' +
                '<p>' + fila.prev().children('.nombreProducto').html() + '</p>' +
                (typeof producto.reemplazo !== 'undefined' ? '<h3>' + mensaje_por + '</h3><p><span class="contenedorNombre">' + producto.reemplazo.nombre + '</span><input type="button" name="quitarReemplazo" value="X" /></p>' : '') +
                '<p><input type="text" name="reemplazoBuscador" value=""/></p>' +
                '<p id="productosEncontrados"></p>' +
                '<p><span id="cerrar" class="boton">' + mensaje_cerrar + '</span></p>' +
            '</div>';
    
    $('body').append('<div id="fondoOscuro"></div>');
    $('body').append(html);
    
    //Elimina un reemplazo
    $('input[name="quitarReemplazo"]').click(function() {
        delete producto.reemplazo;
        fila.find('.boton.reemplazar').removeClass('reemplazado');
        cerrarDialogoReemplazo();
    });
    
    //Centrar
    $('#ventanaReemplazar').css('left', parseFloat($('body').width())/2 - parseFloat($('#ventanaReemplazar').outerWidth())/2);
    //Controles
    $('#fondoOscuro, #cerrar').click(function() {
        //Cerrar
        cerrarDialogoReemplazo();
    });
    //Buscar productos
    var reemplazoAjax = null;
    $('input[name="reemplazoBuscador"]').keyup(function() {
        if(reemplazoAjax !== null) {
            reemplazoAjax.abort();
        }

        reemplazoAjax = $.getJSON('ajax.php?callback=?', {
            accion: 'buscarProductos',
            texto: $('input[name="reemplazoBuscador"]').val()
        }, function(resultado) {
            if(resultado.ok) {
                var productosEncontrados = [ ];
                for(var i=0,len=resultado.datos.length;i<len;i++) {
                    var iter = resultado.datos[i];
                    productosEncontrados.push(
                            '<div data-id_product="' + iter.id_product + '" data-id_product_attribute="' + iter.id_product_attribute + '" data-identificador="' + iter.identificador + '" class="productoEncontrado">' +
                                '<p class="nombreProducto"><span class="contenedorNombre">' + iter.name + '</span><input type="button" name="seleccionarProducto" value="+"/></p>' +
                            '</div>');
                }

                $('#productosEncontrados').empty();
                if(resultado.datos.length > 0) {
                    $('#productosEncontrados').append(productosEncontrados.join(''));
                    //Seleccionar un producto
                    $('.productoEncontrado input[name="seleccionarProducto"]').click(function() {
                        var contenedor = $(this).parent().parent();
                        var nombre = contenedor.find('.contenedorNombre').html();
                        producto.reemplazo = { nombre: nombre, id_product: contenedor.data('id_product'), 
                            id_product_attribute: contenedor.data('id_product_attribute'), identificador: contenedor.data('identificador') };
                        fila.find('.boton.reemplazar').addClass('reemplazado');
                        cerrarDialogoReemplazo();
                    });
                }
                else {
                    $('#productosEncontrados').append('<p class="centrado">' + mensaje_ninguno_encontrado + '</p>');
                }
            }
        });
    });
}

/**
 * Cierra la ventana de reemplazo de productos.
 */
function cerrarDialogoReemplazo() {
    focoEnInput(lector.inputName);
    $('#ventanaReemplazar').remove();
    $('#fondoOscuro').remove();
}

/**
 * Devuelve el producto correspondiente a la fila.
 * @param {jQuery} fila
 * @returns {Object}
 */
function obtenerProductoPorFila(fila) {
    var ids = fila.attr('id').split('_');
    return productos.get(ids[0], ids[1], ids[2]);
}

/**
 * Devuelve el id compuesto.
 * @param {Object} producto
 * @returns {String}
 */
function obtenerIdCompuesto(producto) {
    return producto.id_order_detail + '_' + producto.id_product + '_' + producto.id_product_attribute;
}

/**
 * Limpia la pantalla al no escoger pedido.
 */
function limpiarPedido() {
    $('#contenedorInfo #fechaPedido').html("");
    $('#contenedorInfo #formaPago').html("");
    $('#contenedorInfo #transportista').html("");
    $('#contenedorInfo #telefono').html("");
    $('#contenedorProductos table tbody').empty();
    $('#contenedorInfoClientes #email').html(mensaje_selecciona);
    $('#contenedorInfoClientes #customer').html("");
    $('#contenedorInfoClientes #telefonoCliente').html("");
    $('#contenedorInfoClientes #direccionEntrega').html("");
    $('#contenedorInfoClientes #transportista').html("");
    $('#contenedorInfoClientes #codPostal').html("");
    $('#contenedorInfoClientes #ciudad').html("");
    $('#contenedorInfoClientes #pais').html("");
    $('#contenedorInfoClientes #idPrestashop').html("");
    $('#contenedorInfoClientes #referenciaAmazon').html("");
    $('#contenedorInfoClientes #sexo').html("");
    $('#contenedorInfoClientes #nota').html("");

    productos.clear();
    actualizarResultadoPedido();
}

/**
 * Realiza la reserva de numeros de serie en el programa de innova deluxe.
 * @param {Object} producto
 * @param {int} cantidad
 * @param {String} lote
 * @param {boolean} ignorarAnteriores Se ignora la comprobación de que el lote es el siguiente a usar.
 */
function reservarNumerosSerie(producto, cantidad, lote, ignorarAnteriores) {
    bloquearPantalla();

    $.getJSON('ajax.php?callback=?', {
        accion: 'reservarLote',
        lote: lote,
        idProducto: producto.id_product,
        idCombinacion: producto.id_product_attribute,
        cantidad: cantidad,
        idPedido: $('select[name="pedidosMontables"]').val(),
        ignorarAnteriores: ignorarAnteriores
    }, function (respuesta) {
        if(respuesta.ok) {
            switch(respuesta.datos[0]) {
                case 0:
                    //Correcto
                    desbloquearPantalla();
                    break;
                
                case 1:
                    if(respuesta.datos[1] === false) {
                        //No hay mas lotes para el producto
                        abrirDialogo(ventana_sinLotes, function() {
                            $('.cerrarVentana').click(function() {
                                cerrarDialogo();
                            });
                        });
                        procesador.eliminarUltimosCodigos(cantidad);
                        actualizarCantidadTabla(producto);
                        desbloquearPantalla();
                    }
                    else {
                        //Se ha solicitado mas cantidad que entradas para ese lote hay disponibles (caso 3)
                        var ventana = ventana_sobraProducto.replace('{unidades}', respuesta.datos[1][0]).replace('{lote}', lote)
                                .replace('{nuevoLote}', (respuesta.datos[1][1] ? respuesta.datos[1][1] : mensaje_noLote));
                        abrirDialogo(ventana, function() {
                            $('.cerrarVentana').click(function() {
                                cerrarDialogo();
                            });
                        });
                        procesador.eliminarUltimosCodigos(respuesta.datos[1][0]);
                        actualizarCantidadTabla(producto);
                        desbloquearPantalla();
                    }
                    break;

                case 2:
                    //Se ha solicitado un lote pero hay otro anterior (caso 2)
                    var ventana = ventana_faltaProducto.replace('{unidades}', respuesta.datos[1][1])
                            .replace('{lote}', respuesta.datos[1][0]);
                    abrirDialogo(ventana, function() {
                        $('#encontrado').click(function() {
                            procesador.eliminarUltimosCodigos(cantidad);
                            actualizarCantidadTabla(producto);
                            desbloquearPantalla();
                            cerrarDialogo();
                        });
                        $('#noEncontrado').click(function() {
                            $('.ventana .boton').off('click').css('opacity', '0.5');
                            marcarMerma(producto, respuesta.datos[1][0], function() {
                                reservarNumerosSerie(producto, cantidad, lote);
                                desbloquearPantalla();
                                cerrarDialogo();
                            });
                        });
                        $('#igonrarAviso').click(function() {
                            $('.ventana .boton').off('click').css('opacity', '0.5');
                            reservarNumerosSerie(producto, cantidad, lote, true);
                            desbloquearPantalla();
                            cerrarDialogo();
                        });
                    });
                    break;

                case 3:
                    //Ha fallado la consulta o la reserva sin motivo concreto
                    abrirDialogo(ventana_error, function() {
                        $('.cerrarVentana').click(function() {
                            cerrarDialogo();
                        });
                    });
                    procesador.eliminarUltimosCodigos(cantidad);
                    actualizarCantidadTabla(producto);
                    desbloquearPantalla();
                    break;
                    
                case 4:
                    //El lote no existe o no es para el producto solicitado
                    abrirDialogo(ventana_inexistente, function() {
                        $('.cerrarVentana').click(function() {
                            cerrarDialogo();
                        });
                    });
                    procesador.eliminarUltimosCodigos(cantidad);
                    actualizarCantidadTabla(producto);
                    desbloquearPantalla();
                    break;
            }
        }
        else {
            //Error con el servidor
            abrirDialogo(ventana_error, function() {
                $('.cerrarVentana').click(function() {
                    cerrarDialogo();
                });
            });
            desbloquearPantalla();
        }
    });
}

/**
 * Marca el lote como disponible.
 * @param {Object} producto
 * @param {String} lote
 * @param {int} cantidad
 * @param {function} callback
 */
function marcarDisponible(producto, lote, cantidad, callback) {
    $.getJSON('ajax.php?callback=?', {
        accion: 'marcarDisponiblePorLote',
        lote: lote,
        idProducto: producto.id_product,
        idCombinacion: producto.id_product_attribute,
        idPedido: $('select[name="pedidosMontables"]').val(),
        cantidad: cantidad
    }, function (respuesta) {
        if(!respuesta.ok || !respuesta.datos) {
            abrirDialogo(ventana_error, function() {
                $('.cerrarVentana').click(function() {
                    cerrarDialogo();
                });
            });
        }
        else if(typeof callback === 'function') {
            callback();
        }
    });
}

/**
 * Marca como merma un lote.
 * @param {Object} producto
 * @param {String} lote
 * @param {function} callback
 */
function marcarMerma(producto, lote, callback) {
    $.getJSON('ajax.php?callback=?', {
        accion: 'marcarMerma',
        lote: lote,
        idProducto: producto.id_product,
        idCombinacion: producto.id_product_attribute,
        idPedido: $('select[name="pedidosMontables"]').val()
    }, function (respuesta) {
        if(!respuesta.ok || !respuesta.datos) {
            abrirDialogo(ventana_error, function() {
                $('.cerrarVentana').click(function() {
                    cerrarDialogo();
                });
            });
        }
        else if(typeof callback === 'function') {
            callback();
        }
    });
}

/**
 * Elimina una fila del pedido.
 * @param {Object} producto
 */
function eliminarFilaPedido(producto) {
    $.getJSON('ajax.php?callback=?', {
        accion: 'eliminarFilaPedido',
        idFilaPedido: producto.id_order_detail
    }, function (respuesta) {
        if(respuesta.ok) {
            productos.remove(producto.id_order_detail, producto.id_product, producto.id_product_attribute);
            $('#' + obtenerIdCompuesto(producto) + '_identificador').next().remove();
            $('#' + obtenerIdCompuesto(producto) + '_identificador').next().remove();
            $('#' + obtenerIdCompuesto(producto) + '_identificador').next().remove();
            $('#' + obtenerIdCompuesto(producto) + '_identificador').remove();
        }
        else {
            mensaje(mensaje_errorEliminarFila, 'error');
        }
    });
}

/**
 * Asigna a una fila la clase seleccionada
 * @param {jQuery} fila
 */
function setSeleccionada(fila) {
    $('.filaProducto').removeClass('seleccionada');
    fila.addClass('seleccionada');
}