/* global lector */

/**
 * Muestra un mensaje en pantalla.
 * @param {string} texto
 * @param {string} clase
 */
function mensaje(texto, clase) {
    var mensaje = $('<div class="alert ' + clase + '">' + texto + '</div>');
    $('body').append(mensaje);
    mensaje.css('left', $(window).width()/2 - mensaje.outerWidth()/2);
    
    mensaje.click(function() {
        mensaje.fadeOut(1000, function() {
            mensaje.remove();
        });
    });
    
    setTimeout(function() {
        mensaje.fadeOut(1000, function() {
            mensaje.remove();
        });
    }, 5000);
}

/**
 * Abre un cuadro de dialogo.
 * @param {String} contenido
 * @param {function} onReady
 */
function abrirDialogo(contenido, onReady) {
    var html = 
            '<div class="ventana">' + 
                contenido +
            '</div>';
    if(!$('#fondoOscuro').length) {
        $('body').append('<div id="fondoOscuro"></div>');
    }
    $('body').append(html);
    
    //Centrar
    $('.ventana').css('left', parseFloat($('body').width())/2 - parseFloat($('.ventana').outerWidth())/2);
    
    if(typeof onReady === 'function') {
        onReady();
    }
}

/**
 * Cierra el cuadro de dialogo.
 */
function cerrarDialogo() {
    focoEnInput(lector.inputName);
    $('.ventana').remove();
    $('#fondoOscuro').remove();
}

/**
 * Bloquea la pantalla para que no se pueda utilizar la pda.
 */
function bloquearPantalla() {
    $('body').append('<div id="fondoBloqueo"></div>');
    lector.detenerCaptacion();
}

/**
 * Permite volver a utilizar la pda.
 */
function desbloquearPantalla() {
    $('#fondoBloqueo').remove();
    lector.iniciarCaptacion();
    focoEnInput(lector.inputName);
}