/**
 * Tarea ejecutable en una cola.
 * @type {Tarea}
 */
class Tarea {
    /**
     * Crea una nueva tarea para la cola.
     * @param {function} ejecutable Se le pasa una instancia de la tarea. Al finalizar debe llamar al metodo finalizada.
     * @returns {Tarea}
     */
    constructor(ejecutable) {
        this.ejecutable = ejecutable;
        this.cola = null;
    }
    
    /**
     * Ejecuta la tarea.
     */
    ejecutar() {
        this.ejecutable(this);
    }
    
    /**
     * Indica que la tarea ha finalizado.
     * Debe llamarse desde el codigo ejecutable.
     */
    finalizada() {
        this.cola.ejecutar();
    }
}