/**
 * Crea y ejecuta colas.
 * @type {GestorColas}
 */
class GestorColas {
    /**
     * Crea un procesador de colas.
     * @returns {GestorColas}
     */
    constructor() {
        this.colas = {};
    }
    
    /**
     * Agrega una nueva tarea, seleccionando la cola por el id.
     * La cola se inicia de inmediato.
     * @param {String} id
     * @param {Tarea} tarea
     */
    agregarTarea(id, tarea) {
        if(typeof this.colas[id] === 'undefined') {
            this.colas[id] = new Cola();
        }
        
        this.colas[id].agregarTarea(tarea);
        this.colas[id].iniciar();
    }
}