/**
 * Cola de tareas ejecutables.
 * @type {Cola}
 */
class Cola {
    /**
     * Crea una cola de tareas.
     * @returns {Cola}
     */
    constructor() {
        this.tareas = [];
        this.iniciado = false;
    }
    
    /**
     * Agrega una tarea para ser ejecutada.
     * @param {Tarea} tarea
     */
    agregarTarea(tarea) {
        this.tareas.push(tarea);
    }
    
    /**
     * Inicia la ejecucion de la cola.
     * Si se vacia es necesario volver a iniciarla. Llamar a iniciar con la cola ejecutandose no produce ningun efecto.
     */
    iniciar() {
        if(!this.iniciado) {
            this.iniciado = true;
            this.ejecutar();
        }
    }
    
    /**
     * Ejecuta la tarea siguiente.
     */
    ejecutar() {
        var tarea = this.tareas.shift();
        if(typeof tarea !== 'undefined') {
            tarea.cola = this;
            tarea.ejecutar();
        }
        else {
            this.iniciado = false;
        }
    }
}