/**
 * Ayuda a manejar la lista de productos.
 * @param {boolean} eanExtendido 
 * @returns {Products}
 */
function Products(eanExtendido) {
    this.products = [];
    this.eanExtendido = eanExtendido;
}

/**
 * Devuelve un producto por sus identificadores.
 * @param {int} id_order_detail
 * @param {int} id_product
 * @param {int} id_product_attribute
 * @returns {Object}
 */
Products.prototype.get = function(id_order_detail, id_product, id_product_attribute) {
    var found = null;
    for(var i=0,len=this.products.length;i<len;i++) {
        var product = this.products[i];
        if(product.id_order_detail == id_order_detail && product.id_product == id_product && product.id_product_attribute == id_product_attribute) {
            found = product;
            break;
        }
    }
    
    return found;
};

/**
 * Devuelve el primer producto con el codigo indicado que no este completo o el ultimo encontrado en caso contrario.
 * @param {String} code
 * @returns {Object}
 */
Products.prototype.getByIdentifier = function(code) {
    var found = null;
    for(var i=0,len=this.products.length;i<len;i++) {
        var product = this.products[i];
        if(this.eanExtendido) {
            if(product.identificador == code || product.identificador == '0' + code || (product.hasOwnProperty('reemplazo') && 
                    (product.reemplazo.identificador == code || product.reemplazo.identificador == '0' + code))) {
                found = product;
                if(product.cantidadActual < product.cantidadNecesaria) {
                    break;
                }
            }
        }
        else if(product.identificador == code || (product.hasOwnProperty('reemplazo') && product.reemplazo.identificador == code)) {
                found = product;
                if(product.cantidadActual < product.cantidadNecesaria) {
                    break;
                }
        } else{
            for (var j in product.eans13) {
                if (product.eans13[j] == code) {
                    found = product;
                    if(product.cantidadActual < product.cantidadNecesaria) {
                        break;
                    }
                }
            }
        }
    }
    
    return found;
};

/**
 * Vacia el objeto.
 */
Products.prototype.clear = function() {
    this.products = [];
};

/**
 * Indica si el objeto esta vacio.
 * @returns {boolean}
 */
Products.prototype.isEmpty = function() {
    return this.products.length === 0;
};

/**
 * Elimina un producto del listado.
 * @param {int} id_order_detail
 * @param {int} id_product
 * @param {int} id_product_attribute
 */
Products.prototype.remove = function(id_order_detail, id_product, id_product_attribute) {
    var pos = -1;
    for(var i=0,len=this.products.length;i<len;i++) {
        var product = this.products[i];
        if(product.id_order_detail == id_order_detail && product.id_product == id_product && product.id_product_attribute == id_product_attribute) {
            pos = i;
            break;
        }
    }
    
    if(pos >= 0) {
        this.products.splice(pos, 1);
    }
};