/**
 * Permite desplazar la pantalla horizontalmente como si fuesen múltiples páginas.
 * @param {string} selectorContenedorPaginas
 * @param {string} selectorPaginas
 * @param {function} callback Se llama al finalizar un desplazamiento.
 */
function DesplazarPaginas(selectorContenedorPaginas, selectorPaginas, callback) {
    var contenedor = $(selectorContenedorPaginas), paginas = $(selectorPaginas), desplazamientoAnterior = 0;

    paginas.css('float', 'left').width($('html').width());
    contenedor.css('position', 'relative').width(paginas.length * paginas.width());

    if(!DesplazarPaginas.isMobile()) {
        contenedor.swipe({
            swipeStatus:function(event, phase, direction, distance, duration, fingerCount) {
                if(phase === 'start') {
                    contenedor.stop();

                    desplazamientoAnterior = 0;
                }
                else if(phase === 'move') {
                    if(direction === 'left') {
                        distance = -distance;
                    }

                    var posIzq = parseFloat(contenedor.offset().left);
                    var nuevaPos = posIzq + distance - desplazamientoAnterior;
                    if(direction === 'right' && nuevaPos > 0) {
                        nuevaPos = 0;
                    }
                    else if(direction === 'left' && Math.abs(nuevaPos) > contenedor.width() - paginas.width()) {
                        nuevaPos = -(contenedor.width() - paginas.width());
                    }

                    contenedor.css('left', nuevaPos);
                    desplazamientoAnterior = distance;
                }
                else if(phase === 'end') {
                    animar();
                }
                else if(phase === 'cancel') {
                    animar();
                }
            }
        });
    }
    else {
        $( window ).on( "orientationchange", function( event ) {
            var texto = '';
            for(var x in event) {
                texto += x + ' -> ' + event[x] + ' | ';
            }
            setTimeout(function() {
                paginas.width($('html').width());
                contenedor.width(paginas.length * paginas.width());
            }, 1000);
        });
    }
}

/**
 * Devuelve el punto más cercano. (solo un eje)
 * @param {number[]} puntos
 * @param {number} puntoActual
 * @returns {number}
 */
DesplazarPaginas.puntoMasCercano = function(puntos, puntoActual) {
    var puntosMayores = [], puntosMenores = [];
    for(var i=0,len=puntos.length;i<len;i++) {
        if(puntos[i] > puntoActual) {
            puntosMayores.push(puntos[i]);
        }
        else {
            if(puntos[i] == puntoActual) {
                return puntoActual;
            }
            else {
                puntosMenores.push(puntos[i]);
            }
        }
    }

    var resultado;
	var puntoAnterior = puntosMenores.reduce(function (p, v) {
		return ( p > v ? p : v );
	});
	var puntoSiguiente = puntosMayores.reduce(function (p, v) {
		return ( p < v ? p : v );
	});

    if(Math.abs(puntoActual - puntoAnterior) < Math.abs(puntoActual - puntoSiguiente)) {
        resultado = puntoAnterior;
    }
    else {
        resultado = puntoSiguiente;
    }

    return resultado;
};

/**
 * Indica si es un móvil.
 * @returns {Boolean}
 */
DesplazarPaginas.isMobile = function() {
    if (navigator.userAgent.match(/Android/i)
            || navigator.userAgent.match(/webOS/i)
            || navigator.userAgent.match(/iPhone/i)
            || navigator.userAgent.match(/iPad/i)
            || navigator.userAgent.match(/iPod/i)
            || navigator.userAgent.match(/BlackBerry/i)
            || navigator.userAgent.match(/Windows Phone/i)
            ) {
        return true;
    }
    else {
        return false;
    }
};

