<?php
/**
 * Devuelve los productos con un formato util para la pda.
 * @param array $productos
 * @param Context $context
 * @param ImaxImprimePedidosServidor $modulo
 * @param int $idPedido
 * @return array
 */
function formatearProductosPedido($productos, $context, $modulo, $idPedido) {
    $image_sizes = ImageType::getImagesTypes();
    $width = 1000;
    $image_type_name = '';
    foreach ($image_sizes AS $image_size) {
        if ($image_size['width'] < $width) {
            $width = $image_size['width'];
            $image_type_name = $image_size['name'];
        }
    }
    $deluxeTracking = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'DELUXE_TRACKING');
    if($deluxeTracking) {
        $conectorTracking = new ConectorDeluxeTracking();
        $lotesPreAsignados = $conectorTracking->cargarReservados($idPedido);
    }
    else {
        $lotesPreAsignados = [];
    }
    $productosSinPicking = json_decode(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'PRODUCTOS_NO_PICKING'));
    $identificadorSalida = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'IDENTIFICADOR_SALIDA');
    foreach ($productos as $clave => $producto) {
        $productoObj = new Product($producto['product_id']);
        $id_image_temp = Product::getCover($producto['product_id']);
        $name = $productoObj->link_rewrite[Configuration::getGlobalValue('PS_LANG_DEFAULT')];
        $ids = $productoObj->id.'-'.(!empty($id_image_temp['id_image']) ? $id_image_temp['id_image'] : 0);
        $type = $image_type_name;

        $not_default = false;
        // legacy mode or default image
        $theme = ((Shop::isFeatureActive() && file_exists(_PS_PROD_IMG_DIR_.$ids.($type ? '-'.$type : '').'-'.(int)Context::getContext()->shop->theme_name.'.jpg')) ? '-'.Context::getContext()->shop->theme_name : '');
        if ((Configuration::get('PS_LEGACY_IMAGES') && (file_exists(_PS_PROD_IMG_DIR_.$ids.($type ? '-'.$type : '').$theme.'.jpg'))) || ($not_default = strpos($ids, 'default') !== false)) {
            if ((int)Configuration::get('PS_REWRITING_SETTINGS') == 1 && !$not_default) {
                $uri_path = $context->shop->getBaseUri().$ids.($type ? '-'.$type : '').$theme.'/'.$name.'.jpg';
            }
            else {
                $uri_path = _THEME_PROD_DIR_.$ids.($type ? '-'.$type : '').$theme.'.jpg';
            }
        }
        else {
            // if ids if of the form id_product-id_image, we want to extract the id_image part
            $split_ids = explode('-', $ids);
            $id_image = (isset($split_ids[1]) ? $split_ids[1] : $split_ids[0]);
            $theme = ((Shop::isFeatureActive() && file_exists(_PS_PROD_IMG_DIR_.Image::getImgFolderStatic($id_image).$id_image.($type ? '-'.$type : '').'-'.(int)Context::getContext()->shop->theme_name.'.jpg')) ? '-'.Context::getContext()->shop->theme_name : '');
            if ((int)Configuration::get('PS_REWRITING_SETTINGS') == 1) {
                $uri_path = $context->shop->getBaseUri().$id_image.($type ? '-'.$type : '').$theme.'/'.$name.'.jpg';
            }
            else {
                $uri_path = _THEME_PROD_DIR_.Image::getImgFolderStatic($id_image).$id_image.($type ? '-'.$type : '').$theme.'.jpg';
            }
        }

        $productos[$clave]['imagen'] = '//'.Tools::getMediaServer($uri_path).$uri_path;

        if($producto['product_attribute_id']) {
            $combinacion = new Combination($producto['product_attribute_id']);
            $productos[$clave]['product_ean13'] = $combinacion->ean13;
            $productos[$clave]['product_reference'] = ($combinacion->reference ? $combinacion->reference : $producto['reference']);
        }
        else {
            $productos[$clave]['product_ean13'] = $productoObj->ean13;
            $productos[$clave]['product_reference'] = ($productoObj->reference ? $productoObj->reference : $producto['reference']);
        }
        //Agregamos el identificador
        $productos[$clave]['identificador'] = seleccionarIdentificador($productos[$clave]);

        //Stock real
        $imax = new ImaxImprimePedidosServidor();
        if(Module::isEnabled('imaxmultialmacen')){
            $opcionAlmacen = $imax->cargarOpcionAlmacen($producto['product_id'], $producto['product_attribute_id']);
            if($opcionAlmacen['almacenSalidaPorDefecto']){
                $productos[$clave]['ubicacion'] = Warehouse::getWarehouseNameById($opcionAlmacen['almacenSalidaPorDefecto']);
                $cantidad = $imax->getStock($producto['product_id'], $producto['product_attribute_id'], $opcionAlmacen['almacenSalidaPorDefecto']);
                if(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'USAR_CANTIDAD_FISICA_PDA')) {
                    $productos[$clave]['stockReal'] = (int)$cantidad['physical_quantity'];
                }
                else{
                    $productos[$clave]['stockReal'] = (int)$cantidad['quantity'];
                }
            }
            else {
                $productos[$clave]['ubicacion'] = '-';
                $productos[$clave]['stockReal'] = 0;
            }
        }
        else{
            $ubicacion = $imax->cargarExtraProducto($productoObj->id, (int)$producto['product_attribute_id']);
            $productos[$clave]['ubicacion'] = ($ubicacion ? $ubicacion['ubicacion'] : '');
            
            if(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'USAR_CANTIDAD_FISICA_PDA')) {
                $id_product = (int)$productoObj->id;
                $id_product_attribute = (int)$producto['product_attribute_id'];
                $cantidades = Db::getInstance()->getRow('SELECT * FROM `'._DB_PREFIX_."stock_available` WHERE id_product = $id_product 
                    AND id_product_attribute = $id_product_attribute");
                $productos[$clave]['stockReal'] = ($cantidades ? $cantidades['quantity'] + $cantidades['reserved_quantity'] : 0);
            }
            else {
                $productos[$clave]['stockReal'] = StockAvailable::getQuantityAvailableByProduct($productoObj->id, $producto['product_attribute_id']);
            }
        }
        
        //Usa numero de serie
        if(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'ACT_NOM_SER')) {
            $productos[$clave]['usaNumeroSerie'] = true;
        }
        else {
            $productos[$clave]['usaNumeroSerie'] = $modulo->productoTieneNumerosSerie($productoObj->id);
            if($deluxeTracking && !$productos[$clave]['usaNumeroSerie']) {
                $productos[$clave]['usaNumeroSerie'] = $conectorTracking->usaLotes($producto['product_id'], $producto['product_attribute_id']);
            }
        }
        
        //Fabricante
        $fabricante = new Manufacturer($productoObj->id_manufacturer, $context->language->id);
        $productos[$clave]['fabricante'] = $fabricante->name;
        

        //Con stock
        $productos[$clave]['conStock'] = ((isset($producto['product_quantity_in_stock']) && $producto['product_quantity_in_stock'] >= 0) || $productos[$clave]['stockReal'] >= $producto['product_quantity']);
        
        //Observaciones
        $productos[$clave]['observaciones'] = (isset($productoObj->observacion[$modulo->idLang]) ? $productoObj->observacion[$modulo->idLang] : '');

        //Componentes del pack
        $productos[$clave]['componentes'] = array();
        if(isPack($productoObj->id)) {
            $datosComponentes = getItemTable($productoObj->id, $context->language->id);
            foreach($datosComponentes as &$datosComponente) {
                $datosComponente['product_id'] = $datosComponente['id_product'];
                $datosComponente['product_attribute_id'] = $datosComponente['id_product_attribute_item'];
                $datosComponente['product_name'] = $datosComponente['name'];
                $datosComponente['product_ean13'] = $datosComponente['ean13'];
                $datosComponente['product_reference'] = $datosComponente['reference'];
                $datosComponente['product_quantity'] = $datosComponente['pack_quantity'] * $productos[$clave]['product_quantity'];
                $datosComponente['id_order_detail'] = $productos[$clave]['id_order_detail'];
            }

            $productos[$clave]['componentes'] = formatearProductosPedido($datosComponentes, $context, new ImaxImprimePedidosServidor(), $idPedido);
        }
        
        $productos[$clave]['numerosSerie'] = [];
        $productos[$clave]['cantidadActual'] = 0;
        if($deluxeTracking && !empty($lotesPreAsignados[(int)$productos[$clave]['product_id']][(int)$productos[$clave]['product_attribute_id']])) {
            //Lotes ya asignados
            $productos[$clave]['numerosSerie'] = $lotesPreAsignados[(int)$productos[$clave]['product_id']][(int)$productos[$clave]['product_attribute_id']];
            $productos[$clave]['cantidadActual'] = count($lotesPreAsignados[(int)$productos[$clave]['product_id']][(int)$productos[$clave]['product_attribute_id']]);
        }
        elseif(in_array($productos[$clave]['product_id'], $productosSinPicking)) {
            //Productos no picking
            $productos[$clave]['cantidadActual'] = $productos[$clave]['product_quantity'];
        }
        $productos[$clave]['eans13'] = array();
        
        if (Module::isEnabled('imaxmultiean') && $identificadorSalida != ImaxImprimePedidosServidor::IDENTIFICADOR_REFERENCIA) {
            $module = Module::getInstanceByName('imaxmultiean');
            $productos[$clave]['eans13'] = array_column($module->getFunciones()->getEANs($producto['product_id'], $producto['product_attribute_id']), 'ean13');
        }
    }
    
    //Ordenamos por ubicacion
    // usort($productos, function($a, $b) {
    //     return strcmp($a['ubicacion'], $b['ubicacion']);
    // });

    return $productos;
}

/**
 * Indica si un producto es un pack.
 * @param int $id_product
 * @return boolean
 */
function isPack($id_product) {
    return (boolean)Db::getInstance()->getValue('SELECT 1 FROM `' . _DB_PREFIX_ . 'pack` WHERE id_product_pack = ' . (int) $id_product);
}

/**
 * Devuelve informacion de los componentes de un pack sin depender de la tienda.
 * @param int $id_product
 * @param int $id_lang
 * @return array
 */
function getItemTable($id_product, $id_lang) {
    $sql = 'SELECT p.*, pl.*, image.`id_image` id_image, il.`legend`, cl.`name` AS category_default, a.quantity AS pack_quantity, a.id_product_pack, a.id_product_attribute_item
            FROM `' . _DB_PREFIX_ . 'pack` a
            LEFT JOIN `' . _DB_PREFIX_ . 'product` p ON p.id_product = a.id_product_item
            LEFT JOIN `' . _DB_PREFIX_ . 'product_lang` pl
                ON p.id_product = pl.id_product
                AND pl.`id_lang` = ' . (int) $id_lang . '
            LEFT JOIN `' . _DB_PREFIX_ . 'image` image
                ON (image.`id_product` = p.`id_product` AND image.cover=1)
            LEFT JOIN `' . _DB_PREFIX_ . 'image_lang` il ON (image.`id_image` = il.`id_image` AND il.`id_lang` = ' . (int) $id_lang . ')
            LEFT JOIN `' . _DB_PREFIX_ . 'category_lang` cl
                ON p.`id_category_default` = cl.`id_category`
                AND cl.`id_lang` = ' . (int) $id_lang . '
            WHERE a.`id_product_pack` = ' . (int) $id_product . '
            GROUP BY a.`id_product_item`, a.`id_product_attribute_item`';

    $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

    foreach ($result as &$line) {
        if (Combination::isFeatureActive() && isset($line['id_product_attribute_item']) && $line['id_product_attribute_item']) {
            $line['cache_default_attribute'] = $line['id_product_attribute'] = $line['id_product_attribute_item'];

            $sql = 'SELECT agl.`name` AS group_name, al.`name` AS attribute_name,  pai.`id_image` AS id_product_attribute_image
            FROM `' . _DB_PREFIX_ . 'product_attribute` pa
            ' . Shop::addSqlAssociation('product_attribute', 'pa') . '
            LEFT JOIN `' . _DB_PREFIX_ . 'product_attribute_combination` pac ON pac.`id_product_attribute` = ' . $line['id_product_attribute_item'] . '
            LEFT JOIN `' . _DB_PREFIX_ . 'attribute` a ON a.`id_attribute` = pac.`id_attribute`
            LEFT JOIN `' . _DB_PREFIX_ . 'attribute_group` ag ON ag.`id_attribute_group` = a.`id_attribute_group`
            LEFT JOIN `' . _DB_PREFIX_ . 'attribute_lang` al ON (a.`id_attribute` = al.`id_attribute` AND al.`id_lang` = ' . (int) Context::getContext()->language->id . ')
            LEFT JOIN `' . _DB_PREFIX_ . 'attribute_group_lang` agl ON (ag.`id_attribute_group` = agl.`id_attribute_group` AND agl.`id_lang` = ' . (int) Context::getContext()->language->id . ')
            LEFT JOIN `' . _DB_PREFIX_ . 'product_attribute_image` pai ON (' . $line['id_product_attribute_item'] . ' = pai.`id_product_attribute`)
            WHERE pa.`id_product` = ' . (int) $line['id_product'] . ' AND pa.`id_product_attribute` = ' . $line['id_product_attribute_item'] . '
            GROUP BY pa.`id_product_attribute`, ag.`id_attribute_group`
            ORDER BY pa.`id_product_attribute`';

            $attr_name = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

            if (isset($attr_name[0]['id_product_attribute_image']) && $attr_name[0]['id_product_attribute_image']) {
                $line['id_image'] = $attr_name[0]['id_product_attribute_image'];
            }
            $line['name'] .= "\n";
            foreach ($attr_name as $value) {
                $line['name'] .= ' ' . $value['group_name'] . '-' . $value['attribute_name'];
            }
        }
        $line = Product::getTaxesInformations($line);
    }

    return $result;
}

/**
 * Devuelve el identificador del producto.
 * @param array $producto
 * @return string
 */
function seleccionarIdentificador($producto) {
    $identificador = '';
    switch(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'IDENTIFICADOR_SALIDA')) {
        case ImaxImprimePedidosServidor::IDENTIFICADOR_EAN13:
            $identificador = $producto['product_ean13'];
            break;

        case ImaxImprimePedidosServidor::IDENTIFICADOR_REFERENCIA:
            $identificador = $producto['product_reference'];
            break;
        
        case ImaxImprimePedidosServidor::IDENTIFICADOR_REFERENCIA_EAN13:
            $identificador = $producto['product_reference'];
            if(!$identificador){
                $identificador = $producto['product_ean13'];
            }
            break;
    }
    if(!$identificador) {
        $identificador = $producto['product_id'].'-'.(int)$producto['product_attribute_id'].'-ids';
    }
    
    return $identificador;
}

/**
 * Devuelve el html de una vista.
 * @param string $archivo
 * @param ImaxImprimePedidosServidor $modulo
 * @return string
 */
function cargarVista($archivo, $modulo) {
    ob_start();
    require 'vistas/'.basename($archivo);
    return ob_get_clean();
}

/**
 * Bloquea un pedido 
 * @param int $idPedido
 * @param string $uniq Identificador adicional para distinguir entre un mismo empleado en dos dispositivos distintos.
 * @return boolean
 */
function bloquear($idPedido, &$uniq){
    $result = false;
    $context = Context::getContext();
    //Borramos el bloqueo actual
    $uniqSql = pSQL($uniq);
    Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . "bloqueoPedido` 
        WHERE idEmpleado = {$context->employee->id} AND uniq = '$uniqSql' AND idTipoPedido = " . ImaxImprimePedidosServidor::TIPO_PEDIDO_SALIDA);
    if(!$uniq) {
        //Generamos un nuevo uniq
        $uniq = uniqid('', true);
    }
    if ($idPedido) {
        $bloqueado = (boolean)Db::getInstance()->getValue('SELECT 1 FROM `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . "bloqueoPedido` 
            WHERE idPedido = $idPedido AND NOW() - acceso < 120 AND idTipoPedido = " . ImaxImprimePedidosServidor::TIPO_PEDIDO_SALIDA);
        if(!$bloqueado) {
            $uniqSql = pSQL($uniq);
            $result = Db::getInstance()->execute('REPLACE INTO `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . "bloqueoPedido` 
                (idPedido, idTipoPedido, idEmpleado, uniq) 
                VALUES ($idPedido, " . ImaxImprimePedidosServidor::TIPO_PEDIDO_SALIDA . ", {$context->employee->id}, '$uniqSql')");
        }
    }
    return $result;
}

/**
 * Graba en el log.
 * @param int $id_order
 * @param int $id_employee
 * @param string $uniq
 * @param string $concepto
 * @return boolean
 */
function loguear($id_order, $id_employee, $uniq, $concepto) {
    $id_order = (int)$id_order;
    $id_employee = (int)$id_employee;
    $uniq = pSQL($uniq);
    $concepto = pSQL($concepto);
    return Db::getInstance()->execute('INSERT INTO `'._DB_PREFIX_."imaxLog` (id_order, id_employee, uniq, concepto) 
        VALUES ($id_order, $id_employee, '$uniq', '$concepto')");
}

/**
 * Indica si el pedido está finalizado.
 * @param int $idPedido
 * @return boolean 
 */
function estaFinalizado($idPedido) {
    return (boolean)Db::getInstance()->getValue('SELECT 1 FROM `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . "procesadoPedido` 
        WHERE fechaFin IS NOT NULL AND idPedido = $idPedido");
}
