<?php 

use PrestaShop\PrestaShop\Adapter\SymfonyContainer;

include(__DIR__.'/funciones/back.php');
define('_PS_ADMIN_DIR_', getAdminDir());
include_once(dirname(__FILE__) . '/../../../config/config.inc.php');
if(version_compare(_PS_VERSION_, '1.7.0.0 ', '>=') && !class_exists('AppKernel')) {
    require_once __DIR__.'/../../../app/AppKernel.php';
}

include_once(dirname(__FILE__) . '/../imaximprimepedidosservidor.php');
include_once __DIR__.'/../clases/ConectorDeluxeTracking.php';
include_once __DIR__.'/../clases/IntermediarioDeluxeTracking.php';
include_once(dirname(__FILE__) . '/funciones/funciones.php');

$context = Context::getContext();
$context->shop->setUrl();
$context->controller = new AdminController();
if(version_compare(_PS_VERSION_, '1.7.0.0 ', '>=')) {
    //Inicializamos el kernel
    global $kernel;
    $kernel = new AppKernel(_PS_MODE_DEV_ ? 'dev' : 'prod', _PS_MODE_DEV_ ? true : false);
    $kernel->boot();
    $context->container = SymfonyContainer::getInstance();
}

$resultado['ok'] = false;
$resultado['datos'] = array();
//Comprobamos logueo
if (!empty($context->employee->id) && $context->employee->isLoggedBack()) {
    switch (Tools::getValue('accion')) {
        case 'obtenerListaPedidos':
            $modulo = new ImaxImprimePedidosServidor();
            $empleadoActual = Context::getContext()->employee;
            
            $fechaInicioString = '';
            $fechaInicio = Tools::getValue('fechaDesde', '');
            $fechaFinString = '';
            $fechaFin = Tools::getValue('fechaHasta', '');
            $formaPagoSeleccionadaString = '';
            $formaPagoSeleccionada = Tools::getValue('formaPagoVisible', '');
            $transportistaSeleccionadoString = '';
            $transportistaSeleccionado = Tools::getValue('transportistaVisible', '');
            $estadoPedidoSeleccionadoString = '';
            $estadoPedidoSeleccionado = Tools::getValue('estadoVisible', '');
            if(Tools::getValue('modoSinTerminar', false)) {
                $tablaEstadosString = 'INNER JOIN `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . 'pedidoPendiente` ppen ON o3.id_order = ppen.id_order ';
                $whereSinTerminar = '';
            }
            else {
                $tablaEstadosString = '
                    INNER JOIN `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . "estadoMontable` em3 ON o3.current_state = em3.idEstadoPedido AND em3.id_employee = '$empleadoActual->id'
                    LEFT JOIN `" . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . 'pedidoPendiente` ppen ON o3.id_order = ppen.id_order ';
                $whereSinTerminar = "AND (ppen.id_order IS NULL || ppen.id_employee = '$empleadoActual->id')";
            }
            
            //Limitaciones de empleado
            $todosEmpleadosPDA = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'TODOS_EMPLEADOS_PDA');
            $limitacionesEmpleado = $modulo->obtenerDatosExtraEmpleado($empleadoActual->id);
            $limitacionesEmpleadoString = '';
            $proveedoresEmpleadoString = '';
            if(!$todosEmpleadosPDA) {
                if(!$limitacionesEmpleado || !$limitacionesEmpleado['formasPago'] || !$limitacionesEmpleado['proveedores']) {
                    $limitacionesEmpleadoString = 'AND 1 != 1';
                }
                else {
                    $formasPagoEmpleado = '';
                    foreach($limitacionesEmpleado['formasPago'] as $formaPagoEmpleado) {
                        $formasPagoEmpleado .= '"'.pSQL($formaPagoEmpleado).'",';
                    }
                    $formasPagoEmpleado = substr($formasPagoEmpleado, 0, -1);

                    $limitacionesEmpleadoString = "AND o3.module IN ($formasPagoEmpleado)";
                    
                    $proveedoresEmpleado = '';
                    foreach($limitacionesEmpleado['proveedores'] as $proveedorEmpleado) {
                        $proveedoresEmpleado .= (int)$proveedorEmpleado.',';
                    }
                    $proveedoresEmpleado = substr($proveedoresEmpleado, 0, -1);
                    $proveedoresEmpleadoString = "AND o3.id_order in (select id_order from ps_order_detail od inner join ps_product p on od.product_id = p.id_product where p.id_supplier in ($proveedoresEmpleado))";
                }
            }

            //Cargamos los pedidos montables
            if ($fechaInicio) {
                $trozosInicio = explode('/', $fechaInicio);
                $fechaInicioString = "date(o3.date_add) >= '$trozosInicio[2]-$trozosInicio[1]-$trozosInicio[0]'";
            }
            if ($fechaFin) {
                $trozosFin = explode('/', $fechaFin);
                $fechaFinString = ($fechaInicioString ? 'AND ' : '') . "date(o3.date_add) <= '$trozosFin[2]-$trozosFin[1]-$trozosFin[0]'";
            }
            if($formaPagoSeleccionada) {
                $formaPagoSeleccionada = pSQL($formaPagoSeleccionada);
                $formaPagoSeleccionadaString = "AND o3.module = '$formaPagoSeleccionada'";
            }
            if($transportistaSeleccionado) {
                $transportistaSeleccionado = (int)$transportistaSeleccionado;
                $transportistaSeleccionadoString = "AND c.id_reference = $transportistaSeleccionado";
            }
            if($estadoPedidoSeleccionado) {
                $estadoPedidoSeleccionado = (int)$estadoPedidoSeleccionado;
                $estadoPedidoSeleccionadoString = "AND o3.current_state = $estadoPedidoSeleccionado";
            }
            
            //Quitar los pedidos sin stock suficiente
            $noPedidosSinStockPDA = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'NO_PEDIDOS_SIN_STOCK_PDA');
            if($noPedidosSinStockPDA) {
                $noPedidosSinStockPDAString = 'and conStock = 1';
            }
            else {
                $noPedidosSinStockPDAString = '';
            }
            
            //Orden de los pedidos
            $tipoOrden = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'ORDENACION_PEDIDOS_POR_PDA');            
            $orden = pSQL(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'ORDENACION_PEDIDOS_PDA'));

            $pedidos = Db::getInstance()->executeS('
                SELECT o3.id_order, o3.reference, o3.id_customer, o3.id_shop, o3.id_address_delivery,
                    IFNULL((SELECT COUNT(m.id_message) FROM `' . _DB_PREFIX_ . 'message` m 
                        WHERE m.id_order = o3.id_order AND m.private = 1 AND (m.id_employee IS NOT NULL AND m.id_employee != 0)
                        GROUP BY m.id_order), 0) AS privados,
                    IFNULL((SELECT COUNT(m2.id_message) FROM  `' . _DB_PREFIX_ . 'message` m2 
                        WHERE m2.id_order = o3.id_order AND m2.private = 0 
                        GROUP BY m2.id_order),0) AS publicos,
                    SUM(COALESCE(pp3.fechaFin, 0)) as cerrado,
                    BIT_AND(IF (sa.quantity >= od.product_quantity OR od.product_quantity_in_stock >= 0, 1, 0)) conStock
                FROM ' . _DB_PREFIX_ . 'orders AS o3
                    '.$tablaEstadosString.'
                    INNER JOIN `' . _DB_PREFIX_ .'order_detail` od ON od.id_order = o3.id_order
                    LEFT JOIN `' . _DB_PREFIX_ .'stock_available` sa ON od.product_id = sa.id_product AND od.product_attribute_id = sa.id_product_attribute
                    LEFT JOIN `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . 'procesadoPedido` pp3 ON pp3.idPedido = o3.id_order
                    LEFT JOIN `' . _DB_PREFIX_ .'carrier` c ON o3.id_carrier = c.id_carrier
                    WHERE 1=1 ' . 
                        $whereSinTerminar . ' ' .
                        $estadoPedidoSeleccionadoString . ' ' .
                        ($fechaInicioString || $fechaFinString ? "AND $fechaInicioString $fechaFinString" : '') . ' ' .
                        $limitacionesEmpleadoString . ' ' .
                        $proveedoresEmpleadoString . ' ' .
                        $formaPagoSeleccionadaString . ' ' .
                        $transportistaSeleccionadoString . '
                    GROUP BY o3.id_order
                    HAVING cerrado = 0 '.$noPedidosSinStockPDAString.' 
                    ORDER BY '. $tipoOrden .' ' .$orden);
            
            //Contamos tambien los mensajes de CustomeThread y agregamos el texto identificativo de la tienda
            $textoTiendasPDA = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'TEXTO_TIENDAS_PDA'));
            foreach($pedidos as &$pedido) {
                $publicos = CustomerMessage::getTotalCustomerMessages("id_customer = '{$pedido['id_customer']}' AND id_order = '{$pedido['id_order']}' AND private = 0");
                $pedido['publicos'] += $publicos;
                $privados = CustomerMessage::getTotalCustomerMessages("id_customer = '{$pedido['id_customer']}' AND id_order = '{$pedido['id_order']}' AND private = 1");
                $pedido['privados'] += $privados;
                
                $pedido['textoTienda'] = (isset($textoTiendasPDA[$pedido['id_shop']]) ? $textoTiendasPDA[$pedido['id_shop']] : '');
                $pedido['id_zone'] = Address::getZoneById($pedido['id_address_delivery']);
                
                //Reducimos la cantidad de datos por rendimiento
                unset($pedido['id_shop']);
                unset($pedido['id_customer']);
                unset($pedido['id_address_delivery']);
            }

            //Cargamos los bloqueos
            $uniq = pSQL(trim(Tools::getValue('uniq')));
            $bloqueos = Db::getInstance()->executeS('SELECT * FROM `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . "bloqueoPedido` 
                WHERE (idEmpleado != {$context->employee->id} OR uniq != '$uniq') AND NOW() - acceso < 120 AND idTipoPedido = " . ImaxImprimePedidosServidor::TIPO_PEDIDO_SALIDA);
            
            $resultado['ok'] = true;
            $resultado['datos']['pedidos'] = $pedidos;
            $resultado['datos']['bloqueos'] = $bloqueos;
            break;

        case 'bloquear':
            $idPedido = (int) Tools::getValue('idPedido');
            $uniq = trim(Tools::getValue('uniq'));
            bloquear($idPedido, $uniq);
            $resultado['ok'] = true;
            $resultado['datos']['uniq'] = $uniq;
            break;

        case 'cargarPedido':
            $idPedido = (int) Tools::getValue('idPedido');
            $uniq = trim(Tools::getValue('uniq'));
            if ($idPedido) {
                $bloqueado = bloquear($idPedido, $uniq);
                if(!$bloqueado || estaFinalizado($idPedido)) {
                    $resultado['ok'] = false;
                    $resultado['msg'] = 1;
                }
                else {
                    $pedido = new Order($idPedido);
                    $customer = new Customer($pedido->id_customer);

                    $genero = new Gender($customer->id_gender, $context->employee->id_lang);
                    $sexo = 'No definido';
                    if ($genero->id_gender) {
                        $sexo = $genero->name;
                    }

                    $productos = array_filter($pedido->getProducts(), function($producto) {
                        return $producto['product_quantity'] > 0;
                    });
                    $productos = formatearProductosPedido($productos, $context, new ImaxImprimePedidosServidor(), $pedido->id);

                    $nameCustomer = $customer->firstname . '  ' . $customer->lastname;
                    $mailCustomer = $customer->email;
                    $nota = $customer->note;

                    Db::getInstance()->execute('REPLACE INTO `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . "procesadoPedido` (idPedido, idEmpleado) VALUES ($idPedido, {$context->employee->id})");

                    $formaPago = Module::getInstanceByName($pedido->module);
                    if (Validate::isLoadedObject($formaPago)) {
                        $nombreFormaPago = $formaPago->displayName;
                    } else {
                        $nombreFormaPago = $pedido->payment;
                    }

                    $transportista = new Carrier($pedido->id_carrier);
                    if (Validate::isLoadedObject($transportista)) {
                        $nombreTransportista = $transportista->name;
                    } else {
                        $nombreTransportista = '';
                    }

                    $direccionFactura = new Address($pedido->id_address_invoice);
                    $direccionEntrega = $direccionFactura->address1;
                    $codigoPostal = $direccionFactura->postcode;
                    $ciudad = $direccionFactura->city;
                    $pais = $direccionFactura->country;

                    $telefono = ($direccionFactura->phone_mobile ? $direccionFactura->phone_mobile : $direccionFactura->phone);

                    $resultado['ok'] = true;
                    $resultado['datos']['productos'] = $productos;
                    $resultado['datos']['customer'] = $nameCustomer;
                    $resultado['datos']['sexo'] = $sexo;
                    $resultado['datos']['nota'] = $nota;
                    $resultado['datos']['email'] = $mailCustomer;
                    $resultado['datos']['direccionEntrega'] = $direccionEntrega;
                    $resultado['datos']['codPostal'] = $codigoPostal;
                    $resultado['datos']['ciudad'] = $ciudad;
                    $resultado['datos']['pais'] = $pais;
                    $resultado['datos']['formaPago'] = $nombreFormaPago;
                    $resultado['datos']['transportista'] = $nombreTransportista;
                    $resultado['datos']['fechaCreacion'] = date('d/m/Y', strtotime($pedido->date_add));
                    $resultado['datos']['mensajes'] = array_merge(Message::getMessagesByOrderId($idPedido, true), CustomerThread::getCustomerMessages($pedido->id_customer, null, $pedido->id));
                    $resultado['datos']['telefono'] = $telefono;
                    $resultado['datos']['empaquetado'] = $pedido->gift;
                    $resultado['datos']['empaquetadoMensaje'] = $pedido->gift_message;
                    $resultado['datos']['idPrestashop'] = $pedido->id;
                    $resultado['datos']['referencia'] = $pedido->reference;
                    if(Module::isEnabled('amazon')){
                        $resultado['datos']['referenciaAmazon'] = Db::getInstance()->getValue('Select mp_order_id from '._DB_PREFIX_.'marketplace_orders where id_order = ' . $pedido->id);
                    }
                }
            }
            $resultado['datos']['uniq'] = $uniq;
            break;

        case 'agregarMensaje':
            $idPedido = (int) Tools::getValue('idPedido');
            $mensaje = trim(Tools::getValue('mensaje'));
            $privado = (boolean) Tools::getValue('privado');
            if ($idPedido && $mensaje) {
                try {
                    $order = new Order($idPedido);
                    $customer = new Customer($order->id_customer);
                    
                    $id_customer_thread = CustomerThread::getIdCustomerThreadByEmailAndIdOrder($customer->email, $order->id);
                    if (!$id_customer_thread) {
                        $customer_thread = new CustomerThread();
                        $customer_thread->id_contact = 0;
                        $customer_thread->id_customer = (int) $order->id_customer;
                        $customer_thread->id_shop = (int) $context->shop->id;
                        $customer_thread->id_order = (int) $order->id;
                        $customer_thread->id_lang = (int) $context->language->id;
                        $customer_thread->email = $customer->email;
                        $customer_thread->status = 'open';
                        $customer_thread->token = Tools::passwdGen(12);
                        $customer_thread->add();
                    } else {
                        $customer_thread = new CustomerThread((int) $id_customer_thread);
                    }

                    $customer_message = new CustomerMessage();
                    $customer_message->id_customer_thread = $customer_thread->id;
                    $customer_message->id_employee = (int) $context->employee->id;
                    $customer_message->message = $mensaje;
                    $customer_message->private = $privado;
                    $resultado['ok'] = $customer_message->add();
                    
                    if (!$privado) {
                        $varsTpl = array(
                            '{lastname}' => $customer->lastname,
                            '{firstname}' => $customer->firstname,
                            '{id_order}' => $order->id,
                            '{order_name}' => $order->getUniqReference(),
                            '{message}' => $mensaje
                        );
                        @Mail::Send((int) $order->id_lang, 'order_merchant_comment', Mail::l('New message regarding your order', (int) $order->id_lang), $varsTpl, $customer->email, $customer->firstname . ' ' . $customer->lastname, null, null, null, null, _PS_MAIL_DIR_, true, (int) $order->id_shop);
                    }
                } catch (Exception $ex) {
                    
                }
            }
            break;

        case 'finalizar':
            $idPedido = (int) Tools::getValue('idPedido');
            $opcionesFinalizar = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'OPCIONES_FINALIZAR'));
            $aspectoAlternativo = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'ASPECTO_ALTERNATIVO_PDA');
            if($aspectoAlternativo){
                $imprimirEtiqueta = in_array(0, $opcionesFinalizar) ? 1 : 0;
                $imprimirPedido = in_array(1, $opcionesFinalizar) ? 1 : 0;
                $imprimirFactura = in_array(2, $opcionesFinalizar) ? 1 : 0;
                if(empty($opcionesFinalizar)){
                    $imprimir = false;   
                }else{
                    $imprimir = true;
                }
            }else{
                $imprimir = Tools::getValue('imprimir');
                $imprimirEtiqueta = 1;
                $imprimirPedido = 0;
                $imprimirFactura = 0;
            } 
            $bultos = (int)Tools::getValue('bultos', 1);
            $productos = Tools::getValue('productos');
            if ($idPedido) {
                try {
                    //NOTA: La columna bultos de esta tabla ya no se utiliza.
                    $resultado['ok'] = Db::getInstance()->execute('
                        UPDATE `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . "procesadoPedido` 
                            SET fechaFin = NOW(), bultos = $bultos WHERE idPedido = $idPedido AND idEmpleado = {$context->employee->id}") &
                        (!$imprimir || Db::getInstance()->execute("
                            INSERT INTO `" . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . "imprimirEtiqueta` (idPedido, etiqueta, pedido, factura)
                                VALUES ($idPedido, $imprimirEtiqueta , $imprimirPedido, $imprimirFactura)
                            ON DUPLICATE KEY UPDATE 
                                etiqueta = VALUES(etiqueta),
                                pedido = VALUES(pedido),
                                factura = VALUES(factura)")
                        );

                    if ($resultado['ok']) {
                        $modulo = new ImaxImprimePedidosServidor();
                        
                        $modulo->insertarBultosManuales($idPedido, $bultos);
                        
                        $filasServidas = array();
                        $filasPack = array();
                        foreach($productos as $producto) {
                            //Grabamos los numeros de serie
                            if(!empty($producto['numerosSerie'])) {
                                foreach($producto['numerosSerie'] as $i => $numeroSerie) {
                                    $modulo->guardarNumeroSerie($idPedido, $producto['id_order_detail'], $producto['id_product'], 
                                            $producto['id_product_attribute'], $i, $numeroSerie);
                                }
                            }
                            //Grabamos los reemplazos
                            if(!empty($producto['reemplazo'])) {
                                $modulo->guardarReemplazo($idPedido, $producto['id_order_detail'], $producto['id_product'], 
                                            $producto['id_product_attribute'], $producto['reemplazo']['id_product'], $producto['reemplazo']['id_product_attribute']);
                                if(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'AJUSTAR_REEMPLAZAR_PDA')) {
                                    //Reajustamos el stock
                                    StockAvailable::updateQuantity($producto['id_product'], $producto['id_product_attribute'], 
                                            $producto['cantidadNecesaria']);
                                    StockAvailable::updateQuantity($producto['reemplazo']['id_product'], 
                                            $producto['reemplazo']['id_product_attribute'], -$producto['cantidadNecesaria']);
                                }
                            }
                            
                            //Preprocesamos las filas servidas
                            if(!isset($filasServidas[$producto['id_product']][$producto['id_product_attribute']])) {
                                $filasServidas[$producto['id_product']][$producto['id_product_attribute']] = array(
                                    'cantidadNecesaria' => 0, 'cantidadActual' => 0);
                            }
                            $filasServidas[$producto['id_product']][$producto['id_product_attribute']]['cantidadNecesaria'] += $producto['cantidadNecesaria'];
                            $filasServidas[$producto['id_product']][$producto['id_product_attribute']]['cantidadActual'] += $producto['cantidadActual'];
                            
                            $filas[$producto['id_order_detail']]['restante'][$producto['id_product']][$producto['id_product_attribute']] = $producto['cantidadNecesaria'] - $producto['cantidadActual']; 
                            $filas[$producto['id_order_detail']]['idPack'] = $producto['idPack'];
                        }

                        //Almacenamos el material servido
                        foreach($filasServidas as $id_product => $filaServidaTemp) {
                            foreach($filaServidaTemp as $id_product_attribute => $filaServida) {
                                $id_product = (int)$id_product;
                                $id_product_attribute = (int)$id_product_attribute;
                                $cantidadNecesaria = (int)$filaServida['cantidadNecesaria'];
                                $cantidadActual = (int)$filaServida['cantidadActual'];
                                
                                Db::getInstance()->execute('
                                    REPLACE INTO `'. _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . "servido` (idPedido, idProducto, idCombinacion, cantidadNecesaria, cantidadServida) 
                                        VALUES ('$idPedido', '$id_product', '$id_product_attribute', '$cantidadNecesaria', '$cantidadActual')");
                            }
                        }

                        $pedido = new Order($idPedido);
                        //Devolvemos lo no enviado y generamos un nuevo pedido de ser necesario
                        if(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'FINALIZAR_INCOMPLETOS') && Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'PEDIDOS_INCOMPLETOS')) {
                            if($modulo->ajustarPedidoIncompleto($pedido, $filas)) {
                                $resultado['ok'] = false;
                            }
                        }

                        if(!$imprimir) { //Si se va a imprimir cambiamos el estado en el momento de sacar la etiqueta
                            //Cambiamos el estado del pedido
                            $estado_cambio = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'ESTADO_MONTADO');
                            $modulo->cambiarEstado($pedido, $estado_cambio, true);
                        }
                        
                        //Lo quitamos de pendiente
                        Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."pedidoPendiente` 
                            WHERE id_order = '$idPedido'");
                        
                        //Insertamos los movimientos necesarios
                        if(Module::isEnabled('imaxmultialmacen') && Module::isEnabled('gestavdstock')) {
                            $multi = Module::getInstanceByName('imaxmultialmacen');
                            foreach($filasServidas as $id_product => $filaServidaTemp) {
                                foreach($filaServidaTemp as $id_product_attribute => $filaServida) {
                                    $opcionesAlmacenProducto = $modulo->cargarOpcionAlmacen($id_product, $id_product_attribute);
                                    //El almacén de salida es obligatorio
                                    $id_warehouse = $opcionesAlmacenProducto['almacenSalidaPorDefecto'];
                                    $ultimoMovimiento = $multi->obtenerUltimoMovimiento($id_product, $id_product_attribute, $id_warehouse);
                                    $mvt_reserved = 0;
                                    $mvt_physical = $filaServida['cantidadActual'];
                                    $reserved_quantity = $ultimoMovimiento['reserved_quantity'];
                                    $physical_quantity = $ultimoMovimiento['physical_quantity'] - $mvt_physical;
                                    $reason_presta = 'Pedido Enviado';
                                    $multi->insertarMovimiento($id_product, $id_product_attribute, $id_warehouse, $reserved_quantity, 
                                            $physical_quantity, $mvt_reserved, -$mvt_physical, $reason_presta, $idPedido);
                                    $multi->ajustarStockPedido($mvt_physical, $idPedido, $id_product, $id_product_attribute);
                                }
                            }
                        }
                    }
                    
                    try {
                        Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . "bloqueoPedido` 
                            WHERE idPedido = $idPedido AND idTipoPedido = " . ImaxImprimePedidosServidor::TIPO_PEDIDO_SALIDA);
                    } catch (Exception $ex) { }
                } catch (Exception $ex) {
                    $resultado['ok'] = false;
                }
            }
            break;
        case 'imprimir':
            $idPedido = (int) Tools::getValue('idPedido');
            $opcionesImprimir = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'OPCIONES_IMPRIMIR'));
            if(!empty($opcionesImprimir)){
                $imprimirEtiqueta = in_array(0, $opcionesImprimir) ? 1 : 0;
                $imprimirPedido = in_array(1, $opcionesImprimir) ? 1 : 0;
                $imprimirFactura = in_array(2, $opcionesImprimir) ? 1 : 0;
                $resultado['ok'] = Db::getInstance()->execute("INSERT INTO `" . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . "imprimirEtiqueta` (idPedido, etiqueta, pedido, factura)
                                VALUES ($idPedido, $imprimirEtiqueta , $imprimirPedido, $imprimirFactura)
                                ON DUPLICATE KEY UPDATE 
                                    etiqueta = VALUES(etiqueta),
                                    pedido = VALUES(pedido),
                                    factura = VALUES(factura)");
            }else{
                $resultado['ok'] = true;
            }
            break;    
        case 'buscarProductos':
            $modulo = new ImaxImprimePedidosServidor();
            $texto = Tools::getValue('texto');
            $resultado['datos'] = $modulo->buscarProducto($texto);
            $resultado['ok'] = true;
            break;
        
        case 'reservarLote':
            $lote = Tools::getValue('lote');
            $id_product = (int) Tools::getValue('idProducto');
            $id_product_attribute = (int) Tools::getValue('idCombinacion');
            $cantidad = (int) Tools::getValue('cantidad');
            $id_order = (int) Tools::getValue('idPedido');
            $ignorarAnteriores = (boolean) Tools::getValue('ignorarAnteriores');
            
            $modulo = new ImaxImprimePedidosServidor();
            $resultado['datos'] = $modulo->reservarLote($lote, $id_product, $id_product_attribute, $cantidad, $id_order, $ignorarAnteriores);
            $resultado['ok'] = true;
            break;
        
        case 'marcarMerma':
            $lote = Tools::getValue('lote');
            $id_product = (int) Tools::getValue('idProducto');
            $id_product_attribute = (int) Tools::getValue('idCombinacion');
            $cantidad = (int) Tools::getValue('cantidad');
            $id_order = (int) Tools::getValue('idPedido', 0);
            
            $modulo = new ImaxImprimePedidosServidor();
            $resultado['datos'] = $modulo->marcarMerma($lote, $id_product, $id_product_attribute, $cantidad, $id_order);
            $resultado['ok'] = true;
            break;
        
        case 'marcarDisponiblePorLote':
            $lote = Tools::getValue('lote');
            $id_product = (int) Tools::getValue('idProducto');
            $id_product_attribute = (int) Tools::getValue('idCombinacion');
            $id_order = (int) Tools::getValue('idPedido');
            $cantidad = (int) Tools::getValue('cantidad');
            
            $modulo = new ImaxImprimePedidosServidor();
            $resultado['datos'] = $modulo->marcarDisponiblePorLote($lote, $id_product, $id_product_attribute, $cantidad, $id_order);
            $resultado['ok'] = true;
            break;
        
        case 'eliminarFilaPedido':
            $id_order_detail = (int) Tools::getValue('idFilaPedido');
            $modulo = new ImaxImprimePedidosServidor();
            $resultado['ok'] = $modulo->eliminarFilaPedido($id_order_detail);
            break;
        
        case 'sinTerminar':
            $id_order = (int)Tools::getValue('idPedido');
            $empleadoActual = Context::getContext()->employee;
            $modulo = new ImaxImprimePedidosServidor();
            $resultado['ok'] = $modulo->pedidoSinTerminar($id_order, $empleadoActual->id);
            break;
    }
}

echo Tools::getValue('callback') . '(' . json_encode($resultado) . ')';
