<?php
define('_PS_ADMIN_DIR_', '');
include_once(dirname(__FILE__) . '../../../../config/config.inc.php');
include_once(dirname(__FILE__) . '/../imaximprimepedidosservidor.php');

$context = Context::getContext();
$modulo = new ImaxImprimePedidosServidor();

//Cargamos licencias
$licencias = [];
$licenciasPosibles = ['imaximprimepedidosservidorpda', 'imaximprimepedidosservidorpdaentrada'];
foreach($licenciasPosibles as $licenciaPosible) {
    if($modulo->checkLicenciaAdicional($licenciaPosible, $modulo->getLicenciaAdicional($licenciaPosible, FALSE), 0)) {
        $licencias[] = $licenciaPosible;
    }
}

//Comprobamos logueo
$nombreUsuario = '';
if(!empty($context->employee->id) && $context->employee->isLoggedBack()) {
    $nombreUsuario = $context->employee->firstname;
    
    if(isset($_POST['logout'])) {
        $context->employee->logout();
    }
}

$srcLogo = $context->link->getBaseLink().'img/'.Configuration::get('PS_LOGO');
$urlImaxinventariodiferido = '';
if(Module::isEnabled('imaxinventariodiferido')) {
    $urlImaxinventariodiferido = $context->link->getBaseLink().'modules/imaxinventariodiferido/pda/principal.php';  
}

$urlImaxscanean = '';
if(Module::isEnabled('imaxscanean')) {
    $urlImaxscanean = $context->link->getBaseLink().'modules/imaxscanean/pda/principal.php';  
}

$urlImaxmovimientospda = '';
if(Module::isEnabled('imaxmovimientospda')) {
    $urlImaxmovimientospda = $context->link->getBaseLink().'modules/imaxmovimientospda/pda/principal.php';  
}

$urlImaxrecoleccionpda = '';
if(Module::isEnabled('imaxrecoleccionpda')) {
    $urlImaxrecoleccionpda = $context->link->getBaseLink().'modules/imaxrecoleccionpda/pda/principal.php';  
}

$cuerpo = 'menu.php';
$css[] = 'menu.css';
$js[] = 'menu.js';
$idBody = 'paginaMenu';
$nombrePagina = $modulo->l('Inicio', 'ImaxImprimePedidosServidor');

if(isset($_POST['submit'])) {
    /* Check fields validity */
    $errors = array();
    $passwd = trim(Tools::getValue('pass'));
    $email = trim(Tools::getValue('email'));
    if (empty($email)) {
        $errors[] = Tools::displayError($modulo->l('El email esta vacio.', 'ImaxImprimePedidosServidor'));
    } elseif (!Validate::isEmail($email)) {
        $errors[] = Tools::displayError($modulo->l('La direccion de email es incorrecta.', 'ImaxImprimePedidosServidor'));
    }

    if (empty($passwd)) {
        $errors[] = Tools::displayError($modulo->l('El password esta en blanco.', 'ImaxImprimePedidosServidor'));
    } else {
        if (version_compare(_PS_VERSION_, '8.0.0', '>=')) {
            // Para PrestaShop 8.0.0 o posterior    
            if (!Validate::isAcceptablePasswordLength($passwd)) {
                $errors[] = Tools::displayError($modulo->l('El password es incorrecto.', 'ImaxImprimePedidosServidor'));
            }
        } else {
            // Para PrestaShop 1.7 o anterior
            if (!Validate::isPasswd($passwd)) {
                $errors[] = Tools::displayError($modulo->l('El password es incorrecto.', 'ImaxImprimePedidosServidor'));
            }
        }
    }

    if (!count($errors)) {
        // Find employee
        $context->employee = new Employee();
        $is_employee_loaded = $context->employee->getByEmail($email, $passwd);
        $employee_associated_shop = $context->employee->getAssociatedShops();
        if (!$is_employee_loaded) {
            $errors[] = Tools::displayError($modulo->l('No existe el empleado o el password es incorrecto.', 'ImaxImprimePedidosServidor'));
            $context->employee->logout();
        } elseif (empty($employee_associated_shop) && !$context->employee->isSuperAdmin()) {
            $errors[] = Tools::displayError($modulo->l('El empleado no esta configurado para la tienda.', 'ImaxImprimePedidosServidor'));
            $context->employee->logout();
        } else {
            if(class_exists('PrestaShopLogger')) {
                PrestaShopLogger::addLog('Back Office connection from Informax PDA ('.Tools::getRemoteAddr().')', 1, null, '', 0, true, (int)$context->employee->id);
            }

            $context->employee->remote_addr = (int)ip2long(Tools::getRemoteAddr());
            // Update cookie
            $cookie = Context::getContext()->cookie;
            $cookie->id_employee = $context->employee->id;
            $cookie->email = $context->employee->email;
            $cookie->profile = $context->employee->id_profile;
            $cookie->passwd = $context->employee->passwd;
            $cookie->remote_addr = $context->employee->remote_addr;

            $cookie->write();
            
            Tools::redirectAdmin($context->shop->getBaseURL(true).'modules/imaximprimepedidosservidor/menu/index.php');
        }
    }
}

require_once '../comun/vistas/base.php';