/* global baseUrl, passRemota */

$(function() {
    mostrarOpcionesAlternativo.bind($('input[name="aspectoAlternativoPDA"]'))(); 
    $('input[name="aspectoAlternativoPDA"]').click(mostrarOpcionesAlternativo);
    
    $('#plantilla').keyup(function() {
        $(this).parent().parent().children('.contador').remove();
        $(this).parent().parent().append('<span class="contador">(' + $(this).val().length + ')</span>');
    });
    
    $('#plantilla').keyup();
    
    $('input[name="modoPlantilla"]').click(function() {
        switch($(this).val()) {
            case '0':
                $('#grupoPartes').hide();
                $('#grupoComodines').hide();
                $('#grupoAlternativamente').show();
                $('#contenedorMultiplicadorSerieProductos').show();
                break;
                
            case '1':
                $('#grupoPartes').hide();
                $('#grupoComodines').show();
                $('#grupoAlternativamente').hide();
                $('#contenedorMultiplicadorSerieProductos').hide();
                break;
                
            case '2':
                $('#grupoPartes').show();
                $('#grupoComodines').hide();
                $('#grupoAlternativamente').hide();
                $('#contenedorMultiplicadorSerieProductos').hide();
                break;
        }
    });
    $('input[name="modoPlantilla"]:checked').click();
    
    $('select[name="selectorGrupos"]').change(function() {
        if($(this).val() == 0) {
            $('#partesAlternativamente').show();
        }
        else {
            $('#partesAlternativamente').hide();
        }
    });
    $('select[name="selectorGrupos"]').change();
    
    //Plantilla caracteristicas
    /*$(".etiqueta").draggable({ revert: 'invalid', helper: "clone" });
    hacerDroppable($(".camposActivos > div"));
    
    $('form[name="camposCaracteristicas"]').submit(function() {
        var elementos1 = obtenerElementosRecuadro($('.camposActivos:nth-child(1)'));
        $('input[name="camposCaracteristicas"]').val(JSON.stringify(elementos1));
    });
    
    rellenarRecuadro($.parseJSON($('input[name="camposCaracteristicas"]').val()), $('.camposActivos:nth-child(1)'));*/
    
    //Colores para las zonas
    $('[name^="colorZonaPDA"]').each(function() {
        new Huebee(this, {
            notation: 'hex',
            saturations: 1
        });
    });
        
    //Productos sin picking
    var noPickingAjax = null;
    $('[name="buscarProductoNoPicking"]').keyup(function() {
        if(noPickingAjax) {
            noPickingAjax.abort();
        }
        
        if($(this).val()) {
            $.getJSON(baseUrl + 'imaximprimepedidosservidor_remoto.php?callback=?', {
                accion: 'buscarProducto',
                texto: $(this).val(),
                passRemota: passRemota
            }, function(respuesta) {
                var html = '<p>No se encuentran productos.</p>';
                if(respuesta.length > 0) {
                    var filas = [];
                    filas.push('<ul>');
                    respuesta.forEach(function(elemento) {
                        filas.push('<li data-id_product="' + elemento.id_product + '">' + elemento.id_product + ' - ' + elemento.name + '</li>');
                    });
                    filas.push('</ul>');

                    html = filas.join('');
                }

                $('.resultadosBusquedaProductoNoPicking').html(html);
            });
        }
        else {
            $('.resultadosBusquedaProductoNoPicking').html('');
        }
    });
    $('body').on('click', '.resultadosBusquedaProductoNoPicking li', function() {
        $('.contenedorResultadosProductoNoPicking ul').append('<li data-id_product="' + $(this).data('id_product') + '">' + $(this).html() + '<input type="button" name="eliminar" value="X"/></li>');
        showSuccessMessage('Agregado');
    });
    $('body').on('click', '.contenedorResultadosProductoNoPicking [name="eliminar"]', function() {
        $(this).parent().remove();
    });
    $('[name="opcionesConfiguracion"]').click(function() {
        var productos = [];
        $('.contenedorResultadosProductoNoPicking li').each(function() {
            productos.push($(this).data('id_product'));
        });
        $('[name="productosNoPicking"]').val(productos.join(','));
    });
    $('[name="articulosConPegatinas"]').click(function() {
        $.getJSON(baseUrl + 'imaximprimepedidosservidor_ajax.php?callback=?', {
            accion: 'generarArchivoArticulosPegatinas'
        }, function(respuesta) {
            if(respuesta.ok) {
                $('#contArtPega').html('<a href="../modules/imaximprimepedidosservidor/sampleFiles/articulosConPegatinas.csv">Pulsa este enlace para bajar un archivo de ejemplo.</a>');
                var link = document.createElement('a');
                // Establece la URL del archivo
                link.href = baseUrl + 'sampleFiles/articulosConPegatinas.csv';
                // Establece el atributo download para forzar la descarga
                link.download = 'articulosConPegatinas.csv';
                // Agrega el enlace al cuerpo del documento (para que funcione en Firefox)
                document.body.appendChild(link);
                // Simula el clic en el enlace
                link.click();
                // Elimina el enlace del documento después de hacer clic
                document.body.removeChild(link);
                // var fileUrl = baseUrl + 'samplesFiles/articulosConPegatinas.csv'; 
                // window.open(fileUrl, '_blank');
                showSuccessMessage(respuesta.mensaje);
            }
            else {
                showErrorMessage(respuesta.mensaje);
            }
        });
    });

    $('[name="eliminarPedidosPendientes"]').click(function() {
        if(confirm(msgEliminarPedidosPendientes)){
            $.getJSON(baseUrl + 'imaximprimepedidosservidor_ajax.php?callback=?', {
                accion: 'eliminarPedidosPendientes'
            }, function(respuesta) {
                if(respuesta.ok) {
                    showSuccessMessage(respuesta.mensaje);
                }
                else {
                    showErrorMessage(respuesta.mensaje);
                }
            });
        }
    });
});


/**
 * Agrega los eventos necesarios al elemento del recuadro.
 * @param {JQuery} elemento
 */
function hacerDroppable(elemento) {
    elemento.droppable({
        accept: '.etiqueta',
        drop: eventoDrop
    });
}

/**
 * Evento drop del recuadro.
 * @param {Object} event
 * @param {Object} ui
 */
function eventoDrop(event, ui) {
    var fila = $(this);
    
    var papelera = $('<i class="icon-trash">').click(function() {
        //Eliminar el elemento
        $(this).parent().remove();
    });
    var copia = ui.draggable.clone().removeClass('etiqueta').append(papelera);
    fila.append(copia);
    fila.sortable().disableSelection();
}

/**
 * Devuelve los elementos seleccionados para el formulario.
 * @param {JQuery} elementoContenedor 
 * @returns {Array|elementosRecuadro.elementos}
 */
function obtenerElementosRecuadro(elementoContenedor) {
    var elementos = [ ];
    elementoContenedor.children('div').each(function() {
        if($(this).children().length > 0) {
            var elementosFila = [ ];
            $(this).children().each(function() {
                elementosFila.push($(this).data('id'));
            });
            elementos.push(elementosFila);
        }
    });
    
    return elementos;
}

/**
 * Carga el cuadro con los elementos dados.
 * @param {Array} elementos
 * @param {JQuery} elementoContenedor
 */
function rellenarRecuadro(elementos, elementoContenedor) {
    if(elementos) {
        for(var i=0,len=elementos.length;i<len;i++) {
            for(var j=0,len2=elementos[i].length;j<len2;j++) {
                var fila = elementoContenedor.children('div').get(i);
                eventoDrop.call(fila, { target: fila }, { draggable: $('.etiqueta').filter(function() {
                    return $(this).data('id') == elementos[i][j];
                }) });
            }
        }
    }
}

function mostrarOpcionesAlternativo() {
    if($(this).is(':checked')) {
        $('#opcionesAspectoAlternativo').show();
        $('#opcionesBotones').hide();
    }
    else {
        $('#opcionesBotones').show();
        $('#opcionesAspectoAlternativo').hide();    
    }
}