<?php 
use PrestaShop\PrestaShop\Adapter\SymfonyContainer;

include_once(dirname(__FILE__) . '../../../config/config.inc.php');
Configuration::set('PS_SHOP_ENABLE', true);
include_once(dirname(__FILE__) . '../../../init.php');
include_once(dirname(__FILE__) . '/imaximprimepedidosservidor.php');

Context::getContext()->esImprime = TRUE;

//Inicializamos el kernel
if(version_compare(_PS_VERSION_, '1.7.0.0 ', '>=')) {
    if(!class_exists('AppKernel')) {
        require_once __DIR__.'/../../../app/AppKernel.php';
    }

    global $kernel;
    $kernel = new AppKernel(_PS_MODE_DEV_ ? 'dev' : 'prod', _PS_MODE_DEV_ ? true : false);
    $kernel->boot();
    Context::getContext()->container = SymfonyContainer::getInstance();
}

$passRemota = isset($_REQUEST['passRemota']) ? $_REQUEST['passRemota'] : '';
$accion = isset($_REQUEST['accion']) ? $_REQUEST['accion'] : '';
$debug = isset($_REQUEST['debug']) ? TRUE : FALSE;

$resultado = array();
$realTime = new ImaxImprimePedidosServidor();

$pass = Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS');
if ($pass == '' || $pass != $passRemota) { 
    echo json_encode(array('error' => true, 'mensaje' => $realTime->l('La contraseña no es correcta')));
    exit;
}

switch ($accion){
    case 'insertarBultos':
        $resultado['ok'] = $realTime->insertarBultosManuales(Tools::getValue('id_order'), Tools::getValue('bultos'));
        break;
    
    case 'actualizarBultos':
        $bultosManuales = new BultosManuales(Tools::getValue('id_order'));
        $resultado = $bultosManuales->grabarBultosManuales(Tools::getValue('bultos'));
        echo Tools::getValue('callback').'('.json_encode($resultado).')';
        exit;
        break;
    
    case 'buscarProducto':
        $resultado = $realTime->buscarProducto(Tools::getValue('texto'));
        echo Tools::getValue('callback').'('.json_encode($resultado).')';
        exit;
        break;
    
    case 'addNumSerie':
        $resultado['ok'] = 1;
        $datos = Tools::getValue('datos');
        foreach($datos as $idCompuesto => $numSerie) {
            $partes = explode('_', $idCompuesto);
            if(!$realTime->guardarNumeroSerie($partes[0], $partes[1], $partes[2], $partes[3], $partes[4], $numSerie)) {
                $resultado['ok'] = 0;
            }
        }
        echo Tools::getValue('callback').'('.json_encode($resultado).')';
        exit();
        break;
    
    case 'damePendientes':
        $texto = Tools::getValue('textoBuscado', FALSE);
        $cantidad = Tools::getValue('cantidad', 0);
        $pagina = Tools::getValue('pagina', 0);
        $idEstado = Tools::getValue('idEstado');
        $idProveedor = Tools::getValue('idProveedor', 0);
        $orden = Tools::getValue('orden');
        $referenciaTransportista = Tools::getValue('referenciaTransportista', 0);
        $fechaDesde = Tools::getValue('fechaDesde', '');
        $fechaHasta = Tools::getValue('fechaHasta', '');
        $formaPago = Tools::getValue('formaPago', '');
        $codigosPostales = Tools::getValue('codigosPostales', '');
        $imprimidos = Tools::getValue('imprimidas', 0);
        $campoOrden = Tools::getValue('campoOrden', 0);
        $ubicacion = Tools::getValue('ubicacion', '');
        $idPais = Tools::getValue('idPais', 0);
        $idsTienda = explode(',', Tools::getValue('idsTienda', ''));
        $idLocal = Tools::getValue('idLocal', 0);
        $emailCliente = Tools::getValue('emailCliente', '');
        $passCliente = Tools::getValue('passCliente', '');
        $resultado = $realTime->pedidos(TRUE, $texto, $cantidad, $pagina, $idEstado, $orden, $referenciaTransportista, $fechaDesde, $fechaHasta, 
                $formaPago, $idProveedor, $codigosPostales, $imprimidos, $campoOrden, $ubicacion, $idPais, $idsTienda, $idLocal, $emailCliente, 
                $passCliente);
        break;

    case 'dameHistorico':        
        $texto = Tools::getValue('textoBuscado', FALSE);
        $cantidad = Tools::getValue('cantidad', 0);
        $pagina = Tools::getValue('pagina', 0);
        $idEstado = Tools::getValue('idEstado');
        $idProveedor = Tools::getValue('idProveedor', 0);
        $orden = Tools::getValue('orden');
        $referenciaTransportista = Tools::getValue('referenciaTransportista');
        $fechaDesde = Tools::getValue('fechaDesde', '');
        $fechaHasta = Tools::getValue('fechaHasta', '');
        $formaPago = Tools::getValue('formaPago', '');
        $codigosPostales = Tools::getValue('codigosPostales', '');
        $imprimidos = Tools::getValue('imprimidas', 0);
        $campoOrden = Tools::getValue('campoOrden', 0);
        $ubicacion = Tools::getValue('ubicacion', '');
        $idPais = Tools::getValue('idPais', 0);
        $idsTienda = explode(',', Tools::getValue('idsTienda', ''));
        $idLocal = Tools::getValue('idLocal', 0);
        $emailCliente = Tools::getValue('emailCliente', '');
        $passCliente = Tools::getValue('passCliente', '');
        $resultado = $realTime->pedidos(FALSE, $texto, $cantidad, $pagina, $idEstado, $orden, $referenciaTransportista, $fechaDesde, $fechaHasta, 
                $formaPago, $idProveedor, $codigosPostales, $imprimidos, $campoOrden, $ubicacion, $idPais, $idsTienda, $idLocal, $emailCliente, 
                $passCliente);
        break;    
    
    case 'dameImprimibles':
        $texto = Tools::getValue('textoBuscado', FALSE);
        $idEstado = Tools::getValue('idEstado');
        $idProveedor = Tools::getValue('idProveedor', 0);
        $orden = Tools::getValue('orden');
        $referenciaTransportista = Tools::getValue('referenciaTransportista', 0);
        $fechaDesde = Tools::getValue('fechaDesde', '');
        $fechaHasta = Tools::getValue('fechaHasta', '');
        $formaPago = Tools::getValue('formaPago', '');
        $codigosPostales = Tools::getValue('codigosPostales', '');
        $imprimidos = Tools::getValue('imprimidas', 0);
        $campoOrden = Tools::getValue('campoOrden', 0);
        $ubicacion = Tools::getValue('ubicacion', '');
        $idPais = Tools::getValue('idPais', 0);
        $idsTienda = explode(',', Tools::getValue('idsTienda', ''));
        $documentos = (Tools::isSubmit('documentos') ? explode(',', Tools::getValue('documentos', '')) : false);
        $marcarNoSolicitados = Tools::getValue('marcarNoSolicitados', false);
        $idLocal = Tools::getValue('idLocal', 0);
        $emailCliente = Tools::getValue('emailCliente', '');
        $passCliente = Tools::getValue('passCliente', '');
        $resultado = $realTime->pedidosParaImprimir($texto, $idEstado, $orden, $referenciaTransportista, $fechaDesde, $fechaHasta, $formaPago, 
                $idProveedor, $codigosPostales, $imprimidos, $campoOrden, $ubicacion, $idPais, $idsTienda, $documentos, $marcarNoSolicitados, 
                $idLocal, $emailCliente, $passCliente);
        break;
    
    case 'dameEstadosPedido':
        $resultado['datos'] = $realTime->estadosPedidos();
        break;
    
    case 'dameEstadosFastPrinting':
        $resultado['datos'] = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'ESTADOS_FAST_PRINTING'));
        if(!$resultado['datos']) {
            $resultado['datos'] = array();
        }
        break;
    
    case 'dameFormasPago':
        $resultado['datos'] = $realTime->formasPago();
        break;
    
    case 'dameTiendas':
        $resultado['datos'] = $realTime->tiendasPresta();
        break;
    
    case 'dameEmpleados':
        $resultado['datos'] = $realTime->empleados();
        break;
    
    case 'damePedidosImpresos':
        $resultado['datos'] = base64_encode($realTime->generarPdfPedidosImpresos(Tools::getValue('fechaInicio'), Tools::getValue('fechaFin')));
        if(!$resultado['datos']) {
            $resultado['error'] = true;
            $resultado['mensaje'] = $realTime->l('No se dispone del documento pdf');
        }
        break;
    
    case 'damePaises':
        $resultado['datos'] = $realTime->paisesPresta();
        break;
    
    case 'dameProvincias':
        $resultado['datos'] = $realTime->provinciasPresta();
        break;
    
    case 'damePedido':
        $idPedido = Tools::getValue('idPedido');
        $soloTexto = Tools::getValue('soloTexto', false);
        $plantilla = Tools::getValue('plantilla', '');
        $resultado['datos'] = base64_encode($realTime->generarPdfPedido($idPedido, $soloTexto, $plantilla));
        if(!$resultado['datos']) {
            $resultado['error'] = true;
            $resultado['mensaje'] = $realTime->l('No se dispone del documento');
        }
        break;
    
    case 'dameFactura':
        $idPedido = Tools::getValue('idPedido');
        $resultado['datos'] = base64_encode($realTime->generarPdfFactura($idPedido));
        if(!$resultado['datos']) {
            $resultado['error'] = true;
            $resultado['mensaje'] = $realTime->l('No se dispone del documento pdf');
        }
        break;
        
    case 'dameAbono':
        $idPedido = Tools::getValue('idPedido');
        $resultado['datos'] = base64_encode($realTime->generarPdfAbono($idPedido));
        if(!$resultado['datos']) {
            $resultado['error'] = true;
            $resultado['mensaje'] = $realTime->l('No se dispone del documento pdf');
        }
        break;
        
    case 'dameEtiqueta':
        $idPedido = Tools::getValue('idPedido');
        $cambiarEstado = Tools::getValue('cambiarEstado', false);
        //Ponemos el modo devolución temporalmente de ser necesario
        $datos = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'datosTransportista_correos_express');
        if($datos) {
            $datos = unserialize($datos);
            $datos['inversaCex'] = Tools::getValue('inversa', false);
            Configuration::set(ImaxImprimePedidosServidor::prefijo.'datosTransportista_correos_express', serialize($datos));
        }
        $bultos = Tools::getValue('bultos');
        if($bultos > 1) {
            $realTime->insertarBultosManuales($idPedido, $bultos);
        }
        $resultado['datos'] = base64_encode($realTime->generarPdfEtiqueta($idPedido, Tools::getValue('marcarDescargado', true)));
        if(!$resultado['datos']) {
            $resultado['error'] = true;
            $resultado['mensaje'] = $realTime->getErrorEtiqueta();
        }
        elseif($cambiarEstado) {
            $pedido = new Order($idPedido);
                  
            //Cambiamos el estado del pedido
            $estado_cambio = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'ESTADO_MONTADO');
            $realTime->cambiarEstado($pedido, $estado_cambio, true);
        }
        break;
        
    case 'dameBlSpartoo':
        $idPedido = Tools::getValue('idPedido');
        $resultado['datos'] = base64_encode($realTime->generarPdfBlSpartoo($idPedido));
        if(!$resultado['datos']) {
            $resultado['error'] = true;
            $resultado['mensaje'] = $realTime->l('No se dispone del documento pdf');
        }
        break;
        
    case 'dameInfoEtiqueta':
        $idPedido = Tools::getValue('idPedido');
        $esReferencia = Tools::getValue('esReferencia', false);
        $estadosIncidencia = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'INCIDENCIA'));
        $referenciasTransportista = $realTime->obtenerReferenciaTransportistas();
        $aliasFormasPago = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'ALIAS_FORMAS_PAGO'));
        $resultado['datos'] = $realTime->obtenerFilaPedido($idPedido, $estadosIncidencia, $referenciasTransportista, $aliasFormasPago, $esReferencia);
        
        break;
        
    case 'dameLicencias':
        $resultado['datos'] = array();
        if($realTime->checkLicenciaAdicional('imaximprimepedidosservidorpda', $realTime->getLicenciaAdicional('imaximprimepedidosservidorpda', FALSE), 0)) {
            $resultado['datos'][] = 'imaximprimepedidosservidorpda';
        }
        if($realTime->checkLicenciaAdicional('imaximprimepedidosservidorpdaentrada', $realTime->getLicenciaAdicional('imaximprimepedidosservidorpdaentrada', FALSE), 0)) {
            $resultado['datos'][] = 'imaximprimepedidosservidorpdaentrada';
        }
        if($realTime->checkLicenciaAdicional('imaximprimepedidosservidornumserie', $realTime->getLicenciaAdicional('imaximprimepedidosservidornumserie', FALSE), 0)) {
            $resultado['datos'][] = 'imaximprimepedidosservidornumserie';
        }
        if($realTime->checkLicenciaAdicional('imaximprimepedidosservidorfastprinting', $realTime->getLicenciaAdicional('imaximprimepedidosservidorfastprinting', FALSE), 0)) {
            $resultado['datos'][] = 'imaximprimepedidosservidorfastprinting';
        }
        if($realTime->checkLicenciaAdicional('imaximprimepedidosservidorimpresionsocket', $realTime->getLicenciaAdicional('imaximprimepedidosservidorimpresionsocket', FALSE), 0)) {
            $resultado['datos'][] = 'imaximprimepedidosservidorimpresionsocket';
        }
        if(Module::isEnabled('imaxdhlparcelv3')) {
            $resultado['datos'][] = 'cierreDiaDhl';
        }
        break;
    
    case 'cambiaEstado':
        $idPedido = Tools::getValue('idPedido');
        $idEstado = Tools::getValue('idEstado');
        if($idPedido && $idEstado) {
            $pedido = new Order($idPedido);
            $pedido->setCurrentState($idEstado);
            
            $resultado['error'] = false;
        }
        else {
            $resultado['error'] = true;
            $resultado['mensaje'] = $realTime->l('Datos erróneos');
        }
        break;
    
    case 'cambiaTransportista':
        $idPedido = Tools::getValue('idPedido');
        $referenciaTransportista = Tools::getValue('referenciaTransportista');
        if($idPedido && $referenciaTransportista) {
            $transportista = Carrier::getCarrierByReference($referenciaTransportista);
            if(Validate::isLoadedObject($transportista)) {
                $pedido = new OrderCore($idPedido);
                $pedido->id_carrier = $transportista->id;
                $pedido->update();
                
                $transporte = new OrderCarrier($pedido->getIdOrderCarrier());
                $transporte->id_carrier = $transportista->id;
                $transporte->update();
            
                $resultado['error'] = false;
            }
            else {
                $resultado['error'] = true;
                $resultado['mensaje'] = $realTime->l('Transportista erróneo');
            }
        }
        else {
            $resultado['error'] = true;
            $resultado['mensaje'] = $realTime->l('Datos erróneos');
        }
        break;
    
    case 'dameDatosEconomicos':
        $passGrabado = Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS_ECONOMICO');
        $passEconomico = Tools::getValue('passEconomico');

        if($passGrabado && $passEconomico == $passGrabado) {
            $idProveedor = Tools::getValue('idProveedor', 0);
            $codigosPostales = Tools::getValue('codigosPostales', '');
            $idsTienda = explode(',', Tools::getValue('idsTienda', ''));
            $idLocal = Tools::getValue('idLocal', 0);
            $emailCliente = Tools::getValue('emailCliente', '');
            $passCliente = Tools::getValue('passCliente', '');
            $resultado = $realTime->datosEconomicos($idProveedor, $codigosPostales, $idsTienda, $idLocal, $emailCliente, $passCliente);
        }
        else {
            echo json_encode(array('error' => true, 'mensaje' => $realTime->l('La contraseña no es correcta')));
            exit;
        }
        break;
        
    case 'dameTransportistas':
        Shop::setContext(Shop::CONTEXT_ALL);
        $resultado['datos'] = $realTime->obtenerTransportistas();
        break;
 
    case 'obtenerEtiquetasImprimibles':
        $resultado['datos'] = $realTime->obtenerEtiquetasImprimibles(Tools::getValue('idLocal', 0), Tools::getValue('idEmpleado', 0), 
                Tools::getValue('emailCliente', ''), Tools::getValue('passCliente', ''));
        break;
    
    case 'obtenerLocales':
        if(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'USAR_LOCALES')) {
            $resultado['datos'] = $realTime->obtenerLocales(false);
        }
        else {
            $resultado['datos'] = array();
        }
        break;
    
    case 'actualizarLocal':
        $resultado['ok'] = $realTime->modificarLocalPedido(Tools::getValue('id_order'), Tools::getValue('id_store'));
        break;
    
    case 'obtenerEtiquetaGDS':
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/GeneradorEtiqueta.php";
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/generadoresEtiqueta/GeneradorEtiquetaGds.php";
        
        $generador = new GeneradorEtiquetaGds($realTime);
        $generador->generarEtiquetaRemoto(Tools::getValue('id_order'));
        break;
        
    case 'actualizarDireccion':
        $resultado['ok'] = $realTime->modificarDireccionEntrega(Tools::getValue('id_order'), json_decode(Tools::getValue('nuevosDatos'), true));
        break;
    
    case 'obtenerManifiestoSeur':
        $fecha = Tools::getValue('fecha');
        $id_store = Tools::getValue('tienda');
        
        $resultado['datos'] = base64_encode($realTime->generarManifestSeur($fecha, $id_store));
        $resultado['ok'] = (boolean)$resultado['datos'];
        break;
    
    case 'generarManifiestoSeur':
        require_once(_PS_MODULE_DIR_ . DIRECTORY_SEPARATOR . 'seur' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'Manifest.php');
        require_once(_PS_MODULE_DIR_ . DIRECTORY_SEPARATOR . 'seur' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'SeurCCC.php');
        require_once(_PS_MODULE_DIR_ . DIRECTORY_SEPARATOR . 'seur' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'SeurOrder.php');
        
        SeurManifest::createManifest(Tools::getValue('ids_seur_order'));
        break;
    
    case 'obtenerPass':
        $resultado['ok'] = true;
        $configuracion = Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS_CONFIGURACION', null, 0, 0, '');
        $edicion = Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS_EDICION', null, 0, 0, '');
        $resultado['datos'] = array(
            'configuracion' => ($configuracion ? $configuracion : ''),
            'edicion' => ($edicion ? $edicion : '')
        );
        break;
    
    case 'obtenerPlantillas':
        $resultado['datos'] = array_values($realTime->obtenerPlantillas());
        $resultado['ok'] = (boolean)$resultado['datos'];
        break;
    
    case 'obtenerProductosDHL':
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/GeneradorEtiqueta.php";
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/generadoresEtiqueta/GeneradorEtiquetaDhl.php";
        
        $generador = new GeneradorEtiquetaDhl($realTime);
        $generador->obtenerProductosDhl();
        break;
    
    case 'generarEtiquetaDHL':
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/GeneradorEtiqueta.php";
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/generadoresEtiqueta/GeneradorEtiquetaDhl.php";
        
        $generador = new GeneradorEtiquetaDhl($realTime);
        $generador->generarEtiquetaRemoto();
        break;
        
    case 'generarEtiquetaEnvialia':
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/GeneradorEtiqueta.php";
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/generadoresEtiqueta/GeneradorEtiquetaEnvialia.php";
        
        $generador = new GeneradorEtiquetaEnvialia($realTime);
        $generador->generarEtiquetaRemoto();
        break;

    case 'generarEtiquetaAsendia':
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/GeneradorEtiqueta.php";
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/generadoresEtiqueta/GeneradorEtiquetaAsendia.php";
        
        $generador = new GeneradorEtiquetaAsendia($realTime);
        $generador->generarEtiquetaRemoto();
        break;
        
    case 'generarEtiquetaUPS':
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/GeneradorEtiqueta.php";
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/generadoresEtiqueta/GeneradorEtiquetaUps.php";
        
        $generador = new GeneradorEtiquetaUps($realTime);
        $generador->generarEtiquetaRemoto(Tools::getValue('id_order'));
        break;
        
    case 'obtenerUsuariosDhl':
        $resultado['datos'] = $realTime->obtenerUsuariosDhl();
        $resultado['ok'] = true;
        break;
        
    case 'obtenerCierresDhl':
        $resultado['datos'] = $realTime->listarCierresDhl(Tools::getValue('user'));
        $resultado['ok'] = true;
        break;
    
    case 'obtenerCierreDhl':
        $user = Tools::getValue('user', '');
        $cierre = Tools::getValue('cierre', '');
        $ruta = ($user ? $user.'/' : '').date('Y/m/d');
        $resultado['datos'] = base64_encode($realTime->obtenerCierreDhl($cierre ? $ruta.'/'.$cierre : '', $user));
        $resultado['ok'] = true;
        break;
    
    case 'generarEtiquetaCorreosOficial':
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/GeneradorEtiqueta.php";
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/generadoresEtiqueta/GeneradorEtiquetaCorreos.php";
        
        $resultado = '';
        $generador = new GeneradorEtiquetaCorreos($realTime);
        $generador->generarEtiquetaRemoto(Tools::getValue('order_id'));
        break;
    case 'obtenerEtiquetasImprimiblesProducto':
        $resultado['datos'] = $realTime->obtenerEtiquetasImprimiblesProducto(Tools::getValue('idLocal', 0), Tools::getValue('idEmpleado', 0), 
                Tools::getValue('emailCliente', ''), Tools::getValue('passCliente', ''));
        break;
    case 'dameEtiquetaProducto':
        $idPedido = Tools::getValue('idPedido');
        $idProducto = (int)Tools::getValue('idProducto');
        $idCombinacion = (int)Tools::getValue('idCombinacion');
        $resultado['datos'] = base64_encode($realTime->generarEtiquetaProducto($idPedido, $idProducto, $idCombinacion));
        if(!$resultado['datos']) {
            $resultado['error'] = true;
            $resultado['mensaje'] = $realTime->l('No se dispone del documento pdf');
        }
        break;    
    case 'generarEtiquetaCtt':
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/GeneradorEtiqueta.php";
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/generadoresEtiqueta/GeneradorEtiquetaCtt.php";
        
        $generador = new GeneradorEtiquetaCtt($realTime);
        $generador->generarEtiquetaRemoto(Tools::getValue('id_order'));
        break;
    case 'generarEtiquetaFedex':
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/GeneradorEtiqueta.php";
        require_once _PS_MODULE_DIR_ . "imaximprimepedidosservidor/clases/generadoresEtiqueta/GeneradorEtiquetaFedex.php";
        
        $generador = new GeneradorEtiquetaFedex($realTime);
        $generador->generarEtiquetaRemoto(Tools::getValue('id_employee'));
        break;
}

echo json_encode($resultado);