<?php 

//NOTA: Se han de crear dos claves en la tabla idxrtracking para mejorar el rendimiento 
//(id_order, combination_reference, date_expiry, id_status) y (id_product, id_attribute, out_lot, id_status).
//También una clave en ps_order_invoice para la columna number.

require_once __DIR__.'/clases/CentralizadorEtiquetas.php';
require_once __DIR__.'/clases/GeneradorEtiqueta.php';
require_once __DIR__.'/clases/ConfiguracionEtiqueta.php';
require_once __DIR__.'/clases/BultosManuales.php';

spl_autoload_register(function($nombreClase) {
    if (strpos($nombreClase, 'MarcL\\') !== false) {
        $temp = explode('\\', $nombreClase);
        $nombreClase = end($temp);
    }
    
    if (strpos($nombreClase, 'Transformer') !== FALSE) {
        if (is_file(str_replace('\\', DIRECTORY_SEPARATOR, dirname(__FILE__) . '/classes/Transformers/' . $nombreClase . '.php'))) {
            require_once str_replace('\\', DIRECTORY_SEPARATOR, dirname(__FILE__) . '/classes/Transformers/' . $nombreClase . '.php');
        }
    }
    
    if (strpos($nombreClase, 'Amazon') !== FALSE || strpos($nombreClase, 'CurlHttpRequest') !== FALSE) {
        if (is_file(str_replace('\\', DIRECTORY_SEPARATOR, dirname(__FILE__) . '/classes/' . $nombreClase . '.php'))) {
            require_once str_replace('\\', DIRECTORY_SEPARATOR, dirname(__FILE__) . '/classes/' . $nombreClase . '.php');
        }
    }
    
    if (strpos($nombreClase, 'Picqer\\Barcode') !== FALSE) {
        if (is_file(str_replace('\\', DIRECTORY_SEPARATOR, dirname(__FILE__) . '/clases/' . $nombreClase . '.php'))) {
            require_once str_replace('\\', DIRECTORY_SEPARATOR, dirname(__FILE__) . '/clases/' . $nombreClase . '.php');
        }
    }
}, true, true);

class ImaxImprimePedidosServidor extends Module {
//TODO: Probar cuando se encuentren: Asm, Colissimo, Paq ligero, Ctt, envialia, Fedex, GDS, tipsa, ups, zeleris. 
//Se puede probar en https://novaenv2.nodo5.informaxdns.es.

    var $versionPS;
    var $idShop;
    var $langShop;
    private $_html = '', $forceCheck, $errorEtiqueta;
    private static $tipoImagenMini, $tiposDocumentos = array('factura', 'pedido', 'etiqueta'), $tipoImagenMediana, $hookedTopOrder = false;
    public $idManual, $sufijo, $idLang;

    const prefijo = 'imaximppedser_';
    const ENTITY_PRODUCTO = 'products', ENTITY_CATEGORIA = 'categories', ENTITY_FABRICANTE = 'manufacturers', ENTITY_PROVEEDOR = 'suppliers';
    const TIPO_PEDIDO_SALIDA = 0, TIPO_PEDIDO_ENTRADA = 1;
    const ARCHIVO_CSV = 0, ARCHIVO_EXCEL = 1;
    const IDENTIFICADOR_EAN13 = 0, IDENTIFICADOR_REFERENCIA = 1, IDENTIFICADOR_REFERENCIA_EAN13 = 2;
    const IMPRIMIR_DESEADO = 0, IMPRIMIR_ACTUAL = 1;
    const PLANTILLA_ALTERNATIVAMENTE = 0, PLANTILLA_COMODINES = 1, PLANTILLA_PARTES = 2;
    
    public function __construct() {
        $this->name = 'imaximprimepedidosservidor';
        $this->tab = 'administration';
        $this->version = '3.88';
        $this->author = 'Informax';
        $this->need_instance = 0;
        $this->bootstrap = false;
        $this->ps_versions_compliancy = ['min' => '1.6.0.0', 'max' => _PS_VERSION_];

        parent::__construct();
        $this->displayName = $this->l('Gestion de pedidos de venta y compra servidor');
        $this->description = $this->l('Servidor para el programa imprime pedidos');
        $this->idManual = '0';
        $this->forceCheck = 0;
        $this->sufijo = self::prefijo;
        $this->idShop = $this->context->shop->id;
        $this->idLang = $this->context->language->id;
        if (version_compare(_PS_VERSION_, '8.0.0.0 ', '>=')) {
            $this->versionPS = 18;
        } 
        elseif (version_compare(_PS_VERSION_, '1.7.6.0 ', '>=')) {
            $this->versionPS = 17.6;
        } 
        elseif (version_compare(_PS_VERSION_, '1.7.0.0 ', '>=')) {
            $this->versionPS = 17;
        } 
        elseif (version_compare(_PS_VERSION_, '1.6.0.0 ', '>=')) {
            $this->versionPS = 16;
        }
        
        if (Configuration::getGlobalValue(self::prefijo . 'LICENCIA') == '') {
            $this->warning[] = $this->l('La licencia no es valida. Es necesario configurar correctamente la licencia para usar este modulo');
        }
        
        if(defined('_PS_ADMIN_DIR_') && _PS_ADMIN_DIR_) {
            Configuration::updateGlobalValue(self::prefijo . 'ADMIN', _PS_ADMIN_DIR_);            
        }
    }
    
    public function install() {
        include(dirname(__FILE__) . '/configuration.php');
        foreach ($configuracion AS $indice => $valor) {
            if (!Configuration::updateGlobalValue($indice, $valor)) {
                return false;
            }
        }

        if (!parent::install()) {
            return false;
        }

        foreach ($hooks as $hook) {
            if (!$this->registerHook($hook)) {
                $this->_errors[] = $this->l('Ha fallado la instalacion del hook:') . ' ' . $hook;
                return false;
            }
        }

        if (!$this->installTab()) {
            $this->_errors[] = $this->l('Error al instalar el tab');
            return false;
        } 

        include(dirname(__FILE__) . '/sql-install.php');
        foreach ($sql as $s) {
            if (!Db::getInstance()->execute($s)) {
                $this->_errors[] = $this->l('Ha fallado la consulta:') . ' ' . $s;
                return false;
            }
        }

        if(Module::isEnabled('gestavdstock')) {
            Db::getInstance()->execute("ALTER TABLE `" . _DB_PREFIX_ . "stock_available_advanced` ADD INDEX (`id_product`, `id_product_attribute`);");
        }

        $token = md5(uniqid());
        if (!Configuration::updateGlobalValue(self::prefijo . 'TOKEN_CRON', $token)) {
            $this->_errors[] = $this->l('Se ha producido un error al crear el cron');
            return false;
        }

        $this->marcarTodoDescargado();
        $directorioAdmin = getcwd();

        if (!@copy(dirname(__FILE__) . '/' . $this->name . '_cron.php', $directorioAdmin . '/' . $this->name . '_cron.php')) {
            $this->_errors[] = $this->l('Se ha producido un error al copiar el archivo de cron general a la carpeta de administracion');
            return false;
        }
        if (is_file(dirname(__FILE__) . '/' . $this->name . '_cron.php.imax') && !@copy(dirname(__FILE__) . '/' . $this->name . '_cron.php.imax', $directorioAdmin . '/' . $this->name . '_cron.php.imax')) {
            $this->_errors[] = $this->l('Se ha producido un error al copiar el archivo de cron ofuscado a la carpeta de administracion');
            return false;
        }

        //Acceso pda
        $meta = new Meta();
        $meta->configurable = 1;
        $meta->description = 'Ayuda a montar los pedidos';
        $meta->keywords = 'pda';
        $meta->page = 'module-imaximprimepedidosservidor-pda';
        $meta->title = 'PDA';
        $meta->url_rewrite = 'pda';
        $meta->add();

        if(class_exists('Theme')) {
            $plantillas = Theme::getThemes();
            foreach ($plantillas as $plantilla) {
                Db::getInstance()->execute('
              INSERT IGNORE INTO `' . _DB_PREFIX_ . "theme_meta` (id_theme, id_meta, left_column, right_column)
              VALUES ('$plantilla->id', '{$meta->id}', '$plantilla->default_left_column', '$plantilla->default_right_column')");
            }
        }

        //Acceso pda entrada
        $meta = new Meta();
        $meta->configurable = 1;
        $meta->description = 'Para hacer el picking';
        $meta->keywords = 'pda entrada';
        $meta->page = 'module-imaximprimepedidosservidor-pdaentrada';
        $meta->title = 'PDA entrada';
        $meta->url_rewrite = 'pda_entrada';
        $meta->add();

        if(class_exists('Theme')) {
            $plantillas = Theme::getThemes();
            foreach ($plantillas as $plantilla) {
                Db::getInstance()->execute('
              INSERT IGNORE INTO `' . _DB_PREFIX_ . "theme_meta` (id_theme, id_meta, left_column, right_column)
              VALUES ('$plantilla->id', '{$meta->id}', '$plantilla->default_left_column', '$plantilla->default_right_column')");
            }
        }
        
        //Acceso menu
        $meta = new Meta();
        $meta->configurable = 1;
        $meta->description = 'Menu PDA';
        $meta->keywords = 'menu';
        $meta->page = 'module-imaximprimepedidosservidor-menu';
        $meta->title = 'Menu PDA';
        $meta->url_rewrite = 'menu';
        $meta->add();

        if(class_exists('Theme')) {
            $plantillas = Theme::getThemes();
            foreach ($plantillas as $plantilla) {
                Db::getInstance()->execute('
              INSERT IGNORE INTO `' . _DB_PREFIX_ . "theme_meta` (id_theme, id_meta, left_column, right_column)
              VALUES ('$plantilla->id', '{$meta->id}', '$plantilla->default_left_column', '$plantilla->default_right_column')");
            }
        }
        
        //Detectamos si es DBarrio
        $tablaOrders = Db::getInstance()->executeS('DESCRIBE `'._DB_PREFIX_.'orders`');
        foreach($tablaOrders as $columnaOrders) {
            if($columnaOrders['Field'] == 'id_seller') {
                Configuration::updateGlobalValue(self::prefijo.'DBarrio', true);
                Configuration::updateGlobalValue(self::prefijo.'NO_PEDIDOS_SIN_EMAIL_PASS', true);
                break;
            }
        }
        
        $this->almacenarFormasDePagoUsadas($this->escanearFormasDePagoUsadas());

        return true;
    }

    public function uninstall() {
        if (!parent::uninstall()) {
            return false;
        }

        include(dirname(__FILE__) . '/sql-unninstall.php');
        foreach ($sql as $s) {
            if (!Db::getInstance()->execute($s)) {
                return false;
            }
        }

        if (!$this->uninstallTab()) {
            $this->_errors[] = $this->l('Error al eliminar el tab');
            return false;
        }

        //Deshacer redireccion hacia pda
        $idMeta = Db::getInstance()->getValue('SELECT id_meta FROM `' . _DB_PREFIX_ . 'meta` WHERE page = "module-imaximprimepedidosservidor-pda"');
        if ($idMeta) {
            Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . "meta` WHERE id_meta = '$idMeta'");
            Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . "meta_lang` WHERE id_meta = '$idMeta'");
            if(class_exists('Theme')) {
                Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . "theme_meta` WHERE id_meta = '$idMeta'");
            }
        }
        $idMetaEntrada = Db::getInstance()->getValue('SELECT id_meta FROM `' . _DB_PREFIX_ . 'meta` WHERE page = "module-imaximprimepedidosservidor-pdaentrada"');
        if ($idMetaEntrada) {
            Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . "meta` WHERE id_meta = '$idMetaEntrada'");
            Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . "meta_lang` WHERE id_meta = '$idMetaEntrada'");
            if(class_exists('Theme')) {
                Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . "theme_meta` WHERE id_meta = '$idMetaEntrada'");
            }
        }

        return true;
    }

    /** FUNCIONES PRINCIPALES * */
    private function _postProcess() {
        $accion = Tools::getValue('action');
        $error = 0;
        $html = '';
        switch ($accion) {
            case 'guardarDatos':
                $error = FALSE;
                $passAcesoRemoto = Tools::getValue('passAcesoRemoto');
                $passEconomico = Tools::getValue('passEconomico');
                $passConfiguracion = Tools::getValue('passConfiguracion');
                $passEdicion = Tools::getValue('passEdicion');

                if ($passAcesoRemoto) {
                    if (!Configuration::updateGlobalValue(self::prefijo . 'PASS', $passAcesoRemoto)) {
                        $error = TRUE;
                    }
                }

                if ($passEconomico) {
                    if (!Configuration::updateGlobalValue(self::prefijo . 'PASS_ECONOMICO', $passEconomico)) {
                        $error = TRUE;
                    }
                }

                if ($passConfiguracion) {
                    if (!Configuration::updateGlobalValue(self::prefijo . 'PASS_CONFIGURACION', $passConfiguracion)) {
                        $error = TRUE;
                    }
                }

                if ($passEdicion) {
                    if (!Configuration::updateGlobalValue(self::prefijo . 'PASS_EDICION', $passEdicion)) {
                        $error = TRUE;
                    }
                }

                if ($error) {
                    $this->_html .= $this->displayError($this->l('Ha ocurrido un error.'));
                } else {
                    $this->_html .= $this->displayConfirmation($this->l('Configuración guardada correctamente.'));
                }
                break;
                
            case 'configurar':
                $centralizador = new CentralizadorEtiquetas($this);
                if($centralizador->grabarConfiguracion(Tools::getAllValues())) {
                    $this->_html .= $this->displayConfirmation($this->l('Configuración guardada correctamente.'));
                } 
                else {
                    $this->_html .= $this->displayError($this->l('Ha ocurrido un error.'));
                }
                break;
                
            case 'otras':
                $estadosDescartados = Tools::getValue('estadosDescartados', array());
                $estados = Tools::getValue('estados', array());
                $estadosFastPrinting = Tools::getValue('estadosFastPrinting', array());
                $estadosNoCambiar = Tools::getValue('estadosNoCambiar', array());
                $informacionAdicional = Tools::getValue('informacionAdicional', 0);
                $estadoImpresoPedido = Tools::getValue('estadoImpresoPedido', 0);
                $usarLocales = Tools::getValue('usarLocales', 0);
                $comprobarDireccion = Tools::getValue('comprobarDireccion', 0);
                $noPedidosSinEmailPass = Tools::getValue('noPedidosSinEmailPass', 0);
                $nuevoEstadoNoCambiar = Tools::getValue('nuevoEstadoNoCambiar', 0);
                $localesVisibles = Tools::getValue('localesVisibles', array());
                if (!Configuration::updateGlobalValue(self::prefijo . 'INCIDENCIA', serialize($estados)) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'DESCARTADO', serialize($estadosDescartados)) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'ESTADOS_FAST_PRINTING', serialize($estadosFastPrinting)) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'ESTADOS_NO_CAMBIAR', serialize($estadosNoCambiar)) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'NUEVO_ESTADO_NO_CAMBIAR', $nuevoEstadoNoCambiar) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'COD_SPARTOO', trim(Tools::getValue('partenaire'))) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'INFO_ADICIONAL', $informacionAdicional) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'USAR_LOCALES', $usarLocales) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'COMPROBAR_DIRECCION', $comprobarDireccion) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'NO_PEDIDOS_SIN_EMAIL_PASS', $noPedidosSinEmailPass) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'LOCALES_VISIBLES', serialize($localesVisibles)) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'ESTADO_IMPRESO_PEDIDO', $estadoImpresoPedido)) {
                    $this->_html .= $this->displayError($this->l('Ha ocurrido un error.'));
                } else {
                    $this->_html .= $this->displayConfirmation($this->l('Configuración guardada correctamente.'));
                }
                break;

            case 'pickingOUT':
                $agregarManual = Tools::getValue('agregarManual', 0);
                $finalizarIncompletos = Tools::getValue('finalizarIncompletos', 0);
                $pedidosIncompletos = Tools::getValue('pedidosIncompletos', 0);
                $devolucionIncompletos = Tools::getValue('devolucionIncompletos', 0);
                $identificadorPedido = Tools::getValue('identificadorPedido', 0);
                $mostrarFiltroFecha = Tools::getValue('mostrarFiltroFecha', 0);
                $mostrarFiltroFormaPago = Tools::getValue('mostrarFiltroFormaPago', 0);
                $mostrarFiltroTransportista = Tools::getValue('mostrarFiltroTransportista', 0);
                $solicitarLectura = Tools::getValue('solicitarLectura', 0);
                $visorReducido = Tools::getValue('visorReducido', 0);
                $packsIndivisibles = Tools::getValue('packsIndivisibles', 0);
                $selectReferencia = Tools::getValue('selectReferencia', 0);
                $mostrarUbicacionPDA = Tools::getValue('mostrarUbicacionPDA', 0);
                $mostrarFabricantePDA = Tools::getValue('mostrarFabricantePDA', 0);
                $origenUbicacionPDA = Tools::getValue('origenUbicacionPDA', 0);
                $mostrarReferenciaPDA = Tools::getValue('mostrarReferenciaPDA', 0);
                $todosEmpleadosPDA = Tools::getValue('todosEmpleadosPDA', 0);
                $mostrarCantidadRestantePDA = Tools::getValue('mostrarCantidadRestantePDA', 0);
                $usarCantidadFisicaPDA = Tools::getValue('usarCantidadFisicaPDA', 0);
                $unaSolaPaginaPDA = Tools::getValue('unaSolaPaginaPDA', 0);
                $noPedidosSinStockPDA = Tools::getValue('noPedidosSinStockPDA', 0);
                $indicarSinStockPDA = Tools::getValue('indicarSinStockPDA', 0);
                $permitirReemplazarPDA = Tools::getValue('permitirReemplazarPDA', 0);
                $eanExtendidoPDA = Tools::getValue('eanExtendidoPDA', 0);
                $ajustarReemplazarPDA = Tools::getValue('ajustarReemplazarPDA', 0);
                $mostrarFlotantePDA = Tools::getValue('mostrarFlotantePDA', 0);
                $simboloMultiplicadorPDA = trim(Tools::getValue('simboloMultiplicadorPDA', '*'));
                $estadosPendientesMontar = Tools::getValue('estadosMontablesPDA', array());
                $resultadoPendientes = Db::getInstance()->execute('TRUNCATE TABLE `' . _DB_PREFIX_ . self::prefijo . 'estadoMontable`');
                if ($estadosPendientesMontar) {
                    foreach ($estadosPendientesMontar as $id_employee => $estadoPendienteMontar) {
                        $id_employee = (int)$id_employee;
                        $sql = 'INSERT INTO `' . _DB_PREFIX_ . self::prefijo . 'estadoMontable` (idEstadoPedido, id_employee) VALUES ';
                        foreach($estadoPendienteMontar as $estado) {
                            $estado = (int)$estado;
                            $sql .= "($estado, $id_employee),";
                        }
                        $resultadoPendientes = Db::getInstance()->execute(mb_substr($sql, 0, -1));
                    }
                }
                $ordenacionPedidosPorPDA = Tools::getValue('ordenacionPedidosPorPDA', array());
                $ordenacionPedidosPDA = Tools::getValue('ordenacionPedidosPDA');
                $emailAvisosPDA = Tools::getValue('emailAvisosPDA');
                $textoTiendasPDA = serialize(Tools::getValue('textoTiendasPDA', array()));
                $colorZonaPDA = serialize(Tools::getValue('colorZonaPDA', array()));
                $empleadosPuedenEliminar = serialize(Tools::getValue('empleadosPuedenEliminar', array()));
                $estadoSinTerminarPDA = Tools::getValue('estadoSinTerminarPDA', 0);
                $aspectoAlternativoPDA = Tools::getValue('aspectoAlternativoPDA', 0);
                $nomenStockWeb = Tools::getValue('nomenStockWeb', 0);
                $almacenEntradaGeneral = Tools::getValue('almacenEntradaGeneral', 0);
                $formasFinalizarPedido = Tools::getValue('formasFinalizarPedido', array());
                $mostrarBotonImprimir = Tools::getValue('mostrarBotonImprimir', 0);
                $opcionesImprimir = Tools::getValue('opcionesImprimir', array());
                $opcionesFinalizar = Tools::getValue('opcionesFinalizar', array());
                $pedirBultosFinalizar = Tools::getValue('pedirBultosFinalizar', 0);
                $filtroEstadosPDA = Tools::getValue('filtroEstadosPDA', 0);
                $mostraCP = Tools::getValue('mostraCP', 0);
                $productosNoPicking = array_unique(explode(',', Tools::getValue('productosNoPicking')));
                if (!Configuration::updateGlobalValue(self::prefijo . 'AGREGAR_MANUAL', $agregarManual) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'FINALIZAR_INCOMPLETOS', $finalizarIncompletos) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'PEDIDOS_INCOMPLETOS', $pedidosIncompletos) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'DEVOLUCION_INCOMPLETOS', $devolucionIncompletos) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'IDENTIFICADOR_PEDIDO', $identificadorPedido) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'FILTRO_FECHA', $mostrarFiltroFecha) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'FILTRO_FORMA_PAGO', $mostrarFiltroFormaPago) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'FILTRO_TRANSPORTISTA', $mostrarFiltroTransportista) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'SOLICITAR_LECTURA', $solicitarLectura) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'VISOR_REDUCIDO', $visorReducido) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'PACKS_INDIVISIBLES', $packsIndivisibles) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'IDENTIFICADOR_SALIDA', $selectReferencia) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'MOSTRAR_UBI_PDA', $mostrarUbicacionPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'MOSTRAR_FABRICANTE_PDA', $mostrarFabricantePDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'ORIGEN_UBI_PDA', $origenUbicacionPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'MOSTRAR_REF_PDA', $mostrarReferenciaPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'TODOS_EMPLEADOS_PDA', $todosEmpleadosPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'MOSTRAR_RESTANTE_PDA', $mostrarCantidadRestantePDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'USAR_CANTIDAD_FISICA_PDA', $usarCantidadFisicaPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'UNA_SOLA_PAGINA_PDA', $unaSolaPaginaPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'NO_PEDIDOS_SIN_STOCK_PDA', $noPedidosSinStockPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'INDICAR_SIN_STOCK_PDA', $indicarSinStockPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'PERMITIR_REEMPLAZAR_PDA', $permitirReemplazarPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'AJUSTAR_REEMPLAZAR_PDA', $ajustarReemplazarPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'MOSTRAR_FLOTANTE_PDA', $mostrarFlotantePDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'ASPECTO_ALTERNATIVO_PDA', $aspectoAlternativoPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'NOMEN_STOCK_WEB', $nomenStockWeb) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'FORMAS_FINALIZAR_PEDIDO', serialize($formasFinalizarPedido)) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'MOSTRAR_BOTON_IMPRIMIR', $mostrarBotonImprimir) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'OPCIONES_IMPRIMIR', serialize($opcionesImprimir)) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'OPCIONES_FINALIZAR', serialize($opcionesFinalizar)) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'PEDIR_BULTOS_FINALIZAR', $pedirBultosFinalizar) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'SIMBOLO_MULTIPLICADOR_PDA', $simboloMultiplicadorPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'ORDENACION_PEDIDOS_POR_PDA', $ordenacionPedidosPorPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'ORDENACION_PEDIDOS_PDA', $ordenacionPedidosPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'EMAIL_AVISOS_PDA', $emailAvisosPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'EAN_EXTENDIDO_PDA', $eanExtendidoPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'ESTADO_MONTADO', (int) Tools::getValue('estadoMontado')) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'ESTADO_INCOMPLETO', (int) Tools::getValue('estadoIncompletoPDA')) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'TEXTO_TIENDAS_PDA', $textoTiendasPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'COLOR_ZONA_PDA', $colorZonaPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'FILTRO_ESTADO_PDA', $filtroEstadosPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'MOSTRAR_CP', $mostraCP) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'ESTADO_SIN_TERMINAR_PDA', $estadoSinTerminarPDA) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'EMPLEADOS_PUEDEN_ELIMINAR', $empleadosPuedenEliminar) ||
                        !Configuration::updateGlobalValue(self::prefijo . 'PRODUCTOS_NO_PICKING', json_encode($productosNoPicking)) ||
                        !$resultadoPendientes) {
                    $this->_html .= $this->displayError($this->l('Ha ocurrido un error.'));
                } else {
                    $this->_html .= $this->displayConfirmation($this->l('Configuración guardada correctamente.'));
                }
                break;
            case 'pickingIN':
                $agregarManualEntrada = Tools::getValue('agregarManualEntrada', 0);
                $imprimirCantidadEtiquetas = Tools::getValue('imprimirCantidadEtiquetas', 0);
                $mostrarFiltroFechaEntrada = Tools::getValue('mostrarFiltroFechaEntrada', 0);
                $razonMvtEntrada = Tools::getValue('razonMvtEntrada', 0);
                $mostrarRefProduct = Tools::getValue('mostrarRefProduct', 0);
                $simboloMultiplicadorPDAEntrada = Tools::getValue('simboloMultiplicadorPDAEntrada', 0);
                $almacenEntradaGeneral = Tools::getValue('almacenEntradaGeneral', 0);
                if (!Configuration::updateGlobalValue(self::prefijo . 'AGREGAR_MANUAL_ENTRADA', $agregarManualEntrada) ||
                    !Configuration::updateGlobalValue(self::prefijo . 'IMPRIMIR_CANTIDAD_ETIQUETAS', $imprimirCantidadEtiquetas) ||
                    !Configuration::updateGlobalValue(self::prefijo . 'FILTRO_FECHA_ENTRADA', $mostrarFiltroFechaEntrada) ||
                    !Configuration::updateGlobalValue(self::prefijo . 'RAZON_MVT_ENTRADA', $razonMvtEntrada) ||
                    !Configuration::updateGlobalValue(self::prefijo . 'MOSTRAR_REF_PRODUCT', $mostrarRefProduct) ||
                    !Configuration::updateGlobalValue(self::prefijo . 'SIMBOLO_MULTIPLICADOR_PDA_ENTRADA', $simboloMultiplicadorPDAEntrada) ||
                    !Configuration::updateGlobalValue(self::prefijo . 'ALMACEN_ENTRADA_GENERAL', $almacenEntradaGeneral)
                    ) {
                    $this->_html .= $this->displayError($this->l('Ha ocurrido un error.'));
                } else {
                    $file_import = dirname(__FILE__) . '/import/' . $_FILES['file']['name'] . '.' . date('Ymdhis') . '.csv';
                    
                    if (move_uploaded_file($_FILES['file']['tmp_name'], $file_import)) {
                        require_once dirname(__FILE__).'/clases/accesoDatos/iAccesoDatos.php';
                        switch (ImaxImprimePedidosServidor::detectarTipoArchivo($file_import)) {
                            case ImaxImprimePedidosServidor::ARCHIVO_CSV:
                                require_once dirname(__FILE__).'/clases/accesoDatos/AccesoDatosCSV.php';
                                $acceso = new clases\accesoDatos\AccesoDatosCSV($file_import, 0, 1, ';');
                                break;
                            
                            case ImaxImprimePedidosServidor::ARCHIVO_EXCEL:
                                require_once dirname(__FILE__).'/clases/accesoDatos/AccesoDatosExcel.php';
                                require_once dirname(__FILE__).'/clases/accesoDatos/ChunkReadFilter.php';
                                $acceso = new clases\accesoDatos\AccesoDatosExcel($file_import, 0, 32768, 1);
                                break;
                            
                            default:
                                require_once dirname(__FILE__).'/clases/accesoDatos/AccesoDatosCSV.php';
                                $acceso = new clases\accesoDatos\AccesoDatosCSV($file_import, 0, 1, ';');
                                break;
                        }
                        while (($data = $acceso->obtenerFila()) !== FALSE) {
                            // Referencia del producto o combinación
                            $reference = $data[2];
                            
                            // Inicializar los IDs
                            $id_product = $this->getProductIdByReference($reference);
                            $id_product_attribute = $this->getProductAttributeIdByReference($reference);
                        
                            // Si no hay id_product_attribute, es una referencia de producto
                            if (!$id_product_attribute) {
                                $id_product = $this->getProductIdByReference($reference);
                                $id_product_attribute = 0; // No hay combinación
                            } else {
                                // Obtener id_product a partir del id_product_attribute
                                $id_product = Db::getInstance()->getValue('SELECT id_product FROM ' . _DB_PREFIX_ . 'product_attribute WHERE id_product_attribute = ' . (int)$id_product_attribute);
                            }
                        
                            // Convertir los valores de imprimirEtiquetaProducto e imprimirUnaEtiqueta a booleanos
                            $imprimirEtiquetaProducto = (bool)$data[4];
                            $imprimirUnaEtiqueta = (bool)$data[5];
                            
                            // Grabar los datos en la base de datos
                            $this->grabarImprimirEtiqueta($id_product, $id_product_attribute, $imprimirEtiquetaProducto, $imprimirUnaEtiqueta);
                        }
                        
                    }
                    $this->_html .= $this->displayConfirmation($this->l('Configuración guardada correctamente.'));
                }
                break;
            case 'amazon':
                if (Configuration::updateGlobalValue(self::prefijo . 'AMA_KEY', trim(Tools::getValue('amazon_key'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'AMA_SEC', trim(Tools::getValue('amazon_secret'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'CREAR_AMA', (int) Tools::getValue('crearAmazon')) &&
                        Configuration::updateGlobalValue(self::prefijo . 'PRO_AMA', (int) Tools::getValue('prod_amazon')) &&
                        Configuration::updateGlobalValue(self::prefijo . 'TIP_PRE_PRO_AMA', (int) Tools::getValue('preciooferta_id')) &&
                        Configuration::updateGlobalValue(self::prefijo . 'AMA_AI', trim(Tools::getValue('amazon_associateId'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'AMA_CI', trim(Tools::getValue('amazon_country_id')))) {
                    $this->_html .= $this->displayConfirmation($this->l('Configuracion guardada correctamente.'));
                } else {
                    $this->_html .= $this->displayError($this->l('Ha ocurrido un error al guardar la configuracion'));
                }
                break;
            case 'configuracionSerialNumber':
                if (Configuration::updateGlobalValue(self::prefijo . 'PLANTILLA', trim(Tools::getValue('plantilla'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'MULTIPLICADOR_SERIE_PRODUCTOS', trim(Tools::getValue('multiplicadorSerieProductos'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'ACT_NOM_SER', trim(Tools::getValue('actNumSerie'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'MODO_PLANTILLA', trim(Tools::getValue('modoPlantilla'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'SEPARADOR_PLANTILLA', trim(Tools::getValue('separadorPlantilla'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'SEPARADOR_PLANTILLA_ALTERNATIVAMENTE', trim(Tools::getValue('separadorPlantillaAlternativamente'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'CONSERVAR_SEPARADOR', trim(Tools::getValue('conservarSeparador'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'CONSERVAR_SEPARADOR_ALTERNATIVAMENTE', trim(Tools::getValue('conservarSeparadorAlternativamente'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'PARTES_PLANTILLA', trim(Tools::getValue('partesPlantilla'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'PARTES_PLANTILLA_LOTE', trim(Tools::getValue('partesPlantillaLote'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'PARTES_PLANTILLA_LOTE_ALTERNATIVAMENTE', trim(Tools::getValue('partesPlantillaLoteAlternativamente'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'DELUXE_TRACKING', trim(Tools::getValue('deluxeTracking'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'SELECTOR_GRUPOS', trim(Tools::getValue('selectorGrupos'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'NSERIE_FACTURA', trim(Tools::getValue('agregarNumerosSerieFactura'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'NOM_SER', trim(Tools::getValue('nombreCampoNumSerie')))) {
                    $idxrTracking = Module::getInstanceByName('idxrtracking'); //Antes deluxetracking
                    if($idxrTracking) {
                        if(trim(Tools::getValue('deluxeTracking'))) {
                            //Quitamos al modulo de innova deluxe tracking de los hooks
                            $idxrTracking->unregisterHook('actionOrderStatusPostUpdate');
                        }
                        else {
                            //Los reinstauramos
                            $idxrTracking->registerHook('actionOrderStatusPostUpdate');
                        }
                    }

                    $this->_html .= $this->displayConfirmation($this->l('Configuracion guardada correctamente.'));
                }
                else {
                    $this->_html .= $this->displayError($this->l('Ha ocurrido un error al guardar la configuracion'));
                }
                break;
            case 'generarToken':
                $token = md5(uniqid());
                if (Configuration::updateGlobalValue(self::prefijo . 'TOKEN_CRON', $token)) {
                    $this->_html .= $this->displayConfirmation($this->l('Token generado correctamente'));
                } else {
                    $this->_html .= $this->displayError($this->l('Ha ocurrido un error al generar el token'));
                }
                break;
            case 'importarUbicaciones':
                if(isset($_FILES['ubicaciones']) && $_FILES['ubicaciones']['error']  == UPLOAD_ERR_OK) {
                    //Guardamos copia
                    copy($_FILES['ubicaciones']['tmp_name'], __DIR__.'/import/importar_ubicaciones_'.date('Y_m_d_H_i_s').'.csv');
                    
                    $total = 0;
                    $correctos = 0;
                    
                    $h = fopen($_FILES['ubicaciones']['tmp_name'], 'r');
                    while(($fila = fgetcsv($h, 0, ';'))) {
                        $referencia = pSQL(trim($fila[0]));
                        if($referencia) {
                            $idProducto = Db::getInstance()->getRow('SELECT id_product, id_product_attribute FROM `'._DB_PREFIX_."product_attribute` WHERE reference = '$referencia'");
                            if(!$idProducto) {
                                $idProducto = Db::getInstance()->getRow('SELECT id_product, 0 as id_product_attribute FROM `'._DB_PREFIX_."product` WHERE reference = '$referencia'");
                            }

                            if($idProducto) {
                                if($this->grabarExtraProducto($idProducto['id_product'], $fila[1], $idProducto['id_product_attribute'])) {
                                    $correctos++;
                                }
                            }
                        }
                        
                        $total++;
                    }
                    fclose($h);
                    
                    $this->_html .= $this->displayConfirmation($this->l('Se han procesado').' '.$correctos.' '.$this->l('de').' '.$total);
                }
                else {
                    $this->_html .= $this->displayError($this->l('Ha ocurrido un error al subir el archivo.'));
                }
                break;
            case 'exportarUbicaciones':           
                if(isset($_FILES['referencias']) && $_FILES['referencias']['error']  == UPLOAD_ERR_OK) {
                    $lineas = array();
                    
                    $h = fopen($_FILES['referencias']['tmp_name'], 'r');
                    while(($fila = fgetcsv($h, 0, ';'))) {
                        $referencia = pSQL(trim($fila[0]));
                        
                        $idProducto = Db::getInstance()->getRow('SELECT id_product, id_product_attribute FROM `'._DB_PREFIX_."product_attribute` WHERE reference = '$referencia'");
                        if(!$idProducto) {
                            $idProducto = Db::getInstance()->getRow('SELECT id_product, 0 as id_product_attribute FROM `'._DB_PREFIX_."product` WHERE reference = '$referencia'");
                        }
                        
                        if($idProducto) {
                            $ubicacion = $this->cargarExtraProducto($idProducto['id_product'], $idProducto['id_product_attribute']);
                            $lineas[] = trim($fila[0]).';'.trim($ubicacion['ubicacion']);
                        }
                    }
                    fclose($h);
                    
                    if($lineas) {
                        //Mandamos el fichero
                        $datos = implode("\n", $lineas);
                        
                        if(ob_get_length()) {
                            ob_clean();
                        }
                        header('Content-Type: application/x-download');
                        header('Content-Length: '.strlen($datos));
                        header('Content-Disposition: attachment; filename="ubicaciones.csv"');
                        header('Cache-Control: private, max-age=0, must-revalidate');
                        header('Pragma: public');
                        echo $datos;
                        exit;
                    }
                    else {
                        $this->_html .= $this->displayError($this->l('Ha ocurrido un error al generar el archivo.'));
                    }
                }
                else {
                    $this->_html .= $this->displayError($this->l('Ha ocurrido un error al subir el archivo.'));
                }
                break;
            case 'exportarReferencias':
                $lineas = Db::getInstance()->executeS('
                    SELECT IF(pa.id_product_attribute IS NOT NULL AND pa.id_product_attribute != 0, pa.reference, p.reference) reference, ep.ubicacion, p.id_product, pa.id_product_attribute FROM `'._DB_PREFIX_.'product` p 
                        LEFT JOIN `'._DB_PREFIX_.'product_attribute` pa ON p.id_product = pa.id_product
                        LEFT JOIN `'._DB_PREFIX_.self::prefijo.'extraProducto` ep ON p.id_product = ep.id_product AND (pa.id_product_attribute = ep.id_product_attribute OR (pa.id_product_attribute IS NULL AND ep.id_product_attribute = 0))');
                
                //Mandamos el fichero
                if(ob_get_length()) {
                    ob_clean();
                }
                header('Content-Type: application/x-download');
                header('Content-Disposition: attachment; filename="referencias.csv"');
                header('Cache-Control: private, max-age=0, must-revalidate');
                header('Pragma: public');
                $fp = fopen('php://output', 'w');
                foreach($lineas as $linea) {
                    if($linea['reference']) {
                        $linea['name'] = Product::getProductName($linea['id_product'], $linea['id_product_attribute']);
                        fputcsv($fp, $linea, ';');
                    }
                }
                fclose($fp);
                exit;
                break;
            case 'configuracionDatosDefecto':
                if (Configuration::updateGlobalValue(self::prefijo . 'CATEGORIAS', trim(Tools::getValue('categoria'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'NOM_PRO_DEFECTO', trim(Tools::getValue('nom_producto'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'PRECIO_PRO_DEFECTO', (int) Tools::getValue('pre_producto')) &&
                        Configuration::updateGlobalValue(self::prefijo . 'COSTE_PRO_DEFECTO', (int) Tools::getValue('cos_producto')) &&
                        Configuration::updateGlobalValue(self::prefijo . 'STOCK_PRO_DEFECTO', (int) Tools::getValue('stock_producto')) &&
                        Configuration::updateGlobalValue(self::prefijo . 'SUPPLI_PRODUCTO', (int) Tools::getValue('suppli_producto')) &&
                        Configuration::updateGlobalValue(self::prefijo . 'IMP_PRODUCTO', (int) Tools::getValue('imp_producto')) &&
                        Configuration::updateGlobalValue(self::prefijo . 'EN_CONTROLADOR', Tools::getValue('enControlador')) &&
                        Configuration::updateGlobalValue(self::prefijo . 'CREAR', (int) Tools::getValue('crear')) &&
                        Configuration::updateGlobalValue(self::prefijo . 'CREAR_PRODUCTOS', Tools::getValue('crearProductos'))
                        ) {
                    $html .= $this->displayConfirmation($this->l('Configuracion guardada correctamente.'));
                }
                else {
                    $html .= $this->displayError($this->l('Ha ocurrido un error al guardar la configuracion'));
                }
                break;
            case 'resetear':
                $this->marcarTodoDescargado();
                break;
            case 'gestionLicencia':
                $licencia = Tools::getValue('licencia');
                if (Configuration::updateGlobalValue(self::prefijo . 'LICENCIA', $licencia)) {
                    $this->_html .= $this->displayConfirmation('Licencia guardada correctamente');
                } else {
                    $this->_html .= $this->displayError('Ha ocurrido un error al guardar la licencia');
                }
                $this->forceCheck = 1;
                break;
            case 'plantillas':
                $plantillaCorreoOrdinario = serialize(Tools::getValue('plantillaCorreoOrdinario'));
                $plantillaCorreoCertificado = serialize(Tools::getValue('plantillaCorreoCertificado'));
                $plantillaGenerica = serialize(Tools::getValue('plantillaGenerica'));
                $plantillaPedido = serialize(Tools::getValue('plantillaPedido'));
                $plantillaFactura = serialize(Tools::getValue('plantillaFactura'));
                $ponerCodigo = Tools::getValue('ponerCodigo');
                if (Configuration::updateGlobalValue(self::prefijo . 'PLANTILLA_CORREO_ORDINARIO', $plantillaCorreoOrdinario) && 
                        Configuration::updateGlobalValue(self::prefijo . 'PLANTILLA_CORREO_CERTIFICADO', $plantillaCorreoCertificado) && 
                        Configuration::updateGlobalValue(self::prefijo . 'PLANTILLA_GENERICA', $plantillaGenerica) && 
                        Configuration::updateGlobalValue(self::prefijo . 'PLANTILLA_PEDIDO', $plantillaPedido) && 
                        Configuration::updateGlobalValue(self::prefijo . 'PONER_CODIGO', $ponerCodigo) && 
                        Configuration::updateGlobalValue(self::prefijo . 'PLANTILLA_FACTURA', $plantillaFactura)) {
                    $this->_html .= $this->displayConfirmation('Configuracion guardada correctamente');
                } else {
                    $this->_html .= $this->displayError('Ha ocurrido un error al guardar la configuracion');
                }
                $this->forceCheck = 1;
                break;
            case 'renombrarFormasPago':
                $aliasFormasPago = serialize(Tools::getValue('aliasFormasPago', array()));
                if (Configuration::updateGlobalValue(self::prefijo . 'ALIAS_FORMAS_PAGO', $aliasFormasPago)) {
                    $this->_html .= $this->displayConfirmation('Configuracion guardada correctamente');
                } else {
                    $this->_html .= $this->displayError('Ha ocurrido un error al guardar la configuracion');
                }
                break;
            case 'telefonosFalsos':
                $telefonosFalsos = serialize(Tools::getValue('telefonosFalsos', array()));
                if (Configuration::updateGlobalValue(self::prefijo . 'TELEFONOS_FALSOS', $telefonosFalsos)) {
                    $this->_html .= $this->displayConfirmation('Configuracion guardada correctamente');
                } else {
                    $this->_html .= $this->displayError('Ha ocurrido un error al guardar la configuracion');
                }
                break;
            case 'gestionLicenciaAdicional':
                $licenciasAdicionales = Tools::getValue('licenciaAdicional');
                Db::getInstance()->execute('TRUNCATE TABLE `' . _DB_PREFIX_ . self::prefijo . 'licencias`');
                $erroresLicencias = array();
                $error = 0;
                $msg = $this->l('Licencias guardadas correctamente');
                foreach ($licenciasAdicionales AS $nombre => $licencia) {
                    if (trim($licencia) != '') {
                        $sql = 'INSERT INTO `' . _DB_PREFIX_ . self::prefijo . 'licencias` '
                                . ' (nombre, licencia)'
                                . ' VALUES'
                                . ' ("' . $nombre . '","' . $licencia . '")';
                        DB::getInstance()->execute($sql);
                        if (!$this->checkLicenciaAdicional($nombre, $licencia, 1)) {
                            $erroresLicencias[] = $nombre;
                            $error = 1;
                        }
                    }
                }
                if ($error == 1) {
                    $msg = $this->l('Se ha producido un error en los siguientes plugins: ');
                    $sw = 0;
                    foreach ($erroresLicencias AS $errorLicencia) {
                        if ($sw == 0) {
                            $msg .= '<br />' . $errorLicencia;
                            $sw = 1;
                        } else {
                            $msg .= ', ' . $errorLicencia;
                        }
                    }
                    $this->_html .= $this->displayError($msg);
                } else {
                    $this->_html .= $this->displayConfirmation($msg);
                }
                break;
                
            case 'plantillaCaracteristicas':
                $nombreVisibleArray = Tools::getValue('nombreVisible');
                
                Configuration::updateGlobalValue(self::prefijo.'campo_nombreVisible', serialize($nombreVisibleArray));
                $camposCaracteristicas = Tools::getValue('camposCaracteristicas');
                Configuration::updateGlobalValue(self::prefijo.'camposCaracteristicas', $camposCaracteristicas);

                $this->_html .= $this->displayConfirmation($this->l('Se ha guardado la configuracion correctamente.'));
                break;
        }
    }

    private function checkLicencia($force = 0) {
        $data = array();
        $f = Configuration::getGlobalValue(self::prefijo . 'F');
        $check = Configuration::getGlobalValue(self::prefijo . 'F_CHECK');
        $url = Configuration::getGlobalValue(self::prefijo . 'F_SERVER');
        $data['server'] = self::getDomain();
        $data['modulo'] = $this->name;
        $data['action'] = 'checkLicencia';
        $data['licencia'] = Configuration::getGlobalValue(self::prefijo . 'LICENCIA');
        if ($check >= 100 || $force == 1) {
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            $datos = curl_exec($ch);
            $datos = json_decode($datos);
            if (!$datos || $datos->codError != 0) {
                Configuration::updateGlobalValue(self::prefijo . 'F', '');
                Configuration::updateGlobalValue(self::prefijo . 'F_CHECK', (int) $check + 1);
                return false;
            } else {
                Configuration::updateGlobalValue(self::prefijo . 'F', $datos->msgError);
                Configuration::updateGlobalValue(self::prefijo . 'F_CHECK', 0);
                return true;
            }
        } else {
            Configuration::updateGlobalValue(self::prefijo . 'F_CHECK', (int) $check + 1);
            return true;
        }
    }

    public function checkLicenciaAdicional($nombreModulo, $numLicencia, $force = 0) {
        $data = array();
        $check = $this->getCheckLicenciaAdicional($nombreModulo);
        $url = Configuration::getGlobalValue(self::prefijo . 'F_SERVER');
        $data['server'] = self::getDomain();
        $data['modulo'] = $nombreModulo;
        $data['action'] = 'checkLicenciaAdicional';
        $data['licencia'] = $numLicencia;
        if ($check !== false) {
            if ($check >= 100 || $force == 1) {
                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                $datos = curl_exec($ch);
                $datos = json_decode($datos);
                $info = curl_getinfo($ch);
                if (!is_null($datos)) {
                    if ($datos->codError != 0) {
                        $this->updateCheckLicenciaAdicional($nombreModulo, $check + 1);
                        $this->updateValidateLicenciaAdicional($nombreModulo, 0);
                        return false;
                    } else {
                        $this->updateCheckLicenciaAdicional($nombreModulo, 0);
                        $this->updateValidateLicenciaAdicional($nombreModulo, 1);
                        return true;
                    }
                } else {
                    $this->updateCheckLicenciaAdicional($nombreModulo, $check + 1);
                    $this->updateValidateLicenciaAdicional($nombreModulo, 0);
                    return false;
                }
            } else {
                $this->updateCheckLicenciaAdicional($nombreModulo, $check + 1);
                return true;
            }
        } else {
            return false;
        }
    }

    public static function getDomain() {
        $idShopDefault = Configuration::getGlobalValue('PS_SHOP_DEFAULT');
        $tienda = new Shop($idShopDefault);
        if (Validate::isLoadedObject($tienda)) {
            if (isset($tienda->domain)) {
                return $tienda->domain;
            }
        }
        return false;
    }

    private function getOtrasLicencias() {
        $sql = 'SELECT * FROM ' . _DB_PREFIX_ . self::prefijo . 'licencias';
        return Db::getInstance()->executeS($sql);
    }

    public function getLicenciaAdicional($nombreModulo, $validada = true) {
        $sql = 'SELECT licencia FROM `' . _DB_PREFIX_ . self::prefijo . 'licencias`'
                . ' WHERE '
                . ' nombre = "' . trim($nombreModulo) . '"' . ($validada ? ' AND validate = 1' : '');
        return DB::getInstance()->getValue($sql);
    }

    private function getCheckLicenciaAdicional($nombreModulo) {
        $sql = 'SELECT numCheck FROM `' . _DB_PREFIX_ . self::prefijo . 'licencias`'
                . ' WHERE '
                . ' nombre = "' . trim($nombreModulo) . '"';
        return DB::getInstance()->getValue($sql);
    }

    private function updateCheckLicenciaAdicional($nombreModulo, $numCheck) {
        $sql = 'UPDATE `' . _DB_PREFIX_ . self::prefijo . 'licencias`'
                . ' SET numCheck=' . $numCheck . ' '
                . ' WHERE nombre="' . $nombreModulo . '"';
        return DB::getInstance()->execute($sql);
    }

    private function updateValidateLicenciaAdicional($nombreModulo, $activo) {
        $sql = 'UPDATE `' . _DB_PREFIX_ . self::prefijo . 'licencias`'
                . ' SET validate=' . $activo . ' '
                . ' WHERE nombre="' . $nombreModulo . '"';
        return DB::getInstance()->execute($sql);
    }

    private function _displayForm() {
        $this->_displayFormExport();
    }
    
    /**
     * Devuelve las cantidades de producto servidas a traves de la pda.
     * @param int $idPedido
     * @return array
     */
    public function obtenerCantidadesServidas($idPedido) {
        $idPedido = (int)$idPedido;
        
        return Db::getInstance()->executeS('SELECT * FROM `'. _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . "servido` WHERE idPedido = '$idPedido'");
    }

    public static function getUrlAdmin() {
        $temp = explode('/', $_SERVER['PHP_SELF']);
        array_pop(($temp));
        $urlAdmin = implode('/', $temp);
        if (Configuration::get('PS_SSL_ENABLED') == 1) {
            $url = 'https://';
        } else {
            $url = 'http://';
        }
        $url .= $_SERVER['SERVER_NAME'] . $urlAdmin . '/';
        return $url;
    }

    private function _displayFormExport() {
        /* FORMULARIO AJAX */
        $urlTienda = self::getUrlAdmin();
        $this->_html .= '<script>'
                . ' var nameModule = "' . $this->name . '"; '
                . ' var url = "' . $urlTienda . '"; '
                . ' var baseUrl = "' . $this->_path . '"; '
                . ' var passRemota = "' . Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS') . '"; '
                . ' var msgEliminarPedidosPendientes = "' . $this->l('Si continúa la tabla de pedidos pendientes se vaciará completamente') . '"; '
                . ' </script>';

        $this->checkLicenciaAdicional('imaximprimepedidosservidorpda', $this->getLicenciaAdicional('imaximprimepedidosservidorpda', FALSE), 0);
        $this->checkLicenciaAdicional('imaximprimepedidosservidorpdaentrada', $this->getLicenciaAdicional('imaximprimepedidosservidorpdaentrada', FALSE), 0);
        $this->checkLicenciaAdicional('imaximprimepedidosservidornumserie', $this->getLicenciaAdicional('imaximprimepedidosservidornumserie', FALSE), 0);
        $this->checkLicenciaAdicional('imaximprimepedidosservidorfastprinting', $this->getLicenciaAdicional('imaximprimepedidosservidorfastprinting', FALSE), 0);

        /* FORMULARIO AJAX VAR JS */
        if (Configuration::getGlobalValue(self::prefijo . 'LICENCIA') == '') {
            $this->_html .= '<div class="bootstrap" style="width:100%">';
            $this->_html .= '<div class="alert alert-warning">';
            $this->_html .= '<p>' . $this->l('ATENCION: SU LICENCIA ESTA VACIA') . '</p>';
            $this->_html .= '<p>' . $this->l('Debe introducir un numero de licencia valido para continuar') . '</p>';
            $this->_html .= '</div>';
            $this->_html .= '</div>';
            $this->_html .= $this->_mostrarLicencia();
            $this->forceCheck = 0;
        } elseif (!self::checkLicencia($this->forceCheck)) {
            $this->_html .= '<div class="bootstrap" style="width:100%">';
            $this->_html .= '<div class="alert alert-warning">';
            $this->_html .= '<p>' . $this->l('ATENCION: SU LICENCIA NO ES VALIDA') . '</p>';
            $this->_html .= '<p>' . $this->l('Si ejecuta el modulo sin licencia los resultados no seran validos') . '</p>';
            $this->_html .= '<p>' . $this->l('Haga esto bajo su responsabilidad, Informax no dara soporte ni aceptar quejas o peticiones derivadas del uso sin licencia de nuestros productos') . '</p>';
            $this->_html .= '<p>' . $this->l('El uso de nuestro software sin licencia constituye una infraccion de las leyes de propiedad intelectual, y sera puesta en conocimiento de las autoridades pertinentes') . '</p>';
            $this->_html .= '<p>' . $this->l('Si cree que este mensaje es un error, por favor, pongase en contacto con nosotros, enviandonos codigo de licencia, nombre del modulo, dominio de la tienda y copia de la factura de pago') . '</p>';
            $this->_html .= '</div>';
            $this->_html .= '</div>';
            $this->_html .= $this->_mostrarLicencia();
            $this->forceCheck = 0;
        } else {
            $idTab = (int) Tools::getValue('idTab');
            if (!isset($idTab) || $idTab == 0) {
                $idTab = 1;
            }
            
            $picking = $this->getLicenciaAdicional('imaximprimepedidosservidorpda') ||
                    $this->getLicenciaAdicional('imaximprimepedidosservidorpdaentrada') ||
                    $this->getLicenciaAdicional('imaximprimepedidosservidornumserie');
                    
            $this->_html .= '	   
                <ul id="menuTab">
                    <li id="menuTab1" class="menuTabButton' . (($idTab == 1) ? " selected" : "" ) . '">1. ' . $this->l('Enlaces') . '</li>			
                    <li id="menuTab2" class="menuTabButton' . (($idTab == 2) ? " selected" : "" ) . '">2. ' . $this->l('Configuracion') . '</li>			
                    <li id="menuTab3" class="menuTabButton' . (($idTab == 3) ? " selected" : "" ) . '">3. ' . $this->l('Configuracion remota') . '</li>			
                    <li id="menuTab4" class="menuTabButton' . (($idTab == 4) ? " selected" : "" ) . '">4. ' . $this->l('Configuracion productos') . '</li>			
                    '.($picking ? '<li id="menuTab5" class="menuTabButton' . (($idTab == 5) ? " selected" : "" ) . '">5. ' . $this->l('Configuracion picking') . '</li>' : '').'			
                    <li id="menuTab6" class="menuTabButton' . (($idTab == 6) ? " selected" : "" ) . '">6. ' . $this->l('Licencia') . '</li>
                </ul>
                <div id="tabList">
                    <div id="menuTab1Sheet" class="tabItem' . (($idTab == 1) ? " selected" : "" ) . '">' . $this->_enlaces() . '</div>
                    <div id="menuTab2Sheet" class="tabItem' . (($idTab == 2) ? " selected" : "" ) . '">' . $this->_configuracion() . '</div>	
                    <div id="menuTab3Sheet" class="tabItem' . (($idTab == 3) ? " selected" : "" ) . '">' . $this->_configuracionRemota() . '</div>				                                				
                    <div id="menuTab4Sheet" class="tabItem' . (($idTab == 4) ? " selected" : "" ) . '">' . $this->_configuracionProductos() . '</div>				                                				
                    '.($picking ? '<div id="menuTab5Sheet" class="tabItem' . (($idTab == 5) ? " selected" : "" ) . '">' . $this->_configuracionPicking() . '</div>' : '').'
                    <div id="menuTab6Sheet" class="tabItem' . (($idTab == 6) ? " selected" : "" ) . '">' . $this->_mostrarLicencia() . '</div>				                                				
                </div>
                <br clear="left" />
                <br />
                <style>
                    #menuTab { float: left; padding: 0; margin: 0; text-align: left; }
                    #menuTab li { text-align: left; float: left; display: inline; padding: 5px; padding-right: 10px; background: #EFEFEF; font-weight: bold; cursor: pointer; border-left: 1px solid #EFEFEF; border-right: 1px solid #EFEFEF; border-top: 1px solid #EFEFEF; }
                    #menuTab li.menuTabButton.selected { background: #FFF6D3; border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-top: 1px solid #CCCCCC; }
                    #tabList { clear: left; }
                    .tabItem { display: none; }
                    .tabItem.selected { display: block; background: #FFFFF0; border: 1px solid #CCCCCC; padding: 10px; padding-top: 20px; }
                </style>
                <script>
                    $(".menuTabButton").click(function() {
                        $(".menuTabButton.selected").removeClass("selected");
                        $(this).addClass("selected");
                        $(".tabItem.selected").removeClass("selected");
                        $("#" + this.id + "Sheet").addClass("selected");
                    });
                </script>';
        }
    }

    public function getContent() {
        $this->getTxtFiles();
        
        $this->addCSS('huebee.min.css');
        $this->addCSS('css.css');
        $this->addJqueryUI('ui.draggable');
        $this->addJqueryUI('ui.droppable');
        $this->addJqueryUI('ui.sortable');
        $this->addJS('huebee.pkgd.min.js');
        $this->addJS('functions.js');
        $this->addCSS('publi.css');
        $this->_html .= $this->createHelpHeader();
        if (!empty($_POST)) {
            $this->_html .= $this->_postProcess();
        }

        $this->_displayForm();
        $this->_html .= $this->getModuleFooter();
        return $this->_html;
    }

    private function _enlaces() {
        $html = '
            <style type="text/css">
            #imprime_config label {
            width: inherit;
            }
            </style>';

        $tienda = new Shop($this->idShop);
        $enlace = $tienda->getBaseURL();
        if ($enlace[strlen($enlace) - 1] == '/') {
            $enlace = mb_substr($enlace, 0, -1);
        }
        $html .= '<fieldset><legend>'.$this->l('URL para el programa Imprime pedidos').'</legend>
            '.$enlace.'
            </fieldset><br/>';

        if ($this->getLicenciaAdicional('imaximprimepedidosservidorpda')) {
            require_once dirname(__FILE__).'/qrcode/qrlib.php';
            QRcode::png("$enlace/modules/imaximprimepedidosservidor/pda", dirname(__FILE__).'/css/qr.png', 'H', 2);

            $html .= '<fieldset><legend>'.$this->l('URL para acceder a monta pedidos (puede acceder escaneando el qr)').'</legend>
                <p id="enlacePDA"><a href="'.$enlace.'/modules/imaximprimepedidosservidor/pda" target="_blank">'.$enlace.'/pda</a> <img src="'.$enlace.'/modules/imaximprimepedidosservidor/css/qr.png" alt=""/></p>
                </fieldset><br/>';
        }
        if ($this->getLicenciaAdicional('imaximprimepedidosservidorpdaentrada')) {
            require_once dirname(__FILE__).'/qrcode/qrlib.php';
            QRcode::png("$enlace/modules/imaximprimepedidosservidor/pdaEntrada", dirname(__FILE__).'/css/qr_entrada.png', 'H', 2);

            $html .= '<fieldset><legend>'.$this->l('URL para acceder al picking (puede acceder escaneando el qr)').'</legend>
                <p id="enlacePDAEntrada"><a href="'.$enlace.'/pda_entrada" target="_blank">'.$enlace.'/pda_entrada</a> <img src="'.$enlace.'/modules/imaximprimepedidosservidor/css/qr_entrada.png" alt=""/></p>
                </fieldset><br/>';
        }

        $html .= '<fieldset><legend>'.$this->l('Resumen de pedidos impresos').'</legend>
            <p id="enlacePDAEntrada"><a href="'.$enlace.'/modules/imaximprimepedidosservidor/imaximprimepedidosservidor_export.php?fechaInicio='.date('Y-m-d').'&fechaFin='.date('Y-m-d').'&accion=impresos" target="_blank">'.$enlace.'/modules/imaximprimepedidosservidor/imaximprimepedidosservidor_export.php?fechaInicio='.date('Y-m-d').'&fechaFin='.date('Y-m-d').'&accion=impresos</a></p>
            </fieldset><br/>';
        /* mejoras imax */
        $html .= '<fieldset><legend>'.$this->l('Exportacion de Ubicaciones').'</legend>
            <p id="enlacePDAEntrada"><a href="'.$enlace.'/modules/imaximprimepedidosservidor/imaximprimepedidosservidor_export.php?&accion=ubicaciones" target="_blank">'.$enlace.'/modules/imaximprimepedidosservidor/imaximprimepedidosservidor_export.php?accion=ubicaciones</a></p>
            </fieldset><br/>';
        
        $html .= '<fieldset><legend>'.$this->l('Pedidos procesados por las PDAs').'</legend>
            <p id="enlaceProcesadosPDA"><a href="'.$enlace.'/modules/imaximprimepedidosservidor/imaximprimepedidosservidor_export.php?fechaInicio='.date('Y-m-d').'&fechaFin='.date('Y-m-d').'&accion=procesadosPda" target="_blank">'.$enlace.'/modules/imaximprimepedidosservidor/imaximprimepedidosservidor_export.php?fechaInicio='.date('Y-m-d').'&fechaFin='.date('Y-m-d').'&accion=procesadosPda</a></p>
            </fieldset><br/>';
        
        $html .= '<fieldset><legend>'.$this->l('Resumen de filas eliminadas y reemplazadas por las PDAs').'</legend>
            <p id="enlaceProcesadosPDA"><a href="'.$enlace.'/modules/imaximprimepedidosservidor/imaximprimepedidosservidor_export.php?fechaInicio='.date('Y-m-d').'&fechaFin='.date('Y-m-d').'&accion=cambiadasEliminadasPda" target="_blank">'.$enlace.'/modules/imaximprimepedidosservidor/imaximprimepedidosservidor_export.php?fechaInicio='.date('Y-m-d').'&fechaFin='.date('Y-m-d').'&accion=cambiadasEliminadasPda</a></p>
            </fieldset><br/>';

        return $html;
    }
    
    /**
     * Devuelve la lista de plantillas disponibles.
     * @return string[]
     */
    public function obtenerPlantillas() {
        $plantillas = array();
        $path = dirname(__FILE__).'/pdf';
        $dir = dir($path);
        while(($file = $dir->read()) !== false) {
            if(is_file($path.'/'.$file)) {
                $nombre = substr($file, 0, strpos($file, '.'));
                $plantillas[$nombre] = $nombre;
            }
        }
        
        return $plantillas;
    }
    
    private function _configuracion() {
        require_once(dirname(__FILE__) . '/functionsForm.php');
        require_once(dirname(__FILE__) . '/imaxAcordeon.php');

        $plantillas = $this->obtenerPlantillas();
        
        $plantillaCorreoOrdinario = $this->valoresPlantilla('PLANTILLA_CORREO_ORDINARIO', array('etiquetaOrdinario', '101,54'));
        $plantillaCorreoCertificado = $this->valoresPlantilla('PLANTILLA_CORREO_CERTIFICADO', array('etiquetaCertificado', '101,54'));
        $plantillaGenerica = $this->valoresPlantilla('PLANTILLA_GENERICA', array('etiqueta', 'A5'));
        $plantillaPedido = $this->valoresPlantilla('PLANTILLA_PEDIDO', array('newOrder', 'A4'));
        $ponerCodigo = Configuration::getGlobalValue(self::prefijo . 'PONER_CODIGO');
        
        $html = '';

        $acordeon = new imaxAcordeon($this->_path);
        $form = new imaxForm($this, $this->_path);
        $form->createHidden("action", "plantillas");
        $form->createHidden("idTab", "2");
        $form->createFormInfomationText($this->l('Las dimensiones para la generacion del documento se pueden introducir como "ancho,alto" (ej: 120,64) o como un iso estandar (ej: A4).'));
        $form->createFormSelect('plantillaCorreoOrdinario[0]', $this->l('Plantilla etiqueta Correos Ordinario'), $plantillas, $plantillaCorreoOrdinario[0]);
        $form->createFormTextGroup('plantillaCorreoOrdinario[1]', $plantillaCorreoOrdinario[1], $this->l('Dimensiones etiqueta Correos Ordinario'));
        $form->createFormSelect('plantillaCorreoCertificado[0]', $this->l('Plantilla etiqueta Correos Certificado'), $plantillas, $plantillaCorreoCertificado[0]);
        $form->createFormTextGroup('plantillaCorreoCertificado[1]', $plantillaCorreoCertificado[1], $this->l('Dimensiones etiqueta Correos Certificado'));
        $form->createFormSelect('plantillaGenerica[0]', $this->l('Plantilla etiqueta generica'), $plantillas, $plantillaGenerica[0]);
        $form->createFormTextGroup('plantillaGenerica[1]', $plantillaGenerica[1], $this->l('Dimensiones etiqueta generica'));
        $form->createFormSelect('plantillaPedido[0]', $this->l('Plantilla pedido'), $plantillas, $plantillaPedido[0]);
        $form->createFormTextGroup('plantillaPedido[1]', $plantillaPedido[1], $this->l('Dimensiones pedido'));
        $form->createFormCheckboxGroup('ponerCodigo', $this->l('Agregar el codigo de barras al final del pedido'), $ponerCodigo);
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
        $html .= $acordeon->renderAcordeon($this->l('Plantillas'), $form->renderForm());
        
        
        $tabla = '<table class="table"><thead><tr><th>'.$this->l('Nombre original').'</th><th>'.$this->l('Nuevo nombre').'</th></tr></thead><tbody>';
        $aliasFormasPago = unserialize(Configuration::getGlobalValue(self::prefijo.'ALIAS_FORMAS_PAGO'));
        $formasPago = PaymentModule::getInstalledPaymentModules();
        foreach($formasPago as $formaPago) {
            $module = Module::getInstanceById($formaPago['id_module']);
            if($module) {
                $valor = (isset($aliasFormasPago[$module->name]) ? $aliasFormasPago[$module->name] : '');
                $tabla .= "<tr><td>$module->displayName</td><td><input type='text' name='aliasFormasPago[$module->name]' value='$valor' size='100'/></td></tr>";
            }
        }
        $tabla .= '</tbody></table>';
        
        $acordeon = new imaxAcordeon($this->_path);
        $form = new imaxForm($this, $this->_path);
        $form->createHidden("action", "renombrarFormasPago");
        $form->createHidden("idTab", "2");
        $form->addToForm($tabla);
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
        $html .= $acordeon->renderAcordeon($this->l('Renombrar formas de pago'), $form->renderForm());
        
        $tabla = '<table class="table"><thead><tr><th>'.$this->l('Pais').'</th><th>'.$this->l('Telefono falso').'</th></tr></thead><tbody>';
        $paises = Country::getCountries($this->idLang, true, false, false);
        $telefonosFalsos = unserialize(Configuration::getGlobalValue(self::prefijo.'TELEFONOS_FALSOS'));
        foreach($paises as $pais) {
            $valor = (isset($telefonosFalsos[$pais['id_country']]) ? $telefonosFalsos[$pais['id_country']] : '');
            $tabla .= "<tr><td>{$pais['name']}</td><td><input type='text' name='telefonosFalsos[{$pais['id_country']}]' value='$valor'/></td></tr>";
        }
        $tabla .= '</tbody></table>';
        
        $acordeon = new imaxAcordeon($this->_path);
        $form = new imaxForm($this, $this->_path);
        $form->createHidden("action", "telefonosFalsos");
        $form->createHidden("idTab", "2");
        $form->addToForm($tabla);
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
        $html .= $acordeon->renderAcordeon($this->l('Paises con telefono opcional'), $form->renderForm());
        
        return $html;
    }
    
    /**
     * Devuelve el valor para la plantilla indicada sacado de base de datos o el valor por defecto.
     * @param string $nombre
     * @param string[] $porDefecto
     * @return string[]
     */
    public function valoresPlantilla($nombre, $porDefecto) {
        $valoresTemp = Configuration::getGlobalValue(self::prefijo.$nombre);
        if($valoresTemp) {
            $valores = unserialize($valoresTemp);
            if(!$valores) {
                $valores = $porDefecto;
            }
        }
        else {
            $valores = $porDefecto;
        }
        
        return $valores;
    }

    /**
     * Devuelve valor o un array si contiene una coma.
     * @param string $valor
     * @return mixed
     */
    public function conditionalSplit($valor) {
        $valor = (strpos($valor, ',') !== false ? explode(',', $valor) : $valor);
        if(is_array($valor)) {
            array_walk($valor, 'trim');
            array_walk($valor, 'intval');
        }
        
        return $valor;
    }
    
    private function _configuracionRemota() {
        require_once(dirname(__FILE__) . '/functionsForm.php');
        require_once(dirname(__FILE__) . '/imaxAcordeon.php');

        $html = '';

        $acordeon = new imaxAcordeon($this->_path);
        $form = new imaxForm($this, $this->_path);
        $form->createHidden("action", "guardarDatos");
        $form->createHidden("idTab", "3");
        $form->createFormTextGroup('passAcesoRemoto', '', 'Password Remota:');
        $form->createFormTextGroup('passEconomico', '', 'Password datos economicos:');
        $form->createFormTextGroup('passConfiguracion', '', 'Password para la configuracion:');
        $form->createFormTextGroup('passEdicion', '', 'Password para editar la direccion:');
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
        $html .= $acordeon->renderAcordeon($this->l('Configurar acceso remoto a tu Prestashop'), $form->renderForm());

        $acordeon = new imaxAcordeon($this->_path);
        $form = new imaxForm($this, $this->_path);
        $form->createHidden("action", "resetear");
        $form->createHidden("idTab", "3");
        $form->createFormInfomationText($this->l('Pulsa para marcar todos los pedidos como descargados'));
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Resetear'));
        $html .= $acordeon->renderAcordeon($this->l('Todos Descargados'), $form->renderForm());

        //Cargamos los transportistas
        $transportistas = Carrier::getCarriers($this->idLang, FALSE, FALSE, FALSE, NULL, Carrier::ALL_CARRIERS);
        $transportistasAdaptados = $this->adaptarListaTransportistas($transportistas);
        
        //Estados
        $estados = OrderState::getOrderStates($this->idLang);
        $estadosAdaptadosClaveValor = $this->adaptarListaEstadosPedidoClaveValor($estados);
        $estadosAdaptadosClaveValor[0] = $this->l('- No cambiar -');

        $centralizador = new CentralizadorEtiquetas($this);
        $html .= $centralizador->generarVisualizacion($transportistasAdaptados, $estadosAdaptadosClaveValor);
        
        //Cargamos los estados de pedido
        $estadosAdaptados = $this->adaptarListaEstadosPedido($estados);
        $informacionAdicional = Configuration::getGlobalValue(self::prefijo . 'INFO_ADICIONAL');
        $partenaire = Configuration::getGlobalValue(self::prefijo . 'COD_SPARTOO');
        $usarLocales = Configuration::getGlobalValue(self::prefijo . 'USAR_LOCALES');
        $comprobarDireccion = Configuration::getGlobalValue(self::prefijo . 'COMPROBAR_DIRECCION');
        $noPedidosSinEmailPass = Configuration::getGlobalValue(self::prefijo . 'NO_PEDIDOS_SIN_EMAIL_PASS');
        $locales = $this->obtenerLocales();
        $localesFormateados = array();
        foreach($locales as $local) {
            $localesFormateados[] = array('text' => $local['name'], 'value' => $local['id_store']);
        }
        
        $acordeon = new imaxAcordeon($this->_path);
        $form = new imaxForm($this, $this->_path);
        $form->createHidden("action", "otras");
        $form->createHidden("idTab", "3");
        $form->createFormRadioButtonGroup(array(
                array('checked' => $informacionAdicional == 0, 'name' => 'informacionAdicional', 'value' => '0', 'text' => $this->l('Forma de pago')), 
                array('checked' => $informacionAdicional == 1, 'name' => 'informacionAdicional', 'value' => '1', 'text' => $this->l('Nombre del cliente'))), 
            $this->l('Informacion adicional'));
        $form->createFormSelect('estadoImpresoPedido', $this->l('Estado de los pedidos despues de imprimir el pedido:'), $estadosAdaptadosClaveValor, Configuration::getGlobalValue(self::prefijo . 'ESTADO_IMPRESO_PEDIDO'));
        $form->createFormCheckboxGroup('noPedidosSinEmailPass', $this->l('No devolver pedidos sin email y pass'), $noPedidosSinEmailPass);
        $form->createFormCheckboxGroup('usarLocales', $this->l('Usar locales'), $usarLocales);
        $form->createFormCheckboxGroup('comprobarDireccion', $this->l('Realizar comprobaciones adicionales en la direccion antes de generar etiquetas'), $comprobarDireccion);
        $form->createFormCheckboxGroupList('localesVisibles', $this->l('Locales visibles en cliente'), $this->l('Locales visibles en cliente'), $localesFormateados, unserialize(Configuration::getGlobalValue(self::prefijo . 'LOCALES_VISIBLES')) );
        $form->createFormCheckboxGroupList('estados', $this->l('Selecciona los estados de incidencia:'), $this->l('Selecciona los estados de incidencia:'), $estadosAdaptados, unserialize(Configuration::getGlobalValue(self::prefijo . 'INCIDENCIA')));
        $form->createFormCheckboxGroupList('estadosDescartados', $this->l('Selecciona los estados descartados:'), $this->l('Selecciona los estados descartados:'), $estadosAdaptados, unserialize(Configuration::getGlobalValue(self::prefijo . 'DESCARTADO')));
        $form->createFormCheckboxGroupList('estadosFastPrinting', $this->l('Selecciona los estados para fast printing:'), $this->l('Selecciona los estados para fast printing:'), $estadosAdaptados, unserialize(Configuration::getGlobalValue(self::prefijo . 'ESTADOS_FAST_PRINTING')));
        $form->createFormCheckboxGroupList('estadosNoCambiar', $this->l('Selecciona los estados que no seran cambiados al imprimir:'), $this->l('Selecciona los estados que no seran cambiados al imprimir:'), $estadosAdaptados, unserialize(Configuration::getGlobalValue(self::prefijo . 'ESTADOS_NO_CAMBIAR')));
        $form->createFormSelect('nuevoEstadoNoCambiar', $this->l('En lugar de no cambiar los estados anteriores cambiar a este:'), $estadosAdaptadosClaveValor, Configuration::getGlobalValue(self::prefijo . 'NUEVO_ESTADO_NO_CAMBIAR'));
        if(Module::isInstalled('spartoo')) {
            $form->createFormTextGroup('partenaire', $partenaire, $this->l('Partenaire de Spartoo'));
        }
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
        $html .= $acordeon->renderAcordeon($this->l('Otras configuraciones'), $form->renderForm());

        return $html;
    }
    
    /**
     * Devuelve un numero auto incremental, agrupado por nombre.
     * @param string $nombre
     * @return int
     */
    private function autoIncremento($nombre) {
        $auto = (int)Configuration::getGlobalValue(self::prefijo.'AUTO_INCREMENTO_'.$nombre);
        $auto++;
        Configuration::updateGlobalValue(self::prefijo.'AUTO_INCREMENTO_'.$nombre, $auto);
        
        return $auto;
    }

    /**
     * Adapta el formato del array de transportista para el imaxforms.
     * @param array $transportistas
     * @return array
     */
    private function adaptarListaTransportistas($transportistas) {
        $resultado = array();
        foreach ($transportistas as $transportista) {
            $resultado[] = array('value' => $transportista['id_reference'], 'text' => $transportista['name']);
        }

        return $resultado;
    }

    /**
     * Adapta el formato del array de estados de pedido para el imaxforms.
     * @param array $estadosPedido
     * @return array
     */
    private function adaptarListaEstadosPedido($estadosPedido) {
        $resultado = array();
        foreach ($estadosPedido as $estadoPedido) {
            $resultado[] = array('value' => $estadoPedido['id_order_state'], 'text' => $estadoPedido['name']);
        }

        return $resultado;
    }

    /**
     * Adapta el formato del array de estados de pedido para el imaxforms select.
     * @param array $estadosPedido
     * @return array
     */
    private function adaptarListaEstadosPedidoClaveValor($estadosPedido) {
        $resultado = array();
        foreach ($estadosPedido as $estadoPedido) {
            $resultado[$estadoPedido['id_order_state']] = $estadoPedido['name'];
        }

        return $resultado;
    }

    private function _configuracionProductos() {
        require_once(dirname(__FILE__) . '/functionsForm.php');
        require_once(dirname(__FILE__) . '/imaxAcordeon.php');

        $html = '';
        
        $acordeon = new imaxAcordeon($this->_path);

        $crear = Configuration::getGlobalValue(self::prefijo . 'CREAR');
        $categoria = Configuration::getGlobalValue(self::prefijo . 'CATEGORIAS');
        $nom_producto = Configuration::getGlobalValue(self::prefijo . 'NOM_PRO_DEFECTO');
        $pre_producto = Configuration::getGlobalValue(self::prefijo . 'PRECIO_PRO_DEFECTO');
        $cos_producto = Configuration::getGlobalValue(self::prefijo . 'COSTE_PRO_DEFECTO');
        $stock_producto = (int) Configuration::getGlobalValue(self::prefijo . 'STOCK_PRO_DEFECTO');
        $enControlador = Configuration::getGlobalValue(self::prefijo . 'EN_CONTROLADOR');
        $proveedor_producto = Configuration::getGlobalValue(self::prefijo . 'SUPPLI_PRODUCTO');
        $impuesto_producto = Configuration::getGlobalValue(self::prefijo . 'IMP_PRODUCTO');
        $crearProductos = Configuration::getGlobalValue(self::prefijo . 'CREAR_PRODUCTOS');
        $impuestos = TaxRulesGroup::getTaxRulesGroups();
        $impuestosFormateados = array();
        foreach ($impuestos as $impuesto) {
            $impuestosFormateados[$impuesto['id_tax_rules_group']] = $impuesto['name'];
        }

        $acordeon = new imaxAcordeon($this->_path);
        $form = new imaxForm($this, $this->_path);
        $form->createHidden("action", "configuracionDatosDefecto");
        $form->createHidden("idTab", "4");
        $form->createSelectCategory('categoria', 'Selecciona la categoria', $categoria);
        $form->createFormTextGroup('nom_producto', $nom_producto, 'Nombre por defecto del producto');
        $form->createFormTextGroup('pre_producto', $pre_producto, 'Precio por defecto');
        $form->createFormTextGroup('cos_producto', $cos_producto, 'Coste por defecto');
        $form->createFormTextGroup('stock_producto', $stock_producto, 'Stock por defecto');
        $form->createSelectSupplier('suppli_producto', 'Proveedor', $proveedor_producto);
        $form->createFormSelect('imp_producto', 'Impuesto', $impuestosFormateados, $impuesto_producto);
        $form->createFormSelect('crear', 'Buscar productos en base a ', array(0 => $this->l('Referencia'), 1 => $this->l('Ean')), $crear);
        $form->createFormCheckboxGroup('crearProductos', $this->l('Crear productos que no existen'), $crearProductos);
        //$form->createFormCheckboxGroup('enControlador', 'Mostrar estas opciones en el controlador', $enControlador);
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
        $html .= $acordeon->renderAcordeon($this->l('Configuracion Productos Nuevos'), $form->renderForm());
        unset($form);
        /*
        $form = new imaxForm($this, $this->_path);
        $form->createHidden("action", "amazon");
        $form->createHidden("idTab", "4");

        $amazon_key = Configuration::getGlobalValue(self::prefijo . 'AMA_KEY');
        $amazon_secret = Configuration::getGlobalValue(self::prefijo . 'AMA_SEC');
        $amazon_associateId = Configuration::getGlobalValue(self::prefijo . 'AMA_AI');
        $amazon_country_id = Configuration::getGlobalValue(self::prefijo . 'AMA_CI');
        $crearAmazon = Configuration::getGlobalValue(self::prefijo . 'CREAR_AMA');
        $ipsBack = Configuration::getGlobalValue(self::prefijo . 'IPS_BACK');
        $prod_amazon = Configuration::getGlobalValue(self::prefijo . 'PRO_AMA');
        $preciooferta_id = Configuration::getGlobalValue(self::prefijo . 'TIP_PRE_PRO_AMA');

        $amazonCountry = array('br' => $this->l('Brasil'),
            'ca' => $this->l('Canada'),
            'cn' => $this->l('China'),
            'fr' => $this->l('Francia'),
            'de' => $this->l('Alemania'),
            'in' => $this->l('India'),
            'it' => $this->l('Italia'),
            'jp' => $this->l('Japon'),
            'mx' => $this->l('Mexico'),
            'es' => $this->l('España'),
            'uk' => $this->l('Inglaterra'),
            'us' => $this->l('Estados Unidos'),
        );

        $preciooferta = array(0 => 'Oferta', 1 => 'Precio Normal');
        $form->createFormTextGroup('amazon_key', $amazon_key, 'Amazon key id:');
        $form->createFormTextGroup('amazon_secret', $amazon_secret, 'Amazon secret:');
        $form->createFormTextGroup('amazon_associateId', $amazon_associateId, 'Amazon associateId:');
        $form->createFormSelect('preciooferta_id', 'Precio a poner en el producto', $preciooferta, $preciooferta_id);
        $form->createFormSelect('amazon_country_id', 'Amazon Country', $amazonCountry, $amazon_country_id);
        $temp = '<label>' . $this->l('Ips Autorizadas para ver los precios por delante (separadas por coma)') . '</label>';
        $temp .= '<input type="text" name="ipsBack" value="' . $ipsBack . '" style="width:300px"/>';
        $temp .= '<script type="text/javascript">
                    function addRemoteAddrBanip()
                    {
                            var length = $(\'input[name=ipsBack]\').attr(\'value\').length;
                            if (length > 0)
                                    $(\'input[name=ipsBack]\').attr(\'value\',$(\'input[name=ipsBack]\').attr(\'value\') +\',' . Tools::getRemoteAddr() . '\');
                            else
                                    $(\'input[name=ipsBack]\').attr(\'value\',\'' . Tools::getRemoteAddr() . '\');
                    }
                </script>';
        $temp .= '<button type="button" class="btn btn-default" onclick="addRemoteAddrBanip();"><i class="icon-plus"></i> ' . $this->l('Add my IP') . '</button>';
        $temp .= '<br /><br />';
        $form->addToForm($temp);
        $form->createFormTextGroup('prod_amazon', $prod_amazon, 'Productos a procesar :');
        $form->createFormCheckboxGroup('crearAmazon', 'Crear el producto capturando datos de Amazon', $crearAmazon);
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
        $html .= $acordeon->renderAcordeon($this->l('Amazon Data'), $form->renderForm());

        $urlTienda = self::getUrlAdmin();
        $token = Configuration::getGlobalValue(self::prefijo . 'TOKEN_CRON');
        $form = new imaxForm($this, $this->getPathUri());
        $form->createHidden("action", "generarToken");
        $form->createHidden("idTab", 4);
        $form->createFormInfomationText('<b>' . $this->l('ATENCION:') . '</b> ' . $this->l('Si cambia el token, tiene que cambiarlo tambien en las tareas de cron'), 'warning', true);
        $form->createFormInfomationText('Debe enviarlo por get a las urls del servicio', 'confirm');
        $form->createFormInfomationText('Productos:<a href="' . $urlTienda . $this->name . '_cron.php?token=' . $token . '&action=productos" target="_blank">' . $urlTienda . $this->name . '_cron.php?token=' . $token . '&action=productos</a>', 'confirm', true);
        $form->createFormInfomationText('Imagenes:<a href="' . $urlTienda . $this->name . '_cron.php?token=' . $token . '&action=imagenes" target="_blank">' . $urlTienda . $this->name . '_cron.php?token=' . $token . '&action=imagenes</a>', 'confirm', true);
        $form->createFormInfomationText('Token Actual: ' . $token, 'confirm');
        $form->createSubmitButton('generarToken', $this->l('Regenerar Token Amazon'));
        $html .= $acordeon->renderAcordeon($this->l('Cron'), $form->renderForm());*/
        
        $form = new imaxForm($this, $this->getPathUri(), '', 'post', '', 'multipart/form-data');
        $form->createHidden("action", "importarUbicaciones");
        $form->createHidden("idTab", 4);
        $form->createFormInfomationText($this->l('Un archivo csv con el formato (referencia;ubicacion)'));
        $form->createFormUploadFile('ubicaciones', $this->l('Archivo de ubicaciones'));
        $form->createSubmitButton('importar', $this->l('Importar'));
        $html .= $acordeon->renderAcordeon($this->l('Importar ubicaciones'), $form->renderForm());
        
        $form = new imaxForm($this, $this->getPathUri(), '', 'post', '', 'multipart/form-data');
        $form->createHidden("action", "exportarUbicaciones");
        $form->createHidden("idTab", 4);
        $form->createFormInfomationText($this->l('Al subir un archivo csv con una referencia por linea se obtiene otro con el formato (referencia;ubicacion)'));
        $form->createFormUploadFile('referencias', $this->l('Archivo de referencias'));
        $form->createSubmitButton('exportar', $this->l('Exportar'));
        $html .= $acordeon->renderAcordeon($this->l('Exportar ubicaciones'), $form->renderForm());
        
        $form = new imaxForm($this, $this->getPathUri());
        $form->createHidden("action", "exportarReferencias");
        $form->createHidden("idTab", 4);
        $form->createFormInfomationText($this->l('Introduzca las ubicaciones en la segunda columna. (Referencia, Ubicacion, Id producto, Id combinacion, Nombre producto)'));
        $form->createSubmitButton('exportar', $this->l('Exportar'));
        $html .= $acordeon->renderAcordeon($this->l('Exportar referencias'), $form->renderForm());

        return $html;
    }

    private function _configuracionPicking() {
        require_once(dirname(__FILE__) . '/functionsForm.php');
        require_once(dirname(__FILE__) . '/imaxAcordeon.php');
        
        $html = '';

        $estados = OrderState::getOrderStates($this->idLang);
        $estadosAdaptados = $this->adaptarListaEstadosPedido($estados);
        $estadosAdaptadosClaveValor = $this->adaptarListaEstadosPedidoClaveValor($estados);
        $estadosAdaptadosClaveValor[0] = $this->l('- No cambiar -');

        $estadoMontado = Configuration::getGlobalValue(self::prefijo . 'ESTADO_MONTADO');
        $estadoIncompleto = Configuration::getGlobalValue(self::prefijo . 'ESTADO_INCOMPLETO');
        $marcadoAgregarManual = Configuration::getGlobalValue(self::prefijo . 'AGREGAR_MANUAL');
        $finalizarIncompletos = Configuration::getGlobalValue(self::prefijo . 'FINALIZAR_INCOMPLETOS');
        $pedidosIncompletos = Configuration::getGlobalValue(self::prefijo . 'PEDIDOS_INCOMPLETOS');
        $devolucionIncompletos = Configuration::getGlobalValue(self::prefijo . 'DEVOLUCION_INCOMPLETOS');
        $mostrarFiltroFecha = Configuration::getGlobalValue(self::prefijo . 'FILTRO_FECHA');
        $mostrarFiltroFormaPago = Configuration::getGlobalValue(self::prefijo . 'FILTRO_FORMA_PAGO');
        $mostrarFiltroTransportista = Configuration::getGlobalValue(self::prefijo . 'FILTRO_TRANSPORTISTA');
        $solicitarLectura = Configuration::getGlobalValue(self::prefijo . 'SOLICITAR_LECTURA');
        $visorReducido = Configuration::getGlobalValue(self::prefijo . 'VISOR_REDUCIDO');
        $packsIndivisibles = Configuration::getGlobalValue(self::prefijo . 'PACKS_INDIVISIBLES');
        $marcadoAgregarManualEntrada = Configuration::getGlobalValue(self::prefijo . 'AGREGAR_MANUAL_ENTRADA');
        $mostrarFiltroFechaEntrada = Configuration::getGlobalValue(self::prefijo . 'FILTRO_FECHA_ENTRADA');
        $imprimirCantidadEtiquetas = Configuration::getGlobalValue(self::prefijo . 'IMPRIMIR_CANTIDAD_ETIQUETAS');
        $identificadorSalida = Configuration::getGlobalValue(self::prefijo . 'IDENTIFICADOR_SALIDA');
        $eanExtendido = Configuration::getGlobalValue(self::prefijo . 'EAN_EXTENDIDO_PDA');
        $mostrarUbicacion = Configuration::getGlobalValue(self::prefijo . 'MOSTRAR_UBI_PDA');
        $mostrarFabricantePDA = Configuration::getGlobalValue(self::prefijo . 'MOSTRAR_FABRICANTE_PDA');
        $origenUbicacionPDA = Configuration::getGlobalValue(self::prefijo . 'ORIGEN_UBI_PDA');
        $origenesUbicacion = array(0 => $this->l('Del propio modulo'));
        if(Module::isEnabled('obswarehouselocation')) {
            $moduloLocalizacion = Module::getInstanceByName('obswarehouselocation');
            $origenesUbicacion[1] = $this->l('Del modulo').' '.$moduloLocalizacion->displayName;
        }
        if($this->hayUbicacionesPresta()) {
            $origenesUbicacion[2] = $this->l('De Prestashop');
        }
        $mostrarReferencia = Configuration::getGlobalValue(self::prefijo . 'MOSTRAR_REF_PDA');
        $todosEmpleadosPDA = Configuration::getGlobalValue(self::prefijo . 'TODOS_EMPLEADOS_PDA');
        $mostrarCantidadRestantePDA = Configuration::getGlobalValue(self::prefijo . 'MOSTRAR_RESTANTE_PDA');
        $usarCantidadFisicaPDA = Configuration::getGlobalValue(self::prefijo . 'USAR_CANTIDAD_FISICA_PDA');
        $unaSolaPaginaPDA = Configuration::getGlobalValue(self::prefijo . 'UNA_SOLA_PAGINA_PDA');
        $noPedidosSinStockPDA = Configuration::getGlobalValue(self::prefijo . 'NO_PEDIDOS_SIN_STOCK_PDA');
        $indicarSinStockPDA = Configuration::getGlobalValue(self::prefijo . 'INDICAR_SIN_STOCK_PDA');
        $permitirReemplazarPDA = Configuration::getGlobalValue(self::prefijo . 'PERMITIR_REEMPLAZAR_PDA');
        $ajustarReemplazarPDA = Configuration::getGlobalValue(self::prefijo . 'AJUSTAR_REEMPLAZAR_PDA');
        $mostrarFlotantePDA = Configuration::getGlobalValue(self::prefijo . 'MOSTRAR_FLOTANTE_PDA');
        $aspectoAlternativoPDA = Configuration::getGlobalValue(self::prefijo . 'ASPECTO_ALTERNATIVO_PDA');
        $nomenStockWeb = Configuration::getGlobalValue(self::prefijo . 'NOMEN_STOCK_WEB');
        $simboloMultiplicadorPDA = Configuration::getGlobalValue(self::prefijo . 'SIMBOLO_MULTIPLICADOR_PDA');
        $ordenacionPedidosPorPDA = Configuration::getGlobalValue(self::prefijo . 'ORDENACION_PEDIDOS_POR_PDA');
        $ordenacionPedidosPDA = Configuration::getGlobalValue(self::prefijo . 'ORDENACION_PEDIDOS_PDA');
        $textoTiendasPDA = unserialize(Configuration::getGlobalValue(self::prefijo . 'TEXTO_TIENDAS_PDA'));
        $emailAvisosPDA = Configuration::getGlobalValue(self::prefijo . 'EMAIL_AVISOS_PDA');
        $empleadosPuedenEliminar = unserialize(Configuration::getGlobalValue(self::prefijo . 'EMPLEADOS_PUEDEN_ELIMINAR'));
        $estadoSinTerminarPDA = Configuration::getGlobalValue(self::prefijo . 'ESTADO_SIN_TERMINAR_PDA');
        $tiendas = Shop::getShops();
        $empleadosChecks = [];
        $empleados = Employee::getEmployees();
        foreach($empleados as $empleado) {
            $empleadosChecks[] = ['value' => $empleado['id_employee'], 'text' => $empleado['id_employee'].' - '.$empleado['firstname'].' '.
                $empleado['lastname']];
        }
        $zonas = Zone::getZones(false, true);
        $colorZonaPDA = unserialize(Configuration::getGlobalValue(self::prefijo . 'COLOR_ZONA_PDA'));
        $filtroEstadosPDA = Configuration::getGlobalValue(self::prefijo . 'FILTRO_ESTADO_PDA');
        $mostraCP = Configuration::getGlobalValue(self::prefijo . 'MOSTRAR_CP');
        $formasFinalizarPedido = array(
            array('text' => $this->l('Finalizar'), 'value' => 0),
            array('text' => $this->l('Finalizar e imprimir etiquetas'), 'value' => 1),
            array('text' => $this->l('Finalizar e imprimir con nº bultos'), 'value' => 2)
        );
        $mostrarBotonImprimir = Configuration::getGlobalValue(self::prefijo . 'MOSTRAR_BOTON_IMPRIMIR');
        $opcionesImprimir = array(
            array('text' => $this->l('Imprimir etiqueta'), 'value' => 0),
            array('text' => $this->l('Imprimir pedido'), 'value' => 1),
            array('text' => $this->l('Imprimir factura'), 'value' => 2)
        );
        $opcionesFinalizar = array(
            array('text' => $this->l('Imprimir etiqueta'), 'value' => 0),
            array('text' => $this->l('Imprimir pedido'), 'value' => 1),
            array('text' => $this->l('Imprimir factura'), 'value' => 2)
        );
        $pedirBultosFinalizar = Configuration::getGlobalValue(self::prefijo . 'PEDIR_BULTOS_FINALIZAR');
        //Picking de salida
        if ($this->getLicenciaAdicional('imaximprimepedidosservidorpda')) {
            $acordeon = new imaxAcordeon($this->_path);
            $acordeonInterno = new imaxAcordeon($this->_path);
            $form = new imaxForm($this, $this->_path);
            $formInterno = new imaxForm($this, $this->_path, '', '', '', '', false, true);
            $form->createHidden("action", "pickingOUT");
            $form->createHidden("idTab", "5");
            $form->createFormCheckboxGroup('agregarManual', $this->l('Mostrar boton de agregar manualmente en pda'), $marcadoAgregarManual);
            $form->createFormCheckboxGroup('finalizarIncompletos', $this->l('Permitir finalizar pedidos incompletos en pda'), $finalizarIncompletos);
            $form->createFormCheckboxGroup('pedidosIncompletos', $this->l('Al finalizar pedidos incompletos en pda crear un nuevo pedido con el restante'), $pedidosIncompletos);
            $form->createFormCheckboxGroup('devolucionIncompletos', $this->l('Al finalizar pedidos incompletos en pda crear una devolucion'), $devolucionIncompletos);
            $form->createFormSelect('estadoIncompletoPDA', $this->l('Estado de los pedidos incompletos con el restante (PDA):'), $estadosAdaptadosClaveValor, $estadoIncompleto);
            $form->createFormCheckboxGroup('mostrarFiltroFecha', $this->l('Mostrar filtro de fecha en pda'), $mostrarFiltroFecha);
            $form->createFormCheckboxGroup('mostrarFiltroFormaPago', $this->l('Mostrar filtro de forma de pago en pda'), $mostrarFiltroFormaPago);
            $form->createFormCheckboxGroup('mostrarFiltroTransportista', $this->l('Mostrar filtro de transportista en pda'), $mostrarFiltroTransportista);
            $form->createFormCheckboxGroup('solicitarLectura', $this->l('Solicitar lectura de mensajes en pda'), $solicitarLectura);
            $form->createFormCheckboxGroup('noPedidosSinStockPDA', $this->l('No mostrar pedidos sin stock en pda'), $noPedidosSinStockPDA);
            $form->createFormCheckboxGroup('indicarSinStockPDA', $this->l('Mostrar falta de stock en pda'), $indicarSinStockPDA);
            $form->createFormSelect('estadoMontado', $this->l('Estado de los pedidos despues de montarlos (PDA):'), $estadosAdaptadosClaveValor, $estadoMontado);
            $form->createFormSelect('selectReferencia', $this->l('Identificador para los productos'), [
                self::IDENTIFICADOR_EAN13 => $this->l('Ean13'), 
                self::IDENTIFICADOR_REFERENCIA => $this->l('Referencia'),
                self::IDENTIFICADOR_REFERENCIA_EAN13 => $this->l('Referencia o Ean13')
            ], $identificadorSalida);
            $form->createFormCheckboxGroup('eanExtendidoPDA', $this->l('Agregar un 0 al ean de ser necesario (PDA)'), $eanExtendido);
            $form->createFormSelect('visorReducido', $this->l('Visor para pantallas reducidas (PDA)'), array(0 => $this->l('No'), 1 => $this->l('Reducido'), 2 => $this->l('Muy reducido')), $visorReducido);
            $form->createFormCheckboxGroup('packsIndivisibles', $this->l('Tratar los packs como un unico producto (PDA)'), $packsIndivisibles);
            $form->createFormCheckboxGroup('mostrarUbicacionPDA', $this->l('Mostrar la ubicacion del producto (PDA)'), $mostrarUbicacion);
            $form->createFormCheckboxGroup('mostrarFabricantePDA', $this->l('Mostrar el fabricante del producto (PDA)'), $mostrarFabricantePDA);
            $form->createFormSelect('origenUbicacionPDA', $this->l('Origen de la ubicacion del producto (PDA)'), $origenesUbicacion, $origenUbicacionPDA);
            $form->createFormCheckboxGroup('mostrarReferenciaPDA', $this->l('Mostrar la referencia del producto (PDA)'), $mostrarReferencia);
            $form->createFormCheckboxGroup('todosEmpleadosPDA', $this->l('Todos los empleados pueden ver todos los pedidos (PDA)'), $todosEmpleadosPDA);
            $form->createFormCheckboxGroup('mostrarCantidadRestantePDA', $this->l('Mostar cantidad restante (PDA)'), $mostrarCantidadRestantePDA);
            $form->createFormCheckboxGroup('usarCantidadFisicaPDA', $this->l('Usar la cantidad fisica (PDA)'), $usarCantidadFisicaPDA);
            $form->createFormCheckboxGroup('unaSolaPaginaPDA', $this->l('Mostar las pantallas en una sola pagina (PDA)'), $unaSolaPaginaPDA);
            $form->createFormCheckboxGroup('permitirReemplazarPDA', $this->l('Permitir reemplazar productos (PDA)'), $permitirReemplazarPDA);
            $form->createFormCheckboxGroup('ajustarReemplazarPDA', $this->l('Al reemplazar ajustar stock (PDA)'), $ajustarReemplazarPDA);
            $form->createFormTextGroup('simboloMultiplicadorPDA', $simboloMultiplicadorPDA, $this->l('Simbolo para el multiplicador de cantidades (PDA)'));
            $form->createFormCheckboxGroup('mostrarFlotantePDA', $this->l('Permitir abrir teclado en pantalla (PDA)'), $mostrarFlotantePDA);
            $form->createFormSelect('ordenacionPedidosPorPDA', $this->l('Ordenar los pedidos (PDA) por'), array('o3.id_order' => $this->l('Id del pedido'), 'o3.date_add' => $this->l('Fecha de creación del pedido'), 
                'od.product_name' => $this->l('Alfabeticamente por el listado de productos del pedido')), $ordenacionPedidosPorPDA);
            $form->createFormSelect('ordenacionPedidosPDA', $this->l('Orden de los pedidos (PDA)'), array('ASC' => $this->l('Ascendente'), 
                'DESC' => $this->l('Descendiente')), $ordenacionPedidosPDA);
            $form->createFormTextGroup('emailAvisosPDA', $emailAvisosPDA, $this->l('Emails a los que mandar los avisos (PDA)'));
            $form->createFormCheckboxGroupList('empleadosPuedenEliminar', $this->l('Empleados que pueden eliminar filas de pedido (PDA):'), '', $empleadosChecks, $empleadosPuedenEliminar);
            $form->createFormSelect('estadoSinTerminarPDA', $this->l('Estado para los pedidos a medio montar (PDA)'), $estadosAdaptadosClaveValor, $estadoSinTerminarPDA);
            $form->addToForm('<div id="opcionesBotones">');
            $form->createFormCheckboxGroupList('formasFinalizarPedido', $this->l('Formas de finalizar un pedido'), $this->l('Formas de finalizar un pedido'), $formasFinalizarPedido, unserialize(Configuration::getGlobalValue(self::prefijo . 'FORMAS_FINALIZAR_PEDIDO')));
            $form->addToForm('</div>');
            
            $form->createFormCheckboxGroup('filtroEstadosPDA', $this->l('Mostrar el filtro por estado de pedido (PDA)'), $filtroEstadosPDA);
            $form->createFormCheckboxGroup('mostraCP', $this->l('Mostrar el códico postal asociado al transportista'), $mostraCP);
            
            $form->createFormCheckboxGroup('aspectoAlternativoPDA', $this->l('Aspecto alternativo (PDA)'), $aspectoAlternativoPDA);
            $form->createFormSelect('nomenStockWeb', $this->l('Nomenclatura para el stock web (PDA)'), array(0 => $this->l('Restante'), 
                1 => $this->l('Stock web')), $nomenStockWeb);
            $form->addToForm('<div id="opcionesAspectoAlternativo">');
            $formInterno->createFormCheckboxGroup('mostrarBotonImprimir', $this->l('Mostrar botón imprimir'), $mostrarBotonImprimir);
            $formInterno->createFormCheckboxGroupList('opcionesImprimir', $this->l('Opciones de impresión'), $this->l('Opciones de impresión'), $opcionesImprimir, unserialize(Configuration::getGlobalValue(self::prefijo . 'OPCIONES_IMPRIMIR')));
            $formInterno->createFormCheckboxGroupList('opcionesFinalizar', $this->l('Opciones de finalización'), $this->l('Opciones de finalización'), $opcionesFinalizar, unserialize(Configuration::getGlobalValue(self::prefijo . 'OPCIONES_FINALIZAR')));
            $formInterno->createFormCheckboxGroup('pedirBultosFinalizar', $this->l('Pedir bultos al finalizar'), $pedirBultosFinalizar);
            $formInterno->createFormSelect('identificadorPedido', $this->l('Mostar referencia o id en la pantalla principal'), array(0 => $this->l('Referencia'), 1 => $this->l('Id')), Configuration::getGlobalValue(self::prefijo . 'IDENTIFICADOR_PEDIDO'));
            $htmlInterno = $acordeonInterno->renderAcordeon($this->l('Opciones Aspecto Alternativo'), $formInterno->renderForm(true), true);
            $form->addToForm($htmlInterno);
            $form->addToForm('</div>');
            //Estados de pedido procesables
            foreach($empleados as $empleado) {
                $estadosMontablesPDA = array_map(function($datos) {
                    return $datos['id_order_state'];
                }, $this->cargarEstadosPedido($empleado['id_employee']));
                $formInterno->createFormCheckboxGroupList('estadosMontablesPDA['.$empleado['id_employee'].']', $empleado['id_employee'].' - '.$empleado['firstname'].' '.
                        $empleado['lastname'], '', $estadosAdaptados, $estadosMontablesPDA);
            }
            $htmlInterno = $acordeonInterno->renderAcordeon($this->l('Estados de pedido a mostrar en la pda por empleado'), $formInterno->renderForm(true), true);
            $form->addToForm($htmlInterno);
            //Prefijos por tienda
            foreach($tiendas as $tienda) {
                $formInterno->createFormTextGroup("textoTiendasPDA[{$tienda['id_shop']}]", 
                        (isset($textoTiendasPDA[$tienda['id_shop']]) ? $textoTiendasPDA[$tienda['id_shop']] : ''), $this->l('Texto identificativo de la tienda')." {$tienda['name']}");
            }
            $htmlInterno = $acordeonInterno->renderAcordeon($this->l('Textos identificativos por tienda para el listado de pedidos en la pda'), $formInterno->renderForm(true), true);
            $form->addToForm($htmlInterno);
            //Colores por zona
            foreach($zonas as $zona) {
                $formInterno->createFormTextGroup("colorZonaPDA[{$zona['id_zone']}]", 
                        (isset($colorZonaPDA[$zona['id_zone']]) ? $colorZonaPDA[$zona['id_zone']] : ''), $this->l('Color para la zona')." {$zona['name']}");
            }
            $htmlInterno = $acordeonInterno->renderAcordeon($this->l('Colores por zona para el listado de pedidos en la pda'), $formInterno->renderForm(true), true);
            $form->addToForm($htmlInterno);
            //Productos que no necesitan picking
            $formInterno->createFormTextGroup('buscarProductoNoPicking', '', $this->l('Buscar producto'));
            $formInterno->createHidden('productosNoPicking', '');
            $formInterno->addToForm('<div class="resultadosBusquedaProductoNoPicking"></div>'); 
            $formInterno->addToForm('<div class="contenedorResultadosProductoNoPicking"><p>'.$this->l('Productos actuales:').'</p>'.$this->generarListadoProductosNoPicking().'</div>');
            $htmlInterno = $acordeonInterno->renderAcordeon($this->l('Productos que no necesitan picking'), $formInterno->renderForm(true), true);
            $form->addToForm($htmlInterno);
            $form->addToForm('<button class="btn btn-default" name="eliminarPedidosPendientes" type="button"><i class="process-icon-save"></i>Eliminar pedidos pendientes</button>');
            $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
            $html .= $acordeon->renderAcordeon($this->l('Picking Salida'), $form->renderForm());
        }

        //Picking de entrada
        if ($this->getLicenciaAdicional('imaximprimepedidosservidorpdaentrada')) {
            $stockMvtReasons = StockMvtReason::getStockMvtReasons($this->idLang);
            $stockMvtReasonsFormat = array();
            foreach($stockMvtReasons as $stockMvtReason){
                $stockMvtReasonsFormat[$stockMvtReason['id_stock_mvt_reason']] = $stockMvtReason['name'];
            }
            $razonMvtEntrada = Configuration::getGlobalValue(self::prefijo.'RAZON_MVT_ENTRADA');
            $mostrarRefProduct = Configuration::getGlobalValue(self::prefijo.'MOSTRAR_REF_PRODUCT');
            $simboloMultiplicadorPDAEntrada = Configuration::getGlobalValue(self::prefijo . 'SIMBOLO_MULTIPLICADOR_PDA_ENTRADA');
            $acordeon = new imaxAcordeon($this->_path);
            $form = new imaxForm($this, $this->_path, Tools::safeOutput($_SERVER['REQUEST_URI']), 'post', 'uploadFile', "multipart/form-data", false, false, $this->_path);
            $form->createHidden("action", "pickingIN");
            $form->createHidden("idTab", "5");
            $form->createFormCheckboxGroup('agregarManualEntrada', $this->l('Mostrar boton de agregar manualmente en picking'), $marcadoAgregarManualEntrada);
            $form->createFormCheckboxGroup('mostrarFiltroFechaEntrada', $this->l('Mostrar filtro de fecha en picking'), $mostrarFiltroFechaEntrada);
            $form->createFormSelect('imprimirCantidadEtiquetas', $this->l('Cantidad de etiquetas a imprimir'), array(self::IMPRIMIR_DESEADO => $this->l('Deseado'), self::IMPRIMIR_ACTUAL => $this->l('Actual')), $imprimirCantidadEtiquetas);
            $form->createFormSelect('razonMvtEntrada', 'Razón del movimiento de stock de entrada', $stockMvtReasonsFormat, $razonMvtEntrada, 'razonMvtEntrada');
            $form->createFormCheckboxGroup('mostrarRefProduct', $this->l('Mostrar referencia producto'), $mostrarRefProduct);
            $form->createFormTextGroup('simboloMultiplicadorPDAEntrada', $simboloMultiplicadorPDAEntrada, $this->l('Simbolo para el multiplicador de cantidades (PDA)'));
            if(Module::isEnabled('imaxmultialmacen')){
                $almacenEntradaGeneral = Configuration::getGlobalValue(self::prefijo.'ALMACEN_ENTRADA_GENERAL');
                $almacenes = Warehouse::getWarehouses(true);
                $almaceneEstructurados = [0 => ' -Seleccione una opción- '];
                foreach($almacenes as $almacen){
                    $almaceneEstructurados[$almacen['id_warehouse']] = $almacen['name'];
                }
                $form->createFormSelect('almacenEntradaGeneral', $this->l('Almacén de entrada general'), $almaceneEstructurados, $almacenEntradaGeneral);
            }
            $form->addToForm('<div id="contArtPega">');
            if(file_exists(__DIR__."/sampleFiles/articulosConPegatinas.csv")){
                $form->addToForm('<a href="../modules/imaximprimepedidosservidor/sampleFiles/articulosConPegatinas.csv">'.$this->l('Pulsa este enlace para bajar un archivo de ejemplo.').'</a>');
            }
            $form->addToForm('</div>');
            $form->createFormUploadFile('file', $this->l('Artículos con pegatinas'), '');
            $form->addToForm('<button class="btn btn-default" name="articulosConPegatinas" type="button"><i class="process-icon-save"></i>Exportar</button>');
            $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
            $html .= $acordeon->renderAcordeon($this->l('Picking Entrada'), $form->renderForm());
        }

        //Numero de serie
        if ($this->getLicenciaAdicional('imaximprimepedidosservidornumserie')) {
            $acordeon = new imaxAcordeon($this->_path);
            $form = new imaxForm($this, $this->_path);
            $form->createHidden("action", "configuracionSerialNumber");
            $form->createHidden("idTab", "5");

            $plantilla = Configuration::getGlobalValue(self::prefijo . 'PLANTILLA');
            $nombreCampoNumSerie = Configuration::getGlobalValue(self::prefijo . 'NOM_SER');
            $multiplicadorSerieProductos = Configuration::getGlobalValue(self::prefijo . 'MULTIPLICADOR_SERIE_PRODUCTOS');
            $actNumSerie = Configuration::getGlobalValue(self::prefijo . 'ACT_NOM_SER');
            $modoPlantilla = Configuration::getGlobalValue(self::prefijo . 'MODO_PLANTILLA');
            $separadorPlantilla = Configuration::getGlobalValue(self::prefijo . 'SEPARADOR_PLANTILLA');
            $separadorPlantillaAlternativamente = Configuration::getGlobalValue(self::prefijo . 'SEPARADOR_PLANTILLA_ALTERNATIVAMENTE');
            $conservarSeparador = Configuration::getGlobalValue(self::prefijo . 'CONSERVAR_SEPARADOR');
            $conservarSeparadorAlternativamente = Configuration::getGlobalValue(self::prefijo . 'CONSERVAR_SEPARADOR_ALTERNATIVAMENTE');
            $partesPlantilla = Configuration::getGlobalValue(self::prefijo . 'PARTES_PLANTILLA');
            $partesPlantillaLote = Configuration::getGlobalValue(self::prefijo . 'PARTES_PLANTILLA_LOTE');
            $partesPlantillaLoteAlternativamente = Configuration::getGlobalValue(self::prefijo . 'PARTES_PLANTILLA_LOTE_ALTERNATIVAMENTE');
            $agregarNumerosSerieFactura = Configuration::getGlobalValue(self::prefijo . 'NSERIE_FACTURA');
            $deluxeTracking = Configuration::getGlobalValue(self::prefijo . 'DELUXE_TRACKING');
            $token = Configuration::getGlobalValue(self::prefijo . 'TOKEN_CRON');
            $selectorGrupos = Configuration::getGlobalValue(self::prefijo . 'SELECTOR_GRUPOS');
            $inicio = date('Y-m-d', time() - 60 * 60 * 24 * 30);
            $fin = date('Y-m-d');
            $idEstado = Configuration::getGlobalValue('PS_OS_PAYMENT');


            $form->createFormRadioButtonGroup(array(
                array('value' => self::PLANTILLA_ALTERNATIVAMENTE, 'text' => $this->l('Alternativamente'), 'name' => 'modoPlantilla', 'checked' => $modoPlantilla == self::PLANTILLA_ALTERNATIVAMENTE),
                array('value' => self::PLANTILLA_COMODINES, 'text' => $this->l('Con comodines'), 'name' => 'modoPlantilla', 'checked' => $modoPlantilla == self::PLANTILLA_COMODINES),
                array('value' => self::PLANTILLA_PARTES, 'text' => $this->l('Con partes'), 'name' => 'modoPlantilla', 'checked' => $modoPlantilla == self::PLANTILLA_PARTES)
                    ), $this->l('Tipo de plantilla'));
            //Plantilla comodines
            $form->addToForm('<div id="grupoComodines">');
            $form->createFormTextGroup('plantilla', $plantilla, $this->l('Plantilla Referencia'));
            $form->createFormInfomationText($this->l('Utilizar # para seleccionar el caracter de la posicion correspondiente. Si no hay nada en la plantilla se pedira el numero de serie o lote al acabar de escanear el producto.'));
            $form->addToForm('</div>');
            //Plantilla partes
            $form->addToForm('<div id="grupoPartes">');
            $form->createFormTextGroup('separadorPlantilla', $separadorPlantilla, $this->l('Separador de grupos'));
            $form->createFormCheckboxGroup('conservarSeparador', $this->l('Mantener el separador de grupos en la referencia'), $conservarSeparador);
            $form->createFormTextGroup('partesPlantilla', $partesPlantilla, $this->l('Grupos referencia'));
            $form->createFormTextGroup('partesPlantillaLote', $partesPlantillaLote, $this->l('Grupos lote'));
            $form->createFormInfomationText($this->l('El "separador de grupos" suele ser un unico caracter (ej: -). "Grupos referencia" y "Grupos lote" es una lista de numeros separados por comas, la primera posicion es el 1, en blanco para seleccionar todos los grupos.'));
            $form->addToForm('</div>');
            //Plantilla alternativamente
            $form->addToForm('<div id="grupoAlternativamente">');
            $form->createFormTextGroup('separadorPlantillaAlternativamente', $separadorPlantillaAlternativamente, $this->l('Separador de grupos en el lote (de haberlo)'));
            $form->createFormSelect('selectorGrupos', $this->l('Posicion de los grupos'), [
                0 => $this->l('Las indicadas en "Grupos lote"'),
                1 => $this->l('El ultimo grupo')
            ], $selectorGrupos);
            $form->addToForm('<div id="partesAlternativamente">');
            $form->createFormTextGroup('partesPlantillaLoteAlternativamente', $partesPlantillaLoteAlternativamente, $this->l('Grupos lote'));
            $form->createFormCheckboxGroup('conservarSeparadorAlternativamente', $this->l('Mantener el separador de grupos'), $conservarSeparadorAlternativamente);
            $form->createFormInfomationText($this->l('El "separador de grupos" suele ser un unico caracter (ej: -). "Grupos lote" es una lista de numeros separados por comas, la primera posicion es el 1, en blanco para seleccionar todos los grupos.'));
            $form->addToForm('</div>');
            $form->addToForm('</div>');

            $form->createFormTextGroup('nombreCampoNumSerie', $nombreCampoNumSerie, 'Nombre Campo');
            $form->addToForm('<div id="contenedorMultiplicadorSerieProductos">');
            $form->createFormCheckboxGroup('multiplicadorSerieProductos', $this->l('Al escanear numeros de serie introducir la misma cantidad que de productos escaneados'), $multiplicadorSerieProductos);
            $form->addToForm('</div>');
            $form->createFormCheckboxGroup('actNumSerie', $this->l('Activar los numeros de serie en todos los productos'), $actNumSerie);
            $form->createFormCheckboxGroup('agregarNumerosSerieFactura', $this->l('Mostrar los numeros de serie en la factura'), $agregarNumerosSerieFactura);
            $form->createFormInfomationText($this->l('Si marca la opcion anterior todos los productos usaran el numero de serie, si no esta marcado ha de indicar en cada producto que tenga numero de serie o lote o fecha de caducidad'));
            $form->createFormCheckboxGroup('deluxeTracking', $this->l('Conectar con el modulo de tracking de Innova Deluxe'), $deluxeTracking);
            $form->createFormInfomationText($this->l('Use el enlace siguiente para descargar el listado de numeros de serie y pedidos.'));
            $form->createFormInfomationText('<a href="' . $this->_path . $this->name . '_export.php?token=' . $token . '&fechaInicio=' . $inicio . '&fechaFin=' . $fin . '&idEstado=' . $idEstado . '" target="_blank">' . $this->_path . $this->name . '_export.php?token=' . $token . '&fechaInicio=' . $inicio . '&fechaFin=' . $fin . '&idEstado=' . $idEstado . '</a>', 'confirm', true);
            $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
            $html .= $acordeon->renderAcordeon($this->l('Numeros de serie'), $form->renderForm());
        }

        return $html;
    }
    
    /**
     * Devuelve la lista de productos seleccionados para no hacerles picking.
     * @return string
     */
    private function generarListadoProductosNoPicking() {
        $productos = json_decode(Configuration::getGlobalValue(self::prefijo.'PRODUCTOS_NO_PICKING'));

        $filas = [];
        foreach($productos as $producto) {
            $filas[] = '<li data-id_product="'.$producto.'">'.$producto.' - '.Product::getProductName($producto).' <input type="button" name="eliminar" value="X"/></li>';
        }

        return '<ul>'.implode('', $filas).'</ul>';
    }
    
    /**
     * Indica si están disponibles las ubicaciones de Prestashop.
     * @return boolean
     */
    private function hayUbicacionesPresta() {
        $ubicaciones = false;
        
        $columnas = Db::getInstance()->executeS('DESCRIBE '._DB_PREFIX_.'stock_available');
        foreach($columnas as $columna) {
            if($columna['Field'] == 'location') {
                $ubicaciones = true;
                break;
            }
        }
        
        return $ubicaciones;
    }

    private function _mostrarLicencia() {
        include_once(dirname(__FILE__) . '/functionsForm.php');
        include_once(dirname(__FILE__) . '/imaxAcordeon.php');
        $licenseDomain = self::getDomain();
        $html = '';
        $form = new imaxForm($this, $this->_path);
        $acordeon = new imaxAcordeon($this->_path);
        if (!$licenseDomain) {
            $form->createFormInfomationText('La configuracion de su tienda no es correcta. No se puede determinar el dominio');
            $html .= $acordeon->renderAcordeon($this->l('Gestion Licencia'), $form->renderForm());
            Configuration::updateGlobalValue(self::prefijo . 'LICENCIA', '');
            Configuration::updateGlobalValue(self::prefijo . 'F', '');
            Configuration::updateGlobalValue(self::prefijo . 'F_CHECK', 1001);
        } else {
            $licencia = Configuration::getGlobalValue(self::prefijo . 'LICENCIA');
            $form->createHidden("action", "gestionLicencia");
            $form->createHidden("idTab", "6");
            $form->createFormInfomationText('ATENCION:  La licencia es obligatoria para el correcto funcionamiento del modulo');
            $form->createFormInfomationText($this->l('La licencia se deberia generar para el dominio: ') . $licenseDomain, 'notice', true);
            $form->createFormTextGroup('licencia', $licencia, 'Numero de Licencia');
            $form->createSubmitButton('submitLicencia', $this->l('Guardar'));
            $html .= $acordeon->renderAcordeon($this->l('Gestion Licencia'), $form->renderForm());
        }

        include(dirname(__FILE__) . "/configuration.php");
        if (isset($plugins) && is_array($plugins) && !empty($plugins)) {
            $licenciasAdicionales = $this->getOtrasLicencias();
            $html2 = '';
            $html2 .= '<form action="' . Tools::safeOutput($_SERVER['REQUEST_URI']) . '" method="post">';
            $html2 .= '<div class="bootstrap">';
            $html2 .= '<div class="module_confirmation conf confirm alert alert-success">';
            $html2 .= $this->l('Introduzca las licencias para los plugins adicionales');
            $html2 .= '<br />';
            $html2 .= $this->l('Puede obtener las licencias en: ');
            $html2 .= '<a href="tienda.informax.es" target="_blank">tienda.informax.es</a>';
            $html2 .= '</div>';
            $html2 .= '</div>';
            $html2 .= '<table class="table tableDnD tablaImportProductos listaLicencia">';
            $html2 .= '<tr>';
            $html2 .= '<th>' . $this->l('Nombre Plugin') . '</th>';
            $html2 .= '<th>' . $this->l('Licencia') . '</th>';
            $html2 .= '<th>' . $this->l('Estado') . '</th>';
            $html2 .= '</tr>';
            foreach ($plugins AS $plugin) {
                $html2 .= '<tr>';
                $html2 .= '<td>';
                $html2 .= $plugin['nombre'] . ' (' . $plugin['descripcion'] . ')';
                $html2 .= '</td>';
                $valorLicencia = '';
                $estado = 'ausente';
                foreach ($licenciasAdicionales AS $licenciaAdicional) {
                    if ($licenciaAdicional['nombre'] == $plugin['nombre']) {
                        $valorLicencia = $licenciaAdicional['licencia'];
                        if ($licenciaAdicional['validate'] == 0) {
                            $estado = 'incorrecta';
                        } else if ($licenciaAdicional['validate'] == 1) {
                            $estado = 'correcta';
                        }
                        continue;
                    }
                }
                $html2 .= '<td>';
                $html2 .= '<input type="text" name="licenciaAdicional[' . $plugin['nombre'] . ']" value="' . $valorLicencia . '">';
                $html2 .= '</td>';
                $html2 .= '<td>';
                $html2 .= '<img src="' . $this->_path . '/css/estadoLicencia_' . $estado . '.png" alt="Licencia ' . $estado . '" title="Licencia ' . $estado . '">';
                $html2 .= '</td>';
                $html2 .= '</tr>';
            }
            $html2 .= '</table>';
            $html2 .= '<p><button class="btn btn-default pull-right" name="submitLicenciaAdicional" type="submit"><i class="process-icon-save"></i>' . $this->l('Guardar') . '</button></p>';
            $html2 .= '<input type="hidden" name="action" value="gestionLicenciaAdicional">';
            $html2 .= '<input type="hidden" name="idTab" value="6" />';
            $html2 .= '</form>';
            $html .= $acordeon->renderAcordeon($this->l('Licencias Adicionales'), $html2);
        }

        return $html;
    }

    private function getFunction() {
        $function = Configuration::getGlobalValue(self::prefijo . 'F');
        return $function;
    }

    /**
     * Devuelve una parte de un pedido y genera otro con ella.
     * @param Order $pedido
     * @param array $productos { product_id, product_attribute_id, cantidad }
     * @return string Un mensaje de error o un string vacio.
     */
    public function ajustarPedidoIncompleto($pedido, $productos) {
        $mensaje = '';
        
        //Calculamos lo que hay que devolver y el contenido del nuevo pedido
        $devoluciones = array();
        $nuevoPedido = array();
        $listaPedido = $pedido->getOrderDetailList();
        foreach($listaPedido as $lineaPedido) {
            if($lineaPedido['product_quantity'] > 0) {
                if($productos[$lineaPedido['id_order_detail']]['idPack']) {
                    //Es un pack
                    $packVacio = true;
                    $componentesRestantes = array();
                    foreach($productos[$lineaPedido['id_order_detail']]['restante'] as $id_product => $productoTemp) {
                        foreach($productoTemp as $id_product_attribute => $restante) {
                            if($restante <= 0) {
                                //La linea se sirvio completa
                                $packVacio = false;
                            }
                            else {
                                $componentesRestantes[] = array(
                                    'id_product' => $id_product,
                                    'id_product_attribute' => $id_product_attribute,
                                    'cantidad' => (int)$restante,
                                    'precioSinImpuestos' => 0,
                                    'precioConImpuestos' => 0);
                            }
                        }
                    }

                    if($packVacio) {
                        //Lo devolvemos si esta vacio y lo agregamos al nuevo pedido
                        $devoluciones[$lineaPedido['id_order_detail']] = array(
                            'id_order_detail' => $lineaPedido['id_order_detail'],
                            'quantity' => (int)$lineaPedido['product_quantity'],
                            'unit_price' => $lineaPedido['unit_price_tax_excl'],
                            'amount' => $lineaPedido['unit_price_tax_incl'] * (int)$lineaPedido['product_quantity'],
                            'id_product' => $lineaPedido['product_id'],
                            'id_product_attribute' => 0,
                        );

                        $nuevoPedido[] = array(
                            'id_product' => $lineaPedido['product_id'],
                            'id_product_attribute' => 0,
                            'cantidad' => (int)$lineaPedido['product_quantity'],
                            'precioSinImpuestos' => $lineaPedido['unit_price_tax_excl'],
                            'precioConImpuestos' => $lineaPedido['unit_price_tax_incl']
                        );
                    }
                    else {
                        //Mandamos los productos que faltan al nuevo pedido con precio cero
                        $nuevoPedido = array_merge($nuevoPedido, $componentesRestantes);
                    }
                }
                else {
                    //Es un producto
                    foreach($productos[$lineaPedido['id_order_detail']]['restante'] as $id_product => $productoTemp) {
                        foreach($productoTemp as $id_product_attribute => $restante) {
                            if($restante > 0) {
                                $devoluciones[$lineaPedido['id_order_detail']] = array(
                                    'id_order_detail' => $lineaPedido['id_order_detail'],
                                    'quantity' => (int)$restante,
                                    'unit_price' => $lineaPedido['unit_price_tax_excl'],
                                    'amount' => $lineaPedido['unit_price_tax_incl'] * (int)$restante,
                                    'id_product' => $id_product,
                                    'id_product_attribute' => $id_product_attribute,
                                );

                                $nuevoPedido[] = array(
                                    'id_product' => $id_product,
                                    'id_product_attribute' => $id_product_attribute,
                                    'cantidad' => (int)$restante,
                                    'precioSinImpuestos' => $lineaPedido['unit_price_tax_excl'],
                                    'precioConImpuestos' => $lineaPedido['unit_price_tax_incl']
                                );
                            }
                        }
                    }
                }
            }
        }

        if($devoluciones && Configuration::getGlobalValue(self::prefijo . 'DEVOLUCION_INCOMPLETOS')) {
            if(!$this->devolverNoProcesado($pedido, $devoluciones)) {
                $mensaje = $this->l('No se pudo generar la devolucion.');   
            }
        }
        
        if(!$mensaje && $nuevoPedido) {
            $mensaje = $this->crearNuevoPedidoNoProcesado($pedido, $nuevoPedido);
        }

        return $mensaje;
    }
    
    /**
     * Genera una devolucion.
     * @param Order $pedido
     * @param array $lineas [{id_order_detail, quantity, unit_price, amount, id_product, id_product_attribute}], los productos a devolver.
     * @return boolean
     */
    private function devolverNoProcesado($pedido, $lineas) {
        $resultado = OrderSlip::create($pedido, $lineas);
        if($resultado) {
            foreach($lineas as $linea) {
                StockAvailable::updateQuantity($linea['id_product'], $linea['id_product_attribute'], $linea['quantity']);
            }
        }
        
        return $resultado;
    }
    
    /**
     * Crea un pedido copiando otro pero con los productos indicados.
     * @param Order $pedidoOrigen
     * @param array $productos { id_product, id_product_attribute, cantidad, precioSinImpuestos, precioConImpuestos }, los productos a incluir.
     * @return string El mensaje de error o string vacio.
     */
    private function crearNuevoPedidoNoProcesado($pedidoOrigen, $productos) {
        $mensajeError = '';

        try {
            $formaPagoObj = Module::getInstanceByName($pedidoOrigen->module);
            if (!$formaPagoObj) {
                $mensajeError = $this->l('No se encontro la forma de pago.');
            } 
            $cliente = new Customer($pedidoOrigen->id_customer);
            if(!Validate::isLoadedObject($cliente)) {
                $mensajeError = $this->l('No se encontro el cliente.');
            }
            if (!$productos) {
                $mensajeError = $this->l('No hay productos que agregar.');
            }

            if (!$mensajeError) {
                //Mensaje
                $mensaje = $this->l('Proviene del pedido:').' '.$pedidoOrigen->id;
                $mensajeOriginal = $pedidoOrigen->getFirstMessage();
                if($mensajeOriginal) {
                    $mensaje .= '<br/>'.$mensajeOriginal;
                }

                //Carro y contexto
                $carro = clone new Cart($pedidoOrigen->id_cart);
                $contexto = Context::getContext();
                $contexto->customer = new Customer($pedidoOrigen->id_customer);
                $contexto->currency = new Currency($carro->id_currency);
                $carro->add();
                $contexto->cart = $carro;
                
                //Los productos
                $productosRepetidos = array();
                foreach ($productos as $producto) {
                    if (Product::existsInDatabase($producto['id_product'], 'product')) {
                        if (!$carro->updateQty($producto['cantidad'], $producto['id_product'], $producto['id_product_attribute'])) {
                            $mensajeError = $this->l('No se pudo agregar el producto:').' '.$producto['id_product'].' - '.$producto['id_product_attribute'];
                            $carro->delete();
                            break;
                        }
                    } else {
                        $mensajeError = $this->l('No existe el producto:').' '.$producto['id_product'].' - '.$producto['id_product_attribute'];
                        $carro->delete();
                        break;
                    }
                    
                    if($producto['precioConImpuestos'] > 0) {
                        $productosRepetidos[$producto['id_product']][$producto['id_product_attribute']] = $producto['precioConImpuestos'];
                    }
                }
                
                if (!$mensajeError) {
                    $contexto = Context::getContext();
                    $contexto->customer = $cliente;
					
                    //Total pedido
                    $total = $pedidoOrigen->total_shipping_tax_incl;
                    foreach($productos as $producto) {//Si los productos tienen ecotasa falla el precio 0
                        if(!(float)$producto['precioSinImpuestos'] && isset($productosRepetidos[$producto['id_product']][$producto['id_product_attribute']])) {
                            //Es un producto ya pagado
                            $id = $this->crearBono($productosRepetidos[$producto['id_product']][$producto['id_product_attribute']] * (int)$producto['cantidad'], 'Producto ya pagado');
                            if($id) {
                                $carro->addCartRule($id);
                            }
                        }
                        else {
                            $total += $producto['precioConImpuestos'] * (int)$producto['cantidad'];

                            //Igualamos el precio del producto
                            $precio = new SpecificPrice();
                            $precio->id_cart = $carro->id;
                            $precio->id_product = $producto['id_product'];
                            $precio->id_product_attribute = $producto['id_product_attribute'];
                            $precio->price = $producto['precioSinImpuestos'];
                            $precio->id_shop = $pedidoOrigen->id_shop;
                            $precio->id_currency = 0;
                            $precio->id_country = 0;
                            $precio->id_group = 0;
                            $precio->id_customer = $pedidoOrigen->id_customer;
                            $precio->from_quantity = 1;
                            $precio->reduction = 0;
                            $precio->reduction_type = 'amount';
                            $precio->from = '0000-00-00';
                            $precio->to = '0000-00-00';
                            $precio->add();
                        }
                    }
                    
                    $estadoIncompleto = Configuration::getGlobalValue(self::prefijo . 'ESTADO_INCOMPLETO');
                    if($estadoIncompleto) {
                        $estado = new OrderState($estadoIncompleto);
                    }
                    else {
                        $estado = $pedidoOrigen->getCurrentOrderState();
                    }

                    //Creamos el pedido
                    if (!$formaPagoObj->validateOrder($carro->id, ($estado ? $estado->id : Configuration::getGlobalValue('PS_OS_ERROR')), $total, 
                            $formaPagoObj->displayName, $mensaje, array(), NULL, FALSE, $cliente->secure_key)) {
                        $mensajeError = $this->l('No se pudo validar el pedido.');
                    }
                }
            }
        } catch (Exception $ex) {
            $mensajeError = $ex->getMessage();
        }

        return $mensajeError;
    }
    
    /**
     * Crea un nuevo bono.
     * @param float $precio
     * @param string $name
     * @return int
     */
    public function crearBono($precio, $name) {
        if ($precio) {
            try {
                $cartRule = new CartRule();
                $uid = substr(uniqid('', true), -8);
                if (!$name) {
                    $name = $uid;
                }
                $cartRule->name[$this->idLang] = $name;
                $cartRule->date_from = date('Y-m-d H:i:s');
                $cartRule->date_to = date('Y-m-d H:i:s', time() + 10 * 30 * 24 * 60 * 60);
                $cartRule->free_shipping = 0;
                $cartRule->partial_use = 0;
                $cartRule->code = $uid;
                $cartRule->quantity = 1;
                $cartRule->quantity_per_user = 1;
                $cartRule->reduction_tax = 1;
                $cartRule->reduction_amount = $precio;
                $cartRule->reduction_product = 0;
                $cartRule->highlight = 0;
                $cartRule->cart_rule_restriction = true;
                $cartRule->add();

                return $cartRule->id;
            }
            catch(Exception $ex) { }
        }
        
        return false;
    }
    
    /**
     * Devuelve el telefono falso para el pais de estar configurado.
     * Se llama desde otros módulos.
     * @param Order $pedido
     * @return string
     */
    public function obtenerTelefonoFalso($pedido) {
        $telefono = '';
        
        $telefonosFalsos = unserialize(Configuration::getGlobalValue(self::prefijo.'TELEFONOS_FALSOS'));
        $direccion = new Address($pedido->id_address_delivery);
        if(!empty($telefonosFalsos[$direccion->id_country])) {
            $telefono = $telefonosFalsos[$direccion->id_country];
        }
        
        return $telefono;
    }

    /**
     * Devuelve los datos economicos.
     * @param int $idProveedor
     * @param string $codigosPostales
     * @param int[] $idsTienda
     * @param int $idLocal
     * @param string $email
     * @param string $pass
     * @return \stdClass
     */
    public function datosEconomicos($idProveedor = 0, $codigosPostales = '', $idsTienda = array(), $idLocal = 0, $email = '', $pass = '') {
        $date_from = date("Y-m-d");
        $date_to = date("Y-m-d H:i:s");

        $datos = new stdClass();

        $estadosDescartados = unserialize(Configuration::get(self::prefijo . 'DESCARTADO'));

        $datos->cantidadPedidos = $this->contarPedidos(FALSE, '', 0, TRUE, 0, $date_from, $date_to, $estadosDescartados, '', $idProveedor, 
                $codigosPostales, 0, '', 0, $idsTienda, false, $idLocal, $email, $pass);
        $datos->vendido = 0;
        $datos->iva = 0;
        $datos->portes = 0;
        
        $idsPedido = $this->obtenerPedidos(FALSE, '', 0, 0, 0, TRUE, 'ASC', 0, $date_from, $date_to, $estadosDescartados, '', $idProveedor, 
                $codigosPostales, 0, 0, '', 0, $idsTienda, false, $idLocal, $email, $pass);
        foreach ($idsPedido as $numPedido) {
            $order = new Order((int) $numPedido);

            $datos->vendido += $order->total_products;
            $datos->portes += $order->total_shipping_tax_excl;
            $datos->iva += $order->total_paid_tax_incl - $order->total_paid_tax_excl;
        }

        $datos->vendido = Tools::displayPrice($datos->vendido);
        $datos->portes = Tools::displayPrice($datos->portes);
        $datos->iva = Tools::displayPrice($datos->iva);

        return $datos;
    }
    
    /**
     * Devuelve la ruta de la imagen de la combinacion o la imagen de portada del producto.
     * @param int $idProducto
     * @param int $idCombinacion
     * @param int $tipo 1 -> pequeña, 2 -> mediana.
     * @return string
     */
    private function obtenerUrlImagen($idProducto, $idCombinacion = 0, $tipo = 1) {
        $url = '';
        
        switch($tipo) {
            case 2:
                if(!self::$tipoImagenMediana) {
                    $image_sizes = ImageType::getImagesTypes('products');
                    $width = 1000;
                    self::$tipoImagenMediana = '';
                    foreach ($image_sizes AS $image_size) {
                        if ($image_size['width'] < $width && $image_size['width'] >= 200) {
                            $width = $image_size['width'];
                            self::$tipoImagenMediana = $image_size['name'];
                        }
                    }
                }
                $type = self::$tipoImagenMediana;
                break;
            
            default:
                if(!self::$tipoImagenMini) {
                    $image_sizes = ImageType::getImagesTypes('products');
                    $width = 1000;
                    self::$tipoImagenMini = '';
                    foreach ($image_sizes AS $image_size) {
                        if ($image_size['width'] < $width) {
                            $width = $image_size['width'];
                            self::$tipoImagenMini = $image_size['name'];
                        }
                    }
                }
                $type = self::$tipoImagenMini;
                break;
        }
        
        if($type) {
            $id_image_temp = false;
            if($idCombinacion) {
                $comb = new Combination($idCombinacion);
                $imagenesComb = $comb->getWsImages();
                if($imagenesComb) {
                    if(!isset($imagenesComb[0]['id_image'])) {
						$id_image_temp = $imagenesComb[0]['id'];
					}
					else {
						$id_image_temp = $imagenesComb[0]['id_image'];
					}
                }
            }

            if(!$id_image_temp) {
                $id_image_temp = Product::getCover($idProducto);
                if($id_image_temp) {
                    $id_image_temp = $id_image_temp['id_image'];
                }
            }

            if($id_image_temp) {
                $productoObj = new Product($idProducto);
                $name = $productoObj->link_rewrite[Configuration::getGlobalValue('PS_LANG_DEFAULT')];
                $ids = $productoObj->id.'-'.$id_image_temp;

                $not_default = false;
                // legacy mode or default image
                $theme = ((Shop::isFeatureActive() && file_exists(_PS_PROD_IMG_DIR_.$ids.($type ? '-'.$type : '').'-'.(int)Context::getContext()->shop->theme_name.'.jpg')) ? '-'.Context::getContext()->shop->theme_name : '');
                if ((Configuration::get('PS_LEGACY_IMAGES') && (file_exists(_PS_PROD_IMG_DIR_.$ids.($type ? '-'.$type : '').$theme.'.jpg'))) || ($not_default = strpos($ids, 'default') !== false)) {
                    if ((int)Configuration::get('PS_REWRITING_SETTINGS') == 1 && !$not_default) {
                        $uri_path = $this->context->shop->getBaseUri().$ids.($type ? '-'.$type : '').$theme.'/'.$name.'.jpg';
                    }
                    else {
                        $uri_path = _THEME_PROD_DIR_.$ids.($type ? '-'.$type : '').$theme.'.jpg';
                    }
                }
                else {
                    // if ids if of the form id_product-id_image, we want to extract the id_image part
                    $split_ids = explode('-', $ids);
                    $id_image = (isset($split_ids[1]) ? $split_ids[1] : $split_ids[0]);
                    $theme = ((Shop::isFeatureActive() && file_exists(_PS_PROD_IMG_DIR_.Image::getImgFolderStatic($id_image).$id_image.($type ? '-'.$type : '').'-'.(int)Context::getContext()->shop->theme_name.'.jpg')) ? '-'.Context::getContext()->shop->theme_name : '');
                    if ((int)Configuration::get('PS_REWRITING_SETTINGS') == 1) {
                        $uri_path = $this->context->shop->getBaseUri().$id_image.($type ? '-'.$type : '').$theme.'/'.$name.'.jpg';
                    }
                    else {
                        $uri_path = _THEME_PROD_DIR_.Image::getImgFolderStatic($id_image).$id_image.($type ? '-'.$type : '').$theme.'.jpg';
                    }
                }

                $url = 'http://'.Tools::getMediaServer($uri_path).$uri_path;
            }
        }
        
        return $url;
    }
    
    /**
     * Devuelve los pedidos para imprimir.
     * @param string $textoBuscado
     * @param int $idEstado
     * @param int $orden
     * @param int $referenciaTransportista
     * @param string $fechaDesde
     * @param string $fechaHasta
     * @param string $formaPago
     * @param int $idProveedor
     * @param string $codigosPostales
     * @param int $imprimidos
     * @param int $campoOrden
     * @param string $ubicacion
     * @param int $idPais
     * @param int[] $idsTienda
     * @param string[] $documentos
     * @param boolean $marcarNoSolicitados
     * @param int $idLocal
     * @param string $email
     * @param string $pass
     * @return array
     */
    public function pedidosParaImprimir($textoBuscado = FALSE, $idEstado = 0, $orden = 0, 
            $referenciaTransportista = 0, $fechaDesde = '', $fechaHasta = '', $formaPago = '', $idProveedor = 0, $codigosPostales = '', 
            $imprimidos = 0, $campoOrden = 0, $ubicacion = '', $idPais = 0, $idsTienda = array(), $documentos = array(), 
            $marcarNoSolicitados = false, $idLocal = 0, $email = '', $pass = '') {
        $resultado = array('datos' => array());
        
        if ($idEstado == -1) {
            //Con incidencias
            $idEstado = 0;
            $soloIncidencias = TRUE;
        } else {
            $soloIncidencias = FALSE;
        }

        if ($orden == 0) {
            $ordenString = 'DESC';
        } else {
            $ordenString = 'ASC';
        }
        
        $idsTransportista = $this->obtenerTodosTransportistasPorReferencia($referenciaTransportista);

        $centralizador = new CentralizadorEtiquetas($this);
        $estadosDescartados = unserialize(Configuration::get(self::prefijo . 'DESCARTADO'));
        if(is_array($documentos)) {
            array_walk($documentos, 'trim');
            $documentos = array_filter($documentos);
        }
        $idsPedido = $this->obtenerPedidos(true, $textoBuscado, 0, 0, $idEstado, FALSE, $ordenString, $idsTransportista, $fechaDesde, $fechaHasta, 
                $estadosDescartados, $formaPago, $idProveedor, $codigosPostales, $imprimidos, $campoOrden, $ubicacion, $idPais, $idsTienda, $documentos, 
                $idLocal, $email, $pass);
        foreach($idsPedido as $idPedido) {
            if($marcarNoSolicitados && $documentos) {
                $this->marcarDescargado($idPedido, array_diff(self::$tiposDocumentos, $documentos));
            }
            
            $pedido = new Order($idPedido);
            $estadoActual = $pedido->getCurrentOrderState();
            $temp = $this->cargarDescargado($pedido->id);
            $transportista = new Carrier($pedido->id_carrier);
            $generador = $centralizador->obtenerGenerador($transportista->id_reference);
            
            $resultado['datos'][] = array(
                'id' => $pedido->id, 
                'pagado' => ($estadoActual ? (boolean) $estadoActual->paid : false),
                'facturaDescargado' => $temp['facturaDescargado'],
                'pedidoDescargado' => $temp['pedidoDescargado'],
                'etiquetaDescargado' => $temp['etiquetaDescargado'],
                'tipoEtiqueta' => (Validate::isLoadedObject($transportista) ? $transportista->name : 'etiquetaDefecto'),
                'inversa' => ($generador instanceof GeneradorEtiquetaCorreosExpress && $generador->cargarConfiguracion()->inversaCex),
                'estado' => ($estadoActual ? $estadoActual->id : 0)
            );
        }
        
        return $resultado;
    }
    
    /**
     * Devuelve los pedidos.
     * @param boolean $pendientes Si es true devuelve los pedidos sin imprimir, de lo contrario devuelve los ya impresos.
     * @param string $textoBuscado
     * @param int $cantidad 0 para todos.
     * @param int $pagina
     * @param int $idEstado
     * @param int $referenciaTransportista
     * @param string $fechaDesde
     * @param string $fechaHasta
     * @param string $formaPago
     * @param int $idProveedor
     * @param string $codigosPostales
     * @param int $imprimidos
     * @param int $campoOrden
     * @param string $ubicacion
     * @param int $idPais
     * @param int[] $idsTienda
     * @param int $idLocal
     * @param string $idLocal
     * @param string $idLocal
     * @return array
     */
    public function pedidos($pendientes = TRUE, $textoBuscado = FALSE, $cantidad = 0, $pagina = 0, $idEstado = 0, $orden = 0, 
            $referenciaTransportista = 0, $fechaDesde = '', $fechaHasta = '', $formaPago = '', $idProveedor = 0, $codigosPostales = '', 
            $imprimidos = 0, $campoOrden = 0, $ubicacion = '', $idPais = 0, $idsTienda = array(), $idLocal = 0, $email = '', $pass = '') {
        if ($idEstado == -1) {
            //Con incidencias
            $idEstado = 0;
            $soloIncidencias = TRUE;
        } else {
            $soloIncidencias = FALSE;
        }

        if ($orden == 0) {
            $ordenString = 'DESC';
        } else {
            $ordenString = 'ASC';
        }
        
        $idsTransportista = $this->obtenerTodosTransportistasPorReferencia($referenciaTransportista);

        $estadosDescartados = unserialize(Configuration::get(self::prefijo . 'DESCARTADO'));
        $idsPedido = $this->obtenerPedidos($pendientes, $textoBuscado, $cantidad, $pagina, $idEstado, FALSE, $ordenString, $idsTransportista, 
                $fechaDesde, $fechaHasta, $estadosDescartados, $formaPago, $idProveedor, $codigosPostales, $imprimidos, $campoOrden, $ubicacion,
                $idPais, $idsTienda, false, $idLocal, $email, $pass);
        $cantidadTotal = $this->contarPedidos($pendientes, $textoBuscado, $idEstado, FALSE, $idsTransportista, $fechaDesde, $fechaHasta, 
                $estadosDescartados, $formaPago, $idProveedor, $codigosPostales, $imprimidos, $ubicacion, $idPais, $idsTienda, false, $idLocal, 
                $email, $pass);

        $estadosIncidencia = unserialize(Configuration::getGlobalValue(self::prefijo . 'INCIDENCIA'));
        $referenciasTransportista = $this->obtenerReferenciaTransportistas();
        $aliasFormasPago = unserialize(Configuration::getGlobalValue(self::prefijo . 'ALIAS_FORMAS_PAGO'));

        $totalSobrante = 0;
        $pedidos = new stdClass();
        $pedidos->datos = array();
        foreach ($idsPedido as $numPedido) {
            $resultadoTemp = $this->obtenerFilaPedido($numPedido, $estadosIncidencia, $referenciasTransportista, $aliasFormasPago);
            if ($soloIncidencias && !$resultadoTemp['incidencia']) {
                $totalSobrante++;
            }
            else {
                $pedidos->datos[] = $resultadoTemp;
            }
        }
        
        $idCliente = $this->comprobarEmailyPass($email, $pass);
        $cliente = new Customer($idCliente);

        $pedidos->numPedidos = $cantidadTotal - $totalSobrante;
        $pedidos->cliente = (Validate::isLoadedObject($cliente) ? $cliente->firstname.' '.$cliente->lastname : '');

        return $pedidos;
    }
    
    /**
     * Genera un array con los datos de una fila de pedido.
     * @param int $id_order
     * @param int[] $estadosIncidencia
     * @param int[] $referenciasTransportista
     * @param string[] $aliasFormasPago
     * @param boolean $esReferencia Indica si el id de pedido es en realidad la referencia.
     * @return array
     */
    public function obtenerFilaPedido($id_order, $estadosIncidencia, $referenciasTransportista, $aliasFormasPago, $esReferencia = false) {
        if($esReferencia) {
            $pedidos = Order::getByReference($id_order);
            $order = $pedidos->getFirst();
            if(!$order) {
                $order = new Order();
            }
        }
        else {
            $order = new Order((int) $id_order);
        }
        $moneda = new Currency($order->id_currency, $this->context->language->id);

        $resultadoTemp = array();
        $resultadoTemp['id'] = (int)$order->id;
        $resultadoTemp['codigo'] = $order->id . " - " . $order->reference;
        $resultadoTemp['creacion'] = strtotime($order->date_add);
        $mensaje = $order->getFirstMessage();
        if (!$mensaje) {
            $mensaje = '';
        }
        $resultadoTemp['mensaje'] = $mensaje;
        $resultadoTemp['estado'] = $order->current_state;
        $estadoActual = $order->getCurrentOrderState();
        $resultadoTemp['pagado'] = ($estadoActual ? (boolean) $estadoActual->paid : FALSE);
        $temp = $this->cargarDescargado($order->id);
        $resultadoTemp['facturaDescargado'] = $temp['facturaDescargado'];
        $resultadoTemp['pedidoDescargado'] = $temp['pedidoDescargado'];
        $resultadoTemp['etiquetaDescargado'] = $temp['etiquetaDescargado'];

        //Cogemos el historial para ver los estados
        $resultadoTemp['incidencia'] = FALSE;
        $historial = $order->getHistory($this->idLang);
        foreach ($historial as $estado) {
            if (in_array($estado['id_order_state'], $estadosIncidencia)) {
                $resultadoTemp['incidencia'] = TRUE;
                break;
            }
        }

        $transportista = new Carrier($order->id_carrier);
        if (Validate::isLoadedObject($transportista)) {
            $resultadoTemp['tipoEtiqueta'] = $transportista->name;
        } else {
            $resultadoTemp['tipoEtiqueta'] = 'etiquetaDefecto';
        }

        if (isset($referenciasTransportista[$order->id_carrier])) {
            $resultadoTemp['referenciaTransportista'] = $referenciasTransportista[$order->id_carrier];
        } else {
            $resultadoTemp['referenciaTransportista'] = 0;
        }
        $resultadoTemp['id_transportista'] = trim($order->id_carrier);
        
        $resultadoTemp['bultos'] = 0;
        $resultadoTemp['bultosBloqueado'] = false;
        if(isset($referenciasTransportista[$order->id_carrier])) {
            $generador = (new CentralizadorEtiquetas($this))->obtenerGenerador($referenciasTransportista[$order->id_carrier]);
            
            $imaxGls = Module::getInstanceByName('imaxgls');
            if($imaxGls) {
                $gls = unserialize(Configuration::getGlobalValue(ImaxGls::PREFIJO . '_TRANSPORTISTAS'));
                $dhl = unserialize(Configuration::getGlobalValue(ImaxGls::PREFIJO . '_TRANSPORTISTAS_DHL'));
                $imaxGlsManual = Configuration::getGlobalValue(ImaxGls::PREFIJO . '_BULTOS_MANUAL');
                if($imaxGlsManual && (($gls && in_array($referenciasTransportista[$order->id_carrier], $gls)) || 
                        ($dhl && in_array($referenciasTransportista[$order->id_carrier], $dhl)))) {
                    if(method_exists($imaxGls, 'cargarInfoBultos')) {
                        $datosBultos = $imaxGls->cargarInfoBultos($order->id);
                        $resultadoTemp['bultos'] = (int)($datosBultos ? $datosBultos['bultos'] : 1);
                        $resultadoTemp['bultosBloqueado'] = (boolean)($datosBultos ? $datosBultos['descargado'] : false);
                    }
                }
            }
            
            if(!$resultadoTemp['bultos'] && $generador->cargarConfiguracion()->bultosManuales) {
                $bultosManuales = new BultosManuales($order->id);
                $numBultos = $bultosManuales->obtenerBultosManuales();
                $resultadoTemp['bultos'] = ($numBultos ? $numBultos : 1);
                $resultadoTemp['bultosBloqueado'] = $generador->obtenerBultosBloqueados($order);
            }

            $resultadoTemp['inversa'] = ($generador instanceof GeneradorEtiquetaCorreosExpress && $generador->cargarConfiguracion()->inversaCex);
        }
        else {
            $resultadoTemp['inversa'] = false;
        }
        
        if($this->esGenerica($order->id_carrier)) {
            $generadorGenerico = new GeneradorEtiquetaGenerica($this);
            if($generadorGenerico->cargarConfiguracion()->bultosManuales) {
                $bultosManuales = new BultosManuales($order->id);
                $numBultos = $bultosManuales->obtenerBultosManuales();
                $resultadoTemp['bultos'] = ($numBultos ? $numBultos : 1);
                $resultadoTemp['bultosBloqueado'] = $generadorGenerico->obtenerBultosBloqueados($order);
            }
        }

        $resultadoTemp['productos'] = $this->obtenerDatosProductos($order);

        $resultadoTemp['direccion'] = $this->agruparDireccion($order->id_address_delivery);

        switch(Configuration::getGlobalValue(self::prefijo.'INFO_ADICIONAL')) {
            case 0:
                $datoAdicional = (!empty($aliasFormasPago[$order->module]) ? $aliasFormasPago[$order->module] : $order->payment);
                break;

            case 1:
                $cliente = new Customer($order->id_customer);
                $datoAdicional = $cliente->firstname.' '.$cliente->lastname;
                break;
        }
        $resultadoTemp['informacionAdicional'] = $datoAdicional;
        $resultadoTemp['formaPago'] = (!empty($aliasFormasPago[$order->module]) ? $aliasFormasPago[$order->module] : $order->payment);
        try {
            $resultadoTemp['totalPedido'] = ($this->versionPS >= 17.6 ? 
                    $this->context->currentLocale->formatPrice($order->total_paid_tax_incl, $moneda->iso_code) : 
                round($order->total_paid_tax_incl, 2).' '.$moneda->sign);
            $resultadoTemp['totalArticulos'] = ($this->versionPS >= 17.6 ? 
                    $this->context->currentLocale->formatPrice($order->total_products_wt, $moneda->iso_code) : 
                round($order->total_products_wt, 2).' '.$moneda->sign);
            $resultadoTemp['totalEnvio'] = ($this->versionPS >= 17.6 ? 
                    $this->context->currentLocale->formatPrice($order->total_shipping_tax_incl, $moneda->iso_code) : 
                round($order->total_shipping_tax_incl, 2).' '.$moneda->sign);

            $montando = Db::getInstance()->getRow('
                SELECT fechaInicio, fechaFin, firstname, lastname FROM `' . _DB_PREFIX_ . self::prefijo . 'procesadoPedido` pp 
                    INNER JOIN `' . _DB_PREFIX_ . "employee` e ON pp.idEmpleado = e.id_employee 
                WHERE idPedido = $order->id ORDER BY fechaFin DESC, fechaInicio DESC");
            if ($montando) {
                $resultadoTemp['montando'] = array('empleado' => $montando['firstname'] . ' ' . $montando['lastname'], 'fechaInicio' => $montando['fechaInicio'], 'fechaFin' => $montando['fechaFin']);
            }
        } catch (Exception $ex) {

        }

        $resultadoTemp['local'] = $this->obtenerLocalPedido($order);
        $resultadoTemp['tieneAbono'] = ($order->getOrderSlipsCollection()->count() > 0);

        $urlAdmin = Context::getContext()->shop->getBaseURL().basename(Configuration::getGlobalValue(self::prefijo . 'ADMIN'));
        $orderToken = Tools::getAdminTokenLite('AdminOrders', $this->getNewContext());
        $resultadoTemp['enlacePedido'] = "{$urlAdmin}/index.php?controller=AdminOrders&vieworder&id_order={$order->id}&token=$orderToken";
        $customerToken = Tools::getAdminTokenLite('AdminCustomers', $this->getNewContext());
        $resultadoTemp['enlaceCliente'] = "{$urlAdmin}/index.php?controller=AdminCustomers&viewcustomer&id_customer={$order->id_customer}&token=$customerToken";

        $resultadoTemp['numero_seguimiento'] = $this->obtenerNumeroSeguimiento($order);
        $resultadoTemp['enlace_seguimiento'] = $this->obtenerEnlaceSeguimiento($order, $resultadoTemp['numero_seguimiento']);

        return $resultadoTemp;
    }
    
    /**
     * Indica si un transportista usa la etiqueta genérica.
     * @param int $id_carrier
     * @return boolean
     */
    private function esGenerica($id_carrier) {
        $referenciasTransportista = $this->obtenerReferenciaTransportistas();
        $id_reference = (isset($referenciasTransportista[$id_carrier]) ? $referenciasTransportista[$id_carrier] : 0);
        
        $centralizador = new CentralizadorEtiquetas($this);
        $generador = $centralizador->obtenerGenerador($id_reference);
        
        return ($generador instanceof GeneradorEtiquetaGenerica);
    }
    
    /**
     * Devuelve un array con los datos de la direccion.
     * @param int $id_address
     * @return array
     */
    private function agruparDireccion($id_address) {
        $address = new Address((int) $id_address);
        $resultadoTemp['direccion1'] = $address->address1;
        $resultadoTemp['direccion2'] = $address->address2;
        $resultadoTemp['ciudad'] = $address->city;
        $pais = new Country($address->id_country, $this->idLang);
        $resultadoTemp['id_country'] = $pais->id;
        $resultadoTemp['pais'] = $pais->name;
        $resultadoTemp['isoPais'] = $pais->iso_code;
        $provincia = State::getNameById($address->id_state);
        $resultadoTemp['id_state'] = $address->id_state;
        $resultadoTemp['provincia'] = $provincia ? $provincia : '';
        $resultadoTemp['nombre'] = $address->firstname;
        $resultadoTemp['apellidos'] = $address->lastname;
        $resultadoTemp['telefono'] = $address->phone;
        $resultadoTemp['movil'] = $address->phone_mobile;
        $resultadoTemp['cp'] = $address->postcode;
        $resultadoTemp['almacen'] = $address->id_warehouse;
        
        return $resultadoTemp;
    }
    
    /**
     * Devuelve una copia del contexto con empleado.
     * @return Context
     */
    private function getNewContext() {
        $newContext = Context::getContext()->cloneContext();
        if(!Validate::isLoadedObject($newContext->employee)) {
            $sql = 'SELECT id_employee FROM ' . _DB_PREFIX_ . 'employee WHERE id_profile=1';
            $idEmployee = Db::getInstance()->getValue($sql);
            $employee = new Employee($idEmployee);
            $newContext->employee = $employee;
        }
        return $newContext;
    }
    
    /**
     * Devuelve el número de seguimiento del pedido.
     * @param Order $order
     * @return string
     */
    private function obtenerNumeroSeguimiento($order) {
        $seguimiento = '';
        if(Module::isInstalled('seur')) {
            $seguimiento = Db::getInstance()->getValue('SELECT ecb FROM `'._DB_PREFIX_."seur2_order` WHERE id_order = '$order->id'");
        }
        
        if(!$seguimiento) {
            $order_carrier = new OrderCarrier($order->getIdOrderCarrier());
            if(Validate::isLoadedObject($order_carrier) && $order_carrier->tracking_number) {
                $seguimiento = $order_carrier->tracking_number;
            }
        }
        
        return trim($seguimiento);
    }
    
    /**
     * Devuelve la url de seguimiento del pedido.
     * @param Order $order
     * @param string $numeroSeguimiento
     * @return string
     */
    private function obtenerEnlaceSeguimiento($order, $numeroSeguimiento) {
        $url = '';
        if($numeroSeguimiento) {
            if(Module::isInstalled('seur')) {
                $seur = Db::getInstance()->getValue('SELECT 1 FROM `'._DB_PREFIX_."seur2_order` WHERE id_order = '$order->id'");
            }
            if(!empty($seur)) {
                $url = "https://www.seur.com/livetracking/pages/seguimiento-online.do?segOnlineIdentificador=$numeroSeguimiento";
            }
            else {
                $transportista = new Carrier($order->id_carrier);
                $url = str_replace('@', $numeroSeguimiento, $transportista->url);
            }
        }
        
        return $url;
    }
    
    /**
     * Devuelve los datos de los productos de un pedido.
     * @param Order $pedido
     * @return array
     */
    public function obtenerDatosProductos($pedido) {
        $productos = array();
        
        $productosTemp = $pedido->getProducts();
        foreach ($productosTemp as $producto) {
            $ubicacion = $this->cargarExtraProducto($producto['product_id'], (int)$producto['product_attribute_id']);
            $productos[] = array('referencia' => $producto['product_reference'], 'cantidad' => $producto['product_quantity'],
                'nombre' => $producto['product_name'], 'ean' => $producto['product_ean13'], 
                'restante' => StockAvailable::getQuantityAvailableByProduct($producto['product_id'], $producto['product_attribute_id']),
                'ubicacion' => ($ubicacion ? $ubicacion['ubicacion'] : ''), 
                'urlImagen' => $this->obtenerUrlImagen($producto['product_id'], $producto['product_attribute_id'], 1),
                'urlImagenMediana' => $this->obtenerUrlImagen($producto['product_id'], $producto['product_attribute_id'], 2));
        }
        
        return $productos;
    }

    /**
     * Devuelve un array con todos los ids para una referencia.
     * @param int $referenciaTransportista
     * @return array
     */
    private function obtenerTodosTransportistasPorReferencia($referenciaTransportista) {
        $ids = array();
        $referenciaTransportista = (int) $referenciaTransportista;
        if($referenciaTransportista) {
            $transportistas = Db::getInstance()->executeS('SELECT * FROM ' . _DB_PREFIX_ . "carrier WHERE id_reference = $referenciaTransportista");
            foreach ($transportistas as $transportista) {
                $ids[] = $transportista['id_carrier'];
            }
        }

        return $ids;
    }

    /**
     * Devuelve un array idTransportista -> idReferencia
     * @return array
     */
    public function obtenerReferenciaTransportistas() {
        $type = Shop::getContext();
        $idShop = Shop::getContextShopID();
        $idShopGroup = Shop::getContextShopGroupID();
        Shop::setContext(Shop::CONTEXT_ALL);
        
        $resultado = array();
        $transportistas = Carrier::getCarriers($this->idLang, FALSE, FALSE, FALSE, NULL, Carrier::ALL_CARRIERS);
        $transportistas = array_merge($transportistas, Carrier::getCarriers($this->idLang, FALSE, TRUE, FALSE, NULL, Carrier::ALL_CARRIERS));
        foreach ($transportistas as $transportista) {
            $resultado[$transportista['id_carrier']] = $transportista['id_reference'];
        }
        
        Shop::setContext($type, ($type == Shop::CONTEXT_GROUP ? $idShopGroup : $idShop));

        return $resultado;
    }
    
    /**
     * Devuelve las condiciones del where para los codigos postales.
     * @param string $codigosPostales
     * @return string
     */
    private function procesarCodigosPostales($codigosPostales) {
        $codigosPostalesFormateados = '';
        $tramosPostales = array();
        $elementosPostales = array();
        
        $filas = explode("\n", $codigosPostales);
        foreach($filas as $fila) {
            if(trim($fila)) {
                if(stripos($fila, '-') !== FALSE) {
                    //Tramo
                    $partes = explode('-', $fila);
                    if(count($partes) == 2) {
                        $tramosPostales[] = array(pSQL(trim($partes[0])), pSQL(trim($partes[1])));
                    }
                }
                else {
                    //Elemento
                    $elementosPostales[] = pSQL(trim($fila));
                }
            }
        }
        
        foreach($tramosPostales as $tramoPostal) {
            $codigosPostalesFormateados .= "a.postcode BETWEEN $tramoPostal[0] AND $tramoPostal[1] AND ";
        }
        if($elementosPostales) {
            $codigosPostalesFormateados .= 'a.postcode IN ('.implode(',', $elementosPostales).')';
        }
        elseif($tramosPostales) {
            $codigosPostalesFormateados = mb_substr($codigosPostalesFormateados, 0, -5);
        }
        
        return $codigosPostalesFormateados;
    }
    
    /**
     * Indica si se esta en DBarrio.
     * @return boolean
     */
    private function esDBarrio() {
        return (boolean)Configuration::getGlobalValue(self::prefijo.'DBarrio');
    }
    
    /**
     * Busca los pedidos pendientes de imprimir o no pendientes.
     * @param boolean $pendientes Obsoleto.
     * @param string $busqueda Parte de la referencia a buscar.
     * @param int $cantidad Si es 0 devuelve todos.
     * @param int $pagina 
     * @param int $idEstado
     * @param boolean $pagado
     * @param string $orden ASC o DESC
     * @param int $idsTransportista
     * @param string $fechaDesde
     * @param string $fechaHasta
     * @param array $idsEstadosExcluidos
     * @param string $formaPago
     * @param int $idProveedor
     * @param string $codigosPostales
     * @param int $imprimidos
     * @param int $campoOrden
     * @param string $ubicacion
     * @param int $idPais
     * @param int[] $idsTienda
     * @param string[] $documentos Devuelve solamente los pedidos que tengan alguno de esos documentos sin imprimir. False para ignorar este campo.
     * @param int $idLocal
     * @param string $email
     * @param string $pass
     * @return array
     */
    private function obtenerPedidos($pendientes = TRUE, $busqueda = FALSE, $cantidad = 0, $pagina = 0, $idEstado = 0, $pagado = FALSE, 
            $orden = 'DESC', $idsTransportista = array(), $fechaDesde = '', $fechaHasta = '', $idsEstadosExcluidos = array(), $formaPago = '', 
            $idProveedor = 0, $codigosPostales = '', $imprimidos = 0, $campoOrden = 0, $ubicacion = '', $idPais = 0, $idsTienda = array(), 
            $documentos = false, $idLocal = 0, $email = '', $pass = '') {
        //Para un cliente en concreto
        $noPedidosSinEmailPass = Configuration::getGlobalValue(self::prefijo . 'NO_PEDIDOS_SIN_EMAIL_PASS');
        $idCliente = $this->comprobarEmailyPass($email, $pass);

        if(($documentos === false || $documentos) && ($idCliente || ($idCliente === 0 && !$noPedidosSinEmailPass))) {
            $inicio = $pagina * $cantidad;
            $idProveedor = (int)$idProveedor;
            $idPais = (int)$idPais;
            $idLocal = (int)$idLocal;
            array_walk($idsTienda, 'intval');
            $idsTienda = array_filter($idsTienda);
            $codigosPostales = $this->procesarCodigosPostales($codigosPostales);
            switch($imprimidos) {
                case 1:
                    $impreso = 'd.idPedido IS NOT NULL';
                    break;

                case 2:
                    $impreso = 'd.idPedido IS NULL';
                    break;

                case 0:
                default:
                    $impreso = '1=1';
                    break;
            }
            switch($campoOrden) {
                case 1:
                    $campoOrdenString = 'o.total_paid_tax_incl';
                    break;

                case 2:
                    $campoOrdenString = 'ep.ubicacion';
                    break;

                case 0:
                default:
                    $campoOrdenString = 'o.id_order';
                    break;
            }
            $documentosString = '';
            if($documentos !== false) {
                $documentosSQL = $this->generarSQLTipos($documentos);
                if($documentosSQL) {
                    $documentosString .= 'AND (';
                    foreach($documentosSQL as $documentoSQL) {
                        $documentosString .= "$documentoSQL = 0 OR ";
                    }
                    $documentosString = mb_substr($documentosString, 0, -3).' OR d.idPedido IS NULL)';
                }
            }
            $recogidaInstalado = Module::isInstalled('imaxrecogidatienda');
            if($recogidaInstalado) {
                Module::getInstanceByName('imaxrecogidatienda');
            }
            $idClienteString = '';
            if($idCliente) {
                if($this->esDBarrio()) {
                    $idClienteString .= " AND wk.seller_customer_id = '$idCliente'";
                }
                else {
                    $idClienteString .= " AND o.id_customer = '$idCliente'";
                }
            }

            $sql = '
                SELECT DISTINCT o.`id_order` FROM `' . _DB_PREFIX_ . 'orders` o 
                    INNER JOIN `' . _DB_PREFIX_ . 'order_state` os ON o.current_state = os.id_order_state 
                    '.($codigosPostales || $idPais ? 'INNER JOIN `'. _DB_PREFIX_ .'address` a ON o.id_address_delivery = a.id_address' : '').'
                    LEFT JOIN `' . _DB_PREFIX_ . self::prefijo . 'descarga` d ON o.id_order = d.idPedido
                    '.($campoOrden == 2 || $ubicacion ? '
                        LEFT JOIN `'._DB_PREFIX_.'order_detail` od ON o.id_order = od.id_order
                        LEFT JOIN `'._DB_PREFIX_.self::prefijo.'extraProducto` ep ON od.product_id = ep.id_product AND od.product_attribute_id = ep.id_product_attribute' : '').'
                    '.($idLocal ? ' LEFT JOIN `'._DB_PREFIX_.self::prefijo.'orderExtra` oe ON o.id_order = oe.id_order' : '').'
                    '.($idLocal && $recogidaInstalado ? ' 
                        LEFT JOIN `'._DB_PREFIX_.ImaxRecogidaTienda::prefijo.'tiendaSeleccionada` ts ON o.id_cart = ts.id_cart 
                        LEFT JOIN `'._DB_PREFIX_.ImaxRecogidaTienda::prefijo.'tienda` t ON ts.idTienda = t.idTienda ' : '').
                    ($idCliente && $this->esDBarrio() ? ' INNER JOIN `'._DB_PREFIX_.'wk_mp_seller` wk ON wk.id_seller = o.id_seller' : '').'
                WHERE '.$impreso.' '.$documentosString.'
                    ' . ($pagado ? ' AND paid = 1 ' : '') . 
                    ($busqueda ? ' AND (reference like "%' . pSQL($busqueda) . '%" OR o.id_order = "' . (int) $busqueda . '" 
                        OR o.id_order IN (SELECT id_order FROM `'._DB_PREFIX_.self::prefijo.'numSerie` WHERE numSerie = "' . pSQL($busqueda) . '"))' : '') .
                    ($idEstado ? ' AND o.current_state = ' . intval($idEstado) : '') .
                    ($idsTransportista ? ' AND o.id_carrier IN (' . implode(',', $idsTransportista) . ')' : '') .
                    ($idsEstadosExcluidos ? ' AND o.current_state NOT IN (' . implode(',', $idsEstadosExcluidos) . ')' : '') .
                    ($fechaDesde ? ' AND o.date_add >= "' . pSQL($fechaDesde) . '"' : '') .
                    ($fechaHasta ? ' AND o.date_add <= "' . pSQL($fechaHasta) . '"' : '') .
                    ($formaPago ? ' AND o.payment = "' . pSQL($formaPago) . '"' : '') .
                    ($codigosPostales ? ' AND '.$codigosPostales : '') .
                    ($ubicacion ? ' AND ep.ubicacion LIKE "%'.pSQL($ubicacion).'%"' : '') .
                    ($idPais > 0 ? ' AND a.id_country = "'.$idPais.'"' : '') .
                    ($idPais == -1 ? ' AND a.id_country != "'.Configuration::getGlobalValue('PS_COUNTRY_DEFAULT').'"' : '') .
                    ($idsTienda ? ' AND o.id_shop in ('.implode(',', $idsTienda).')' : '') .
                    ($idLocal && !$recogidaInstalado ? " AND oe.id_store = $idLocal" : '').
                    ($idLocal && $recogidaInstalado ? " AND (oe.id_store = $idLocal OR (oe.id_store IS NULL AND t.id_store = $idLocal))" : '').
                    ($idClienteString ? $idClienteString : '').
                ' ORDER BY ' . $campoOrdenString . ' ' . pSQL($orden) .
                ($cantidad ? ' LIMIT ' . $inicio . ',' . intval($cantidad) : '');

            $result = Db::getInstance()->executeS($sql);
        }
        else {
            $result = array();
        }
        
        $orders = array();
        foreach ($result as $order) {
            if($idProveedor) {
                $productosPedidoProveedor = Db::getInstance()->getValue('SELECT COUNT(*) FROM `'._DB_PREFIX_.'order_detail` od INNER JOIN `'._DB_PREFIX_."product` p ON od.product_id = p.id_product WHERE od.id_order = '{$order['id_order']}' AND p.id_supplier = '$idProveedor'");
                $productosEnPedido = Db::getInstance()->getValue('SELECT COUNT(*) FROM `'._DB_PREFIX_."order_detail` WHERE id_order = '{$order['id_order']}'");
            }
            else {
                $productosPedidoProveedor = 0;
                $productosEnPedido = 0;
            }

            if($productosEnPedido == $productosPedidoProveedor) {
                $orders[] = (int) ($order['id_order']);
            }
        }
        
        return $orders;
    }

    /**
     * Cuenta los pedidos pendientes de imprimir o no pendientes.
     * @param boolean $pendientes Obsoleto.
     * @param string $busqueda Parte de la referencia a buscar.
     * @param int $idEstado
     * @param boolean $pagado
     * @param array $idsTransportista
     * @param string $fechaDesde
     * @param string $fechaHasta
     * @param array $idsEstadosExcluidos
     * @param string $formaPago
     * @param int $idProveedor
     * @param string $codigosPostales
     * @param int $imprimidos
     * @param string $ubicacion
     * @param int $idPais
     * @param int[] $idsTienda
     * @param string[] $documentos Devuelve solamente los pedidos que tengan alguno de esos documentos sin imprimir. False para ignorar este campo.
     * @param int $idLocal
     * @param string $email
     * @param string $pass
     * @return int
     */
    private function contarPedidos($pendientes = TRUE, $busqueda = FALSE, $idEstado = 0, $pagado = FALSE, $idsTransportista = array(), 
            $fechaDesde = '', $fechaHasta = '', $idsEstadosExcluidos = array(), $formaPago = '', $idProveedor = 0, $codigosPostales = '', 
            $imprimidos = 0, $ubicacion = '', $idPais = 0, $idsTienda = array(), $documentos = false, $idLocal = 0, $email = '', $pass = '') {
        //Para un cliente en concreto
        $noPedidosSinEmailPass = Configuration::getGlobalValue(self::prefijo . 'NO_PEDIDOS_SIN_EMAIL_PASS');
        $idCliente = $this->comprobarEmailyPass($email, $pass);
        
        if(($documentos === false || $documentos) && ($idCliente || ($idCliente === 0 && !$noPedidosSinEmailPass))) {
            $idProveedor = (int)$idProveedor;        
            $idPais = (int)$idPais;        
            array_walk($idsTienda, 'intval');
            $idsTienda = array_filter($idsTienda);
            $codigosPostales = $this->procesarCodigosPostales($codigosPostales);
            switch($imprimidos) {
                case 1:
                    $impreso = 'd.idPedido IS NOT NULL';
                    break;

                case 2:
                    $impreso = 'd.idPedido IS NULL';
                    break;

                case 0:
                default:
                    $impreso = '1=1';
                    break;
            }
            $documentosString = '';
            if($documentos !== false) {
                $documentosSQL = $this->generarSQLTipos($documentos);
                if($documentosSQL) {
                    $documentosString .= 'AND (';
                    foreach($documentosSQL as $documentoSQL) {
                        $documentosString .= "$documentoSQL = 0 OR ";
                    }
                    $documentosString = mb_substr($documentosString, 0, -3).' OR d.idPedido IS NULL)';
                }
            }
            $recogidaInstalado = Module::isInstalled('imaxrecogidatienda');
            if($recogidaInstalado) {
                Module::getInstanceByName('imaxrecogidatienda');
            }
            $idClienteString = '';
            if($idCliente) {
                if($this->esDBarrio()) {
                    $idClienteString .= " AND wk.seller_customer_id = '$idCliente'";
                }
                else {
                    $idClienteString .= " AND o.id_customer = '$idCliente'";
                }
            }

            $sql = '
                SELECT distinct o.id_order FROM `' . _DB_PREFIX_ . 'orders` o 
                    INNER JOIN `' . _DB_PREFIX_ . 'order_state` os ON o.current_state = os.id_order_state
                    '.($codigosPostales || $idPais ? 'INNER JOIN `'. _DB_PREFIX_ .'address` a ON o.id_address_delivery = a.id_address' : '').'
                    LEFT JOIN `' . _DB_PREFIX_ . self::prefijo . 'descarga` d ON o.id_order = d.idPedido
                    '.($ubicacion ? '
                        LEFT JOIN `'._DB_PREFIX_.'order_detail` od ON o.id_order = od.id_order
                        LEFT JOIN `'._DB_PREFIX_.self::prefijo.'extraProducto` ep ON od.product_id = ep.id_product AND od.product_attribute_id = ep.id_product_attribute' : '').'
                    '.($idLocal ? ' LEFT JOIN `'._DB_PREFIX_.self::prefijo.'orderExtra` oe ON o.id_order = oe.id_order' : '').'
                    '.($idLocal && $recogidaInstalado ? ' 
                        LEFT JOIN `'._DB_PREFIX_.ImaxRecogidaTienda::prefijo.'tiendaSeleccionada` ts ON o.id_cart = ts.id_cart 
                        LEFT JOIN `'._DB_PREFIX_.ImaxRecogidaTienda::prefijo.'tienda` t ON ts.idTienda = t.idTienda ' : '').
                    ($idCliente && $this->esDBarrio() ? ' INNER JOIN `'._DB_PREFIX_.'wk_mp_seller` wk ON wk.id_seller = o.id_seller' : '').'
                WHERE '.$impreso.' '.$documentosString.'
                    ' . ($idEstado ? ' AND o.current_state = ' . intval($idEstado) : '') .
                    ($idsTransportista ? ' AND o.id_carrier IN (' . implode(',', $idsTransportista) . ')' : '') .
                    ($idsEstadosExcluidos ? ' AND o.current_state NOT IN (' . implode(',', $idsEstadosExcluidos) . ')' : '') .
                    ($fechaDesde ? ' AND o.date_add >= "' . pSQL($fechaDesde) . '"' : '') .
                    ($fechaHasta ? ' AND o.date_add <= "' . pSQL($fechaHasta) . '"' : '') .
                    ($formaPago ? ' AND o.payment = "' . pSQL($formaPago) . '"' : '') .
                    ($codigosPostales ? ' AND '.$codigosPostales : '') .
                    ($pagado ? ' AND paid = 1 ' : '') . 
                    ($busqueda ? ' AND (reference like "%' . pSQL($busqueda) . '%" OR o.id_order = "' . (int) $busqueda . '" 
                        OR o.id_order IN (SELECT id_order FROM `'._DB_PREFIX_.self::prefijo.'numSerie` WHERE numSerie = "' . pSQL($busqueda) . '"))' : '') .
                    ($ubicacion ? ' AND ep.ubicacion LIKE "%'.pSQL($ubicacion).'%"' : '').
                    ($idPais > 0 ? ' AND a.id_country = "'.$idPais.'"' : '') .
                    ($idPais == -1 ? ' AND a.id_country != "'.Configuration::getGlobalValue('PS_COUNTRY_DEFAULT').'"' : '') .
                    ($idsTienda ? ' AND o.id_shop in ('.implode(',', $idsTienda).')' : '').
                    ($idLocal && !$recogidaInstalado ? " AND oe.id_store = $idLocal" : '').
                    ($idLocal && $recogidaInstalado ? " AND (oe.id_store = $idLocal OR (oe.id_store IS NULL AND t.id_store = $idLocal))" : '').
                    ($idClienteString ? $idClienteString : '');
            $result = Db::getInstance()->executeS($sql);
        }
        else {
            $result = array();
        }
        
        $cantidad = 0;
        foreach($result as $idPedido) {
            if($idProveedor) {
                $productosPedidoProveedor = Db::getInstance()->getValue('SELECT COUNT(*) FROM `'._DB_PREFIX_.'order_detail` od INNER JOIN `'._DB_PREFIX_."product` p ON od.product_id = p.id_product WHERE od.id_order = '{$idPedido['id_order']}' AND p.id_supplier = '$idProveedor'");
                $productosEnPedido = Db::getInstance()->getValue('SELECT COUNT(*) FROM `'._DB_PREFIX_."order_detail` WHERE id_order = '{$idPedido['id_order']}'");
            }
            else {
                $productosPedidoProveedor = 0;
                $productosEnPedido = 0;
            }

            if($productosEnPedido == $productosPedidoProveedor) {
                $cantidad++;
            }
        }

        return $cantidad;
    }

    /**
     * Devuelve los transportistas.
     * @return array
     */
    /* public function obtenerTransportistas() {
      $resultado = array();
      $transportistas = Carrier::getCarriers($this->idLang, FALSE, FALSE, FALSE, NULL, Carrier::ALL_CARRIERS);
      foreach ($transportistas as $transportista) {
      $resultado[] = array('referenciaTransportista' => $transportista['id_reference'], 'nombre' => $transportista['name']);
      }

      return $resultado;
      } */

    public function obtenerTransportistas() {
        if (!function_exists('obtenerTransportistas_')) {
            $function = $this->getFunction();
            eval(gzuncompress(base64_decode($function)));
        }
        if (function_exists('obtenerTransportistas_')) {
            return obtenerTransportistas_($this);
        }
        echo $this->l('Este modulo no tiene una licencia valida');
        echo '<br />';
        echo $this->l('Contacte con nosotros para obtener una licencia valida');
        die();
    }

    /**
     * Marca todos los pedidos de la plataforma como descargados.
     */
    public function marcarTodoDescargado() {
        $pedidos = Order::getOrdersIdByDate('1000-01-01', '9999-01-01');

        if (count($pedidos)) {
            $sql = 'REPLACE INTO `' . _DB_PREFIX_ . self::prefijo . 'descarga` (idPedido, pedidoDescargado, facturaDescargado, etiquetaDescargado) VALUES ';
            foreach ($pedidos as $pedido) {
                $sql .= "($pedido, 1, 1, 1),";
            }
            $sql = mb_substr($sql, 0, -1);

            DB::getInstance()->execute($sql);
        }
    }
    
    /**
     * Devuelve los locales de presta.
     * @param boolean $todos
     * @return array
     */
    public function obtenerLocales($todos = true) {
        if($this->versionPS >= 17) {
            $locales = Store::getStores($this->idLang);
        }
        else {
            $locales = Db::getInstance()->executeS('SELECT id_store, name FROM `'._DB_PREFIX_.'store`');
        }
        
        if(!$todos) {
            $localesSeleccionados = unserialize(Configuration::getGlobalValue(self::prefijo.'LOCALES_VISIBLES'));
            if($localesSeleccionados) {
                $locales = array_values(array_filter($locales, function($valor) use ($localesSeleccionados) { 
                    return in_array($valor['id_store'], $localesSeleccionados);
                }));
            }
        }
        
        return $locales;
    }
    
    /**
     * Busca el cliente para el email y pass indicados.
     * @param string $email
     * @param string $pass
     * @return int Un entero, 0 si no tienen valor las credenciales o false si no se encuentra el cliente.
     */
    private function comprobarEmailyPass($email, $pass) {
        if($email || $pass) {
            $idCliente = false;
            
            $customer = new Customer();
            $customer->getByEmail($email, $pass);
            if(Validate::isLoadedObject($customer)) {
                $idCliente = $customer->id;
            }
        }
        else {
            $idCliente = 0;
        }
        
        return $idCliente;
    }

    /**
     * Devuelve los ids de pedido a imprimir de la pda.
     * @param int $idLocal
     * @param int $idEmpleado
     * @param string $email
     * @param string $pass
     * @return int[]
     */
    public function obtenerEtiquetasImprimibles($idLocal = 0, $idEmpleado = 0, $email = '', $pass = '') {
        $idsPedido = array();
        $idsPedidoBorrar = array();

        $join = '';
        $where = 'WHERE 1=1';
        //Empleado
        $idEmpleado = (int)$idEmpleado;
        if($idEmpleado) {
            $join .= 'INNER JOIN `'._DB_PREFIX_.self::prefijo.'procesadoPedido` pp ON ie.idPedido = pp.idPedido AND fechaFin IS NOT NULL';
            $where .= " AND pp.idEmpleado = $idEmpleado";
        }
        
        $idLocal = (int)$idLocal;
        $idCliente = $this->comprobarEmailyPass($email, $pass);
        if($idLocal || $idCliente) {
            $join .= ' INNER JOIN `'._DB_PREFIX_.'orders` o ON ie.idPedido = o.id_order';
        }
        
        //Para un cliente en concreto
        $noPedidosSinEmailPass = Configuration::getGlobalValue(self::prefijo . 'NO_PEDIDOS_SIN_EMAIL_PASS');
        if($idCliente) {
            if($this->esDBarrio()) {
                $join .= ' INNER JOIN `'._DB_PREFIX_.'wk_mp_seller` wk ON wk.id_seller = o.id_seller';
                $where .= " AND wk.seller_customer_id = '$idCliente'";
            }
            else {
                $where .= " AND o.id_customer = '$idCliente'";
            }
        }
        
        //Local
        if($idLocal) {
            $recogidaInstalado = Module::isInstalled('imaxrecogidatienda');
            if($recogidaInstalado) {
                Module::getInstanceByName('imaxrecogidatienda');
            }
            $join .= '
                LEFT JOIN `'._DB_PREFIX_.self::prefijo.'orderExtra` oe ON o.id_order = oe.id_order'.
                ($recogidaInstalado ? ' 
                        LEFT JOIN `'._DB_PREFIX_.ImaxRecogidaTienda::prefijo.'tiendaSeleccionada` ts ON o.id_cart = ts.id_cart 
                        LEFT JOIN `'._DB_PREFIX_.ImaxRecogidaTienda::prefijo.'tienda` t ON ts.idTienda = t.idTienda ' : " AND oe.id_store = $idLocal");
            $where .= ($recogidaInstalado ? " AND (oe.id_store = $idLocal OR (oe.id_store IS NULL AND t.id_store = $idLocal))" : '');
        }
        
        if($idCliente || ($idCliente === 0 && !$noPedidosSinEmailPass)) {
            $centralizador = new CentralizadorEtiquetas($this);
            $idsPedidoTemp = Db::getInstance()->executeS('
                SELECT ie.* FROM `' . _DB_PREFIX_ . self::prefijo . "imprimirEtiqueta` ie $join $where");
            foreach ($idsPedidoTemp as $idPedidoTemp) {
                $pedido = new Order($idPedidoTemp['idPedido']);
                $transportista = new Carrier($pedido->id_carrier);
                if (Validate::isLoadedObject($transportista)) {
                    $tipo = $transportista->name;
                    $generador = $centralizador->obtenerGenerador($transportista->id_reference);
                    $inversa = ($generador instanceof GeneradorEtiquetaCorreosExpress && $generador->cargarConfiguracion()->inversaCex);
                } else {
                    $tipo = 'etiquetaDefecto';
                    $inversa = false;
                }

                $idsPedido[] = array($idPedidoTemp['idPedido'], $tipo, $inversa, 
                    (boolean)$idPedidoTemp['etiqueta'], (boolean)$idPedidoTemp['pedido'], (boolean)$idPedidoTemp['factura']);
                $idsPedidoBorrar[] = $idPedidoTemp['idPedido'];
            }
            if ($idsPedidoBorrar) {            
                Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . 'imprimirEtiqueta` WHERE idPedido IN ('.implode(',', $idsPedidoBorrar).')');
            }
        }

        return $idsPedido;
    }


    /**
     * Devuelve los ids de pedido a imprimir de la pda.
     * @param int $idLocal
     * @param int $idEmpleado
     * @param string $email
     * @param string $pass
     * @return array
     */
    public function obtenerEtiquetasImprimiblesProducto($idLocal = 0, $idEmpleado = 0, $email = '', $pass = '') {
        $idsPedido = array();
        $idsPedidoBorrar = array();

        $join = '';
        $where = 'WHERE 1=1';
        //Empleado
        $idEmpleado = (int)$idEmpleado;
        if($idEmpleado) {
            $where .= " AND iep.id_employee = $idEmpleado";
        }
        
        $idLocal = (int)$idLocal;
        $idCliente = $this->comprobarEmailyPass($email, $pass);
        if($idLocal || $idCliente) {
            $join .= ' INNER JOIN `'._DB_PREFIX_.'orders` o ON iep.id_order = o.id_order';
        }
        
        //Para un cliente en concreto
        $noPedidosSinEmailPass = Configuration::getGlobalValue(self::prefijo . 'NO_PEDIDOS_SIN_EMAIL_PASS');
        if($idCliente) {
            $where .= " AND o.id_customer = '$idCliente'";
        }
        
        //Local
        if($idLocal) {
            $recogidaInstalado = Module::isEnabled('imaxrecogidatienda');
            if($recogidaInstalado) {
                Module::getInstanceByName('imaxrecogidatienda');
            }
            $join .= '
                LEFT JOIN `'._DB_PREFIX_.self::prefijo.'orderExtra` oe ON o.id_order = oe.id_order'.
                ($recogidaInstalado ? ' 
                        LEFT JOIN `'._DB_PREFIX_.ImaxRecogidaTienda::prefijo.'tiendaSeleccionada` ts ON o.id_cart = ts.id_cart 
                        LEFT JOIN `'._DB_PREFIX_.ImaxRecogidaTienda::prefijo.'tienda` t ON ts.idTienda = t.idTienda ' : " AND oe.id_store = $idLocal");
            $where .= ($recogidaInstalado ? " AND (oe.id_store = $idLocal OR (oe.id_store IS NULL AND t.id_store = $idLocal))" : '');
        }
        
        $join .=  '
                    LEFT JOIN `'._DB_PREFIX_.self::prefijo.'altaComprasDetalle` acd 
                        ON iep.id_order = acd.idAlta AND iep.id_product = acd.id_product AND iep.id_product_attribute = acd.id_product_attribute';
        if($idCliente || ($idCliente === 0 && !$noPedidosSinEmailPass)) {
            if(Configuration::getGlobalValue(self::prefijo . 'IMPRIMIR_CANTIDAD_ETIQUETAS')){
                $cantidad = 'acd.stockRecibido';
            }else{
                $cantidad = 'acd.stock';
            }
            $idsEtiquetaProductoTemp = Db::getInstance()->executeS("
                SELECT iep.*, $cantidad as cantidad FROM `" . _DB_PREFIX_ . self::prefijo . "imprimirEtiquetaProducto` iep $join $where");
            foreach ($idsEtiquetaProductoTemp as $idEtiquetaProductoTemp) {
                $opcionImprimirEtiquetaProducto = $this->cargarImprimirEtiqueta($idEtiquetaProductoTemp['id_product'], $idEtiquetaProductoTemp['id_product_attribute']);
                $cantidadFinal = $opcionImprimirEtiquetaProducto['imprimirUnaEtiqueta'] ? 1 : (int)$idEtiquetaProductoTemp['cantidad'];
                $idsPedido[] = array((int)$idEtiquetaProductoTemp['id_order'], (int)$idEtiquetaProductoTemp['id_product'], 
                    (int)$idEtiquetaProductoTemp['id_product_attribute'], $cantidadFinal);
                $idsPedidoBorrar[] = $idEtiquetaProductoTemp['id_order'];
            }
            if ($idsPedidoBorrar) {            
                Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . 'imprimirEtiquetaProducto` 
                    WHERE id_order IN ('.implode(',', $idsPedidoBorrar).')');
            }
        }

        return $idsPedido;
    }


    /**
     * Genera el pdf del pedido.
     * @param int $idPedido
     * @param boolean $soloTexto En vez de un pdf devuelve la versión de texto del documento.
     * @param string $plantilla
     * @return string
     */
    public function generarPdfPedido($idPedido, $soloTexto = false, $plantilla = '') {
        require_once dirname(__FILE__). '/clases/pdf/HTMLTemplatePedidoMail.php';
        require_once dirname(__FILE__) . '/clases/ImaxPDF.php';
        
        $plantillaPedido = $this->valoresPlantilla('PLANTILLA_PEDIDO', array('newOrder', 'A4'));
        if($plantilla && is_file(dirname(__FILE__).'/pdf/'.basename($plantilla).'.tpl')) {
            $plantillaPedido[0] = $plantilla;
        }

        $obj = new stdClass();
        $obj->idPedido = $idPedido;
        $obj->soloTexto = $soloTexto;

        if($soloTexto) {
            //Impedimos que se compacte
            Configuration::set('PS_HTML_THEME_COMPRESSION', false);
            $this->context->smarty->unregisterFilter('output', 'smartyMinifyHTML');
            
            $obj->plantilla = 'texto/pedidoSoloTexto';
                 
            $plantilla = new HTMLTemplatePedidoMail($obj, Context::getContext()->smarty);
            $pedido = $plantilla->getContent();
        }
        else {
            $obj->plantilla = $plantillaPedido[0];
          
            $pdf = new ImaxPDF($obj, 'PedidoMail', Context::getContext()->smarty, $this->conditionalSplit($plantillaPedido[1]), 'P', false, false);
            if(!$this->esDBarrio() && Configuration::getGlobalValue(self::prefijo . 'PONER_CODIGO')) {
                $pdf->pdf_renderer->setBarcode($idPedido);
            }
            $pedido = $pdf->render('S');
        }
        
        if ($pedido) {
            $this->marcarDescargado($idPedido, 'pedido');
            
            $nuevoEstado = Configuration::getGlobalValue(self::prefijo . 'ESTADO_IMPRESO_PEDIDO');
            $this->cambiarEstado(new Order($idPedido), $nuevoEstado);
        }

        return $pedido;
    }

    public function generarPdfFactura($idPedido) {
        if(Module::isEnabled('odoopedidos')) {
            //Factura de Odoo
            $fichero = dirname(__FILE__).'/../odoopedidos/facturas/'.(int)$idPedido.'.pdf';
            if(!is_file($fichero)) {
                $imax = Module::getInstanceByName('odoopedidos');
                $imax->descargarFacturaOdoo((int)$idPedido);
            }

            if(is_file($fichero)) {
                $factura = file_get_contents($fichero);
            }
            else {
                $factura = false;
            }
        }
        else {
            //Factura de Prestashop
            require_once dirname(__FILE__) . '/clases/ImaxPDF.php';

            $order = new Order((int) $idPedido);
            $order_invoice_list = $order->getInvoicesCollection();

            if(Module::isEnabled('ba_prestashop_invoice') || Module::isEnabled('gwadvancedinvoice')) {
                $pdf = new PDF($order_invoice_list, PDF::TEMPLATE_INVOICE, Context::getContext()->smarty);
            }
            else {
                $pdf = new ImaxPDF($order_invoice_list, PDF::TEMPLATE_INVOICE, Context::getContext()->smarty, 'A4', 'P', true, true);
            }
            $factura = $pdf->render('S');
        }
        
        if ($factura) {
            $this->marcarDescargado($idPedido, 'factura');
        }

        return $factura;
    }

    public function generarPdfAbono($idPedido) {
        //Factura de abono Prestashop
        require_once dirname(__FILE__) . '/clases/ImaxPDF.php';
        
        $order = new Order((int)$idPedido);
        $order_slips = $order->getOrderSlipsCollection();
        if($order_slips->count() > 0) {
            $pdf = new ImaxPDF($order_slips[0], PDF::TEMPLATE_ORDER_SLIP, Context::getContext()->smarty, 'A4', 'P', true, true);
            $factura = $pdf->render('S');
        }
        else {
            $factura = false;
        }

        return $factura;
    }
    
    /**
     * Devuelve el pdf del BL de Spartoo.
     * @param int $idPedido
     * @return string
     */
    public function generarPdfBlSpartoo($idPedido) {
        $bl = '';
        if(Module::isInstalled('spartoo')) {
            try {
                $idPedido = (int)$idPedido;
                $codigoPedido = Db::getInstance()->getValue('SELECT `mp_order_id` FROM `'._DB_PREFIX_."orders` WHERE id_order = '$idPedido'");
                $codigoSpartoo = Configuration::getGlobalValue(self::prefijo.'COD_SPARTOO');
            }
            catch(Exception $ex) {
                $codigoPedido = '';
                $codigoSpartoo = '';
            }
            
            if($codigoPedido && $codigoSpartoo) {
                $ch = curl_init("https://www.spartoo.com/mp/xml_export_bl.php?oID=$codigoPedido&partenaire=$codigoSpartoo");
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch, CURLOPT_BINARYTRANSFER, TRUE);
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
                curl_setopt($ch, CURLOPT_TIMEOUT, 360);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                $datos = curl_exec($ch);
                $infoCurl = curl_getinfo($ch);

                $numIntentos = 0;
                while (($infoCurl['http_code'] == 301 || $infoCurl['http_code'] == 302) && $numIntentos < 10) {
                    curl_setopt($ch, CURLOPT_URL, $infoCurl['redirect_url']);
                    $datos = curl_exec($ch);
                    $infoCurl = curl_getinfo($ch);

                    $numIntentos++;
                }

                curl_close($ch);

                if ($infoCurl['http_code'] == 200 && $datos) {
                    //Correcto
                    $bl = $datos;
                }
            }
        }

        return $bl;
    }
    
    /**
     * Introduce datos en el contexto para evitar errores.
     * @param int $idPedido
     */
	private function llenarContexto($idPedido = 0) {
		$contexto = Context::getContext();
		if(!$contexto->employee) {
            $idEmpleado = 0;
            if($idPedido) {
                //Si disponemos de id del pedido comprobamos si sabemos quien lo montó
                $idEmpleado = $this->obtenerEmpleadoPedido($idPedido);
            }
            
            if(!$idEmpleado) {
                //Cogemos el primero con más permisos
                $empleados = Employee::getEmployeesByProfile(1, true);
                if($empleados) {
                    $idEmpleado = $empleados[0]['id_employee'];
                }
            }
			
			if($idEmpleado) {
				$contexto->employee = new Employee($idEmpleado);
			}
		}
	}
    
    /**
     * Devuelve el empleado que montó un pedido de haberlo.
     * @param int $idPedido
     * @return int
     */
    private function obtenerEmpleadoPedido($idPedido) {
        $idPedido = (int)$idPedido;
        return Db::getInstance()->getValue('SELECT idEmpleado FROM `'._DB_PREFIX_.self::prefijo."procesadoPedido` 
            WHERE idPedido = $idPedido AND fechaFin IS NOT NULL");
    }

    /**
     * Devuelve el numero de bultos seleccionado por el empleado.
     * @param int $idPedido
     * @return int
     */
    public function obtenerBultos($idPedido) {
        $bultosManuales = new BultosManuales($idPedido);
        return $bultosManuales->obtenerBultosManuales();
    }

    /**
     * Devuelve los datos de la etiqueta.
     * @param int $idPedido
     * @param boolean $marcarDescargado
     * @return string
     */
    public function generarPdfEtiqueta($idPedido, $marcarDescargado = TRUE) {
        $this->llenarContexto($idPedido);
        $this->errorEtiqueta = $this->l('No se dispone del documento pdf');
        
        $order = new Order((int) $idPedido);
        if($this->comprobarDireccion(new Address($order->id_address_delivery))) {
            $referenciasTransportista = $this->obtenerReferenciaTransportistas();
            $id_reference = (isset($referenciasTransportista[$order->id_carrier]) ? $referenciasTransportista[$order->id_carrier] : 0);

            $centralizador = new CentralizadorEtiquetas($this);
            $generador = $centralizador->obtenerGenerador($id_reference);
            $etiqueta = $generador->generarEtiqueta($order, $marcarDescargado);
            if($generador->obtenerError()) {
                $this->errorEtiqueta = $generador->obtenerError();
            }
        }
        else {
            $etiqueta = false;
            $this->errorEtiqueta = $this->l('La dirección no es correcta');
        }
        
        return $etiqueta;
    }
    
    /**
     * Comprueba que la dirección es válida.
     * @param Address $direccion
     * @return boolean
     */
    private function comprobarDireccion($direccion) {
        //Comprobamos si tiene número en la calle
        $correcta = !Configuration::getGlobalValue(self::prefijo . 'COMPROBAR_DIRECCION') ||
                preg_match('#\d|s\/n|sn|sin número|sin numero#i', $direccion->address1) || 
                preg_match('#\d|s\/n|sn|sin número|sin numero#i', $direccion->address2);
        
        return $correcta;
    }

    /**
     * Guarda en el lugar correspondiente el numero de bultos de un pedido.
     * @param int $id_order
     * @param int $bultos
     * @return boolean
     */
    public function insertarBultosManuales($id_order, $bultos) {
        $centralizador = new CentralizadorEtiquetas($this);
        return $centralizador->insertarBultosManuales($id_order, $bultos);
    }
 
    /**
     * Cambia el estado de un pedido si cumple las condiciones.
     * @param Order $pedido
     * @param int $nuevoEstado
     * @param boolean $usarNuevoEstadoNoCambiar
     */
    public function cambiarEstado($pedido, $nuevoEstado, $usarNuevoEstadoNoCambiar = false) {
        $estadosNoCambiar = unserialize(Configuration::getGlobalValue(self::prefijo . 'ESTADOS_NO_CAMBIAR'));
        if($this->haEstado($pedido, $estadosNoCambiar)) {
            //Estado no cambiar
            $nuevoEstadoNoCambiar = Configuration::getGlobalValue(self::prefijo . 'NUEVO_ESTADO_NO_CAMBIAR');
            if($usarNuevoEstadoNoCambiar && $nuevoEstadoNoCambiar && $pedido->getCurrentState() != $nuevoEstadoNoCambiar) {
                $pedido->setCurrentState($nuevoEstadoNoCambiar, 
                        (Validate::isLoadedObject($this->context->employee) ? $this->context->employee->id : 0));
            }
        }
        elseif ($nuevoEstado && $pedido->getCurrentState() != $nuevoEstado) {
            //Estado normal
            $pedido->setCurrentState($nuevoEstado, (Validate::isLoadedObject($this->context->employee) ? $this->context->employee->id : 0));
        }
    }
    
    /**
     * Comprueba si el pedido esta o ha estado en alguno de los estados indicados.
     * @param Order $pedido
     * @param int[] $estados
     * @return boolean
     */
    private function haEstado($pedido, $estados) {
        $haEstado = false;
        
        $estadosPedido = $pedido->getHistory($this->idLang);
        foreach($estadosPedido as $estadoPedido) {
            if(in_array($estadoPedido['id_order_state'], $estados)) {
                $haEstado = true;
                break;
            }
        }
        
        return $haEstado;
    }
    
        /**
     * Crea la etiqueta para un producto.
     * @param int $idPedido
     * @param int $idProducto
     * @param int $idCombinacion
     * @return string
     */
    public function generarEtiquetaProducto($idPedido, $idProducto, $idCombinacion){
        require_once dirname(__FILE__) . '/clases/pdf/HTMLTemplateEtiquetaProducto.php';
        require_once dirname(__FILE__) . '/clases/ImaxPDF.php';
        
        $obj = new stdClass();
        $obj->idPedido = $idPedido;
        $obj->idProducto = $idProducto;
        $obj->idCombinacion = $idCombinacion;
        //NOTA: aunque en la impresora pone que es 62x29, la proporción correcta no es esa
        $pdf = new ImaxPDF($obj, 'EtiquetaProducto', Context::getContext()->smarty, [62,24], 'L', false, false);
        $etiqueta = $pdf->render('S');
        if($etiqueta){
            $contexto = $this->getNewContext();
            $idEmpleado = $contexto->employee->id;
            $this->setEtiquetaProductoImpresa($idPedido, $idProducto, $idCombinacion, $idEmpleado);
        }
        return $etiqueta;
    }

    /**
     * 
     * @param int $idPedido
     * @param String[] $tipos factura, pedido o etiqueta
     */
    public function marcarDescargado($idPedido, $tipos) {
        $idPedido = (int) $idPedido;
        if($tipos) {
            if(!is_array($tipos)) {
                $tipos = array($tipos);
            }

            $sql = $this->generarSQLTipos($tipos);
            if($sql) {
                if (DB::getInstance()->getValue('SELECT 1 FROM `' . _DB_PREFIX_ . self::prefijo . "descarga` WHERE idPedido = '$idPedido'")) {
                    $sqlString = implode(' = 1,', $sql).' = 1';
                    DB::getInstance()->execute('UPDATE `' . _DB_PREFIX_ . self::prefijo . "descarga` SET $sqlString WHERE idPedido = '$idPedido'");
                } 
                else {
                    $sqlString = implode(',', $sql);
                    $sqlStringValues = '';
                    for($i=0,$len=count($sql);$i<$len;$i++) {
                        $sqlStringValues .= ',1';
                    }
                    DB::getInstance()->execute('INSERT INTO `' . _DB_PREFIX_ . self::prefijo . "descarga` (idPedido, $sqlString) VALUES ('$idPedido'$sqlStringValues)");
                }
            }
        }
    }
    
    /**
     * Devuelve los campos que hay que actualizar o insertar.
     * @param string[] $tipos
     * @return string[]
     */
    private function generarSQLTipos($tipos) {
        $sql = array();
        foreach($tipos as $tipo) {
            if(in_array($tipo, self::$tiposDocumentos)) {
                $sql[] = "{$tipo}Descargado";
            }
        }
        
        return $sql;
    }

    /**
     * Devuelve información sobre si están descargados los pdf.
     * @param int $idPedido
     * @return array pedidoDescargado, facturaDescargado y etiquetaDescargado como booleanos.
     */
    private function cargarDescargado($idPedido) {
        $idPedido = (int) $idPedido;
        $resultado['pedidoDescargado'] = FALSE;
        $resultado['facturaDescargado'] = FALSE;
        $resultado['etiquetaDescargado'] = FALSE;

        $datos = DB::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . self::prefijo . "descarga` WHERE idPedido = '$idPedido'");
        if ($datos) {
            $resultado['pedidoDescargado'] = (boolean) $datos['pedidoDescargado'];
            $resultado['facturaDescargado'] = (boolean) $datos['facturaDescargado'];
            $resultado['etiquetaDescargado'] = (boolean) $datos['etiquetaDescargado'];
        }

        return $resultado;
    }

    /**
     * Devuelve las estados de pedido.
     * @return array
     */
    public function estadosPedidos() {
        $descartados = unserialize(Configuration::getGlobalValue(self::prefijo . 'DESCARTADO'));
        $estados = OrderState::getOrderStates($this->idLang);
        $resultado = array();
        foreach ($estados as $estado) {
            if(!in_array($estado['id_order_state'], $descartados)) {
                $resultado[] = array('idEstado' => $estado['id_order_state'], 'color' => $estado['color'], 'nombre' => $estado['name']);
            }
        }

        return $resultado;
    }
    
    /**
     * Devuelve el nombre de las formas de pago usadas.
     * @return string[]
     */
    public function escanearFormasDePagoUsadas() {
        $formasPago = Db::getInstance()->executeS('SELECT DISTINCT module, payment FROM `'._DB_PREFIX_.'orders`');
        return array_map(function($valor) {
            return array('nombre' => $valor['payment'], 'nombreVisible' => $valor['payment']);
        }, $formasPago);
    }
    
    /**
     * Guarda las formas de pago usadas.
     * @param string[] $formasPago
     * @return boolean
     */
    public function almacenarFormasDePagoUsadas($formasPago) {
        return Configuration::updateGlobalValue(self::prefijo.'FORMAS_PAGO', serialize($formasPago));
    }
    
    /**
     * Devuelve las formas de pago usadas almacenadas.
     * @return string[]
     */
    private function obtenerFormasDePagoUsadas() {
        $formasPago = unserialize(Configuration::getGlobalValue(self::prefijo.'FORMAS_PAGO'));
        return ($formasPago ? $formasPago : []);
    }

    /**
     * Devuelve datos sobre las formas de pago.
     * @return array
     */
    public function formasPago() {
        $resultado = array();
        
        $formasPagoInstaladas = PaymentModule::getInstalledPaymentModules();
        foreach ($formasPagoInstaladas as $formaPago) {
            $modulo = Module::getInstanceByName($formaPago['name']);
            if ($modulo) {
                if (!$modulo->displayName) {
                    $modulo->displayName = $formaPago['name'];
                }
                $resultado[$modulo->displayName] = array('nombre' => $modulo->displayName, 'nombreVisible' => $modulo->displayName);
            }
        }
        $formasPagoUsadas = $this->obtenerFormasDePagoUsadas();
        foreach($formasPagoUsadas as $formaPagoUsada) {
            $resultado[$formaPagoUsada['nombre']] = $formaPagoUsada;
        }

        return array_values($resultado);
    }
    
    /**
     * Devuelve las tiendas.
     * @return array
     */
    public function tiendasPresta() {
        $tiendas = array();
        $tiendasTemp = Shop::getShops();
        foreach($tiendasTemp as $tiendaTemp) {
            $tiendas[] = array('idShop' => $tiendaTemp['id_shop'], 'nombre' => $tiendaTemp['name']);
        }
        
        return $tiendas;
    }
    
    /**
     * Devuelve los empleados.
     * @return array
     */
    public function empleados() {
        $empleados = array();
        $empleadosTemp = Employee::getEmployees();
        foreach($empleadosTemp as $empleadoTemp) {
            $empleados[] = array('id_employee' => $empleadoTemp['id_employee'], 'nombre' => $empleadoTemp['firstname'].' '.$empleadoTemp['lastname']);
        }
        
        return $empleados;
    }
    
    /**
     * Devuelve los paises de presta.
     * @return array
     */
    public function paisesPresta() {
        $paises = array();
        $paisesTemp = Country::getCountries($this->idLang, true);
        foreach($paisesTemp as $paisTemp) {
            $paises[] = array('idCountry' => $paisTemp['id_country'], 'nombre' => $paisTemp['name'], 'prefijoTelefonico' => trim($paisTemp['call_prefix']));
        }
        
        return $paises;
    }
    
    /**
     * Devuelve las provincias de presta.
     * @return array
     */
    public function provinciasPresta() {
        $provincias = array();
        $provinciasTemp = State::getStates($this->idLang, true);
        foreach($provinciasTemp as $provinciaTemp) {
            $provincias[] = array('idState' => $provinciaTemp['id_state'], 'nombre' => $provinciaTemp['name'], 'idCountry' => $provinciaTemp['id_country']);
        }
        
        return $provincias;
    }

    /**
     * Elimina informacion adicional de producto.
     * @param int $id_product
     * @param int $id_product_attribute
     * @return boolean
     */
    public function eliminarExtraProducto($id_product, $id_product_attribute = 0) {
        $id_product = (int) $id_product;
        $id_product_attribute = (int) $id_product_attribute;

        return Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . self::prefijo . "extraProducto` WHERE id_product = '$id_product'".($id_product_attribute ? " AND id_product_attribute = '$id_product_attribute'" : ''));
    }

    /**
     * Graba informacion adicional del producto.
     * @param int $id_product
     * @param string $ubicacion
     * @param int $id_product_attribute
     * @return boolean
     */
    public function grabarExtraProducto($id_product, $ubicacion, $id_product_attribute = 0) {
        $id_product = (int) $id_product;
        $id_product_attribute = (int) $id_product_attribute;
        $ubicacion = pSQL($ubicacion);

        return Db::getInstance()->execute('REPLACE INTO `' . _DB_PREFIX_ . self::prefijo . "extraProducto` (id_product, id_product_attribute, ubicacion) VALUES ('$id_product', '$id_product_attribute', '$ubicacion')");
    }

    /**
     * @param int $id_product
     * @return bool
     */
    public function borrarImprimirEtiquetaProducto($id_product){
        return Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . self::prefijo . "opcionImprimirEtiquetaProducto` WHERE id_product = '$id_product'");
    }

    /**
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $imprimirEtiquetaProducto
     * @param int $imprimirUnaEtiqueta
     * @return bool
     */
    public function grabarImprimirEtiqueta($id_product, $id_product_attribute, $imprimirEtiquetaProducto, $imprimirUnaEtiqueta){
        $id_product = (int) $id_product;
        $id_product_attribute = (int) $id_product_attribute;
        $imprimirEtiquetaProducto = (bool) $imprimirEtiquetaProducto;
        $imprimirUnaEtiqueta = (bool) $imprimirUnaEtiqueta;
        return Db::getInstance()->execute('REPLACE INTO `' . _DB_PREFIX_ . self::prefijo . "opcionImprimirEtiquetaProducto` (id_product, id_product_attribute, imprimirEtiqueta, imprimirUnaEtiqueta) VALUES ('$id_product', '$id_product_attribute', '$imprimirEtiquetaProducto', '$imprimirUnaEtiqueta')");
    }

    /**
     * @return bool
     */
    public function cargarImprimirEtiquetaProducto(){
        $sql = 'SELECT * FROM `' . _DB_PREFIX_ . self::prefijo . "opcionImprimirEtiquetaProducto`";
        return Db::getInstance()->executeS($sql);
    }

    public function cargarImprimirEtiqueta($idProduct, $idProductAttribute = 0){
        $idProduct = (int) $idProduct;
        $idProductAttribute = (int) $idProductAttribute;
        return Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . self::prefijo . "opcionImprimirEtiquetaProducto` WHERE id_product = '$idProduct' AND id_product_attribute = '$idProductAttribute'");
    }
    /**
     * Devuelve datos extra del producto.
     * @param int $id_product
     * @param int $id_product_attribute Si es false se ignora.
     * @return array
     */
    public function cargarExtraProducto($id_product, $id_product_attribute = false) {
        return ($id_product_attribute !== false ? $this->cargarExtraUnaCombinacion($id_product, $id_product_attribute) : 
            $this->cargarExtraTodasCombinaciones($id_product));
    }
    
    /**
     * Devuelve los datos extra para una combinacion.
     * @param int $id_product
     * @param int $id_product_attribute
     * @return array
     */
    private function cargarExtraUnaCombinacion($id_product, $id_product_attribute) {
        //Datos extra
        $id_product = (int) $id_product;
        $id_product_attribute = (int) $id_product_attribute;
        $resultado = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . self::prefijo . "extraProducto` WHERE id_product = '$id_product' AND id_product_attribute = '$id_product_attribute'");
        
        $origenUbicacion = Configuration::getGlobalValue(self::prefijo . 'ORIGEN_UBI_PDA');
        if($origenUbicacion == 1) {
            //obswarehouselocation
            $modulo = Module::getInstanceByName('obswarehouselocation');
            if($modulo) {
                $localizacion = $modulo->getWarehouseLocation($id_product);
                $resultado['id_product'] = $id_product;
                $resultado['id_product_attribute'] = $id_product_attribute;
                $resultado['ubicacion'] = $localizacion;
            }
        }
        elseif($origenUbicacion == 2) {
            //Prestashop
            if($this->hayUbicacionesPresta()) {
                $resultado['id_product'] = $id_product;
                $resultado['id_product_attribute'] = $id_product_attribute;
                $resultado['ubicacion'] = Db::getInstance()->getValue('SELECT location FROM `'._DB_PREFIX_."stock_available` WHERE id_product = '$id_product' AND id_product_attribute = '$id_product_attribute'");
            }
        }
        
        return $resultado;
    }
    
    /**
     * Devuelve los datos extra de un producto.
     * @param int $id_product
     * @return array
     */
    private function cargarExtraTodasCombinaciones($id_product) {
        $resultado = array();
        
        //Datos extra
        $id_product = (int) $id_product;
        $temp = Db::getInstance()->executeS('SELECT * FROM `' . _DB_PREFIX_ . self::prefijo . "extraProducto` WHERE id_product = '$id_product'");
        foreach($temp as $t) {
            $resultado[$t['id_product_attribute']] = $t;
        }

        $origenUbicacion = Configuration::getGlobalValue(self::prefijo . 'ORIGEN_UBI_PDA');
        if($origenUbicacion == 1) {
            //obswarehouselocation
            $modulo = Module::getInstanceByName('obswarehouselocation');
            if($modulo) {
                $localizacion = $modulo->getWarehouseLocation($id_product);
                $resultado[0]['id_product'] = $id_product;
                $resultado[0]['id_product_attribute'] = 0;
                $resultado[0]['ubicacion'] = $localizacion;
            }
        }
        elseif($origenUbicacion == 2) {
            //Prestashop
            if($this->hayUbicacionesPresta()) {
                $localizaciones = Db::getInstance()->executeS('SELECT id_product_attribute, location FROM `'._DB_PREFIX_."stock_available` WHERE id_product = '$id_product'");
                foreach($localizaciones as $localizacion) {
                    $resultado[$localizacion['id_product_attribute']]['id_product'] = $id_product;
                    $resultado[$localizacion['id_product_attribute']]['id_product_attribute'] = $localizacion['id_product_attribute'];
                    $resultado[$localizacion['id_product_attribute']]['ubicacion'] = $localizacion['location'];
                }
            }
        }

        return $resultado;
    }

    /**
     * Guarda un numero de serie.
     * @param int $id_order
     * @param int $id_order_detail
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $num
     * @param string $numSerie
     * @return boolean
     */
    public function guardarNumeroSerie($id_order, $id_order_detail, $id_product, $id_product_attribute, $num, $numSerie) {
        $id_order = (int)$id_order;
        $id_order_detail = (int)$id_order_detail;
        $id_product = (int)$id_product;
        $id_product_attribute = (int)$id_product_attribute;
        $num = (int)$num;
        $numSerie = pSQL($numSerie);
        
        return Db::getInstance()->execute('REPLACE INTO `' . _DB_PREFIX_ . self::prefijo . "numSerie` (id_order, id_order_detail, id_product, id_product_attribute, num, numSerie) VALUES ('$id_order', '$id_order_detail', '$id_product', '$id_product_attribute', '$num', '$numSerie')");
    }

    /**
     * Guarda un reemplazo.
     * @param int $id_order
     * @param int $id_order_detail
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $id_product_reemplazo
     * @param int $id_product_attribute_reemplazo
     * @return boolean
     */
    public function guardarReemplazo($id_order, $id_order_detail, $id_product, $id_product_attribute, $id_product_reemplazo, $id_product_attribute_reemplazo) {
        $id_order = (int)$id_order;
        $id_order_detail = (int)$id_order_detail;
        $id_product = (int)$id_product;
        $id_product_attribute = (int)$id_product_attribute;
        $id_product_reemplazo = (int)$id_product_reemplazo;
        $id_product_attribute_reemplazo = (int)$id_product_attribute_reemplazo;
        
        return Db::getInstance()->execute('REPLACE INTO `'._DB_PREFIX_.self::prefijo."orderDetailExtra` (id_order, id_order_detail, id_product, id_product_attribute, id_product_reemplazo, id_product_attribute_reemplazo) VALUES ('$id_order', '$id_order_detail', '$id_product', '$id_product_attribute', '$id_product_reemplazo', '$id_product_attribute_reemplazo')");
    }
    
    /**
     * Devuelve los reemplazos disponibles para un pedido.
     * @param int $id_order
     * @return array
     */
    public function recuperarReemplazos($id_order) {
        $id_order = (int)$id_order;
        
        return Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.self::prefijo."orderDetailExtra` WHERE id_order = '$id_order'");
    }

    /**
     * Devuelve los numeros de serie de un pedido.
     * @param int $id_order
     * @return array
     */
    public function recuperarNumerosSerie($id_order) {
        $id_order = (int) $id_order;
        
        return Db::getInstance()->executeS('SELECT * FROM `' . _DB_PREFIX_ . self::prefijo . "numSerie` WHERE id_order = '$id_order' ORDER BY id_product ASC, id_product_attribute ASC");
    }

    public function productoTieneNumerosSerie($id_product) {
        //Todos los productos tienen 
        if (Configuration::getGlobalValue(self::prefijo . 'ACT_NOM_SER')) {
            return true;
        }
        //La categoria por defecto del producto tiene
        $product = new Product($id_product);
        if($this->tieneNumSerieCat($product->id_category_default)) {
            return true;
        }
        //El producto tiene
        $id_product = (int) $id_product;
        $datos = Db::getInstance()->getValue('SELECT 1 FROM `' . _DB_PREFIX_ . self::prefijo . "numSerieActivo` WHERE id_product = '$id_product' and activo = 1");
        return (boolean) $datos;
    }

    public function productoGuardarNumerosSerie($id_product, $value) {
        $id_product = (int) $id_product;
        if ($id_product) {
            $value = (int) $value;
            $datos = Db::getInstance()->execute('REPLACE INTO `' . _DB_PREFIX_ . self::prefijo . "numSerieActivo` (id_product, activo) VALUES  ('$id_product','$value')");
            return $datos;
        }
    }
    
    /**
     * Devuelve los datos de los pedidos impresos en las fechas indicadas.
     * @param string $fechaInicio
     * @param string $fechaFin
     * @return array
     */
    private function obtenerPedidosImpresos($fechaInicio = '', $fechaFin = '') {
        $where = '';
        if ($fechaInicio) {
            $fechaInicio = pSQL($fechaInicio);
            $where .= "AND o.date_add >= '$fechaInicio' ";
        }
        if ($fechaFin) {
            $fechaFin = pSQL($fechaFin);
            $where .= "AND o.date_add <= '$fechaFin 23:59:59' ";
        }
        
        $filas = Db::getInstance()->executeS(
                'SELECT o.date_add, o.id_order FROM `' . _DB_PREFIX_ . 'orders` o 
                    INNER JOIN `' . _DB_PREFIX_ . self::prefijo . "descarga` d ON o.id_order = d.idPedido
                WHERE 1=1 $where");
        $filasFormateadas = array();
        foreach($filas as $fila) {
            $pedido = new Order($fila['id_order']);
            $cliente = new Customer($pedido->id_customer);
            $nombreCliente = $cliente->firstname.' '.$cliente->lastname;
            $peso = $pedido->getTotalWeight();
            $transportista = new Carrier($pedido->id_carrier);
            $nombreTransportista = $transportista->name;
            $direccionEntrega = new Address($pedido->id_address_delivery);
            $nombrePais = Country::getNameById($this->idLang, $direccionEntrega->id_country);
            
            $filasFormateadas[] = array($pedido->id, $nombreCliente, $peso, $nombreTransportista, $nombrePais);
        }
        
        return $filasFormateadas;
    }
    
    /**
     * Devuelve el pdf de los pedidos impresos.
     * @param string $fechaInicio
     * @param string $fechaFin
     * @return string
     */
    public function generarPdfPedidosImpresos($fechaInicio = '', $fechaFin = '') {
        require_once dirname(__FILE__). '/clases/pdf/HTMLTemplatePedidosImpresos.php';
        require_once dirname(__FILE__) . '/clases/ImaxPDF.php';

        $pdf = new ImaxPDF(array($this->obtenerPedidosImpresos($fechaInicio, $fechaFin)), 'PedidosImpresos', Context::getContext()->smarty, 
                'A4', 'P', false, false);
        $pedidos = $pdf->render('S');

        return $pedidos;
    }
    
    /**
     * Exporta los pedidos impresos.
     * @param string $fechaInicio
     * @param string $fechaFin
     */
    public function exportarPedidosImpresos($fechaInicio = '', $fechaFin = '') {
        $this->exportarCsv(array('ID pedido', 'Nombre cliente', 'Peso', 'Transportista', 'pais'), $this->obtenerPedidosImpresos($fechaInicio, $fechaFin), 'pedidosImpresos.csv');
    }
    
    /**
     * Exporta los pedidos procesados por las pdas.
     * @param string $fechaInicio
     * @param string $fechaFin
     */
    public function exportarProcesadosPda($fechaInicio = '', $fechaFin = '') {
        $this->exportarCsv(array('Fecha', 'Empleado', 'ID pedido', 'Referencia pedido'), $this->obtenerProcesadosPda($fechaInicio, $fechaFin), 'procesadosPda.csv');
    }
    
    /**
     * Devuelve un array con los datos de los pedidos procesados por la pda.
     * @param string $fechaInicio
     * @param string $fechaFin
     * @return array
     */
    private function obtenerProcesadosPda($fechaInicio = '', $fechaFin = '') {
        $procesados = [];
        
        $where = '';
        if($fechaInicio) {
            $fechaInicio = pSQL($fechaInicio);
            $where .= " AND DATE(fechaFin) >= '$fechaInicio'";
        }
        if($fechaFin) {
            $fechaFin = pSQL($fechaFin);
            $where .= " AND DATE(fechaFin) <= '$fechaFin'";
        }
        $datos = Db::getInstance()->executeS('
            SELECT * FROM `'._DB_PREFIX_.self::prefijo.'procesadoPedido` pp 
                LEFT JOIN `'._DB_PREFIX_.'orders` o ON pp.idPedido = o.id_order
                LEFT JOIN `'._DB_PREFIX_."employee` e ON pp.idEmpleado = e.id_employee
            WHERE fechaFin IS NOT NULL $where
            ORDER BY DATE(fechaFin) ASC, id_employee ASC");
     
        foreach($datos as $dato) {
            $procesados[] = [$this->formatDate($dato['fechaFin']), $dato['firstname'].' '.$dato['lastname'], $dato['id_order'], $dato['reference']];
        }
        
        return $procesados;
    }
    
    /**
     * Devuelve la fecha en el formato actual.
     * @param string $dateString
     * @return string
     */
    private function formatDate($dateString) {
        $time = strtotime($dateString);
        $context = Context::getContext();
        $date_format = $context->language->date_format_lite;
        return date($date_format, $time);
    }

    /**
     * Exporta un csv con los numeros de serie.
     * @param string $fechaInicio
     * @param string $fechaFin
     * @param int $idEstadoPedido
     */
    public function exportarNumerosSerie($fechaInicio = '', $fechaFin = '', $idEstadoPedido = 0) {
        $where = '';
        if ($fechaInicio) {
            $fechaInicio = pSQL($fechaInicio);
            $where .= "AND o.date_add >= '$fechaInicio' ";
        }
        if ($fechaFin) {
            $fechaFin = pSQL($fechaFin);
            $where .= "AND o.date_add <= '$fechaFin 23:59:59' ";
        }
        if ($idEstadoPedido) {
            $idEstadoPedido = (int) $idEstadoPedido;
            $where .= "AND o.current_state = $idEstadoPedido";
        }

        $filas = Db::getInstance()->executeS(
                'SELECT o.date_add, o.id_order, od.product_name, ns.numSerie, od.product_reference FROM `' . _DB_PREFIX_ . 'orders` o 
                    INNER JOIN `' . _DB_PREFIX_ . 'order_detail` od ON o.id_order = od.id_order
                    LEFT JOIN `' . _DB_PREFIX_ . self::prefijo . "numSerie` ns ON od.id_order = ns.id_order AND od.id_order_detail = ns.id_order_detail
                WHERE 1=1 $where");

        $this->exportarCsv(array('Fecha', 'Id pedido', 'Nombre', 'Serie', 'Referencia'), $filas, 'numerosSerie.csv');
    }

    /**
     * Crea un csv y lo envío al navegador.
     * @param array $cabecera Un array de string con los nombres de los datos.
     * @param array $filas Un array de dos dimensiones con los datos.
     * @param string $nombreArchivo 
     */
    private function exportarCsv($cabecera, $filas, $nombreArchivo) {
        header("Content-Type: text/csv; charset=iso-8859-15");
        header("Content-Disposition: attachment; filename=$nombreArchivo");
        header("Content-Transfer-Encoding: binary");
        $out = fopen('php://output', 'w');
        //La cabecera
        if ($cabecera) {
            fputcsv($out, $this->utf8_decode_array($cabecera), ';', '"');
        }
        //Los datos
        foreach ($filas as $fila) {
            fputcsv($out, $this->utf8_decode_array($fila), ';', '"');
        }

        fclose($out);
        exit;
    }

    public function utf8_decode_array($array) {
        if (is_array($array)) {
            foreach ($array as $key => $value) {
                if (mb_detect_encoding($value) == 'UTF-8') {
                    $array[$key] = utf8_decode($value);
                }
            }
        } else {
            if (mb_detect_encoding($array) == 'UTF-8') {
                $array = utf8_decode($array);
            }
        }

        return $array;
    }
    
    /**
     * Devuelve los datos extra de un empleado.
     * @param int $id_employee
     * @return array
     */
    public function obtenerDatosExtraEmpleado($id_employee) {
        $id_employee = (int)$id_employee;
        
        $datos = Db::getInstance()->getRow('SELECT * FROM `'._DB_PREFIX_.self::prefijo."employeeExtra` WHERE id_employee = '$id_employee'");
        if($datos) {
            $datos['proveedores'] = unserialize($datos['proveedores']);
            $datos['formasPago'] = unserialize($datos['formasPago']);
        }
        
        return $datos;
    }
    
    /**
     * Guarda la informacion extra de un empleado.
     * @param int $id_employee
     * @param int[] $proveedores
     * @param int[] $formasPago
     * @return boolean
     */
    private function guardarDatosExtraEmpleado($id_employee, $proveedores, $formasPago) {
        $id_employee = (int)$id_employee;
        $proveedores = pSQL(serialize($proveedores), true);
        $formasPago = pSQL(serialize($formasPago), true);
        
        return Db::getInstance()->execute('REPLACE INTO `'._DB_PREFIX_.self::prefijo."employeeExtra` (id_employee, proveedores, formasPago) VALUES ('$id_employee', '$proveedores', '$formasPago')");
    }
    
    /**
     * Indica si los productos de la categoria tienen numero de serie.
     * @param int $id_category
     * @return boolean
     */
    private function tieneNumSerieCat($id_category) {
        $id_category = (int)$id_category;
        
        return (boolean)Db::getInstance()->getValue('SELECT 1 FROM `'._DB_PREFIX_.self::prefijo."numSerieActivoCat` WHERE id_category = '$id_category'");
    }
    
    /**
     * Inserta una categoria para indicar que sus productos tienen numero de serie.
     * @param int $id_category
     * @param boolean $tiene
     * @return boolean
     */
    private function guardarNumSerieCat($id_category, $tiene) {
        $id_category = (int)$id_category;
        if($tiene) {
            $sql = 'INSERT IGNORE `'._DB_PREFIX_.self::prefijo."numSerieActivoCat` (id_category) VALUES ('$id_category')";
        }
        else {
            $sql = 'DELETE FROM `'._DB_PREFIX_.self::prefijo."numSerieActivoCat` WHERE id_category = '$id_category'";
        }
        
        return Db::getInstance()->execute($sql);
    }
    
    public function hookDisplayAdminEmployeesForm($params) {
        require_once(dirname(__FILE__) . '/functionsForm.php');
        
        $proveedoresFormateados = array();
        $proveedores = Supplier::getSuppliers();
        foreach($proveedores as $proveedor) {
            $proveedoresFormateados[] = array('value' => $proveedor['id_supplier'], 'text' => $proveedor['name']);
        }
        $formasPagoFormateadas = array();
        $formasPago = PaymentModule::getInstalledPaymentModules();
        foreach($formasPago as $formaPago) {
            $modulo = Module::getInstanceByName($formaPago['name']);
            
            $formasPagoFormateadas[] = array('value' => $formaPago['name'], 'text' => $modulo->displayName);
        }
        
        $datosAlmacenados = $this->obtenerDatosExtraEmpleado(Tools::getValue('id_employee'));
        
        $form = new imaxForm($this, $this->_path, '', 'post', '', '', false, true);
        $form->createFormCheckboxGroupList('proveedores', $this->l('Proveedores visibles en PDA'), $this->l('Proveedores visibles en PDA'), 
                $proveedoresFormateados, ($datosAlmacenados['proveedores'] ? $datosAlmacenados['proveedores'] : array()));
        $form->createFormCheckboxGroupList('formasPago', $this->l('Formas de pago visibles en PDA'), $this->l('Formas de pago visibles en PDA'), 
                $formasPagoFormateadas, ($datosAlmacenados['formasPago'] ? $datosAlmacenados['formasPago'] : array()));
        
        return $form->renderForm();
    }
    
    public function hookActionAdminEmployeesControllerSaveAfter($params) {
        if($params['return']) {
            $this->guardarDatosExtraEmpleado(Tools::getValue('id_employee'), Tools::getValue('proveedores', array()), Tools::getValue('formasPago', array()));
        }
    }
    
    public function hookDisplayBackOfficeCategory($params) {
        //Para DHL AIR
        require_once(dirname(__FILE__) . '/functionsForm.php');

        $form = new imaxForm($this, $this->_path, '', 'post', '', '', false, true);
        
        $id_category = (int)Tools::getValue('id_category');
        $contenido = Db::getInstance()->getValue('SELECT dhlAirContenido FROM `'._DB_PREFIX_.self::prefijo."catExtra` WHERE id_category = '$id_category'");
        $nombreCampoNumSerie = Configuration::getGlobalValue(self::prefijo . 'NOM_SER');
        
        $html = $form->createFormTextGroup('dhlAirContenido', $contenido, $this->l('Mensaje de contenido para la Aduana'));
        $html .= $form->createFormCheckboxGroup('numSerie', $this->l('Tiene').' '.(isset($nombreCampoNumSerie) ? $nombreCampoNumSerie : $this->l('Numero de Serie')), $this->tieneNumSerieCat($id_category));
        
        return $html;
    }
    
    public function hookActionCategoryAdd($params) {
        $this->hookActionCategoryUpdate($params);
    }
        
    public function hookActionCategoryUpdate($params) {
        $id_category = (int)$params['category']->id;
        $contenido = pSQL(trim(Tools::getValue('dhlAirContenido')));
        $numSerie = Tools::getValue('numSerie');
        $this->guardarNumSerieCat($id_category, $numSerie);
        
        Db::getInstance()->execute('REPLACE INTO `'._DB_PREFIX_.self::prefijo."catExtra` (id_category, dhlAirContenido) VALUES ('$id_category', '$contenido')");
    }

    public function hookDisplayPDFInvoice($params) {
        $html = '';
        
        //Reemplazos
        $reemplazos = $this->recuperarReemplazos($params['object']->id_order);
        if($reemplazos) {
            $html .= '<h3>' . $this->l('Reemplazos') . '</h3>';
            foreach($reemplazos as $reemplazo) {
                $nombreProducto = Product::getProductName($reemplazo['id_product'], $reemplazo['id_product_attribute']);
                $nombreReemplazo = Product::getProductName($reemplazo['id_product_reemplazo'], $reemplazo['id_product_attribute_reemplazo']);
                $html .= "<p>$nombreProducto => $nombreReemplazo</p>";
            }
        }
        //Numeros de serie
        if (Configuration::getGlobalValue(self::prefijo . 'NSERIE_FACTURA') && $this->getLicenciaAdicional('imaximprimepedidosservidornumserie')) {
            $html .= '<h3>' . $this->l('Numeros de serie') . '</h3>';
            $order = new Order($params['object']->id_order);
            $numerosSerie = $this->recuperarNumerosSerie($order->id);
            foreach ($numerosSerie as $numeroSerie) {
                $nombreProducto = Product::getProductName($numeroSerie['id_product'], $numeroSerie['id_product_attribute']);
                $html .= "<p>$nombreProducto => {$numeroSerie['numSerie']}</p>";
            }
        }

        return $html;
    }
    
    public function hookDisplayAdminOrderTop($params) {
        if(!self::$hookedTopOrder) {
            self::$hookedTopOrder = true;
            
            $pedido = new Order($params['id_order']);
            //Comprobamos si es un transportista con bultos manuales
            $referenciasTransportista = $this->obtenerReferenciaTransportistas();
            $mostrarNumeroBultos = false;
            $bultosManuales = new BultosManuales($pedido->id);
            if(isset($referenciasTransportista[$pedido->id_carrier])) {
                $generador = (new CentralizadorEtiquetas($this))->obtenerGenerador($referenciasTransportista[$pedido->id_carrier]);
                
                $mostrarNumeroBultos = $generador->cargarConfiguracion()->bultosManuales;
                $numeroBultos = $bultosManuales->obtenerBultosManuales();
                $bultosBloqueado = $generador->obtenerBultosBloqueados($pedido);
            }
            if($this->esGenerica($pedido->id_carrier)) {
                //Generico
                $generadorGenerico = new GeneradorEtiquetaGenerica($this);
                $mostrarNumeroBultos = $generadorGenerico->cargarConfiguracion()->bultosManuales;
                $numeroBultos = $bultosManuales->obtenerBultosManuales();
                $bultosBloqueado = $generadorGenerico->obtenerBultosBloqueados($pedido);
            }
            if($mostrarNumeroBultos) {
                $this->smarty->assign('mostrarNumeroBultosBloqueado', $bultosBloqueado);
                $this->smarty->assign('numeroBultos', $numeroBultos);
                $this->smarty->assign('id_order', $params['id_order']);
                $this->smarty->assign('baseUrl', $this->_path);
                $this->smarty->assign('pass', Configuration::getGlobalValue(self::prefijo . 'PASS'));

                $html = $this->display($this->name, 'extraPedido_17.tpl');
            }
            else {
                $html = '';
            }
        }
        else {
            $html = '';
        }
        
        return $html;
    }

    public function hookDisplayAdminOrder($params) {
        //Mensajes
        $mensajes = Message::getMessagesByOrderId($params['id_order'], true);
        foreach($mensajes as &$mensaje) {
            $mensaje['date_add'] = Tools::displayDate($mensaje['date_add'], null, true);
        }
        $this->smarty->assign(
                array(
                    'mensajes' => $mensajes));
        $output = $this->display('imaximprimepedidosservidor', 'views/hook/messages.tpl');
        //Cantidad de bultos
        if(!self::$hookedTopOrder) {
            $output .= $this->hookDisplayAdminOrderTop($params);
        }
        
        //Productos servidos
        $productosServidos = $this->obtenerCantidadesServidas($params['id_order']);
        if($productosServidos) {
            $productosServidosTemp = array();
            foreach($productosServidos as $productoServido) {
                $productosServidosTemp[] = array(
                    'nombre' => Product::getProductName($productoServido['idProducto'], $productoServido['idCombinacion']),
                    'cantidadServida' => $productoServido['cantidadServida'],
                    'cantidadTotal' => $productoServido['cantidadNecesaria']);
            }
            
            $this->smarty->assign(
                    array('productosServidos' => $productosServidosTemp));
            $output .= $this->display($this->name, 'views/hook/productosServidos.tpl');
        }
        
        $order = new Order($params['id_order']);
        //Local del pedido
        if(Configuration::getGlobalValue(self::prefijo.'USAR_LOCALES') && !Module::isEnabled('imaxrecogidatienda')) {
            $id_store = $this->obtenerLocalPedido($order);
            $locales = $this->obtenerLocales();
            $this->smarty->assign(array(
                'id_store' => $id_store,
                'locales' => array_merge(array(array('id_store' => 0, 'name' => $this->l('- Ninguno -'))), $locales),
                'path' => $this->_path,
                'id_order' => $params['id_order'],
                'passRemota' => Configuration::get(self::prefijo . 'PASS')
            ));
            
            $output .= $this->display($this->name, 'views/hook/localPedido.tpl');
        }
        
        //Reemplazos
        $reemplazosOrdenados = array();
        $reemplazos = $this->recuperarReemplazos($params['id_order']);
        if($reemplazos) {
            foreach($reemplazos as $reemplazo) {
                $reemplazosOrdenados[] = array('origen' => Product::getProductName($reemplazo['id_product'], $reemplazo['id_product_attribute']), 
                    'destino' => Product::getProductName($reemplazo['id_product_reemplazo'], $reemplazo['id_product_attribute_reemplazo']));
            }
            $this->smarty->assign(array('reemplazos' => $reemplazosOrdenados));

            $output .= $this->display($this->name, 'views/hook/reemplazos.tpl');
        }
        
        //Filas eliminadas
        $filasEliminadas = $this->cargarFilasPedidoEliminadas($params['id_order']);
        if($filasEliminadas) {
            $moneda = new Currency($order->id_currency);
            foreach($filasEliminadas as &$filaEliminada) {
                $filaEliminada['fila']['total_price_tax_incl'] = ($this->versionPS >= 17.6 ? 
                    $this->context->currentLocale->formatPrice($filaEliminada['fila']['total_price_tax_incl'], $moneda->iso_code) : 
                    round($filaEliminada['fila']['total_price_tax_incl'], 2).' '.$moneda->sign);
                $filaEliminada['employee'] = new Employee($filaEliminada['id_employee']);
            }
            $this->smarty->assign(array('filasEliminadas' => $filasEliminadas));

            $output .= $this->display($this->name, 'views/hook/eliminadas.tpl');
        }

        //Numeros de serie
        if ($this->getLicenciaAdicional('imaximprimepedidosservidornumserie')) {
            $pass = Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS');
            $link = new Link();
            $url = $link->getAdminLink('AdminOrders') . '&vieworder&id_order=' . (int) $params['id_order'];
            $actNumSerie = (int) Configuration::getGlobalValue(self::prefijo . 'ACT_NOM_SER');

            $nombreCampoNumSerie = Configuration::getGlobalValue(self::prefijo . 'NOM_SER');
            $arrayProductosNumSerie = array();
            $productos = $order->getProducts();
            foreach ($productos as $p) {
                if (!$actNumSerie && !$this->productoTieneNumerosSerie($p['product_id'])) {
                    continue;
                }

                for ($i = 0; $i < $p['product_quantity']; $i++) {
                    $arrayProductosNumSerie[(int)$p['id_order'].'_'.(int)$p['id_order_detail'].'_'.(int)$p['product_id'].'_'.(int)$p['product_attribute_id'].'_'. $i] = $p['product_name'];
                }
            }
            $numerosSerieOrdenados = array();
            $numerosSerie = $this->recuperarNumerosSerie($params['id_order']);
            foreach($numerosSerie as $numeroSerie) {
                $numerosSerieOrdenados[(int)$numeroSerie['id_order'].'_'.(int)$numeroSerie['id_order_detail'].'_'.(int)$numeroSerie['id_product'].'_'.(int)$numeroSerie['id_product_attribute'].'_'.(int)$numeroSerie['num']] = $numeroSerie['numSerie'];
            }
            
            $this->smarty->assign(
                    array(
                        'nombreCampoNumSerie' => (isset($nombreCampoNumSerie) ? $nombreCampoNumSerie : $this->l('Numero de Serie'))
                        , 'arrayProductosNumSerie' => $arrayProductosNumSerie
                        , 'pass' => $pass
                        , 'path' => $this->_path
                        , 'id_order' => $params['id_order']
                        , 'url' => $url
                        , 'passRemota' => Configuration::get(self::prefijo . 'PASS')
                        , 'valoresNumerosSerie' => $numerosSerieOrdenados));
            
            $output .= $this->display($this->name, 'views/hook/numSerie.tpl');
        }
        
        return $output;
    }
    
    public function hookDisplayCarrierList($params) {
    
    }

    public function hookActionAdminStoresListingFieldsModifier($params){

    }

    public function hookActionActionObjectStoreAddAfter($params){

    }

    public function hookActionActionObjectStoreUpdateAfter($params){

    }

    public function hookActionActionAdminStoresFormModifier($params){

    }

    public function hookDisplayProductButtons($params){

    }

    public function hookDisplayAdminOrderLeft($params){

    }

    public function hookActionOrder($params){
        
    }

    /**
     * Devuelve el id del local para un pedido.
     * @param Order $pedido
     * @return int
     */
    public function obtenerLocalPedido($pedido) {
        $id_store = Db::getInstance()->getValue('SELECT id_store FROM `'._DB_PREFIX_.self::prefijo."orderExtra` WHERE id_order = '$pedido->id'");        
        if(!$id_store && Module::isInstalled('imaxrecogidatienda')) {
            $recogida = Module::getInstanceByName('imaxrecogidatienda');
            $datosPedido = $recogida->obtenerTienda($pedido);
            if($datosPedido && $datosPedido['id_store']) {
                $id_store = $datosPedido['id_store'];
                $this->modificarLocalPedido($pedido->id, $id_store);
            }
        }
        
        return $id_store;
    }
    
    /**
     * Cambia el local asignado a un pedido.
     * @param int $id_order
     * @param int $id_store
     * @return boolean
     */
    public function modificarLocalPedido($id_order, $id_store) {
        $id_order = (int)$id_order;
        $id_store = (int)$id_store;
        
        return Db::getInstance()->execute('INSERT INTO `'._DB_PREFIX_.self::prefijo."orderExtra` (id_order, id_store) VALUES ('$id_order', '$id_store') ON DUPLICATE KEY UPDATE id_store = '$id_store'");
    }
    
    /**
     * Busca un producto.
     * @param string $texto
     * @param boolean $ignorarCombinaciones
     * @return array
     */
    public function buscarProducto($texto, $ignorarCombinaciones = false) {
        require_once dirname(__FILE__).'/pda/funciones/funciones.php';
        
        $texto = pSQL($texto);
        $textoTrim = pSQL(trim($texto));
        
        if (Module::isEnabled('imaxmultiean')) {
            $module = Module::getInstanceByName('imaxmultiean');
            $encontrados = Db::getInstance()->executeS('
            SELECT p.id_product as product_id, 
                   0 as product_attribute_id, 
                   name, 
                   COALESCE(MAX(me.ean13), p.ean13) as product_ean13, 
                   reference as product_reference 
            FROM `'._DB_PREFIX_.'product` p 
            INNER JOIN `'._DB_PREFIX_."product_lang` pl ON p.id_product = pl.id_product 
            LEFT JOIN `" . _DB_PREFIX_ . $module->prefijo . "multiean` me ON p.id_product = me.id_product
            WHERE id_lang = '$this->idLang' 
              AND id_shop = '$this->idShop' 
              AND (name LIKE '%$texto%' OR TRIM(p.reference) = '$textoTrim' OR TRIM(p.ean13) = '$textoTrim' OR TRIM(me.ean13) = '$textoTrim' )
            GROUP BY p.id_product
            ORDER BY name ASC 
            LIMIT 100");

        }else{
        $encontrados = Db::getInstance()->executeS('
            SELECT p.id_product as product_id, 0 as product_attribute_id, name, ean13 as product_ean13, reference as product_reference FROM `'._DB_PREFIX_.'product` p 
                INNER JOIN `'._DB_PREFIX_."product_lang` pl ON p.id_product = pl.id_product 
            WHERE id_lang = '$this->idLang' AND id_shop = '$this->idShop' AND (name LIKE '%$texto%' OR TRIM(reference) = '$textoTrim' OR TRIM(ean13) = '$textoTrim')
            ORDER BY name ASC 
            LIMIT 100");
        }
        
        // Realizar la búsqueda en las tablas de productos, combinaciones y, opcionalmente, multiean
        
    
        $resultado = array();
    
        // Procesamiento de los resultados
        foreach($encontrados as $encontrado) {
            if($ignorarCombinaciones) {
                $combinaciones = [];
            }
            else {
                $combinaciones = Product::getProductAttributesIds($encontrado['product_id']);
            }
            
            if($combinaciones) {
                foreach($combinaciones as $combinacion) {
                    $datosCombinacion = Db::getInstance()->getRow('SELECT ean13 as product_ean13, reference as product_reference FROM `'._DB_PREFIX_."product_attribute` WHERE id_product_attribute = '{$combinacion['id_product_attribute']}'");
                    $combinacion += $datosCombinacion;
                    $combinacion['product_id'] = $encontrado['product_id'];
                    $combinacion['product_attribute_id'] = $combinacion['id_product_attribute'];
                    $identificador = seleccionarIdentificador($combinacion);
                    $resultado[] = array('id_product' => $encontrado['product_id'], 'id_product_attribute' => $combinacion['product_attribute_id'],
                        'name' => Product::getProductName($encontrado['product_id'], $combinacion['product_attribute_id'], $this->idLang), 
                        'identificador' => $identificador);
                }
            }
            else {
                $identificador = seleccionarIdentificador($encontrado);
                $resultado[] = array('id_product' => $encontrado['product_id'], 'id_product_attribute' => 0,
                    'name' => $encontrado['name'], 'identificador' => $identificador);
            }
        }
        
        return $resultado;
    }
    
    /**
     * Devuelve el id del order_carrier.
     * @param Order $pedido
     * @return int
     */
    private function getIdOrderCarrier($pedido) {
        if (version_compare(_PS_VERSION_, '1.5.5.0 ', '>=')) {
            $id = $pedido->getIdOrderCarrier();
        }
        else {
            $id = (int) Db::getInstance()->getValue('
				SELECT `id_order_carrier`
				FROM `' . _DB_PREFIX_ . 'order_carrier`
				WHERE `id_order` = ' . (int) $pedido->id);
        }

        return $id;
    }
    
    /**
     * Modifica el numero de seguimiento.
     * @param Order $pedido
     * @param string $seguimiento
     * @param boolean $email
     * @return string Devuelve un mensaje de error o una cadena vacia.
     */
    private function actualizarSeguimiento($pedido, $seguimiento, $email) {
        $error = '';

        if (Validate::isLoadedObject($pedido)) {
            try {
                $order_carrier = new OrderCarrier($this->getIdOrderCarrier($pedido));
                if (Validate::isLoadedObject($order_carrier) && Validate::isTrackingNumber($seguimiento)) {
                    // Update order_carrier
                    $order_carrier->tracking_number = $seguimiento;
                    if ($order_carrier->update()) {
                        // Send mail to customer
                        $customer = new Customer((int) $pedido->id_customer);
                        $carrier = new Carrier((int) $pedido->id_carrier, $pedido->id_lang);
                        if (Validate::isLoadedObject($customer) && Validate::isLoadedObject($carrier)) {
                            if($email) {
                                $template_vars = array(
                                    '{followup}' => str_replace('@', $order_carrier->tracking_number, $carrier->url),
                                    '{firstname}' => $customer->firstname,
                                    '{lastname}' => $customer->lastname,
                                    '{id_order}' => $pedido->id,
                                    '{shipping_number}' => $order_carrier->tracking_number,
                                    '{order_name}' => $pedido->getUniqReference()
                                );

                                if (!Mail::Send((int) $pedido->id_lang, 'in_transit', Mail::l('Package in transit', (int) $pedido->id_lang), $template_vars, $customer->email, $customer->firstname . ' ' . $customer->lastname, null, null, null, null, _PS_MAIL_DIR_, false, (int) $pedido->id_shop)) {
                                    $error = $this->l('No se pudo enviar el email.');
                                }
                            }
                            
                            Hook::exec('actionAdminOrdersTrackingNumberUpdate', array('order' => $pedido, 'customer' => $customer,
                                    'carrier' => $carrier), null, false, true, false, $pedido->id_shop);
                        } 
                        else {
                            $error = $this->l('Los datos del pedido son erroneos.');
                        }
                    } 
                    else {
                        $error = $this->l('No se pudo cambiar el seguimiento.');
                    }
                } 
                else {
                    $error = $this->l('Datos erroneos.');
                }
            } 
            catch (Exception $ex) {
                $error = $ex->getMessage();
            }
        }

        return $error;
    }
 
    /**
     * Cambia los datos pasados en la direccion indicada.
     * @param int $id_order
     * @param array $nuevosDatos
     * @return boolean
     */
    public function modificarDireccionEntrega($id_order, $nuevosDatos) {
        $resultado = false;
        
        $pedido = new Order($id_order);
        //Primero el seguimiento
        if($nuevosDatos['tracking_number']) {
            $this->actualizarSeguimiento($pedido, $nuevosDatos['tracking_number'], true);
            unset($nuevosDatos['tracking_number']);
        }
        
        $direccion = new Address($pedido->id_address_delivery);
        if(Validate::isLoadedObject($direccion)) {
            foreach($nuevosDatos as $campo => $nuevoDato) {
                $direccion->$campo = $nuevoDato;
            }
            
            try {
                $resultado = $direccion->update();
            } 
            catch (Exception $ex) { }
        }
        
        return $resultado;
    }
    
    /**
     * Devuelve las platillas de porte.
     * @return string[]
     */
    public function obtenerPlantillasPorte() {
        $plantillas = array();
        $path = dirname(__FILE__).'/porte';
        $dir = dir($path);
        while(($file = $dir->read()) !== false) {
            if(is_file($path.'/'.$file) && stripos($file, '.tpl') !== false) {
                $nombre = substr($file, 0, strpos($file, '.'));
                $plantillas[$nombre] = $nombre;
            }
        }
        
        return $plantillas;
    }

    public function hookDisplayAdminProductsExtra($params) {
        if (isset($params['id_product'])) {
            $idProducto = $params['id_product'];
        } else {
            $idProducto = Tools::getValue('id_product');
        }
        $producto = new Product($idProducto, $this->idLang);
        $datosExtra = $this->cargarExtraProducto($idProducto);
        $actNumSerie = (int) Configuration::getGlobalValue(self::prefijo . 'ACT_NOM_SER');
        $nombreCampoNumSerie = Configuration::getGlobalValue(self::prefijo . 'NOM_SER');
        $combinaciones = $producto->getAttributeCombinations($this->idLang);
        $plantillasPorte = $this->obtenerPlantillasPorte();

        // Agrupar las combinaciones por id_product_attribute
        $lineas = [];
    
        if(!$combinaciones){
            $opcionImprimirEtiquetaProducto = $this->cargarImprimirEtiqueta($idProducto);
            if (is_array($opcionImprimirEtiquetaProducto)) {
                $imprimirEtiqueta = $opcionImprimirEtiquetaProducto['imprimirEtiqueta'];
                $imprimirUnaEtiqueta = $opcionImprimirEtiquetaProducto['imprimirUnaEtiqueta'];
            } else {
                $imprimirEtiqueta = false;
                $imprimirUnaEtiqueta = false;
            }
            $opcionesAlmacenProducto = $this->cargarOpcionAlmacen($idProducto);

            $lineas[0] = [
                'id' => 0,
                'nombreAtributo' => $producto->name[$this->idLang],
                'referencia' => $producto->reference,
                'imprimirEtiqueta' => $imprimirEtiqueta,
                'imprimirUnaEtiqueta' => $imprimirUnaEtiqueta,
                'almacenEntradaPorDefecto' => $opcionesAlmacenProducto['almacenEntradaPorDefecto'],
                'almacenSalidaPorDefecto' => $opcionesAlmacenProducto['almacenSalidaPorDefecto']
            ];
        }else{
            $grupoCombinaciones = [];
            foreach ($combinaciones as $combinacion) {
                $key = $combinacion['id_product_attribute'];
                if (!isset($grupoCombinaciones[$key])) {
                    $grupoCombinaciones[$key] = [
                        'id_product_attribute' => $key,
                        'reference' => $combinacion['reference'],
                        'attributes' => []
                    ];
                }
        
                $grupoCombinaciones[$key]['attributes'][$combinacion['group_name']] = $combinacion['attribute_name'];
            }
            
            // Procesar las combinaciones agrupadas
            foreach ($grupoCombinaciones as $combinacion) {
                $opcionesAlmacen = $this->cargarOpcionAlmacen($idProducto, $combinacion['id_product_attribute']);
                $opcionesImprimirEtiqueta = $this->cargarImprimirEtiqueta($idProducto, $combinacion['id_product_attribute']);
                if(!$opcionesImprimirEtiqueta){
                    $opcionesImprimirEtiqueta = ['imprimirEtiqueta' => 0, 'imprimirUnaEtiqueta' => 0];
                }
                
                $infoAtributo = implode(' - ', $combinacion['attributes']);
                $lineas[$combinacion['id_product_attribute']] = [
                    'id' => $combinacion['id_product_attribute'],
                    'nombreAtributo' => $infoAtributo,
                    'referencia' => $combinacion['reference'],
                    'imprimirEtiqueta' => $opcionesImprimirEtiqueta['imprimirEtiqueta'],
                    'imprimirUnaEtiqueta' => $opcionesImprimirEtiqueta['imprimirUnaEtiqueta'],
                    'almacenEntradaPorDefecto' => $opcionesAlmacen['almacenEntradaPorDefecto'],
                    'almacenSalidaPorDefecto' => $opcionesAlmacen['almacenSalidaPorDefecto']
                ];
            }   
        }
        
        $almacenes = [];
        if(Module::isEnabled('imaxmultialmacen')){
            $almacenes = Warehouse::getWarehouses(true);
        }

        $this->smarty->assign(array('ubicacion' => $datosExtra,
            'nombreCampoNumSerie' => (isset($nombreCampoNumSerie) ? $nombreCampoNumSerie : $this->l('Numero de Serie')),
            'numSerie' => $actNumSerie,
            'activo' => $this->productoTieneNumerosSerie($idProducto),
            'origenUbicacion' => Configuration::getGlobalValue(self::prefijo . 'ORIGEN_UBI_PDA'),
            'combinaciones' => $combinaciones,
            'plantillasPorte' => $plantillasPorte,
            'lineas' => $lineas,
            'almacenes' => $almacenes 
        ));

        return $this->display('imaximprimepedidosservidor', 'views/admin/productTab.tpl');
    }
    
    public function hookActionValidateOrder($params) {
        //Guardamos la nueva forma de pago
        $formasPago = $this->obtenerFormasDePagoUsadas();
        $nuevo = array('nombre' => $params['order']->payment, 'nombreVisible' => $params['order']->payment);
        if(!in_array($nuevo, $formasPago)) {
            $formasPago[] = $nuevo;
            $this->almacenarFormasDePagoUsadas($formasPago);
        }
    }

    public function hookActionProductSave($params) {
        if (Tools::isSubmit('imaximprimepedidosservidor')) {
            $id_product = (int)Tools::getValue('id_product');
            $ubicaciones = Tools::getValue('ubicacion');
            $imprimirEtiqueta = Tools::getValue('imprimirEtiqueta', []);
            $almacenEntradaPorDefecto = Tools::getValue('almacenEntradaPorDefecto');
            $almacenSalidaPorDefecto = Tools::getValue('almacenSalidaPorDefecto');

            if(!$this->borrarImprimirEtiquetaProducto($id_product)){
                return false;
            }

            foreach($imprimirEtiqueta as $id_product_attribute => $valores){
                if(!$this->grabarImprimirEtiqueta($id_product, $id_product_attribute, isset($valores['todas']), isset($valores['una']))){
                    return false;
                }
            }
            
            foreach($almacenEntradaPorDefecto as $id_product_attribute => $entradaPorDefecto){
                if(!$this->grabarOpcionesAlmacen($id_product, $id_product_attribute, [], $entradaPorDefecto, $almacenSalidaPorDefecto[$id_product_attribute])){
                    return false;
                }
            }

            $this->eliminarExtraProducto($id_product);
            if (is_array($ubicaciones)) {
                foreach ($ubicaciones as $id_product_attribute => $ubicacion) {
                    $this->grabarExtraProducto($id_product, $ubicacion, $id_product_attribute);
                }
            }
            $this->productoGuardarNumerosSerie(Tools::getValue('id_producto_imax_serie'), (int) Tools::getValue('numSerie', 0));
        }
    }
    

    public function hookActionProductDelete($params) {
        Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . self::prefijo . "imagenPendiente` WHERE id_product = '" . $params['id_product'] . "'");
        Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . self::prefijo . "processed` WHERE id_product = '" . $params['id_product'] . "'");
        Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . self::prefijo . "w_pro` WHERE sku = '" . $params['product']->ean13 . "'");
    }

    /**
     * Crea un nuevo tab.
     * @param string $clase
     * @param string $nombre
     * @param string $padre
     * @return boolean
     */
    private function crearTab($clase, $nombre, $padre = '') {
        if (version_compare(_PS_VERSION_, '8.0.0', '>=')) {
            $tabRepository = $this->get('prestashop.core.admin.tab.repository');
            if (!$tabRepository->findOneIdByClassName($clase)) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = $clase;
                $tab->name = array();
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = $nombre;
                }
                if ($padre == '') {
                    $posicion = 0;
                } else {
                    $posicion = $tabRepository->findOneIdByClassName($padre);
                }
                $tab->id_parent = intval($posicion);
                $tab->module = $this->name;
                try {
                    if (!$tab->add()) {
                        return false;
                    }
                } catch (Exception $exc) {
                    return false;
                }
            }
        }else{
            if (!Tab::getIdFromClassName($clase)) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = $clase;
                $tab->name = array();
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = $nombre;
                }
                if ($padre == '') {
                    $posicion = 0;
                } else {
                    $posicion = Tab::getIdFromClassName($padre);
                }
                $tab->id_parent = intval($posicion);
                $tab->module = $this->name;
                try {
                    if (!$tab->add()) {
                        return false;
                    }
                } catch (Exception $exc) {
                    return false;
                }
            }
        }
        
        return true;
    }

    /**
     * Borra un tab.
     * @param string $clase
     * @return boolean
     */
    private function borrarTab($clase) {
        if (version_compare(_PS_VERSION_, '8.0.0', '>=')) {
            $tabRepository = $this->get('prestashop.core.admin.tab.repository');
            $id_tab = $tabRepository->findOneIdByClassName($clase);
        } else {
            $id_tab = (int) Tab::getIdFromClassName($clase);
        }
        
        if ($id_tab) {
            $tab = new Tab($id_tab);
            try {
                if (!$tab->delete()) {
                    return false;
                }
            } catch (Exception $exc) {
                return false;
            }
        }
    
        return true;
    }
    
    /**
     * Instala los tabs del módulo.
     * @return boolean
     */
    public function installTab() {
        include(dirname(__FILE__) . '/configuration.php');

        //Instalamos el root
        if (isset($moduleTabRoot) && $moduleTabRoot) {
            $this->crearTab($moduleTabRoot['clase'], $moduleTabRoot['name']);
        }

        //Instalamos el resto de tabs
        if (isset($moduleTabs) && $moduleTabs) {
            foreach ($moduleTabs AS $moduleTab) {
                $this->borrarTab($moduleTab['clase']);
                if (!$this->crearTab($moduleTab['clase'], $moduleTab['name'], $moduleTab['padre'])) {
                    return false;
                }
            }
        }

        return true;
    }

    /**
     * Desinstala los tabs del módulo.
     * @return boolean
     */
    public function uninstallTab() {
        include(dirname(__FILE__) . '/configuration.php');

        //Desinstalamos las tabs de este módulo
        if (isset($moduleTabs) && $moduleTabs) {
            foreach ($moduleTabs AS $moduleTab) {
                if (!$this->borrarTab($moduleTab['clase'])) {
                    return false;
                }
            }
        }

        //Desinstalamos el root si está vacío
        if (isset($moduleTabRoot) && $moduleTabRoot) {
            $id_tab = (int) Tab::getIdFromClassName($moduleTabRoot['clase']);
            if ($id_tab && Tab::getNbTabs($id_tab) == 0) {
                if (!$this->borrarTab($moduleTabRoot['clase'])) {
                    return false;
                }
            }
        }

        return true;
    }

    public function hookActionAdminStoresFormModifier($params) {

        $sql = 'SELECT tipo FROM ' . _DB_PREFIX_ . 'storestipo where id_store = ' . Tools::getValue('id_store');
        $result = Db::getInstance()->getValue($sql);
        $select = array(
            1 => array('id_tipoStore' => 1, 'nombre' => 'Distribuidor'),
            2 => array('id_tipoStore' => 2, 'nombre' => 'Punto de Venta')
        );

        $params['fields'][0]['form']['input'][] = array(
            'type' => 'select',
            'label' => $this->l('Tipo de Tienda'),
            'name' => 'tipoStore',
            'required' => true,
            'default_value' => 1,
            'options' => array(
                'query' => $select,
                'id' => 'id_tipoStore',
                'name' => 'nombre'
            )
        );

        $params['fields_value']['tipoStore'] = $result;
    }

    public function hookActionObjectStoreAddAfter($params) {
        $tipoStore = Tools::getValue('tipoStore');
        if ($tipoStore) {
            $idStore = $params['object']->id;
            if ($idStore) {
                $sql = 'INSERT IGNORE INTO  ' . _DB_PREFIX_ . 'storestipo (id_store, tipo) VALUES (' . $idStore . ',' . $tipoStore . ')';
                Db::getInstance()->execute($sql);
            }
        }
    }

    public function hookActionObjectStoreUpdateAfter($params) {
        $tipoStore = Tools::getValue('tipoStore');
        if ($tipoStore) {
            $idStore = $params['object']->id;
            if ($idStore) {
                $sql = 'UPDATE ' . _DB_PREFIX_ . 'storestipo SET tipo=' . $tipoStore . ' WHERE id_store=' . $idStore;
                Db::getInstance()->execute($sql);
            }
        }
    }
    
    public function hookActionOrderStatusPostUpdate($params) {
        $referenciasTransportista = $this->obtenerReferenciaTransportistas();
        $order = new Order($params['id_order']);
        $id_reference = (isset($referenciasTransportista[$order->id_carrier]) ? $referenciasTransportista[$order->id_carrier] : 0);
        $centralizador = new CentralizadorEtiquetas($this);
        $generador = $centralizador->obtenerGenerador($id_reference);
        
        if($params['newOrderStatus']->id == Configuration::get('PS_OS_SHIPPING')) {
            $inventar = '';
            if($generador instanceof GeneradorEtiquetaCorreoOrdinario && $generador->cargarConfiguracion()->inventarSeguimientoOrdinario) {
                $inventar = $generador->cargarConfiguracion()->inventarSeguimientoOrdinario;
                $nombreAuto = 'ordinario';
            }
            elseif($generador instanceof GeneradorEtiquetaCorreoCertificado && $generador->cargarConfiguracion()->inventarSeguimientoCertificado) {
                $inventar = $generador->cargarConfiguracion()->inventarSeguimientoCertificado;
                $nombreAuto = 'certificado';
            }
        
            if($inventar) {
                if(stripos($inventar, '[auto]') !== false) {
                    //Agregamos el autonumerico
                    $inventar = str_ireplace('[auto]', $this->autoIncremento($nombreAuto), $inventar);
                }
                
                $order_carrier = new OrderCarrier($order->getIdOrderCarrier());
                if (Validate::isLoadedObject($order_carrier) && !$order_carrier->tracking_number) {
                    $order_carrier->tracking_number = $inventar;
                    $order_carrier->update();
                }
            }
        }
        
        //Acciones para del modulo de innova deluxe tracking
        require_once __DIR__.'/clases/ConectorDeluxeTracking.php';
        require_once __DIR__.'/clases/IntermediarioDeluxeTracking.php';
        if(Configuration::getGlobalValue(self::prefijo . 'DELUXE_TRACKING') && Module::isEnabled('idxrtracking')) {
            if ($params['newOrderStatus']->id == Configuration::getGlobalValue('PS_OS_CANCELED') || 
                    $params['newOrderStatus']->id == Configuration::getGlobalValue('PS_OS_REFUND')) {
                //Devolvemos los lotes del pedido correspondiente
                $conector = new ConectorDeluxeTracking();
                $conector->marcarDisponible($params['id_order']);
            }
            elseif($params['newOrderStatus']->id == Configuration::getGlobalValue('PS_OS_SHIPPING') || 
                    $params['newOrderStatus']->id == Configuration::getGlobalValue('PS_OS_DELIVERED') || 
                    $params['newOrderStatus']->id == Configuration::get('innovacommerce_state')) {
                //Marcamos los lotes como vendidos
                $conector = new ConectorDeluxeTracking();
                $info = $conector->cargarInfoPedido($params['id_order']);
                if($info && !$info[0]['out_invoice'] && $order->invoice_number) {
                    //Si no tiene numero de factura tampoco tendra nota de factura agregada
                    $this->agregarNotaFactura($conector, $params['id_order'], $order->invoice_number);
                }

                $conector->marcarVendido($params['id_order'], $order->invoice_number);
            }
        }
    }
    
    /**
     * Agrega la nota de los lotes a la factura del pedido.
     * @param ConectorDeluxeTracking $conector
     * @param int $id_order
     * @param string $invoice_number
     */
    private function agregarNotaFactura($conector, $id_order, $invoice_number) {
        $lotes = [];
        $datos = $conector->cargarInfoPedido($id_order);
        foreach($datos as $dato) {
            if(!isset($lotes[$dato['out_lot'].'~'.$dato['id_product'].'~'.$dato['id_attribute']])) {
                $lotes[$dato['out_lot'].'~'.$dato['id_product'].'~'.$dato['id_attribute']] = ['cantidad' => 0, 'info' => $dato];
            }
            $lotes[$dato['out_lot'].'~'.$dato['id_product'].'~'.$dato['id_attribute']]['cantidad']++;
        }
        
        foreach($lotes as $lote) {
            $cantidad = $lote['cantidad'];
            $producto = pSQL($lote['info']['product_sold']);
            switch($lote['info']['id_certificate']) {
                case 1:
                    $certificado = Configuration::get('DELUXE_TRACKING_TEXT_UE', $this->idLang);
                    break;
                
                case 2:
                    $certificado = Configuration::get('DELUXE_TRACKING_TEXT_COSMOS', $this->idLang);
                    break;
                
                case 3:
                    $certificado = Configuration::get('DELUXE_TRACKING_TEXT_UE', $this->idLang);
                    $certificado .= " | " . Configuration::get('DELUXE_TRACKING_TEXT_COSMOS', $this->idLang);
                    break;
                
                default:
                    $certificado = '';
                    break;
            }

            if(!$this->validateDate($lote['info']['date_expiry'])) {
                $caducidad = '';
            }
            else {
                $caducidad = pSQL(date("d-m-Y", $lote['info']['date_expiry']));
            }
            $loteSalida = pSQL($lote['info']['out_lot']);
            
            Db::getInstance()->execute('UPDATE `' . _DB_PREFIX_ . 'order_invoice` SET `note` = CONCAT(note, "('.$cantidad.') - '. 
                     $producto.': '.$certificado.' Fecha de caducidad: '.$caducidad.', Lote de salida: '.$loteSalida.'\n")
                    WHERE `number` =  "'.pSQL($invoice_number).'"');
        }
    }
       
    /**
     * Valida una fecha.
     * @param string $date
     * @param string $format
     * @return boolean
     */
    private function validateDate($date, $format = 'Y-m-d H:i:s') {
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }

    public function procesar($producto) {
        $amazon_key = Configuration::getGlobalValue(self::prefijo . 'AMA_KEY');
        $amazon_secret = Configuration::getGlobalValue(self::prefijo . 'AMA_SEC');
        $amazon_associateId = Configuration::getGlobalValue(self::prefijo . 'AMA_AI');
        $amazon_country_id = Configuration::getGlobalValue(self::prefijo . 'AMA_CI');
        $preciooferta_id = Configuration::getGlobalValue(self::prefijo . 'TIP_PRE_PRO_AMA');

        $urlBuilder = new MarcL\AmazonUrlBuilder(
                $amazon_key, $amazon_secret, $amazon_associateId, $amazon_country_id
        );
        $idiomas = Language::getLanguages();
        // Setup a new instance of the AmazonAPI with your keys
        $amazonAPI = new MarcL\AmazonAPI($urlBuilder, 'xml');
        // Need to avoid triggering Amazon API throttling        
        $items = $amazonAPI->ItemSearch($producto->ean13);
        if ((string) $items->Items->TotalResults == 0) {
            return false;
        }


        $producto->name[$this->idLang] = mb_substr((string) $items->Items->Item->ItemAttributes->Title, 0, 127);
        $idManufacturer = Manufacturer::getIdByName((string) $items->Items->Item->ItemAttributes->Manufacturer);
        if (!$idManufacturer) {
            $fabricante = new Manufacturer();
            $nombre = (string) $items->Items->Item->ItemAttributes->Manufacturer;
            $fabricante->name = $this->cleanName(trim($nombre));
            foreach ($idiomas as $i) {
                $fabricante->description[$i['id_lang']] = trim($nombre);
            }

            $fabricante->active = 1;
            try {
                $fabricante->add();
                $idManufacturer = $fabricante->id;
            } catch (Exception $e) {
                p($items->Items->Item->ItemAttributes);
                p((string) $items->Items->Item->ItemAttributes->Brand);
                echo "Se ha producido un error al insertar el fabricante";
                echo "<pre>";
                print_r($e);
                echo "</pre>";
                d($fabricante);
                die();
            }
        }
        $producto->id_manufacturer = $idManufacturer;
        /* ALTO */
        $producto->height = (string) $items->Items->Item->ItemAttributes->PackageDimensions->Height / 100 * 2.54;
        /* LARGO */
        $producto->depth = (string) $items->Items->Item->ItemAttributes->PackageDimensions->Length / 100 * 2.54;
        /* PESO */
        $producto->weight = (string) $items->Items->Item->ItemAttributes->PackageDimensions->Weight / 100 * 0.453592;
        /* ANCHO */
        $producto->width = (string) $items->Items->Item->ItemAttributes->PackageDimensions->Width / 100 * 2.54;

        foreach ($items->Items->Item->ItemLinks->ItemLink as $links) {
            if ($links->Description == 'All Customer Reviews')
                $urlAllReviews = (string) $links->URL;
            if ($links->Description == 'All Offers')
                $urlOffers = (string) $links->URL;
        }



        /* TODO EL PRECIO VIENE CON IVA */

        $url = $items->Items->Item->DetailPageURL;
        $precio = (string) $items->Items->Item->ItemAttributes->ListPrice->Amount / 100;
        $precioOferta = (string) $items->Items->Item->OfferSummary->LowestNewPrice->Amount / 100;


        if ($preciooferta_id == 0)
            $producto->price = $precio;
        else {
            $producto->price = $precioOferta;
        }
        if (!$producto->price) {
            $producto->price = $precio;
        }
        $descFull = '';
        $fullBig = 0;

        foreach ($items->Items->Item->ItemAttributes->Feature as $desc) {
            if ((string) $desc) {
                $descFull .= (string) $desc;
            }
        }
        if ($descFull) {
            if (count_chars($descFull) < 800)
                $producto->description_short[$this->idLang] = $descFull;
            else {
                $fullBig = 1;
                $producto->description_short[$this->idLang] = mb_substr($descFull, 0, 799);
            }
        } else {
            $descFull = '';
        }



        if (isset($items->Items->Item->EditorialReviews->EditorialReview->Content)) {
            if ($fullBig)
                $producto->description[$this->idLang] = (string) $items->Items->Item->EditorialReviews->EditorialReview->Content;
            else
                $producto->description[$this->idLang] = (string) $items->Items->Item->EditorialReviews->EditorialReview->Content;
        }


        $this->insertarImagenes($producto->id, (string) $items->Items->Item->LargeImage->URL, 1);
        if ($items->Items->Item->ImageSets->ImageSet) {
            foreach ($items->Items->Item->ImageSets->ImageSet as $imagen) {
                $this->insertarImagenes($producto->id, (string) $imagen->LargeImage->URL, 0);
            }
        }

        $this->insertarVarios($producto, $precio, $precioOferta, $url, $urlAllReviews, $urlOffers);

        return $producto;
    }

    private function insertarVarios($producto, $precio, $precioOferta, $url, $urlAllReviews, $urlOffers) {
        if ($producto) {
            $sql = 'INSERT IGNORE `' . _DB_PREFIX_ . self::prefijo . 'processed` (sku,id_product,precio,precioOferta,url,urlAllReviews,urlOffers) '
                    . 'VALUES '
                    . '("' . $producto->ean13 . '","' . trim($producto->id) . '",'
                    . '"' . trim($precio) . '","' . trim($precioOferta) . '","' . trim($url) . '","' . trim($urlAllReviews) . '","' . trim($urlOffers)
                    . '")';
            Db::getInstance()->execute($sql);
        }
    }

    private function insertarImagenes($idProduct, $url, $esPrincipal = 0) {
        if ($idProduct) {
            $sql = 'INSERT IGNORE `' . _DB_PREFIX_ . self::prefijo . 'imagenPendiente` (id_product,urlImagen,hash, esPrincipal) VALUES (' . $idProduct . ',"' . trim($url) . '","' . md5(trim($url)) . '",' . $esPrincipal . ')';
            Db::getInstance()->execute($sql);
        }
    }
    
    /**
     * Genera el manifest de Seur para un dia y ccc.
     * @param int $fecha
     * @param int $id_store
     * @return string
     */
    public function generarManifestSeur($fecha, $id_store) {
        $fechaString = date('Y-m-d', $fecha);
        $cccsSeleccionados = unserialize(Configuration::getGlobalValue(self::prefijo.'CCC_LOCAL'));
        $ccc = (!empty($cccsSeleccionados[$id_store]) ? $cccsSeleccionados[$id_store] : 0);
        $idsSeur = Db::getInstance()->executeS('SELECT id_seur_order FROM `'._DB_PREFIX_."seur2_order` WHERE date(date_labeled) = '$fechaString' AND id_seur_ccc = '$ccc'");
        if($idsSeur) {
            $url = 'http://' . self::getDomain() . '/modules/imaximprimepedidosservidor/imaximprimepedidosservidor_remoto.php?accion=generarManifiestoSeur&passRemota='.Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS');
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array('ids_seur_order' => array_column($idsSeur, 'id_seur_order'))));
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
            curl_setopt($ch, CURLOPT_TIMEOUT, 360);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            $datos = curl_exec($ch);
            $infoCurl = curl_getinfo($ch);

            $numIntentos = 0;
            while (($infoCurl['http_code'] == 301 || $infoCurl['http_code'] == 302) && $numIntentos < 10) {
                curl_setopt($ch, CURLOPT_URL, $infoCurl['redirect_url']);
                $datos = curl_exec($ch);
                $infoCurl = curl_getinfo($ch);

                $numIntentos++;
            }

            curl_close($ch);		
        }
        else {
            $infoCurl = array();
            $infoCurl['http_code'] = 0;
        }

        return ($infoCurl['http_code'] == 200 ? $datos : false);
    }
    
    /**
     * Procesa las imagenes pendientes.
     * @param int $idProduct
     * @return int La cantidad de imagenes procesada correctamente.
     */
    public function procesarImagenes($idProduct = NULL) {
        $cantidad = 0;
        if ($this->comprobarProceso('I')) {
            $numImagenes = Configuration::get(self::prefijo . 'CANTIDAD_IMAGENES');
            if (!$numImagenes) {
                $numImagenes = 5;
            }
            $sqlFilter = '';
            if ($idProduct) {
                $sqlFilter = ' AND id_product = ' . $idProduct . ' ';
                $numImagenes = 50;
            }

            $datos = Db::getInstance()->executeS("select * from `" . _DB_PREFIX_ . self::prefijo . "imagenPendiente` WHERE procesado = 0 AND numIntentos < 3 " . $sqlFilter . "  ORDER BY id_product ASC limit 0," . $numImagenes, true, false);

            if (count($datos)) {
                foreach ($datos as $dato) {
                    $producto = new Product($dato['id_product']);
                    if (Validate::isLoadedObject($producto)) {
                        try {
                            $cover = $dato['esPrincipal'];
                            if (Image::getCover($dato['id_product'])) {
                                $cover = 0;
                            }
                            $legend = $producto->name[$this->idLang];
                            $imagen = new Image();
                            $imagen->id_product = $dato['id_product'];
                            $imagen->position = 0;
                            $imagen->cover = $cover;
                            $imagen->legend = $legend;
                            $url = $dato['urlImagen'];
                            if ($imagen->add()) {
                                if (!self::copyImagen($imagen->id_product, $imagen->id, $url)) {
                                    $imagen->delete();
                                    db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . self::prefijo . "imagenPendiente` SET numIntentos = numIntentos + 1 where id = '{$dato['id']}'");
                                } else {
                                    $imagen->associateTo($producto->id_shop_default);
                                    db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . self::prefijo . "imagenPendiente` SET procesado = 1, id_imagen='{$imagen->id}' where id = '{$dato['id']}'");
                                    $cantidad++;
                                }
                            } else {
                                db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . self::prefijo . "imagenPendiente` SET numIntentos = numIntentos + 1 where id = '{$dato['id']}'");
                            }
                        } catch (Exception $ex) {
                            db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . self::prefijo . "imagenPendiente` SET numIntentos = numIntentos + 1 where id = '{$dato['id']}'");
                        }
                    } else {
                        db::getInstance()->execute("DELETE FROM `" . _DB_PREFIX_ . self::prefijo . "imagenPendiente` WHERE id_product = '{$dato['id_product']}'");
                    }

                    $producto = null;
                    unset($producto);
                }
                $respuesta = $this->l('Se han procesado') . $cantidad . $this->l('imagenes');
            } else {
                $respuesta = $this->l('No existen imagenes para procesar');
            }
            $this->terminarProceso('I');
        } else {
            $respuesta = $this->l('Proceso solapado');
        }

        return $respuesta;
    }

    /**
     * Copia las imagenes en su localizacion.
     * @param int $id_entity
     * @param int $id_image
     * @param string $url
     * @param string $entity
     * @param string $user
     * @param string $password
     * @return boolean
     */
    public static function copyImagen($id_entity, $id_image, $url, $entity = self::ENTITY_PRODUCTO, $user = '', $password = '') {
        if (strpos($url, 'http:') === false && strpos($url, 'https:') === false) {
            return true;
        }

        if (!ini_get("safe_mode")) {
            if (function_exists('set_time_limit')) {
                @set_time_limit(0);
            }
            if ((int) substr(ini_get("memory_limit"), 0, -1) < 512) {
                ini_set("memory_limit", "512M");
            }
        } else {
            if (function_exists('set_time_limit')) {
                @set_time_limit(0);
            }
        }

        $tmpfile = tempnam(_PS_TMP_IMG_DIR_, 'ps_import');
        $watermark_types = explode(',', Configuration::get('WATERMARK_TYPES'));
        switch ($entity) {
            default:
            case self::ENTITY_PRODUCTO:
                $image_obj = new Image($id_image);
                $path = $image_obj->getPathForCreation();
                break;
            case self::ENTITY_CATEGORIA:
                $path = _PS_CAT_IMG_DIR_ . (int) $id_entity;
                break;
            case self::ENTITY_FABRICANTE:
                $path = _PS_MANU_IMG_DIR_ . (int) $id_entity;
                break;
            case self::ENTITY_PROVEEDOR:
                $path = _PS_SUPP_IMG_DIR_ . (int) $id_entity;
                break;
        }
        $url_source_file = str_replace(' ', '%20', trim($url));
        $ch = curl_init($url_source_file);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_BINARYTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        if ($user) {
            curl_setopt($ch, CURLOPT_USERPWD, "$user:$password");
        }
        $datos = curl_exec($ch);
        $infoCurl = curl_getinfo($ch);
        curl_close($ch);

        $numIntentos = 0;
        while (($infoCurl['http_code'] == 301 || $infoCurl['http_code'] == 302) && $numIntentos < 10) {
            $ch = curl_init($infoCurl['redirect_url']);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_BINARYTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            if ($user) {
                curl_setopt($ch, CURLOPT_USERPWD, "$user:$password");
            }
            $datos = curl_exec($ch);
            $infoCurl = curl_getinfo($ch);
            curl_close($ch);
            $numIntentos++;
        }

        if ($infoCurl['http_code'] == 200 && $numIntentos <= 10) {
            if (file_put_contents($tmpfile, $datos) !== false) {
                if (!ImageManager::isRealImage($tmpfile)) {
                    @unlink($tmpfile);
                    return false;
                }

                ImageManager::resize($tmpfile, $path . '.jpg');
                $imagesTypes = ImageType::getImagesTypes($entity);
                foreach ($imagesTypes AS $imageType) {
                    if (($error = ImageManager::resize($tmpfile, $path . '-' . stripslashes($imageType['name']) . '.jpg', $imageType['width'], $imageType['height'])) == false) {
                        
                    }
                }

                if (in_array($imageType['id_image_type'], $watermark_types)) {
                    Hook::exec('actionWatermark', array('id_image' => $id_image, 'id_product' => $id_entity));
                }
            } else {
                @unlink($tmpfile);
                return false;
            }
            @unlink($tmpfile);
            return true;
        } else {
            if ($numIntentos > 10) {
                $msg = 'Error al obtener la imagen: la pagina no redirecciona correctamente';
            } else {
                $msg = 'Error al obtener la imagen: error en el servidor -> ' . $infoCurl['http_code'];
            }
            @unlink($tmpfile);
            return false;
        }
    }

    /**
     * Comprueba si hay solapamiento.
     * @param string $prefijoModulo El prefijo que utiliza el modulo.
     * @param string $sufijoTipo Un sufijo para crear distintos solapamientos.
     * @return boolean
     */
    public function comprobarProceso($sufijoTipo = 'P') {
        return true;
        $modoSolapado = Configuration::getGlobalValue(self::prefijo . 'MODO_SOLAPADO');
        if ($modoSolapado) {
            return true;
        }

        $procesoActivo = Configuration::getGlobalValue(self::prefijo . 'PROCESO_ACTIVO_' . $sufijoTipo);
        if ($procesoActivo == 1) {
            $fechaUltimoProceso = Configuration::getGlobalValue(self::prefijo . 'ULTIMO_PROCESO_' . $sufijoTipo);
            if ($fechaUltimoProceso == '') {
                $fechaUltimoProceso = date('U', 1);
                Configuration::updateGlobalValue(self::prefijo . 'ULTIMO_PROCESO_' . $sufijoTipo, $fechaUltimoProceso);
            }
            $fechaActual = date('U');
            $fechaUltimoProcesoModificada = $fechaUltimoProceso + 20 * 60;
            if ($fechaActual > $fechaUltimoProcesoModificada) {
                Configuration::updateGlobalValue(self::prefijo . 'PROCESO_ACTIVO_' . $sufijoTipo, 0);
            }

            return false;
        } else {
            Configuration::updateGlobalValue(self::prefijo . 'PROCESO_ACTIVO_' . $sufijoTipo, 1);
            Configuration::updateGlobalValue(self::prefijo . 'ULTIMO_PROCESO_' . $sufijoTipo, date('U'));

            return true;
        }
    }

    /**
     * Marca la ejecucion como finalizada.
     * @param string $prefijo
     */
    public static function terminarProceso($sufijo = 'P') {
        if ($sufijo == 'P') {
            Configuration::updateGlobalValue(self::prefijo . 'PROCESO_ACTIVO_P', 0);
        } else {
            Configuration::updateGlobalValue(self::prefijo . 'PROCESO_ACTIVO_I', 0);
        }
    }

    public function createHelpHeader() {
        $html = '<div class="module-preheader">';
        $html .= $this->getDatosPubli('header');
        $html .= '</div>';

        $html .= '<div class="module-header">';
        $html .= '<div class="module-title-container">';
        $html .= '<h2 class="module-title">' . $this->displayName . '<small> by Informax</small></h2>';
        $html .= '<h3 class="module-version">' . $this->l('Version: ') . $this->version . '</h3>';
        $html .= '</div>';

        $html .= '<div class="module-toolbar">';
        $html .= '<ul class="module-nav" >';

        $html .= '<li>';
        $html .= '<a target="_blank" href="http://www.informax.es">';
        $html .= '<img src="../modules/' . $this->name . '/img/informax.png">';
        $html .= '<div>' . $this->l('Informax') . '</div>';
        $html .= '</a>';
        $html .= '</li>';

        $html .= '<li>';
        $html .= '<a target="_blank" href="http://tickets.informax.es/open.php?topicId=10">';
        $html .= '<img src="../modules/' . $this->name . '/img/abrir-ticket.png">';
        $html .= '<div>' . $this->l('Asistencia') . '</div>';
        $html .= '</a>';
        $html .= '</li>';

        $html .= '<li>';
        $html .= '<a target="_blank" href="http://docs.informax.es/?p=' . $this->idManual . '">';
        $html .= '<img src="../modules/' . $this->name . '/img/ir-a-manuales.png">';
        $html .= '<div>' . $this->l('Manuales') . '</div>';
        $html .= '</a>';
        $html .= '</li>';

        $html .= '</ul>';
        $html .= '</div>';
        $html .= '</div>';
        return $html;
    }

    public function getModuleFooter() {
        $url = Configuration::getGlobalValue(self::prefijo . 'URL_FALDON');
        $html = '<div class="module-newsletter">';
        $html .= '<form action="http://www.informax.es/subscribe/" method="post" target="_blank">
                    <input type="hidden" name="accion" value="newsletter">
                    <input type="hidden" name="idTab" value="1" />';
        $html .= '<p>' . $this->l('Si deseas enterarte de todos los cambios en nuestros modulos, nuevos Modulos, como funciona Prestashop, apuntate a nuestras news') . '</p>';
        $html .= ' <p>';
        $html .= ' <label>' . $this->l('email') . '</label>';
        $html .= '<input type="text" name="email" value="" />';
        $html .= '<input type="submit" name="subscribe" value="' . $this->l('Guardar') . '" />';
        $html .= '</p>';
        $html .= '</form><br />';
        $html .= '</div>';
        $html .= '<div class="module-footer">';
        $html .= '<div class="module-footer-left">';
        $html .= $this->getDatosPubli('footera');
        $html .= '</div>';
        $html .= '<div class="module-footer-right">';
        $html .= $this->getDatosPubli('footerb');
        $html .= '</div>';
        $html .= '</div>';
        return $html;
    }

    public function getDatosPubli($tipo) {
        $datosCompletos = Configuration::getGlobalValue(self::prefijo . 'TXT_FILE');

        $html = '';
        if ($datosCompletos) {
            $aperturaA = '';
            $cierreA = '';
            $datosCompletos = @unserialize($datosCompletos);
            if (!is_array($datosCompletos)) {
                return '';
            }
            shuffle($datosCompletos);
            foreach ($datosCompletos AS $datoElemento) {
                if ($datoElemento[1] == $tipo) {
                    if (trim($datoElemento[2]) != '') {
                        $aperturaA .= '<a href="' . $datoElemento[2] . '" target="_blank">';
                        $cierreA = '</a>';
                    }
                    if (trim($datoElemento[0]) != '') {
                        $html = $aperturaA . '<img src="' . Configuration::getGlobalValue(self::prefijo . 'URL_TXT') . '/img/' . $datoElemento[0] . '" />' . $cierreA;
                    }
                    return $html;
                }
            }
        }
        return $html;
    }

    public function getTxtFiles() {
        if (Configuration::getGlobalValue(self::prefijo . 'DESCARGA_ARCHIVO') < 10000) {
            Configuration::updateGlobalValue(self::prefijo . 'DESCARGA_ARCHIVO', Configuration::getGlobalValue(self::prefijo . 'DESCARGA_ARCHIVO') + 1);
            return false;
        }
        $url = Configuration::getGlobalValue(self::prefijo . 'URL_TXT') . '/' . Configuration::getGlobalValue(self::prefijo . 'TIPO') . '.txt';
        $basedir_active = ini_get('open_basedir');
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_BINARYTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 360);
        if (!$basedir_active) {
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
        }
        $datos = curl_exec($ch);
        $infoCurl = curl_getinfo($ch);
        if (!isset($infoCurl['http_code']) || $infoCurl['http_code'] != 200) {

            return false;
        }
        Configuration::updateGlobalValue(self::prefijo . 'DESCARGA_ARCHIVO', 0);
        return Configuration::updateGlobalValue(self::prefijo . 'TXT_FILE', $this->readCsv($datos));
    }

    private function readCsv($string) {
        $string = trim($string);
        $temp = explode("\n", $string);
        $respuesta = array();
        foreach ($temp AS $elemento) {
            $elementoInterno = array();
            $elementoInterno = explode(";", $elemento);
            $respuesta[] = $elementoInterno;
        }
        return serialize($respuesta);
    }

    function l($msg, $modulo = '', $locale = null) {
        if ($modulo == '') {
            $modulo = 'traducciones' . strtolower($this->name);
        }
        return parent::l($msg, $modulo);
    }

    function addCSS($css) {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            $this->context->controller->addCss($this->_path . 'css/' . $css, 'all');
        }
        return;
    }

    function addJS($js) {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            $this->context->controller->addJs($this->_path . 'js/' . $js);
        }
        return;
    }

    function addJqueryUI($plugin) {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            if ($this->context->controller instanceof stdClass) {
                $this->context->controller = new AdminModulesController();
            }
            $this->context->controller->addJqueryUI($plugin);
        }
        return;
    }

    public function tiendas() {
        $tiendas = Configuration::getGlobalValue($this->sufijo . 'TIENDAS');
        if ($tiendas != '' && strpos($tiendas, ':') !== FALSE && strpos($tiendas, '{') !== FALSE) {
            $tiendas = unserialize($tiendas);
            if (isset($tiendas['default'])) {
                if (isset($tiendas[$tiendas['default']]['idShop'])) {
                    $this->idShop = $tiendas[$tiendas['default']]['idShop'];
                }
            }
        }
    }

    public function datosProduct($idProducto) {
        if ($idProducto) {
            $sql = 'SELECT '
                    . ' * '
                    . ' FROM `'
                    . _DB_PREFIX_ . self::prefijo . "processed`"
                    . ' WHERE id_product=' . $idProducto;


            return Db::getInstance()->getRow($sql);
        }
        
        return false;
    }

    /**
     * Sincroniza el stock.
     * @return string Mensajes de error de cron solapado. 
     */
    public function sincronizar() {
        /* $this->comprobarProceso() */
        if (1 == 1) {
            $sleepTime = 1.5;
            $error = '';
            $resultado = $this->getProductosPendientes();
            if (!$resultado) {
                $this->terminarProceso();
                return $this->l('Todos los productos han sido procesados');
            }

            foreach ($resultado as $p) {
                if ($p['sku']) {
                    $arrayproducto = $this->buscarEan($p['sku']);
                    $producto = new Product($arrayproducto['id_product']);
                    if ($producto->ean13) {
                        $producto = $this->procesar($producto);
                    }
                    if ($producto) {
                        $producto->update();
                    }
                }
                $this->deletePendiente($p['sku']);
                sleep($sleepTime);
            }
            $this->terminarProceso();
            return $this->l('Proceso Finalizado correctamente - Ultimo producto procesado:') . $p['id_product'];
        } else {
            return $this->l('Proceso activo');
        }
    }

    public static function buscarEan($reference) {
        $reference = pSQL($reference); // Asegurándonos de que la referencia está correctamente escapada.
    
        // Primero, buscaremos en la tabla product_attribute.
        $sql = 'SELECT id_product, id_product_attribute
                FROM ' . _DB_PREFIX_ . 'product_attribute
                WHERE ean13 = "' . $reference . '"';
        $resultCombinaciones = Db::getInstance()->getRow($sql);
        if ($resultCombinaciones) {
            return $resultCombinaciones;
        }
    
        // Luego, buscaremos en la tabla product.
        $sql = 'SELECT id_product, 0 AS id_product_attribute
                FROM ' . _DB_PREFIX_ . 'product
                WHERE ean13 = "' . $reference . '"';
        $resultProductos = Db::getInstance()->getRow($sql);
    
        if ($resultProductos) {
        return $resultProductos;
    }

        // Finalmente, si el módulo imaxmultiean está instalado y habilitado, buscaremos en la tabla multiean.
        if (Module::isEnabled('imaxmultiean')) {
            $module = Module::getInstanceByName('imaxmultiean');
            $sql = 'SELECT id_product, id_product_attribute
                    FROM ' . _DB_PREFIX_ . $module->prefijo . 'multiean
                    WHERE ean13 = "' . $reference . '"';
            $resultMultiean = Db::getInstance()->getRow($sql);
            if ($resultMultiean) {
                return $resultMultiean;
            }
        }
    
        // Si no se encuentra ningún resultado, devolver null o un valor predeterminado adecuado.
        return null;
    }
    

    public static function buscarReferencia($reference = false, $ean = false) {
        if ($reference !== false) {
            $campo = 'reference';
            $valor = pSQL(trim($reference));
        } else {
            $campo = 'ean13';
            $valor = pSQL(trim($ean));
        }
        
        $resultado = array();
        if ($valor) {
            // Buscando en la tabla product_attribute.
            $sql = 'SELECT id_product, id_product_attribute
                    FROM ' . _DB_PREFIX_ . 'product_attribute
                    WHERE ' . $campo . ' = "' . $valor . '"';
            $resultado = Db::getInstance()->getRow($sql);
            if (!$resultado) {
                // Buscando en la tabla product.
                $sql = 'SELECT id_product, 0 AS id_product_attribute
                        FROM ' . _DB_PREFIX_ . 'product
                        WHERE ' . $campo . ' = "' . $valor . '"';
                $resultado = Db::getInstance()->getRow($sql);
            }
    
            // Si no se encuentra resultado, y el campo es ean13, y el módulo imaxmultiean está instalado y habilitado, buscar en la tabla multiean.
            if (!$resultado && $campo === 'ean13' && Module::isEnabled('imaxmultiean')) {
                $module = Module::getInstanceByName('imaxmultiean');
                $sql = 'SELECT id_product, id_product_attribute
                        FROM ' . _DB_PREFIX_ . $module->prefijo . 'multiean
                        WHERE ean13 = "' . $valor . '"';
                $resultado = Db::getInstance()->getRow($sql);
            }
        }
        
        return $resultado;
    }

    public static function deletePendiente($ean) {
        $sql = 'DELETE FROM ' . _DB_PREFIX_ . self::prefijo . 'w_pro  WHERE sku = ' . $ean;
        return Db::getInstance()->execute($sql);
    }

    public static function getProductosPendientes() {
        $limitProductos = Configuration::getGlobalValue(self::prefijo . 'PRO_AMA');
        if ($limitProductos) {
            $limit = 'LIMIT ' . $limitProductos;
        } else {
            $limit = 'LIMIT 5';
        }
        $sql = 'SELECT * '
                . ' FROM ' . _DB_PREFIX_ . self::prefijo . 'w_pro ' . $limit;
        return Db::getInstance()->executeS($sql);
    }

    public static function crearProducto($productoCrear, $idLang, $categoria = FALSE, $fast = FALSE, $stock = 0) {
        $crear = Configuration::getGlobalValue(self::prefijo . 'CREAR');
        if (!$categoria) {
            $categoria = Configuration::getGlobalValue(self::prefijo . 'CATEGORIAS');
        }
        $nom_producto = Configuration::getGlobalValue(self::prefijo . 'NOM_PRO_DEFECTO');
        $pre_producto = Configuration::getGlobalValue(self::prefijo . 'PRECIO_PRO_DEFECTO');
        $cos_producto = Configuration::getGlobalValue(self::prefijo . 'COSTE_PRO_DEFECTO');
        $sto_producto = Configuration::getGlobalValue(self::prefijo . 'STOCK_PRO_DEFECTO');
        $proveedor_producto = Configuration::getGlobalValue(self::prefijo . 'SUPPLI_PRODUCTO');
        $impuesto_producto = Configuration::getGlobalValue(self::prefijo . 'IMP_PRODUCTO');
        if ($fast) {
            $producto = new Product();
            $producto->name[$idLang] = $nom_producto;
            $producto->active = 0;
            $producto->id_category_default = $categoria;
            $categoria = array($categoria);
            $producto->wholesale_price = $cos_producto;
            $producto->price = $pre_producto;
            $producto->link_rewrite[$idLang] = Tools::link_rewrite(self::cleanName($nom_producto));
            $producto->ean13 = $productoCrear;
            $producto->reference = $productoCrear;
            $producto->id_supplier = $proveedor_producto;
            $producto->id_tax_rules_group = $impuesto_producto;
        } else {
            $producto = new Product();
            $producto->name[$idLang] = $productoCrear['nombre'] ? $productoCrear['nombre'] : $nom_producto;
            $producto->active = 0;
            if ($productoCrear['cats']) {
                $producto->id_category_default = reset($productoCrear['cats']);
                $categoria = $productoCrear['cats'];
            } else {
                $producto->id_category_default = $categoria;
                $categoria = array($categoria);
            }
            $producto->wholesale_price = $productoCrear['coste'] ? $productoCrear['coste'] : $cos_producto;
            $producto->price = $productoCrear['precio'] ? $productoCrear['precio'] : $pre_producto;
            $producto->reference = $productoCrear['referencia'];
            if (isset($productoCrear['peso'])) {
                $producto->weight = $productoCrear['peso'];
            }
            if (isset($productoCrear['ean'])) {
                $producto->ean13 = $productoCrear['ean'];
            }
            $producto->link_rewrite[$idLang] = $productoCrear['nombre'] ? Tools::link_rewrite(self::cleanName($productoCrear['nombre'])) : Tools::link_rewrite(self::cleanName($nom_producto));
            $producto->id_supplier = $productoCrear['id_proveedor'] ? $productoCrear['id_proveedor'] : $proveedor_producto;
            $producto->id_tax_rules_group = $productoCrear['id_impuesto'] ? $productoCrear['id_impuesto'] : $impuesto_producto;
            $stock = $productoCrear['stock'];
        }
        
        try {
            if ($producto->add()) {
                if ($producto->id_supplier) {
                    $product_supplier = new ProductSupplier();
                    $product_supplier->id_product = $producto->id;
                    $product_supplier->id_product_attribute = 0;
                    $product_supplier->id_supplier = $producto->id_supplier;
                    $product_supplier->product_supplier_reference = $producto->reference;
                    $product_supplier->save();
                }

                $idproducto = $producto->id;
                StockAvailable::SetQuantity((int) $idproducto, 0, $stock);
                $crearAmazon = Configuration::getGlobalValue(self::prefijo . 'CREAR_AMA');
                if ($crearAmazon) {
                    if ($producto->ean13) {
                        $sql = 'INSERT INTO ' . _DB_PREFIX_ . self::prefijo . 'w_pro (sku)  VALUES ("' . $producto->ean13 . '")';
                        Db::getInstance()->execute($sql);
                    }
                }
                $producto->addToCategories($categoria);

                return $idproducto;
            } else {
                return FALSE;
            }
        }
        catch(Exception $ex) { 
            return false;
        }
    }

    public static function cleanName($name) {
        if (function_exists('mb_strtolower')) {
            $name = mb_strtolower($name, 'utf-8');
        }
        $name = trim($name);

        if (!function_exists('mb_strtolower')) {
            $name = Tools::replaceAccentedChars($name);
        }
        $name = str_replace('<', ' menor de ', $name);
        $name = str_replace('>', ' mayor de ', $name);
        $name = preg_replace('/[^a-zA-Z0-9\s\'\:\/\[\]\-\pL]/u', '', $name);
        $name = preg_replace('/[\s\'\:\/\[\]\-]+/', ' ', $name);
        $name = str_replace(array(' ', '/'), ' ', $name);
        return $name;
    }

    /**
     * Devuelve el tipo de archivo.
     * @param string $rutaArchivo
     * @return int
     */
    public static function detectarTipoArchivo($rutaArchivo) {
        $resultado = false;

        $ext = explode(',', $rutaArchivo);
        $ext = end($ext);
        $mime = mime_content_type($rutaArchivo);
        if ($mime == 'text/plain') {
            $resultado = self::ARCHIVO_CSV;
        } elseif ($mime == 'application/vnd.ms-excel' || $mime == 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet') {
            $resultado = self::ARCHIVO_EXCEL;
        } elseif ($ext == 'csv') {
            $resultado = self::ARCHIVO_CSV;
        } elseif ($ext == 'xls' || $ext == 'xlsx') {
            $resultado = self::ARCHIVO_EXCEL;
        }

        return $resultado;
    }
    
    /**
     * Exporta los ubicaciones de los productos.
     */
    public function exportarUbicaciones() {
        $filas = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.self::prefijo.'extraProducto` where ubicacion <> "" ');
        $filasFormateadas = array();
        foreach ($filas as $fila) {
            $idProducto = $fila['id_product'];
            $id_product_attribute = $fila['id_product_attribute'];
            if ($id_product_attribute == 0) {
                $p = new Product($idProducto);
                $referencia = $p->reference;
                $id_product_attribute = '';
            }
            else {
                $c = new Combination($id_product_attribute);
                $referencia = $c->reference;
            }
            $ubicacion = $fila['ubicacion'];
            $filasFormateadas[] = array($idProducto, $id_product_attribute, $referencia, $ubicacion);
        }

        $this->exportarCsv(array('ID producto', 'Id Atributo', 'Referencia', 'ubicacion'), $filasFormateadas, 'ubicaciones.csv');
    }
    
    /**
     * Reserva un lote.
     * @param string $lote
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $cantidad
     * @param int $id_order
     * @param boolean $ignorarAnteriores
     * @return array
     */
    public function reservarLote($lote, $id_product, $id_product_attribute, $cantidad, $id_order, $ignorarAnteriores) {
        require_once __DIR__.'/clases/ConectorDeluxeTracking.php';
        require_once __DIR__.'/clases/IntermediarioDeluxeTracking.php';
        
        $conector = new ConectorDeluxeTracking();
        $resultado = $conector->reservarLote($lote, $id_product, $id_product_attribute, $cantidad, $id_order, $ignorarAnteriores);
        $emailTemp = Configuration::getGlobalValue(self::prefijo . 'EMAIL_AVISOS_PDA');
        if($resultado[0] == ConectorDeluxeTracking::RESERVA_NO_LOCALIZADO && $emailTemp) {
            //Enviamos el aviso de producto sobrante
            $pedido = new Order($id_order);
            $variables = [
                '{pedido}' => $pedido->id.' - '.$pedido->reference, 
                '{unidades}' => ($resultado[1] ? $resultado[1][0] : $cantidad), 
                '{codigoEscaneado}' => $lote,
                '{nombreProducto}' => Product::getProductName($id_product, $id_product_attribute)
            ];
            foreach(explode(',', $emailTemp) as $email) {
                Mail::Send((int) $this->idLang, 'sobrante', Mail::l('Producto sobrante', (int) $this->idLang), $variables, 
                        trim($email), Configuration::get(self::prefijo . 'PS_SHOP_NAME'), 
                        null, null, null, null, __DIR__.'/mails/', false, (int) $pedido->id_shop);
            }
        }
        return $resultado;
    }
    
    /**
     * Cambia el stock de un producto según el tipo de gestión actual.
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $qty_diff
     */
    private function modificarStock($id_product, $id_product_attribute, $qty_diff) {
        if ($qty_diff != 0) {
            $product = new Product($id_product);
            if (Configuration::get('PS_STOCK_MANAGEMENT')) {
                //Gestión avanzada
                if ($product->advanced_stock_management) {
                    $warehouses = Warehouse::getWarehousesByProductId($id_product, $id_product_attribute);
                    foreach ($warehouses as $warehouse) {
                        $warehouseStock = new Warehouse($warehouse['id_warehouse']);
                        break;
                    }

                    $stockmanager = StockManagerFactory::getManager();
                    if ((int) $id_product_attribute) {
                        $combination = new Combination((int) $id_product_attribute);
                        $price = $combination->wholesale_price;
                    } 
                    else {
                        $price = $product->wholesale_price;
                    }

                    if ($qty_diff > 0) {
                        $stockmanager->addProduct($id_product, (int) $id_product_attribute, $warehouseStock, $qty_diff, 'tracking', $price);

                        StockAvailable::synchronize($id_product);
                    } else {
                        $new_qty_diff = $qty_diff * -1;
                        $stockmanager->removeProduct($id_product, (int) $id_product_attribute, $warehouseStock, $new_qty_diff, 'tracking', true);

                        StockAvailable::synchronize($id_product);
                    }
                } else {
                    //Gestión normal de stock
                    StockAvailable::updateQuantity($id_product, $id_product_attribute, $qty_diff);
                }
            }

            Hook::exec('actionProductUpdate', array('id_product' => (int) $id_product, 'product' => $product));
        }
    }
    
    /**
     * Marca un lote como merma.
     * @param string $lote
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $cantidad
     * @param int $id_order
     * @return boolean
     */
    public function marcarMerma($lote, $id_product, $id_product_attribute, $cantidad, $id_order = 0) {
        require_once __DIR__.'/clases/ConectorDeluxeTracking.php';
        require_once __DIR__.'/clases/IntermediarioDeluxeTracking.php';
        
        $conector = new ConectorDeluxeTracking();
        $resultado = $conector->marcarMerma($lote, $id_product, $id_product_attribute, $cantidad);
        if($resultado) {
            //Restamos el stock
            $this->modificarStock($id_product, $id_product_attribute, -count($resultado));

            $emailTemp = Configuration::getGlobalValue(self::prefijo . 'EMAIL_AVISOS_PDA');
            if($emailTemp) {
                //Enviamos un email de aviso de merma
                $pedido = new Order($id_order);
                $idsLineasLotes = [];
                foreach($resultado as $r) {
                    $idsLineasLotes[] = $r['id_tracking'];
                }
                $variables = [
                    '{pedido}' => $pedido->id.' - '.$pedido->reference, 
                    '{idsLineasLotes}' => implode(', ', $idsLineasLotes), 
                    '{codigoEscaneadoMerma}' => $lote,
                    '{nombreProducto}' => Product::getProductName($id_product, $id_product_attribute)
                ];
                foreach(explode(',', $emailTemp) as $email) {
                    Mail::Send((int) $this->idLang, 'merma', Mail::l('Lotes marcados como merma', (int) $this->idLang), $variables, 
                            trim($email), Configuration::get(self::prefijo . 'PS_SHOP_NAME'), 
                            null, null, null, null, __DIR__.'/mails/', false, (int) $pedido->id_shop);
                }
            }
        }
        
        return (boolean)$resultado;
    }
    
    /**
     * Marca como disponible un lote.
     * @param string $lote
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $cantidad
     * @param int $id_order
     * @return boolean
     */
    public function marcarDisponiblePorLote($lote, $id_product, $id_product_attribute, $cantidad, $id_order) {
        require_once __DIR__.'/clases/ConectorDeluxeTracking.php';
        require_once __DIR__.'/clases/IntermediarioDeluxeTracking.php';
        
        $conector = new ConectorDeluxeTracking();
        return (boolean)$conector->marcarDisponiblePorLote($lote, $id_product, $id_product_attribute, $cantidad, $id_order);
    }
    /**
     * Elimina la fila indicada dejando constancia en la tabla "filaPedidoEliminada".
     * @param int $id_order_detail
     * @return boolean
     */
    public function eliminarFilaPedido($id_order_detail) {
        $resultado = false;
        
        $orderDetail = new OrderDetail($id_order_detail);
        $eliminadores = unserialize(Configuration::getGlobalValue(self::prefijo.'EMPLEADOS_PUEDEN_ELIMINAR'));
        if($eliminadores && in_array($this->context->employee->id, $eliminadores) && Validate::isLoadedObject($orderDetail)) {
            $id_employee = (!empty($this->context->employee->id) ? (int)$this->context->employee->id : 0);
            $orderDetailString = pSQL(serialize(get_object_vars($orderDetail)));
            if(Db::getInstance()->execute('REPLACE INTO `'._DB_PREFIX_.self::prefijo."filaPedidoEliminada` (id_order, id_order_detail, id_employee, fila) 
                    VALUES ('$orderDetail->id_order', '$orderDetail->id', '$id_employee', '$orderDetailString')")) {
                $resultado = $orderDetail->delete();
                if($resultado) {
                    //Recalculamos los totales
                    $order = new Order($orderDetail->id_order);
                    $order->total_paid = $this->minimoCero($order->total_paid, $orderDetail->total_price_tax_incl);
                    $order->total_paid_real = $this->minimoCero($order->total_paid_real, $orderDetail->total_price_tax_incl);
                    $order->total_paid_tax_excl = $this->minimoCero($order->total_paid_tax_excl, $orderDetail->total_price_tax_excl);
                    $order->total_paid_tax_incl = $this->minimoCero($order->total_paid_tax_incl, $orderDetail->total_price_tax_incl);
                    $order->total_products = $this->minimoCero($order->total_products, $orderDetail->total_price_tax_excl);
                    $order->total_products_wt = $this->minimoCero($order->total_products_wt, $orderDetail->total_price_tax_incl);
                    $order->update();
                    //Impuestos
                    $order->updateOrderDetailTax();
                    //Pago
                    $payments = $order->getOrderPayments();
                    if($payments) {
                        $payments[0]->amount = $this->minimoCero($payments[0]->amount, $orderDetail->total_price_tax_incl);
                        $payments[0]->update();
                    }
                    //Factura
                    $facturas = $order->getInvoicesCollection();
                    if($facturas) {
                        $facturas[0]->total_paid_tax_excl = $order->total_paid_tax_excl;
                        $facturas[0]->total_paid_tax_incl = $order->total_paid_tax_incl;
                        $facturas[0]->total_products = $order->total_products;
                        $facturas[0]->total_products_wt = $order->total_products_wt;
                        $facturas[0]->update();
                    }
                }
            }
        }
        
        return $resultado;
    }
    
    /**
     * Le resta operando2 a operando1 y devuelve como minimo cero.
     * @param float $operando1
     * @param float $operando2
     * @return float
     */
    private function minimoCero($operando1, $operando2) {
        if($operando2 >= $operando1) {
            $resultado = 0;
        }
        else {
            $resultado = $operando1 - $operando2;
        }
        
        return $resultado;
    }
    
    /**
     * Devuelve las filas eliminadas del pedido.
     * @param int $id_order
     * @return array
     */
    private function cargarFilasPedidoEliminadas($id_order) {
        $id_order = (int)$id_order;
        $filas = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.self::prefijo."filaPedidoEliminada` WHERE id_order = '$id_order'");
        foreach($filas as &$fila) {
            $fila['fila'] = unserialize($fila['fila']);
        }
        
        return $filas;
    }
    
    /**
     * Devuelve los nombres de los cierres del dia de hoy.
     * @param string $user
     * @return string[]
     */
    public function listarCierresDhl($user = false) {
        $cierres = [];
        if(Module::isEnabled('imaxdhlparcelv3')) {
            $dhl = Module::getInstanceByName('imaxdhlparcelv3');
            $cierres = $dhl->getFunciones()->listarCierresDia(date('Y-m-d'), $user);
        }

        if($cierres && $cierres != array_values($cierres)) {
            //No los queremos agrupados pero lo están
            $cierresTemp = [];
            foreach($cierres as $cierre) {
                $cierresTemp = array_merge($cierresTemp, array_values($cierre));
            }
            $cierres = $cierresTemp;
        }

        return $cierres;
    }
    
    /**
     * Devuelve los usuarios de DHL.
     * @return string[]
     */
    public function obtenerUsuariosDhl() {
        $credenciales = [];
        if(Module::isEnabled('imaxdhlparcelv3')) {
            $dhl = Module::getInstanceByName('imaxdhlparcelv3');
            $credenciales = $dhl->getFunciones()->obtenerCredenciales();
        }
        
        return array_column($credenciales, 'id_usuario');
    }
    
    /**
     * Devuelve el cierre del dia solicitado.
     * @param string $ruta [user]/anho/mes/dia/horas_minutos.pdf, si se deja en blanco genera uno nuevo y lo devuelve.
     * @param string $user 
     * @return string
     */
    public function obtenerCierreDhl($ruta = '', $user = false) {
        $cierre = false;
        if(Module::isEnabled('imaxdhlparcelv3')) {
            $dhl = Module::getInstanceByName('imaxdhlparcelv3');

            if($user) {
                //Imprime nuevo
                if(!$ruta) {
                    $resultado = $dhl->getFunciones()->generarCierreDia($user);
                    if($resultado[0]) {
                        $ruta = $resultado[2];
                    }
                }
            }
            else {
                //Imprime antiguo
                if(!$ruta) {
                    $usuarios = $dhl->getFunciones()->obtenerCredenciales();
                    foreach($usuarios as $usuario) {
                        $resultado = $dhl->getFunciones()->generarCierreDia($usuario['id_usuario']);
                        if($resultado[0] && !$ruta) {
                            $ruta = $resultado[2];
                        }
                    }
                }
            }

            $cierre = $dhl->getFunciones()->obtenerCierreDia($ruta);
        }
        
        return $cierre;
    }
    
    /**
     * Deja un pedido pendiente de terminar.
     * @param int $id_order
     * @param int $id_employee
     * @return boolean
     */
    public function pedidoSinTerminar($id_order, $id_employee) {
        $estadoSinTerminar = (int)Configuration::getGlobalValue(self::prefijo.'ESTADO_SIN_TERMINAR_PDA');
        if($estadoSinTerminar) {
            $this->cambiarEstado(new Order($id_order), $estadoSinTerminar);
        }
        
        return Db::getInstance()->execute('INSERT IGNORE `'._DB_PREFIX_.self::prefijo."pedidoPendiente` (id_order, id_employee) 
            VALUES ('$id_order', '$id_employee')");
    }
    
    /**
     * Devuelve los estados de pedido y la cantidad de pedidos que tienen.
     * @param int $id_employee
     * @return array
     */
    public function cargarEstadosPedido($id_employee) {
        return Db::getInstance()->executeS('
            SELECT COUNT(po.id_order) as total, pos.id_order_state as id_order_state, posl.name as name FROM `' . _DB_PREFIX_ . 'order_state` as pos 
                LEFT JOIN `' . _DB_PREFIX_ . 'orders` AS po ON pos.id_order_state = po.current_state 
                INNER JOIN `' . _DB_PREFIX_ . 'order_state_lang` AS posl ON posl.id_order_state = pos.id_order_state AND posl.id_lang = '.$this->idLang.' 
                INNER JOIN `' . _DB_PREFIX_ . self::prefijo . 'estadoMontable` AS em ON posl.id_order_state = em.idEstadoPedido AND posl.id_lang = '.$this->idLang.' AND em.id_employee = '.(int)$id_employee.' 
            GROUP BY pos.id_order_state');
    }
    
    /**
     * Devuelve el último error al generar una etiqueta.
     * Que devuelva algo no es indicativo de que exista error.
     * @return string
     */
    public function getErrorEtiqueta() {
        return $this->errorEtiqueta;
    }
    
    /**
     * Saca por pantalla un resumen de las filas eliminadas y reemplazadas entre las dos fechas opcionales.
     * @param string $fechaInicio
     * @param string $fechaFin
     */
    public function exportarCambiadasEliminadasPda($fechaInicio = '', $fechaFin = '') {
        $reemplazos = $this->obtenerLineasCambiadas($fechaInicio, $fechaFin);
        $eliminadas = $this->obtenerLineasEliminadas($fechaInicio, $fechaFin);
        //Reemplazamos algunos valores y agrupamos por pedido.
        $filas = [];
        $filasTemp = array_merge($reemplazos, $eliminadas);
        foreach($filasTemp as $fila) {
            $empleado = new Employee($fila['id_employee']);
            if($fila['id_product_reemplazo']) {
                $reemplazo = trim(Product::getProductName($fila['id_product_reemplazo'], $fila['id_product_attribute_reemplazo']));
            }
            else {
                $reemplazo = $this->l('Eliminada');
            }
            
            $temp = [];
            $temp[] = $fila['fecha'];
            $temp[] = $empleado->firstname.' '.$empleado->lastname;
            $temp[] = $fila['id_order'];
            $temp[] = $fila['reference'];
            $temp[] = trim(Product::getProductName($fila['id_product'], $fila['id_product_attribute']));
            $temp[] = $reemplazo;
            $filas[$fila['id_order'].'.'.$fila['id_order_detail']] = $temp;
        }
        sort($filas, SORT_NUMERIC);
 
        $this->exportarCsv(array('Fecha', 'Empleado', 'ID pedido', 'Referencia pedido', 'Producto', 'Reemplazo'), $filas, 'modificacionesPda.csv');
    }
    
    /**
     * Devuelve las filas eliminadas entre las dos fechas opcionales.
     * @param string $fechaInicio
     * @param string $fechaFin
     * @return array
     */
    private function obtenerLineasEliminadas($fechaInicio = '', $fechaFin = '') {
        $where = '';
        if($fechaInicio) {
            $fechaInicio = pSQL($fechaInicio);
            $where .= " AND fpe.fecha >= '$fechaInicio 00:00:00'";
        }
        if($fechaFin) {
            $fechaFin = pSQL($fechaFin);
            $where .= " AND fpe.fecha <= '$fechaFin 23:59:59'";
        }

        $filas = Db::getInstance()->executeS('
            SELECT fpe.fecha, fpe.id_employee, o.id_order, o.reference, 0 id_product, 0 id_product_attribute, 0 id_product_reemplazo, 
                0 id_product_attribute_reemplazo, fpe.id_order_detail, fpe.fila FROM `'._DB_PREFIX_.self::prefijo.'filaPedidoEliminada` fpe 
                INNER JOIN `'._DB_PREFIX_."orders` o ON fpe.id_order = o.id_order
            WHERE 1 $where");
        foreach($filas as &$fila) {
            $fila['fila'] = unserialize($fila['fila']);
            $fila['id_product'] = $fila['fila']['product_id'];
            $fila['id_product_attribute'] = $fila['fila']['product_attribute_id'];
        }
        
        return $filas;
    }
    
    /**
     * Devuelve los reemplazos entre las dos fechas opcionales.
     * @param string $fechaInicio
     * @param string $fechaFin
     * @return array
     */
    private function obtenerLineasCambiadas($fechaInicio = '', $fechaFin = '') {
        $where = '';
        if($fechaInicio) {
            $fechaInicio = pSQL($fechaInicio);
            $where .= " AND pp.fechaFin >= '$fechaInicio 00:00:00'";
        }
        if($fechaFin) {
            $fechaFin = pSQL($fechaFin);
            $where .= " AND pp.fechaFin <= '$fechaFin 23:59:59'";
        }
        return Db::getInstance()->executeS('
            SELECT pp.fechaFin fecha, pp.idEmpleado id_employee, o.id_order, o.reference, ode.id_product, ode.id_product_attribute, 
                ode.id_product_reemplazo, ode.id_product_attribute_reemplazo, ode.id_order_detail, "" fila FROM `'._DB_PREFIX_.self::prefijo.'orderDetailExtra` ode 
                INNER JOIN `'._DB_PREFIX_.'orders` o ON ode.id_order = o.id_order
                INNER JOIN `'._DB_PREFIX_.self::prefijo."procesadoPedido` pp ON ode.id_order = pp.idPedido
            WHERE 1 $where");
    }

    /**
     * Inserta en la tabla si una etiqueta se ha impreso para un determinado producto para un pedido
     * @param int $idPedido
     * @param int $idProducto    
     * @param int $idCombinacion 
     * @param int $idEmpleado
     */
    public function setEtiquetaProductoImpresa($idPedido, $idProducto, $idCombinacion, $idEmpleado){
        $idPedido = (int)$idPedido; 
        $idProducto = (int)$idProducto; 
        $idCombinacion = (int)$idCombinacion;
        $idEmpleado = (int)$idEmpleado;
        $sql = "REPLACE INTO `"._DB_PREFIX_.self::prefijo."etiquetaProductoImpresa` (`id_order`, `id_product`, `id_product_attribute`, `id_employee`)
                VALUES ($idPedido, $idProducto, $idCombinacion, $idEmpleado)";
        Db::getInstance()->execute($sql);    
    }

    /**
     * Devuelve si una etiqueta se ha impreso para un determinado producto para un pedido
     * @param int $idPedido
     * @param int $idProducto    
     * @param int $idCombinacion
     * @return bool 
     */
    public function getEtiquetaProductoImpresa($idPedido, $idProducto, $idCombinacion){
        $idPedido = (int)$idPedido; 
        $idProducto = (int)$idProducto; 
        $idCombinacion = (int)$idCombinacion;
        $sql = "SELECT * FROM `"._DB_PREFIX_.self::prefijo."etiquetaProductoImpresa` 
                WHERE `id_order` = $idPedido
                AND  `id_product` = $idProducto
                AND `id_product_attribute` = $idCombinacion";
        return  (bool)Db::getInstance()->executeS($sql);
    }

    /**
     * Genera el csv con los artículo de pegatinas
     * @return bool
     */
    public function generarArchivoArticulosPegatinas(){
        $articulosPegatinas = $this->cargarImprimirEtiquetaProducto();
        foreach ($articulosPegatinas as $articuloPegatina) {
            $clave = $articuloPegatina["id_product"] . "_" . $articuloPegatina["id_product_attribute"];
            // Asignar el elemento al nuevo array con la clave compuesta
            $nuevoArray[$clave] = $articuloPegatina;
        }
        $articulosPegatinas = $nuevoArray;
        $productos = Product::getProducts($this->idLang, 0, 0,'id_product', 'ASC');
        // Nombre del archivo CSV
        $nombreArchivo = __DIR__ . '/sampleFiles/articulosConPegatinas.csv';
    
        // Abrir el archivo para escritura
        $archivo = fopen($nombreArchivo, 'w');
    
        // Escribir la cabecera del archivo CSV
        fputcsv($archivo, ["Id Producto", "Id Combinación", "Referencia", "Nombre", "Pegatina", "Una pegatina"], ';');
        foreach($productos as $producto){
            $idProducto = $producto['id_product'];
            $productoTemp = new Product($idProducto, false, $this->idLang);
            $nombreProducto = $productoTemp->name;
            $combinaciones = $productoTemp->getAttributeCombinations($this->idLang);
            if (!empty($combinaciones)) {
                $combinacionesUnicas = [];

                foreach ($combinaciones as $combinacion) {
                    $clave = $combinacion["id_product_attribute"] . "_" . $combinacion["id_product"];
                    if (!isset($combinacionesUnicas[$clave])) {
                        $combinacionesUnicas[$clave] = $combinacion;
                    }
                }

                $combinaciones = array_values($combinacionesUnicas);
                foreach($combinaciones as $combinacion){
                    $idCombinacion = $combinacion['id_product_attribute'];
                    $combinacion = new Combination($idCombinacion);
                    $referencia = $combinacion->reference;
                    $imprimirEtiqueta = 0;
                    $imprimirUnaEtiqueta = 0;
                    if(isset($articulosPegatinas[$idProducto . '_' . $idCombinacion])){
                        $imprimirEtiqueta = $articulosPegatinas[$idProducto . '_' . $idCombinacion]['imprimirEtiqueta'];
                        $imprimirUnaEtiqueta = $articulosPegatinas[$idProducto . '_' . $idCombinacion]['imprimirUnaEtiqueta'];
                    }
                    fputcsv($archivo, [$idProducto, $idCombinacion, $referencia, $nombreProducto, $imprimirEtiqueta, $imprimirUnaEtiqueta], ';');
                }
            }else{
                $idCombinacion = 0;
                $referencia = $productoTemp->reference;
                $imprimirEtiqueta = 0;
                $imprimirUnaEtiqueta = 0;
                if(isset($articulosPegatinas[$idProducto . '_0'])){
                    $imprimirEtiqueta = $articulosPegatinas[$idProducto . '_' . $idCombinacion]['imprimirEtiqueta'];
                    $imprimirUnaEtiqueta = $articulosPegatinas[$idProducto . '_' . $idCombinacion]['imprimirUnaEtiqueta'];
                }
                fputcsv($archivo, [$idProducto, $idCombinacion, $referencia, $nombreProducto, $imprimirEtiqueta, $imprimirUnaEtiqueta], ';'); 
            }
        }    
        // Cerrar el archivo
        fclose($archivo);
        return true;
    }
    
    /**
     * Carga el id_product a partir de la referencia
     * @param mixed $reference
     * @return string|false|null
     */
    private function getProductIdByReference($reference) {
        $sql = 'SELECT id_product FROM ' . _DB_PREFIX_ . 'product WHERE reference = "' . pSQL($reference) . '"';
        return Db::getInstance()->getValue($sql);
    }

    /**
     * Carga el id_product_attribute a partir de la referencia
     * @param mixed $reference
     * @return string|false|null
     */
    private function getProductAttributeIdByReference($reference) {
        $sql = 'SELECT id_product_attribute FROM ' . _DB_PREFIX_ . 'product_attribute WHERE reference = "' . pSQL($reference) . '"';
        return Db::getInstance()->getValue($sql);
    }
    
    /**
     * Vacía la tabla de pedidos pedientes
     * @return bool
     */
    public function vaciarTablaPedidosPedientes(){
        $sql = 'TRUNCATE TABLE ' . _DB_PREFIX_ . self::prefijo. 'pedidoPendiente';
        return Db::getInstance()->execute($sql);
    }

    /**
     * Carga las opciones de los almacenes por producto o combinación
     * @param int $idProduct
     * @param int $idProductAttribute
     * @return array
     */
    public static function cargarOpcionAlmacen($idProduct, $idProductAttribute = 0){
        $idProduct = (int) $idProduct;
        $idProductAttribute = (int) $idProductAttribute;
        $sql = "SELECT * FROM `". _DB_PREFIX_ . self::prefijo . "opcionAlmacenProducto` WHERE `id_product` = $idProduct AND `id_product_attribute` = $idProductAttribute";
        $opciones = Db::getInstance()->getRow($sql);
        if($opciones) {
            $opciones['almacenesMostrar'] = unserialize($opciones['almacenesMostrar']);
        }
        else {
            $opciones['almacenEntradaPorDefecto'] = false;
            $opciones['almacenSalidaPorDefecto'] = false;
            $opciones['almacenesMostrar'] = [];
        }
        
        return $opciones;
    }

    
    /**
     * Graba el almacén por defecto
     * @param int $id_product
     * @param int $id_product_attribute
     * @param array $almacenesMostrar
     * @param int $id_warehouse
     * @return bool
     */
    private function grabarOpcionesAlmacen($id_product, $id_product_attribute = 0, $almacenesMostrar = [], $id_entry_warehouse = 0, $id_output_warehouse = 0){
        $id_product = (int) $id_product;
        $id_product_attribute = (int) $id_product_attribute;
        $almacenesMostrar =  pSQL(serialize($almacenesMostrar), true);
        $id_entry_warehouse = (int) $id_entry_warehouse;
        $id_output_warehouse = (int) $id_output_warehouse;
        $sql = "Replace INTO `". _DB_PREFIX_ . $this->sufijo . "opcionAlmacenProducto` (`id_product`, `id_product_attribute`, `almacenesMostrar`, `almacenEntradaPorDefecto`, `almacenSalidaPorDefecto`)
        VALUES ($id_product, $id_product_attribute, '$almacenesMostrar', '$id_entry_warehouse', '$id_output_warehouse');";
        return Db::getInstance()->execute($sql);
    }

    /**
     * Devuelve la cantidad física de un producto
     * @param mixed $id_product
     * @param mixed $id_product_attribute
     * @return array
     */
    public function getStock($id_product, $id_product_attribute = null, $id_warehouse = null) {
        if($id_warehouse){
            $idStock = StockAvailable::getWarehouseStockAvailableIdByProductId($id_product, $id_product_attribute, $id_warehouse);
            $stock = new Stock($idStock);
            $resultado = ['quantity' => $stock->usable_quantity, 'physical_quantity' => $stock->physical_quantity];
        }else{
            $db = Db::getInstance();
            $id_product_attribute_condition = $id_product_attribute ? ' AND id_product_attribute = ' . (int)$id_product_attribute : ' AND id_product_attribute = 0';
            $sql = 'SELECT quantity, physical_quantity FROM ' . _DB_PREFIX_ . 'stock_available WHERE id_product = ' . (int)$id_product . $id_product_attribute_condition;
            $resultado = $db->getRow($sql);
        }
        return $resultado;
    }
}   
