<?php
use PrestaShop\PrestaShop\Adapter\StockManager;
use PrestaShop\PrestaShop\Adapter\SymfonyContainer;
require_once(dirname(__FILE__) . '/../../imaximprimepedidosservidor.php');

class AdminImaxImprimePedidosOrderController extends AdminController {

    public $name, $id_lang, $_path, $images, $url, $success, $html, $idTab, $error, $warning, $info, $modulo;
    const prefijo = 'imaximppedser_';

    public function __construct() {
        //Inicializamos el kernel
        if(version_compare(_PS_VERSION_, '1.7.0.0 ', '>=')) {
            if(!class_exists('AppKernel')) {
                require_once __DIR__.'/../../../../app/AppKernel.php';
            }
        
            global $kernel;
            $kernel = new AppKernel(_PS_MODE_DEV_ ? 'dev' : 'prod', _PS_MODE_DEV_ ? true : false);
            $kernel->boot();
            Context::getContext()->container = SymfonyContainer::getInstance();
        }
        $this->name = 'imaximprimepedidosservidor';
        $this->path = _PS_MODULE_DIR_ . $this->name . '/';

        $this->display = 'edit';
        $this->id_lang = (int) Context::getContext()->language->id;
        $this->name = 'imaximprimepedidosservidor';
        $this->lang = true;
        $this->deleted = false;
        $this->colorOnBackground = true;
        $this->_path = Tools::safeOutput($_SERVER['REQUEST_URI']);

        $this->url = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name . '/';
        $this->images = $this->url . 'images/';

        $this->context = Context::getContext();
        $this->success = array();
        $this->html = '';
        $this->modulo = Module::getInstanceByName($this->name);

        parent::__construct();
        $this->bootstrap = false;
        $contextData = new Context;
        $contextData->shop = $this->context->shop;
        $contextData->employee = $this->context->employee;
        $contextData->currency = $this->context->currency;
    }

    public function renderForm() {
        $this->context->controller->addJS(dirname($this->_path).'/../modules/imaximprimepedidosservidor/js/printelement.js');
        $this->context->controller->addJS(dirname($this->_path).'/../modules/imaximprimepedidosservidor/pdaEntrada/js/funcionesPrincipal.js');
        $this->context->controller->addCSS(dirname($this->_path).'/../modules/imaximprimepedidosservidor/pdaEntrada/css/principal.css');
        
        $idTab = (int) Tools::getValue('id_tab');
        if (!isset($idTab) || $idTab == 0)
            $idTab = 1;
        $this->html .= '	   
                <ul id="menuTab">
                    <li id="menuTab1" class="menuTabButton' . (($idTab == 1) ? " selected" : "" ) . '">1. ' . $this->l('Configuracion') . '</li>			
                   <!-- <li id="menuTab2" class="menuTabButton' . (($idTab == 2) ? " selected" : "" ) . '">2. ' . $this->l('Licencia') . '</li> -->
                </ul>
                <div id="tabList' . $this->name . '">
                    <div id="menuTab1Sheet" class="tabItem' . (($idTab == 1) ? " selected" : "" ) . '">' . $this->_activarAcceso() . '</div>
                  <!--  <div id="menuTab2Sheet" class="tabItem' . (($idTab == 2) ? " selected" : "" ) . '">' . $this->_yaveremos() . '</div> -->
                </div>
                <br clear="left" />
                <br />
                <style>
                    html { font-size: 16px;}
                    #menuTab { float: left; padding: 0; margin: 0; text-align: left; }
                    #menuTab li { text-align: left; float: left; display: inline; padding: 5px; padding-right: 10px; background: #EFEFEF; font-weight: bold; cursor: pointer; border-left: 1px solid #EFEFEF; border-right: 1px solid #EFEFEF; border-top: 1px solid #EFEFEF; }
                    #menuTab li.menuTabButton.selected { background: #FFF6D3; border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-top: 1px solid #CCCCCC; }
                    #tabList' . $this->name . ' { clear: left;, width:100% }
                    .tabItem { display: none; }
                    .tabItem.selected { display: block; background: #FFFFF0; border: 1px solid #CCCCCC; padding: 10px; padding-top: 20px; }
                    #menuTab1Sheet > .form-group { float: none; }
                    .nobootstrap #menuTab1Sheet .form-group > div { float: inherit; }
                    #paginaListado fieldset { margin-top: 20px; }
                    #paginaListado fieldset legend { margin-bottom: 10px; }
                    #paginaListado table { width: 100%; }
                    #paginaListado th:first-child { display: none;}
                    // #paginaListado td:first-child { display: none;}
                </style>
                <script>
                    $(".menuTabButton").click(function() {
                        $(".menuTabButton.selected").removeClass("selected");
                        $(this).addClass("selected");
                        $(".tabItem.selected").removeClass("selected");
                        $("#" + this.id + "Sheet").addClass("selected");
                    });
                    
                    var botonSumarPDA = 0, botonRestarPDA = 0, mensaje_incompletas = "'.$this->l('incompletas').'", mostrarRefProduct = 0, 
                        mensaje_excedidas = "'.$this->l('excedidas').'", 
                        mensaje_finalizadas = "'.$this->l('finalizadas').'";
                </script>';

        return $this->html . $this->content . parent::renderForm();
    }

    public function postProcess() {
        $notificaciones = $this->prepareNotifications();
        if(!empty($notificaciones['success'])){
            foreach($notificaciones['success'] as $success){
                $this->html .= $this->displayConfirmation($success);
            }
        }
        if(!empty($notificaciones['error'])){
            foreach($notificaciones['error'] as $error){
                $this->html .= $this->displayError($error);
            }
        }
        $accion = Tools::getValue('action');
        $this->idTab = Tools::getValue("idTab");
        switch ($accion) {
            case 'importacion':
                $referencia = Tools::getValue('referencia');
                if ($referencia) {
                    $categoria = Configuration::getGlobalValue(self::prefijo . 'CATEGORIAS');
                    if ($categoria) {
                        ini_set('auto_detect_line_endings', 1);
                        
                        $error = false;
                        
                        $file_import = dirname(__FILE__) . '/../../import/' . $_FILES['file']['name'] . '.' . date('Ymdhis') . '.csv';
                        if (move_uploaded_file($_FILES['file']['tmp_name'], $file_import)) {
                            require_once dirname(__FILE__).'/../../clases/accesoDatos/iAccesoDatos.php';
                            switch (ImaxImprimePedidosServidor::detectarTipoArchivo($file_import)) {
                                case ImaxImprimePedidosServidor::ARCHIVO_CSV:
                                    require_once dirname(__FILE__).'/../../clases/accesoDatos/AccesoDatosCSV.php';
                                    $acceso = new clases\accesoDatos\AccesoDatosCSV($file_import, 0, 1, ';');
                                    break;
                                
                                case ImaxImprimePedidosServidor::ARCHIVO_EXCEL:
                                    require_once dirname(__FILE__).'/../../clases/accesoDatos/AccesoDatosExcel.php';
                                    require_once dirname(__FILE__).'/../../clases/accesoDatos/ChunkReadFilter.php';
                                    $acceso = new clases\accesoDatos\AccesoDatosExcel($file_import, 0, 32768, 1);
                                    break;
                                
                                default:
                                    require_once dirname(__FILE__).'/../../clases/accesoDatos/AccesoDatosCSV.php';
                                    $acceso = new clases\accesoDatos\AccesoDatosCSV($file_import, 0, 1, ';');
                                    break;
                            }

                            $stocks = array();
                            $refFabrica = array();
                            $eanProductos = array();
                            $referenciaProductos = array();
                            $productosean = array();
                            while (($data = $acceso->obtenerFila()) !== FALSE) {
                                if(Configuration::getGlobalValue(self::prefijo . 'CREAR')) {
                                    //Ean
                                    $ean = trim($data[2]);
                                    $referenciaProducto = false;
                                }
                                else {
                                    //Referencia
                                    $ean = false;
                                    $referenciaProducto = trim($data[3]);
                                }
                                
                                $productosean['productoPrestashop'] = ImaxImprimePedidosServidor::buscarReferencia($referenciaProducto, $ean);
                                $productosean['referencia'] = $data[3];
                                $productosean['stock'] = $data[5];
                                if($productosean['productoPrestashop']){
                                    $idProducto = $productosean['productoPrestashop']['id_product'];
                                    $idCombinacion = $productosean['productoPrestashop']['id_product_attribute'];
                                }else if(Configuration::getGlobalValue(self::prefijo . 'CREAR_PRODUCTOS')){
                                    $productosean['nombre'] = $data[1];
                                    $productosean['coste'] = $data[6];
                                    $productosean['precio'] = $data[7];
                                    $productosean['peso'] = (!empty($data[8]) ? $data[8] : 0);
                                    $productosean['ean'] = $data[2];
                                    $productosean['id_proveedor'] = $data[0];
                                    $productosean['id_impuesto'] = (!empty($data[9]) ? $data[9] : 0);
                                    if(!trim($data[4])){
                                        $productosean['cats'] = '';
                                    }else{
                                        $productosean['cats'] = explode(',', $data[4]);
                                    }
                                    $idProducto = ImaxImprimePedidosServidor::crearProducto($productosean, $this->id_lang, $categoria);
                                    $idCombinacion = 0;
                                }else{
                                    continue;
                                }
                                
                                if($idProducto) {
                                    $stocks[$idProducto][$idCombinacion] = $productosean['stock'];
                                    $refFabrica[$idProducto][$idCombinacion] = trim($data[10]);
                                    $eanProductos[$idProducto][$idCombinacion] = trim($data[2]);
                                    $referenciaProductos[$idProducto][$idCombinacion] = trim($data[3]);
                                }
                                else {
                                    $error = true;
                                }
                            }
                            unlink($file_import);
                        }
                        else {
                            $error = true;
                        }

                        if(!$error) {
                            if($this->crearPedidoEan($referencia, Tools::getValue('date_from'), $stocks, $refFabrica, $eanProductos, $referenciaProductos)) {
                                $this->html .= $this->displayConfirmation($this->l('Pedido generado correctamente'));
                                $this->success[] = $this->l('Pedido generado correctamente');
                            }
                            else {
                                $this->html .= $this->displayError($this->l('Error al crear la compra.'));
                                $this->errors[] = $this->l('Error al crear la compra.'); 
                            }
                        }
                        else {
                            $this->html .= $this->displayError($this->l('Error en los productos.'));
                            $this->errors[] = $this->l('Error en los productos.');
                        }
                    } else {
                        $this->html .= $this->displayError($this->l('Tiene que seleccionar categoria por defecto'));
                        $this->errors[] = $this->l('Tiene que seleccionar categoria por defecto');
                    }
                } else {
                    $this->html .= $this->displayError($this->l('No ha puesto referencia es imprescindible'));
                    $this->errors[] = $this->l('No ha puesto referencia es imprescindible');
                }
                $this->redirectWithNotifications($this->context->link->getAdminLink('AdminImaxImprimePedidosOrder'));
                break;
            case 'configuracion':
                if (Configuration::updateGlobalValue(self::prefijo . 'CATEGORIAS', (int) Tools::getValue('categorias')) &&
                        Configuration::updateGlobalValue(self::prefijo . 'CREAR', (int) Tools::getValue('crear'))
                )
                    $this->html .= $this->displayConfirmation($this->l('Configuracion guardada correctamente.'));
                else
                    $this->html .= $this->displayError($this->l('Ha ocurrido un error al guardar la configuracion'));

                break;
          
        } 
    }
    
    /**
     * Inserta en base de datos una compra nueva.
     * @param string $referenciaPedido
     * @param string $fechaEntrada
     * @param int $stocks [id_product => stock]
     * @param array $refFabrica
     */
    private function crearPedidoEan($referenciaPedido, $fechaEntrada, $stocks, $refFabrica, $eanProductos, $referenciaProductos) {
        $resultado = true;
        
        $referenciaPedido = pSQL(trim($referenciaPedido));
        $temp = explode('/', trim($fechaEntrada));
        $fechaEntrada = $temp[2].'-'.$temp[1].'-'.$temp[0];
        
        try {
            if(Db::getInstance()->execute('INSERT INTO `'._DB_PREFIX_.self::prefijo."altaCompras` (referencia, fechaEntrada) VALUES ('$referenciaPedido', '$fechaEntrada')")) {
                $idCompra = Db::getInstance()->Insert_ID();
                foreach($stocks as $idProducto => $stockTemp) {
                    foreach($stockTemp as $idCombinacion => $stock) {
                        $refFrabricaProducto = $refFabrica[$idProducto][$idCombinacion];
                        $eanProducto = $eanProductos[$idProducto][$idCombinacion];
                        $referenciaProducto = $referenciaProductos[$idProducto][$idCombinacion];
                        if(!Db::getInstance()->execute('INSERT INTO `'._DB_PREFIX_.self::prefijo."altaComprasDetalle` (idAlta, id_product, id_product_attribute, stock, stockRecibido, ref_fabrica, ean, referencia) VALUES ('$idCompra', '$idProducto', '$idCombinacion', '$stock', '0', '$refFrabricaProducto', '$eanProducto', '$referenciaProducto')")) {
                            $resultado = false;
                        }
                    }
                }
            }
            else {
                $resultado = false;
            }
        }
        catch(Exception $ex) { 
            $resultado = false;
        }
        
        return $resultado;
    }
    
    /**
     * Elimina de base de datos una compra nueva.
     * @param int $idAlta
     * @return boolean
     */
    public function eliminarPedidoEan($idAlta) {
        $idAlta = (int)$idAlta;
        
        return Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.self::prefijo."altaCompras` WHERE id = '$idAlta'") &&
                Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.self::prefijo."altaComprasDetalle` WHERE idAlta = '$idAlta'") &&
                Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.self::prefijo."mensajeAltaCompra` WHERE idAltaCompra = '$idAlta'");
    }

    public function _activarAcceso() {
        include_once($this->path . 'functionsForm.php');
        include_once($this->path . 'imaxAcordeon.php');
        $html = '';

        $acordeon = new imaxAcordeon($this->path);
        
        $form = new imaxForm($this->modulo, $this->path, '', 'post', '', '', false, true, $this->path);
        $form->createHidden("action", "none");
        $form->createHidden("idTab", "1");

        $pedidosSinAgregar = json_encode($this->obtenerPedidosSinAgregar());
        $campos = array('id' => 'Identificador', 'referencia' => 'Referencia', 'fechaEntrada' => 'Fecha entrada', 'finalizado' => 'Finalizado');
        $codigoFormateador = <<<EOT
            var pedidosSinAgregar = $pedidosSinAgregar, html;

            if(pedidosSinAgregar.indexOf(row.id) != -1) {
                html = "<button type='button' class='btn btn-xs btn-default imprimirPedido' data-row-id='" + row.id + "'><span class='icon-print'></span></button><button type='button' class='btn btn-xs btn-default aplicarStock' data-row-id='" + row.id + "'><span class='icon-plus-circle'></span></button><button type='button' class='btn btn-xs btn-default eliminarPedido' data-row-id='" + row.id + "'><span class='icon-remove'></span></button>";
            }
            else {
                html = "<button type='button' class='btn btn-xs btn-default imprimirPedido' data-row-id='" + row.id + "'><span class='icon-print'></span></button><button type='button' class='btn btn-xs btn-default eliminarPedido' data-row-id='" + row.id + "'><span class='icon-remove'></span></button>";
            }
                
            return html;
EOT;
        $modulo = $this; //Se usa en principal_listado.php
        $sumaCorrecta = $this->l('Stock agregado correctamente.');
        $sumaErronea = $this->l('No se pudo agregar el stock.');
        $confirmacionEliminar = $this->l('¿Esta seguro?');
        $etiquetasImprimir = json_encode($this->modulo->cargarImprimirEtiquetaProducto());
        $mostrarRefProduct = (int)Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'MOSTRAR_REF_PRODUCT');
        $botonImprimir = "<button onclick=\'printSpecificArea();\' class=\'btn btn-primary\'>Imprimir esta página</button>";
        $listado = str_replace("\n", '', require_once dirname(__FILE__).'/../../pdaEntrada/vistas/principal_listado.php');
        $listado .= $botonImprimir;
        $codigoEventoLoad = <<<EOT
            etiquetasImprimir = $etiquetasImprimir;
            mostrarRefProduct = $mostrarRefProduct;
            grid.find(".imprimirPedido").on("click", function(e){
                //Imprimir
                var idCompra = $(this).data("row-id");
                $.getJSON('../modules/imaximprimepedidosservidor/pdaEntrada/ajax.php?callback=?', {
                    accion: 'cargarPedido',
                    idPedido: idCompra
                }, function (respuesta) {
                    if (respuesta.ok) {
                        var msg = '<div id="paginaListado">$listado</div>';
                        $.fancybox( msg, {'autoDimensions': true, 'autoSize': true, 'openEffect': 'none', 'closeEffect': 'none', 'minWidth': '400px'} );

                        productos = [];
                        for (var i = 0, len = respuesta.datos.productos.length; i < len; i++) {
                            var iter = respuesta.datos.productos[i];

                            introducirLineaProducto(iter, '');
                        }

                        actualizarCantidadesGrupos();
                
                    }
                });
            }).end().find(".aplicarStock").on("click", function(e){
                // Agregar stock
                var idCompra = $(this).data("row-id");

                // Usando $.ajax para realizar una solicitud POST
                $.ajax({
                    url: '../modules/imaximprimepedidosservidor/pdaEntrada/ajax.php',
                    type: 'POST',
                    dataType: 'jsonp',
                    data: {
                        accion: 'sumarStock',
                        idPedido: idCompra
                    },
                    success: function(respuesta) {
                        if (respuesta.ok) {
                            showSuccessMessage("$sumaCorrecta");
                            $('.aplicarStock[data-row-id=' + idCompra + ']').remove();
                        } else {
                            showErrorMessage("$sumaErronea");
                        }
                    }
                });      
            }).end().find(".eliminarPedido").on("click", function(e){
                //Eliminar pedido
                if(confirm("$confirmacionEliminar")) {
                    var idCompra = $(this).data("row-id");
                    var fila = $(this).closest('tr');
                    $.getJSON('../modules/imaximprimepedidosservidor/pdaEntrada/ajax.php?callback=?', {
                        accion: 'eliminarPedido',
                        idPedido: idCompra
                    }, function (respuesta) {
                        if (respuesta.ok) {
                            fila.remove();
                        }
                    });
                }
            });
EOT;
        $cabecera = <<<EOT
            <tr>
                <th data-column-id="id" data-type="numeric" data-identifier="true" data-order="desc">id</th>
                <th data-column-id="referencia">Referencia</th>        
                <th data-column-id="fechaEntrada">Fecha Entrada</th>
                <th data-column-id="finalizado">Finalizado</th>
                <th data-column-id="commands" data-formatter="formateador" data-sortable="false">Comando</th>
            </tr>
EOT;
        $form->createTableAjax('grid-data', _DB_PREFIX_ . self::prefijo . 'altaCompras', $campos, $campos, $this->url, 'server.php', $cabecera, 
                ['formateador' => $codigoFormateador], $codigoEventoLoad);
        $html .= $form->renderForm();
        unset($form);        

        $form = new imaxForm($this->modulo, $this->path, Tools::safeOutput($_SERVER['REQUEST_URI']), 'post', 'uploadFile', "multipart/form-data", false, false, $this->path);
        $form->createHidden("action", "importacion");
        $form->createHidden("idTab", "1");
        $form->addToForm('<p><a href="../modules/imaximprimepedidosservidor/sampleFiles/sampeFileAddProductos.csv">'.$this->l('Pulsa este enlace para bajar un archivo de ejemplo.').'</a></p>');
        $form->createFormTextGroup('referencia', '', $this->l('Referencia de Pedido'), '', 0, 0, array('placeholder' => $this->l('Pon tu referencia')));
        $form->createFormDate('date_from', $this->l('Dia de compra'));
        $form->createFormUploadFile('file', $this->l('Fichero con referencias'), '');
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));        
        $html .= $acordeon->renderAcordeon($this->l('Importacion'), $form->renderForm());
        unset($form);

        return $html;
    }

    public function _yaveremos() {
        include_once($this->path . 'functionsForm.php');
        include_once($this->path . 'imaxAcordeon.php');
        $html = $this->l('Por ahora nada');
        return $html;
    }
    
    /**
     * Suma el nuevo stock a los productos correspondientes.
     * @param int $idPedido
     * @return boolean 
     */
    public function agregarStock($idPedido) {
        $idPedido = (int)$idPedido;
        $referenciaOrdenCompra = Db::getInstance()->getValue('SELECT `referencia` FROM `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."altaCompras` WHERE id = '$idPedido' AND stockAgregado = '0'");
        if($referenciaOrdenCompra) {
            $productosPedido = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."altaComprasDetalle` WHERE idAlta = $idPedido");
            $razonMvtEntrada = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'RAZON_MVT_ENTRADA');
            $gestavdstock = Module::isEnabled('gestavdstock');
            foreach($productosPedido as $productoPedido) {
                if($productoPedido['stockRecibido']){
                    $opcionesAlmacen = ImaxImprimePedidosServidor::cargarOpcionAlmacen($productoPedido['id_product'], $productoPedido['id_product_attribute']);
                    if($opcionesAlmacen && $opcionesAlmacen['almacenEntradaPorDefecto'] != 0){
                        $almacenEntradaPorDefecto = $opcionesAlmacen['almacenEntradaPorDefecto'];
                    }else{
                        $almacenEntradaPorDefecto = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'ALMACEN_ENTRADA_GENERAL');
                    }
                    if($gestavdstock){
                        $stock = $this->getStock($productoPedido['id_product'], $productoPedido['id_product_attribute'], $almacenEntradaPorDefecto);
                        if($stock){
                            $stock['physical_quantity'] = 0;
                            $stock['reserved_quantity'] = 0;
                        }
                        $cantidadFisica = $productoPedido['stockRecibido'] +  $stock['physical_quantity'];
                        $this->updateProductStock($productoPedido['id_product'], $productoPedido['id_product_attribute'], $productoPedido['stockRecibido'], $cantidadFisica, $stock['reserved_quantity']);
                        $this->generarMovimientoGestavdstock($productoPedido['id_product'], $productoPedido['id_product_attribute'], $productoPedido['stockRecibido'], $razonMvtEntrada, $referenciaOrdenCompra);
                    }else{
                        StockAvailable::updateQuantity($productoPedido['id_product'], $productoPedido['id_product_attribute'], $productoPedido['stockRecibido'], null, false, [], $almacenEntradaPorDefecto);
                        $this->generarMovimiento($productoPedido['id_product'], $productoPedido['id_product_attribute'], $productoPedido['stockRecibido'], $razonMvtEntrada);
                        (new StockManager())->updatePhysicalProductQuantity(
                            (int) Context::getContext()->shop->id,
                            (int) Configuration::get('PS_OS_ERROR'),
                            (int) Configuration::get('PS_OS_CANCELED'),
                            $productoPedido['id_product']
                        );
                    }
                }
            }
            
            $resultado = Db::getInstance()->execute('UPDATE `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."altaCompras` SET stockAgregado = 1 WHERE id = '$idPedido'");
        }
        else {
            $resultado = false;
        }
        
        return $resultado;
    }
    
    /**
     * Devuelve los ids de los pedidos listos para agregar su stock.
     * @return int[]
     */
    private function obtenerPedidosSinAgregar() {
        $respuesta = array();
        
        $pedidosSinAgregar = Db::getInstance()->executeS('SELECT id FROM `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo.'altaCompras` WHERE finalizado = 1 AND stockAgregado = 0');
        foreach($pedidosSinAgregar as $pedidoSinAgregar) {
            $respuesta[] = $pedidoSinAgregar['id'];
        }
        
        return $respuesta;
    }
    
    /**
     * Helper displaying error message(s)
     * @param string|array $error
     * @return string
     */
    public function displayError($error) {
        $output = '
		<div class="bootstrap">
		<div class="module_error alert alert-danger" >
			<button type="button" class="close" data-dismiss="alert">&times;</button>';

        if (is_array($error)) {
            $output .= '<ul>';
            foreach ($error as $msg) {
                $output .= '<li>' . $msg . '</li>';
            }
            $output .= '</ul>';
        } else {
            $output .= $error;
        }

        // Close div openned previously
        $output .= '</div></div>';

        $this->error = true;
        return $output;
    }

    /**
     * Helper displaying warning message(s)
     * @param string|array $error
     * @return string
     */
    public function displayWarning($warning) {
        $output = '
		<div class="bootstrap">
		<div class="module_warning alert alert-warning" >
			<button type="button" class="close" data-dismiss="alert">&times;</button>';

        if (is_array($warning)) {
            $output .= '<ul>';
            foreach ($warning as $msg) {
                $output .= '<li>' . $msg . '</li>';
            }
            $output .= '</ul>';
        } else {
            $output .= $warning;
        }

        // Close div openned previously
        $output .= '</div></div>';

        return $output;
    }

    public function displayConfirmation($string) {
        $output = '
		<div class="bootstrap">
		<div class="module_confirmation conf confirm alert alert-success">
			<button type="button" class="close" data-dismiss="alert">&times;</button>
			' . $string . '
		</div>
		</div>';
        return $output;
    }

    /**
     * Genera movimientos de stock de un producto
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $cantidad
     */
    public function generarMovimiento($id_product, $id_product_attribute, $cantidad, $razon){             
        return (new \PrestaShop\PrestaShop\Core\Stock\StockManager())->saveMovement(
            $id_product,
            $id_product_attribute,
            $cantidad,
            array(
                'id_stock_mvt_reason' => $razon,
            )
        );
    }

    /**
     * Genera movimientos de stock de un producto para el módulo gestavdstock
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $cantidad
     */
    public function generarMovimientoGestavdstock($id_product, $id_product_attribute, $cantidad, $razon, $referenciaOrdenCompra){
        $id_product = (int) $id_product;
        $id_product_attribute = (int) $id_product_attribute;
        $cantidad = (int) $cantidad;
        $lang_id = Context::getContext()->language->id;
        $id_employee = Context::getContext()->employee->id;
        $product = new Product($id_product, false, $lang_id);
        $product_name= pSQL($product->name);
        if($id_product_attribute){
            $combination = new Combination($id_product_attribute, $lang_id);
            $reference = pSQL($combination->reference);
        }else{
            $reference= pSQL($product->reference);
        }
        $opcionesAlmacen = ImaxImprimePedidosServidor::cargarOpcionAlmacen($id_product, $id_product_attribute);
        if($opcionesAlmacen && $opcionesAlmacen['almacenEntradaPorDefecto'] != 0){
            $almacenEntradaPorDefecto = $opcionesAlmacen['almacenEntradaPorDefecto'];
        }else{
            $almacenEntradaPorDefecto = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'ALMACEN_ENTRADA_GENERAL');
        }
        $stock = $this->getStock($id_product, $id_product_attribute, $almacenEntradaPorDefecto);
        if($stock){
            $stock['stock_quantity'] += $cantidad;
            $stock['physical_quantity'] += $cantidad;
        }else{
            $stock['stock_quantity'] = $cantidad;
            $stock['physical_quantity'] = $cantidad;
            $stock['reserved_quantity'] = 0;
        }
        $mvt_physical = (int)$cantidad;
        $mvt_reserved = 0;
        $sign=-1;
        if($mvt_physical>0)
             $sign=1;
        $stockMvtReasons = StockMvtReason::getStockMvtReasons($lang_id);
        $stockMvtReasonsFormat = array();
        foreach($stockMvtReasons as $stockMvtReason){
            $stockMvtReasonsFormat[$stockMvtReason['id_stock_mvt_reason']] = $stockMvtReason['name'];
        }
        $id_stock_mvt_reason = pSQL($stockMvtReasonsFormat[$razon]);       
        $comments = pSQL($stockMvtReasonsFormat[$razon]);
        $referenciaOrdenCompra = pSQL($referenciaOrdenCompra);
        $date_add= date('Y-m-d H:i:s');
        $sql = 'INSERT INTO ' . _DB_PREFIX_ .'stock_available_advanced 
                (product_name,reference,id_product,id_product_attribute,
                id_order,id_order_status, stock_quantity, 
                physical_quantity,reserved_quantity, mvt_physical,
                mvt_reserved,sign,id_employee,reason_presta,comments,date_add) 
                VALUES ("'.$product_name.'","'.$reference.'","'.$id_product.'",
                "'.$id_product_attribute.'", "0", "0",
                "'.$stock['stock_quantity'].'", "'.$stock['physical_quantity'].'","'.$stock['reserved_quantity'].'",
                "'.$mvt_physical.'", "'.$mvt_reserved.'","'.$sign.'",
                "'.$id_employee.'", "'.$id_stock_mvt_reason.'","'.$comments . '-' . $referenciaOrdenCompra .'",
                "'.$date_add.'")';
        Db::getInstance()->execute($sql);
        $id_stock_available_advanced = (int)Db::getInstance()->Insert_ID();
        
        if(Module::isEnabled('imaxmultialmacen')){
            Module::getInstanceByName('imaxmultialmacen');
            $opcionesAlmacen = ImaxImprimePedidosServidor::cargarOpcionAlmacen($id_product, $id_product_attribute);
            if($opcionesAlmacen && $opcionesAlmacen['almacenEntradaPorDefecto'] != 0){
                $almacenEntradaPorDefecto = $opcionesAlmacen['almacenEntradaPorDefecto'];
            }else{
                $almacenEntradaPorDefecto = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'ALMACEN_ENTRADA_GENERAL');
            }
            Configuration::set(ImaxMultiAlmacen::prefijo. 'ALMACEN_GENERAL', $almacenEntradaPorDefecto);
            Db::getInstance()->execute('REPLACE INTO `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."extraMovimiento_advanced` 
            (id_stock_available_advanced, id_warehouse) VALUES ($id_stock_available_advanced, $almacenEntradaPorDefecto)");
        }                
    }

    /**
     * Devuelve la cantidad física de un producto
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $id_warehouse
     * @return string|false
     */
    private function getStock($id_product, $id_product_attribute = null, $id_warehouse = null) {
        $db = Db::getInstance();
        $id_product = (int) $id_product;
        $id_product_attribute = (int) $id_product_attribute;
        $id_warehouse = (int) $id_warehouse;
        if(Module::isEnabled('imaxmultialmacen')){
            Module::getInstanceByName('imaxmultialmacen');
            $sql = 'SELECT stock_quantity, physical_quantity, reserved_quantity FROM ' . _DB_PREFIX_ . "stock_available_advanced saa
                    INNER JOIN `"._DB_PREFIX_.ImaxMultiAlmacen::prefijo."extraMovimiento_advanced` ema 
                    ON saa.id_stock_available_advanced = ema.id_stock_available_advanced 
                    WHERE id_product = '$id_product' AND id_product_attribute = '$id_product_attribute' and id_warehouse = $id_warehouse
                    ORDER BY ema.id_stock_available_advanced DESC";
        }else{  
            $sql = 'SELECT stock_quantity, physical_quantity, reserved_quantity FROM ' . _DB_PREFIX_ . "stock_available_advanced 
                    WHERE id_product = '$id_product' AND id_product_attribute = '$id_product_attribute' ORDER BY id_stock_available_advanced DESC";
        }
        
        return $db->getRow($sql);
    }

    /**
     * Actualiza el stock si el módulo gestavdstock se encuntra instalado
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $quantity
     * @param int $physical_quantity
     * @param int $reserved_quantity
     */
    private function updateProductStock($id_product, $id_product_attribute, $quantity, $physical_quantity, $reserved_quantity) {
        $id_product = (int) $id_product;
        $id_product_attribute = (int) $id_product_attribute;
        $physical_quantity = (int) $physical_quantity;
        $reserved_quantity = (int) $reserved_quantity;
        $opcionesAlmacen = ImaxImprimePedidosServidor::cargarOpcionAlmacen($id_product, $id_product_attribute);
        if($opcionesAlmacen && $opcionesAlmacen['almacenEntradaPorDefecto'] != 0){
            $almacenEntradaPorDefecto = $opcionesAlmacen['almacenEntradaPorDefecto'];
        }else{
            $almacenEntradaPorDefecto = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'ALMACEN_ENTRADA_GENERAL');
        }
        StockAvailable::updateQuantity($id_product, $id_product_attribute, $quantity, null, false, [], $almacenEntradaPorDefecto);
        $sql = "UPDATE `" . _DB_PREFIX_ . "stock_available` SET physical_quantity = $physical_quantity, reserved_quantity = $reserved_quantity
                WHERE id_product = $id_product AND id_product_attribute = $id_product_attribute";
        Db::getInstance()->execute($sql);
        $sql = "UPDATE `" . _DB_PREFIX_ . "stock` SET physical_quantity = $physical_quantity 
        WHERE id_product = $id_product AND id_product_attribute = $id_product_attribute AND id_warehouse = $almacenEntradaPorDefecto";
        Db::getInstance()->execute($sql);  
    }
 
    public function redirectWithNotifications($url)
    {
        $notifications = json_encode([
            'error' => $this->errors,
            'warning' => $this->warning,
            'success' => $this->success,
            'info' => $this->info,
        ]);
        if (session_status() == PHP_SESSION_ACTIVE) {
            $_SESSION['notifications'] = $notifications;
        } elseif (session_status() == PHP_SESSION_NONE) {
            session_start();
            $_SESSION['notifications'] = $notifications;
        } else {
            setcookie('notifications', $notifications);
        }

        return Tools::redirectAdmin($url);
    }

    protected function prepareNotifications()
     {
        $notifications = [
            'error' => $this->errors,
            'success' => $this->success,
        ];

        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }

        if (session_status() == PHP_SESSION_ACTIVE && isset($_SESSION['notifications'])) {
            $notifications = array_merge($notifications, json_decode($_SESSION['notifications'], true));
            unset($_SESSION['notifications']);
        } elseif (isset($_COOKIE['notifications'])) {
            $notifications = array_merge($notifications, json_decode($_COOKIE['notifications'], true));
            unset($_COOKIE['notifications']);
        }

        return $notifications;
    }
}
