<?php

require_once(dirname(__FILE__) . '/../../imaximprimepedidosservidor.php');

class AdminImaxImprimePedidosAddProductosController extends AdminController {

    public $name, $id_lang, $_path, $images, $url, $success, $html, $idTab, $error, $warning, $info, $modulo;
    const prefijo = 'imaximppedser_';

    public function __construct() {
        $this->name = 'imaximprimepedidosservidor';
        $this->path = _PS_MODULE_DIR_ . $this->name . '/';

        $this->display = 'edit';
        $this->id_lang = (int) Context::getContext()->language->id;

        $this->lang = true;
        $this->deleted = false;
        $this->colorOnBackground = true;
        $this->_path = Tools::safeOutput($_SERVER['REQUEST_URI']);

        $this->url = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name . '/';
        $this->images = $this->url . 'images/';

        $this->context = Context::getContext();
        $this->bootstrap = false;
        $this->html = '';

        $this->modulo = Module::getInstanceByName($this->name);

        parent::__construct();

        $contextData = new Context;
        $contextData->shop = $this->context->shop;
        $contextData->employee = $this->context->employee;
        $contextData->currency = $this->context->currency;
    }

    public function renderForm() {
        $idTab = (int) Tools::getValue('id_tab');
        if (!isset($idTab) || $idTab == 0)
            $idTab = 1;
        $this->html .= '	   
                <ul id="menuTab">
                    <li id="menuTab1" class="menuTabButton' . (($idTab == 1) ? " selected" : "" ) . '">1. ' . $this->l('Creacion de productos') . '</li>			                    
                </ul>
                <div id="tabList' . $this->name . '">
                    <div id="menuTab1Sheet" class="tabItem' . (($idTab == 1) ? " selected" : "" ) . '">' . $this->_activarAcceso() . '</div>                                                    				
                </div>
                <br clear="left" />
                <br />
                <style>
                    #menuTab { float: left; padding: 0; margin: 0; text-align: left; }
                    #menuTab li { text-align: left; float: left; display: inline; padding: 5px; padding-right: 10px; background: #EFEFEF; font-weight: bold; cursor: pointer; border-left: 1px solid #EFEFEF; border-right: 1px solid #EFEFEF; border-top: 1px solid #EFEFEF; }
                    #menuTab li.menuTabButton.selected { background: #FFF6D3; border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-top: 1px solid #CCCCCC; }
                    #tabList' . $this->name . ' { clear: left;, width:100% }
                    .tabItem { display: none; }
                    .tabItem.selected { display: block; background: #FFFFF0; border: 1px solid #CCCCCC; padding: 10px; padding-top: 20px; }
                </style>
                <script>
                    $(".menuTabButton").click(function() {
                        $(".menuTabButton.selected").removeClass("selected");
                        $(this).addClass("selected");
                        $(".tabItem.selected").removeClass("selected");
                        $("#" + this.id + "Sheet").addClass("selected");
                    });
                </script>';

        return $this->html . $this->content . parent::renderForm();
    }

    public function postProcess() {
        $accion = Tools::getValue('action');
        $this->idTab = Tools::getValue("idTab");
        $html = "";
        switch ($accion) {
            case 'addProduct':
                $ean = trim(Tools::getValue('ean'));
                $categoria = trim(Tools::getValue('categoria'));
                $stock = (int) Tools::getValue('stock');
                if ($stock == -1) {
                    $existe = ImaxImprimePedidosServidor::buscarEan($ean);
                    if ($existe) {
                        $stock = StockAvailable::getQuantityAvailableByProduct((int) $existe['id_product'], (int) $existe['id_product_attribute']);
                        $imax = new ImaxImprimePedidosServidor();
                        $ubicacion = $imax->cargarExtraProducto((int) $existe['id_product'], (int) $existe['id_product_attribute']);
                        $respuesta = $this->l('El producto tiene de stock: ') . $stock;
                        if ($ubicacion) {
                            $respuesta .= $this->l(' Su ubicacion es: ') . $ubicacion['ubicacion'];
                        }
                        $this->html .= $this->displayConfirmation($respuesta);
                    } else {
                        $this->html .= $this->displayError($this->l('No existe ningún producto con ese EAN'));
                    }
                } else {
                    Configuration::updateGlobalValue(self::prefijo.'CATEGORIAS', $categoria);
                    $nombre = trim(Tools::getValue('nom_producto', false));
                    if($nombre !== FALSE) {
                        Configuration::updateGlobalValue(self::prefijo.'NOM_PRO_DEFECTO', $nombre);
                    }
                    $precio = trim(Tools::getValue('pre_producto', false));
                    if($precio !== FALSE) {
                        Configuration::updateGlobalValue(self::prefijo.'PRECIO_PRO_DEFECTO', $precio);
                    }
                    $coste = trim(Tools::getValue('cos_producto', false));
                    if($coste !== FALSE) {
                        Configuration::updateGlobalValue(self::prefijo.'COSTE_PRO_DEFECTO', $coste);
                    }
                    $proveedor = trim(Tools::getValue('suppli_producto', false));
                    if($proveedor !== FALSE) {
                        Configuration::updateGlobalValue(self::prefijo.'SUPPLI_PRODUCTO', $proveedor);
                    }
                    $impuesto = trim(Tools::getValue('imp_producto', false));
                    if($impuesto !== FALSE) {
                        Configuration::updateGlobalValue(self::prefijo.'IMP_PRODUCTO', $impuesto);
                    }
                    Configuration::updateGlobalValue(self::prefijo.'STOCK_PRO_DEFECTO', $stock);
                    
                    if ($ean) {
                        $existe = ImaxImprimePedidosServidor::buscarEan($ean);
                        if (!$existe) {
                            $id = ImaxImprimePedidosServidor::crearProducto($ean, $this->id_lang, $categoria, true, $stock);
                            if ($id) {
                                $this->html .= $this->displayConfirmation($this->l('Producto nuevo creado: ') . $id);
                            }
                        }else {
                            StockAvailable::SetQuantity((int) $existe['id_product'], (int) $existe['id_product_attribute'], (int) $stock);
                            $this->html .= $this->displayConfirmation($this->l('Producto ') . $existe['id_product'] . (' Stock nuevo : ') . $stock);
                        }
                    }
                }
                break;
            case 'importacion':
                $error = 0;
                $file_import = dirname(__FILE__) . '/../../import/' . $_FILES['file']['name'] . '.' . date('Ymdhis') . '.csv';
                if (move_uploaded_file($_FILES['file']['tmp_name'], $file_import)) {
                    require_once dirname(__FILE__).'/../../clases/accesoDatos/iAccesoDatos.php';
                    switch (ImaxImprimePedidosServidor::detectarTipoArchivo($file_import)) {
                        case ImaxImprimePedidosServidor::ARCHIVO_CSV:
                            require_once dirname(__FILE__).'/../../clases/accesoDatos/AccesoDatosCSV.php';
                            $acceso = new clases\accesoDatos\AccesoDatosCSV($file_import, 0, 1, ';');
                            break;

                        case ImaxImprimePedidosServidor::ARCHIVO_EXCEL:
                            require_once dirname(__FILE__).'/../../clases/accesoDatos/AccesoDatosExcel.php';
                            require_once dirname(__FILE__).'/../../clases/accesoDatos/ChunkReadFilter.php';
                            $acceso = new clases\accesoDatos\AccesoDatosExcel($file_import, 0, 32768, 1);
                            break;

                        default:
                            require_once dirname(__FILE__).'/../../clases/accesoDatos/AccesoDatosCSV.php';
                            $acceso = new clases\accesoDatos\AccesoDatosCSV($file_import, 0, 1, ';');
                            break;
                    }
                    
                    $productosean = array();
                    while (($data = $acceso->obtenerFila()) !== FALSE) {
                        if ($data) {
                            $productosean['productoPresahop'] = ImaxImprimePedidosServidor::buscarReferencia($data[0]);
                            if ($productosean['productoPresahop']['id_product_attribute']) {
                                if (Validate::isEan13($data[1])) {
                                    $combination = new Combination($productosean['productoPresahop']['id_product_attribute']);
                                    if(Validate::isLoadedObject($combination)) {
                                        $combination->ean13 = $data[1];
                                        $combination->update();
                                    }
                                }
                            }
                            else {
                                if (Validate::isEan13($data[1])) {
                                    $producto = new Product($productosean['productoPresahop']['id_product']);
                                    if(Validate::isLoadedObject($producto)) {
                                        $producto->ean13 = $data[1];
                                        $producto->update();
                                    }
                                }
                            }
                        }
                    }
                    unlink($file_import);
                }
                if ($error == 0) {
                    //$this->crearPedidoEan((int) Tools::getValue('nombre_cliente'), $productoEncontrados);
                    $this->html .= $this->displayConfirmation($this->l('Actualizado Correctamente'));
                }
                
                break;
        }
    }

    public function _activarAcceso() {
        include_once($this->path . 'functionsForm.php');
        include_once($this->path . 'imaxAcordeon.php');
        $html = '';

        $categoria = Configuration::getGlobalValue(self::prefijo.'CATEGORIAS');
        $nom_producto = Configuration::getGlobalValue(self::prefijo.'NOM_PRO_DEFECTO');
        $pre_producto = Configuration::getGlobalValue(self::prefijo.'PRECIO_PRO_DEFECTO');
        $cos_producto = Configuration::getGlobalValue(self::prefijo.'COSTE_PRO_DEFECTO');
        $sto_producto = (int)Configuration::getGlobalValue(self::prefijo.'STOCK_PRO_DEFECTO');
        $enControlador = Configuration::getGlobalValue(self::prefijo.'EN_CONTROLADOR');
        $proveedor_producto = Configuration::getGlobalValue(self::prefijo.'SUPPLI_PRODUCTO');
        $impuesto_producto = Configuration::getGlobalValue(self::prefijo.'IMP_PRODUCTO');
        $impuestos = TaxRulesGroup::getTaxRulesGroups();
        $impuestosFormateados = array();
        foreach($impuestos as $impuesto) {
            $impuestosFormateados[$impuesto['id_tax_rules_group']] = $impuesto['name'];
        }
        
        $acordeon = new imaxAcordeon($this->_path, $this->path);
        $form = new imaxForm($this->modulo, $this->_path);
        $form->createHidden("action", "addProduct");
        $form->createHidden("idTab", "1");
        $form->createFormTextGroup('ean', '', $this->l('EAN'), $this->l('EAN'), 0, 0, array(), true);
        $form->createFormTextGroup('stock', $sto_producto, $this->l('Stock del producto'));        
        $form->createSelectCategory('categoria', 'Selecciona la categoria', $categoria, 'Selecciona la categoria', false, true, true);
        if($enControlador) {
            $form->createFormTextGroup('nom_producto', $nom_producto, 'Nombre por defecto del producto');
            $form->createFormTextGroup('pre_producto', $pre_producto, 'Precio por defecto');
            $form->createFormTextGroup('cos_producto', $cos_producto, 'Coste por defecto');
            $form->createSelectSupplier('suppli_producto', 'Proveedor', $proveedor_producto);
            $form->createFormSelect('imp_producto', 'Impuesto', $impuestosFormateados, $impuesto_producto);
        }
        $form->createFormInfomationText($this->l('Puede crear los productos leyendo desde el codigo de barras y si Amazon esta activado, se importara los datos de forma automática, SI EXISTE EL STOCK SERA ACTUALIZADO'));
        $form->createFormInfomationText($this->l('Si en stock pones -1 y el producto existe te devuelve la ubicacion y el stock'));
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
        $html .= $form->renderForm();
        unset($form);
        $form = new imaxForm($this->modulo, $this->_path, Tools::safeOutput($_SERVER['REQUEST_URI']), 'post', 'uploadFile', "multipart/form-data", false, false, $this->path);
        $form->createHidden("action", "importacion");
        $form->createHidden("idTab", "1");
        $form->addToForm('<p><a href="../modules/imaximprimepedidosservidor/sampleFiles/sampeFileAddEAN.csv">'.$this->l('Pulsa este enlace para bajar un archivo de ejemplo.').'</a></p>');
        $form->createFormUploadFile('file', 'Fichero con referencias para modificar los EAN', 'Fiel 2');        
        $temphtml = '';
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
        $html .= $acordeon->renderAcordeon($this->l('Importacion'), $form->renderForm());

        return $html;
    }

    /**
     * Helper displaying error message(s)
     * @param string|array $error
     * @return string
     */
    public function displayError($error) {
        $output = '
		<div class="bootstrap">
		<div class="module_error alert alert-danger" >
			<button type="button" class="close" data-dismiss="alert">&times;</button>';

        if (is_array($error)) {
            $output .= '<ul>';
            foreach ($error as $msg) {
                $output .= '<li>' . $msg . '</li>';
            }
            $output .= '</ul>';
        } else {
            $output .= $error;
        }

        // Close div openned previously
        $output .= '</div></div>';

        $this->error = true;
        return $output;
    }

    /**
     * Helper displaying warning message(s)
     * @param string|array $error
     * @return string
     */
    public function displayWarning($warning) {
        $output = '
		<div class="bootstrap">
		<div class="module_warning alert alert-warning" >
			<button type="button" class="close" data-dismiss="alert">&times;</button>';

        if (is_array($warning)) {
            $output .= '<ul>';
            foreach ($warning as $msg) {
                $output .= '<li>' . $msg . '</li>';
            }
            $output .= '</ul>';
        } else {
            $output .= $warning;
        }

        // Close div openned previously
        $output .= '</div></div>';

        return $output;
    }

    public function displayConfirmation($string) {
        $output = '
		<div class="bootstrap">
		<div class="module_confirmation conf confirm alert alert-success">
			<button type="button" class="close" data-dismiss="alert">&times;</button>
			' . $string . '
		</div>
		</div>';
        return $output;
    }

}
