<?php
class OrderProceesed extends ObjectModel
{
    /** @var string Name */
    public $content;
    public $title;
    public $position;
    public $active;
    const prefijo = 'imaximppedser_';

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => self::prefijo.'orders',
        'primary' => 'id_order',
        'multilang' => FALSE,
        'fields' => array(
            'position' =>           array('type' => self::TYPE_INT),
            'active' =>             array('type' => self::TYPE_BOOL),

            // Lang fields
            'title' =>          array('type' => self::TYPE_STRING, 'lang' => FALSE , 'validate' => 'isGenericName', 'required' => true, 'size' => 128),
            'reference' =>          array('type' => self::TYPE_STRING, 'lang' => FALSE , 'validate' => 'isGenericName', 'required' => true, 'size' => 128),
            
        ),
    );

    public function add($autodate = TRUE, $null_values = FALSE)
    {
        $this->position = self::getLastPosition();
        return parent::add($autodate, TRUE);
    }

    public function update($null_values = FALSE)
    {
        if (parent::update($null_values)) {
            return $this->cleanPositions();
        }
        
        return FALSE;
    }

    public function delete()
    {
        if (parent::delete()) {
            return $this->cleanPositions();
        }
        
        return FALSE;
    }
    
    public static function getLastPosition()
    {
        $sql = '
        SELECT MAX(position) + 1
        FROM `'._DB_PREFIX_.'belvg_faq`';

        return (Db::getInstance()->getValue($sql));
    }

    public static function cleanPositions()
    {
        $sql = '
        SELECT `id_belvg_faq`
        FROM `'._DB_PREFIX_.'belvg_faq`
        ORDER BY `position`';

        $result = Db::getInstance()->executeS($sql);

        for ($i = 0, $total = count($result); $i < $total; ++$i) {
            $sql = 'UPDATE `'._DB_PREFIX_.'belvg_faq`
                    SET `position` = '.(int)$i.'
                    WHERE `id_belvg_faq` = '.(int)$result[$i]['id_belvg_faq'];
            Db::getInstance()->execute($sql);
        }
        
        return TRUE;
    }
    
    public function updatePosition($way, $position)
    {
        if (!$res = Db::getInstance()->executeS('
            SELECT cp.`id_belvg_faq`, cp.`position`
            FROM `'._DB_PREFIX_.'belvg_faq` cp
            ORDER BY cp.`position` ASC'
        )) {
            return FALSE;
        }
        
        foreach ($res as $faq) {
            if ((int)$faq['id_belvg_faq'] == (int)$this->id) {
                $moved_faq = $faq;
            }
        }

        if (!isset($moved_faq) || !isset($position)) {
            return FALSE;
        }

        // < and > statements rather than BETWEEN operator
        // since BETWEEN is treated differently according to databases
        return (Db::getInstance()->execute('
            UPDATE `'._DB_PREFIX_.'belvg_faq`
            SET `position`= `position` '.($way ? '- 1' : '+ 1').'
            WHERE `position`
            '.($way
                ? '> '.(int)$moved_faq['position'].' AND `position` <= '.(int)$position
                : '< '.(int)$moved_faq['position'].' AND `position` >= '.(int)$position))
        && Db::getInstance()->execute('
            UPDATE `'._DB_PREFIX_.'belvg_faq`
            SET `position` = '.(int)$position.'
            WHERE `id_belvg_faq` = '.(int)$moved_faq['id_belvg_faq']));
    }
}