<?php

class HTMLTemplatePedidosImpresos extends HTMLTemplate {

    public $pedidos;

    public function __construct($datos, $smarty) {
        $this->pedidos = $datos;
        $this->smarty = $smarty;
        
        $this->assignCommonHeaderData();
    }
    
    /**
     * Returns the template's HTML content
     * @return string HTML content
     */
    public function getContent() {
        $tabla = '
            <table>
                <thead>
                    <tr>
                        <th><strong>'.$this->l('ID pedido').'</strong></th>
                        <th><strong>'.$this->l('Nombre cliente').'</strong></th>
                        <th><strong>'.$this->l('Peso').'</strong></th>
                        <th><strong>'.$this->l('Transportista').'</strong></th>
                        <th><strong>'.$this->l('Pais').'</strong></th>
                     </tr>
                </thead>
                <tbody>';
        
        foreach($this->pedidos as $pedido) {
            $tabla .= '<tr>';
            foreach($pedido as $columna) {
                $tabla .= "<td>$columna</td>";
            }
            $tabla .= '</tr>';
        }
        
        $tabla .= '</tbody></table>';

        $this->smarty->assign(array('tabla' => $tabla));

        return $this->smarty->fetch($this->getTemplate('pedidosImpresos'));
    }

    /**
     * Returns the template filename when using bulk rendering
     * @return string filename
     */
    public function getBulkFilename() {
        return 'pedidos_impresos.pdf';
    }

    /**
     * Returns the template filename
     * @return string filename
     */
    public function getFilename() {
        return 'pedidos_impresos.pdf';
    }

    public function getTemplate($template_name) {
        $template = false;

        $default_template = _PS_MODULE_DIR_.'imaximprimepedidosservidor/pdf/'.$template_name.'.tpl';

        if (file_exists($default_template)) {
            $template = $default_template;
        }

        return $template;
    }

    public function getHeader() {        
        return '';
    }

    public function getFooter() {
        return '';
    }

    public function getPagination() { 
		return $this->smarty->fetch(parent::getTemplate('pagination'));
	}
}
