<?php

class HTMLTemplatePedidoMail extends HTMLTemplate {

    public $order, $nombrePlantilla, $soloTexto;

    public function __construct($datos, $smarty) {
        $this->order = new Order($datos->idPedido);
        $this->nombrePlantilla = $datos->plantilla;
        $this->smarty = $smarty;
        $this->shop = new Shop((int)$this->order->id_shop);
        $this->modulo = new ImaxImprimePedidosServidor();
        $this->soloTexto = $datos->soloTexto;
    }
    
    /**
     * Returns the template's HTML content
     * @return string HTML content
     */
    public function getContent() {
        $this->assignCommonHeaderData();
        
        $currency = new Currency($this->order->id_currency);
        $customer = new Customer($this->order->id_customer);
        $delivery = new Address((int) $this->order->id_address_delivery);
        $invoice = new Address((int) $this->order->id_address_invoice);
        $order_date_text = Tools::displayDate($this->order->date_add);
        $carrier = new Carrier((int) $this->order->id_carrier);
        $aliasFormasPago = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'ALIAS_FORMAS_PAGO'));
        $message = $this->order->getFirstMessage();
        if (!$message || empty($message)) {
            $message = $this->l('Sin mensaje');
        }
        $dbarrio = Module::isEnabled('marketplace');

        $items_table = '';
        $miniItems = '';
        $miniItemsTexto = '';

        $products = $this->order->getProducts();
        $customized_datas = Product::getAllCustomizedDatas((int) $this->order->id_cart);
        Product::addCustomizationPrice($products, $customized_datas);
        foreach ($products as $key => $product) {
            $ubicacion = $this->modulo->cargarExtraProducto($product['product_id'], (int)$product['product_attribute_id']);
            $unit_price = $product['product_price_wt'];

            $customization_text = '';
            if (isset($customized_datas[$product['product_id']][$product['product_attribute_id']])) {

                foreach ($customized_datas[$product['product_id']][$product['product_attribute_id']] as $customizationTemp) {
                    foreach($customizationTemp as $customization) {
                        if (isset($customization['datas'][_CUSTOMIZE_TEXTFIELD_])) {
                            foreach ($customization['datas'][_CUSTOMIZE_TEXTFIELD_] as $text) {
                                $customization_text .= $text['name'] . ': ' . $text['value'] . '<br />';
                            }
                        }

                        if (isset($customization['datas'][_CUSTOMIZE_FILE_])) {
                            $customization_text .= count($customization['datas'][_CUSTOMIZE_FILE_]) . ' ' . $this->l('image(s)') . '<br />';
                        }

                        $customization_text .= '---<br />';
                    }
                }

                $customization_text = rtrim($customization_text, '---<br />');
            }

            $items_table .=
                    '<tr style="background-color:' . ($key % 2 ? '#DDE2E6' : '#EBECEE') . ';">
					<td style="padding:0.6em 0.4em; text-align:center;">' . $product['product_reference'] . '</td>
					<td style="padding:0.6em 0.4em; text-align:center;">
						<strong>'
                    . $product['product_name'] . (isset($product['attributes_small']) ? ' ' . $product['attributes_small'] : '') . (!empty($customization_text) ? '<br />' . $customization_text : '') .
                    '</strong>
					</td>
					<td style="padding:0.6em 0.4em; text-align:center;">' . Tools::displayPrice($unit_price, $currency, false) . '</td>
					<td style="padding:0.6em 0.4em; text-align:center;">' . (int) $product['product_quantity'] . '</td>
					<td style="padding:0.6em 0.4em; text-align:center;">' . Tools::displayPrice(($unit_price * $product['product_quantity']), $currency, false) . '</td>
				</tr>';
            
            $miniItems	.= '
                <tr>'.
                    (!$dbarrio ? '<td>' . $product['product_reference'] . '</td>' : '').
                    '<td>' . (int) $product['product_quantity'] . '</td>'.
                    (!$dbarrio ? '<td>' . ($ubicacion ? $ubicacion['ubicacion'] : '') . '</td>' : '').
                    '<td>' . Tools::displayPrice(($unit_price * $product['product_quantity']), $currency, false) . '</td>
                </tr>
                <tr>
                    <td colspan="'.(!$dbarrio ? 4 : 2).'" style="border-bottom: 1px solid black;">'
                        . $product['product_name'] . (isset($product['attributes_small']) ? ' ' . $product['attributes_small'] : '') . (!empty($customization_text) ? '<br />' . $customization_text : '') .
                    '</td>	
                </tr>';
            
            $miniItemsTexto	.= 
                    (!$dbarrio ? $product['product_reference'] . ' | ' : '').
                    (int) $product['product_quantity'] . ' | ' .
                    (!$dbarrio ? ($ubicacion ? $ubicacion['ubicacion'] : '') . ' | ' : '').
                    Tools::displayPrice(($unit_price * $product['product_quantity']), $currency, false) . "\n" .
                    $product['product_name'] . (isset($product['attributes_small']) ? ' ' . $product['attributes_small'] : '') . 
                    (!empty($customization_text) ? "\n" . strip_tags($customization_text) : '') . "\n";
        }
        foreach ($this->order->getCartRules() as $discount) {
            $items_table .=
                    '<tr style="background-color:#EBECEE;">
					<td colspan="4" style="padding:0.6em 0.4em; text-align:right;">' . $this->l('Voucher code:') . ' ' . $discount['name'] . '</td>
					<td style="padding:0.6em 0.4em; text-align:right;">-' . Tools::displayPrice($discount['value'], $currency, false) . '</td>
			</tr>';
        }
        
        //DBarrio
        if($dbarrio) {
            $mp_carrier = new WkMpCarrier(WkMpCarrier::getIdMpCarrierByCarrierReference($carrier->id_reference));
            if($mp_carrier->email) {
                $minutos = marketplace::getCarrierDelay($this->order->id, true);
                $fecha = new DateTime();
                $fecha->modify('+'.$minutos.' minute');
                $fechaRecogida = $fecha->format('d/m/Y H:i'); // fecha recogida

                $minutos = marketplace::getCarrierDelay($this->order->id);
                $fecha = new DateTime();
                $fecha->modify('+'.$minutos.' minute');
                $fechaEntrega = $fecha->format('d/m/Y H:i'); // fecha entrega estimada
                
                $nombreRepatidor = $mp_carrier->nombre;   // nombre comercial del repartidor
                $telefonoRepartidor = $mp_carrier->telefono;   // teléfono 
            }
        }

        $template_vars = array(
            'dbarrio' => $dbarrio,
            'dbarrio_fechaRecogida' => (!empty($fechaRecogida) ? $fechaRecogida : ''),
            'dbarrio_fechaEntrega' => (!empty($fechaEntrega) ? $fechaEntrega : ''),
            'dbarrio_nombreRepartidor' => (!empty($nombreRepatidor) ? $nombreRepatidor : ''),
            'dbarrio_telefonoRepartidor' => (!empty($telefonoRepartidor) ? $telefonoRepartidor : ''),
            'firstname' => $customer->firstname,
            'lastname' => $customer->lastname,
            'email' => $customer->email,
            'delivery_block_txt' => self::getFormatedAddress($delivery, "\n"),
            'invoice_block_txt' => self::getFormatedAddress($invoice, "\n"),
            'delivery_block_html' => self::getFormatedAddress($delivery, '<br />', array(
                'firstname' => '<span style="color:' . Configuration::get('PS_MAIL_COLOR') . '; font-weight:bold;">%s</span>',
                'lastname' => '<span style="color:' . Configuration::get('PS_MAIL_COLOR') . '; font-weight:bold;">%s</span>')),
            'invoice_block_html' => self::getFormatedAddress($invoice, '<br />', array(
                'firstname' => '<span style="color:' . Configuration::get('PS_MAIL_COLOR') . ' font-weight:bold;">%s</span>',
                'lastname' => '<span style="color:' . Configuration::get('PS_MAIL_COLOR') . '; font-weight:bold;">%s</span>')),
            'delivery_company' => $delivery->company,
            'delivery_firstname' => $delivery->firstname,
            'delivery_lastname' => $delivery->lastname,
            'delivery_address1' => $delivery->address1,
            'delivery_address2' => $delivery->address2,
            'delivery_city' => $delivery->city,
            'delivery_postal_code' => $delivery->postcode,
            'delivery_country' => $delivery->country,
            'delivery_state' => $delivery->id_state ? State::getNameById($delivery->id_state) : '',
            'delivery_phone' => $delivery->phone,
            'delivery_phone_mobile' => $delivery->phone_mobile,
            'delivery_vat_number' => $delivery->vat_number,
            'delivery_other' => $delivery->other,
            'invoice_company' => $invoice->company,
            'invoice_firstname' => $invoice->firstname,
            'invoice_lastname' => $invoice->lastname,
            'invoice_address2' => $invoice->address2,
            'invoice_address1' => $invoice->address1,
            'invoice_city' => $invoice->city,
            'invoice_postal_code' => $invoice->postcode,
            'invoice_country' => $invoice->country,
            'invoice_state' => $invoice->id_state ? State::getNameById($invoice->id_state) : '',
            'invoice_phone' => $invoice->phone,
            'invoice_phone_mobile' => $invoice->phone_mobile,
            'invoice_vat_number' => $invoice->vat_number,
            'invoice_other' => $invoice->other,
            'order_name' => sprintf('%06d', $this->order->id),
            'shop_name' => Configuration::get('PS_SHOP_NAME'),
            'date' => $order_date_text,
            'carrier' => (($carrier->name == '0') ? Configuration::get('PS_SHOP_NAME') : $carrier->name),
            'payment' => Tools::substr((!empty($aliasFormasPago[$this->order->module]) ? $aliasFormasPago[$this->order->module] : $this->order->payment), 0, 32),
            'items' => $items_table,
            'miniItems' => $miniItems,
            'miniItemsTexto' => $miniItemsTexto,
            'total_paid' => Tools::displayPrice($this->order->total_paid, $currency),
            'total_products' => Tools::displayPrice($this->order->getTotalProductsWithTaxes(), $currency),
            'total_discounts' => Tools::displayPrice($this->order->total_discounts, $currency),
            'total_shipping' => Tools::displayPrice($this->order->total_shipping, $currency),
            'total_wrapping' => Tools::displayPrice($this->order->total_wrapping, $currency),
            'currency' => $currency->sign,
            'message' => $message,
            'shop_url' => $this->shop->getBaseURL(true),
            'versionPS' => (version_compare(_PS_VERSION_, '1.7.0.0 ', '>=') ? 17 : 16),
            'order_id' => $this->order->id,
            'order_reference' => $this->order->reference,
            'gift_message' => $this->order->gift_message
        );

        $this->smarty->assign($template_vars);

        $html = $this->smarty->fetch($this->getTemplate($this->nombrePlantilla));
        if($this->soloTexto) {
            $html = mb_convert_encoding(strip_tags(preg_replace(array('/<!--(.|\s)*?-->\n/', '/€/'), array('', 'E'), html_entity_decode(html_entity_decode($html)))), 'cp850');
        }

        return $html;
    }

    /**
     * Returns the template filename when using bulk rendering
     * @return string filename
     */
    public function getBulkFilename() {
        return 'newOrder.pdf';
    }

    /**
     * Returns the template filename
     * @return string filename
     */
    public function getFilename() {
        return Configuration::get('PS_DELIVERY_PREFIX', Context::getContext()->language->id, null, $this->order->id_shop) . sprintf('%06d', $this->order->invoice_number) . '.pdf';
    }

    public function getTemplate($template_name) {
        $template = false;

        $default_template = _PS_MODULE_DIR_.'imaximprimepedidosservidor/pdf/'.$template_name.'.tpl';

        if (file_exists($default_template)) {
            $template = $default_template;
        }

        return $template;
    }

    public function getHeader() {        
        return '';
    }

    public function getFooter() {
        return '';
    }

    public static function getFormatedAddress(Address $address, $line_sep, $fields_style = array()) {
        return AddressFormat::generateAddress($address, array('avoid' => array()), $line_sep, ' ', $fields_style);
    }

    public function getPagination() { 
		return $this->smarty->fetch(parent::getTemplate('pagination'));
	}
}
