<?php

class HTMLTemplateEtiquetaProducto extends HTMLTemplate {
    private $idPedido, $idProducto, $idCombinacion;

    public function __construct($datos, $smarty) {
        $this->idPedido = $datos->idPedido;
        $this->idProducto = $datos->idProducto;
        $this->idCombinacion = $datos->idCombinacion;
        $this->smarty = $smarty;
    }
    
    protected function asignarVariables() {
        $barcode = new Picqer\Barcode\BarcodeGeneratorPNG();
        $referenciaPedido = Db::getInstance()->getValue('SELECT `referencia` FROM `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . 'altaCompras` WHERE `id` = ' . (int) $this->idPedido);
        $datos = Db::getInstance()->getRow('SELECT `ref_fabrica`, `ean`, `referencia` FROM `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . 'altaComprasDetalle` WHERE `id_product` = ' . (int) $this->idProducto .' AND `id_product_attribute` = ' . (int) $this->idCombinacion .' AND `idAlta` = ' . (int) $this->idPedido);
        $ean = '';
        if(!empty($datos['ean'])){
            $ean = $datos['ean'];
        }
        elseif($this->idCombinacion){
            $combinacion = new Combination($this->idCombinacion);
            $ean = $combinacion->ean13;
        }
        else{
            $producto = new Product($this->idProducto);
            $ean = $producto->ean13;
        }
        $referencia = '';
        if(!empty($datos['referencia'])){
            $referencia = $datos['referencia'];
        }
        elseif($this->idCombinacion){
            $combinacion = new Combination($this->idCombinacion);
            $referencia = $combinacion->reference;
        }
        else{
            $producto = new Product($this->idProducto);
            $referencia = $producto->reference;
        }
        $nombreProducto = Product::getProductName($this->idProducto, $this->idCombinacion);
        if($ean) {
            $etiqueta = $barcode->getBarcode($ean, $barcode::TYPE_CODE_128, 3, 20, [0, 0, 0]);
        }
        else {
            $etiqueta = '';
        }
        if(!empty($datos)) {
            $refFabrica = $datos['ref_fabrica'];
        }
        else {
            $refFabrica = '';
        }
        
        $this->smarty->assign(['nombreProducto'=>$nombreProducto, 
                               'idProducto' => $this->idProducto, 
                               'refFabrica' => substr($refFabrica, 0, 12), 
                               'referenciaPedido' => substr($referenciaPedido, 0, 9), 
                               'barcodeSrc' => '@'.base64_encode($etiqueta),
                               'referencia' => substr($referencia, 6, 5),
                               'ean' => $ean,
                             ]);
    }

    public function getContent() {
        $this->asignarVariables();
        
        $html = $this->smarty->fetch($this->getTemplate('etiqueta_producto'));
        return $html;
    }
    
    
    public function getHeader() {
        return '';
    }
    
    public function getFooter() {
        return '';
    }

    /**
     * Returns the template filename when using bulk rendering
     * @return string filename
     */
    public function getBulkFilename() {
        return 'etiqueta_producto.pdf';
    }

    /**
     * Returns the template filename
     * @return string filename
     */
    public function getFilename() {
        return 'etiqueta_producto.pdf';
    }

    public function getTemplate($template_name) {
        $template = false;
        $default_template = _PS_MODULE_DIR_.'imaximprimepedidosservidor/pdf/'.$template_name.'.tpl';

        if (file_exists($default_template)) {
            $template = $default_template;
        }

        return $template;
    }
    
    public function getPagination() { 
		return '';
	}
}