<?php

class HTMLTemplateEtiqueta extends HTMLTemplate {

    public $order, $nombrePlantilla, $numBultos;

    public function __construct($datos, $smarty) {
        $this->order = new Order($datos->idPedido);
        $this->nombrePlantilla = $datos->plantilla;
        $this->smarty = $smarty;
        $this->shop = new Shop((int)$this->order->id_shop);
        $this->numBultos = (!empty($datos->numBultos) ? $datos->numBultos : 0);
    }
    
    protected function asignarVariables() {
        $this->assignCommonHeaderData();

        $direccionRemitente = new stdClass();
        $direccionRemitente->name = Configuration::get('PS_SHOP_NAME');
        $direccionRemitente->address1 = Configuration::get('PS_SHOP_ADDR1');
        $direccionRemitente->address2 = Configuration::get('PS_SHOP_ADDR2');
        $direccionRemitente->postcode = Configuration::get('PS_SHOP_CODE');
        $direccionRemitente->city = Configuration::get('PS_SHOP_CITY');
        $direccionRemitente->phone = Configuration::get('PS_SHOP_PHONE');
        $direccionRemitente->email = Configuration::get('PS_SHOP_EMAIL');
        $direccionRemitente->state = State::getNameById(Configuration::get('PS_SHOP_STATE_ID'));
        $direccionRemitente->country = Country::getNameById(Context::getContext()->language->id, Configuration::get('PS_SHOP_COUNTRY_ID'));

        $customer = new Customer($this->order->id_customer);
        $direccionDestinatario = new Address((int) $this->order->id_address_delivery);
        $direccionDestinatario->country = Country::getNameById(Context::getContext()->language->id, $direccionDestinatario->id_country);
        $direccionDestinatario->state = State::getNameById($direccionDestinatario->id_state);
        $direccionDestinatario->email = $customer->email;
        
        $observaciones = $this->order->getFirstMessage();
        
        $cantidadProductos = 0;
        $productos = $this->order->getProducts();
        $customized_datas = Product::getAllCustomizedDatas((int) $this->order->id_cart);
        Product::addCustomizationPrice($productos, $customized_datas);
        foreach($productos as &$producto) {
            $cantidadProductos += $producto['product_quantity'];
            
            $customization_text = '';
            if (isset($customized_datas[$producto['product_id']][$producto['product_attribute_id']])) {

                foreach ($customized_datas[$producto['product_id']][$producto['product_attribute_id']] as $customizationTemp) {
                    foreach($customizationTemp as $customization) {
                        if (isset($customization['datas'][_CUSTOMIZE_TEXTFIELD_])) {
                            foreach ($customization['datas'][_CUSTOMIZE_TEXTFIELD_] as $text) {
                                $customization_text .= $text['name'] . ': ' . $text['value'] . '<br />';
                            }
                        }

                        if (isset($customization['datas'][_CUSTOMIZE_FILE_])) {
                            $customization_text .= count($customization['datas'][_CUSTOMIZE_FILE_]) . ' ' . $this->l('image(s)') . '<br />';
                        }

                        $customization_text .= '---<br />';
                    }
                }

                $customization_text = rtrim($customization_text, '---<br />');
            }
            
            $producto['customization'] = $customization_text;
        }
        
        $barcode = new Picqer\Barcode\BarcodeGeneratorPNG();
        $carrier = new Carrier($this->order->id_carrier);
        $order_carrier = new OrderCarrier($this->getIdOrderCarrier($this->order));
        $this->smarty->assign(array(
            'direccionRemitente' => $direccionRemitente,
            'direccionDestinatario' => $direccionDestinatario,
            'observaciones' => $observaciones,
            'carrier' => $carrier,
            'fecha' => date('d/m/Y H:i:s', strtotime($this->order->date_add)),
            'productos' => $productos,
            'total' => $this->order->total_paid_tax_incl,
            'estado' => $this->order->getCurrentOrderState(),
            'idLang' => Configuration::getGlobalValue('PS_LANG_DEFAULT'),
            'moneda' => $this->order->id_currency,
            'idPedido' => $this->order->id,
            'referenciaPedido' => $this->order->reference,
            'seguimiento' => $order_carrier->tracking_number,
            'cantidadProductos' => $cantidadProductos,
            'pedido' => $this->order,
            'barcodeSrc' =>  '@'.base64_encode($barcode->getBarcode($this->order->id, $barcode::TYPE_CODE_128, 3, 80, [0, 0, 0])),
            'bultos' => $this->numBultos,
            'bultoActual' => 1
        ));
    }

    public function getContent() {
        $this->asignarVariables();
        
        $html = $this->smarty->fetch($this->getTemplate($this->nombrePlantilla));
        for($x=2;$x<=$this->numBultos;$x++) {
            $this->smarty->assign(array('bultoActual' => $x));
            $html .= '<br pagebreak="true"/>'.$this->smarty->fetch($this->getTemplate($this->nombrePlantilla));
        }
        
        return $html;
    }
    
    /**
     * Devuelve el id del order_carrier.
     * @param Order $pedido
     * @return int
     */
    private function getIdOrderCarrier($pedido) {
        if (version_compare(_PS_VERSION_, '1.5.5.0 ', '>=')) {
            $id = $pedido->getIdOrderCarrier();
        }
        else {
            $id = (int) Db::getInstance()->getValue('
				SELECT `id_order_carrier`
				FROM `' . _DB_PREFIX_ . 'order_carrier`
				WHERE `id_order` = ' . (int) $pedido->id);
        }

        return $id;
    }
    
    public function getHeader() {
        return '';
    }
    
    public function getFooter() {
        return '';
    }

    /**
     * Returns the template filename when using bulk rendering
     * @return string filename
     */
    public function getBulkFilename() {
        return 'etiqueta.pdf';
    }

    /**
     * Returns the template filename
     * @return string filename
     */
    public function getFilename() {
        return Configuration::get('PS_DELIVERY_PREFIX', Context::getContext()->language->id, null, $this->order->id_shop) . sprintf('%06d', $this->order->invoice_number) . '.pdf';
    }

    public function getTemplate($template_name) {
        $template = false;
        $default_template = _PS_MODULE_DIR_.'imaximprimepedidosservidor/pdf/'.$template_name.'.tpl';

        if (file_exists($default_template)) {
            $template = $default_template;
        }

        return $template;
    }
    
    public function getPagination() { 
		return $this->smarty->fetch(parent::getTemplate('pagination'));
	}
}